/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.JFXPopup;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.stage.Window;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.GameItem;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class GameListPopupMenu
extends StackPane {
    private final JFXListView<GameItem> listView = new JFXListView();
    private final BooleanBinding isEmpty = Bindings.isEmpty((ObservableList)this.listView.getItems());

    public GameListPopupMenu() {
        this.setMaxHeight(365.0);
        this.getStyleClass().add((Object)"popup-menu-content");
        this.listView.setCellFactory(Cell::new);
        this.listView.setFixedCellSize(60.0);
        this.listView.setPrefWidth(300.0);
        this.listView.prefHeightProperty().bind((ObservableValue)Bindings.size(this.getItems()).multiply(60).add(2));
        Label placeholder = new Label(I18n.i18n("version.empty"));
        placeholder.setStyle("-fx-padding: 10px; -fx-text-fill: -monet-on-surface-variant; -fx-font-style: italic;");
        FXUtils.onChangeAndOperate(this.isEmpty, empty -> this.getChildren().setAll((Object[])new Node[]{empty != false ? placeholder : this.listView}));
    }

    public ObservableList<GameItem> getItems() {
        return this.listView.getItems();
    }

    private static final class Cell
    extends ListCell<GameItem> {
        private final Region graphic;
        private final ImageView imageView;
        private final TwoLineListItem content;
        private final StringProperty tag = new SimpleStringProperty();

        public Cell(ListView<GameItem> listView) {
            this.setPadding(Insets.EMPTY);
            HBox root = new HBox();
            root.setSpacing(8.0);
            root.setAlignment(Pos.CENTER_LEFT);
            StackPane imageViewContainer = new StackPane();
            FXUtils.setLimitWidth((Region)imageViewContainer, 32.0);
            FXUtils.setLimitHeight((Region)imageViewContainer, 32.0);
            this.imageView = new ImageView();
            FXUtils.limitSize(this.imageView, 32.0, 32.0);
            imageViewContainer.getChildren().setAll((Object[])new Node[]{this.imageView});
            this.content = new TwoLineListItem();
            FXUtils.onChangeAndOperate(this.tag, tag -> {
                this.content.getTags().clear();
                if (StringUtils.isNotBlank(tag)) {
                    this.content.addTag((String)tag);
                }
            });
            BorderPane.setAlignment((Node)this.content, (Pos)Pos.CENTER);
            root.getChildren().setAll((Object[])new Node[]{this.imageView, this.content});
            StackPane pane = new StackPane();
            pane.getChildren().setAll((Object[])new Node[]{root});
            pane.getStyleClass().add((Object)"menu-container");
            root.setMouseTransparent(true);
            RipplerContainer ripplerContainer = new RipplerContainer((Node)pane);
            FXUtils.onClicked((Node)ripplerContainer, () -> {
                GameItem item = (GameItem)this.getItem();
                if (item != null) {
                    item.getProfile().setSelectedVersion(item.getId());
                    Window patt4416$temp = this.getScene().getWindow();
                    if (patt4416$temp instanceof JFXPopup) {
                        JFXPopup popup = (JFXPopup)patt4416$temp;
                        popup.hide();
                    }
                }
            });
            this.graphic = ripplerContainer;
            ripplerContainer.maxWidthProperty().bind((ObservableValue)listView.widthProperty().subtract(5));
        }

        protected void updateItem(GameItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.imageView.imageProperty().unbind();
            this.content.titleProperty().unbind();
            this.content.subtitleProperty().unbind();
            this.tag.unbind();
            if (empty || item == null) {
                this.setGraphic(null);
            } else {
                this.setGraphic((Node)this.graphic);
                this.imageView.imageProperty().bind(item.imageProperty());
                this.content.titleProperty().bind((ObservableValue)item.titleProperty());
                this.content.subtitleProperty().bind((ObservableValue)item.subtitleProperty());
                this.tag.bind((ObservableValue)item.tagProperty());
            }
        }
    }
}

