/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public final class SimpleMultimap<K, V, M extends Collection<V>> {
    private final Map<K, M> map;
    private final Supplier<M> valuer;

    public SimpleMultimap(Supplier<Map<K, M>> mapper, Supplier<M> valuer) {
        this.map = mapper.get();
        this.valuer = valuer;
    }

    public int size() {
        return this.values().size();
    }

    public Set<K> keys() {
        return this.map.keySet();
    }

    public Collection<V> values() {
        Collection res = (Collection)this.valuer.get();
        for (Map.Entry<K, M> entry : this.map.entrySet()) {
            res.addAll((Collection)entry.getValue());
        }
        return res;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key) && !((Collection)this.map.get(key)).isEmpty();
    }

    public M get(K key) {
        return (M)this.map.computeIfAbsent(key, any -> (Collection)this.valuer.get());
    }

    public void put(K key, V value) {
        M set = this.get(key);
        set.add(value);
    }

    public void putAll(K key, Collection<? extends V> value) {
        M set = this.get(key);
        set.addAll(value);
    }

    public M removeKey(K key) {
        return (M)((Collection)this.map.remove(key));
    }

    public boolean removeValue(V value) {
        boolean flag = false;
        for (Collection c : this.map.values()) {
            flag |= c.remove(value);
        }
        return flag;
    }

    public boolean removeValue(K key, V value) {
        return this.get(key).remove(value);
    }

    public void clear() {
        this.map.clear();
    }

    public void clear(K key) {
        if (this.map.containsKey(key)) {
            ((Collection)this.map.get(key)).clear();
        } else {
            this.map.put(key, (Collection)this.valuer.get());
        }
    }
}

