/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.terracotta.provider;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.terracotta.TerracottaNative;
import org.jackhuang.hmcl.terracotta.provider.ITerracottaProvider;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jetbrains.annotations.Nullable;

public final class MacOSProvider
implements ITerracottaProvider {
    public final TerracottaNative installer;
    public final TerracottaNative binary;

    public MacOSProvider(TerracottaNative installer, TerracottaNative binary) {
        this.installer = installer;
        this.binary = binary;
    }

    @Override
    public ITerracottaProvider.Status status() throws IOException {
        assert (this.binary != null);
        if (!Files.exists(Path.of("/Applications/terracotta.app", new String[0]), new LinkOption[0])) {
            return ITerracottaProvider.Status.NOT_EXIST;
        }
        return this.binary.status();
    }

    @Override
    public Task<?> install(ITerracottaProvider.Context context, @Nullable TarFileTree tree) throws IOException {
        assert (this.installer != null && this.binary != null);
        Task installerTask = this.installer.install(context, tree);
        Task<?> binaryTask = this.binary.install(context, tree);
        context.bindProgress((ObservableValue<? extends Number>)installerTask.progressProperty().add((ObservableNumberValue)binaryTask.progressProperty()).multiply(0.4));
        return Task.allOf(installerTask.thenComposeAsync(() -> {
            ManagedProcess process = new ManagedProcess(new ProcessBuilder("osascript", "-e", String.format("do shell script \"installer -pkg %s -target /\" with prompt \"%s\" with administrator privileges", this.installer.getPath(), I18n.i18n("terracotta.sudo_installing"))));
            process.pumpInputStream(SystemUtils::onLogLine);
            process.pumpErrorStream(SystemUtils::onLogLine);
            return Task.fromCompletableFuture(process.getProcess().onExit());
        }), binaryTask.thenRunAsync(() -> Files.setPosixFilePermissions(this.binary.getPath(), Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE))));
    }

    @Override
    public List<String> ofCommandLine(Path path) {
        assert (this.binary != null);
        return List.of(this.binary.getPath().toString(), "--hmcl", path.toString());
    }
}

