/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.utils;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private long count;
    private final long maxCount;
    private final boolean propagateClose;
    private long mark;

    public BoundedInputStream(InputStream in, long maxCount) {
        super(in);
        this.maxCount = maxCount;
        this.propagateClose = false;
    }

    public BoundedInputStream(InputStream in, long maxCount, boolean propagateClose) {
        super(in);
        this.maxCount = maxCount;
        this.propagateClose = propagateClose;
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            this.in.close();
        }
    }

    public long getBytesRead() {
        return this.count;
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public long getBytesRemaining() {
        return this.maxCount - this.count;
    }

    @Override
    public int read() throws IOException {
        if (this.count < this.maxCount) {
            ++this.count;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        long bytesRemaining = this.getBytesRemaining();
        if (bytesRemaining == 0L) {
            return -1;
        }
        int bytesToRead = (int)Math.min((long)len, bytesRemaining);
        int bytesRead = this.in.read(b, off, bytesToRead);
        if (bytesRead >= 0) {
            this.count += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesToSkip = Math.min(this.getBytesRemaining(), n);
        long bytesSkipped = this.in.skip(bytesToSkip);
        this.count += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.count;
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.count = this.mark;
    }
}

