/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public interface DownloadProvider {
    public String getVersionListURL();

    public String getAssetBaseURL();

    default public List<URI> getAssetObjectCandidates(String assetObjectLocation) {
        return List.of(NetworkUtils.toURI(this.getAssetBaseURL() + assetObjectLocation));
    }

    public String injectURL(String var1);

    default public List<URI> injectURLWithCandidates(String baseURL) {
        return List.of(NetworkUtils.toURI(this.injectURL(baseURL)));
    }

    default public List<URI> injectURLsWithCandidates(List<String> urls) {
        return urls.stream().flatMap(url -> this.injectURLWithCandidates((String)url).stream()).collect(Collectors.toList());
    }

    public VersionList<?> getVersionListById(String var1);

    public int getConcurrency();
}

