/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.OSRestriction;
import org.jackhuang.hmcl.game.RuledArgument;
import org.jackhuang.hmcl.game.StringArgument;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jetbrains.annotations.Nullable;

@Immutable
public final class Arguments {
    @SerializedName(value="game")
    private final List<Argument> game;
    @SerializedName(value="jvm")
    private final List<Argument> jvm;
    public static final List<Argument> DEFAULT_JVM_ARGUMENTS;
    public static final List<Argument> DEFAULT_GAME_ARGUMENTS;

    public Arguments() {
        this(null, null);
    }

    public Arguments(List<Argument> game, List<Argument> jvm) {
        this.game = game;
        this.jvm = jvm;
    }

    @Nullable
    public List<Argument> getGame() {
        return this.game == null ? null : Collections.unmodifiableList(this.game);
    }

    public Arguments withGame(List<Argument> game) {
        return new Arguments(game, this.jvm);
    }

    @Nullable
    public List<Argument> getJvm() {
        return this.jvm == null ? null : Collections.unmodifiableList(this.jvm);
    }

    public Arguments withJvm(List<Argument> jvm) {
        return new Arguments(this.game, jvm);
    }

    public Arguments addGameArguments(String ... gameArguments) {
        return this.addGameArguments(Arrays.asList(gameArguments));
    }

    public Arguments addGameArguments(List<String> gameArguments) {
        List list = gameArguments.stream().map(StringArgument::new).collect(Collectors.toList());
        return new Arguments(Lang.merge(this.getGame(), list), this.getJvm());
    }

    public Arguments addJVMArguments(String ... jvmArguments) {
        return this.addJVMArguments(Arrays.asList(jvmArguments));
    }

    public Arguments addJVMArguments(List<String> jvmArguments) {
        return this.addJVMArgumentsDirect(jvmArguments.stream().map(StringArgument::new).collect(Collectors.toList()));
    }

    public Arguments addJVMArgumentsDirect(List<Argument> jvmArguments) {
        return new Arguments(this.getGame(), Lang.merge(this.getJvm(), jvmArguments));
    }

    public static Arguments merge(Arguments a, Arguments b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new Arguments(a.game == null && b.game == null ? null : Lang.merge(a.game, b.game), a.jvm == null && b.jvm == null ? null : Lang.merge(a.jvm, b.jvm));
    }

    public static List<String> parseStringArguments(List<String> arguments, Map<String, String> keys) {
        return arguments.stream().filter(Objects::nonNull).flatMap(str -> new StringArgument((String)str).toString(keys, Collections.emptyMap()).stream()).collect(Collectors.toList());
    }

    public static List<String> parseArguments(List<Argument> arguments, Map<String, String> keys) {
        return Arguments.parseArguments(arguments, keys, Collections.emptyMap());
    }

    public static List<String> parseArguments(List<Argument> arguments, Map<String, String> keys, Map<String, Boolean> features) {
        return arguments.stream().filter(Objects::nonNull).flatMap(arg -> arg.toString(keys, features).stream()).collect(Collectors.toList());
    }

    static {
        ArrayList<Argument> jvm = new ArrayList<Argument>(8);
        jvm.add(new RuledArgument(Collections.singletonList(new CompatibilityRule(CompatibilityRule.Action.ALLOW, new OSRestriction(OperatingSystem.WINDOWS))), Collections.singletonList("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump")));
        jvm.add(new RuledArgument(Collections.singletonList(new CompatibilityRule(CompatibilityRule.Action.ALLOW, new OSRestriction(OperatingSystem.WINDOWS, "^10\\."))), Arrays.asList("-Dos.name=Windows 10", "-Dos.version=10.0")));
        jvm.add(new StringArgument("-Djava.library.path=${natives_directory}"));
        jvm.add(new StringArgument("-Dminecraft.launcher.brand=${launcher_name}"));
        jvm.add(new StringArgument("-Dminecraft.launcher.version=${launcher_version}"));
        jvm.add(new StringArgument("-cp"));
        jvm.add(new StringArgument("${classpath}"));
        DEFAULT_JVM_ARGUMENTS = Collections.unmodifiableList(jvm);
        ArrayList<RuledArgument> game = new ArrayList<RuledArgument>(1);
        game.add(new RuledArgument(Collections.singletonList(new CompatibilityRule(CompatibilityRule.Action.ALLOW, null, Collections.singletonMap("has_custom_resolution", true))), Arrays.asList("--width", "${resolution_width}", "--height", "${resolution_height}")));
        DEFAULT_GAME_ARGUMENTS = Collections.unmodifiableList(game);
    }
}

