/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.yggdrasil;

import com.google.gson.Gson;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.yggdrasil.GameProfile;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

@Immutable
public class YggdrasilSession {
    private final String clientToken;
    private final String accessToken;
    private final GameProfile selectedProfile;
    private final List<GameProfile> availableProfiles;
    @Nullable
    private final Map<String, String> userProperties;
    private static final Gson GSON_PROPERTIES = new Gson();

    public YggdrasilSession(String clientToken, String accessToken, GameProfile selectedProfile, List<GameProfile> availableProfiles, Map<String, String> userProperties) {
        this.clientToken = clientToken;
        this.accessToken = accessToken;
        this.selectedProfile = selectedProfile;
        this.availableProfiles = availableProfiles;
        this.userProperties = userProperties;
        if (accessToken != null) {
            Logger.registerAccessToken(accessToken);
        }
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public GameProfile getSelectedProfile() {
        return this.selectedProfile;
    }

    public List<GameProfile> getAvailableProfiles() {
        return this.availableProfiles;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public static YggdrasilSession fromStorage(Map<?, ?> storage) {
        Objects.requireNonNull(storage);
        UUID uuid = Lang.tryCast(storage.get("uuid"), String.class).map(UUIDTypeAdapter::fromString).orElseThrow(() -> new IllegalArgumentException("uuid is missing"));
        String name = Lang.tryCast(storage.get("displayName"), String.class).orElseThrow(() -> new IllegalArgumentException("displayName is missing"));
        String clientToken = Lang.tryCast(storage.get("clientToken"), String.class).orElseThrow(() -> new IllegalArgumentException("clientToken is missing"));
        String accessToken = Lang.tryCast(storage.get("accessToken"), String.class).orElseThrow(() -> new IllegalArgumentException("accessToken is missing"));
        Map userProperties = Lang.tryCast(storage.get("userProperties"), Map.class).orElse(null);
        return new YggdrasilSession(clientToken, accessToken, new GameProfile(uuid, name), null, userProperties);
    }

    public Map<Object, Object> toStorage() {
        if (this.selectedProfile == null) {
            throw new IllegalStateException("No character is selected");
        }
        return Lang.mapOf(Pair.pair("clientToken", this.clientToken), Pair.pair("accessToken", this.accessToken), Pair.pair("uuid", UUIDTypeAdapter.fromUUID(this.selectedProfile.getId())), Pair.pair("displayName", this.selectedProfile.getName()), Pair.pair("userProperties", this.userProperties));
    }

    public AuthInfo toAuthInfo() {
        if (this.selectedProfile == null) {
            throw new IllegalStateException("No character is selected");
        }
        return new AuthInfo(this.selectedProfile.getName(), this.selectedProfile.getId(), this.accessToken, "msa", Optional.ofNullable(this.userProperties).map(properties -> properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singleton((String)e.getValue())))).map(GSON_PROPERTIES::toJson).orElse("{}"));
    }
}

