/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXButton;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;

public abstract class ToolbarListPageSkin<T extends ListPageBase<? extends Node>>
extends SkinBase<T> {
    public ToolbarListPageSkin(T skinnable) {
        super(skinnable);
        SpinnerPane spinnerPane = new SpinnerPane();
        spinnerPane.loadingProperty().bind((ObservableValue)((ListPageBase)skinnable).loadingProperty());
        spinnerPane.failedReasonProperty().bind((ObservableValue)((ListPageBase)skinnable).failedReasonProperty());
        spinnerPane.onFailedActionProperty().bind(((ListPageBase)skinnable).onFailedActionProperty());
        spinnerPane.getStyleClass().add((Object)"large-spinner-pane");
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        StackPane.setMargin((Node)root, (Insets)new Insets(10.0));
        List<Node> toolbarButtons = this.initializeToolbar(skinnable);
        if (!toolbarButtons.isEmpty()) {
            HBox toolbar = new HBox();
            toolbar.setAlignment(Pos.CENTER_LEFT);
            toolbar.setPickOnBounds(false);
            toolbar.getChildren().setAll(toolbarButtons);
            root.getContent().add((Object)toolbar);
        }
        ScrollPane scrollPane = new ScrollPane();
        ComponentList.setVgrow((Node)scrollPane, Priority.ALWAYS);
        scrollPane.setFitToWidth(true);
        VBox content = new VBox();
        Bindings.bindContent((List)content.getChildren(), ((ListPageBase)skinnable).itemsProperty());
        scrollPane.setContent((Node)content);
        FXUtils.smoothScrolling(scrollPane);
        root.getContent().add((Object)scrollPane);
        spinnerPane.setContent((Node)root);
        this.getChildren().setAll((Object[])new Node[]{spinnerPane});
    }

    public static Node wrap(Node node) {
        StackPane stackPane = new StackPane();
        stackPane.setPadding(new Insets(0.0, 5.0, 0.0, 2.0));
        stackPane.getChildren().setAll((Object[])new Node[]{node});
        return stackPane;
    }

    public static JFXButton createToolbarButton2(String text, SVG svg, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-tool-bar-button");
        ret.setGraphic(ToolbarListPageSkin.wrap(svg.createIcon()));
        ret.setText(text);
        ret.setOnAction(e -> {
            onClick.run();
            FXUtils.clearFocus((Node)ret);
        });
        return ret;
    }

    public static JFXButton createDecoratorButton(String tooltip, SVG svg, Runnable onClick) {
        JFXButton ret = new JFXButton();
        ret.getStyleClass().add((Object)"jfx-decorator-button");
        ret.setGraphic(ToolbarListPageSkin.wrap(svg.createIcon()));
        FXUtils.installFastTooltip((Node)ret, tooltip);
        ret.setOnAction(e -> onClick.run());
        return ret;
    }

    protected abstract List<Node> initializeToolbar(T var1);
}

