/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.controls;

import com.jfoenix.skins.JFXTextFieldSkin;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableBooleanProperty;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.BooleanConverter;
import javafx.css.converter.PaintConverter;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.jackhuang.hmcl.ui.FXUtils;

public class JFXTextField
extends TextField {
    private static final String DEFAULT_STYLE_CLASS = "jfx-text-field";
    private ReadOnlyObjectWrapper<ValidatorBase> activeValidator = new ReadOnlyObjectWrapper();
    private ObservableList<ValidatorBase> validators = FXCollections.observableArrayList();
    private StyleableBooleanProperty labelFloat = new SimpleStyleableBooleanProperty(StyleableProperties.LABEL_FLOAT, (Object)this, "lableFloat", false);
    private StyleableObjectProperty<Paint> unFocusColor = new SimpleStyleableObjectProperty(StyleableProperties.UNFOCUS_COLOR, (Object)this, "unFocusColor", (Object)Color.rgb((int)77, (int)77, (int)77));
    private StyleableObjectProperty<Paint> focusColor = new SimpleStyleableObjectProperty(StyleableProperties.FOCUS_COLOR, (Object)this, "focusColor", (Object)Color.valueOf((String)"#4059A9"));
    private StyleableBooleanProperty disableAnimation = new SimpleStyleableBooleanProperty(StyleableProperties.DISABLE_ANIMATION, (Object)this, "disableAnimation", false);
    private List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

    public JFXTextField() {
        this.initialize();
    }

    public JFXTextField(String text) {
        super(text);
        this.initialize();
    }

    protected Skin<?> createDefaultSkin() {
        return new JFXTextFieldSkin(this);
    }

    private void initialize() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        if ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"))) {
            this.setStyle("-fx-skin: \"com.jfoenix.android.skins.JFXTextFieldSkinAndroid\";");
        }
        FXUtils.useJFXContextMenu((TextInputControl)this);
    }

    public ValidatorBase getActiveValidator() {
        return this.activeValidator == null ? null : (ValidatorBase)((Object)this.activeValidator.get());
    }

    public ReadOnlyObjectProperty<ValidatorBase> activeValidatorProperty() {
        return this.activeValidator.getReadOnlyProperty();
    }

    public ObservableList<ValidatorBase> getValidators() {
        return this.validators;
    }

    public void setValidators(ValidatorBase ... validators) {
        this.validators.addAll((Object[])validators);
    }

    public boolean validate() {
        for (ValidatorBase validator : this.validators) {
            if (validator.getSrcControl() == null) {
                validator.setSrcControl((Node)this);
            }
            validator.validate();
            if (!validator.getHasErrors()) continue;
            this.activeValidator.set((Object)validator);
            return false;
        }
        this.activeValidator.set(null);
        return true;
    }

    public void resetValidation() {
        this.pseudoClassStateChanged(ValidatorBase.PSEUDO_CLASS_ERROR, false);
        this.activeValidator.set(null);
    }

    public final StyleableBooleanProperty labelFloatProperty() {
        return this.labelFloat;
    }

    public final boolean isLabelFloat() {
        return this.labelFloatProperty().get();
    }

    public final void setLabelFloat(boolean labelFloat) {
        this.labelFloatProperty().set(labelFloat);
    }

    public Paint getUnFocusColor() {
        return this.unFocusColor == null ? Color.rgb((int)77, (int)77, (int)77) : (Paint)this.unFocusColor.get();
    }

    public StyleableObjectProperty<Paint> unFocusColorProperty() {
        return this.unFocusColor;
    }

    public void setUnFocusColor(Paint color) {
        this.unFocusColor.set((Object)color);
    }

    public Paint getFocusColor() {
        return this.focusColor == null ? Color.valueOf((String)"#4059A9") : (Paint)this.focusColor.get();
    }

    public StyleableObjectProperty<Paint> focusColorProperty() {
        return this.focusColor;
    }

    public void setFocusColor(Paint color) {
        this.focusColor.set((Object)color);
    }

    public final StyleableBooleanProperty disableAnimationProperty() {
        return this.disableAnimation;
    }

    public final Boolean isDisableAnimation() {
        return this.disableAnimation != null && this.disableAnimationProperty().get();
    }

    public final void setDisableAnimation(Boolean disabled) {
        this.disableAnimationProperty().set(disabled.booleanValue());
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        if (this.STYLEABLES == null) {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            styleables.addAll(JFXTextField.getClassCssMetaData());
            styleables.addAll(TextField.getClassCssMetaData());
            this.STYLEABLES = Collections.unmodifiableList(styleables);
        }
        return this.STYLEABLES;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static final class StyleableProperties {
        private static final CssMetaData<JFXTextField, Paint> UNFOCUS_COLOR = new CssMetaData<JFXTextField, Paint>("-jfx-unfocus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#A6A6A6")){

            public boolean isSettable(JFXTextField control) {
                return control.unFocusColor == null || !control.unFocusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXTextField control) {
                return control.unFocusColorProperty();
            }
        };
        private static final CssMetaData<JFXTextField, Paint> FOCUS_COLOR = new CssMetaData<JFXTextField, Paint>("-jfx-focus-color", PaintConverter.getInstance(), (Paint)Color.valueOf((String)"#3f51b5")){

            public boolean isSettable(JFXTextField control) {
                return control.focusColor == null || !control.focusColor.isBound();
            }

            public StyleableProperty<Paint> getStyleableProperty(JFXTextField control) {
                return control.focusColorProperty();
            }
        };
        private static final CssMetaData<JFXTextField, Boolean> LABEL_FLOAT = new CssMetaData<JFXTextField, Boolean>("-jfx-label-float", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXTextField control) {
                return control.labelFloat == null || !control.labelFloat.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTextField control) {
                return control.labelFloatProperty();
            }
        };
        private static final CssMetaData<JFXTextField, Boolean> DISABLE_ANIMATION = new CssMetaData<JFXTextField, Boolean>("-jfx-disable-animation", BooleanConverter.getInstance(), Boolean.valueOf(false)){

            public boolean isSettable(JFXTextField control) {
                return control.disableAnimation == null || !control.disableAnimation.isBound();
            }

            public StyleableBooleanProperty getStyleableProperty(JFXTextField control) {
                return control.disableAnimationProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, UNFOCUS_COLOR, FOCUS_COLOR, LABEL_FLOAT, DISABLE_ANIMATION);
            CHILD_STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

