/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modinfo;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import kala.compress.archivers.zip.ZipArchiveEntry;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.modinfo.ForgeOldModMetadataLst;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.tree.ZipFileTree;

@Immutable
public final class ForgeOldModMetadata {
    @SerializedName(value="modid")
    private final String modId;
    private final String name;
    private final String description;
    private final String author;
    private final String version;
    private final String logoFile;
    private final String mcversion;
    private final String url;
    private final String updateUrl;
    private final String credits;
    private final String[] authorList;
    private final String[] authors;

    public ForgeOldModMetadata() {
        this("", "", "", "", "", "", "", "", "", "", new String[0], new String[0]);
    }

    public ForgeOldModMetadata(String modId, String name, String description, String author, String version, String logoFile, String mcversion, String url, String updateUrl, String credits, String[] authorList, String[] authors) {
        this.modId = modId;
        this.name = name;
        this.description = description;
        this.author = author;
        this.version = version;
        this.logoFile = logoFile;
        this.mcversion = mcversion;
        this.url = url;
        this.updateUrl = updateUrl;
        this.credits = credits;
        this.authorList = authorList;
        this.authors = authors;
    }

    public String getModId() {
        return this.modId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLogoFile() {
        return this.logoFile;
    }

    public String getGameVersion() {
        return this.mcversion;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUpdateUrl() {
        return this.updateUrl;
    }

    public String getCredits() {
        return this.credits;
    }

    public String[] getAuthorList() {
        return this.authorList;
    }

    public String[] getAuthors() {
        return this.authors;
    }

    public static LocalModFile fromFile(ModManager modManager, Path modFile, ZipFileTree tree) throws IOException, JsonParseException {
        List<ForgeOldModMetadata> modList;
        block19: {
            ZipArchiveEntry mcmod = (ZipArchiveEntry)tree.getEntry("mcmod.info");
            if (mcmod == null) {
                throw new IOException("File " + String.valueOf(modFile) + " is not a Forge mod.");
            }
            try (BufferedReader reader = tree.getBufferedReader(mcmod);
                 JsonReader jsonReader = new JsonReader(reader);){
                JsonToken firstToken = jsonReader.peek();
                if (firstToken == JsonToken.BEGIN_ARRAY) {
                    modList = JsonUtils.GSON.fromJson(jsonReader, JsonUtils.listTypeOf(ForgeOldModMetadata.class));
                    break block19;
                }
                if (firstToken == JsonToken.BEGIN_OBJECT) {
                    ForgeOldModMetadataLst list = (ForgeOldModMetadataLst)JsonUtils.GSON.fromJson(jsonReader, (Type)((Object)ForgeOldModMetadataLst.class));
                    if (list == null) {
                        throw new IOException("Mod " + String.valueOf(modFile) + " `mcmod.info` is malformed");
                    }
                    modList = list.modList();
                    break block19;
                }
                throw new JsonParseException("Unexpected first token: " + String.valueOf((Object)firstToken));
            }
        }
        if (modList == null || modList.isEmpty()) {
            throw new IOException("Mod " + String.valueOf(modFile) + " `mcmod.info` is malformed");
        }
        ForgeOldModMetadata metadata = modList.get(0);
        String authors = metadata.getAuthor();
        if (StringUtils.isBlank(authors) && metadata.getAuthors().length > 0) {
            authors = String.join((CharSequence)", ", metadata.getAuthors());
        }
        if (StringUtils.isBlank(authors) && metadata.getAuthorList().length > 0) {
            authors = String.join((CharSequence)", ", metadata.getAuthorList());
        }
        if (StringUtils.isBlank(authors)) {
            authors = metadata.getCredits();
        }
        return new LocalModFile(modManager, modManager.getLocalMod(metadata.getModId(), ModLoaderType.FORGE), modFile, metadata.getName(), new LocalModFile.Description(metadata.getDescription()), authors, metadata.getVersion(), metadata.getGameVersion(), StringUtils.isBlank(metadata.getUrl()) ? metadata.getUpdateUrl() : metadata.url, metadata.getLogoFile());
    }
}

