/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXListView;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.NoPaddingComponent;
import org.jackhuang.hmcl.ui.construct.OptionsList;

public final class OptionsListSkin
extends SkinBase<OptionsList> {
    private final JFXListView<OptionsList.Element> listView = new JFXListView();
    private final ObjectBinding<ContentPaddings> contentPaddings;

    OptionsListSkin(OptionsList control) {
        super((Control)control);
        this.listView.setItems(control.getElements());
        this.listView.setCellFactory(listView1 -> new Cell());
        this.contentPaddings = Bindings.createObjectBinding(() -> {
            Insets padding = control.getContentPadding();
            return padding == null ? ContentPaddings.EMPTY : new ContentPaddings(new Insets(padding.getTop(), padding.getRight(), 0.0, padding.getLeft()), new Insets(0.0, padding.getRight(), padding.getBottom(), padding.getLeft()), new Insets(0.0, padding.getRight(), 0.0, padding.getLeft()));
        }, (Observable[])new Observable[]{control.contentPaddingProperty()});
        this.getChildren().setAll((Object[])new Node[]{this.listView});
    }

    private record ContentPaddings(Insets first, Insets last, Insets middle) {
        static final ContentPaddings EMPTY = new ContentPaddings(Insets.EMPTY, Insets.EMPTY, Insets.EMPTY);
    }

    private final class Cell
    extends ListCell<OptionsList.Element> {
        private static final PseudoClass PSEUDO_CLASS_FIRST = PseudoClass.getPseudoClass((String)"first");
        private static final PseudoClass PSEUDO_CLASS_LAST = PseudoClass.getPseudoClass((String)"last");
        private final InvalidationListener updateStyleListener = o -> this.updateStyle();
        private StackPane wrapper;

        public Cell() {
            FXUtils.limitCellWidth(OptionsListSkin.this.listView, this);
            WeakInvalidationListener weakListener = new WeakInvalidationListener(this.updateStyleListener);
            OptionsListSkin.this.listView.itemsProperty().addListener((o, oldValue, newValue) -> {
                if (oldValue != null) {
                    oldValue.removeListener((InvalidationListener)weakListener);
                }
                if (newValue != null) {
                    newValue.addListener((InvalidationListener)weakListener);
                }
                weakListener.invalidated((Observable)o);
            });
            this.itemProperty().addListener((InvalidationListener)weakListener);
            OptionsListSkin.this.contentPaddings.addListener((InvalidationListener)weakListener);
        }

        protected void updateItem(OptionsList.Element item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setGraphic(null);
            } else if (item instanceof OptionsList.ListElement) {
                OptionsList.ListElement element = (OptionsList.ListElement)item;
                if (this.wrapper == null) {
                    this.wrapper = this.createWrapper();
                } else {
                    this.wrapper.getStyleClass().remove((Object)"no-padding");
                }
                Node node = element.getNode();
                if (node instanceof NoPaddingComponent || node.getProperties().containsKey((Object)"ComponentList.noPadding")) {
                    this.wrapper.getStyleClass().add((Object)"no-padding");
                }
                this.wrapper.getChildren().setAll((Object[])new Node[]{node});
                this.setGraphic((Node)this.wrapper);
            } else {
                this.setGraphic(item.getNode());
            }
            this.updateStyle();
        }

        private StackPane createWrapper() {
            StackPane wrapper = new StackPane();
            wrapper.setAlignment(Pos.CENTER_LEFT);
            wrapper.getStyleClass().add((Object)"options-list-item");
            this.updateStyle();
            return wrapper;
        }

        private void updateStyle() {
            OptionsList.Element item = (OptionsList.Element)this.getItem();
            int index = this.getIndex();
            ObservableList items = this.getListView().getItems();
            if (item == null || index < 0 || index >= items.size()) {
                this.setPadding(Insets.EMPTY);
                return;
            }
            boolean isFirst = index == 0;
            boolean isLast = index == items.size() - 1;
            ContentPaddings paddings = (ContentPaddings)OptionsListSkin.this.contentPaddings.get();
            if (isFirst) {
                this.setPadding(paddings.first);
            } else if (isLast) {
                this.setPadding(paddings.last);
            } else {
                this.setPadding(paddings.middle);
            }
            if (item instanceof OptionsList.ListElement && this.wrapper != null) {
                this.wrapper.pseudoClassStateChanged(PSEUDO_CLASS_FIRST, isFirst || !(items.get(index - 1) instanceof OptionsList.ListElement));
                this.wrapper.pseudoClassStateChanged(PSEUDO_CLASS_LAST, isLast || !(items.get(index + 1) instanceof OptionsList.ListElement));
            }
        }
    }
}

