/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.When;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Skin;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.RipplerContainer;

public class PopupMenu
extends Control {
    private final ObservableList<Node> content = FXCollections.observableArrayList();
    private final BooleanProperty alwaysShowingVBar = new SimpleBooleanProperty();

    public PopupMenu() {
        this.getStyleClass().add((Object)"popup-menu");
    }

    public ObservableList<Node> getContent() {
        return this.content;
    }

    public boolean isAlwaysShowingVBar() {
        return this.alwaysShowingVBar.get();
    }

    public BooleanProperty alwaysShowingVBarProperty() {
        return this.alwaysShowingVBar;
    }

    public void setAlwaysShowingVBar(boolean alwaysShowingVBar) {
        this.alwaysShowingVBar.set(alwaysShowingVBar);
    }

    protected Skin<?> createDefaultSkin() {
        return new PopupMenuSkin();
    }

    public static Node wrapPopupMenuItem(Node node) {
        StackPane pane = new StackPane();
        pane.getChildren().setAll((Object[])new Node[]{node});
        pane.getStyleClass().add((Object)"menu-container");
        node.setMouseTransparent(true);
        return new RipplerContainer((Node)pane);
    }

    private class PopupMenuSkin
    extends SkinBase<PopupMenu> {
        protected PopupMenuSkin() {
            super((Control)PopupMenu.this);
            ScrollPane scrollPane = new ScrollPane();
            scrollPane.setFitToHeight(true);
            scrollPane.setFitToWidth(true);
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.vbarPolicyProperty().bind((ObservableValue)new When((ObservableBooleanValue)PopupMenu.this.alwaysShowingVBar).then((Object)ScrollPane.ScrollBarPolicy.ALWAYS).otherwise((Object)ScrollPane.ScrollBarPolicy.AS_NEEDED));
            VBox content = new VBox();
            content.getStyleClass().add((Object)"popup-menu-content");
            Bindings.bindContent((List)content.getChildren(), PopupMenu.this.getContent());
            scrollPane.setContent((Node)content);
            FXUtils.smoothScrolling(scrollPane);
            this.getChildren().setAll((Object[])new Node[]{scrollPane});
        }
    }
}

