/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.LinePane;
import org.jackhuang.hmcl.ui.construct.LineTextPane;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.i18n.I18n;

public abstract class ModpackPage
extends SpinnerPane
implements WizardPage {
    public static final SettingsMap.Key<Profile> PROFILE = new SettingsMap.Key("PROFILE");
    protected final WizardController controller;
    protected final StringProperty nameProperty;
    protected final StringProperty versionProperty;
    protected final StringProperty authorProperty;
    protected final JFXTextField txtModpackName;
    protected final JFXButton btnInstall;
    protected final JFXButton btnDescription;

    protected ModpackPage(WizardController controller) {
        this.controller = controller;
        VBox borderPane = new VBox();
        borderPane.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)borderPane, 500.0);
        ComponentList componentList = new ComponentList();
        LinePane archiveNamePane = new LinePane();
        archiveNamePane.setTitle(I18n.i18n("archive.file.name"));
        this.txtModpackName = new JFXTextField();
        this.txtModpackName.setPrefWidth(300.0);
        BorderPane.setAlignment((Node)this.txtModpackName, (Pos)Pos.CENTER_RIGHT);
        archiveNamePane.setRight((Node)this.txtModpackName);
        LineTextPane modpackNamePane = new LineTextPane();
        modpackNamePane.setTitle(I18n.i18n("modpack.name"));
        this.nameProperty = modpackNamePane.textProperty();
        LineTextPane versionPane = new LineTextPane();
        versionPane.setTitle(I18n.i18n("archive.version"));
        this.versionProperty = versionPane.textProperty();
        LineTextPane authorPane = new LineTextPane();
        authorPane.setTitle(I18n.i18n("archive.author"));
        this.authorProperty = authorPane.textProperty();
        BorderPane descriptionPane = new BorderPane();
        this.btnDescription = FXUtils.newBorderButton(I18n.i18n("modpack.description"));
        this.btnDescription.setOnAction(e -> this.onDescribe());
        descriptionPane.setLeft((Node)this.btnDescription);
        this.btnInstall = FXUtils.newRaisedButton(I18n.i18n("button.install"));
        this.btnInstall.setOnAction(e -> this.onInstall());
        this.btnInstall.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.txtModpackName.validate(), (Observable[])new Observable[]{this.txtModpackName.textProperty()}));
        descriptionPane.setRight((Node)this.btnInstall);
        componentList.getContent().setAll((Object[])new Node[]{archiveNamePane, modpackNamePane, versionPane, authorPane, descriptionPane});
        borderPane.getChildren().setAll((Object[])new Node[]{componentList});
        this.setContent((Node)borderPane);
    }

    protected abstract void onInstall();

    protected abstract void onDescribe();

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

