/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXTextField;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.LineFileChooserButton;
import org.jackhuang.hmcl.ui.construct.LinePane;
import org.jackhuang.hmcl.ui.construct.LineTextPane;
import org.jackhuang.hmcl.ui.versions.WorldExportPage;
import org.jackhuang.hmcl.util.i18n.I18n;

public class WorldExportPageSkin
extends SkinBase<WorldExportPage> {
    public WorldExportPageSkin(WorldExportPage skinnable) {
        super((Control)skinnable);
        VBox container = new VBox();
        container.setSpacing(16.0);
        container.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)container, 500.0);
        ComponentList list = new ComponentList();
        LineFileChooserButton chooseFileButton = new LineFileChooserButton();
        chooseFileButton.setTitle(I18n.i18n("world.export.location"));
        chooseFileButton.setType(LineFileChooserButton.Type.SAVE_FILE);
        chooseFileButton.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("world"), new String[]{"*.zip"}));
        chooseFileButton.locationProperty().bindBidirectional((Property)skinnable.pathProperty());
        LinePane worldNamePane = new LinePane();
        worldNamePane.setTitle(I18n.i18n("world.name"));
        JFXTextField txtWorldName = new JFXTextField();
        txtWorldName.textProperty().bindBidirectional((Property)skinnable.worldNameProperty());
        txtWorldName.setPrefWidth(300.0);
        worldNamePane.setRight((Node)txtWorldName);
        LineTextPane gameVersionPane = new LineTextPane();
        gameVersionPane.setTitle(I18n.i18n("world.game_version"));
        gameVersionPane.textProperty().bind((ObservableValue)skinnable.gameVersionProperty());
        list.getContent().setAll((Object[])new Node[]{chooseFileButton, worldNamePane, gameVersionPane});
        container.getChildren().setAll((Object[])new Node[]{ComponentList.createComponentListTitle(I18n.i18n("world.export")), list});
        JFXButton btnExport = FXUtils.newRaisedButton(I18n.i18n("button.export"));
        btnExport.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> txtWorldName.getText().isEmpty() || Files.exists(Paths.get(chooseFileButton.getLocation(), new String[0]), new LinkOption[0]), (Observable[])new Observable[]{txtWorldName.textProperty().isEmpty(), chooseFileButton.locationProperty()}));
        btnExport.setOnAction(e -> skinnable.export());
        HBox bottom = new HBox();
        bottom.setAlignment(Pos.CENTER_RIGHT);
        bottom.getChildren().setAll((Object[])new Node[]{btnExport});
        container.getChildren().add((Object)bottom);
        this.getChildren().setAll((Object[])new Node[]{container});
    }
}

