/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import javafx.scene.image.Image;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.ui.FXUtils;

public enum VersionIconType {
    DEFAULT("/assets/img/grass.png"),
    GRASS("/assets/img/grass.png"),
    CHEST("/assets/img/chest.png"),
    CHICKEN("/assets/img/chicken.png"),
    COMMAND("/assets/img/command.png"),
    OPTIFINE("/assets/img/optifine.png"),
    CRAFT_TABLE("/assets/img/craft_table.png"),
    FABRIC("/assets/img/fabric.png"),
    FORGE("/assets/img/forge.png"),
    NEO_FORGE("/assets/img/neoforge.png"),
    FURNACE("/assets/img/furnace.png"),
    QUILT("/assets/img/quilt.png"),
    APRIL_FOOLS("/assets/img/april_fools.png"),
    CLEANROOM("/assets/img/cleanroom.png"),
    LEGACY_FABRIC("/assets/img/legacyfabric.png");

    private final String resourceUrl;

    public static VersionIconType getIconType(ModLoaderType modLoaderType) {
        return switch (modLoaderType) {
            case ModLoaderType.FORGE -> FORGE;
            case ModLoaderType.NEO_FORGED -> NEO_FORGE;
            case ModLoaderType.FABRIC -> FABRIC;
            case ModLoaderType.QUILT -> QUILT;
            case ModLoaderType.LITE_LOADER -> CHICKEN;
            case ModLoaderType.CLEANROOM -> CLEANROOM;
            default -> COMMAND;
        };
    }

    private VersionIconType(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public Image getIcon() {
        return FXUtils.newBuiltinImage(this.resourceUrl);
    }
}

