/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;

public class TwoLineListItem
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "two-line-list-item";
    private final HBox firstLine;
    private HBox secondLine;
    private final Label lblTitle;
    private Label lblSubtitle;
    private final StringProperty title = new StringPropertyBase(){

        public Object getBean() {
            return TwoLineListItem.this;
        }

        public String getName() {
            return "title";
        }

        protected void invalidated() {
            TwoLineListItem.this.lblTitle.setText(this.get());
        }
    };
    private StringProperty subtitle;
    private ObservableList<Label> tags;
    private static final PseudoClass WARNING_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"warning");

    public TwoLineListItem() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setMouseTransparent(true);
        this.lblTitle = new Label();
        this.lblTitle.getStyleClass().add((Object)"title");
        this.firstLine = new HBox(new Node[]{this.lblTitle});
        this.firstLine.getStyleClass().add((Object)"first-line");
        this.firstLine.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().setAll((Object[])new Node[]{this.firstLine});
    }

    public TwoLineListItem(String titleString, String subtitleString) {
        this();
        this.setTitle(titleString);
        this.setSubtitle(subtitleString);
    }

    private void initSecondLine() {
        if (this.secondLine == null) {
            this.lblSubtitle = new Label();
            this.lblSubtitle.getStyleClass().add((Object)"subtitle");
            this.secondLine = new HBox(new Node[]{this.lblSubtitle});
        }
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty subtitleProperty() {
        if (this.subtitle == null) {
            this.subtitle = new StringPropertyBase(){

                public Object getBean() {
                    return TwoLineListItem.this;
                }

                public String getName() {
                    return "subtitle";
                }

                protected void invalidated() {
                    String subtitle = this.get();
                    if (subtitle != null) {
                        TwoLineListItem.this.initSecondLine();
                        TwoLineListItem.this.lblSubtitle.setText(subtitle);
                        if (TwoLineListItem.this.getChildren().size() == 1) {
                            TwoLineListItem.this.getChildren().add((Object)TwoLineListItem.this.secondLine);
                        }
                    } else if (TwoLineListItem.this.secondLine != null) {
                        TwoLineListItem.this.lblSubtitle.setText(null);
                        if (TwoLineListItem.this.getChildren().size() > 1) {
                            TwoLineListItem.this.getChildren().setAll((Object[])new Node[]{TwoLineListItem.this.firstLine});
                        }
                    }
                }
            };
        }
        return this.subtitle;
    }

    public String getSubtitle() {
        return this.subtitle != null ? (String)this.subtitleProperty().get() : null;
    }

    public void setSubtitle(String subtitle) {
        if (this.subtitle == null && subtitle == null) {
            return;
        }
        this.subtitleProperty().set((Object)subtitle);
    }

    public Label getTitleLabel() {
        return this.lblTitle;
    }

    public Label getSubtitleLabel() {
        this.initSecondLine();
        return this.lblSubtitle;
    }

    public ObservableList<Label> getTags() {
        if (this.tags == null) {
            this.tags = FXCollections.observableArrayList();
            HBox tagsBox = new HBox(8.0);
            tagsBox.getStyleClass().add((Object)"tags");
            tagsBox.setAlignment(Pos.CENTER_LEFT);
            Bindings.bindContent((List)tagsBox.getChildren(), this.tags);
            ScrollPane scrollPane = new ScrollPane((Node)tagsBox);
            HBox.setHgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
            scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
            FXUtils.onChangeAndOperate(tagsBox.heightProperty(), height -> FXUtils.setLimitHeight((Region)scrollPane, height.doubleValue()));
            scrollPane.setPrefWidth(50.0);
            this.firstLine.getChildren().setAll((Object[])new Node[]{this.lblTitle, scrollPane});
        }
        return this.tags;
    }

    public void addTag(String tag, PseudoClass pseudoClass) {
        Label tagLabel = new Label(tag);
        tagLabel.getStyleClass().add((Object)"tag");
        if (pseudoClass != null) {
            tagLabel.pseudoClassStateChanged(pseudoClass, true);
        }
        this.getTags().add((Object)tagLabel);
    }

    public void addTag(String tag) {
        this.addTag(tag, null);
    }

    public void addTagWarning(String tag) {
        this.addTag(tag, WARNING_PSEUDO_CLASS);
    }

    public String toString() {
        return "TwoLineListItem[title=%s, subtitle=%s, tags=%s]".formatted(this.getTitle(), this.getSubtitle(), this.tags);
    }
}

