/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.wizard;

import java.util.Queue;
import java.util.concurrent.CancellationException;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.ui.wizard.AbstractWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.SettingsMap;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;

public abstract class TaskExecutorDialogWizardDisplayer
extends AbstractWizardDisplayer {
    public TaskExecutorDialogWizardDisplayer(Queue<Object> cancelQueue) {
        super(cancelQueue);
    }

    @Override
    public void handleTask(final SettingsMap settings, Task<?> task) {
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(new TaskCancellationAction(it -> {
            it.fireEvent(new DialogCloseEvent());
            this.onEnd();
        }));
        pane.setTitle(I18n.i18n("message.doing"));
        if (settings.containsKey("title")) {
            Object title = settings.get("title");
            if (title instanceof StringProperty) {
                StringProperty titleProperty = (StringProperty)title;
                pane.titleProperty().bind((ObservableValue)titleProperty);
            } else if (title instanceof String) {
                String titleMessage = (String)title;
                pane.setTitle(titleMessage);
            }
        }
        FXUtils.runInFX(() -> {
            TaskExecutor executor = task.executor(new TaskListener(){

                @Override
                public void onStop(boolean success, TaskExecutor executor) {
                    FXUtils.runInFX(() -> {
                        if (success) {
                            Object patt0$temp = settings.get("success_message");
                            if (patt0$temp instanceof String) {
                                String successMessage = (String)patt0$temp;
                                Controllers.dialog(successMessage, null, MessageDialogPane.MessageType.SUCCESS, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            } else if (!settings.containsKey("forbid_success_message")) {
                                Controllers.dialog(I18n.i18n("message.success"), null, MessageDialogPane.MessageType.SUCCESS, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            }
                        } else {
                            if (executor.getException() == null) {
                                return;
                            }
                            if (executor.getException() instanceof CancellationException) {
                                TaskExecutorDialogWizardDisplayer.this.onEnd();
                                return;
                            }
                            String appendix = StringUtils.getStackTrace(executor.getException());
                            if (settings.get(WizardProvider.FailureCallback.KEY) != null) {
                                settings.get(WizardProvider.FailureCallback.KEY).onFail(settings, executor.getException(), () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            } else {
                                Object patt0$temp = settings.get("failure_message");
                                if (patt0$temp instanceof String) {
                                    String failureMessage = (String)patt0$temp;
                                    Controllers.dialog(appendix, failureMessage, MessageDialogPane.MessageType.ERROR, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                                } else if (!settings.containsKey("forbid_failure_message")) {
                                    Controllers.dialog(appendix, I18n.i18n("wizard.failed"), MessageDialogPane.MessageType.ERROR, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                                }
                            }
                        }
                    });
                }
            });
            pane.setExecutor(executor);
            Controllers.dialog((Region)pane);
            executor.start();
        });
    }
}

