/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jackhuang.hmcl.game.World;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.versions.WorldBackupsPage;

public final class WorldBackupTask
extends Task<Path> {
    private final World world;
    private final Path backupsDir;
    private final boolean needLock;

    public WorldBackupTask(World world, Path backupsDir, boolean needLock) {
        this.world = world;
        this.backupsDir = backupsDir;
        this.needLock = needLock;
    }

    @Override
    public void execute() throws Exception {
        try (FileChannel lockChannel = this.needLock ? this.world.lock() : null;){
            Files.createDirectories(this.backupsDir, new FileAttribute[0]);
            String time = LocalDateTime.now().format(WorldBackupsPage.TIME_FORMATTER);
            String baseName = time + "_" + this.world.getFileName();
            Path backupFile = null;
            OutputStream outputStream = null;
            for (int count = 0; count < 256; ++count) {
                try {
                    backupFile = this.backupsDir.resolve(baseName + (count == 0 ? "" : " " + count) + ".zip").toAbsolutePath();
                    outputStream = Files.newOutputStream(backupFile, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
                    break;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    continue;
                }
            }
            if (outputStream == null) {
                throw new IOException("Too many attempts");
            }
            try (final ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(outputStream));){
                final String rootName = this.world.getFileName();
                final Path rootDir = this.world.getFile();
                Files.walkFileTree(this.world.getFile(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        if (path.endsWith("session.lock")) {
                            return FileVisitResult.CONTINUE;
                        }
                        zipOutputStream.putNextEntry(new ZipEntry(rootName + "/" + rootDir.relativize(path).toString().replace('\\', '/')));
                        Files.copy(path, zipOutputStream);
                        zipOutputStream.closeEntry();
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.setResult(backupFile);
        }
    }
}

