/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.tree;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import kala.compress.archivers.ArchiveEntry;
import kala.compress.archivers.zip.ZipArchiveReader;
import org.jackhuang.hmcl.util.tree.TarFileTree;
import org.jackhuang.hmcl.util.tree.ZipFileTree;

public abstract class ArchiveFileTree<F, E extends ArchiveEntry>
implements Closeable {
    protected final F file;
    protected final Dir<E> root = new Dir();

    public static ArchiveFileTree<?, ?> open(Path file) throws IOException {
        Path namePath = file.getFileName();
        if (namePath == null) {
            throw new IOException(file + " is not a valid archive file");
        }
        String name = namePath.toString();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            return new ZipFileTree(new ZipArchiveReader(file));
        }
        if (name.endsWith(".tar") || name.endsWith(".tar.gz") || name.endsWith(".tgz")) {
            return TarFileTree.open(file);
        }
        throw new IOException(file + " is not a valid archive file");
    }

    public ArchiveFileTree(F file) {
        this.file = file;
    }

    public F getFile() {
        return this.file;
    }

    public Dir<E> getRoot() {
        return this.root;
    }

    public void addEntry(E entry) throws IOException {
        int end;
        String[] path = entry.getName().split("/");
        Dir dir = this.root;
        int n = end = entry.isDirectory() ? path.length : path.length - 1;
        for (int i = 0; i < end; ++i) {
            String item = path[i];
            if (item.equals(".")) continue;
            if (item.equals("..") || item.isEmpty()) {
                throw new IOException("Invalid entry: " + entry.getName());
            }
            if (dir.files.containsKey(item)) {
                throw new IOException("A file and a directory have the same name: " + entry.getName());
            }
            dir = dir.subDirs.computeIfAbsent(item, name -> new Dir());
        }
        if (entry.isDirectory()) {
            if (dir.entry != null) {
                throw new IOException("Duplicate entry: " + entry.getName());
            }
            dir.entry = entry;
        } else {
            String fileName = path[path.length - 1];
            if (dir.subDirs.containsKey(fileName)) {
                throw new IOException("A file and a directory have the same name: " + entry.getName());
            }
            if (dir.files.containsKey(fileName)) {
                throw new IOException("Duplicate entry: " + entry.getName());
            }
            dir.files.put(fileName, entry);
        }
    }

    public abstract InputStream getInputStream(E var1) throws IOException;

    public abstract boolean isLink(E var1);

    public abstract String getLink(E var1) throws IOException;

    public abstract boolean isExecutable(E var1);

    @Override
    public abstract void close() throws IOException;

    public static final class Dir<E extends ArchiveEntry> {
        E entry;
        final Map<String, Dir<E>> subDirs = new HashMap<String, Dir<E>>();
        final Map<String, E> files = new HashMap<String, E>();

        public Map<String, Dir<E>> getSubDirs() {
            return this.subDirs;
        }

        public Map<String, E> getFiles() {
            return this.files;
        }
    }
}

