/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.nbt;

import com.github.steveice10.opennbt.NBTIO;
import com.github.steveice10.opennbt.tag.builtin.CompoundTag;
import com.github.steveice10.opennbt.tag.builtin.IntTag;
import com.github.steveice10.opennbt.tag.builtin.ListTag;
import com.github.steveice10.opennbt.tag.builtin.Tag;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import kala.compress.utils.BoundedInputStream;
import org.jackhuang.hmcl.ui.nbt.NBTTreeView;
import org.jackhuang.hmcl.util.io.FileUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum NBTFileType {
    COMPRESSED(new String[]{"dat", "dat_old"}){

        @Override
        public Tag read(Path file) throws IOException {
            try (BufferedInputStream fileInputStream = new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));){
                fileInputStream.mark(3);
                byte[] header = new byte[3];
                if (fileInputStream.read(header) < 3) {
                    throw new IOException("File is too small");
                }
                fileInputStream.reset();
                FilterInputStream input = Arrays.equals(header, new byte[]{31, -117, 8}) ? new GZIPInputStream(fileInputStream) : fileInputStream;
                Tag tag = NBTIO.readTag(input);
                if (!(tag instanceof CompoundTag)) {
                    throw new IOException("Unexpected tag: " + String.valueOf(tag));
                }
                Tag tag2 = tag;
                return tag2;
            }
        }
    }
    ,
    ANVIL(new String[]{"mca"}){

        @Override
        public Tag read(Path file) throws IOException {
            return REGION.read(file);
        }

        @Override
        public NBTTreeView.Item readAsTree(Path file) throws IOException {
            return REGION.readAsTree(file);
        }
    }
    ,
    REGION(new String[]{"mcr"}){

        @Override
        public Tag read(Path file) throws IOException {
            try (RandomAccessFile r = new RandomAccessFile(file.toFile(), "r");){
                ListTag tag = new ListTag(file.getFileName().toString(), CompoundTag.class);
                if (r.length() == 0L) {
                    ListTag listTag = tag;
                    return listTag;
                }
                byte[] header = new byte[4096];
                byte[] buffer = new byte[0x100000];
                Inflater inflater = new Inflater();
                r.readFully(header);
                for (int i = 0; i < 4096; i += 4) {
                    int offset = ((header[i] & 0xFF) << 16) + ((header[i + 1] & 0xFF) << 8) + (header[i + 2] & 0xFF);
                    int length = header[i + 3] & 0xFF;
                    if (offset == 0 || length == 0) continue;
                    r.seek((long)offset * 4096L);
                    r.readFully(buffer, 0, length * 4096);
                    int chunkLength = ((buffer[0] & 0xFF) << 24) + ((buffer[1] & 0xFF) << 16) + ((buffer[2] & 0xFF) << 8) + (buffer[3] & 0xFF);
                    InputStream input = new ByteArrayInputStream(buffer);
                    ((InputStream)input).skip(5L);
                    input = new BoundedInputStream(input, chunkLength - 1);
                    switch (buffer[4]) {
                        case 1: {
                            input = new GZIPInputStream(input);
                            break;
                        }
                        case 2: {
                            inflater.reset();
                            input = new InflaterInputStream(input, inflater);
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            throw new IOException("Unsupported compression method: " + Integer.toHexString(buffer[4] & 0xFF));
                        }
                    }
                    try (InputStream in = input;){
                        Tag chunk = NBTIO.readTag(in);
                        if (!(chunk instanceof CompoundTag)) {
                            throw new IOException("Unexpected tag: " + String.valueOf(chunk));
                        }
                        tag.add(chunk);
                        continue;
                    }
                }
                ListTag listTag = tag;
                return listTag;
            }
        }

        @Override
        public NBTTreeView.Item readAsTree(Path file) throws IOException {
            NBTTreeView.Item item = new NBTTreeView.Item(this.read(file));
            for (Tag tag : (ListTag)item.getValue()) {
                CompoundTag chunk = (CompoundTag)tag;
                NBTTreeView.Item tree = NBTTreeView.buildTree(chunk);
                Object xPos = chunk.get("xPos");
                Object zPos = chunk.get("zPos");
                if (xPos instanceof IntTag && zPos instanceof IntTag) {
                    tree.setText(String.format("Chunk: %d  %d", ((Tag)xPos).getValue(), ((Tag)zPos).getValue()));
                } else {
                    tree.setText("Chunk: Unknown");
                }
                item.getChildren().add((Object)tree);
            }
            return item;
        }
    };

    static final NBTFileType[] types;
    private final String[] extensions;

    public static boolean isNBTFileByExtension(Path file) {
        return NBTFileType.ofFile(file) != null;
    }

    public static NBTFileType ofFile(Path file) {
        String ext = FileUtils.getExtension(file);
        for (NBTFileType type : types) {
            for (String extension : type.extensions) {
                if (!extension.equals(ext)) continue;
                return type;
            }
        }
        return null;
    }

    private NBTFileType(String ... extensions) {
        this.extensions = extensions;
    }

    public abstract Tag read(Path var1) throws IOException;

    public NBTTreeView.Item readAsTree(Path file) throws IOException {
        NBTTreeView.Item root = NBTTreeView.buildTree(this.read(file));
        root.setName(file.getFileName().toString());
        return root;
    }

    static {
        types = NBTFileType.values();
    }
}

