/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.scene.image.Image;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.game.QuickPlayOption;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.java.JavaRuntime;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.VersionIconType;
import org.jackhuang.hmcl.setting.VersionSetting;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.FileSaver;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.SystemInfo;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.jetbrains.annotations.Nullable;

public final class HMCLGameRepository
extends DefaultGameRepository {
    private final Profile profile;
    private final Map<String, VersionSetting> localVersionSettings = new HashMap<String, VersionSetting>();
    private final Set<String> beingModpackVersions = new HashSet<String>();
    public final EventManager<Event> onVersionIconChanged = new EventManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String PROFILE = "{\"selectedProfile\": \"(Default)\",\"profiles\": {\"(Default)\": {\"name\": \"(Default)\"}},\"clientToken\": \"88888888-8888-8888-8888-888888888888\"}";
    private static final Set<String> FORBIDDEN_VERSION_IDS = new HashSet<String>(Arrays.asList("modpack", "minecraftinstance", "manifest"));

    public HMCLGameRepository(Profile profile, Path baseDirectory) {
        super(baseDirectory);
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public GameDirectoryType getGameDirectoryType(String id) {
        if (this.beingModpackVersions.contains(id) || this.isModpack(id)) {
            return GameDirectoryType.VERSION_FOLDER;
        }
        return this.getVersionSetting(id).getGameDirType();
    }

    @Override
    public Path getRunDirectory(String id) {
        switch (this.getGameDirectoryType(id)) {
            case VERSION_FOLDER: {
                return this.getVersionRoot(id);
            }
            case ROOT_FOLDER: {
                return super.getRunDirectory(id);
            }
            case CUSTOM: {
                try {
                    return Path.of(this.getVersionSetting(id).getGameDir(), new String[0]);
                }
                catch (InvalidPathException ignored) {
                    return this.getVersionRoot(id);
                }
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public Stream<Version> getDisplayVersions() {
        return this.getVersions().stream().filter(v -> !v.isHidden()).sorted(Comparator.comparing(v -> Lang.requireNonNullElse(v.getReleaseTime(), Instant.EPOCH)).thenComparing(v -> VersionNumber.asVersion(v.getId())));
    }

    @Override
    protected void refreshVersionsImpl() {
        this.localVersionSettings.clear();
        super.refreshVersionsImpl();
        this.versions.keySet().forEach(this::loadLocalVersionSetting);
        this.versions.keySet().forEach(version -> {
            if (this.isModpack((String)version)) {
                this.specializeVersionSetting((String)version);
            }
        });
        try {
            Path file = this.getBaseDirectory().resolve("launcher_profiles.json");
            if (!Files.exists(file, new LinkOption[0]) && !this.versions.isEmpty()) {
                Files.createDirectories(file.getParent(), new FileAttribute[0]);
                Files.writeString(file, (CharSequence)PROFILE, new OpenOption[0]);
            }
        }
        catch (IOException ex) {
            Logger.LOG.warning("Unable to create launcher_profiles.json, Forge/LiteLoader installer will not work.", ex);
        }
    }

    public void changeDirectory(Path newDirectory) {
        this.setBaseDirectory(newDirectory);
        this.refreshVersionsAsync().start();
    }

    private void clean(Path directory) throws IOException {
        FileUtils.deleteDirectory(directory.resolve("crash-reports"));
        FileUtils.deleteDirectory(directory.resolve("logs"));
    }

    public void clean(String id) throws IOException {
        this.clean(this.getBaseDirectory());
        this.clean(this.getRunDirectory(id));
    }

    public void duplicateVersion(String srcId, String dstId, boolean copySaves) throws IOException {
        Path srcDir = this.getVersionRoot(srcId);
        Path dstDir = this.getVersionRoot(dstId);
        Version fromVersion = this.getVersion(srcId);
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(srcId + ".jar");
        blackList.add(srcId + ".json");
        if (!copySaves) {
            blackList.add("saves");
        }
        if (Files.exists(dstDir, new LinkOption[0])) {
            throw new IOException("Version exists");
        }
        Files.createDirectories(dstDir, new FileAttribute[0]);
        FileUtils.copyDirectory(srcDir, dstDir, path -> Modpack.acceptFile(path, blackList, null));
        Path fromJson = srcDir.resolve(srcId + ".json");
        Path fromJar = srcDir.resolve(srcId + ".jar");
        Path toJson = dstDir.resolve(dstId + ".json");
        Path toJar = dstDir.resolve(dstId + ".jar");
        if (Files.exists(fromJar, new LinkOption[0])) {
            Files.copy(fromJar, toJar, new CopyOption[0]);
        }
        Files.copy(fromJson, toJson, new CopyOption[0]);
        JsonUtils.writeToJsonFile(toJson, fromVersion.setId(dstId));
        VersionSetting oldVersionSetting = this.getVersionSetting(srcId).clone();
        GameDirectoryType originalGameDirType = oldVersionSetting.getGameDirType();
        oldVersionSetting.setUsesGlobal(false);
        oldVersionSetting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        VersionSetting newVersionSetting = this.initLocalVersionSetting(dstId, oldVersionSetting);
        this.saveVersionSetting(dstId);
        Path srcGameDir = this.getRunDirectory(srcId);
        Path dstGameDir = this.getRunDirectory(dstId);
        if (originalGameDirType != GameDirectoryType.VERSION_FOLDER) {
            FileUtils.copyDirectory(srcGameDir, dstGameDir, path -> Modpack.acceptFile(path, blackList, null));
        }
    }

    private Path getLocalVersionSettingFile(String id) {
        return this.getVersionRoot(id).resolve("hmclversion.cfg");
    }

    private void loadLocalVersionSetting(String id) {
        Path file = this.getLocalVersionSettingFile(id);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                VersionSetting versionSetting = JsonUtils.fromJsonFile(file, VersionSetting.class);
                this.initLocalVersionSetting(id, versionSetting);
            }
            catch (Exception ex) {
                this.initLocalVersionSetting(id, new VersionSetting());
            }
        }
    }

    public VersionSetting createLocalVersionSetting(String id) {
        if (!this.hasVersion(id)) {
            return null;
        }
        if (this.localVersionSettings.containsKey(id)) {
            return this.getLocalVersionSetting(id);
        }
        return this.initLocalVersionSetting(id, new VersionSetting());
    }

    private VersionSetting initLocalVersionSetting(String id, VersionSetting vs) {
        this.localVersionSettings.put(id, vs);
        vs.addListener(a -> this.saveVersionSetting(id));
        return vs;
    }

    @Nullable
    public VersionSetting getLocalVersionSetting(String id) {
        VersionSetting setting;
        if (!this.localVersionSettings.containsKey(id)) {
            this.loadLocalVersionSetting(id);
        }
        if ((setting = this.localVersionSettings.get(id)) != null && this.isModpack(id)) {
            setting.setGameDirType(GameDirectoryType.VERSION_FOLDER);
        }
        return setting;
    }

    @Nullable
    public VersionSetting getLocalVersionSettingOrCreate(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null) {
            vs = this.createLocalVersionSetting(id);
        }
        return vs;
    }

    public VersionSetting getVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null || vs.isUsesGlobal()) {
            this.profile.getGlobal().setUsesGlobal(true);
            return this.profile.getGlobal();
        }
        return vs;
    }

    public Optional<Path> getVersionIconFile(String id) {
        Path root = this.getVersionRoot(id);
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            Path file = root.resolve("icon." + extension);
            if (!Files.exists(file, new LinkOption[0])) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public void setVersionIconFile(String id, Path iconFile) throws IOException {
        String ext = FileUtils.getExtension(iconFile).toLowerCase(Locale.ROOT);
        if (!FXUtils.IMAGE_EXTENSIONS.contains(ext)) {
            throw new IllegalArgumentException("Unsupported icon file: " + ext);
        }
        this.deleteIconFile(id);
        FileUtils.copyFile(iconFile, this.getVersionRoot(id).resolve("icon." + ext));
    }

    public void deleteIconFile(String id) {
        Path root = this.getVersionRoot(id);
        for (String extension : FXUtils.IMAGE_EXTENSIONS) {
            Path file = root.resolve("icon." + extension);
            try {
                Files.deleteIfExists(file);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete icon file: " + String.valueOf(file), e);
            }
        }
    }

    public Image getVersionIconImage(String id) {
        VersionIconType iconType;
        if (id == null || !this.isLoaded()) {
            return VersionIconType.DEFAULT.getIcon();
        }
        VersionSetting vs = this.getLocalVersionSettingOrCreate(id);
        VersionIconType versionIconType = iconType = vs != null ? Lang.requireNonNullElse(vs.getVersionIcon(), VersionIconType.DEFAULT) : VersionIconType.DEFAULT;
        if (iconType == VersionIconType.DEFAULT) {
            String gameVersion;
            Version version = this.getVersion(id).resolve(this);
            Optional<Path> iconFile = this.getVersionIconFile(id);
            if (iconFile.isPresent()) {
                try {
                    return FXUtils.loadImage(iconFile.get());
                }
                catch (Exception e) {
                    Logger.LOG.warning("Failed to load version icon of " + id, e);
                }
            }
            if (LibraryAnalyzer.isModded(this, version)) {
                LibraryAnalyzer libraryAnalyzer = LibraryAnalyzer.analyze(version, null);
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FABRIC)) {
                    return VersionIconType.FABRIC.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.QUILT)) {
                    return VersionIconType.QUILT.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.NEO_FORGE)) {
                    return VersionIconType.NEO_FORGE.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
                    return VersionIconType.FORGE.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.CLEANROOM)) {
                    return VersionIconType.CLEANROOM.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.LITELOADER)) {
                    return VersionIconType.CHICKEN.getIcon();
                }
                if (libraryAnalyzer.has(LibraryAnalyzer.LibraryType.OPTIFINE)) {
                    return VersionIconType.OPTIFINE.getIcon();
                }
            }
            if ((gameVersion = (String)this.getGameVersion(version).orElse(null)) != null) {
                GameVersionNumber versionNumber = GameVersionNumber.asGameVersion(gameVersion);
                if (versionNumber.isAprilFools()) {
                    return VersionIconType.APRIL_FOOLS.getIcon();
                }
                if (versionNumber instanceof GameVersionNumber.LegacySnapshot) {
                    return VersionIconType.COMMAND.getIcon();
                }
                if (versionNumber instanceof GameVersionNumber.Old) {
                    return VersionIconType.CRAFT_TABLE.getIcon();
                }
            }
            return VersionIconType.GRASS.getIcon();
        }
        return iconType.getIcon();
    }

    public void saveVersionSetting(String id) {
        if (!this.localVersionSettings.containsKey(id)) {
            return;
        }
        Path file = this.getLocalVersionSettingFile(id).toAbsolutePath().normalize();
        try {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            Logger.LOG.warning("Failed to create directory: " + String.valueOf(file.getParent()), e);
        }
        FileSaver.save(file, GSON.toJson(this.localVersionSettings.get(id)));
    }

    public VersionSetting specializeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs == null) {
            vs = this.createLocalVersionSetting(id);
        }
        if (vs == null) {
            return null;
        }
        if (vs.isUsesGlobal()) {
            vs.setUsesGlobal(false);
        }
        return vs;
    }

    public void globalizeVersionSetting(String id) {
        VersionSetting vs = this.getLocalVersionSetting(id);
        if (vs != null) {
            vs.setUsesGlobal(true);
        }
    }

    public LaunchOptions.Builder getLaunchOptions(String version, JavaRuntime javaVersion, Path gameDir, List<String> javaAgents, List<String> javaArguments, boolean makeLaunchScript) {
        Path json;
        VersionSetting vs = this.getVersionSetting(version);
        LaunchOptions.Builder builder = new LaunchOptions.Builder().setGameDir(gameDir).setJava(javaVersion).setVersionType(Metadata.TITLE).setVersionName(version).setProfileName(Metadata.TITLE).setGameArguments(StringUtils.tokenize(vs.getMinecraftArgs())).setOverrideJavaArguments(StringUtils.tokenize(vs.getJavaArgs())).setMaxMemory(vs.isNoJVMArgs() && vs.isAutoMemory() ? null : Integer.valueOf((int)(HMCLGameRepository.getAllocatedMemory((long)vs.getMaxMemory() * 1024L * 1024L, SystemInfo.getPhysicalMemoryStatus().getAvailable(), vs.isAutoMemory()) / 1024L / 1024L))).setMinMemory(vs.getMinMemory()).setMetaspace(Lang.toIntOrNull(vs.getPermSize())).setEnvironmentVariables(Lang.mapOf(StringUtils.tokenize(vs.getEnvironmentVariables()).stream().map(it -> {
            int idx = it.indexOf(61);
            return idx >= 0 ? Pair.pair(it.substring(0, idx), it.substring(idx + 1)) : Pair.pair(it, "");
        }).collect(Collectors.toList()))).setWidth(vs.getWidth()).setHeight(vs.getHeight()).setFullscreen(vs.isFullscreen()).setWrapper(vs.getWrapper()).setPreLaunchCommand(vs.getPreLaunchCommand()).setPostExitCommand(vs.getPostExitCommand()).setNoGeneratedJVMArgs(vs.isNoJVMArgs()).setNoGeneratedOptimizingJVMArgs(vs.isNoOptimizingJVMArgs()).setNativesDirType(vs.getNativesDirType()).setNativesDir(vs.getNativesDir()).setProcessPriority(vs.getProcessPriority()).setRenderer(vs.getRenderer()).setEnableDebugLogOutput(vs.isEnableDebugLogOutput()).setUseNativeGLFW(vs.isUseNativeGLFW()).setUseNativeOpenAL(vs.isUseNativeOpenAL()).setDaemon(!makeLaunchScript && vs.getLauncherVisibility().isDaemon()).setJavaAgents(javaAgents).setJavaArguments(javaArguments);
        if (StringUtils.isNotBlank(vs.getServerIp())) {
            builder.setQuickPlayOption(new QuickPlayOption.MultiPlayer(vs.getServerIp()));
        }
        if (ConfigHolder.config().hasProxy()) {
            builder.setProxyType(ConfigHolder.config().getProxyType());
            builder.setProxyHost(ConfigHolder.config().getProxyHost());
            builder.setProxyPort(ConfigHolder.config().getProxyPort());
            if (ConfigHolder.config().hasProxyAuth()) {
                builder.setProxyUser(ConfigHolder.config().getProxyUser());
                builder.setProxyPass(ConfigHolder.config().getProxyPass());
            }
        }
        if (Files.exists(json = this.getModpackConfiguration(version), new LinkOption[0])) {
            try {
                String jsonText = Files.readString(json);
                ModpackConfiguration modpackConfiguration = JsonUtils.GSON.fromJson(jsonText, ModpackConfiguration.class);
                ModpackProvider provider = ModpackHelper.getProviderByType(modpackConfiguration.getType());
                if (provider != null) {
                    provider.injectLaunchOptions(jsonText, builder);
                }
            }
            catch (JsonParseException | IOException e) {
                Logger.LOG.warning("Failed to parse modpack configuration file " + String.valueOf(json), e);
            }
        }
        if (vs.isAutoMemory() && builder.getJavaArguments().stream().anyMatch(it -> it.startsWith("-Xmx"))) {
            builder.setMaxMemory(null);
        }
        return builder;
    }

    @Override
    public Path getModpackConfiguration(String version) {
        return this.getVersionRoot(version).resolve("modpack.cfg");
    }

    public void markVersionAsModpack(String id) {
        this.beingModpackVersions.add(id);
    }

    public void undoMark(String id) {
        this.beingModpackVersions.remove(id);
    }

    public void markVersionLaunchedAbnormally(String id) {
        try {
            Files.createFile(this.getVersionRoot(id).resolve(".abnormal"), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean unmarkVersionLaunchedAbnormally(String id) {
        Path file = this.getVersionRoot(id).resolve(".abnormal");
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                Logger.LOG.warning("Failed to delete abnormal mark file: " + String.valueOf(file), e);
            }
            return true;
        }
        return false;
    }

    public static boolean isValidVersionId(String id) {
        if (FORBIDDEN_VERSION_IDS.contains(id)) {
            return false;
        }
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS && FORBIDDEN_VERSION_IDS.contains(id.toLowerCase(Locale.ROOT))) {
            return false;
        }
        return FileUtils.isNameValid(id);
    }

    public boolean versionIdConflicts(String id) {
        if (OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS) {
            for (String existingId : this.versions.keySet()) {
                if (!existingId.equalsIgnoreCase(id)) continue;
                return true;
            }
            return false;
        }
        return this.versions.containsKey(id);
    }

    public static long getAllocatedMemory(long minimum, long available, boolean auto) {
        if (auto) {
            if ((available -= 0x20000000L) <= 0L) {
                return minimum;
            }
            long threshold = 0x200000000L;
            long suggested = Math.min(available <= 0x200000000L ? (long)((double)available * 0.8) : (long)(6.8719476736E9 + (double)(available - 0x200000000L) * 0.2), 0x400000000L);
            return Math.max(minimum, suggested);
        }
        return minimum;
    }
}

