/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.InstallerItem;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.download.UpdateInstallerWizardProvider;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.TaskCancellationAction;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public class InstallerListPage
extends ListPageBase<InstallerItem>
implements VersionPage.VersionLoadable {
    private Profile profile;
    private String versionId;
    private Version version;
    private String gameVersion;

    public InstallerListPage() {
        FXUtils.applyDragListener((Node)this, it -> Arrays.asList("jar", "exe").contains(FileUtils.getExtension(it)), mods -> {
            if (!mods.isEmpty()) {
                this.doInstallOffline((Path)mods.get(0));
            }
        });
    }

    protected Skin<?> createDefaultSkin() {
        return new InstallerListPageSkin();
    }

    @Override
    public void loadVersion(Profile profile, String versionId) {
        this.profile = profile;
        this.versionId = versionId;
        this.version = profile.getRepository().getVersion(versionId);
        this.gameVersion = null;
        CompletableFuture.supplyAsync(() -> {
            this.gameVersion = profile.getRepository().getGameVersion(this.version).orElse(null);
            return LibraryAnalyzer.analyze(profile.getRepository().getResolvedPreservingPatchesVersion(versionId), this.gameVersion);
        }).thenAcceptAsync(analyzer -> {
            this.itemsProperty().clear();
            InstallerItem.InstallerItemGroup group = new InstallerItem.InstallerItemGroup(this.gameVersion, InstallerItem.Style.LIST_ITEM);
            for (InstallerItem item : group.getLibraries()) {
                String libraryId = item.getLibraryId();
                if (libraryId.contains("fabric-api") || libraryId.contains("quilt-api")) continue;
                String libraryVersion = analyzer.getVersion(libraryId).orElse(null);
                if (libraryVersion != null) {
                    item.versionProperty().set((Object)new InstallerItem.InstalledState(libraryVersion, analyzer.getLibraryStatus(libraryId) != LibraryAnalyzer.LibraryMark.LibraryStatus.CLEAR, false));
                } else {
                    item.versionProperty().set(null);
                }
                item.setOnInstall(() -> Controllers.getDecorator().startWizard(new UpdateInstallerWizardProvider(profile, this.gameVersion, this.version, libraryId, libraryVersion)));
                item.setOnRemove(() -> profile.getDependency().removeLibraryAsync(this.version, libraryId).thenComposeAsync(profile.getRepository()::saveAsync).withComposeAsync(profile.getRepository().refreshVersionsAsync()).withRunAsync(Schedulers.javafx(), () -> this.loadVersion(this.profile, this.versionId)).start());
                this.itemsProperty().add((Object)item);
            }
            for (LibraryAnalyzer.LibraryMark mark : analyzer) {
                String libraryId = mark.getLibraryId();
                String libraryVersion = mark.getLibraryVersion();
                if ("mcbbs".equals(libraryId) || LibraryAnalyzer.LibraryType.fromPatchId(libraryId) != null) continue;
                InstallerItem installerItem = new InstallerItem(libraryId, InstallerItem.Style.LIST_ITEM);
                installerItem.versionProperty().set((Object)new InstallerItem.InstalledState(libraryVersion, false, false));
                installerItem.setOnRemove(() -> profile.getDependency().removeLibraryAsync(this.version, libraryId).thenComposeAsync(profile.getRepository()::saveAsync).withComposeAsync(profile.getRepository().refreshVersionsAsync()).withRunAsync(Schedulers.javafx(), () -> this.loadVersion(this.profile, this.versionId)).start());
                this.itemsProperty().add((Object)installerItem);
            }
        }, Platform::runLater);
    }

    public void installOffline() {
        FileChooser chooser = new FileChooser();
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("install.installer.install_offline.extension"), new String[]{"*.jar", "*.exe"}));
        Path file = FileUtils.toPath(chooser.showOpenDialog((Window)Controllers.getStage()));
        if (file != null) {
            this.doInstallOffline(file);
        }
    }

    private void doInstallOffline(Path file) {
        Task<Void> task = this.profile.getDependency().installLibraryAsync(this.version, file).thenComposeAsync(this.profile.getRepository()::saveAsync).thenComposeAsync(this.profile.getRepository().refreshVersionsAsync());
        task.setName(I18n.i18n("install.installer.install_offline"));
        TaskExecutor executor = task.executor(new TaskListener(){

            @Override
            public void onStop(boolean success, TaskExecutor executor) {
                FXUtils.runInFX(() -> {
                    if (success) {
                        InstallerListPage.this.loadVersion(InstallerListPage.this.profile, InstallerListPage.this.versionId);
                        Controllers.dialog(I18n.i18n("install.success"));
                    } else {
                        if (executor.getException() == null) {
                            return;
                        }
                        UpdateInstallerWizardProvider.alertFailureMessage(executor.getException(), null);
                    }
                });
            }
        });
        Controllers.taskDialog(executor, I18n.i18n("install.installer.install_offline"), TaskCancellationAction.NO_CANCEL);
        executor.start();
    }

    private class InstallerListPageSkin
    extends ToolbarListPageSkin<InstallerListPage> {
        InstallerListPageSkin() {
            super(InstallerListPage.this);
        }

        @Override
        protected List<Node> initializeToolbar(InstallerListPage skinnable) {
            return Collections.singletonList(InstallerListPageSkin.createToolbarButton2(I18n.i18n("install.installer.install_offline"), SVG.ADD, skinnable::installOffline));
        }
    }
}

