/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.jackhuang.hmcl.util.Holder;

public final class InvocationDispatcher<T>
implements Consumer<T> {
    private static final VarHandle PENDING_ARG_HANDLE;
    private final Executor executor;
    private final Consumer<T> action;
    private volatile Holder<T> pendingArg;

    public static <T> InvocationDispatcher<T> runOn(Executor executor, Consumer<T> action) {
        return new InvocationDispatcher<T>(executor, action);
    }

    private InvocationDispatcher(Executor executor, Consumer<T> action) {
        this.executor = executor;
        this.action = action;
    }

    @Override
    public void accept(T t) {
        if (PENDING_ARG_HANDLE.getAndSet(this, new Holder<T>(t)) == null) {
            this.executor.execute(() -> {
                Holder holder = PENDING_ARG_HANDLE.getAndSet(this, null);
                this.action.accept(holder.value);
            });
        }
    }

    static {
        try {
            PENDING_ARG_HANDLE = MethodHandles.lookup().findVarHandle(InvocationDispatcher.class, "pendingArg", Holder.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

