/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.info;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.TreeSet;

public final class Main {
    private static final StringBuilder builder = new StringBuilder();

    private static void appendString(StringBuilder builder, String str) {
        builder.append('\"');
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= ' ' && c <= '~') {
                if (c == '\"' || c == '\\') {
                    builder.append('\\');
                }
                builder.append(c);
                continue;
            }
            switch (c) {
                case '\b': {
                    builder.append("\\b");
                    continue block7;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block7;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block7;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block7;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block7;
                }
                default: {
                    builder.append("\\u").append(String.format("%04x", c));
                }
            }
        }
        builder.append('\"');
    }

    private static void printSystemProperty(String key) {
        Main.printInfo(key, System.getProperty(key));
    }

    private static void printInfo(String key, Object value) {
        Main.printInfo(key, value, false);
    }

    private static void printInfo(String key, Object value, boolean last) {
        builder.setLength(0);
        builder.append("  \"").append(key).append("\": ");
        if (value instanceof String) {
            Main.appendString(builder, (String)value);
        } else if (value instanceof Integer) {
            builder.append((Integer)value);
        } else if (value instanceof String[]) {
            String[] array = (String[])value;
            if (array.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[');
                for (int i = 0; i < array.length; ++i) {
                    String item = array[i];
                    Main.appendString(builder, item);
                    if (i >= array.length - 1) continue;
                    builder.append(", ");
                }
                builder.append(']');
            }
        } else {
            builder.append(value);
        }
        if (!last) {
            builder.append(",");
        }
        System.out.println(builder);
    }

    private static boolean checkClass(String className) {
        try {
            Class.forName(className, false, Main.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static String[] getModules() {
        try {
            Method getModuleName = Class.forName("java.lang.Module").getMethod("getName", new Class[0]);
            Class<?> moduleLayerClass = Class.forName("java.lang.ModuleLayer");
            Object bootLayer = moduleLayerClass.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            Set modules = (Set)moduleLayerClass.getMethod("modules", new Class[0]).invoke(bootLayer, new Object[0]);
            TreeSet<String> names = new TreeSet<String>();
            for (Object module : modules) {
                String name = (String)getModuleName.invoke(module, new Object[0]);
                names.add(name);
            }
            return names.toArray(new String[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void main(String[] args) {
        System.out.println('{');
        Main.printSystemProperty("os.name");
        Main.printSystemProperty("os.arch");
        Main.printSystemProperty("java.version");
        Main.printSystemProperty("java.fullversion");
        Main.printSystemProperty("java.vendor");
        Main.printSystemProperty("java.home");
        Main.printSystemProperty("java.vm.version");
        Main.printSystemProperty("java.vm.vendor");
        Main.printSystemProperty("java.vm.name");
        Main.printSystemProperty("java.vm.info");
        Main.printSystemProperty("java.class.version");
        Main.printSystemProperty("java.compiler");
        Main.printSystemProperty("sun.management.compiler");
        Main.printSystemProperty("jvmci.Compiler");
        Main.printInfo("java.modules", Main.getModules(), true);
        System.out.println('}');
    }
}

