/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXListView;
import java.util.Collections;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.ListPageBase;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.WeakListenerHolder;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorAnimatedPage;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.ui.profile.ProfileListItem;
import org.jackhuang.hmcl.ui.profile.ProfilePage;
import org.jackhuang.hmcl.ui.versions.GameListCell;
import org.jackhuang.hmcl.ui.versions.GameListItem;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.ExtendedProperties;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class GameListPage
extends DecoratorAnimatedPage
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("version.manage")));
    private final ListProperty<Profile> profiles = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObservableList<ProfileListItem> profileListItems = MappedObservableList.create(this.profilesProperty(), profile -> {
        ProfileListItem item = new ProfileListItem((Profile)profile);
        FXUtils.setLimitWidth((Region)item, 200.0);
        return item;
    });
    private final ObjectProperty<Profile> selectedProfile = ExtendedProperties.createSelectedItemPropertyFor(this.profileListItems, Profile.class);

    public GameListPage() {
        GameList gameList = new GameList();
        ScrollPane pane = new ScrollPane();
        VBox.setVgrow((Node)pane, (Priority)Priority.ALWAYS);
        AdvancedListItem addProfileItem = new AdvancedListItem();
        addProfileItem.getStyleClass().add((Object)"navigation-drawer-item");
        addProfileItem.setTitle(I18n.i18n("profile.new"));
        addProfileItem.setActionButtonVisible(false);
        addProfileItem.setLeftGraphic(VersionPage.wrap(SVG.ADD_CIRCLE));
        addProfileItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> Controllers.navigate((Node)new ProfilePage(null))));
        pane.setFitToWidth(true);
        VBox wrapper = new VBox();
        wrapper.getStyleClass().add((Object)"advanced-list-box-content");
        VBox box = new VBox();
        box.setFillWidth(true);
        Bindings.bindContent((List)box.getChildren(), this.profileListItems);
        wrapper.getChildren().setAll((Object[])new Node[]{box, addProfileItem});
        pane.setContent((Node)wrapper);
        AdvancedListBox bottomLeftCornerList = new AdvancedListBox().addNavigationDrawerItem(I18n.i18n("install.new_game"), SVG.ADD_CIRCLE, Versions::addNewGame).addNavigationDrawerItem(I18n.i18n("install.modpack"), SVG.PACKAGE2, Versions::importModpack).addNavigationDrawerItem(I18n.i18n("button.refresh"), SVG.REFRESH, gameList::refreshList).addNavigationDrawerItem(I18n.i18n("settings.type.global.manage"), SVG.SETTINGS, this::modifyGlobalGameSettings);
        FXUtils.setLimitHeight((Region)bottomLeftCornerList, 184.0);
        this.setLeft(new Node[]{pane, bottomLeftCornerList});
        this.setCenter(new Node[]{gameList});
    }

    public ObjectProperty<Profile> selectedProfileProperty() {
        return this.selectedProfile;
    }

    public ObservableList<Profile> getProfiles() {
        return (ObservableList)this.profiles.get();
    }

    public ListProperty<Profile> profilesProperty() {
        return this.profiles;
    }

    public void setProfiles(ObservableList<Profile> profiles) {
        this.profiles.set(profiles);
    }

    public void modifyGlobalGameSettings() {
        Versions.modifyGlobalSettings(Profiles.getSelectedProfile());
    }

    @Override
    public ReadOnlyObjectProperty<DecoratorPage.State> stateProperty() {
        return this.state.getReadOnlyProperty();
    }

    private static class GameList
    extends ListPageBase<GameListItem> {
        private final WeakListenerHolder listenerHolder = new WeakListenerHolder();

        public GameList() {
            Profiles.registerVersionsListener(this::loadVersions);
            this.setOnFailedAction((EventHandler<Event>)((EventHandler)e -> Controllers.navigate((Node)Controllers.getDownloadPage())));
        }

        private void loadVersions(Profile profile) {
            this.listenerHolder.clear();
            this.setLoading(true);
            this.setFailedReason(null);
            if (profile != Profiles.getSelectedProfile()) {
                return;
            }
            ObservableList children = FXCollections.observableList(profile.getRepository().getDisplayVersions().map(instance -> new GameListItem(profile, instance.getId())).toList());
            this.setItems(children);
            if (children.isEmpty()) {
                this.setFailedReason(I18n.i18n("version.empty.hint"));
            }
            this.setLoading(false);
        }

        public void refreshList() {
            Profiles.getSelectedProfile().getRepository().refreshVersionsAsync().start();
        }

        protected GameListSkin createDefaultSkin() {
            return new GameListSkin();
        }

        private class GameListSkin
        extends ToolbarListPageSkin<GameListItem, GameList> {
            public GameListSkin() {
                super(GameList.this);
            }

            @Override
            protected List<Node> initializeToolbar(GameList skinnable) {
                return Collections.emptyList();
            }

            @Override
            protected ListCell<GameListItem> createListCell(JFXListView<GameListItem> listView) {
                return new GameListCell();
            }
        }
    }
}

