/*
 * Decompiled with CFR 0.152.
 */
package kala.compress.archivers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import kala.compress.utils.Charsets;
import kala.compress.utils.SeekableInMemoryByteChannel;

public abstract class ArchiveReaderBuilder<R, B extends ArchiveReaderBuilder<R, B>> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    protected static final OpenOption[] DEFAULT_OPEN_OPTIONS = new OpenOption[]{StandardOpenOption.READ};
    protected OpenOption[] openOptions = DEFAULT_OPEN_OPTIONS;
    protected Charset charset = DEFAULT_CHARSET;
    protected String originDescription;
    protected SeekableByteChannel seekableByteChannel;
    protected Path path;

    protected Path checkPath() {
        if (this.path == null) {
            throw new IllegalStateException("path is null");
        }
        return this.path;
    }

    public final B setCharset(Charset charset) {
        this.charset = charset != null ? charset : DEFAULT_CHARSET;
        return this.asThis();
    }

    public final B setCharset(String charset) {
        return this.setCharset(Charsets.toCharset(charset, DEFAULT_CHARSET));
    }

    public final B setOpenOptions(OpenOption ... openOptions) {
        this.openOptions = openOptions != null ? openOptions : DEFAULT_OPEN_OPTIONS;
        return this.asThis();
    }

    public final B setOriginDescription(String description) {
        this.originDescription = description;
        return this.asThis();
    }

    public final B setSeekableByteChannel(SeekableByteChannel origin) {
        this.seekableByteChannel = origin;
        return this.asThis();
    }

    public final B setByteArray(byte[] origin) {
        return this.setSeekableByteChannel(new SeekableInMemoryByteChannel(origin));
    }

    public final B setFile(File origin) {
        this.path = origin.toPath();
        return this.asThis();
    }

    public final B setFile(String origin) {
        return this.setFile(new File(origin));
    }

    public final B setPath(Path origin) {
        this.path = origin;
        return this.asThis();
    }

    public final B setPath(String origin) {
        return this.setPath(Paths.get(origin, new String[0]));
    }

    public final B setURI(URI origin) {
        return this.setPath(Paths.get(origin));
    }

    public abstract R get() throws IOException;

    protected final B asThis() {
        return (B)this;
    }
}

