
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#ifndef hypre_STRUCT_MV_MUP_HEADER
#define hypre_STRUCT_MV_MUP_HEADER

#ifdef __cplusplus
extern "C" {
#endif

#if defined (HYPRE_MIXED_PRECISION)

/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


HYPRE_Int
hypre_APFillResponseStructAssumedPart_flt( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_APFillResponseStructAssumedPart_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_APFillResponseStructAssumedPart_long_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );

HYPRE_Int
hypre_APFindMyBoxesInRegions_flt( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_float **p_vol_array );
HYPRE_Int
hypre_APFindMyBoxesInRegions_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_double **p_vol_array );
HYPRE_Int
hypre_APFindMyBoxesInRegions_long_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_long_double **p_vol_array );

HYPRE_Int
hypre_APGetAllBoxesInRegions_flt( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_float **p_vol_array, MPI_Comm comm );
HYPRE_Int
hypre_APGetAllBoxesInRegions_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_double **p_vol_array, MPI_Comm comm );
HYPRE_Int
hypre_APGetAllBoxesInRegions_long_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, HYPRE_Int **p_count_array, hypre_long_double **p_vol_array, MPI_Comm comm );

HYPRE_Int
hypre_APPruneRegions_flt( hypre_BoxArray *region_array, HYPRE_Int **p_count_array, hypre_float **p_vol_array );
HYPRE_Int
hypre_APPruneRegions_dbl( hypre_BoxArray *region_array, HYPRE_Int **p_count_array, hypre_double **p_vol_array );
HYPRE_Int
hypre_APPruneRegions_long_dbl( hypre_BoxArray *region_array, HYPRE_Int **p_count_array, hypre_long_double **p_vol_array );

HYPRE_Int
hypre_APRefineRegionsByVol_flt( hypre_BoxArray *region_array, hypre_float *vol_array, HYPRE_Int max_regions, hypre_float gamma, HYPRE_Int dim, HYPRE_Int *return_code, MPI_Comm comm );
HYPRE_Int
hypre_APRefineRegionsByVol_dbl( hypre_BoxArray *region_array, hypre_double *vol_array, HYPRE_Int max_regions, hypre_double gamma, HYPRE_Int dim, HYPRE_Int *return_code, MPI_Comm comm );
HYPRE_Int
hypre_APRefineRegionsByVol_long_dbl( hypre_BoxArray *region_array, hypre_long_double *vol_array, HYPRE_Int max_regions, hypre_long_double gamma, HYPRE_Int dim, HYPRE_Int *return_code, MPI_Comm comm );

HYPRE_Int
hypre_APShrinkRegions_flt( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, MPI_Comm comm );
HYPRE_Int
hypre_APShrinkRegions_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, MPI_Comm comm );
HYPRE_Int
hypre_APShrinkRegions_long_dbl( hypre_BoxArray *region_array, hypre_BoxArray *my_box_array, MPI_Comm comm );

HYPRE_Int
hypre_APSubdivideRegion_flt( hypre_Box *region, HYPRE_Int dim, HYPRE_Int level, hypre_BoxArray *box_array, HYPRE_Int *num_new_boxes );
HYPRE_Int
hypre_APSubdivideRegion_dbl( hypre_Box *region, HYPRE_Int dim, HYPRE_Int level, hypre_BoxArray *box_array, HYPRE_Int *num_new_boxes );
HYPRE_Int
hypre_APSubdivideRegion_long_dbl( hypre_Box *region, HYPRE_Int dim, HYPRE_Int level, hypre_BoxArray *box_array, HYPRE_Int *num_new_boxes );

HYPRE_Int
hypre_AddIndexes_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );
HYPRE_Int
hypre_AddIndexes_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );
HYPRE_Int
hypre_AddIndexes_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );

HYPRE_Int
hypre_AppendBox_flt( hypre_Box *box, hypre_BoxArray *box_array );
HYPRE_Int
hypre_AppendBox_dbl( hypre_Box *box, hypre_BoxArray *box_array );
HYPRE_Int
hypre_AppendBox_long_dbl( hypre_Box *box, hypre_BoxArray *box_array );

HYPRE_Int
hypre_AppendBoxArray_flt( hypre_BoxArray *box_array_0, hypre_BoxArray *box_array_1 );
HYPRE_Int
hypre_AppendBoxArray_dbl( hypre_BoxArray *box_array_0, hypre_BoxArray *box_array_1 );
HYPRE_Int
hypre_AppendBoxArray_long_dbl( hypre_BoxArray *box_array_0, hypre_BoxArray *box_array_1 );

hypre_BoxArrayArray *
hypre_BoxArrayArrayClone_flt( hypre_BoxArrayArray *box_array_array );
hypre_BoxArrayArray *
hypre_BoxArrayArrayClone_dbl( hypre_BoxArrayArray *box_array_array );
hypre_BoxArrayArray *
hypre_BoxArrayArrayClone_long_dbl( hypre_BoxArrayArray *box_array_array );

hypre_BoxArrayArray *
hypre_BoxArrayArrayCreate_flt( HYPRE_Int size, HYPRE_Int ndim );
hypre_BoxArrayArray *
hypre_BoxArrayArrayCreate_dbl( HYPRE_Int size, HYPRE_Int ndim );
hypre_BoxArrayArray *
hypre_BoxArrayArrayCreate_long_dbl( HYPRE_Int size, HYPRE_Int ndim );

HYPRE_Int
hypre_BoxArrayArrayDestroy_flt( hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayDestroy_dbl( hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayDestroy_long_dbl( hypre_BoxArrayArray *box_array_array );

HYPRE_Int
hypre_BoxArrayArrayPrint_flt( MPI_Comm comm, const char *filename, hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayPrint_dbl( MPI_Comm comm, const char *filename, hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayPrint_long_dbl( MPI_Comm comm, const char *filename, hypre_BoxArrayArray *box_array_array );

HYPRE_Int
hypre_BoxArrayArrayPrintToFile_flt( FILE *file, hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayPrintToFile_dbl( FILE *file, hypre_BoxArrayArray *box_array_array );
HYPRE_Int
hypre_BoxArrayArrayPrintToFile_long_dbl( FILE *file, hypre_BoxArrayArray *box_array_array );

hypre_BoxArray *
hypre_BoxArrayClone_flt( hypre_BoxArray *box_array );
hypre_BoxArray *
hypre_BoxArrayClone_dbl( hypre_BoxArray *box_array );
hypre_BoxArray *
hypre_BoxArrayClone_long_dbl( hypre_BoxArray *box_array );

hypre_BoxArray *
hypre_BoxArrayCreate_flt( HYPRE_Int size, HYPRE_Int ndim );
hypre_BoxArray *
hypre_BoxArrayCreate_dbl( HYPRE_Int size, HYPRE_Int ndim );
hypre_BoxArray *
hypre_BoxArrayCreate_long_dbl( HYPRE_Int size, HYPRE_Int ndim );

HYPRE_Int
hypre_BoxArrayCreateFromIndices_flt( HYPRE_Int ndim, HYPRE_Int num_indices_in, HYPRE_Int **indices_in, hypre_float threshold, hypre_BoxArray **box_array_ptr );
HYPRE_Int
hypre_BoxArrayCreateFromIndices_dbl( HYPRE_Int ndim, HYPRE_Int num_indices_in, HYPRE_Int **indices_in, hypre_double threshold, hypre_BoxArray **box_array_ptr );
HYPRE_Int
hypre_BoxArrayCreateFromIndices_long_dbl( HYPRE_Int ndim, HYPRE_Int num_indices_in, HYPRE_Int **indices_in, hypre_long_double threshold, hypre_BoxArray **box_array_ptr );

HYPRE_Int
hypre_BoxArrayDestroy_flt( hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayDestroy_dbl( hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayDestroy_long_dbl( hypre_BoxArray *box_array );

HYPRE_Int
hypre_BoxArrayInBoxArray_flt( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );
HYPRE_Int
hypre_BoxArrayInBoxArray_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );
HYPRE_Int
hypre_BoxArrayInBoxArray_long_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );

HYPRE_Int
hypre_BoxArrayPrint_flt( MPI_Comm comm, const char *filename, hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayPrint_dbl( MPI_Comm comm, const char *filename, hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayPrint_long_dbl( MPI_Comm comm, const char *filename, hypre_BoxArray *box_array );

HYPRE_Int
hypre_BoxArrayPrintToFile_flt( FILE *file, hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayPrintToFile_dbl( FILE *file, hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayPrintToFile_long_dbl( FILE *file, hypre_BoxArray *box_array );

HYPRE_Int
hypre_BoxArrayReadFromFile_flt( FILE *file, hypre_BoxArray **box_array_ptr );
HYPRE_Int
hypre_BoxArrayReadFromFile_dbl( FILE *file, hypre_BoxArray **box_array_ptr );
HYPRE_Int
hypre_BoxArrayReadFromFile_long_dbl( FILE *file, hypre_BoxArray **box_array_ptr );

HYPRE_Int
hypre_BoxArraySetSize_flt( hypre_BoxArray *box_array, HYPRE_Int size );
HYPRE_Int
hypre_BoxArraySetSize_dbl( hypre_BoxArray *box_array, HYPRE_Int size );
HYPRE_Int
hypre_BoxArraySetSize_long_dbl( hypre_BoxArray *box_array, HYPRE_Int size );

HYPRE_Int
hypre_BoxArrayVolume_flt( hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayVolume_dbl( hypre_BoxArray *box_array );
HYPRE_Int
hypre_BoxArrayVolume_long_dbl( hypre_BoxArray *box_array );

HYPRE_Int
hypre_BoxArraysEqual_flt( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );
HYPRE_Int
hypre_BoxArraysEqual_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );
HYPRE_Int
hypre_BoxArraysEqual_long_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2 );

HYPRE_Int
hypre_BoxBTNodeCreate_flt( HYPRE_Int ndim, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTNodeCreate_dbl( HYPRE_Int ndim, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTNodeCreate_long_dbl( HYPRE_Int ndim, hypre_BoxBTNode **btnode_ptr );

HYPRE_Int
hypre_BoxBTNodeDestroy_flt( hypre_BoxBTNode *btnode );
HYPRE_Int
hypre_BoxBTNodeDestroy_dbl( hypre_BoxBTNode *btnode );
HYPRE_Int
hypre_BoxBTNodeDestroy_long_dbl( hypre_BoxBTNode *btnode );

HYPRE_Int
hypre_BoxBTNodeInitialize_flt( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );
HYPRE_Int
hypre_BoxBTNodeInitialize_dbl( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );
HYPRE_Int
hypre_BoxBTNodeInitialize_long_dbl( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );

HYPRE_Int
hypre_BoxBTNodeSetIndices_flt( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices );
HYPRE_Int
hypre_BoxBTNodeSetIndices_dbl( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices );
HYPRE_Int
hypre_BoxBTNodeSetIndices_long_dbl( hypre_BoxBTNode *btnode, HYPRE_Int num_indices, HYPRE_Int **indices );

HYPRE_Int
hypre_BoxBTQueueCreate_flt( hypre_BoxBTQueue **btqueue_ptr );
HYPRE_Int
hypre_BoxBTQueueCreate_dbl( hypre_BoxBTQueue **btqueue_ptr );
HYPRE_Int
hypre_BoxBTQueueCreate_long_dbl( hypre_BoxBTQueue **btqueue_ptr );

HYPRE_Int
hypre_BoxBTQueueDelete_flt( hypre_BoxBTQueue *btqueue, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTQueueDelete_dbl( hypre_BoxBTQueue *btqueue, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTQueueDelete_long_dbl( hypre_BoxBTQueue *btqueue, hypre_BoxBTNode **btnode_ptr );

HYPRE_Int
hypre_BoxBTQueueDestroy_flt( hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueDestroy_dbl( hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueDestroy_long_dbl( hypre_BoxBTQueue *btqueue );

HYPRE_Int
hypre_BoxBTQueueInitialize_flt( HYPRE_Int capacity, hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueInitialize_dbl( HYPRE_Int capacity, hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueInitialize_long_dbl( HYPRE_Int capacity, hypre_BoxBTQueue *btqueue );

HYPRE_Int
hypre_BoxBTQueueInsert_flt( hypre_BoxBTNode *btnode, hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueInsert_dbl( hypre_BoxBTNode *btnode, hypre_BoxBTQueue *btqueue );
HYPRE_Int
hypre_BoxBTQueueInsert_long_dbl( hypre_BoxBTNode *btnode, hypre_BoxBTQueue *btqueue );

HYPRE_Int
hypre_BoxBTStackCreate_flt( hypre_BoxBTStack **btstack_ptr );
HYPRE_Int
hypre_BoxBTStackCreate_dbl( hypre_BoxBTStack **btstack_ptr );
HYPRE_Int
hypre_BoxBTStackCreate_long_dbl( hypre_BoxBTStack **btstack_ptr );

HYPRE_Int
hypre_BoxBTStackDelete_flt( hypre_BoxBTStack *btstack, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTStackDelete_dbl( hypre_BoxBTStack *btstack, hypre_BoxBTNode **btnode_ptr );
HYPRE_Int
hypre_BoxBTStackDelete_long_dbl( hypre_BoxBTStack *btstack, hypre_BoxBTNode **btnode_ptr );

HYPRE_Int
hypre_BoxBTStackDestroy_flt( hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackDestroy_dbl( hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackDestroy_long_dbl( hypre_BoxBTStack *btstack );

HYPRE_Int
hypre_BoxBTStackInitialize_flt( HYPRE_Int capacity, hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackInitialize_dbl( HYPRE_Int capacity, hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackInitialize_long_dbl( HYPRE_Int capacity, hypre_BoxBTStack *btstack );

HYPRE_Int
hypre_BoxBTStackInsert_flt( hypre_BoxBTNode *btnode, hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackInsert_dbl( hypre_BoxBTNode *btnode, hypre_BoxBTStack *btstack );
HYPRE_Int
hypre_BoxBTStackInsert_long_dbl( hypre_BoxBTNode *btnode, hypre_BoxBTStack *btstack );

HYPRE_Int
hypre_BoxBinTreeCreate_flt( HYPRE_Int ndim, hypre_BoxBinTree **boxbt_ptr );
HYPRE_Int
hypre_BoxBinTreeCreate_dbl( HYPRE_Int ndim, hypre_BoxBinTree **boxbt_ptr );
HYPRE_Int
hypre_BoxBinTreeCreate_long_dbl( HYPRE_Int ndim, hypre_BoxBinTree **boxbt_ptr );

HYPRE_Int
hypre_BoxBinTreeDestroy_flt( hypre_BoxBinTree *boxbt );
HYPRE_Int
hypre_BoxBinTreeDestroy_dbl( hypre_BoxBinTree *boxbt );
HYPRE_Int
hypre_BoxBinTreeDestroy_long_dbl( hypre_BoxBinTree *boxbt );

HYPRE_Int
hypre_BoxBinTreeInitialize_flt( hypre_BoxBinTree *boxbt, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );
HYPRE_Int
hypre_BoxBinTreeInitialize_dbl( hypre_BoxBinTree *boxbt, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );
HYPRE_Int
hypre_BoxBinTreeInitialize_long_dbl( hypre_BoxBinTree *boxbt, HYPRE_Int num_indices, HYPRE_Int **indices, hypre_Box *box );

HYPRE_Int
hypre_BoxBoundaryDG_flt( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundarym, hypre_BoxArray *boundaryp, HYPRE_Int d );
HYPRE_Int
hypre_BoxBoundaryDG_dbl( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundarym, hypre_BoxArray *boundaryp, HYPRE_Int d );
HYPRE_Int
hypre_BoxBoundaryDG_long_dbl( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundarym, hypre_BoxArray *boundaryp, HYPRE_Int d );

HYPRE_Int
hypre_BoxBoundaryG_flt( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundary );
HYPRE_Int
hypre_BoxBoundaryG_dbl( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundary );
HYPRE_Int
hypre_BoxBoundaryG_long_dbl( hypre_Box *box, hypre_StructGrid *g, hypre_BoxArray *boundary );

HYPRE_Int
hypre_BoxBoundaryIntersect_flt( hypre_Box *box, hypre_StructGrid *grid, HYPRE_Int d, HYPRE_Int dir, hypre_BoxArray *boundary );
HYPRE_Int
hypre_BoxBoundaryIntersect_dbl( hypre_Box *box, hypre_StructGrid *grid, HYPRE_Int d, HYPRE_Int dir, hypre_BoxArray *boundary );
HYPRE_Int
hypre_BoxBoundaryIntersect_long_dbl( hypre_Box *box, hypre_StructGrid *grid, HYPRE_Int d, HYPRE_Int dir, hypre_BoxArray *boundary );

hypre_Box *
hypre_BoxClone_flt( hypre_Box *box );
hypre_Box *
hypre_BoxClone_dbl( hypre_Box *box );
hypre_Box *
hypre_BoxClone_long_dbl( hypre_Box *box );

hypre_Box *
hypre_BoxCreate_flt( HYPRE_Int ndim );
hypre_Box *
hypre_BoxCreate_dbl( HYPRE_Int ndim );
hypre_Box *
hypre_BoxCreate_long_dbl( HYPRE_Int ndim );

HYPRE_Int
hypre_BoxDestroy_flt( hypre_Box *box );
HYPRE_Int
hypre_BoxDestroy_dbl( hypre_Box *box );
HYPRE_Int
hypre_BoxDestroy_long_dbl( hypre_Box *box );

HYPRE_Int
hypre_BoxGetSize_flt( hypre_Box *box, hypre_Index size );
HYPRE_Int
hypre_BoxGetSize_dbl( hypre_Box *box, hypre_Index size );
HYPRE_Int
hypre_BoxGetSize_long_dbl( hypre_Box *box, hypre_Index size );

HYPRE_Int
hypre_BoxGetStrideSize_flt( hypre_Box *box, hypre_Index stride, hypre_Index size );
HYPRE_Int
hypre_BoxGetStrideSize_dbl( hypre_Box *box, hypre_Index stride, hypre_Index size );
HYPRE_Int
hypre_BoxGetStrideSize_long_dbl( hypre_Box *box, hypre_Index stride, hypre_Index size );

HYPRE_Int
hypre_BoxGetStrideVolume_flt( hypre_Box *box, hypre_Index stride, HYPRE_Int *volume_ptr );
HYPRE_Int
hypre_BoxGetStrideVolume_dbl( hypre_Box *box, hypre_Index stride, HYPRE_Int *volume_ptr );
HYPRE_Int
hypre_BoxGetStrideVolume_long_dbl( hypre_Box *box, hypre_Index stride, HYPRE_Int *volume_ptr );

HYPRE_Int
hypre_BoxGrowByArray_flt( hypre_Box *box, HYPRE_Int *array );
HYPRE_Int
hypre_BoxGrowByArray_dbl( hypre_Box *box, HYPRE_Int *array );
HYPRE_Int
hypre_BoxGrowByArray_long_dbl( hypre_Box *box, HYPRE_Int *array );

HYPRE_Int
hypre_BoxGrowByBox_flt( hypre_Box *box, hypre_Box *gbox );
HYPRE_Int
hypre_BoxGrowByBox_dbl( hypre_Box *box, hypre_Box *gbox );
HYPRE_Int
hypre_BoxGrowByBox_long_dbl( hypre_Box *box, hypre_Box *gbox );

HYPRE_Int
hypre_BoxGrowByIndex_flt( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxGrowByIndex_dbl( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxGrowByIndex_long_dbl( hypre_Box *box, hypre_Index index );

HYPRE_Int
hypre_BoxGrowByValue_flt( hypre_Box *box, HYPRE_Int val );
HYPRE_Int
hypre_BoxGrowByValue_dbl( hypre_Box *box, HYPRE_Int val );
HYPRE_Int
hypre_BoxGrowByValue_long_dbl( hypre_Box *box, HYPRE_Int val );

HYPRE_Int
hypre_BoxInBox_flt( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_BoxInBox_dbl( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_BoxInBox_long_dbl( hypre_Box *box1, hypre_Box *box2 );

HYPRE_Int
hypre_BoxIndexRank_flt( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxIndexRank_dbl( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxIndexRank_long_dbl( hypre_Box *box, hypre_Index index );

HYPRE_Int
hypre_BoxInit_flt( hypre_Box *box, HYPRE_Int ndim );
HYPRE_Int
hypre_BoxInit_dbl( hypre_Box *box, HYPRE_Int ndim );
HYPRE_Int
hypre_BoxInit_long_dbl( hypre_Box *box, HYPRE_Int ndim );

HYPRE_Int
hypre_BoxManAddEntry_flt( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax, HYPRE_Int proc_id, HYPRE_Int box_id, void *info );
HYPRE_Int
hypre_BoxManAddEntry_dbl( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax, HYPRE_Int proc_id, HYPRE_Int box_id, void *info );
HYPRE_Int
hypre_BoxManAddEntry_long_dbl( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax, HYPRE_Int proc_id, HYPRE_Int box_id, void *info );

HYPRE_Int
hypre_BoxManAssemble_flt( hypre_BoxManager *manager );
HYPRE_Int
hypre_BoxManAssemble_dbl( hypre_BoxManager *manager );
HYPRE_Int
hypre_BoxManAssemble_long_dbl( hypre_BoxManager *manager );

HYPRE_Int
hypre_BoxManCreate_flt( HYPRE_Int max_nentries, HYPRE_Int info_size, HYPRE_Int dim, hypre_Box *bounding_box, MPI_Comm comm, hypre_BoxManager **manager_ptr );
HYPRE_Int
hypre_BoxManCreate_dbl( HYPRE_Int max_nentries, HYPRE_Int info_size, HYPRE_Int dim, hypre_Box *bounding_box, MPI_Comm comm, hypre_BoxManager **manager_ptr );
HYPRE_Int
hypre_BoxManCreate_long_dbl( HYPRE_Int max_nentries, HYPRE_Int info_size, HYPRE_Int dim, hypre_Box *bounding_box, MPI_Comm comm, hypre_BoxManager **manager_ptr );

HYPRE_Int
hypre_BoxManDeleteMultipleEntriesAndInfo_flt( hypre_BoxManager *manager, HYPRE_Int *indices, HYPRE_Int num );
HYPRE_Int
hypre_BoxManDeleteMultipleEntriesAndInfo_dbl( hypre_BoxManager *manager, HYPRE_Int *indices, HYPRE_Int num );
HYPRE_Int
hypre_BoxManDeleteMultipleEntriesAndInfo_long_dbl( hypre_BoxManager *manager, HYPRE_Int *indices, HYPRE_Int num );

HYPRE_Int
hypre_BoxManDestroy_flt( hypre_BoxManager *manager );
HYPRE_Int
hypre_BoxManDestroy_dbl( hypre_BoxManager *manager );
HYPRE_Int
hypre_BoxManDestroy_long_dbl( hypre_BoxManager *manager );

HYPRE_Int
hypre_BoxManEntryCopy_flt( hypre_BoxManEntry *fromentry, hypre_BoxManEntry *toentry );
HYPRE_Int
hypre_BoxManEntryCopy_dbl( hypre_BoxManEntry *fromentry, hypre_BoxManEntry *toentry );
HYPRE_Int
hypre_BoxManEntryCopy_long_dbl( hypre_BoxManEntry *fromentry, hypre_BoxManEntry *toentry );

HYPRE_Int
hypre_BoxManEntryGetExtents_flt( hypre_BoxManEntry *entry, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxManEntryGetExtents_dbl( hypre_BoxManEntry *entry, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxManEntryGetExtents_long_dbl( hypre_BoxManEntry *entry, hypre_Index imin, hypre_Index imax );

HYPRE_Int
hypre_BoxManEntryGetInfo_flt( hypre_BoxManEntry *entry, void **info_ptr );
HYPRE_Int
hypre_BoxManEntryGetInfo_dbl( hypre_BoxManEntry *entry, void **info_ptr );
HYPRE_Int
hypre_BoxManEntryGetInfo_long_dbl( hypre_BoxManEntry *entry, void **info_ptr );

HYPRE_Int
hypre_BoxManEntryGetStride_flt( hypre_BoxManEntry *entry, hypre_Index stride );
HYPRE_Int
hypre_BoxManEntryGetStride_dbl( hypre_BoxManEntry *entry, hypre_Index stride );
HYPRE_Int
hypre_BoxManEntryGetStride_long_dbl( hypre_BoxManEntry *entry, hypre_Index stride );

HYPRE_Int
hypre_BoxManGatherEntries_flt( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxManGatherEntries_dbl( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxManGatherEntries_long_dbl( hypre_BoxManager *manager, hypre_Index imin, hypre_Index imax );

HYPRE_Int
hypre_BoxManGetAllEntries_flt( hypre_BoxManager *manager, HYPRE_Int *num_entries, hypre_BoxManEntry **entries );
HYPRE_Int
hypre_BoxManGetAllEntries_dbl( hypre_BoxManager *manager, HYPRE_Int *num_entries, hypre_BoxManEntry **entries );
HYPRE_Int
hypre_BoxManGetAllEntries_long_dbl( hypre_BoxManager *manager, HYPRE_Int *num_entries, hypre_BoxManEntry **entries );

HYPRE_Int
hypre_BoxManGetAllEntriesBoxes_flt( hypre_BoxManager *manager, hypre_BoxArray *boxes );
HYPRE_Int
hypre_BoxManGetAllEntriesBoxes_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes );
HYPRE_Int
hypre_BoxManGetAllEntriesBoxes_long_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes );

HYPRE_Int
hypre_BoxManGetAllEntriesBoxesProc_flt( hypre_BoxManager *manager, hypre_BoxArray *boxes, HYPRE_Int **procs_ptr );
HYPRE_Int
hypre_BoxManGetAllEntriesBoxesProc_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes, HYPRE_Int **procs_ptr );
HYPRE_Int
hypre_BoxManGetAllEntriesBoxesProc_long_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes, HYPRE_Int **procs_ptr );

HYPRE_Int
hypre_BoxManGetAllGlobalKnown_flt( hypre_BoxManager *manager, HYPRE_Int *known );
HYPRE_Int
hypre_BoxManGetAllGlobalKnown_dbl( hypre_BoxManager *manager, HYPRE_Int *known );
HYPRE_Int
hypre_BoxManGetAllGlobalKnown_long_dbl( hypre_BoxManager *manager, HYPRE_Int *known );

HYPRE_Int
hypre_BoxManGetAssumedPartition_flt( hypre_BoxManager *manager, hypre_StructAssumedPart **assumed_partition );
HYPRE_Int
hypre_BoxManGetAssumedPartition_dbl( hypre_BoxManager *manager, hypre_StructAssumedPart **assumed_partition );
HYPRE_Int
hypre_BoxManGetAssumedPartition_long_dbl( hypre_BoxManager *manager, hypre_StructAssumedPart **assumed_partition );

HYPRE_Int
hypre_BoxManGetEntry_flt( hypre_BoxManager *manager, HYPRE_Int proc, HYPRE_Int id, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_BoxManGetEntry_dbl( hypre_BoxManager *manager, HYPRE_Int proc, HYPRE_Int id, hypre_BoxManEntry **entry_ptr );
HYPRE_Int
hypre_BoxManGetEntry_long_dbl( hypre_BoxManager *manager, HYPRE_Int proc, HYPRE_Int id, hypre_BoxManEntry **entry_ptr );

HYPRE_Int
hypre_BoxManGetGlobalIsGatherCalled_flt( hypre_BoxManager *manager, MPI_Comm comm, HYPRE_Int *is_gather );
HYPRE_Int
hypre_BoxManGetGlobalIsGatherCalled_dbl( hypre_BoxManager *manager, MPI_Comm comm, HYPRE_Int *is_gather );
HYPRE_Int
hypre_BoxManGetGlobalIsGatherCalled_long_dbl( hypre_BoxManager *manager, MPI_Comm comm, HYPRE_Int *is_gather );

HYPRE_Int
hypre_BoxManGetIsEntriesSort_flt( hypre_BoxManager *manager, HYPRE_Int *is_sort );
HYPRE_Int
hypre_BoxManGetIsEntriesSort_dbl( hypre_BoxManager *manager, HYPRE_Int *is_sort );
HYPRE_Int
hypre_BoxManGetIsEntriesSort_long_dbl( hypre_BoxManager *manager, HYPRE_Int *is_sort );

HYPRE_Int
hypre_BoxManGetLocalEntriesBoxes_flt( hypre_BoxManager *manager, hypre_BoxArray *boxes );
HYPRE_Int
hypre_BoxManGetLocalEntriesBoxes_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes );
HYPRE_Int
hypre_BoxManGetLocalEntriesBoxes_long_dbl( hypre_BoxManager *manager, hypre_BoxArray *boxes );

HYPRE_Int
hypre_BoxManIncSize_flt( hypre_BoxManager *manager, HYPRE_Int inc_size );
HYPRE_Int
hypre_BoxManIncSize_dbl( hypre_BoxManager *manager, HYPRE_Int inc_size );
HYPRE_Int
hypre_BoxManIncSize_long_dbl( hypre_BoxManager *manager, HYPRE_Int inc_size );

HYPRE_Int
hypre_BoxManIntersect_flt( hypre_BoxManager *manager, hypre_Index ilower, hypre_Index iupper, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );
HYPRE_Int
hypre_BoxManIntersect_dbl( hypre_BoxManager *manager, hypre_Index ilower, hypre_Index iupper, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );
HYPRE_Int
hypre_BoxManIntersect_long_dbl( hypre_BoxManager *manager, hypre_Index ilower, hypre_Index iupper, hypre_BoxManEntry ***entries_ptr, HYPRE_Int *nentries_ptr );

HYPRE_Int
hypre_BoxManSetAllGlobalKnown_flt( hypre_BoxManager *manager, HYPRE_Int known );
HYPRE_Int
hypre_BoxManSetAllGlobalKnown_dbl( hypre_BoxManager *manager, HYPRE_Int known );
HYPRE_Int
hypre_BoxManSetAllGlobalKnown_long_dbl( hypre_BoxManager *manager, HYPRE_Int known );

HYPRE_Int
hypre_BoxManSetAssumedPartition_flt( hypre_BoxManager *manager, hypre_StructAssumedPart *assumed_partition );
HYPRE_Int
hypre_BoxManSetAssumedPartition_dbl( hypre_BoxManager *manager, hypre_StructAssumedPart *assumed_partition );
HYPRE_Int
hypre_BoxManSetAssumedPartition_long_dbl( hypre_BoxManager *manager, hypre_StructAssumedPart *assumed_partition );

HYPRE_Int
hypre_BoxManSetBoundingBox_flt( hypre_BoxManager *manager, hypre_Box *bounding_box );
HYPRE_Int
hypre_BoxManSetBoundingBox_dbl( hypre_BoxManager *manager, hypre_Box *bounding_box );
HYPRE_Int
hypre_BoxManSetBoundingBox_long_dbl( hypre_BoxManager *manager, hypre_Box *bounding_box );

HYPRE_Int
hypre_BoxManSetIsEntriesSort_flt( hypre_BoxManager *manager, HYPRE_Int is_sort );
HYPRE_Int
hypre_BoxManSetIsEntriesSort_dbl( hypre_BoxManager *manager, HYPRE_Int is_sort );
HYPRE_Int
hypre_BoxManSetIsEntriesSort_long_dbl( hypre_BoxManager *manager, HYPRE_Int is_sort );

HYPRE_Int
hypre_BoxManSetNumGhost_flt( hypre_BoxManager *manager, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_BoxManSetNumGhost_dbl( hypre_BoxManager *manager, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_BoxManSetNumGhost_long_dbl( hypre_BoxManager *manager, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_BoxMaxSize_flt( hypre_Box *box );
HYPRE_Int
hypre_BoxMaxSize_dbl( hypre_Box *box );
HYPRE_Int
hypre_BoxMaxSize_long_dbl( hypre_Box *box );

HYPRE_Int
hypre_BoxNnodes_flt( hypre_Box *box );
HYPRE_Int
hypre_BoxNnodes_dbl( hypre_Box *box );
HYPRE_Int
hypre_BoxNnodes_long_dbl( hypre_Box *box );

HYPRE_Int
hypre_BoxOffsetDistance_flt( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxOffsetDistance_dbl( hypre_Box *box, hypre_Index index );
HYPRE_Int
hypre_BoxOffsetDistance_long_dbl( hypre_Box *box, hypre_Index index );

HYPRE_Int
hypre_BoxPartialVolume_flt( hypre_Box *box, hypre_Index partial_volume );
HYPRE_Int
hypre_BoxPartialVolume_dbl( hypre_Box *box, hypre_Index partial_volume );
HYPRE_Int
hypre_BoxPartialVolume_long_dbl( hypre_Box *box, hypre_Index partial_volume );

HYPRE_Int
hypre_BoxPrint_flt( FILE *file, hypre_Box *box );
HYPRE_Int
hypre_BoxPrint_dbl( FILE *file, hypre_Box *box );
HYPRE_Int
hypre_BoxPrint_long_dbl( FILE *file, hypre_Box *box );

HYPRE_Int
hypre_BoxPrintDebug_flt( const char *prefix, hypre_Box *box );
HYPRE_Int
hypre_BoxPrintDebug_dbl( const char *prefix, hypre_Box *box );
HYPRE_Int
hypre_BoxPrintDebug_long_dbl( const char *prefix, hypre_Box *box );

HYPRE_Int
hypre_BoxRankIndex_flt( hypre_Box *box, HYPRE_Int rank, hypre_Index index );
HYPRE_Int
hypre_BoxRankIndex_dbl( hypre_Box *box, HYPRE_Int rank, hypre_Index index );
HYPRE_Int
hypre_BoxRankIndex_long_dbl( hypre_Box *box, HYPRE_Int rank, hypre_Index index );

HYPRE_Int
hypre_BoxRead_flt( FILE *file, HYPRE_Int ndim, hypre_Box **box_ptr );
HYPRE_Int
hypre_BoxRead_dbl( FILE *file, HYPRE_Int ndim, hypre_Box **box_ptr );
HYPRE_Int
hypre_BoxRead_long_dbl( FILE *file, HYPRE_Int ndim, hypre_Box **box_ptr );

HYPRE_Int
hypre_BoxSetExtents_flt( hypre_Box *box, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxSetExtents_dbl( hypre_Box *box, hypre_Index imin, hypre_Index imax );
HYPRE_Int
hypre_BoxSetExtents_long_dbl( hypre_Box *box, hypre_Index imin, hypre_Index imax );

HYPRE_Int
hypre_BoxShiftNeg_flt( hypre_Box *box, hypre_Index shift );
HYPRE_Int
hypre_BoxShiftNeg_dbl( hypre_Box *box, hypre_Index shift );
HYPRE_Int
hypre_BoxShiftNeg_long_dbl( hypre_Box *box, hypre_Index shift );

HYPRE_Int
hypre_BoxShiftPos_flt( hypre_Box *box, hypre_Index shift );
HYPRE_Int
hypre_BoxShiftPos_dbl( hypre_Box *box, hypre_Index shift );
HYPRE_Int
hypre_BoxShiftPos_long_dbl( hypre_Box *box, hypre_Index shift );

HYPRE_Int
hypre_BoxSplit_flt( hypre_Box *box, hypre_Index index, hypre_Box **lbox_ptr, hypre_Box **rbox_ptr );
HYPRE_Int
hypre_BoxSplit_dbl( hypre_Box *box, hypre_Index index, hypre_Box **lbox_ptr, hypre_Box **rbox_ptr );
HYPRE_Int
hypre_BoxSplit_long_dbl( hypre_Box *box, hypre_Index index, hypre_Box **lbox_ptr, hypre_Box **rbox_ptr );

HYPRE_Int
hypre_BoxStrideVolume_flt( hypre_Box *box, hypre_Index stride );
HYPRE_Int
hypre_BoxStrideVolume_dbl( hypre_Box *box, hypre_Index stride );
HYPRE_Int
hypre_BoxStrideVolume_long_dbl( hypre_Box *box, hypre_Index stride );

HYPRE_Int
hypre_BoxVolume_flt( hypre_Box *box );
HYPRE_Int
hypre_BoxVolume_dbl( hypre_Box *box );
HYPRE_Int
hypre_BoxVolume_long_dbl( hypre_Box *box );

HYPRE_Int
hypre_BoxesEqual_flt( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_BoxesEqual_dbl( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_BoxesEqual_long_dbl( hypre_Box *box1, hypre_Box *box2 );

HYPRE_Int
hypre_CoarsenBox_flt( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBox_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBox_long_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_CoarsenBoxArray_flt( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBoxArray_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBoxArray_long_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_CoarsenBoxArrayArray_flt( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBoxArrayArray_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_CoarsenBoxArrayArray_long_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_CoarsenBoxArrayArrayOutward_flt( hypre_BoxArrayArray *boxaa, hypre_BoxArray *refboxa, hypre_IndexRef origin, hypre_Index stride, hypre_BoxArrayArray **new_boxaa_ptr );
HYPRE_Int
hypre_CoarsenBoxArrayArrayOutward_dbl( hypre_BoxArrayArray *boxaa, hypre_BoxArray *refboxa, hypre_IndexRef origin, hypre_Index stride, hypre_BoxArrayArray **new_boxaa_ptr );
HYPRE_Int
hypre_CoarsenBoxArrayArrayOutward_long_dbl( hypre_BoxArrayArray *boxaa, hypre_BoxArray *refboxa, hypre_IndexRef origin, hypre_Index stride, hypre_BoxArrayArray **new_boxaa_ptr );

HYPRE_Int
hypre_CommBlockSetEntries_flt( hypre_CommBlock *comm_block, HYPRE_Int *boxnums, hypre_Box *boxes, HYPRE_Int *orders, hypre_Index stride, hypre_BoxArray *data_space, HYPRE_Int *data_offsets );
HYPRE_Int
hypre_CommBlockSetEntries_dbl( hypre_CommBlock *comm_block, HYPRE_Int *boxnums, hypre_Box *boxes, HYPRE_Int *orders, hypre_Index stride, hypre_BoxArray *data_space, HYPRE_Int *data_offsets );
HYPRE_Int
hypre_CommBlockSetEntries_long_dbl( hypre_CommBlock *comm_block, HYPRE_Int *boxnums, hypre_Box *boxes, HYPRE_Int *orders, hypre_Index stride, hypre_BoxArray *data_space, HYPRE_Int *data_offsets );

HYPRE_Int
hypre_CommBlockSetEntry_flt( hypre_CommBlock *comm_block, HYPRE_Int comm_num, hypre_Box *box, hypre_Index stride, hypre_Index coord, hypre_Index dir, HYPRE_Int *order, HYPRE_Int *rem_order, hypre_Box *data_box, HYPRE_Int data_box_offset );
HYPRE_Int
hypre_CommBlockSetEntry_dbl( hypre_CommBlock *comm_block, HYPRE_Int comm_num, hypre_Box *box, hypre_Index stride, hypre_Index coord, hypre_Index dir, HYPRE_Int *order, HYPRE_Int *rem_order, hypre_Box *data_box, HYPRE_Int data_box_offset );
HYPRE_Int
hypre_CommBlockSetEntry_long_dbl( hypre_CommBlock *comm_block, HYPRE_Int comm_num, hypre_Box *box, hypre_Index stride, hypre_Index coord, hypre_Index dir, HYPRE_Int *order, HYPRE_Int *rem_order, hypre_Box *data_box, HYPRE_Int data_box_offset );

HYPRE_Int
hypre_CommInfoClone_flt( hypre_CommInfo *comm_info, hypre_CommInfo **clone_ptr );
HYPRE_Int
hypre_CommInfoClone_dbl( hypre_CommInfo *comm_info, hypre_CommInfo **clone_ptr );
HYPRE_Int
hypre_CommInfoClone_long_dbl( hypre_CommInfo *comm_info, hypre_CommInfo **clone_ptr );

HYPRE_Int
hypre_CommInfoCoarsen_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsen_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsen_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoCoarsenRecv_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsenRecv_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsenRecv_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoCoarsenSend_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsenSend_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoCoarsenSend_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoCreate_flt( hypre_BoxArrayArray *send_boxes, hypre_BoxArrayArray *recv_boxes, HYPRE_Int **send_procs, HYPRE_Int **recv_procs, HYPRE_Int **send_rboxnums, HYPRE_Int **recv_rboxnums, hypre_BoxArrayArray *send_rboxes, hypre_BoxArrayArray *recv_rboxes, HYPRE_Int boxes_match, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CommInfoCreate_dbl( hypre_BoxArrayArray *send_boxes, hypre_BoxArrayArray *recv_boxes, HYPRE_Int **send_procs, HYPRE_Int **recv_procs, HYPRE_Int **send_rboxnums, HYPRE_Int **recv_rboxnums, hypre_BoxArrayArray *send_rboxes, hypre_BoxArrayArray *recv_rboxes, HYPRE_Int boxes_match, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CommInfoCreate_long_dbl( hypre_BoxArrayArray *send_boxes, hypre_BoxArrayArray *recv_boxes, HYPRE_Int **send_procs, HYPRE_Int **recv_procs, HYPRE_Int **send_rboxnums, HYPRE_Int **recv_rboxnums, hypre_BoxArrayArray *send_rboxes, hypre_BoxArrayArray *recv_rboxes, HYPRE_Int boxes_match, hypre_CommInfo **comm_info_ptr );

HYPRE_Int
hypre_CommInfoDestroy_flt( hypre_CommInfo *comm_info );
HYPRE_Int
hypre_CommInfoDestroy_dbl( hypre_CommInfo *comm_info );
HYPRE_Int
hypre_CommInfoDestroy_long_dbl( hypre_CommInfo *comm_info );

HYPRE_Int
hypre_CommInfoGetTransforms_flt( hypre_CommInfo *comm_info, HYPRE_Int *num_transforms, hypre_Index **coords, hypre_Index **dirs );
HYPRE_Int
hypre_CommInfoGetTransforms_dbl( hypre_CommInfo *comm_info, HYPRE_Int *num_transforms, hypre_Index **coords, hypre_Index **dirs );
HYPRE_Int
hypre_CommInfoGetTransforms_long_dbl( hypre_CommInfo *comm_info, HYPRE_Int *num_transforms, hypre_Index **coords, hypre_Index **dirs );

HYPRE_Int
hypre_CommInfoProjectRecv_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoProjectRecv_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoProjectRecv_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoProjectSend_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoProjectSend_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoProjectSend_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoRefine_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefine_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefine_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoRefineRecv_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefineRecv_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefineRecv_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoRefineSend_flt( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefineSend_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_CommInfoRefineSend_long_dbl( hypre_CommInfo *comm_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_CommInfoSetTransforms_flt( hypre_CommInfo *comm_info, HYPRE_Int num_transforms, hypre_Index *coords, hypre_Index *dirs, HYPRE_Int **send_transforms, HYPRE_Int **recv_transforms );
HYPRE_Int
hypre_CommInfoSetTransforms_dbl( hypre_CommInfo *comm_info, HYPRE_Int num_transforms, hypre_Index *coords, hypre_Index *dirs, HYPRE_Int **send_transforms, HYPRE_Int **recv_transforms );
HYPRE_Int
hypre_CommInfoSetTransforms_long_dbl( hypre_CommInfo *comm_info, HYPRE_Int num_transforms, hypre_Index *coords, hypre_Index *dirs, HYPRE_Int **send_transforms, HYPRE_Int **recv_transforms );

HYPRE_Int
hypre_CommPkgAgglomData_flt( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_float ***comm_data_a, hypre_CommPkg *comm_pkg, hypre_float ***agg_comm_data_ptr );
HYPRE_Int
hypre_CommPkgAgglomData_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_double ***comm_data_a, hypre_CommPkg *comm_pkg, hypre_double ***agg_comm_data_ptr );
HYPRE_Int
hypre_CommPkgAgglomData_long_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_long_double ***comm_data_a, hypre_CommPkg *comm_pkg, hypre_long_double ***agg_comm_data_ptr );

HYPRE_Int
hypre_CommPkgAgglomDestroy_flt( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_float ***comm_data_a );
HYPRE_Int
hypre_CommPkgAgglomDestroy_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_double ***comm_data_a );
HYPRE_Int
hypre_CommPkgAgglomDestroy_long_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkg_a, hypre_long_double ***comm_data_a );

HYPRE_Int
hypre_CommPkgAgglomerate_flt( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkgs, hypre_CommPkg **agg_comm_pkg_ptr );
HYPRE_Int
hypre_CommPkgAgglomerate_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkgs, hypre_CommPkg **agg_comm_pkg_ptr );
HYPRE_Int
hypre_CommPkgAgglomerate_long_dbl( HYPRE_Int num_comm_pkgs, hypre_CommPkg **comm_pkgs, hypre_CommPkg **agg_comm_pkg_ptr );

HYPRE_Int
hypre_CommPkgCreate_flt( hypre_CommInfo *comm_info, hypre_BoxArray *send_data_space, hypre_BoxArray *recv_data_space, HYPRE_Int num_values, HYPRE_Int **orders, HYPRE_Int reverse, MPI_Comm comm, HYPRE_MemoryLocation memory_location, hypre_CommPkg **comm_pkg_ptr );
HYPRE_Int
hypre_CommPkgCreate_dbl( hypre_CommInfo *comm_info, hypre_BoxArray *send_data_space, hypre_BoxArray *recv_data_space, HYPRE_Int num_values, HYPRE_Int **orders, HYPRE_Int reverse, MPI_Comm comm, HYPRE_MemoryLocation memory_location, hypre_CommPkg **comm_pkg_ptr );
HYPRE_Int
hypre_CommPkgCreate_long_dbl( hypre_CommInfo *comm_info, hypre_BoxArray *send_data_space, hypre_BoxArray *recv_data_space, HYPRE_Int num_values, HYPRE_Int **orders, HYPRE_Int reverse, MPI_Comm comm, HYPRE_MemoryLocation memory_location, hypre_CommPkg **comm_pkg_ptr );

HYPRE_Int
hypre_CommPkgDestroy_flt( hypre_CommPkg *comm_pkg );
HYPRE_Int
hypre_CommPkgDestroy_dbl( hypre_CommPkg *comm_pkg );
HYPRE_Int
hypre_CommPkgDestroy_long_dbl( hypre_CommPkg *comm_pkg );

HYPRE_Int
hypre_CommPkgSetPrefixSizes_flt( hypre_CommPkg *comm_pkg );
HYPRE_Int
hypre_CommPkgSetPrefixSizes_dbl( hypre_CommPkg *comm_pkg );
HYPRE_Int
hypre_CommPkgSetPrefixSizes_long_dbl( hypre_CommPkg *comm_pkg );

hypre_CommStencil *
hypre_CommStencilCreate_flt( HYPRE_Int ndim );
hypre_CommStencil *
hypre_CommStencilCreate_dbl( HYPRE_Int ndim );
hypre_CommStencil *
hypre_CommStencilCreate_long_dbl( HYPRE_Int ndim );

HYPRE_Int
hypre_CommStencilCreateNumGhost_flt( hypre_CommStencil *comm_stencil, HYPRE_Int **num_ghost_ptr );
HYPRE_Int
hypre_CommStencilCreateNumGhost_dbl( hypre_CommStencil *comm_stencil, HYPRE_Int **num_ghost_ptr );
HYPRE_Int
hypre_CommStencilCreateNumGhost_long_dbl( hypre_CommStencil *comm_stencil, HYPRE_Int **num_ghost_ptr );

HYPRE_Int
hypre_CommStencilDestroy_flt( hypre_CommStencil *comm_stencil );
HYPRE_Int
hypre_CommStencilDestroy_dbl( hypre_CommStencil *comm_stencil );
HYPRE_Int
hypre_CommStencilDestroy_long_dbl( hypre_CommStencil *comm_stencil );

HYPRE_Int
hypre_CommStencilSetEntry_flt( hypre_CommStencil *comm_stencil, hypre_Index offset );
HYPRE_Int
hypre_CommStencilSetEntry_dbl( hypre_CommStencil *comm_stencil, hypre_Index offset );
HYPRE_Int
hypre_CommStencilSetEntry_long_dbl( hypre_CommStencil *comm_stencil, hypre_Index offset );

HYPRE_Int
hypre_ComputeBoxnums_flt( hypre_BoxArray *boxes, HYPRE_Int *procs, HYPRE_Int **boxnums_ptr );
HYPRE_Int
hypre_ComputeBoxnums_dbl( hypre_BoxArray *boxes, HYPRE_Int *procs, HYPRE_Int **boxnums_ptr );
HYPRE_Int
hypre_ComputeBoxnums_long_dbl( hypre_BoxArray *boxes, HYPRE_Int *procs, HYPRE_Int **boxnums_ptr );

HYPRE_Int
hypre_ComputeCoarseOriginStride_flt( hypre_Index coarse_origin, hypre_Index coarse_stride, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_ComputeCoarseOriginStride_dbl( hypre_Index coarse_origin, hypre_Index coarse_stride, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_ComputeCoarseOriginStride_long_dbl( hypre_Index coarse_origin, hypre_Index coarse_stride, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_ComputeInfoCreate_flt( hypre_CommInfo *comm_info, hypre_BoxArrayArray *indt_boxes, hypre_BoxArrayArray *dept_boxes, hypre_ComputeInfo **compute_info_ptr );
HYPRE_Int
hypre_ComputeInfoCreate_dbl( hypre_CommInfo *comm_info, hypre_BoxArrayArray *indt_boxes, hypre_BoxArrayArray *dept_boxes, hypre_ComputeInfo **compute_info_ptr );
HYPRE_Int
hypre_ComputeInfoCreate_long_dbl( hypre_CommInfo *comm_info, hypre_BoxArrayArray *indt_boxes, hypre_BoxArrayArray *dept_boxes, hypre_ComputeInfo **compute_info_ptr );

HYPRE_Int
hypre_ComputeInfoDestroy_flt( hypre_ComputeInfo *compute_info );
HYPRE_Int
hypre_ComputeInfoDestroy_dbl( hypre_ComputeInfo *compute_info );
HYPRE_Int
hypre_ComputeInfoDestroy_long_dbl( hypre_ComputeInfo *compute_info );

HYPRE_Int
hypre_ComputeInfoProjectComp_flt( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectComp_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectComp_long_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_ComputeInfoProjectRecv_flt( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectRecv_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectRecv_long_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_ComputeInfoProjectSend_flt( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectSend_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );
HYPRE_Int
hypre_ComputeInfoProjectSend_long_dbl( hypre_ComputeInfo *compute_info, hypre_Index index, hypre_Index stride );

HYPRE_Int
hypre_ComputePkgCreate_flt( HYPRE_MemoryLocation memory_location, hypre_ComputeInfo *compute_info, hypre_BoxArray *data_space, HYPRE_Int num_values, hypre_StructGrid *grid, hypre_ComputePkg **compute_pkg_ptr );
HYPRE_Int
hypre_ComputePkgCreate_dbl( HYPRE_MemoryLocation memory_location, hypre_ComputeInfo *compute_info, hypre_BoxArray *data_space, HYPRE_Int num_values, hypre_StructGrid *grid, hypre_ComputePkg **compute_pkg_ptr );
HYPRE_Int
hypre_ComputePkgCreate_long_dbl( HYPRE_MemoryLocation memory_location, hypre_ComputeInfo *compute_info, hypre_BoxArray *data_space, HYPRE_Int num_values, hypre_StructGrid *grid, hypre_ComputePkg **compute_pkg_ptr );

HYPRE_Int
hypre_ComputePkgDestroy_flt( hypre_ComputePkg *compute_pkg );
HYPRE_Int
hypre_ComputePkgDestroy_dbl( hypre_ComputePkg *compute_pkg );
HYPRE_Int
hypre_ComputePkgDestroy_long_dbl( hypre_ComputePkg *compute_pkg );

HYPRE_Int
hypre_ConvertToCanonicalIndex_flt( hypre_Index index, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_ConvertToCanonicalIndex_dbl( hypre_Index index, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_ConvertToCanonicalIndex_long_dbl( hypre_Index index, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_CopyBox_flt( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_CopyBox_dbl( hypre_Box *box1, hypre_Box *box2 );
HYPRE_Int
hypre_CopyBox_long_dbl( hypre_Box *box1, hypre_Box *box2 );

HYPRE_Int
hypre_CopyIndex_flt( hypre_Index in_index, hypre_Index out_index );
HYPRE_Int
hypre_CopyIndex_dbl( hypre_Index in_index, hypre_Index out_index );
HYPRE_Int
hypre_CopyIndex_long_dbl( hypre_Index in_index, hypre_Index out_index );

HYPRE_Int
hypre_CopyToCleanIndex_flt( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );
HYPRE_Int
hypre_CopyToCleanIndex_dbl( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );
HYPRE_Int
hypre_CopyToCleanIndex_long_dbl( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );

HYPRE_Int
hypre_CopyToIndex_flt( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );
HYPRE_Int
hypre_CopyToIndex_dbl( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );
HYPRE_Int
hypre_CopyToIndex_long_dbl( hypre_Index in_index, HYPRE_Int ndim, hypre_Index out_index );

HYPRE_Int
hypre_CreateCommInfo_flt( hypre_StructGrid *bgrid, hypre_Index stride, hypre_CommStencil *comm_stencil, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfo_dbl( hypre_StructGrid *bgrid, hypre_Index stride, hypre_CommStencil *comm_stencil, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfo_long_dbl( hypre_StructGrid *bgrid, hypre_Index stride, hypre_CommStencil *comm_stencil, hypre_CommInfo **comm_info_ptr );

HYPRE_Int
hypre_CreateCommInfoFromGrids_flt( hypre_StructGrid *from_grid, hypre_StructGrid *to_grid, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromGrids_dbl( hypre_StructGrid *from_grid, hypre_StructGrid *to_grid, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromGrids_long_dbl( hypre_StructGrid *from_grid, hypre_StructGrid *to_grid, hypre_CommInfo **comm_info_ptr );

HYPRE_Int
hypre_CreateCommInfoFromNumGhost_flt( hypre_StructGrid *grid, hypre_Index stride, HYPRE_Int *num_ghost, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromNumGhost_dbl( hypre_StructGrid *grid, hypre_Index stride, HYPRE_Int *num_ghost, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromNumGhost_long_dbl( hypre_StructGrid *grid, hypre_Index stride, HYPRE_Int *num_ghost, hypre_CommInfo **comm_info_ptr );

HYPRE_Int
hypre_CreateCommInfoFromStencil_flt( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromStencil_dbl( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_CommInfo **comm_info_ptr );
HYPRE_Int
hypre_CreateCommInfoFromStencil_long_dbl( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_CommInfo **comm_info_ptr );

HYPRE_Int
hypre_CreateComputeInfo_flt( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_ComputeInfo **compute_info_ptr );
HYPRE_Int
hypre_CreateComputeInfo_dbl( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_ComputeInfo **compute_info_ptr );
HYPRE_Int
hypre_CreateComputeInfo_long_dbl( hypre_StructGrid *grid, hypre_Index stride, hypre_StructStencil *stencil, hypre_ComputeInfo **compute_info_ptr );

HYPRE_Int
hypre_DeleteBox_flt( hypre_BoxArray *box_array, HYPRE_Int index );
HYPRE_Int
hypre_DeleteBox_dbl( hypre_BoxArray *box_array, HYPRE_Int index );
HYPRE_Int
hypre_DeleteBox_long_dbl( hypre_BoxArray *box_array, HYPRE_Int index );

HYPRE_Int
hypre_DeleteMultipleBoxes_flt( hypre_BoxArray *box_array, HYPRE_Int *indices, HYPRE_Int num );
HYPRE_Int
hypre_DeleteMultipleBoxes_dbl( hypre_BoxArray *box_array, HYPRE_Int *indices, HYPRE_Int num );
HYPRE_Int
hypre_DeleteMultipleBoxes_long_dbl( hypre_BoxArray *box_array, HYPRE_Int *indices, HYPRE_Int num );

HYPRE_Int
hypre_ExchangeLocalData_flt( hypre_CommPkg *comm_pkg, hypre_float **send_data, hypre_float **recv_data, HYPRE_Int action );
HYPRE_Int
hypre_ExchangeLocalData_dbl( hypre_CommPkg *comm_pkg, hypre_double **send_data, hypre_double **recv_data, HYPRE_Int action );
HYPRE_Int
hypre_ExchangeLocalData_long_dbl( hypre_CommPkg *comm_pkg, hypre_long_double **send_data, hypre_long_double **recv_data, HYPRE_Int action );

HYPRE_Int
hypre_FillResponseBoxManAssemble1_flt( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_FillResponseBoxManAssemble1_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_FillResponseBoxManAssemble1_long_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );

HYPRE_Int
hypre_FillResponseBoxManAssemble2_flt( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_FillResponseBoxManAssemble2_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );
HYPRE_Int
hypre_FillResponseBoxManAssemble2_long_dbl( void *p_recv_contact_buf, HYPRE_Int contact_size, HYPRE_Int contact_proc, void *ro, MPI_Comm comm, void **p_send_response_buf, HYPRE_Int *response_message_size );

HYPRE_Int
hypre_FinalizeIndtComputations_flt( hypre_CommHandle *comm_handle );
HYPRE_Int
hypre_FinalizeIndtComputations_dbl( hypre_CommHandle *comm_handle );
HYPRE_Int
hypre_FinalizeIndtComputations_long_dbl( hypre_CommHandle *comm_handle );

HYPRE_Int
hypre_GatherAllBoxes_flt( MPI_Comm comm, hypre_BoxArray *boxes, HYPRE_Int dim, hypre_BoxArray **all_boxes_ptr, HYPRE_Int **all_procs_ptr, HYPRE_Int *first_local_ptr );
HYPRE_Int
hypre_GatherAllBoxes_dbl( MPI_Comm comm, hypre_BoxArray *boxes, HYPRE_Int dim, hypre_BoxArray **all_boxes_ptr, HYPRE_Int **all_procs_ptr, HYPRE_Int *first_local_ptr );
HYPRE_Int
hypre_GatherAllBoxes_long_dbl( MPI_Comm comm, hypre_BoxArray *boxes, HYPRE_Int dim, hypre_BoxArray **all_boxes_ptr, HYPRE_Int **all_procs_ptr, HYPRE_Int *first_local_ptr );

HYPRE_Int
hypre_GeneralBoxBoundaryIntersect_flt( hypre_Box *box, hypre_StructGrid *grid, hypre_Index stencil_offset, hypre_BoxArray *boundary );
HYPRE_Int
hypre_GeneralBoxBoundaryIntersect_dbl( hypre_Box *box, hypre_StructGrid *grid, hypre_Index stencil_offset, hypre_BoxArray *boundary );
HYPRE_Int
hypre_GeneralBoxBoundaryIntersect_long_dbl( hypre_Box *box, hypre_StructGrid *grid, hypre_Index stencil_offset, hypre_BoxArray *boundary );

HYPRE_Int
hypre_IndexElementMult_flt( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexElementMult_dbl( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexElementMult_long_dbl( hypre_Index index, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexEqual_flt( hypre_Index index, HYPRE_Int val, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexEqual_dbl( hypre_Index index, HYPRE_Int val, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexEqual_long_dbl( hypre_Index index, HYPRE_Int val, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexInBox_flt( hypre_Index index, hypre_Box *box );
HYPRE_Int
hypre_IndexInBox_dbl( hypre_Index index, hypre_Box *box );
HYPRE_Int
hypre_IndexInBox_long_dbl( hypre_Index index, hypre_Box *box );

HYPRE_Int
hypre_IndexMax_flt( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexMax_dbl( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexMax_long_dbl( hypre_Index index, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexMin_flt( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexMin_dbl( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexMin_long_dbl( hypre_Index index, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexPrint_flt( FILE *file, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_IndexPrint_dbl( FILE *file, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_IndexPrint_long_dbl( FILE *file, HYPRE_Int ndim, hypre_Index index );

HYPRE_Int
hypre_IndexRead_flt( FILE *file, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_IndexRead_dbl( FILE *file, HYPRE_Int ndim, hypre_Index index );
HYPRE_Int
hypre_IndexRead_long_dbl( FILE *file, HYPRE_Int ndim, hypre_Index index );

HYPRE_Int
hypre_IndexesEqual_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesEqual_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesEqual_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexesGreater_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesGreater_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesGreater_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );

HYPRE_Int
hypre_IndexesGreaterEqual_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesGreaterEqual_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_IndexesGreaterEqual_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );

HYPRE_Int
hypre_InitializeIndtComputations_flt( hypre_ComputePkg *compute_pkg, hypre_float *data, hypre_CommHandle **comm_handle_ptr );
HYPRE_Int
hypre_InitializeIndtComputations_dbl( hypre_ComputePkg *compute_pkg, hypre_double *data, hypre_CommHandle **comm_handle_ptr );
HYPRE_Int
hypre_InitializeIndtComputations_long_dbl( hypre_ComputePkg *compute_pkg, hypre_long_double *data, hypre_CommHandle **comm_handle_ptr );

HYPRE_Int
hypre_IntersectBoxes_flt( hypre_Box *box1, hypre_Box *box2, hypre_Box *ibox );
HYPRE_Int
hypre_IntersectBoxes_dbl( hypre_Box *box1, hypre_Box *box2, hypre_Box *ibox );
HYPRE_Int
hypre_IntersectBoxes_long_dbl( hypre_Box *box1, hypre_Box *box2, hypre_Box *ibox );

HYPRE_Int
hypre_MapToCoarseIndex_flt( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_MapToCoarseIndex_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_MapToCoarseIndex_long_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_MapToFineIndex_flt( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_MapToFineIndex_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_MapToFineIndex_long_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_MinUnionBoxes_flt( hypre_BoxArray *boxes );
HYPRE_Int
hypre_MinUnionBoxes_dbl( hypre_BoxArray *boxes );
HYPRE_Int
hypre_MinUnionBoxes_long_dbl( hypre_BoxArray *boxes );

HYPRE_Int
hypre_PrintBoxArrayData_flt( FILE *file, HYPRE_Int dim, hypre_BoxArray *box_array, hypre_BoxArray *data_space, HYPRE_Int num_values, HYPRE_Int *value_ids, hypre_float *data );
HYPRE_Int
hypre_PrintBoxArrayData_dbl( FILE *file, HYPRE_Int dim, hypre_BoxArray *box_array, hypre_BoxArray *data_space, HYPRE_Int num_values, HYPRE_Int *value_ids, hypre_double *data );
HYPRE_Int
hypre_PrintBoxArrayData_long_dbl( FILE *file, HYPRE_Int dim, hypre_BoxArray *box_array, hypre_BoxArray *data_space, HYPRE_Int num_values, HYPRE_Int *value_ids, hypre_long_double *data );

HYPRE_Int
hypre_ProjectBox_flt( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBox_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBox_long_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_ProjectBoxArray_flt( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBoxArray_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBoxArray_long_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_ProjectBoxArrayArray_flt( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBoxArrayArray_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_ProjectBoxArrayArray_long_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_ReadBoxArrayData_flt( FILE *file, HYPRE_Int ndim, hypre_BoxArray *box_array, HYPRE_Int *num_values_ptr, HYPRE_Int **value_ids_ptr, hypre_float **values_ptr );
HYPRE_Int
hypre_ReadBoxArrayData_dbl( FILE *file, HYPRE_Int ndim, hypre_BoxArray *box_array, HYPRE_Int *num_values_ptr, HYPRE_Int **value_ids_ptr, hypre_double **values_ptr );
HYPRE_Int
hypre_ReadBoxArrayData_long_dbl( FILE *file, HYPRE_Int ndim, hypre_BoxArray *box_array, HYPRE_Int *num_values_ptr, HYPRE_Int **value_ids_ptr, hypre_long_double **values_ptr );

HYPRE_Int
hypre_RefineBox_flt( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBox_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBox_long_dbl( hypre_Box *box, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_RefineBoxArray_flt( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBoxArray_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBoxArray_long_dbl( hypre_BoxArray *box_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_RefineBoxArrayArray_flt( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBoxArrayArray_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );
HYPRE_Int
hypre_RefineBoxArrayArray_long_dbl( hypre_BoxArrayArray *box_array_array, hypre_IndexRef origin, hypre_Index stride );

HYPRE_Int
hypre_SetIndex_flt( hypre_Index index, HYPRE_Int val );
HYPRE_Int
hypre_SetIndex_dbl( hypre_Index index, HYPRE_Int val );
HYPRE_Int
hypre_SetIndex_long_dbl( hypre_Index index, HYPRE_Int val );

HYPRE_Int
hypre_SnapIndexNeg_flt( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_SnapIndexNeg_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_SnapIndexNeg_long_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_SnapIndexPos_flt( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_SnapIndexPos_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );
HYPRE_Int
hypre_SnapIndexPos_long_dbl( hypre_Index index, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int ndim );

HYPRE_Int
hypre_StCoeffClone_flt( hypre_StCoeff *coeff, HYPRE_Int ndim, hypre_StCoeff **clone_ptr );
HYPRE_Int
hypre_StCoeffClone_dbl( hypre_StCoeff *coeff, HYPRE_Int ndim, hypre_StCoeff **clone_ptr );
HYPRE_Int
hypre_StCoeffClone_long_dbl( hypre_StCoeff *coeff, HYPRE_Int ndim, hypre_StCoeff **clone_ptr );

HYPRE_Int
hypre_StCoeffCreate_flt( HYPRE_Int nterms, hypre_StCoeff **coeff_ptr );
HYPRE_Int
hypre_StCoeffCreate_dbl( HYPRE_Int nterms, hypre_StCoeff **coeff_ptr );
HYPRE_Int
hypre_StCoeffCreate_long_dbl( HYPRE_Int nterms, hypre_StCoeff **coeff_ptr );

HYPRE_Int
hypre_StCoeffDestroy_flt( hypre_StCoeff *coeff );
HYPRE_Int
hypre_StCoeffDestroy_dbl( hypre_StCoeff *coeff );
HYPRE_Int
hypre_StCoeffDestroy_long_dbl( hypre_StCoeff *coeff );

HYPRE_Int
hypre_StCoeffMult_flt( hypre_StCoeff *Acoeff, hypre_StCoeff *Bcoeff, HYPRE_Int ndim, hypre_StCoeff **Ccoeff_ptr );
HYPRE_Int
hypre_StCoeffMult_dbl( hypre_StCoeff *Acoeff, hypre_StCoeff *Bcoeff, HYPRE_Int ndim, hypre_StCoeff **Ccoeff_ptr );
HYPRE_Int
hypre_StCoeffMult_long_dbl( hypre_StCoeff *Acoeff, hypre_StCoeff *Bcoeff, HYPRE_Int ndim, hypre_StCoeff **Ccoeff_ptr );

HYPRE_Int
hypre_StCoeffPrint_flt( hypre_StCoeff *coeff, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StCoeffPrint_dbl( hypre_StCoeff *coeff, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StCoeffPrint_long_dbl( hypre_StCoeff *coeff, char *matnames, HYPRE_Int ndim );

HYPRE_Int
hypre_StCoeffPush_flt( hypre_StCoeff **stack_ptr, hypre_StCoeff *coeff );
HYPRE_Int
hypre_StCoeffPush_dbl( hypre_StCoeff **stack_ptr, hypre_StCoeff *coeff );
HYPRE_Int
hypre_StCoeffPush_long_dbl( hypre_StCoeff **stack_ptr, hypre_StCoeff *coeff );

HYPRE_Int
hypre_StCoeffShift_flt( hypre_StCoeff *coeff, hypre_Index shift, HYPRE_Int ndim );
HYPRE_Int
hypre_StCoeffShift_dbl( hypre_StCoeff *coeff, hypre_Index shift, HYPRE_Int ndim );
HYPRE_Int
hypre_StCoeffShift_long_dbl( hypre_StCoeff *coeff, hypre_Index shift, HYPRE_Int ndim );

HYPRE_Int
hypre_StIndexCopy_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexCopy_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexCopy_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim );

HYPRE_Int
hypre_StIndexNegate_flt( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexNegate_dbl( hypre_Index index, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexNegate_long_dbl( hypre_Index index, HYPRE_Int ndim );

HYPRE_Int
hypre_StIndexPrint_flt( hypre_Index index, char lchar, char rchar, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexPrint_dbl( hypre_Index index, char lchar, char rchar, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexPrint_long_dbl( hypre_Index index, char lchar, char rchar, HYPRE_Int ndim );

HYPRE_Int
hypre_StIndexShift_flt( hypre_Index index, hypre_Index shift, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexShift_dbl( hypre_Index index, hypre_Index shift, HYPRE_Int ndim );
HYPRE_Int
hypre_StIndexShift_long_dbl( hypre_Index index, hypre_Index shift, HYPRE_Int ndim );

HYPRE_Int
hypre_StMatrixClone_flt( hypre_StMatrix *matrix, HYPRE_Int ndim, hypre_StMatrix **mclone_ptr );
HYPRE_Int
hypre_StMatrixClone_dbl( hypre_StMatrix *matrix, HYPRE_Int ndim, hypre_StMatrix **mclone_ptr );
HYPRE_Int
hypre_StMatrixClone_long_dbl( hypre_StMatrix *matrix, HYPRE_Int ndim, hypre_StMatrix **mclone_ptr );

HYPRE_Int
hypre_StMatrixCreate_flt( HYPRE_Int id, HYPRE_Int size, HYPRE_Int ndim, hypre_StMatrix **matrix_ptr );
HYPRE_Int
hypre_StMatrixCreate_dbl( HYPRE_Int id, HYPRE_Int size, HYPRE_Int ndim, hypre_StMatrix **matrix_ptr );
HYPRE_Int
hypre_StMatrixCreate_long_dbl( HYPRE_Int id, HYPRE_Int size, HYPRE_Int ndim, hypre_StMatrix **matrix_ptr );

HYPRE_Int
hypre_StMatrixDestroy_flt( hypre_StMatrix *matrix );
HYPRE_Int
hypre_StMatrixDestroy_dbl( hypre_StMatrix *matrix );
HYPRE_Int
hypre_StMatrixDestroy_long_dbl( hypre_StMatrix *matrix );

HYPRE_Int
hypre_StMatrixMatmat_flt( hypre_StMatrix *A, hypre_StMatrix *B, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );
HYPRE_Int
hypre_StMatrixMatmat_dbl( hypre_StMatrix *A, hypre_StMatrix *B, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );
HYPRE_Int
hypre_StMatrixMatmat_long_dbl( hypre_StMatrix *A, hypre_StMatrix *B, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );

HYPRE_Int
hypre_StMatrixMatmult_flt( HYPRE_Int nmatrices, hypre_StMatrix **matrices, HYPRE_Int *transposes, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );
HYPRE_Int
hypre_StMatrixMatmult_dbl( HYPRE_Int nmatrices, hypre_StMatrix **matrices, HYPRE_Int *transposes, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );
HYPRE_Int
hypre_StMatrixMatmult_long_dbl( HYPRE_Int nmatrices, hypre_StMatrix **matrices, HYPRE_Int *transposes, HYPRE_Int Cid, HYPRE_Int ndim, hypre_StMatrix **C_ptr );

HYPRE_Int
hypre_StMatrixNEntryCoeffs_flt( hypre_StMatrix *matrix, HYPRE_Int entry );
HYPRE_Int
hypre_StMatrixNEntryCoeffs_dbl( hypre_StMatrix *matrix, HYPRE_Int entry );
HYPRE_Int
hypre_StMatrixNEntryCoeffs_long_dbl( hypre_StMatrix *matrix, HYPRE_Int entry );

HYPRE_Int
hypre_StMatrixPrint_flt( hypre_StMatrix *matrix, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StMatrixPrint_dbl( hypre_StMatrix *matrix, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StMatrixPrint_long_dbl( hypre_StMatrix *matrix, char *matnames, HYPRE_Int ndim );

HYPRE_Int
hypre_StMatrixTranspose_flt( hypre_StMatrix *matrix, HYPRE_Int ndim );
HYPRE_Int
hypre_StMatrixTranspose_dbl( hypre_StMatrix *matrix, HYPRE_Int ndim );
HYPRE_Int
hypre_StMatrixTranspose_long_dbl( hypre_StMatrix *matrix, HYPRE_Int ndim );

HYPRE_Int
hypre_StTermCopy_flt( hypre_StTerm *term1, hypre_StTerm *term2, HYPRE_Int ndim );
HYPRE_Int
hypre_StTermCopy_dbl( hypre_StTerm *term1, hypre_StTerm *term2, HYPRE_Int ndim );
HYPRE_Int
hypre_StTermCopy_long_dbl( hypre_StTerm *term1, hypre_StTerm *term2, HYPRE_Int ndim );

HYPRE_Int
hypre_StTermPrint_flt( hypre_StTerm *term, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StTermPrint_dbl( hypre_StTerm *term, char *matnames, HYPRE_Int ndim );
HYPRE_Int
hypre_StTermPrint_long_dbl( hypre_StTerm *term, char *matnames, HYPRE_Int ndim );

HYPRE_Int
hypre_StructAssumedPartitionCreate_flt( HYPRE_Int dim, hypre_Box *bounding_box, hypre_float global_boxes_size, HYPRE_Int global_num_boxes, hypre_BoxArray *local_boxes, HYPRE_Int max_regions, HYPRE_Int max_refinements, hypre_float gamma, MPI_Comm comm, hypre_StructAssumedPart **p_assumed_partition );
HYPRE_Int
hypre_StructAssumedPartitionCreate_dbl( HYPRE_Int dim, hypre_Box *bounding_box, hypre_double global_boxes_size, HYPRE_Int global_num_boxes, hypre_BoxArray *local_boxes, HYPRE_Int max_regions, HYPRE_Int max_refinements, hypre_double gamma, MPI_Comm comm, hypre_StructAssumedPart **p_assumed_partition );
HYPRE_Int
hypre_StructAssumedPartitionCreate_long_dbl( HYPRE_Int dim, hypre_Box *bounding_box, hypre_long_double global_boxes_size, HYPRE_Int global_num_boxes, hypre_BoxArray *local_boxes, HYPRE_Int max_regions, HYPRE_Int max_refinements, hypre_long_double gamma, MPI_Comm comm, hypre_StructAssumedPart **p_assumed_partition );

HYPRE_Int
hypre_StructAssumedPartitionDestroy_flt( hypre_StructAssumedPart *assumed_part );
HYPRE_Int
hypre_StructAssumedPartitionDestroy_dbl( hypre_StructAssumedPart *assumed_part );
HYPRE_Int
hypre_StructAssumedPartitionDestroy_long_dbl( hypre_StructAssumedPart *assumed_part );

HYPRE_Int
hypre_StructAssumedPartitionGetProcsFromBox_flt( hypre_StructAssumedPart *assumed_part, hypre_Box *box, HYPRE_Int *num_proc_array, HYPRE_Int *size_alloc_proc_array, HYPRE_Int **p_proc_array );
HYPRE_Int
hypre_StructAssumedPartitionGetProcsFromBox_dbl( hypre_StructAssumedPart *assumed_part, hypre_Box *box, HYPRE_Int *num_proc_array, HYPRE_Int *size_alloc_proc_array, HYPRE_Int **p_proc_array );
HYPRE_Int
hypre_StructAssumedPartitionGetProcsFromBox_long_dbl( hypre_StructAssumedPart *assumed_part, hypre_Box *box, HYPRE_Int *num_proc_array, HYPRE_Int *size_alloc_proc_array, HYPRE_Int **p_proc_array );

HYPRE_Int
hypre_StructAssumedPartitionGetRegionsFromProc_flt( hypre_StructAssumedPart *assumed_part, HYPRE_Int proc_id, hypre_BoxArray *assumed_regions );
HYPRE_Int
hypre_StructAssumedPartitionGetRegionsFromProc_dbl( hypre_StructAssumedPart *assumed_part, HYPRE_Int proc_id, hypre_BoxArray *assumed_regions );
HYPRE_Int
hypre_StructAssumedPartitionGetRegionsFromProc_long_dbl( hypre_StructAssumedPart *assumed_part, HYPRE_Int proc_id, hypre_BoxArray *assumed_regions );

HYPRE_Int
hypre_StructAssumedPartitionPrint_flt( const char *filename, hypre_StructAssumedPart *ap );
HYPRE_Int
hypre_StructAssumedPartitionPrint_dbl( const char *filename, hypre_StructAssumedPart *ap );
HYPRE_Int
hypre_StructAssumedPartitionPrint_long_dbl( const char *filename, hypre_StructAssumedPart *ap );

HYPRE_Int
hypre_StructCoarsen_flt( hypre_StructGrid *fgrid, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int prune, hypre_StructGrid **cgrid_ptr );
HYPRE_Int
hypre_StructCoarsen_dbl( hypre_StructGrid *fgrid, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int prune, hypre_StructGrid **cgrid_ptr );
HYPRE_Int
hypre_StructCoarsen_long_dbl( hypre_StructGrid *fgrid, hypre_IndexRef origin, hypre_Index stride, HYPRE_Int prune, hypre_StructGrid **cgrid_ptr );

HYPRE_Int
hypre_StructCoarsenAP_flt( hypre_StructAssumedPart *ap, hypre_Index origin, hypre_Index stride, hypre_StructAssumedPart **new_ap_ptr );
HYPRE_Int
hypre_StructCoarsenAP_dbl( hypre_StructAssumedPart *ap, hypre_Index origin, hypre_Index stride, hypre_StructAssumedPart **new_ap_ptr );
HYPRE_Int
hypre_StructCoarsenAP_long_dbl( hypre_StructAssumedPart *ap, hypre_Index origin, hypre_Index stride, hypre_StructAssumedPart **new_ap_ptr );

HYPRE_Int
hypre_StructCommunicationFinalize_flt( hypre_CommHandle *comm_handle );
HYPRE_Int
hypre_StructCommunicationFinalize_dbl( hypre_CommHandle *comm_handle );
HYPRE_Int
hypre_StructCommunicationFinalize_long_dbl( hypre_CommHandle *comm_handle );

HYPRE_Int
hypre_StructCommunicationInitialize_flt( hypre_CommPkg *comm_pkg, hypre_float **send_data, hypre_float **recv_data, HYPRE_Int action, HYPRE_Int tag, hypre_CommHandle **comm_handle_ptr );
HYPRE_Int
hypre_StructCommunicationInitialize_dbl( hypre_CommPkg *comm_pkg, hypre_double **send_data, hypre_double **recv_data, HYPRE_Int action, HYPRE_Int tag, hypre_CommHandle **comm_handle_ptr );
HYPRE_Int
hypre_StructCommunicationInitialize_long_dbl( hypre_CommPkg *comm_pkg, hypre_long_double **send_data, hypre_long_double **recv_data, HYPRE_Int action, HYPRE_Int tag, hypre_CommHandle **comm_handle_ptr );

HYPRE_Int
hypre_StructCopy_flt( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Int
hypre_StructCopy_dbl( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Int
hypre_StructCopy_long_dbl( hypre_StructVector *x, hypre_StructVector *y );

HYPRE_Int
hypre_StructDataCopy_flt( hypre_float *fr_data, /* from */ hypre_BoxArray *fr_data_space, hypre_float *to_data, /* to */ hypre_BoxArray *to_data_space, HYPRE_Int ndim, HYPRE_Int nval );
HYPRE_Int
hypre_StructDataCopy_dbl( hypre_double *fr_data, /* from */ hypre_BoxArray *fr_data_space, hypre_double *to_data, /* to */ hypre_BoxArray *to_data_space, HYPRE_Int ndim, HYPRE_Int nval );
HYPRE_Int
hypre_StructDataCopy_long_dbl( hypre_long_double *fr_data, /* from */ hypre_BoxArray *fr_data_space, hypre_long_double *to_data, /* to */ hypre_BoxArray *to_data_space, HYPRE_Int ndim, HYPRE_Int nval );

HYPRE_Int
hypre_StructGridAssemble_flt( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridAssemble_dbl( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridAssemble_long_dbl( hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridComputeBoxnums_flt( hypre_StructGrid *grid, HYPRE_Int nboxes, HYPRE_Int *boxnums, hypre_Index stride, HYPRE_Int *new_nboxes_ptr, HYPRE_Int **new_boxnums_ptr );
HYPRE_Int
hypre_StructGridComputeBoxnums_dbl( hypre_StructGrid *grid, HYPRE_Int nboxes, HYPRE_Int *boxnums, hypre_Index stride, HYPRE_Int *new_nboxes_ptr, HYPRE_Int **new_boxnums_ptr );
HYPRE_Int
hypre_StructGridComputeBoxnums_long_dbl( hypre_StructGrid *grid, HYPRE_Int nboxes, HYPRE_Int *boxnums, hypre_Index stride, HYPRE_Int *new_nboxes_ptr, HYPRE_Int **new_boxnums_ptr );

HYPRE_Int
hypre_StructGridComputeGlobalSize_flt( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridComputeGlobalSize_dbl( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridComputeGlobalSize_long_dbl( hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridCreate_flt( MPI_Comm comm, HYPRE_Int dim, hypre_StructGrid **grid_ptr );
HYPRE_Int
hypre_StructGridCreate_dbl( MPI_Comm comm, HYPRE_Int dim, hypre_StructGrid **grid_ptr );
HYPRE_Int
hypre_StructGridCreate_long_dbl( MPI_Comm comm, HYPRE_Int dim, hypre_StructGrid **grid_ptr );

HYPRE_Int
hypre_StructGridDestroy_flt( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridDestroy_dbl( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridDestroy_long_dbl( hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridGetMaxBoxSize_flt( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridGetMaxBoxSize_dbl( hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridGetMaxBoxSize_long_dbl( hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridPrint_flt( FILE *file, hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridPrint_dbl( FILE *file, hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridPrint_long_dbl( FILE *file, hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridPrintVTK_flt( const char *filename, hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridPrintVTK_dbl( const char *filename, hypre_StructGrid *grid );
HYPRE_Int
hypre_StructGridPrintVTK_long_dbl( const char *filename, hypre_StructGrid *grid );

HYPRE_Int
hypre_StructGridRead_flt( MPI_Comm comm, FILE *file, hypre_StructGrid **grid_ptr );
HYPRE_Int
hypre_StructGridRead_dbl( MPI_Comm comm, FILE *file, hypre_StructGrid **grid_ptr );
HYPRE_Int
hypre_StructGridRead_long_dbl( MPI_Comm comm, FILE *file, hypre_StructGrid **grid_ptr );

HYPRE_Int
hypre_StructGridRef_flt( hypre_StructGrid *grid, hypre_StructGrid **grid_ref );
HYPRE_Int
hypre_StructGridRef_dbl( hypre_StructGrid *grid, hypre_StructGrid **grid_ref );
HYPRE_Int
hypre_StructGridRef_long_dbl( hypre_StructGrid *grid, hypre_StructGrid **grid_ref );

HYPRE_Int
hypre_StructGridSetBoundingBox_flt( hypre_StructGrid *grid, hypre_Box *new_bb );
HYPRE_Int
hypre_StructGridSetBoundingBox_dbl( hypre_StructGrid *grid, hypre_Box *new_bb );
HYPRE_Int
hypre_StructGridSetBoundingBox_long_dbl( hypre_StructGrid *grid, hypre_Box *new_bb );

HYPRE_Int
hypre_StructGridSetBoxManager_flt( hypre_StructGrid *grid, hypre_BoxManager *boxman );
HYPRE_Int
hypre_StructGridSetBoxManager_dbl( hypre_StructGrid *grid, hypre_BoxManager *boxman );
HYPRE_Int
hypre_StructGridSetBoxManager_long_dbl( hypre_StructGrid *grid, hypre_BoxManager *boxman );

HYPRE_Int
hypre_StructGridSetBoxes_flt( hypre_StructGrid *grid, hypre_BoxArray *boxes );
HYPRE_Int
hypre_StructGridSetBoxes_dbl( hypre_StructGrid *grid, hypre_BoxArray *boxes );
HYPRE_Int
hypre_StructGridSetBoxes_long_dbl( hypre_StructGrid *grid, hypre_BoxArray *boxes );

HYPRE_Int
hypre_StructGridSetExtents_flt( hypre_StructGrid *grid, hypre_Index ilower, hypre_Index iupper );
HYPRE_Int
hypre_StructGridSetExtents_dbl( hypre_StructGrid *grid, hypre_Index ilower, hypre_Index iupper );
HYPRE_Int
hypre_StructGridSetExtents_long_dbl( hypre_StructGrid *grid, hypre_Index ilower, hypre_Index iupper );

HYPRE_Int
hypre_StructGridSetIDs_flt( hypre_StructGrid *grid, HYPRE_Int *ids );
HYPRE_Int
hypre_StructGridSetIDs_dbl( hypre_StructGrid *grid, HYPRE_Int *ids );
HYPRE_Int
hypre_StructGridSetIDs_long_dbl( hypre_StructGrid *grid, HYPRE_Int *ids );

HYPRE_Int
hypre_StructGridSetMaxDistance_flt( hypre_StructGrid *grid, hypre_Index dist );
HYPRE_Int
hypre_StructGridSetMaxDistance_dbl( hypre_StructGrid *grid, hypre_Index dist );
HYPRE_Int
hypre_StructGridSetMaxDistance_long_dbl( hypre_StructGrid *grid, hypre_Index dist );

HYPRE_Int
hypre_StructGridSetNumGhost_flt( hypre_StructGrid *grid, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_StructGridSetNumGhost_dbl( hypre_StructGrid *grid, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_StructGridSetNumGhost_long_dbl( hypre_StructGrid *grid, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_StructGridSetPeriodic_flt( hypre_StructGrid *grid, hypre_Index periodic );
HYPRE_Int
hypre_StructGridSetPeriodic_dbl( hypre_StructGrid *grid, hypre_Index periodic );
HYPRE_Int
hypre_StructGridSetPeriodic_long_dbl( hypre_StructGrid *grid, hypre_Index periodic );

HYPRE_Real
hypre_StructInnerProd_flt( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Real
hypre_StructInnerProd_dbl( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Real
hypre_StructInnerProd_long_dbl( hypre_StructVector *x, hypre_StructVector *y );

HYPRE_Real
hypre_StructInnerProdLocal_flt( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Real
hypre_StructInnerProdLocal_dbl( hypre_StructVector *x, hypre_StructVector *y );
HYPRE_Real
hypre_StructInnerProdLocal_long_dbl( hypre_StructVector *x, hypre_StructVector *y );

HYPRE_Int
hypre_StructMapCoarseToFine_flt( hypre_Index cindex, hypre_Index origin, hypre_Index stride, hypre_Index findex );
HYPRE_Int
hypre_StructMapCoarseToFine_dbl( hypre_Index cindex, hypre_Index origin, hypre_Index stride, hypre_Index findex );
HYPRE_Int
hypre_StructMapCoarseToFine_long_dbl( hypre_Index cindex, hypre_Index origin, hypre_Index stride, hypre_Index findex );

HYPRE_Int
hypre_StructMapFineToCoarse_flt( hypre_Index findex, hypre_Index origin, hypre_Index stride, hypre_Index cindex );
HYPRE_Int
hypre_StructMapFineToCoarse_dbl( hypre_Index findex, hypre_Index origin, hypre_Index stride, hypre_Index cindex );
HYPRE_Int
hypre_StructMapFineToCoarse_long_dbl( hypre_Index findex, hypre_Index origin, hypre_Index stride, hypre_Index cindex );

HYPRE_Int
hypre_StructMatmat_flt( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmat_dbl( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmat_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatmatSetup_flt( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmatSetup_dbl( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmatSetup_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *B, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatmult_flt( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmult_dbl( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmult_long_dbl( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatmultCommSetup_flt( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultCommSetup_dbl( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultCommSetup_long_dbl( hypre_StructMatmultData *mmdata );

HYPRE_Int
hypre_StructMatmultCommunicate_flt( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultCommunicate_dbl( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultCommunicate_long_dbl( hypre_StructMatmultData *mmdata );

HYPRE_Int
hypre_StructMatmultCompute_flt( hypre_StructMatmultData *mmdata, HYPRE_Int iM );
HYPRE_Int
hypre_StructMatmultCompute_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int iM );
HYPRE_Int
hypre_StructMatmultCompute_long_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int iM );

HYPRE_Int
hypre_StructMatmultCompute_core_flt( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );
HYPRE_Int
hypre_StructMatmultCompute_core_dbl( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );
HYPRE_Int
hypre_StructMatmultCompute_core_long_dbl( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );

HYPRE_Int
hypre_StructMatmultCompute_core_generic_flt( hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int nterms, HYPRE_Int ndim, hypre_Index loop_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );
HYPRE_Int
hypre_StructMatmultCompute_core_generic_dbl( hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int nterms, HYPRE_Int ndim, hypre_Index loop_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );
HYPRE_Int
hypre_StructMatmultCompute_core_generic_long_dbl( hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int nterms, HYPRE_Int ndim, hypre_Index loop_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride );

HYPRE_Int
hypre_StructMatmultCompute_fuse_flt( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride, hypre_StructMatrix *M );
HYPRE_Int
hypre_StructMatmultCompute_fuse_dbl( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride, hypre_StructMatrix *M );
HYPRE_Int
hypre_StructMatmultCompute_fuse_long_dbl( HYPRE_Int nterms, hypre_StructMatmultDataMH *a, HYPRE_Int na, HYPRE_Int ndim, hypre_Index loop_size, HYPRE_Int stencil_size, hypre_Box *fdbox, hypre_Index fdstart, hypre_Index fdstride, hypre_Box *cdbox, hypre_Index cdstart, hypre_Index cdstride, hypre_Box *Mdbox, hypre_Index Mdstart, hypre_Index Mdstride, hypre_StructMatrix *M );

HYPRE_Int
hypre_StructMatmultCreate_flt( HYPRE_Int max_matmults, HYPRE_Int max_matrices, hypre_StructMatmultData **mmdata_ptr );
HYPRE_Int
hypre_StructMatmultCreate_dbl( HYPRE_Int max_matmults, HYPRE_Int max_matrices, hypre_StructMatmultData **mmdata_ptr );
HYPRE_Int
hypre_StructMatmultCreate_long_dbl( HYPRE_Int max_matmults, HYPRE_Int max_matrices, hypre_StructMatmultData **mmdata_ptr );

HYPRE_Int
hypre_StructMatmultDestroy_flt( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultDestroy_dbl( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultDestroy_long_dbl( hypre_StructMatmultData *mmdata );

HYPRE_Int
hypre_StructMatmultGetMatrix_flt( hypre_StructMatmultData *mmdata, HYPRE_Int iM, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmultGetMatrix_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int iM, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmultGetMatrix_long_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int iM, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatmultInitialize_flt( hypre_StructMatmultData *mmdata, HYPRE_Int assemble_grid );
HYPRE_Int
hypre_StructMatmultInitialize_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int assemble_grid );
HYPRE_Int
hypre_StructMatmultInitialize_long_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int assemble_grid );

HYPRE_Int
hypre_StructMatmultMultiply_flt( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultMultiply_dbl( hypre_StructMatmultData *mmdata );
HYPRE_Int
hypre_StructMatmultMultiply_long_dbl( hypre_StructMatmultData *mmdata );

HYPRE_Int
hypre_StructMatmultSetKernelType_flt( hypre_StructMatmultData *mmdata, HYPRE_Int kernel_type );
HYPRE_Int
hypre_StructMatmultSetKernelType_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int kernel_type );
HYPRE_Int
hypre_StructMatmultSetKernelType_long_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int kernel_type );

HYPRE_Int
hypre_StructMatmultSetProduct_flt( hypre_StructMatmultData *mmdata, HYPRE_Int nmatrices_in, hypre_StructMatrix **matrices_in, HYPRE_Int nterms, HYPRE_Int *terms_in, HYPRE_Int *transposes_in, HYPRE_Int *iM_ptr );
HYPRE_Int
hypre_StructMatmultSetProduct_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int nmatrices_in, hypre_StructMatrix **matrices_in, HYPRE_Int nterms, HYPRE_Int *terms_in, HYPRE_Int *transposes_in, HYPRE_Int *iM_ptr );
HYPRE_Int
hypre_StructMatmultSetProduct_long_dbl( hypre_StructMatmultData *mmdata, HYPRE_Int nmatrices_in, hypre_StructMatrix **matrices_in, HYPRE_Int nterms, HYPRE_Int *terms_in, HYPRE_Int *transposes_in, HYPRE_Int *iM_ptr );

HYPRE_Int
hypre_StructMatmultSetup_flt( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmultSetup_dbl( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatmultSetup_long_dbl( HYPRE_Int type, HYPRE_Int nmatrices, hypre_StructMatrix **matrices, HYPRE_Int nterms, HYPRE_Int *terms, HYPRE_Int *trans, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixAddInit_flt( HYPRE_Int nmatrices, hypre_StructMatrix **matrices, hypre_StructMatrix **A_ptr );
HYPRE_Int
hypre_StructMatrixAddInit_dbl( HYPRE_Int nmatrices, hypre_StructMatrix **matrices, hypre_StructMatrix **A_ptr );
HYPRE_Int
hypre_StructMatrixAddInit_long_dbl( HYPRE_Int nmatrices, hypre_StructMatrix **matrices, hypre_StructMatrix **A_ptr );

HYPRE_Int
hypre_StructMatrixAddMat_flt( hypre_StructMatrix *A, hypre_float alpha, hypre_StructMatrix *B );
HYPRE_Int
hypre_StructMatrixAddMat_dbl( hypre_StructMatrix *A, hypre_double alpha, hypre_StructMatrix *B );
HYPRE_Int
hypre_StructMatrixAddMat_long_dbl( hypre_StructMatrix *A, hypre_long_double alpha, hypre_StructMatrix *B );

HYPRE_Int
hypre_StructMatrixAssemble_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixAssemble_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixAssemble_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixClearBoundary_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixClearBoundary_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixClearBoundary_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixClearBoxValues_flt( hypre_StructMatrix *matrix, hypre_Box *clear_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixClearBoxValues_dbl( hypre_StructMatrix *matrix, hypre_Box *clear_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixClearBoxValues_long_dbl( hypre_StructMatrix *matrix, hypre_Box *clear_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructMatrixClearGhostValues_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixClearGhostValues_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixClearGhostValues_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixClearValues_flt( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixClearValues_dbl( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixClearValues_long_dbl( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructMatrixComputeDataSpace_flt( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructMatrixComputeDataSpace_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructMatrixComputeDataSpace_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );

HYPRE_Int
hypre_StructMatrixComputeRowSum_flt( hypre_StructMatrix *A, HYPRE_Int type, hypre_StructVector *rowsum );
HYPRE_Int
hypre_StructMatrixComputeRowSum_dbl( hypre_StructMatrix *A, HYPRE_Int type, hypre_StructVector *rowsum );
HYPRE_Int
hypre_StructMatrixComputeRowSum_long_dbl( hypre_StructMatrix *A, HYPRE_Int type, hypre_StructVector *rowsum );

hypre_StructMatrix *
hypre_StructMatrixCreate_flt( MPI_Comm comm, hypre_StructGrid *grid, hypre_StructStencil *user_stencil );
hypre_StructMatrix *
hypre_StructMatrixCreate_dbl( MPI_Comm comm, hypre_StructGrid *grid, hypre_StructStencil *user_stencil );
hypre_StructMatrix *
hypre_StructMatrixCreate_long_dbl( MPI_Comm comm, hypre_StructGrid *grid, hypre_StructStencil *user_stencil );

HYPRE_Int
hypre_StructMatrixCreateCommPkg_flt( hypre_StructMatrix *matrix, hypre_CommInfo *comm_info, hypre_CommPkg **comm_pkg_ptr, hypre_float ***comm_data_ptr );
HYPRE_Int
hypre_StructMatrixCreateCommPkg_dbl( hypre_StructMatrix *matrix, hypre_CommInfo *comm_info, hypre_CommPkg **comm_pkg_ptr, hypre_double ***comm_data_ptr );
HYPRE_Int
hypre_StructMatrixCreateCommPkg_long_dbl( hypre_StructMatrix *matrix, hypre_CommInfo *comm_info, hypre_CommPkg **comm_pkg_ptr, hypre_long_double ***comm_data_ptr );

hypre_StructMatrix *
hypre_StructMatrixCreateMask_flt( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices );
hypre_StructMatrix *
hypre_StructMatrixCreateMask_dbl( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices );
hypre_StructMatrix *
hypre_StructMatrixCreateMask_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices );

HYPRE_Int
hypre_StructMatrixDestroy_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixDestroy_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixDestroy_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Complex *
hypre_StructMatrixExtractPointerByIndex_flt( hypre_StructMatrix *matrix, HYPRE_Int b, hypre_Index index );
HYPRE_Complex *
hypre_StructMatrixExtractPointerByIndex_dbl( hypre_StructMatrix *matrix, HYPRE_Int b, hypre_Index index );
HYPRE_Complex *
hypre_StructMatrixExtractPointerByIndex_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int b, hypre_Index index );

HYPRE_Int
hypre_StructMatrixForget_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixForget_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixForget_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixGetCStride_flt( hypre_StructMatrix *matrix, hypre_IndexRef *cstride );
HYPRE_Int
hypre_StructMatrixGetCStride_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *cstride );
HYPRE_Int
hypre_StructMatrixGetCStride_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *cstride );

HYPRE_Int
hypre_StructMatrixGetDataMapStride_flt( hypre_StructMatrix *matrix, hypre_IndexRef *stride );
HYPRE_Int
hypre_StructMatrixGetDataMapStride_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *stride );
HYPRE_Int
hypre_StructMatrixGetDataMapStride_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *stride );

HYPRE_Int
hypre_StructMatrixGetDiagonal_flt( hypre_StructMatrix *matrix, hypre_StructVector *diag );
HYPRE_Int
hypre_StructMatrixGetDiagonal_dbl( hypre_StructMatrix *matrix, hypre_StructVector *diag );
HYPRE_Int
hypre_StructMatrixGetDiagonal_long_dbl( hypre_StructMatrix *matrix, hypre_StructVector *diag );

HYPRE_Int
hypre_StructMatrixGetFStride_flt( hypre_StructMatrix *matrix, hypre_IndexRef *fstride );
HYPRE_Int
hypre_StructMatrixGetFStride_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *fstride );
HYPRE_Int
hypre_StructMatrixGetFStride_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef *fstride );

HYPRE_Int
hypre_StructMatrixGetStSpaces_flt( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *num_sspaces_ptr, HYPRE_Int **sentry_sspaces_ptr, hypre_Index **sspace_origins_ptr, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStSpaces_dbl( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *num_sspaces_ptr, HYPRE_Int **sentry_sspaces_ptr, hypre_Index **sspace_origins_ptr, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStSpaces_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *num_sspaces_ptr, HYPRE_Int **sentry_sspaces_ptr, hypre_Index **sspace_origins_ptr, hypre_Index stride );

HYPRE_Int
hypre_StructMatrixGetStencilSpace_flt( hypre_StructMatrix *matrix, HYPRE_Int entry, HYPRE_Int transpose, hypre_Index origin, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStencilSpace_dbl( hypre_StructMatrix *matrix, HYPRE_Int entry, HYPRE_Int transpose, hypre_Index origin, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStencilSpace_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int entry, HYPRE_Int transpose, hypre_Index origin, hypre_Index stride );

HYPRE_Int
hypre_StructMatrixGetStencilStride_flt( hypre_StructMatrix *matrix, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStencilStride_dbl( hypre_StructMatrix *matrix, hypre_Index stride );
HYPRE_Int
hypre_StructMatrixGetStencilStride_long_dbl( hypre_StructMatrix *matrix, hypre_Index stride );

HYPRE_Int
hypre_StructMatrixGrowDataSpace_flt( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructMatrixGrowDataSpace_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructMatrixGrowDataSpace_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );

HYPRE_Int
hypre_StructMatrixInitialize_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixInitialize_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixInitialize_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixInitializeData_flt( hypre_StructMatrix *matrix, HYPRE_Int zero_init, hypre_float *data );
HYPRE_Int
hypre_StructMatrixInitializeData_dbl( hypre_StructMatrix *matrix, HYPRE_Int zero_init, hypre_double *data );
HYPRE_Int
hypre_StructMatrixInitializeData_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int zero_init, hypre_long_double *data );

HYPRE_Int
hypre_StructMatrixInitializeShell_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixInitializeShell_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixInitializeShell_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixMapCommInfo_flt( hypre_StructMatrix *matrix, hypre_IndexRef origin, hypre_Index stride, hypre_CommInfo *comm_info );
HYPRE_Int
hypre_StructMatrixMapCommInfo_dbl( hypre_StructMatrix *matrix, hypre_IndexRef origin, hypre_Index stride, hypre_CommInfo *comm_info );
HYPRE_Int
hypre_StructMatrixMapCommInfo_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef origin, hypre_Index stride, hypre_CommInfo *comm_info );

HYPRE_Int
hypre_StructMatrixMapDataBox_flt( hypre_StructMatrix *matrix, hypre_Box *dbox );
HYPRE_Int
hypre_StructMatrixMapDataBox_dbl( hypre_StructMatrix *matrix, hypre_Box *dbox );
HYPRE_Int
hypre_StructMatrixMapDataBox_long_dbl( hypre_StructMatrix *matrix, hypre_Box *dbox );

HYPRE_Int
hypre_StructMatrixMapDataIndex_flt( hypre_StructMatrix *matrix, hypre_Index dindex );
HYPRE_Int
hypre_StructMatrixMapDataIndex_dbl( hypre_StructMatrix *matrix, hypre_Index dindex );
HYPRE_Int
hypre_StructMatrixMapDataIndex_long_dbl( hypre_StructMatrix *matrix, hypre_Index dindex );

HYPRE_Int
hypre_StructMatrixMapDataStride_flt( hypre_StructMatrix *matrix, hypre_Index dstride );
HYPRE_Int
hypre_StructMatrixMapDataStride_dbl( hypre_StructMatrix *matrix, hypre_Index dstride );
HYPRE_Int
hypre_StructMatrixMapDataStride_long_dbl( hypre_StructMatrix *matrix, hypre_Index dstride );

HYPRE_Int
hypre_StructMatrixMigrate_flt( hypre_StructMatrix *from_matrix, hypre_StructMatrix *to_matrix );
HYPRE_Int
hypre_StructMatrixMigrate_dbl( hypre_StructMatrix *from_matrix, hypre_StructMatrix *to_matrix );
HYPRE_Int
hypre_StructMatrixMigrate_long_dbl( hypre_StructMatrix *from_matrix, hypre_StructMatrix *to_matrix );

HYPRE_Int
hypre_StructMatrixNeedResize_flt( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructMatrixNeedResize_dbl( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructMatrixNeedResize_long_dbl( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );

HYPRE_Int
hypre_StructMatrixPlaceStencil_flt( hypre_StructMatrix *matrix, HYPRE_Int entry, hypre_Index dindex, hypre_Index index );
HYPRE_Int
hypre_StructMatrixPlaceStencil_dbl( hypre_StructMatrix *matrix, HYPRE_Int entry, hypre_Index dindex, hypre_Index index );
HYPRE_Int
hypre_StructMatrixPlaceStencil_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int entry, hypre_Index dindex, hypre_Index index );

HYPRE_Int
hypre_StructMatrixPrint_flt( const char *filename, hypre_StructMatrix *matrix, HYPRE_Int all );
HYPRE_Int
hypre_StructMatrixPrint_dbl( const char *filename, hypre_StructMatrix *matrix, HYPRE_Int all );
HYPRE_Int
hypre_StructMatrixPrint_long_dbl( const char *filename, hypre_StructMatrix *matrix, HYPRE_Int all );

HYPRE_Int
hypre_StructMatrixPrintData_flt( FILE *file, hypre_StructMatrix *matrix, HYPRE_Int all );
HYPRE_Int
hypre_StructMatrixPrintData_dbl( FILE *file, hypre_StructMatrix *matrix, HYPRE_Int all );
HYPRE_Int
hypre_StructMatrixPrintData_long_dbl( FILE *file, hypre_StructMatrix *matrix, HYPRE_Int all );

HYPRE_Int
hypre_StructMatrixPtAP_flt( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixPtAP_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixPtAP_long_dbl( hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixPtAPSetup_flt( HYPRE_Int kernel_type, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixPtAPSetup_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixPtAPSetup_long_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixRAP_flt( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRAP_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRAP_long_dbl( hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixRAPSetup_flt( HYPRE_Int kernel_type, hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRAPSetup_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRAPSetup_long_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *R, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixRTtAP_flt( hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRTtAP_dbl( hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRTtAP_long_dbl( hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatrix **M_ptr );

HYPRE_Int
hypre_StructMatrixRTtAPSetup_flt( HYPRE_Int kernel_type, hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRTtAPSetup_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );
HYPRE_Int
hypre_StructMatrixRTtAPSetup_long_dbl( HYPRE_Int kernel_type, hypre_StructMatrix *RT, hypre_StructMatrix *A, hypre_StructMatrix *P, hypre_StructMatmultData **mmdata_ptr, hypre_StructMatrix **M_ptr );

hypre_StructMatrix *
hypre_StructMatrixRead_flt( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );
hypre_StructMatrix *
hypre_StructMatrixRead_dbl( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );
hypre_StructMatrix *
hypre_StructMatrixRead_long_dbl( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_StructMatrixReadData_flt( FILE *file, hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixReadData_dbl( FILE *file, hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixReadData_long_dbl( FILE *file, hypre_StructMatrix *matrix );

hypre_StructMatrix *
hypre_StructMatrixRef_flt( hypre_StructMatrix *matrix );
hypre_StructMatrix *
hypre_StructMatrixRef_dbl( hypre_StructMatrix *matrix );
hypre_StructMatrix *
hypre_StructMatrixRef_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixResize_flt( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructMatrixResize_dbl( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructMatrixResize_long_dbl( hypre_StructMatrix *matrix, hypre_BoxArray *data_space );

HYPRE_Int
hypre_StructMatrixRestore_flt( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixRestore_dbl( hypre_StructMatrix *matrix );
HYPRE_Int
hypre_StructMatrixRestore_long_dbl( hypre_StructMatrix *matrix );

HYPRE_Int
hypre_StructMatrixSetBoxValues_flt( hypre_StructMatrix *matrix, hypre_Box *set_box, hypre_Box *value_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_float *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixSetBoxValues_dbl( hypre_StructMatrix *matrix, hypre_Box *set_box, hypre_Box *value_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixSetBoxValues_long_dbl( hypre_StructMatrix *matrix, hypre_Box *set_box, hypre_Box *value_box, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_long_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructMatrixSetConstantEntries_flt( hypre_StructMatrix *matrix, HYPRE_Int nentries, HYPRE_Int *entries );
HYPRE_Int
hypre_StructMatrixSetConstantEntries_dbl( hypre_StructMatrix *matrix, HYPRE_Int nentries, HYPRE_Int *entries );
HYPRE_Int
hypre_StructMatrixSetConstantEntries_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int nentries, HYPRE_Int *entries );

HYPRE_Int
hypre_StructMatrixSetConstantValues_flt( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_float *values, HYPRE_Int action );
HYPRE_Int
hypre_StructMatrixSetConstantValues_dbl( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_double *values, HYPRE_Int action );
HYPRE_Int
hypre_StructMatrixSetConstantValues_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_long_double *values, HYPRE_Int action );

HYPRE_Int
hypre_StructMatrixSetDomainStride_flt( hypre_StructMatrix *matrix, hypre_IndexRef domain_stride );
HYPRE_Int
hypre_StructMatrixSetDomainStride_dbl( hypre_StructMatrix *matrix, hypre_IndexRef domain_stride );
HYPRE_Int
hypre_StructMatrixSetDomainStride_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef domain_stride );

HYPRE_Int
hypre_StructMatrixSetGhost_flt( hypre_StructMatrix *matrix, HYPRE_Int ghost, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetGhost_dbl( hypre_StructMatrix *matrix, HYPRE_Int ghost, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetGhost_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int ghost, HYPRE_Int *resize );

HYPRE_Int
hypre_StructMatrixSetMemoryLocation_flt( hypre_StructMatrix *matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_StructMatrixSetMemoryLocation_dbl( hypre_StructMatrix *matrix, HYPRE_MemoryLocation memory_location );
HYPRE_Int
hypre_StructMatrixSetMemoryLocation_long_dbl( hypre_StructMatrix *matrix, HYPRE_MemoryLocation memory_location );

HYPRE_Int
hypre_StructMatrixSetNumGhost_flt( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetNumGhost_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetNumGhost_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int *num_ghost, HYPRE_Int *resize );

HYPRE_Int
hypre_StructMatrixSetRangeStride_flt( hypre_StructMatrix *matrix, hypre_IndexRef range_stride );
HYPRE_Int
hypre_StructMatrixSetRangeStride_dbl( hypre_StructMatrix *matrix, hypre_IndexRef range_stride );
HYPRE_Int
hypre_StructMatrixSetRangeStride_long_dbl( hypre_StructMatrix *matrix, hypre_IndexRef range_stride );

HYPRE_Int
hypre_StructMatrixSetTranspose_flt( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetTranspose_dbl( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *resize );
HYPRE_Int
hypre_StructMatrixSetTranspose_long_dbl( hypre_StructMatrix *matrix, HYPRE_Int transpose, HYPRE_Int *resize );

HYPRE_Int
hypre_StructMatrixSetValues_flt( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_float *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixSetValues_dbl( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructMatrixSetValues_long_dbl( hypre_StructMatrix *matrix, hypre_Index grid_index, HYPRE_Int num_stencil_indices, HYPRE_Int *stencil_indices, hypre_long_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructMatrixUnMapDataBox_flt( hypre_StructMatrix *matrix, hypre_Box *dbox );
HYPRE_Int
hypre_StructMatrixUnMapDataBox_dbl( hypre_StructMatrix *matrix, hypre_Box *dbox );
HYPRE_Int
hypre_StructMatrixUnMapDataBox_long_dbl( hypre_StructMatrix *matrix, hypre_Box *dbox );

HYPRE_Int
hypre_StructMatrixUnMapDataIndex_flt( hypre_StructMatrix *matrix, hypre_Index dindex );
HYPRE_Int
hypre_StructMatrixUnMapDataIndex_dbl( hypre_StructMatrix *matrix, hypre_Index dindex );
HYPRE_Int
hypre_StructMatrixUnMapDataIndex_long_dbl( hypre_StructMatrix *matrix, hypre_Index dindex );

HYPRE_Int
hypre_StructMatrixUnMapDataStride_flt( hypre_StructMatrix *matrix, hypre_Index dstride );
HYPRE_Int
hypre_StructMatrixUnMapDataStride_dbl( hypre_StructMatrix *matrix, hypre_Index dstride );
HYPRE_Int
hypre_StructMatrixUnMapDataStride_long_dbl( hypre_StructMatrix *matrix, hypre_Index dstride );

HYPRE_Int
hypre_StructMatrixZeroDiagonal_flt( hypre_StructMatrix *A );
HYPRE_Int
hypre_StructMatrixZeroDiagonal_dbl( hypre_StructMatrix *A );
HYPRE_Int
hypre_StructMatrixZeroDiagonal_long_dbl( hypre_StructMatrix *A );

HYPRE_Int
hypre_StructMatvec_flt( hypre_float alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_float beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructMatvec_dbl( hypre_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_double beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructMatvec_long_dbl( hypre_long_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_long_double beta, hypre_StructVector *y );

HYPRE_Int
hypre_StructMatvecCompute_flt( void *matvec_vdata, hypre_float alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_float beta, hypre_StructVector *y, hypre_StructVector *z );
HYPRE_Int
hypre_StructMatvecCompute_dbl( void *matvec_vdata, hypre_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_double beta, hypre_StructVector *y, hypre_StructVector *z );
HYPRE_Int
hypre_StructMatvecCompute_long_dbl( void *matvec_vdata, hypre_long_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_long_double beta, hypre_StructVector *y, hypre_StructVector *z );

void *
hypre_StructMatvecCreate_flt( void );
void *
hypre_StructMatvecCreate_dbl( void );
void *
hypre_StructMatvecCreate_long_dbl( void );

HYPRE_Int
hypre_StructMatvecDestroy_flt( void *matvec_vdata );
HYPRE_Int
hypre_StructMatvecDestroy_dbl( void *matvec_vdata );
HYPRE_Int
hypre_StructMatvecDestroy_long_dbl( void *matvec_vdata );

HYPRE_Int
hypre_StructMatvecSetTranspose_flt( void *matvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_StructMatvecSetTranspose_dbl( void *matvec_vdata, HYPRE_Int transpose );
HYPRE_Int
hypre_StructMatvecSetTranspose_long_dbl( void *matvec_vdata, HYPRE_Int transpose );

HYPRE_Int
hypre_StructMatvecSetup_flt( void *matvec_vdata, hypre_StructMatrix *A, hypre_StructVector *x );
HYPRE_Int
hypre_StructMatvecSetup_dbl( void *matvec_vdata, hypre_StructMatrix *A, hypre_StructVector *x );
HYPRE_Int
hypre_StructMatvecSetup_long_dbl( void *matvec_vdata, hypre_StructMatrix *A, hypre_StructVector *x );

HYPRE_Int
hypre_StructMatvecT_flt( hypre_float alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_float beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructMatvecT_dbl( hypre_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_double beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructMatvecT_long_dbl( hypre_long_double alpha, hypre_StructMatrix *A, hypre_StructVector *x, hypre_long_double beta, hypre_StructVector *y );

HYPRE_Int
hypre_StructNumGhostFromStencil_flt( hypre_StructStencil *stencil, HYPRE_Int **num_ghost_ptr );
HYPRE_Int
hypre_StructNumGhostFromStencil_dbl( hypre_StructStencil *stencil, HYPRE_Int **num_ghost_ptr );
HYPRE_Int
hypre_StructNumGhostFromStencil_long_dbl( hypre_StructStencil *stencil, HYPRE_Int **num_ghost_ptr );

HYPRE_Int
hypre_StructPartialCopy_flt( hypre_StructVector *x, hypre_StructVector *y, hypre_BoxArrayArray *array_boxes );
HYPRE_Int
hypre_StructPartialCopy_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_BoxArrayArray *array_boxes );
HYPRE_Int
hypre_StructPartialCopy_long_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_BoxArrayArray *array_boxes );

HYPRE_Int
hypre_StructScale_flt( hypre_float alpha, hypre_StructVector *y );
HYPRE_Int
hypre_StructScale_dbl( hypre_double alpha, hypre_StructVector *y );
HYPRE_Int
hypre_StructScale_long_dbl( hypre_long_double alpha, hypre_StructVector *y );

hypre_StructStencil *
hypre_StructStencilCreate_flt( HYPRE_Int dim, HYPRE_Int size, hypre_Index *shape );
hypre_StructStencil *
hypre_StructStencilCreate_dbl( HYPRE_Int dim, HYPRE_Int size, hypre_Index *shape );
hypre_StructStencil *
hypre_StructStencilCreate_long_dbl( HYPRE_Int dim, HYPRE_Int size, hypre_Index *shape );

HYPRE_Int
hypre_StructStencilDestroy_flt( hypre_StructStencil *stencil );
HYPRE_Int
hypre_StructStencilDestroy_dbl( hypre_StructStencil *stencil );
HYPRE_Int
hypre_StructStencilDestroy_long_dbl( hypre_StructStencil *stencil );

HYPRE_Int
hypre_StructStencilOffsetEntry_flt( hypre_StructStencil *stencil, hypre_Index stencil_offset );
HYPRE_Int
hypre_StructStencilOffsetEntry_dbl( hypre_StructStencil *stencil, hypre_Index stencil_offset );
HYPRE_Int
hypre_StructStencilOffsetEntry_long_dbl( hypre_StructStencil *stencil, hypre_Index stencil_offset );

HYPRE_Int
hypre_StructStencilPrint_flt( FILE *file, hypre_StructStencil *stencil );
HYPRE_Int
hypre_StructStencilPrint_dbl( FILE *file, hypre_StructStencil *stencil );
HYPRE_Int
hypre_StructStencilPrint_long_dbl( FILE *file, hypre_StructStencil *stencil );

HYPRE_Int
hypre_StructStencilRead_flt( FILE *file, HYPRE_Int ndim, hypre_StructStencil **stencil_ptr );
HYPRE_Int
hypre_StructStencilRead_dbl( FILE *file, HYPRE_Int ndim, hypre_StructStencil **stencil_ptr );
HYPRE_Int
hypre_StructStencilRead_long_dbl( FILE *file, HYPRE_Int ndim, hypre_StructStencil **stencil_ptr );

hypre_StructStencil *
hypre_StructStencilRef_flt( hypre_StructStencil *stencil );
hypre_StructStencil *
hypre_StructStencilRef_dbl( hypre_StructStencil *stencil );
hypre_StructStencil *
hypre_StructStencilRef_long_dbl( hypre_StructStencil *stencil );

HYPRE_Int
hypre_StructStencilSymmetrize_flt( hypre_StructStencil *stencil, hypre_StructStencil **symm_stencil_ptr, HYPRE_Int **symm_offsets_ptr );
HYPRE_Int
hypre_StructStencilSymmetrize_dbl( hypre_StructStencil *stencil, hypre_StructStencil **symm_stencil_ptr, HYPRE_Int **symm_offsets_ptr );
HYPRE_Int
hypre_StructStencilSymmetrize_long_dbl( hypre_StructStencil *stencil, hypre_StructStencil **symm_stencil_ptr, HYPRE_Int **symm_offsets_ptr );

HYPRE_Int
hypre_StructVectorAssemble_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorAssemble_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorAssemble_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorAxpy_flt( hypre_float alpha, hypre_StructVector *x, hypre_float beta, hypre_StructVector *y, hypre_StructVector *z );
HYPRE_Int
hypre_StructVectorAxpy_dbl( hypre_double alpha, hypre_StructVector *x, hypre_double beta, hypre_StructVector *y, hypre_StructVector *z );
HYPRE_Int
hypre_StructVectorAxpy_long_dbl( hypre_long_double alpha, hypre_StructVector *x, hypre_long_double beta, hypre_StructVector *y, hypre_StructVector *z );

HYPRE_Int
hypre_StructVectorClearAllValues_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorClearAllValues_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorClearAllValues_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorClearBoundGhostValues_flt( hypre_StructVector *vector, HYPRE_Int force );
HYPRE_Int
hypre_StructVectorClearBoundGhostValues_dbl( hypre_StructVector *vector, HYPRE_Int force );
HYPRE_Int
hypre_StructVectorClearBoundGhostValues_long_dbl( hypre_StructVector *vector, HYPRE_Int force );

HYPRE_Int
hypre_StructVectorClearBoxValues_flt( hypre_StructVector *vector, hypre_Box *clear_box, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorClearBoxValues_dbl( hypre_StructVector *vector, hypre_Box *clear_box, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorClearBoxValues_long_dbl( hypre_StructVector *vector, hypre_Box *clear_box, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructVectorClearGhostValues_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorClearGhostValues_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorClearGhostValues_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorClearValues_flt( hypre_StructVector *vector, hypre_Index grid_index, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorClearValues_dbl( hypre_StructVector *vector, hypre_Index grid_index, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorClearValues_long_dbl( hypre_StructVector *vector, hypre_Index grid_index, HYPRE_Int boxnum, HYPRE_Int outside );

hypre_StructVector *
hypre_StructVectorClone_flt( hypre_StructVector *vector );
hypre_StructVector *
hypre_StructVectorClone_dbl( hypre_StructVector *vector );
hypre_StructVector *
hypre_StructVectorClone_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorComputeDataSpace_flt( hypre_StructVector *vector, hypre_IndexRef stride, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructVectorComputeDataSpace_dbl( hypre_StructVector *vector, hypre_IndexRef stride, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );
HYPRE_Int
hypre_StructVectorComputeDataSpace_long_dbl( hypre_StructVector *vector, hypre_IndexRef stride, HYPRE_Int *num_ghost, hypre_BoxArray **data_space_ptr );

hypre_StructVector *
hypre_StructVectorCreate_flt( MPI_Comm comm, hypre_StructGrid *grid );
hypre_StructVector *
hypre_StructVectorCreate_dbl( MPI_Comm comm, hypre_StructGrid *grid );
hypre_StructVector *
hypre_StructVectorCreate_long_dbl( MPI_Comm comm, hypre_StructGrid *grid );

HYPRE_Int
hypre_StructVectorDestroy_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorDestroy_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorDestroy_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorForget_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorForget_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorForget_long_dbl( hypre_StructVector *vector );

hypre_CommPkg *
hypre_StructVectorGetMigrateCommPkg_flt( hypre_StructVector *from_vector, hypre_StructVector *to_vector );
hypre_CommPkg *
hypre_StructVectorGetMigrateCommPkg_dbl( hypre_StructVector *from_vector, hypre_StructVector *to_vector );
hypre_CommPkg *
hypre_StructVectorGetMigrateCommPkg_long_dbl( hypre_StructVector *from_vector, hypre_StructVector *to_vector );

HYPRE_Int
hypre_StructVectorInitialize_flt( hypre_StructVector *vector, HYPRE_Int zero_init );
HYPRE_Int
hypre_StructVectorInitialize_dbl( hypre_StructVector *vector, HYPRE_Int zero_init );
HYPRE_Int
hypre_StructVectorInitialize_long_dbl( hypre_StructVector *vector, HYPRE_Int zero_init );

HYPRE_Int
hypre_StructVectorInitializeData_flt( hypre_StructVector *vector, hypre_float *data );
HYPRE_Int
hypre_StructVectorInitializeData_dbl( hypre_StructVector *vector, hypre_double *data );
HYPRE_Int
hypre_StructVectorInitializeData_long_dbl( hypre_StructVector *vector, hypre_long_double *data );

HYPRE_Int
hypre_StructVectorInitializeShell_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorInitializeShell_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorInitializeShell_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorMapCommInfo_flt( hypre_StructVector *vector, hypre_CommInfo *comm_info );
HYPRE_Int
hypre_StructVectorMapCommInfo_dbl( hypre_StructVector *vector, hypre_CommInfo *comm_info );
HYPRE_Int
hypre_StructVectorMapCommInfo_long_dbl( hypre_StructVector *vector, hypre_CommInfo *comm_info );

HYPRE_Int
hypre_StructVectorMapDataBox_flt( hypre_StructVector *vector, hypre_Box *dbox );
HYPRE_Int
hypre_StructVectorMapDataBox_dbl( hypre_StructVector *vector, hypre_Box *dbox );
HYPRE_Int
hypre_StructVectorMapDataBox_long_dbl( hypre_StructVector *vector, hypre_Box *dbox );

HYPRE_Int
hypre_StructVectorMapDataIndex_flt( hypre_StructVector *vector, hypre_Index dindex );
HYPRE_Int
hypre_StructVectorMapDataIndex_dbl( hypre_StructVector *vector, hypre_Index dindex );
HYPRE_Int
hypre_StructVectorMapDataIndex_long_dbl( hypre_StructVector *vector, hypre_Index dindex );

HYPRE_Int
hypre_StructVectorMapDataStride_flt( hypre_StructVector *vector, hypre_Index dstride );
HYPRE_Int
hypre_StructVectorMapDataStride_dbl( hypre_StructVector *vector, hypre_Index dstride );
HYPRE_Int
hypre_StructVectorMapDataStride_long_dbl( hypre_StructVector *vector, hypre_Index dstride );

HYPRE_Int
hypre_StructVectorMigrate_flt( hypre_CommPkg *comm_pkg, hypre_StructVector *from_vector, hypre_StructVector *to_vector );
HYPRE_Int
hypre_StructVectorMigrate_dbl( hypre_CommPkg *comm_pkg, hypre_StructVector *from_vector, hypre_StructVector *to_vector );
HYPRE_Int
hypre_StructVectorMigrate_long_dbl( hypre_CommPkg *comm_pkg, hypre_StructVector *from_vector, hypre_StructVector *to_vector );

HYPRE_Int
hypre_StructVectorNeedResize_flt( hypre_StructVector *vector, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructVectorNeedResize_dbl( hypre_StructVector *vector, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructVectorNeedResize_long_dbl( hypre_StructVector *vector, hypre_BoxArray *data_space );

HYPRE_Int
hypre_StructVectorPointwiseDivision_flt( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );
HYPRE_Int
hypre_StructVectorPointwiseDivision_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );
HYPRE_Int
hypre_StructVectorPointwiseDivision_long_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );

HYPRE_Int
hypre_StructVectorPointwiseDivpy_flt( hypre_float alpha, hypre_StructVector *x, hypre_StructVector *z, hypre_float beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructVectorPointwiseDivpy_dbl( hypre_double alpha, hypre_StructVector *x, hypre_StructVector *z, hypre_double beta, hypre_StructVector *y );
HYPRE_Int
hypre_StructVectorPointwiseDivpy_long_dbl( hypre_long_double alpha, hypre_StructVector *x, hypre_StructVector *z, hypre_long_double beta, hypre_StructVector *y );

HYPRE_Int
hypre_StructVectorPointwiseInverse_flt( hypre_StructVector *x, hypre_StructVector **y_ptr );
HYPRE_Int
hypre_StructVectorPointwiseInverse_dbl( hypre_StructVector *x, hypre_StructVector **y_ptr );
HYPRE_Int
hypre_StructVectorPointwiseInverse_long_dbl( hypre_StructVector *x, hypre_StructVector **y_ptr );

HYPRE_Int
hypre_StructVectorPointwiseProduct_flt( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );
HYPRE_Int
hypre_StructVectorPointwiseProduct_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );
HYPRE_Int
hypre_StructVectorPointwiseProduct_long_dbl( hypre_StructVector *x, hypre_StructVector *y, hypre_StructVector **z_ptr );

HYPRE_Int
hypre_StructVectorPrint_flt( const char *filename, hypre_StructVector *vector, HYPRE_Int all );
HYPRE_Int
hypre_StructVectorPrint_dbl( const char *filename, hypre_StructVector *vector, HYPRE_Int all );
HYPRE_Int
hypre_StructVectorPrint_long_dbl( const char *filename, hypre_StructVector *vector, HYPRE_Int all );

HYPRE_Int
hypre_StructVectorPrintData_flt( FILE *file, hypre_StructVector *vector, HYPRE_Int all );
HYPRE_Int
hypre_StructVectorPrintData_dbl( FILE *file, hypre_StructVector *vector, HYPRE_Int all );
HYPRE_Int
hypre_StructVectorPrintData_long_dbl( FILE *file, hypre_StructVector *vector, HYPRE_Int all );

hypre_StructVector *
hypre_StructVectorRead_flt( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );
hypre_StructVector *
hypre_StructVectorRead_dbl( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );
hypre_StructVector *
hypre_StructVectorRead_long_dbl( MPI_Comm comm, const char *filename, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_StructVectorReadData_flt( FILE *file, hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorReadData_dbl( FILE *file, hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorReadData_long_dbl( FILE *file, hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorRebase_flt( hypre_StructVector *vector, hypre_StructGrid *grid, hypre_Index stride );
HYPRE_Int
hypre_StructVectorRebase_dbl( hypre_StructVector *vector, hypre_StructGrid *grid, hypre_Index stride );
HYPRE_Int
hypre_StructVectorRebase_long_dbl( hypre_StructVector *vector, hypre_StructGrid *grid, hypre_Index stride );

hypre_StructVector *
hypre_StructVectorRef_flt( hypre_StructVector *vector );
hypre_StructVector *
hypre_StructVectorRef_dbl( hypre_StructVector *vector );
hypre_StructVector *
hypre_StructVectorRef_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorResize_flt( hypre_StructVector *vector, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructVectorResize_dbl( hypre_StructVector *vector, hypre_BoxArray *data_space );
HYPRE_Int
hypre_StructVectorResize_long_dbl( hypre_StructVector *vector, hypre_BoxArray *data_space );

HYPRE_Int
hypre_StructVectorRestore_flt( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorRestore_dbl( hypre_StructVector *vector );
HYPRE_Int
hypre_StructVectorRestore_long_dbl( hypre_StructVector *vector );

HYPRE_Int
hypre_StructVectorScaleValues_flt( hypre_StructVector *vector, hypre_float factor );
HYPRE_Int
hypre_StructVectorScaleValues_dbl( hypre_StructVector *vector, hypre_double factor );
HYPRE_Int
hypre_StructVectorScaleValues_long_dbl( hypre_StructVector *vector, hypre_long_double factor );

HYPRE_Int
hypre_StructVectorSetBoxValues_flt( hypre_StructVector *vector, hypre_Box *set_box, hypre_Box *value_box, hypre_float *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorSetBoxValues_dbl( hypre_StructVector *vector, hypre_Box *set_box, hypre_Box *value_box, hypre_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorSetBoxValues_long_dbl( hypre_StructVector *vector, hypre_Box *set_box, hypre_Box *value_box, hypre_long_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructVectorSetConstantValues_flt( hypre_StructVector *vector, hypre_float value );
HYPRE_Int
hypre_StructVectorSetConstantValues_dbl( hypre_StructVector *vector, hypre_double value );
HYPRE_Int
hypre_StructVectorSetConstantValues_long_dbl( hypre_StructVector *vector, hypre_long_double value );

HYPRE_Int
hypre_StructVectorSetDataSize_flt( hypre_StructVector *vector, HYPRE_Int *data_size, HYPRE_Int *data_host_size );
HYPRE_Int
hypre_StructVectorSetDataSize_dbl( hypre_StructVector *vector, HYPRE_Int *data_size, HYPRE_Int *data_host_size );
HYPRE_Int
hypre_StructVectorSetDataSize_long_dbl( hypre_StructVector *vector, HYPRE_Int *data_size, HYPRE_Int *data_host_size );

HYPRE_Int
hypre_StructVectorSetMemoryMode_flt( hypre_StructVector *vector, HYPRE_Int memory_mode );
HYPRE_Int
hypre_StructVectorSetMemoryMode_dbl( hypre_StructVector *vector, HYPRE_Int memory_mode );
HYPRE_Int
hypre_StructVectorSetMemoryMode_long_dbl( hypre_StructVector *vector, HYPRE_Int memory_mode );

HYPRE_Int
hypre_StructVectorSetNumGhost_flt( hypre_StructVector *vector, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_StructVectorSetNumGhost_dbl( hypre_StructVector *vector, HYPRE_Int *num_ghost );
HYPRE_Int
hypre_StructVectorSetNumGhost_long_dbl( hypre_StructVector *vector, HYPRE_Int *num_ghost );

HYPRE_Int
hypre_StructVectorSetRandomValues_flt( hypre_StructVector *vector, HYPRE_Int seed );
HYPRE_Int
hypre_StructVectorSetRandomValues_dbl( hypre_StructVector *vector, HYPRE_Int seed );
HYPRE_Int
hypre_StructVectorSetRandomValues_long_dbl( hypre_StructVector *vector, HYPRE_Int seed );

HYPRE_Int
hypre_StructVectorSetStride_flt( hypre_StructVector *vector, hypre_IndexRef stride );
HYPRE_Int
hypre_StructVectorSetStride_dbl( hypre_StructVector *vector, hypre_IndexRef stride );
HYPRE_Int
hypre_StructVectorSetStride_long_dbl( hypre_StructVector *vector, hypre_IndexRef stride );

HYPRE_Int
hypre_StructVectorSetValues_flt( hypre_StructVector *vector, hypre_Index grid_index, hypre_float *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorSetValues_dbl( hypre_StructVector *vector, hypre_Index grid_index, hypre_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );
HYPRE_Int
hypre_StructVectorSetValues_long_dbl( hypre_StructVector *vector, hypre_Index grid_index, hypre_long_double *values, HYPRE_Int action, HYPRE_Int boxnum, HYPRE_Int outside );

HYPRE_Int
hypre_StructVectorUnMapDataBox_flt( hypre_StructVector *vector, hypre_Box *dbox );
HYPRE_Int
hypre_StructVectorUnMapDataBox_dbl( hypre_StructVector *vector, hypre_Box *dbox );
HYPRE_Int
hypre_StructVectorUnMapDataBox_long_dbl( hypre_StructVector *vector, hypre_Box *dbox );

HYPRE_Int
hypre_StructVectorUnMapDataIndex_flt( hypre_StructVector *vector, hypre_Index dindex );
HYPRE_Int
hypre_StructVectorUnMapDataIndex_dbl( hypre_StructVector *vector, hypre_Index dindex );
HYPRE_Int
hypre_StructVectorUnMapDataIndex_long_dbl( hypre_StructVector *vector, hypre_Index dindex );

HYPRE_Int
hypre_StructVectorUnMapDataStride_flt( hypre_StructVector *vector, hypre_Index dstride );
HYPRE_Int
hypre_StructVectorUnMapDataStride_dbl( hypre_StructVector *vector, hypre_Index dstride );
HYPRE_Int
hypre_StructVectorUnMapDataStride_long_dbl( hypre_StructVector *vector, hypre_Index dstride );

HYPRE_Int
hypre_SubtractBoxArrays_flt( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2, hypre_BoxArray *tmp_box_array );
HYPRE_Int
hypre_SubtractBoxArrays_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2, hypre_BoxArray *tmp_box_array );
HYPRE_Int
hypre_SubtractBoxArrays_long_dbl( hypre_BoxArray *box_array1, hypre_BoxArray *box_array2, hypre_BoxArray *tmp_box_array );

HYPRE_Int
hypre_SubtractBoxes_flt( hypre_Box *box1, hypre_Box *box2, hypre_BoxArray *box_array );
HYPRE_Int
hypre_SubtractBoxes_dbl( hypre_Box *box1, hypre_Box *box2, hypre_BoxArray *box_array );
HYPRE_Int
hypre_SubtractBoxes_long_dbl( hypre_Box *box1, hypre_Box *box2, hypre_BoxArray *box_array );

HYPRE_Int
hypre_SubtractIndexes_flt( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );
HYPRE_Int
hypre_SubtractIndexes_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );
HYPRE_Int
hypre_SubtractIndexes_long_dbl( hypre_Index index1, hypre_Index index2, HYPRE_Int ndim, hypre_Index result );

HYPRE_Int
hypre_UnionBoxes_flt( hypre_BoxArray *boxes );
HYPRE_Int
hypre_UnionBoxes_dbl( hypre_BoxArray *boxes );
HYPRE_Int
hypre_UnionBoxes_long_dbl( hypre_BoxArray *boxes );

HYPRE_Real
hypre_doubleBoxVolume_flt( hypre_Box *box );
HYPRE_Real
hypre_doubleBoxVolume_dbl( hypre_Box *box );
HYPRE_Real
hypre_doubleBoxVolume_long_dbl( hypre_Box *box );


/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/



#endif

#ifdef __cplusplus
}
#endif

#endif

