/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.JUnitMessages;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.junit.JUnitCore;

public class JUnitContainerInitializer
extends ClasspathContainerInitializer {
    private static final IStatus NOT_SUPPORTED = new Status(4, "org.eclipse.jdt.junit.core", 1, "", null);
    private static final IStatus READ_ONLY = new Status(4, "org.eclipse.jdt.junit.core", 2, "", null);
    @Deprecated
    private static final String JUNIT3_8_1 = "3.8.1";
    private static final String JUNIT3 = "3";
    private static final String JUNIT4 = "4";
    private static final String JUNIT5 = "5";
    private static final String JUNIT6 = "6";

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            IClasspathEntry[] entries;
            IClasspathAttribute[] attributes = null;
            IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry curr = iClasspathEntryArray[n2];
                if (curr.getEntryKind() == 5 && containerPath.equals((Object)curr.getPath())) {
                    attributes = curr.getExtraAttributes();
                }
                ++n2;
            }
            JUnitContainer container = JUnitContainerInitializer.getNewContainer(containerPath, attributes);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static JUnitContainer getNewContainer(IPath containerPath, IClasspathAttribute[] attributes) {
        ArrayList<IClasspathEntry> entriesList;
        block20: {
            entriesList = new ArrayList<IClasspathEntry>();
            String version = containerPath.segment(1);
            if (version == null) break block20;
            switch (version) {
                case "3": 
                case "3.8.1": {
                    entriesList.add(BuildPathSupport.getJUnit4as3LibraryEntry());
                    break;
                }
                case "4": {
                    entriesList.add(BuildPathSupport.getJUnit4LibraryEntry());
                    entriesList.add(BuildPathSupport.getHamcrestLibraryEntry());
                    break;
                }
                case "5": {
                    boolean vintage = JUnitContainerInitializer.isVintage(attributes);
                    entriesList.add(BuildPathSupport.getJUnitJupiterApiLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitJupiterEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitJupiterMigrationSupportLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitJupiterParamsLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformCommonsLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformLauncherLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformRunnerLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformSuiteApiLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformSuiteEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitPlatformSuiteCommonsLibraryEntry());
                    if (vintage) {
                        entriesList.add(BuildPathSupport.getJUnitVintageEngineLibraryEntry());
                    }
                    entriesList.add(BuildPathSupport.getJUnitOpentest4jLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitApiGuardianLibraryEntry());
                    if (vintage) {
                        entriesList.add(BuildPathSupport.getJUnit4LibraryEntry());
                    }
                    entriesList.add(BuildPathSupport.getHamcrestLibraryEntry());
                    entriesList.removeIf(e -> e == null);
                    break;
                }
                case "6": {
                    entriesList.add(BuildPathSupport.getJUnit6JupiterApiLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6JupiterEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6JupiterParamsLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformCommonsLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformLauncherLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformSuiteApiLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformSuiteEngineLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnit6PlatformSuiteCommonsLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitOpentest4jLibraryEntry());
                    entriesList.add(BuildPathSupport.getJUnitApiGuardianLibraryEntry());
                    entriesList.add(BuildPathSupport.getHamcrestLibraryEntry());
                    entriesList.removeIf(e -> e == null);
                    break;
                }
            }
        }
        IClasspathEntry[] entries = entriesList.toArray(new IClasspathEntry[entriesList.size()]);
        return new JUnitContainer(containerPath, entries);
    }

    private static boolean isVintage(IClasspathAttribute[] attributes) {
        if (attributes != null) {
            IClasspathAttribute[] iClasspathAttributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathAttribute attribute = iClasspathAttributeArray[n2];
                if ("vintage".equals(attribute.getName())) {
                    return Boolean.parseBoolean(attribute.getValue());
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean isValidJUnitContainerPath(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.jdt.junit.JUNIT_CONTAINER".equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public IStatus getAccessRulesStatus(IPath containerPath, IJavaProject project) {
        return READ_ONLY;
    }

    public IStatus getSourceAttachmentStatus(IPath containerPath, IJavaProject project) {
        return READ_ONLY;
    }

    public IStatus getAttributeStatus(IPath containerPath, IJavaProject project, String attributeKey) {
        if ("javadoc_location".equals(attributeKey)) {
            return Status.OK_STATUS;
        }
        return NOT_SUPPORTED;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.junit.core");
        IClasspathEntry[] entries = containerSuggestion.getClasspathEntries();
        if (entries.length >= 1 && JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            String version = containerPath.segment(1);
            IClasspathEntry[] iClasspathEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                String preferenceKey = this.getPreferenceKey(entry, version);
                IClasspathAttribute[] extraAttributes = entry.getExtraAttributes();
                if (extraAttributes.length == 0) {
                    String defaultValue = DefaultScope.INSTANCE.getNode("org.eclipse.jdt.junit.core").get(preferenceKey, "");
                    if (!defaultValue.equals(preferences.get(preferenceKey, defaultValue))) {
                        preferences.put(preferenceKey, defaultValue);
                    }
                } else {
                    IClasspathAttribute[] iClasspathAttributeArray = extraAttributes;
                    int n3 = extraAttributes.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IClasspathAttribute attrib = iClasspathAttributeArray[n4];
                        if ("javadoc_location".equals(attrib.getName())) {
                            if (preferenceKey == null) break;
                            preferences.put(preferenceKey, attrib.getValue());
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            JUnitContainerInitializer.rebindClasspathEntries(project.getJavaModel(), containerPath);
        }
    }

    private String getPreferenceKey(IClasspathEntry entry, String version) {
        if (JUNIT3.equals(version)) {
            return "org.eclipse.jdt.junit.junit3.javadoclocation";
        }
        String lastSegment = entry.getPath().lastSegment();
        if (JUNIT4.equals(version)) {
            if (lastSegment.contains("junit")) {
                return "org.eclipse.jdt.junit.junit4.javadoclocation";
            }
            return "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation";
        }
        if (JUNIT5.equals(version)) {
            if (lastSegment.contains("jupiter.api") || lastSegment.contains("jupiter-api")) {
                return "org.eclipse.jdt.junit.junit5.jupiter.api.javadoclocation";
            }
            if (lastSegment.contains("jupiter.engine") || lastSegment.contains("jupiter-engine")) {
                return "org.eclipse.jdt.junit.junit5.jupiter.engine.javadoclocation";
            }
            if (lastSegment.contains("jupiter.migrationsupport") || lastSegment.contains("jupiter-migrationsupport")) {
                return "org.eclipse.jdt.junit.junit5.jupiter.migrationsupport.javadoclocation";
            }
            if (lastSegment.contains("jupiter.params") || lastSegment.contains("jupiter-params")) {
                return "org.eclipse.jdt.junit.junit5.jupiter.params.javadoclocation";
            }
            if (lastSegment.contains("platform.commons") || lastSegment.contains("platform-commons")) {
                return "org.eclipse.jdt.junit.junit5.platform.commons.javadoclocation";
            }
            if (lastSegment.contains("platform.engine") || lastSegment.contains("platform-engine")) {
                return "org.eclipse.jdt.junit.junit5.platform.engine.javadoclocation";
            }
            if (lastSegment.contains("platform.launcher") || lastSegment.contains("platform-launcher")) {
                return "org.eclipse.jdt.junit.junit5.platform.launcher.javadoclocation";
            }
            if (lastSegment.contains("platform.runner") || lastSegment.contains("platform-runner")) {
                return "org.eclipse.jdt.junit.junit5.platform.runner.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.api") || lastSegment.contains("platform-suite-api")) {
                return "org.eclipse.jdt.junit.junit5.platform.suite.api.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.engine") || lastSegment.contains("platform-suite-engine")) {
                return "org.eclipse.jdt.junit.junit5.platform.suite.engine.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.commons") || lastSegment.contains("platform-suite-commons")) {
                return "org.eclipse.jdt.junit.junit5.platform.suite.commons.javadoclocation";
            }
            if (lastSegment.contains("vintage.engine") || lastSegment.contains("vintage-engine")) {
                return "org.eclipse.jdt.junit.junit5.vintage.engine.javadoclocation";
            }
            if (lastSegment.contains("opentest4j")) {
                return "org.eclipse.jdt.junit.junit5.opentest4j.javadoclocation";
            }
            if (lastSegment.contains("apiguardian")) {
                return "org.eclipse.jdt.junit.junit5.apiguardian.javadoclocation";
            }
            if (lastSegment.contains("junit")) {
                return "org.eclipse.jdt.junit.junit4.javadoclocation";
            }
            return "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation";
        }
        if (JUNIT6.equals(version)) {
            if (lastSegment.contains("jupiter.api") || lastSegment.contains("jupiter-api")) {
                return "org.eclipse.jdt.junit.junit6.jupiter.api.javadoclocation";
            }
            if (lastSegment.contains("jupiter.engine") || lastSegment.contains("jupiter-engine")) {
                return "org.eclipse.jdt.junit.junit6.jupiter.engine.javadoclocation";
            }
            if (lastSegment.contains("jupiter.params") || lastSegment.contains("jupiter-params")) {
                return "org.eclipse.jdt.junit.junit6.jupiter.params.javadoclocation";
            }
            if (lastSegment.contains("platform.commons") || lastSegment.contains("platform-commons")) {
                return "org.eclipse.jdt.junit.junit6.platform.commons.javadoclocation";
            }
            if (lastSegment.contains("platform.engine") || lastSegment.contains("platform-engine")) {
                return "org.eclipse.jdt.junit.junit6.platform.engine.javadoclocation";
            }
            if (lastSegment.contains("platform.launcher") || lastSegment.contains("platform-launcher")) {
                return "org.eclipse.jdt.junit.junit6.platform.launcher.javadoclocation";
            }
            if (lastSegment.contains("platform.runner") || lastSegment.contains("platform-runner")) {
                return "org.eclipse.jdt.junit.junit6.platform.runner.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.api") || lastSegment.contains("platform-suite-api")) {
                return "org.eclipse.jdt.junit.junit6.platform.suite.api.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.engine") || lastSegment.contains("platform-suite-engine")) {
                return "org.eclipse.jdt.junit.junit6.platform.suite.engine.javadoclocation";
            }
            if (lastSegment.contains("platform.suite.commons") || lastSegment.contains("platform-suite-commons")) {
                return "org.eclipse.jdt.junit.junit6.platform.suite.commons.javadoclocation";
            }
            if (lastSegment.contains("vintage.engine") || lastSegment.contains("vintage-engine")) {
                return "org.eclipse.jdt.junit.junit6.vintage.engine.javadoclocation";
            }
            if (lastSegment.contains("opentest4j")) {
                return "org.eclipse.jdt.junit.junit5.opentest4j.javadoclocation";
            }
            if (lastSegment.contains("apiguardian")) {
                return "org.eclipse.jdt.junit.junit5.apiguardian.javadoclocation";
            }
            if (lastSegment.contains("junit")) {
                return "org.eclipse.jdt.junit.junit4.javadoclocation";
            }
            return "org.eclipse.jdt.junit.junit4.hamcrest.core.javadoclocation";
        }
        return null;
    }

    private static void rebindClasspathEntries(IJavaModel model, IPath containerPath) throws JavaModelException {
        IJavaProject[] projects;
        ArrayList<IJavaProject> affectedProjects = new ArrayList<IJavaProject>();
        ArrayList<IClasspathAttribute[]> attributesProjects = new ArrayList<IClasspathAttribute[]>();
        IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry[] entries;
            IJavaProject project = iJavaProjectArray[n2];
            IClasspathEntry[] iClasspathEntryArray = entries = project.getRawClasspath();
            int n3 = entries.length;
            int n4 = 0;
            while (n4 < n3) {
                IClasspathEntry curr = iClasspathEntryArray[n4];
                if (curr.getEntryKind() == 5 && containerPath.equals((Object)curr.getPath())) {
                    affectedProjects.add(project);
                    attributesProjects.add(curr.getExtraAttributes());
                }
                ++n4;
            }
            ++n2;
        }
        if (!affectedProjects.isEmpty()) {
            IJavaProject[] affected = affectedProjects.toArray(new IJavaProject[affectedProjects.size()]);
            IClasspathContainer[] containers = new IClasspathContainer[affected.length];
            int i = 0;
            while (i < containers.length) {
                containers[i] = JUnitContainerInitializer.getNewContainer(containerPath, (IClasspathAttribute[])attributesProjects.get(i));
                ++i;
            }
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])affected, (IClasspathContainer[])containers, null);
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        block18: {
            String version;
            if (!JUnitContainerInitializer.isValidJUnitContainerPath(containerPath) || (version = containerPath.segment(1)) == null) break block18;
            switch (version) {
                case "3": 
                case "3.8.1": {
                    return JUnitMessages.JUnitContainerInitializer_description_initializer_junit3;
                }
                case "4": {
                    return JUnitMessages.JUnitContainerInitializer_description_initializer_junit4;
                }
                case "5": {
                    return JUnitMessages.JUnitContainerInitializer_description_initializer_junit5;
                }
                case "6": {
                    return JUnitMessages.JUnitContainerInitializer_description_initializer_junit6;
                }
            }
        }
        return JUnitMessages.JUnitContainerInitializer_description_initializer_unresolved;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private static class JUnitContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public JUnitContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            if (JUnitCore.JUNIT6_CONTAINER_PATH.equals((Object)this.fPath)) {
                return JUnitMessages.JUnitContainerInitializer_description_junit6;
            }
            if (JUnitCore.JUNIT5_CONTAINER_PATH.equals((Object)this.fPath)) {
                return JUnitMessages.JUnitContainerInitializer_description_junit5;
            }
            if (JUnitCore.JUNIT4_CONTAINER_PATH.equals((Object)this.fPath)) {
                return JUnitMessages.JUnitContainerInitializer_description_junit4;
            }
            return JUnitMessages.JUnitContainerInitializer_description_junit3;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

