#
# This script regenerates the list of entities
#

using JSON
using Downloads


#
# Download entities list from HTML5 spec
#
stream = IOBuffer()
Downloads.download("https://html.spec.whatwg.org/entities.json", stream)
content = takestring!(stream)
entities = JSON.parse(content)

#
# Generate Julia list of entities
#
function escape_spec_string(s::String)
    s = Base.escape_string(s)
    # avoid string interpolation
    s = replace(s, "\$" => raw"\$")
    # encode non-breaking whitespace to make contrib/check-whitespace.jl happy
    s = replace(s, "\uA0" => raw"\uA0")
    return s
end

open("src/Common/entities.jl", "w") do io
    print(io, """
        # WARNING: this file was generated by $(basename(@__FILE__)), do not edit it directly.

        const entities = Dict{String, String}(
        """)

    for (k,v) in entities
        c = escape_spec_string(v["characters"])
        print(io, """
                "$k" => "$c",
            """)
    end
    println(io, ")")
end
