# WARNING: this file was generated by regenerate_test_spec.jl, do not edit it directly.

using Test
using Markdown

@testset "CommonMark spec test suite: roundtrip mode, julia flavor" begin


#
# Tabs
#
@testset "Tabs" begin

    # Example 1
    input = "\tfoo\tbaz\t\tbim\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 2
    input = "  \tfoo\tbaz\t\tbim\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 3
    input = "    a\ta\n    ὐ\ta\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 4
    input = "  - foo\n\n\tbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 5
    input = "- foo\n\n\t\tbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 6
    input = ">\t\tfoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 7
    input = "-\t\tfoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 8
    input = "    foo\n\tbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 9
    input = " - foo\n   - bar\n\t - baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 10
    input = "#\tFoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 11
    input = "*\t*\t*\t\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Backslash escapes
#
@testset "Backslash escapes" begin

    # Example 12
    input = "\\!\\\"\\#\\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\?\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 13
    input = "\\\t\\A\\a\\ \\3\\φ\\«\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 14
    input = "\\*not emphasized*\n\\<br/> not a tag\n\\[not a link](/foo)\n\\`not code`\n1\\. not a list\n\\* not a list\n\\# not a heading\n\\[foo]: /url \"not a reference\"\n\\&ouml; not a character entity\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 15
    input = "\\\\*emphasis*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 16
    input = "foo\\\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 17
    input = "`` \\[\\` ``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 18
    input = "    \\[\\]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 19
    input = "~~~\n\\[\\]\n~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 20
    input = "<https://example.com?find=\\*>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 21
    input = "<a href=\"/bar\\/)\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 22
    input = "[foo](/bar\\* \"ti\\*tle\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 23
    input = "[foo]\n\n[foo]: /bar\\* \"ti\\*tle\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 24
    input = "``` foo\\+bar\nfoo\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Entity and numeric character references
#
@testset "Entity and numeric character references" begin

    # Example 25
    input = "&nbsp; &amp; &copy; &AElig; &Dcaron;\n&frac34; &HilbertSpace; &DifferentialD;\n&ClockwiseContourIntegral; &ngE;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 26
    input = "&#35; &#1234; &#992; &#0;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 27
    input = "&#X22; &#XD06; &#xcab;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 28
    input = "&nbsp &x; &#; &#x;\n&#87654321;\n&#abcdef0;\n&ThisIsNotDefined; &hi?;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 29
    input = "&copy\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 30
    input = "&MadeUpEntity;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 31
    input = "<a href=\"&ouml;&ouml;.html\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 32
    input = "[foo](/f&ouml;&ouml; \"f&ouml;&ouml;\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 33
    input = "[foo]\n\n[foo]: /f&ouml;&ouml; \"f&ouml;&ouml;\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 34
    input = "``` f&ouml;&ouml;\nfoo\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 35
    input = "`f&ouml;&ouml;`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 36
    input = "    f&ouml;f&ouml;\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 37
    input = "&#42;foo&#42;\n*foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 38
    input = "&#42; foo\n\n* foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 39
    input = "foo&#10;&#10;bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 40
    input = "&#9;foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 41
    input = "[a](url &quot;tit&quot;)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Precedence
#
@testset "Precedence" begin

    # Example 42
    input = "- `one\n- two`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Thematic breaks
#
@testset "Thematic breaks" begin

    # Example 43
    input = "***\n---\n___\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 44
    input = "+++\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 45
    input = "===\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 46
    input = "--\n**\n__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 47
    input = " ***\n  ***\n   ***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 48
    input = "    ***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 49
    input = "Foo\n    ***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 50
    input = "_____________________________________\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 51
    input = " - - -\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 52
    input = " **  * ** * ** * **\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 53
    input = "-     -      -      -\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 54
    input = "- - - -    \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 55
    input = "_ _ _ _ a\n\na------\n\n---a---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 56
    input = " *-*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 57
    input = "- foo\n***\n- bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 58
    input = "Foo\n***\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 59
    input = "Foo\n---\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 60
    input = "* Foo\n* * *\n* Bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 61
    input = "- Foo\n- * * *\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# ATX headings
#
@testset "ATX headings" begin

    # Example 62
    input = "# foo\n## foo\n### foo\n#### foo\n##### foo\n###### foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 63
    input = "####### foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 64
    input = "#5 bolt\n\n#hashtag\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 65
    input = "\\## foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 66
    input = "# foo *bar* \\*baz\\*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 67
    input = "#                  foo                     \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 68
    input = " ### foo\n  ## foo\n   # foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 69
    input = "    # foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 70
    input = "foo\n    # bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 71
    input = "## foo ##\n  ###   bar    ###\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 72
    input = "# foo ##################################\n##### foo ##\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 73
    input = "### foo ###     \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 74
    input = "### foo ### b\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 75
    input = "# foo#\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 76
    input = "### foo \\###\n## foo #\\##\n# foo \\#\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 77
    input = "****\n## foo\n****\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 78
    input = "Foo bar\n# baz\nBar foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 79
    input = "## \n#\n### ###\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Setext headings
#
@testset "Setext headings" begin

    # Example 80
    input = "Foo *bar*\n=========\n\nFoo *bar*\n---------\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 81
    input = "Foo *bar\nbaz*\n====\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 82
    input = "  Foo *bar\nbaz*\t\n====\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 83
    input = "Foo\n-------------------------\n\nFoo\n=\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 84
    input = "   Foo\n---\n\n  Foo\n-----\n\n  Foo\n  ===\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 85
    input = "    Foo\n    ---\n\n    Foo\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 86
    input = "Foo\n   ----      \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 87
    input = "Foo\n    ---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 88
    input = "Foo\n= =\n\nFoo\n--- -\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 89
    input = "Foo  \n-----\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 90
    input = "Foo\\\n----\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 91
    input = "`Foo\n----\n`\n\n<a title=\"a lot\n---\nof dashes\"/>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 92
    input = "> Foo\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 93
    input = "> foo\nbar\n===\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 94
    input = "- Foo\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 95
    input = "Foo\nBar\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 96
    input = "---\nFoo\n---\nBar\n---\nBaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 97
    input = "\n====\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 98
    input = "---\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 99
    input = "- foo\n-----\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 100
    input = "    foo\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 101
    input = "> foo\n-----\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 102
    input = "\\> foo\n------\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 103
    input = "Foo\n\nbar\n---\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 104
    input = "Foo\nbar\n\n---\n\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 105
    input = "Foo\nbar\n* * *\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 106
    input = "Foo\nbar\n\\---\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Indented code blocks
#
@testset "Indented code blocks" begin

    # Example 107
    input = "    a simple\n      indented code block\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 108
    input = "  - foo\n\n    bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 109
    input = "1.  foo\n\n    - bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 110
    input = "    <a/>\n    *hi*\n\n    - one\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 111
    input = "    chunk1\n\n    chunk2\n  \n \n \n    chunk3\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 112
    input = "    chunk1\n      \n      chunk2\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 113
    input = "Foo\n    bar\n\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 114
    input = "    foo\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 115
    input = "# Heading\n    foo\nHeading\n------\n    foo\n----\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 116
    input = "        foo\n    bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 117
    input = "\n    \n    foo\n    \n\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 118
    input = "    foo  \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Fenced code blocks
#
@testset "Fenced code blocks" begin

    # Example 119
    input = "```\n<\n >\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 120
    input = "~~~\n<\n >\n~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 121
    input = "``\nfoo\n``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 122
    input = "```\naaa\n~~~\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 123
    input = "~~~\naaa\n```\n~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 124
    input = "````\naaa\n```\n``````\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 125
    input = "~~~~\naaa\n~~~\n~~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 126
    input = "```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 127
    input = "`````\n\n```\naaa\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 128
    input = "> ```\n> aaa\n\nbbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 129
    input = "```\n\n  \n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 130
    input = "```\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 131
    input = " ```\n aaa\naaa\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 132
    input = "  ```\naaa\n  aaa\naaa\n  ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 133
    input = "   ```\n   aaa\n    aaa\n  aaa\n   ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 134
    input = "    ```\n    aaa\n    ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 135
    input = "```\naaa\n  ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 136
    input = "   ```\naaa\n  ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 137
    input = "```\naaa\n    ```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 138
    input = "``` ```\naaa\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 139
    input = "~~~~~~\naaa\n~~~ ~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 140
    input = "foo\n```\nbar\n```\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 141
    input = "foo\n---\n~~~\nbar\n~~~\n# baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 142
    input = "```ruby\ndef foo(x)\n  return 3\nend\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 143
    input = "~~~~    ruby startline=3 \$%@#\$\ndef foo(x)\n  return 3\nend\n~~~~~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 144
    input = "````;\n````\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 145
    input = "``` aa ```\nfoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 146
    input = "~~~ aa ``` ~~~\nfoo\n~~~\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 147
    input = "```\n``` aaa\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# HTML blocks
#
@testset "HTML blocks" begin

    # Example 148
    input = "<table><tr><td>\n<pre>\n**Hello**,\n\n_world_.\n</pre>\n</td></tr></table>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 149
    input = "<table>\n  <tr>\n    <td>\n           hi\n    </td>\n  </tr>\n</table>\n\nokay.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 150
    input = " <div>\n  *hello*\n         <foo><a>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 151
    input = "</div>\n*foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 152
    input = "<DIV CLASS=\"foo\">\n\n*Markdown*\n\n</DIV>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 153
    input = "<div id=\"foo\"\n  class=\"bar\">\n</div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 154
    input = "<div id=\"foo\" class=\"bar\n  baz\">\n</div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 155
    input = "<div>\n*foo*\n\n*bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 156
    input = "<div id=\"foo\"\n*hi*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 157
    input = "<div class\nfoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 158
    input = "<div *???-&&&-<---\n*foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 159
    input = "<div><a href=\"bar\">*foo*</a></div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 160
    input = "<table><tr><td>\nfoo\n</td></tr></table>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 161
    input = "<div></div>\n``` c\nint x = 33;\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 162
    input = "<a href=\"foo\">\n*bar*\n</a>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 163
    input = "<Warning>\n*bar*\n</Warning>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 164
    input = "<i class=\"foo\">\n*bar*\n</i>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 165
    input = "</ins>\n*bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 166
    input = "<del>\n*foo*\n</del>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 167
    input = "<del>\n\n*foo*\n\n</del>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 168
    input = "<del>*foo*</del>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 169
    input = "<pre language=\"haskell\"><code>\nimport Text.HTML.TagSoup\n\nmain :: IO ()\nmain = print \$ parseTags tags\n</code></pre>\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 170
    input = "<script type=\"text/javascript\">\n// JavaScript example\n\ndocument.getElementById(\"demo\").innerHTML = \"Hello JavaScript!\";\n</script>\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 171
    input = "<textarea>\n\n*foo*\n\n_bar_\n\n</textarea>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 172
    input = "<style\n  type=\"text/css\">\nh1 {color:red;}\n\np {color:blue;}\n</style>\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 173
    input = "<style\n  type=\"text/css\">\n\nfoo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 174
    input = "> <div>\n> foo\n\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 175
    input = "- <div>\n- foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 176
    input = "<style>p{color:red;}</style>\n*foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 177
    input = "<!-- foo -->*bar*\n*baz*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 178
    input = "<script>\nfoo\n</script>1. *bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 179
    input = "<!-- Foo\n\nbar\n   baz -->\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 180
    input = "<?php\n\n  echo '>';\n\n?>\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 181
    input = "<!DOCTYPE html>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 182
    input = "<![CDATA[\nfunction matchwo(a,b)\n{\n  if (a < b && a < 0) then {\n    return 1;\n\n  } else {\n\n    return 0;\n  }\n}\n]]>\nokay\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 183
    input = "  <!-- foo -->\n\n    <!-- foo -->\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 184
    input = "  <div>\n\n    <div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 185
    input = "Foo\n<div>\nbar\n</div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 186
    input = "<div>\nbar\n</div>\n*foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 187
    input = "Foo\n<a href=\"bar\">\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 188
    input = "<div>\n\n*Emphasized* text.\n\n</div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 189
    input = "<div>\n*Emphasized* text.\n</div>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 190
    input = "<table>\n\n<tr>\n\n<td>\nHi\n</td>\n\n</tr>\n\n</table>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 191
    input = "<table>\n\n  <tr>\n\n    <td>\n      Hi\n    </td>\n\n  </tr>\n\n</table>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Link reference definitions
#
@testset "Link reference definitions" begin

    # Example 192
    input = "[foo]: /url \"title\"\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 193
    input = "   [foo]: \n      /url  \n           'the title'  \n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 194
    input = "[Foo*bar\\]]:my_(url) 'title (with parens)'\n\n[Foo*bar\\]]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 195
    input = "[Foo bar]:\n<my url>\n'title'\n\n[Foo bar]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 196
    input = "[foo]: /url '\ntitle\nline1\nline2\n'\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 197
    input = "[foo]: /url 'title\n\nwith blank line'\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 198
    input = "[foo]:\n/url\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 199
    input = "[foo]:\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 200
    input = "[foo]: <>\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 201
    input = "[foo]: <bar>(baz)\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 202
    input = "[foo]: /url\\bar\\*baz \"foo\\\"bar\\baz\"\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 203
    input = "[foo]\n\n[foo]: url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 204
    input = "[foo]\n\n[foo]: first\n[foo]: second\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 205
    input = "[FOO]: /url\n\n[Foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 206
    input = "[ΑΓΩ]: /φου\n\n[αγω]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 207
    input = "[foo]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 208
    input = "[\nfoo\n]: /url\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 209
    input = "[foo]: /url \"title\" ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 210
    input = "[foo]: /url\n\"title\" ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 211
    input = "    [foo]: /url \"title\"\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 212
    input = "```\n[foo]: /url\n```\n\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 213
    input = "Foo\n[bar]: /baz\n\n[bar]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 214
    input = "# [Foo]\n[foo]: /url\n> bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 215
    input = "[foo]: /url\nbar\n===\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 216
    input = "[foo]: /url\n===\n[foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 217
    input = "[foo]: /foo-url \"foo\"\n[bar]: /bar-url\n  \"bar\"\n[baz]: /baz-url\n\n[foo],\n[bar],\n[baz]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 218
    input = "[foo]\n\n> [foo]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Paragraphs
#
@testset "Paragraphs" begin

    # Example 219
    input = "aaa\n\nbbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 220
    input = "aaa\nbbb\n\nccc\nddd\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 221
    input = "aaa\n\n\nbbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 222
    input = "  aaa\n bbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 223
    input = "aaa\n             bbb\n                                       ccc\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 224
    input = "   aaa\nbbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 225
    input = "    aaa\nbbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 226
    input = "aaa     \nbbb     \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Blank lines
#
@testset "Blank lines" begin

    # Example 227
    input = "  \n\naaa\n  \n\n# aaa\n\n  \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Block quotes
#
@testset "Block quotes" begin

    # Example 228
    input = "> # Foo\n> bar\n> baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 229
    input = "># Foo\n>bar\n> baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 230
    input = "   > # Foo\n   > bar\n > baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 231
    input = "    > # Foo\n    > bar\n    > baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 232
    input = "> # Foo\n> bar\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 233
    input = "> bar\nbaz\n> foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 234
    input = "> foo\n---\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 235
    input = "> - foo\n- bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 236
    input = ">     foo\n    bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 237
    input = "> ```\nfoo\n```\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 238
    input = "> foo\n    - bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 239
    input = ">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 240
    input = ">\n>  \n> \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 241
    input = ">\n> foo\n>  \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 242
    input = "> foo\n\n> bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 243
    input = "> foo\n> bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 244
    input = "> foo\n>\n> bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 245
    input = "foo\n> bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 246
    input = "> aaa\n***\n> bbb\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 247
    input = "> bar\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 248
    input = "> bar\n\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 249
    input = "> bar\n>\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 250
    input = "> > > foo\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 251
    input = ">>> foo\n> bar\n>>baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 252
    input = ">     code\n\n>    not code\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# List items
#
@testset "List items" begin

    # Example 253
    input = "A paragraph\nwith two lines.\n\n    indented code\n\n> A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 254
    input = "1.  A paragraph\n    with two lines.\n\n        indented code\n\n    > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 255
    input = "- one\n\n two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 256
    input = "- one\n\n  two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 257
    input = " -    one\n\n     two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 258
    input = " -    one\n\n      two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 259
    input = "   > > 1.  one\n>>\n>>     two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 260
    input = ">>- one\n>>\n  >  > two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 261
    input = "-one\n\n2.two\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 262
    input = "- foo\n\n\n  bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 263
    input = "1.  foo\n\n    ```\n    bar\n    ```\n\n    baz\n\n    > bam\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 264
    input = "- Foo\n\n      bar\n\n\n      baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 265
    input = "123456789. ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 266
    input = "1234567890. not ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 267
    input = "0. ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 268
    input = "003. ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 269
    input = "-1. not ok\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 270
    input = "- foo\n\n      bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 271
    input = "  10.  foo\n\n           bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 272
    input = "    indented code\n\nparagraph\n\n    more code\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 273
    input = "1.     indented code\n\n   paragraph\n\n       more code\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 274
    input = "1.      indented code\n\n   paragraph\n\n       more code\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 275
    input = "   foo\n\nbar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 276
    input = "-    foo\n\n  bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 277
    input = "-  foo\n\n   bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 278
    input = "-\n  foo\n-\n  ```\n  bar\n  ```\n-\n      baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 279
    input = "-   \n  foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 280
    input = "-\n\n  foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 281
    input = "- foo\n-\n- bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 282
    input = "- foo\n-   \n- bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 283
    input = "1. foo\n2.\n3. bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 284
    input = "*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 285
    input = "foo\n*\n\nfoo\n1.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 286
    input = " 1.  A paragraph\n     with two lines.\n\n         indented code\n\n     > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 287
    input = "  1.  A paragraph\n      with two lines.\n\n          indented code\n\n      > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 288
    input = "   1.  A paragraph\n       with two lines.\n\n           indented code\n\n       > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 289
    input = "    1.  A paragraph\n        with two lines.\n\n            indented code\n\n        > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 290
    input = "  1.  A paragraph\nwith two lines.\n\n          indented code\n\n      > A block quote.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 291
    input = "  1.  A paragraph\n    with two lines.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 292
    input = "> 1. > Blockquote\ncontinued here.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 293
    input = "> 1. > Blockquote\n> continued here.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 294
    input = "- foo\n  - bar\n    - baz\n      - boo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 295
    input = "- foo\n - bar\n  - baz\n   - boo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 296
    input = "10) foo\n    - bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 297
    input = "10) foo\n   - bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 298
    input = "- - foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 299
    input = "1. - 2. foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 300
    input = "- # Foo\n- Bar\n  ---\n  baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

end

#
# Lists
#
@testset "Lists" begin

    # Example 301
    input = "- foo\n- bar\n+ baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 302
    input = "1. foo\n2. bar\n3) baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 303
    input = "Foo\n- bar\n- baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 304
    input = "The number of windows in my house is\n14.  The number of doors is 6.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 305
    input = "The number of windows in my house is\n1.  The number of doors is 6.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 306
    input = "- foo\n\n- bar\n\n\n- baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 307
    input = "- foo\n  - bar\n    - baz\n\n\n      bim\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 308
    input = "- foo\n- bar\n\n<!-- -->\n\n- baz\n- bim\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 309
    input = "-   foo\n\n    notcode\n\n-   foo\n\n<!-- -->\n\n    code\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 310
    input = "- a\n - b\n  - c\n   - d\n  - e\n - f\n- g\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 311
    input = "1. a\n\n  2. b\n\n   3. c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 312
    input = "- a\n - b\n  - c\n   - d\n    - e\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 313
    input = "1. a\n\n  2. b\n\n    3. c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 314
    input = "- a\n- b\n\n- c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 315
    input = "* a\n*\n\n* c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 316
    input = "- a\n- b\n\n  c\n- d\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 317
    input = "- a\n- b\n\n  [ref]: /url\n- d\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 318
    input = "- a\n- ```\n  b\n\n\n  ```\n- c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 319
    input = "- a\n  - b\n\n    c\n- d\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 320
    input = "* a\n  > b\n  >\n* c\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 321
    input = "- a\n  > b\n  ```\n  c\n  ```\n- d\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 322
    input = "- a\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 323
    input = "- a\n  - b\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 324
    input = "1. ```\n   foo\n   ```\n\n   bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 325
    input = "* foo\n  * bar\n\n  baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 326
    input = "- a\n  - b\n  - c\n\n- d\n  - e\n  - f\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

end

#
# Inlines
#
@testset "Inlines" begin

    # Example 327
    input = "`hi`lo`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Code spans
#
@testset "Code spans" begin

    # Example 328
    input = "`foo`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 329
    input = "`` foo ` bar ``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 330
    input = "` `` `\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 331
    input = "`  ``  `\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 332
    input = "` a`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 333
    input = "`\u00A0b\u00A0`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 334
    input = "`\u00A0`\n`  `\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 335
    input = "``\nfoo\nbar  \nbaz\n``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 336
    input = "``\nfoo \n``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 337
    input = "`foo   bar \nbaz`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 338
    input = "`foo\\`bar`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 339
    input = "``foo`bar``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 340
    input = "` foo `` bar `\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 341
    input = "*foo`*`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 342
    input = "[not a `link](/foo`)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 343
    input = "`<a href=\"`\">`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 344
    input = "<a href=\"`\">`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 345
    input = "`<https://foo.bar.`baz>`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 346
    input = "<https://foo.bar.`baz>`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 347
    input = "```foo``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 348
    input = "`foo\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 349
    input = "`foo``bar``\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Emphasis and strong emphasis
#
@testset "Emphasis and strong emphasis" begin

    # Example 350
    input = "*foo bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 351
    input = "a * foo bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 352
    input = "a*\"foo\"*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 353
    input = "*\u00A0a\u00A0*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 354
    input = "*\$*alpha.\n\n*£*bravo.\n\n*€*charlie.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 355
    input = "foo*bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 356
    input = "5*6*78\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 357
    input = "_foo bar_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 358
    input = "_ foo bar_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 359
    input = "a_\"foo\"_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 360
    input = "foo_bar_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 361
    input = "5_6_78\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 362
    input = "пристаням_стремятся_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 363
    input = "aa_\"bb\"_cc\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 364
    input = "foo-_(bar)_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 365
    input = "_foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 366
    input = "*foo bar *\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 367
    input = "*foo bar\n*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 368
    input = "*(*foo)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 369
    input = "*(*foo*)*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 370
    input = "*foo*bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 371
    input = "_foo bar _\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 372
    input = "_(_foo)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 373
    input = "_(_foo_)_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 374
    input = "_foo_bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 375
    input = "_пристаням_стремятся\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 376
    input = "_foo_bar_baz_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 377
    input = "_(bar)_.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 378
    input = "**foo bar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 379
    input = "** foo bar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 380
    input = "a**\"foo\"**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 381
    input = "foo**bar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 382
    input = "__foo bar__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 383
    input = "__ foo bar__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 384
    input = "__\nfoo bar__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 385
    input = "a__\"foo\"__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 386
    input = "foo__bar__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 387
    input = "5__6__78\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 388
    input = "пристаням__стремятся__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 389
    input = "__foo, __bar__, baz__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 390
    input = "foo-__(bar)__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 391
    input = "**foo bar **\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 392
    input = "**(**foo)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 393
    input = "*(**foo**)*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 394
    input = "**Gomphocarpus (*Gomphocarpus physocarpus*, syn.\n*Asclepias physocarpa*)**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 395
    input = "**foo \"*bar*\" foo**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 396
    input = "**foo**bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 397
    input = "__foo bar __\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 398
    input = "__(__foo)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 399
    input = "_(__foo__)_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 400
    input = "__foo__bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 401
    input = "__пристаням__стремятся\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 402
    input = "__foo__bar__baz__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 403
    input = "__(bar)__.\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 404
    input = "*foo [bar](/url)*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 405
    input = "*foo\nbar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 406
    input = "_foo __bar__ baz_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 407
    input = "_foo _bar_ baz_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 408
    input = "__foo_ bar_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 409
    input = "*foo *bar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 410
    input = "*foo **bar** baz*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 411
    input = "*foo**bar**baz*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 412
    input = "*foo**bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 413
    input = "***foo** bar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 414
    input = "*foo **bar***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 415
    input = "*foo**bar***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 416
    input = "foo***bar***baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 417
    input = "foo******bar*********baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 418
    input = "*foo **bar *baz* bim** bop*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 419
    input = "*foo [*bar*](/url)*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 420
    input = "** is not an empty emphasis\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 421
    input = "**** is not an empty strong emphasis\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 422
    input = "**foo [bar](/url)**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 423
    input = "**foo\nbar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 424
    input = "__foo _bar_ baz__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 425
    input = "__foo __bar__ baz__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 426
    input = "____foo__ bar__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 427
    input = "**foo **bar****\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 428
    input = "**foo *bar* baz**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 429
    input = "**foo*bar*baz**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 430
    input = "***foo* bar**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 431
    input = "**foo *bar***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 432
    input = "**foo *bar **baz**\nbim* bop**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 433
    input = "**foo [*bar*](/url)**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 434
    input = "__ is not an empty emphasis\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 435
    input = "____ is not an empty strong emphasis\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 436
    input = "foo ***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 437
    input = "foo *\\**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 438
    input = "foo *_*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 439
    input = "foo *****\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 440
    input = "foo **\\***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 441
    input = "foo **_**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 442
    input = "**foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 443
    input = "*foo**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 444
    input = "***foo**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 445
    input = "****foo*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 446
    input = "**foo***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 447
    input = "*foo****\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 448
    input = "foo ___\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 449
    input = "foo _\\__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 450
    input = "foo _*_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 451
    input = "foo _____\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 452
    input = "foo __\\___\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 453
    input = "foo __*__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 454
    input = "__foo_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 455
    input = "_foo__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 456
    input = "___foo__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 457
    input = "____foo_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 458
    input = "__foo___\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 459
    input = "_foo____\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 460
    input = "**foo**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 461
    input = "*_foo_*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 462
    input = "__foo__\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 463
    input = "_*foo*_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 464
    input = "****foo****\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 465
    input = "____foo____\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 466
    input = "******foo******\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 467
    input = "***foo***\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 468
    input = "_____foo_____\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 469
    input = "*foo _bar* baz_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 470
    input = "*foo __bar *baz bim__ bam*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 471
    input = "**foo **bar baz**\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 472
    input = "*foo *bar baz*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 473
    input = "*[bar*](/url)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 474
    input = "_foo [bar_](/url)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 475
    input = "*<img src=\"foo\" title=\"*\"/>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 476
    input = "**<a href=\"**\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 477
    input = "__<a href=\"__\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 478
    input = "*a `*`*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 479
    input = "_a `_`_\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 480
    input = "**a<https://foo.bar/?q=**>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 481
    input = "__a<https://foo.bar/?q=__>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Links
#
@testset "Links" begin

    # Example 482
    input = "[link](/uri \"title\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 483
    input = "[link](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 484
    input = "[](./target.md)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 485
    input = "[link]()\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 486
    input = "[link](<>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 487
    input = "[]()\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 488
    input = "[link](/my uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 489
    input = "[link](</my uri>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 490
    input = "[link](foo\nbar)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 491
    input = "[link](<foo\nbar>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 492
    input = "[a](<b)c>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 493
    input = "[link](<foo\\>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 494
    input = "[a](<b)c\n[a](<b)c>\n[a](<b>c)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 495
    input = "[link](\\(foo\\))\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 496
    input = "[link](foo(and(bar)))\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 497
    input = "[link](foo(and(bar))\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 498
    input = "[link](foo\\(and\\(bar\\))\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 499
    input = "[link](<foo(and(bar)>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 500
    input = "[link](foo\\)\\:)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 501
    input = "[link](#fragment)\n\n[link](https://example.com#fragment)\n\n[link](https://example.com?foo=3#frag)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 502
    input = "[link](foo\\bar)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 503
    input = "[link](foo%20b&auml;)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 504
    input = "[link](\"title\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 505
    input = "[link](/url \"title\")\n[link](/url 'title')\n[link](/url (title))\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 506
    input = "[link](/url \"title \\\"&quot;\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 507
    input = "[link](/url\u00A0\"title\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 508
    input = "[link](/url \"title \"and\" title\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 509
    input = "[link](/url 'title \"and\" title')\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 510
    input = "[link](   /uri\n  \"title\"  )\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 511
    input = "[link] (/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 512
    input = "[link [foo [bar]]](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 513
    input = "[link] bar](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 514
    input = "[link [bar](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 515
    input = "[link \\[bar](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 516
    input = "[link *foo **bar** `#`*](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 517
    input = "[![moon](moon.jpg)](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 518
    input = "[foo [bar](/uri)](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 519
    input = "[foo *[bar [baz](/uri)](/uri)*](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 520
    input = "![[[foo](uri1)](uri2)](uri3)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 521
    input = "*[foo*](/uri)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 522
    input = "[foo *bar](baz*)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 523
    input = "*foo [bar* baz]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 524
    input = "[foo <bar attr=\"](baz)\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 525
    input = "[foo`](/uri)`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 526
    input = "[foo<https://example.com/?search=](uri)>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 527
    input = "[foo][bar]\n\n[bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 528
    input = "[link [foo [bar]]][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 529
    input = "[link \\[bar][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 530
    input = "[link *foo **bar** `#`*][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 531
    input = "[![moon](moon.jpg)][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 532
    input = "[foo [bar](/uri)][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 533
    input = "[foo *bar [baz][ref]*][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 534
    input = "*[foo*][ref]\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 535
    input = "[foo *bar][ref]*\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 536
    input = "[foo <bar attr=\"][ref]\">\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 537
    input = "[foo`][ref]`\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 538
    input = "[foo<https://example.com/?search=][ref]>\n\n[ref]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 539
    input = "[foo][BaR]\n\n[bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 540
    input = "[ẞ]\n\n[SS]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 541
    input = "[Foo\n  bar]: /url\n\n[Baz][Foo bar]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 542
    input = "[foo] [bar]\n\n[bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 543
    input = "[foo]\n[bar]\n\n[bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 544
    input = "[foo]: /url1\n\n[foo]: /url2\n\n[bar][foo]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 545
    input = "[bar][foo\\!]\n\n[foo!]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 546
    input = "[foo][ref[]\n\n[ref[]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 547
    input = "[foo][ref[bar]]\n\n[ref[bar]]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 548
    input = "[[[foo]]]\n\n[[[foo]]]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 549
    input = "[foo][ref\\[]\n\n[ref\\[]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 550
    input = "[bar\\\\]: /uri\n\n[bar\\\\]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 551
    input = "[]\n\n[]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 552
    input = "[\n ]\n\n[\n ]: /uri\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 553
    input = "[foo][]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 554
    input = "[*foo* bar][]\n\n[*foo* bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 555
    input = "[Foo][]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 556
    input = "[foo] \n[]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 557
    input = "[foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 558
    input = "[*foo* bar]\n\n[*foo* bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 559
    input = "[[*foo* bar]]\n\n[*foo* bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 560
    input = "[[bar [foo]\n\n[foo]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 561
    input = "[Foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 562
    input = "[foo] bar\n\n[foo]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 563
    input = "\\[foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 564
    input = "[foo*]: /url\n\n*[foo*]\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 565
    input = "[foo][bar]\n\n[foo]: /url1\n[bar]: /url2\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 566
    input = "[foo][]\n\n[foo]: /url1\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 567
    input = "[foo]()\n\n[foo]: /url1\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 568
    input = "[foo](not a link)\n\n[foo]: /url1\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 569
    input = "[foo][bar][baz]\n\n[baz]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 570
    input = "[foo][bar][baz]\n\n[baz]: /url1\n[bar]: /url2\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 571
    input = "[foo][bar][baz]\n\n[baz]: /url1\n[foo]: /url2\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Images
#
@testset "Images" begin

    # Example 572
    input = "![foo](/url \"title\")\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 573
    input = "![foo *bar*]\n\n[foo *bar*]: train.jpg \"train & tracks\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 574
    input = "![foo ![bar](/url)](/url2)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 575
    input = "![foo [bar](/url)](/url2)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 576
    input = "![foo *bar*][]\n\n[foo *bar*]: train.jpg \"train & tracks\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 577
    input = "![foo *bar*][foobar]\n\n[FOOBAR]: train.jpg \"train & tracks\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 578
    input = "![foo](train.jpg)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 579
    input = "My ![foo bar](/path/to/train.jpg  \"title\"   )\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 580
    input = "![foo](<url>)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 581
    input = "![](/url)\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 582
    input = "![foo][bar]\n\n[bar]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 583
    input = "![foo][bar]\n\n[BAR]: /url\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 584
    input = "![foo][]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 585
    input = "![*foo* bar][]\n\n[*foo* bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 586
    input = "![Foo][]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 587
    input = "![foo] \n[]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 588
    input = "![foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 589
    input = "![*foo* bar]\n\n[*foo* bar]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 590
    input = "![[foo]]\n\n[[foo]]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 591
    input = "![Foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 592
    input = "!\\[foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 593
    input = "\\![foo]\n\n[foo]: /url \"title\"\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Autolinks
#
@testset "Autolinks" begin

    # Example 594
    input = "<http://foo.bar.baz>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 595
    input = "<https://foo.bar.baz/test?q=hello&id=22&boolean>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 596
    input = "<irc://foo.bar:2233/baz>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 597
    input = "<MAILTO:FOO@BAR.BAZ>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 598
    input = "<a+b+c:d>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 599
    input = "<made-up-scheme://foo,bar>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 600
    input = "<https://../>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 601
    input = "<localhost:5001/foo>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 602
    input = "<https://foo.bar/baz bim>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 603
    input = "<https://example.com/\\[\\>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 604
    input = "<foo@bar.example.com>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 605
    input = "<foo+special@Bar.baz-bar0.com>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 606
    input = "<foo\\+@bar.example.com>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 607
    input = "<>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 608
    input = "< https://foo.bar >\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 609
    input = "<m:abc>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 610
    input = "<foo.bar.baz>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 611
    input = "https://example.com\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 612
    input = "foo@bar.example.com\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Raw HTML
#
@testset "Raw HTML" begin

    # Example 613
    input = "<a><bab><c2c>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 614
    input = "<a/><b2/>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 615
    input = "<a  /><b2\ndata=\"foo\" >\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 616
    input = "<a foo=\"bar\" bam = 'baz <em>\"</em>'\n_boolean zoop:33=zoop:33 />\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 617
    input = "Foo <responsive-image src=\"foo.jpg\" />\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 618
    input = "<33> <__>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 619
    input = "<a h*#ref=\"hi\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 620
    input = "<a href=\"hi'> <a href=hi'>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 621
    input = "< a><\nfoo><bar/ >\n<foo bar=baz\nbim!bop />\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 622
    input = "<a href='bar'title=title>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 623
    input = "</a></foo >\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 624
    input = "</a href=\"foo\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 625
    input = "foo <!-- this is a --\ncomment - with hyphens -->\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 626
    input = "foo <!--> foo -->\n\nfoo <!---> foo -->\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 627
    input = "foo <?php echo \$a; ?>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test_broken expected == actual

    # Example 628
    input = "foo <!ELEMENT br EMPTY>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 629
    input = "foo <![CDATA[>&<]]>\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 630
    input = "foo <a href=\"&ouml;\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 631
    input = "foo <a href=\"\\*\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 632
    input = "<a href=\"\\\"\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Hard line breaks
#
@testset "Hard line breaks" begin

    # Example 633
    input = "foo  \nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 634
    input = "foo\\\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 635
    input = "foo       \nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 636
    input = "foo  \n     bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 637
    input = "foo\\\n     bar\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 638
    input = "*foo  \nbar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 639
    input = "*foo\\\nbar*\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 640
    input = "`code  \nspan`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 641
    input = "`code\\\nspan`\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 642
    input = "<a href=\"foo  \nbar\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 643
    input = "<a href=\"foo\\\nbar\">\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 644
    input = "foo\\\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 645
    input = "foo  \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 646
    input = "### foo\\\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 647
    input = "### foo  \n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Soft line breaks
#
@testset "Soft line breaks" begin

    # Example 648
    input = "foo\nbaz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 649
    input = "foo \n baz\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

#
# Textual content
#
@testset "Textual content" begin

    # Example 650
    input = "hello \$.;'there\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 651
    input = "Foo χρῆν\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

    # Example 652
    input = "Multiple     spaces\n"
    expected = Markdown.parse(input; flavor=:julia)
    new_input = Markdown.plain(expected)
    actual = Markdown.parse(new_input; flavor=:julia)
    @test expected == actual

end

end
