if !(@isdefined JuliaSyntax)
    using JuliaSyntax
end

using Test

# JuliaSyntax is not only tested on master
if isdefined(Test, :detect_closure_boxes)
    @test isempty(Test.detect_closure_boxes(JuliaSyntax))
end

include("test_utils.jl")
include("test_utils_tests.jl")
include("fuzz_test.jl")

include("utils.jl")
include("kinds.jl")

@testset "Tokenize" begin
    include("tokenize.jl")
end

include("parse_stream.jl")
include("parser.jl")
include("green_node.jl")
include("syntax_node.jl")
if VERSION >= v"1.12"
    include("syntax_graph.jl")
end
include("diagnostics.jl")
include("parser_api.jl")
include("expr.jl")
@testset "Parsing literals from strings" begin
    include("literal_parsing.jl")
end
include("source_files.jl")

if VERSION >= v"1.6"
    # Tests restricted to 1.6+ due to
    # * Core._parse hook doesn't exist on v1.5 and lower
    # * Reference parser bugs which would need workarounds for package parse comparisons
    include("hooks.jl")
    include("parse_packages.jl")
end

include("serialization.jl")

# Basic inference tests
@static if isdefined(Base, :infer_return_type)
    @test Base.infer_return_type(JuliaSyntax.sourcetext, (JuliaSyntax.SyntaxTree,)) <: AbstractString
    @test Base.infer_return_type(JuliaSyntax.byte_range, (JuliaSyntax.SyntaxTree,)) == UnitRange{Int}
end
