# WARNING: this file was generated by regenerate_test_spec.jl, do not edit it directly.

using Test
using Markdown

@testset "CommonMark spec test suite: HTML mode, github flavor" begin


#
# Tabs
#
@testset "Tabs" begin

    # Example 1
    input = "\tfoo\tbaz\t\tbim\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\tbaz\t\tbim\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 2
    input = "  \tfoo\tbaz\t\tbim\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\tbaz\t\tbim\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 3
    input = "    a\ta\n    ὐ\ta\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>a\ta\nὐ\ta\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 4
    input = "  - foo\n\n\tbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<p>bar</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 5
    input = "- foo\n\n\t\tbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<pre><code>  bar\n</code></pre>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 6
    input = ">\t\tfoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<pre><code>  foo\n</code></pre>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 7
    input = "-\t\tfoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<pre><code>  foo\n</code></pre>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 8
    input = "    foo\n\tbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\nbar\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 9
    input = " - foo\n   - bar\n\t - baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo\n<ul>\n<li>bar\n<ul>\n<li>baz</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 10
    input = "#\tFoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>Foo</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 11
    input = "*\t*\t*\t\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Backslash escapes
#
@testset "Backslash escapes" begin

    # Example 12
    input = "\\!\\\"\\#\\\$\\%\\&\\'\\(\\)\\*\\+\\,\\-\\.\\/\\:\\;\\<\\=\\>\\?\\@\\[\\\\\\]\\^\\_\\`\\{\\|\\}\\~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>!&quot;#\$%&amp;'()*+,-./:;&lt;=&gt;?@[\\]^_`{|}~</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 13
    input = "\\\t\\A\\a\\ \\3\\φ\\«\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>\\\t\\A\\a\\ \\3\\φ\\«</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 14
    input = "\\*not emphasized*\n\\<br/> not a tag\n\\[not a link](/foo)\n\\`not code`\n1\\. not a list\n\\* not a list\n\\# not a heading\n\\[foo]: /url \"not a reference\"\n\\&ouml; not a character entity\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*not emphasized*\n&lt;br/&gt; not a tag\n[not a link](/foo)\n`not code`\n1. not a list\n* not a list\n# not a heading\n[foo]: /url &quot;not a reference&quot;\n&amp;ouml; not a character entity</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 15
    input = "\\\\*emphasis*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>\\<em>emphasis</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 16
    input = "foo\\\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 17
    input = "`` \\[\\` ``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>\\[\\`</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 18
    input = "    \\[\\]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>\\[\\]\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 19
    input = "~~~\n\\[\\]\n~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>\\[\\]\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 20
    input = "<https://example.com?find=\\*>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"https://example.com?find=%5C*\">https://example.com?find=\\*</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 21
    input = "<a href=\"/bar\\/)\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<a href=\"/bar\\/)\">\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 22
    input = "[foo](/bar\\* \"ti\\*tle\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/bar*\" title=\"ti*tle\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 23
    input = "[foo]\n\n[foo]: /bar\\* \"ti\\*tle\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/bar*\" title=\"ti*tle\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 24
    input = "``` foo\\+bar\nfoo\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-foo+bar\">foo\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Entity and numeric character references
#
@testset "Entity and numeric character references" begin

    # Example 25
    input = "&nbsp; &amp; &copy; &AElig; &Dcaron;\n&frac34; &HilbertSpace; &DifferentialD;\n&ClockwiseContourIntegral; &ngE;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>\u00A0 &amp; © Æ Ď\n¾ ℋ ⅆ\n∲ ≧̸</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 26
    input = "&#35; &#1234; &#992; &#0;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p># Ӓ Ϡ �</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 27
    input = "&#X22; &#XD06; &#xcab;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&quot; ആ ಫ</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 28
    input = "&nbsp &x; &#; &#x;\n&#87654321;\n&#abcdef0;\n&ThisIsNotDefined; &hi?;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&amp;nbsp &amp;x; &amp;#; &amp;#x;\n&amp;#87654321;\n&amp;#abcdef0;\n&amp;ThisIsNotDefined; &amp;hi?;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 29
    input = "&copy\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&amp;copy</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 30
    input = "&MadeUpEntity;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&amp;MadeUpEntity;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 31
    input = "<a href=\"&ouml;&ouml;.html\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<a href=\"&ouml;&ouml;.html\">\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 32
    input = "[foo](/f&ouml;&ouml; \"f&ouml;&ouml;\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/f%C3%B6%C3%B6\" title=\"föö\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 33
    input = "[foo]\n\n[foo]: /f&ouml;&ouml; \"f&ouml;&ouml;\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/f%C3%B6%C3%B6\" title=\"föö\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 34
    input = "``` f&ouml;&ouml;\nfoo\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-föö\">foo\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 35
    input = "`f&ouml;&ouml;`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>f&amp;ouml;&amp;ouml;</code></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 36
    input = "    f&ouml;f&ouml;\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>f&amp;ouml;f&amp;ouml;\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 37
    input = "&#42;foo&#42;\n*foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*foo*\n<em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 38
    input = "&#42; foo\n\n* foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>* foo</p>\n<ul>\n<li>foo</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 39
    input = "foo&#10;&#10;bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\n\nbar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 40
    input = "&#9;foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>\tfoo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 41
    input = "[a](url &quot;tit&quot;)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[a](url &quot;tit&quot;)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Precedence
#
@testset "Precedence" begin

    # Example 42
    input = "- `one\n- two`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>`one</li>\n<li>two`</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Thematic breaks
#
@testset "Thematic breaks" begin

    # Example 43
    input = "***\n---\n___\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n<hr />\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 44
    input = "+++\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>+++</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 45
    input = "===\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>===</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 46
    input = "--\n**\n__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>--\n**\n__</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 47
    input = " ***\n  ***\n   ***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n<hr />\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 48
    input = "    ***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>***\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 49
    input = "Foo\n    ***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\n***</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 50
    input = "_____________________________________\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 51
    input = " - - -\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 52
    input = " **  * ** * ** * **\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 53
    input = "-     -      -      -\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 54
    input = "- - - -    \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 55
    input = "_ _ _ _ a\n\na------\n\n---a---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_ _ _ _ a</p>\n<p>a------</p>\n<p>---a---</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 56
    input = " *-*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>-</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 57
    input = "- foo\n***\n- bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n</ul>\n<hr />\n<ul>\n<li>bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 58
    input = "Foo\n***\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo</p>\n<hr />\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 59
    input = "Foo\n---\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo</h2>\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 60
    input = "* Foo\n* * *\n* Bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>Foo</li>\n</ul>\n<hr />\n<ul>\n<li>Bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 61
    input = "- Foo\n- * * *\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>Foo</li>\n<li>\n<hr />\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# ATX headings
#
@testset "ATX headings" begin

    # Example 62
    input = "# foo\n## foo\n### foo\n#### foo\n##### foo\n###### foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>foo</h1>\n<h2>foo</h2>\n<h3>foo</h3>\n<h4>foo</h4>\n<h5>foo</h5>\n<h6>foo</h6>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 63
    input = "####### foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>####### foo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 64
    input = "#5 bolt\n\n#hashtag\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>#5 bolt</p>\n<p>#hashtag</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 65
    input = "\\## foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>## foo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 66
    input = "# foo *bar* \\*baz\\*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>foo <em>bar</em> *baz*</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 67
    input = "#                  foo                     \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>foo</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 68
    input = " ### foo\n  ## foo\n   # foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo</h3>\n<h2>foo</h2>\n<h1>foo</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 69
    input = "    # foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code># foo\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 70
    input = "foo\n    # bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\n# bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 71
    input = "## foo ##\n  ###   bar    ###\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>foo</h2>\n<h3>bar</h3>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 72
    input = "# foo ##################################\n##### foo ##\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>foo</h1>\n<h5>foo</h5>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 73
    input = "### foo ###     \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo</h3>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 74
    input = "### foo ### b\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo ### b</h3>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 75
    input = "# foo#\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>foo#</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 76
    input = "### foo \\###\n## foo #\\##\n# foo \\#\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo ###</h3>\n<h2>foo ###</h2>\n<h1>foo #</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 77
    input = "****\n## foo\n****\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n<h2>foo</h2>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 78
    input = "Foo bar\n# baz\nBar foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo bar</p>\n<h1>baz</h1>\n<p>Bar foo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 79
    input = "## \n#\n### ###\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2></h2>\n<h1></h1>\n<h3></h3>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Setext headings
#
@testset "Setext headings" begin

    # Example 80
    input = "Foo *bar*\n=========\n\nFoo *bar*\n---------\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>Foo <em>bar</em></h1>\n<h2>Foo <em>bar</em></h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 81
    input = "Foo *bar\nbaz*\n====\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>Foo <em>bar\nbaz</em></h1>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 82
    input = "  Foo *bar\nbaz*\t\n====\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>Foo <em>bar\nbaz</em></h1>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 83
    input = "Foo\n-------------------------\n\nFoo\n=\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo</h2>\n<h1>Foo</h1>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 84
    input = "   Foo\n---\n\n  Foo\n-----\n\n  Foo\n  ===\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo</h2>\n<h2>Foo</h2>\n<h1>Foo</h1>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 85
    input = "    Foo\n    ---\n\n    Foo\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>Foo\n---\n\nFoo\n</code></pre>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 86
    input = "Foo\n   ----      \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo</h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 87
    input = "Foo\n    ---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\n---</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 88
    input = "Foo\n= =\n\nFoo\n--- -\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\n= =</p>\n<p>Foo</p>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 89
    input = "Foo  \n-----\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo</h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 90
    input = "Foo\\\n----\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo\\</h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 91
    input = "`Foo\n----\n`\n\n<a title=\"a lot\n---\nof dashes\"/>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>`Foo</h2>\n<p>`</p>\n<h2>&lt;a title=&quot;a lot</h2>\n<p>of dashes&quot;/&gt;</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 92
    input = "> Foo\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>Foo</p>\n</blockquote>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 93
    input = "> foo\nbar\n===\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo\nbar\n===</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 94
    input = "- Foo\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>Foo</li>\n</ul>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 95
    input = "Foo\nBar\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>Foo\nBar</h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 96
    input = "---\nFoo\n---\nBar\n---\nBaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n<h2>Foo</h2>\n<h2>Bar</h2>\n<p>Baz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 97
    input = "\n====\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>====</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 98
    input = "---\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<hr />\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 99
    input = "- foo\n-----\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n</ul>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 100
    input = "    foo\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\n</code></pre>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 101
    input = "> foo\n-----\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo</p>\n</blockquote>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 102
    input = "\\> foo\n------\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>&gt; foo</h2>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 103
    input = "Foo\n\nbar\n---\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo</p>\n<h2>bar</h2>\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 104
    input = "Foo\nbar\n\n---\n\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\nbar</p>\n<hr />\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 105
    input = "Foo\nbar\n* * *\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\nbar</p>\n<hr />\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 106
    input = "Foo\nbar\n\\---\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\nbar\n---\nbaz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Indented code blocks
#
@testset "Indented code blocks" begin

    # Example 107
    input = "    a simple\n      indented code block\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>a simple\n  indented code block\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 108
    input = "  - foo\n\n    bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<p>bar</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 109
    input = "1.  foo\n\n    - bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>foo</p>\n<ul>\n<li>bar</li>\n</ul>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 110
    input = "    <a/>\n    *hi*\n\n    - one\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>&lt;a/&gt;\n*hi*\n\n- one\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 111
    input = "    chunk1\n\n    chunk2\n  \n \n \n    chunk3\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>chunk1\n\nchunk2\n\n\n\nchunk3\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 112
    input = "    chunk1\n      \n      chunk2\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>chunk1\n  \n  chunk2\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 113
    input = "Foo\n    bar\n\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\nbar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 114
    input = "    foo\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\n</code></pre>\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 115
    input = "# Heading\n    foo\nHeading\n------\n    foo\n----\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>Heading</h1>\n<pre><code>foo\n</code></pre>\n<h2>Heading</h2>\n<pre><code>foo\n</code></pre>\n<hr />\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 116
    input = "        foo\n    bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>    foo\nbar\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 117
    input = "\n    \n    foo\n    \n\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 118
    input = "    foo  \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>foo  \n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Fenced code blocks
#
@testset "Fenced code blocks" begin

    # Example 119
    input = "```\n<\n >\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>&lt;\n &gt;\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 120
    input = "~~~\n<\n >\n~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>&lt;\n &gt;\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 121
    input = "``\nfoo\n``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 122
    input = "```\naaa\n~~~\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n~~~\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 123
    input = "~~~\naaa\n```\n~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n```\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 124
    input = "````\naaa\n```\n``````\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n```\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 125
    input = "~~~~\naaa\n~~~\n~~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n~~~\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 126
    input = "```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code></code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 127
    input = "`````\n\n```\naaa\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>\n```\naaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 128
    input = "> ```\n> aaa\n\nbbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<pre><code>aaa\n</code></pre>\n</blockquote>\n<p>bbb</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 129
    input = "```\n\n  \n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>\n  \n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 130
    input = "```\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code></code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 131
    input = " ```\n aaa\naaa\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\naaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 132
    input = "  ```\naaa\n  aaa\naaa\n  ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\naaa\naaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 133
    input = "   ```\n   aaa\n    aaa\n  aaa\n   ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n aaa\naaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 134
    input = "    ```\n    aaa\n    ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>```\naaa\n```\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 135
    input = "```\naaa\n  ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 136
    input = "   ```\naaa\n  ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 137
    input = "```\naaa\n    ```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n    ```\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 138
    input = "``` ```\naaa\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code> </code>\naaa</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 139
    input = "~~~~~~\naaa\n~~~ ~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n~~~ ~~\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 140
    input = "foo\n```\nbar\n```\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo</p>\n<pre><code>bar\n</code></pre>\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 141
    input = "foo\n---\n~~~\nbar\n~~~\n# baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h2>foo</h2>\n<pre><code>bar\n</code></pre>\n<h1>baz</h1>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 142
    input = "```ruby\ndef foo(x)\n  return 3\nend\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-ruby\">def foo(x)\n  return 3\nend\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 143
    input = "~~~~    ruby startline=3 \$%@#\$\ndef foo(x)\n  return 3\nend\n~~~~~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-ruby\">def foo(x)\n  return 3\nend\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 144
    input = "````;\n````\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-;\"></code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 145
    input = "``` aa ```\nfoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>aa</code>\nfoo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 146
    input = "~~~ aa ``` ~~~\nfoo\n~~~\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code class=\"language-aa\">foo\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 147
    input = "```\n``` aaa\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>``` aaa\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# HTML blocks
#
@testset "HTML blocks" begin

    # Example 148
    input = "<table><tr><td>\n<pre>\n**Hello**,\n\n_world_.\n</pre>\n</td></tr></table>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<table><tr><td>\n<pre>\n**Hello**,\n<p><em>world</em>.\n</pre></p>\n</td></tr></table>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 149
    input = "<table>\n  <tr>\n    <td>\n           hi\n    </td>\n  </tr>\n</table>\n\nokay.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<table>\n  <tr>\n    <td>\n           hi\n    </td>\n  </tr>\n</table>\n<p>okay.</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 150
    input = " <div>\n  *hello*\n         <foo><a>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = " <div>\n  *hello*\n         <foo><a>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 151
    input = "</div>\n*foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "</div>\n*foo*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 152
    input = "<DIV CLASS=\"foo\">\n\n*Markdown*\n\n</DIV>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<DIV CLASS=\"foo\">\n<p><em>Markdown</em></p>\n</DIV>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 153
    input = "<div id=\"foo\"\n  class=\"bar\">\n</div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div id=\"foo\"\n  class=\"bar\">\n</div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 154
    input = "<div id=\"foo\" class=\"bar\n  baz\">\n</div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div id=\"foo\" class=\"bar\n  baz\">\n</div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 155
    input = "<div>\n*foo*\n\n*bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div>\n*foo*\n<p><em>bar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 156
    input = "<div id=\"foo\"\n*hi*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div id=\"foo\"\n*hi*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 157
    input = "<div class\nfoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div class\nfoo\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 158
    input = "<div *???-&&&-<---\n*foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div *???-&&&-<---\n*foo*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 159
    input = "<div><a href=\"bar\">*foo*</a></div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div><a href=\"bar\">*foo*</a></div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 160
    input = "<table><tr><td>\nfoo\n</td></tr></table>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<table><tr><td>\nfoo\n</td></tr></table>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 161
    input = "<div></div>\n``` c\nint x = 33;\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div></div>\n``` c\nint x = 33;\n```\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 162
    input = "<a href=\"foo\">\n*bar*\n</a>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<a href=\"foo\">\n*bar*\n</a>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 163
    input = "<Warning>\n*bar*\n</Warning>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<Warning>\n*bar*\n</Warning>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 164
    input = "<i class=\"foo\">\n*bar*\n</i>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<i class=\"foo\">\n*bar*\n</i>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 165
    input = "</ins>\n*bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "</ins>\n*bar*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 166
    input = "<del>\n*foo*\n</del>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<del>\n*foo*\n</del>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 167
    input = "<del>\n\n*foo*\n\n</del>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<del>\n<p><em>foo</em></p>\n</del>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 168
    input = "<del>*foo*</del>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><del><em>foo</em></del></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 169
    input = "<pre language=\"haskell\"><code>\nimport Text.HTML.TagSoup\n\nmain :: IO ()\nmain = print \$ parseTags tags\n</code></pre>\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre language=\"haskell\"><code>\nimport Text.HTML.TagSoup\n\nmain :: IO ()\nmain = print \$ parseTags tags\n</code></pre>\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 170
    input = "<script type=\"text/javascript\">\n// JavaScript example\n\ndocument.getElementById(\"demo\").innerHTML = \"Hello JavaScript!\";\n</script>\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<script type=\"text/javascript\">\n// JavaScript example\n\ndocument.getElementById(\"demo\").innerHTML = \"Hello JavaScript!\";\n</script>\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 171
    input = "<textarea>\n\n*foo*\n\n_bar_\n\n</textarea>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<textarea>\n\n*foo*\n\n_bar_\n\n</textarea>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 172
    input = "<style\n  type=\"text/css\">\nh1 {color:red;}\n\np {color:blue;}\n</style>\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<style\n  type=\"text/css\">\nh1 {color:red;}\n\np {color:blue;}\n</style>\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 173
    input = "<style\n  type=\"text/css\">\n\nfoo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<style\n  type=\"text/css\">\n\nfoo\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 174
    input = "> <div>\n> foo\n\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<div>\nfoo\n</blockquote>\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 175
    input = "- <div>\n- foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<div>\n</li>\n<li>foo</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 176
    input = "<style>p{color:red;}</style>\n*foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<style>p{color:red;}</style>\n<p><em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 177
    input = "<!-- foo -->*bar*\n*baz*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<!-- foo -->*bar*\n<p><em>baz</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 178
    input = "<script>\nfoo\n</script>1. *bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<script>\nfoo\n</script>1. *bar*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 179
    input = "<!-- Foo\n\nbar\n   baz -->\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<!-- Foo\n\nbar\n   baz -->\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 180
    input = "<?php\n\n  echo '>';\n\n?>\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<?php\n\n  echo '>';\n\n?>\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 181
    input = "<!DOCTYPE html>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<!DOCTYPE html>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 182
    input = "<![CDATA[\nfunction matchwo(a,b)\n{\n  if (a < b && a < 0) then {\n    return 1;\n\n  } else {\n\n    return 0;\n  }\n}\n]]>\nokay\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<![CDATA[\nfunction matchwo(a,b)\n{\n  if (a < b && a < 0) then {\n    return 1;\n\n  } else {\n\n    return 0;\n  }\n}\n]]>\n<p>okay</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 183
    input = "  <!-- foo -->\n\n    <!-- foo -->\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "  <!-- foo -->\n<pre><code>&lt;!-- foo --&gt;\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 184
    input = "  <div>\n\n    <div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "  <div>\n<pre><code>&lt;div&gt;\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 185
    input = "Foo\n<div>\nbar\n</div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo</p>\n<div>\nbar\n</div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 186
    input = "<div>\nbar\n</div>\n*foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div>\nbar\n</div>\n*foo*\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 187
    input = "Foo\n<a href=\"bar\">\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\n<a href=\"bar\">\nbaz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 188
    input = "<div>\n\n*Emphasized* text.\n\n</div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div>\n<p><em>Emphasized</em> text.</p>\n</div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 189
    input = "<div>\n*Emphasized* text.\n</div>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<div>\n*Emphasized* text.\n</div>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 190
    input = "<table>\n\n<tr>\n\n<td>\nHi\n</td>\n\n</tr>\n\n</table>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<table>\n<tr>\n<td>\nHi\n</td>\n</tr>\n</table>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 191
    input = "<table>\n\n  <tr>\n\n    <td>\n      Hi\n    </td>\n\n  </tr>\n\n</table>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<table>\n  <tr>\n<pre><code>&lt;td&gt;\n  Hi\n&lt;/td&gt;\n</code></pre>\n  </tr>\n</table>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Link reference definitions
#
@testset "Link reference definitions" begin

    # Example 192
    input = "[foo]: /url \"title\"\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 193
    input = "   [foo]: \n      /url  \n           'the title'  \n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"the title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 194
    input = "[Foo*bar\\]]:my_(url) 'title (with parens)'\n\n[Foo*bar\\]]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"my_(url)\" title=\"title (with parens)\">Foo*bar]</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 195
    input = "[Foo bar]:\n<my url>\n'title'\n\n[Foo bar]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"my%20url\" title=\"title\">Foo bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 196
    input = "[foo]: /url '\ntitle\nline1\nline2\n'\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"\ntitle\nline1\nline2\n\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 197
    input = "[foo]: /url 'title\n\nwith blank line'\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]: /url 'title</p>\n<p>with blank line'</p>\n<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 198
    input = "[foo]:\n/url\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 199
    input = "[foo]:\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]:</p>\n<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 200
    input = "[foo]: <>\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 201
    input = "[foo]: <bar>(baz)\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]: <bar>(baz)</p>\n<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 202
    input = "[foo]: /url\\bar\\*baz \"foo\\\"bar\\baz\"\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url%5Cbar*baz\" title=\"foo&quot;bar\\baz\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 203
    input = "[foo]\n\n[foo]: url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"url\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 204
    input = "[foo]\n\n[foo]: first\n[foo]: second\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"first\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 205
    input = "[FOO]: /url\n\n[Foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">Foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 206
    input = "[ΑΓΩ]: /φου\n\n[αγω]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/%CF%86%CE%BF%CF%85\">αγω</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 207
    input = "[foo]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = ""
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 208
    input = "[\nfoo\n]: /url\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 209
    input = "[foo]: /url \"title\" ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]: /url &quot;title&quot; ok</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 210
    input = "[foo]: /url\n\"title\" ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&quot;title&quot; ok</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 211
    input = "    [foo]: /url \"title\"\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>[foo]: /url &quot;title&quot;\n</code></pre>\n<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 212
    input = "```\n[foo]: /url\n```\n\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>[foo]: /url\n</code></pre>\n<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 213
    input = "Foo\n[bar]: /baz\n\n[bar]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo\n[bar]: /baz</p>\n<p>[bar]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 214
    input = "# [Foo]\n[foo]: /url\n> bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1><a href=\"/url\">Foo</a></h1>\n<blockquote>\n<p>bar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 215
    input = "[foo]: /url\nbar\n===\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h1>bar</h1>\n<p><a href=\"/url\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 216
    input = "[foo]: /url\n===\n[foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>===\n<a href=\"/url\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 217
    input = "[foo]: /foo-url \"foo\"\n[bar]: /bar-url\n  \"bar\"\n[baz]: /baz-url\n\n[foo],\n[bar],\n[baz]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/foo-url\" title=\"foo\">foo</a>,\n<a href=\"/bar-url\" title=\"bar\">bar</a>,\n<a href=\"/baz-url\">baz</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 218
    input = "[foo]\n\n> [foo]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">foo</a></p>\n<blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Paragraphs
#
@testset "Paragraphs" begin

    # Example 219
    input = "aaa\n\nbbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa</p>\n<p>bbb</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 220
    input = "aaa\nbbb\n\nccc\nddd\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa\nbbb</p>\n<p>ccc\nddd</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 221
    input = "aaa\n\n\nbbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa</p>\n<p>bbb</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 222
    input = "  aaa\n bbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa\nbbb</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 223
    input = "aaa\n             bbb\n                                       ccc\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa\nbbb\nccc</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 224
    input = "   aaa\nbbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa\nbbb</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 225
    input = "    aaa\nbbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>aaa\n</code></pre>\n<p>bbb</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 226
    input = "aaa     \nbbb     \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa<br />\nbbb</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Blank lines
#
@testset "Blank lines" begin

    # Example 227
    input = "  \n\naaa\n  \n\n# aaa\n\n  \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aaa</p>\n<h1>aaa</h1>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Block quotes
#
@testset "Block quotes" begin

    # Example 228
    input = "> # Foo\n> bar\n> baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<h1>Foo</h1>\n<p>bar\nbaz</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 229
    input = "># Foo\n>bar\n> baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<h1>Foo</h1>\n<p>bar\nbaz</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 230
    input = "   > # Foo\n   > bar\n > baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<h1>Foo</h1>\n<p>bar\nbaz</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 231
    input = "    > # Foo\n    > bar\n    > baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>&gt; # Foo\n&gt; bar\n&gt; baz\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 232
    input = "> # Foo\n> bar\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<h1>Foo</h1>\n<p>bar\nbaz</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 233
    input = "> bar\nbaz\n> foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>bar\nbaz\nfoo</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 234
    input = "> foo\n---\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo</p>\n</blockquote>\n<hr />\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 235
    input = "> - foo\n- bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<ul>\n<li>foo</li>\n</ul>\n</blockquote>\n<ul>\n<li>bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 236
    input = ">     foo\n    bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<pre><code>foo\n</code></pre>\n</blockquote>\n<pre><code>bar\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 237
    input = "> ```\nfoo\n```\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<pre><code></code></pre>\n</blockquote>\n<p>foo</p>\n<pre><code></code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 238
    input = "> foo\n    - bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo\n- bar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 239
    input = ">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 240
    input = ">\n>  \n> \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 241
    input = ">\n> foo\n>  \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 242
    input = "> foo\n\n> bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo</p>\n</blockquote>\n<blockquote>\n<p>bar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 243
    input = "> foo\n> bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo\nbar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 244
    input = "> foo\n>\n> bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>foo</p>\n<p>bar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 245
    input = "foo\n> bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo</p>\n<blockquote>\n<p>bar</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 246
    input = "> aaa\n***\n> bbb\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>aaa</p>\n</blockquote>\n<hr />\n<blockquote>\n<p>bbb</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 247
    input = "> bar\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>bar\nbaz</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 248
    input = "> bar\n\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>bar</p>\n</blockquote>\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 249
    input = "> bar\n>\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<p>bar</p>\n</blockquote>\n<p>baz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 250
    input = "> > > foo\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<blockquote>\n<blockquote>\n<p>foo\nbar</p>\n</blockquote>\n</blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 251
    input = ">>> foo\n> bar\n>>baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<blockquote>\n<blockquote>\n<p>foo\nbar\nbaz</p>\n</blockquote>\n</blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 252
    input = ">     code\n\n>    not code\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<pre><code>code\n</code></pre>\n</blockquote>\n<blockquote>\n<p>not code</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# List items
#
@testset "List items" begin

    # Example 253
    input = "A paragraph\nwith two lines.\n\n    indented code\n\n> A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 254
    input = "1.  A paragraph\n    with two lines.\n\n        indented code\n\n    > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 255
    input = "- one\n\n two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>one</li>\n</ul>\n<p>two</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 256
    input = "- one\n\n  two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>one</p>\n<p>two</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 257
    input = " -    one\n\n     two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>one</li>\n</ul>\n<pre><code> two\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 258
    input = " -    one\n\n      two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>one</p>\n<p>two</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 259
    input = "   > > 1.  one\n>>\n>>     two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<blockquote>\n<ol>\n<li>\n<p>one</p>\n<p>two</p>\n</li>\n</ol>\n</blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 260
    input = ">>- one\n>>\n  >  > two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<blockquote>\n<ul>\n<li>one</li>\n</ul>\n<p>two</p>\n</blockquote>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 261
    input = "-one\n\n2.two\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>-one</p>\n<p>2.two</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 262
    input = "- foo\n\n\n  bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<p>bar</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 263
    input = "1.  foo\n\n    ```\n    bar\n    ```\n\n    baz\n\n    > bam\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>foo</p>\n<pre><code>bar\n</code></pre>\n<p>baz</p>\n<blockquote>\n<p>bam</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 264
    input = "- Foo\n\n      bar\n\n\n      baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>Foo</p>\n<pre><code>bar\n\n\nbaz\n</code></pre>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 265
    input = "123456789. ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"123456789\">\n<li>ok</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 266
    input = "1234567890. not ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>1234567890. not ok</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 267
    input = "0. ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"0\">\n<li>ok</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 268
    input = "003. ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"3\">\n<li>ok</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 269
    input = "-1. not ok\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>-1. not ok</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 270
    input = "- foo\n\n      bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<pre><code>bar\n</code></pre>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 271
    input = "  10.  foo\n\n           bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"10\">\n<li>\n<p>foo</p>\n<pre><code>bar\n</code></pre>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 272
    input = "    indented code\n\nparagraph\n\n    more code\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>indented code\n</code></pre>\n<p>paragraph</p>\n<pre><code>more code\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 273
    input = "1.     indented code\n\n   paragraph\n\n       more code\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<pre><code>indented code\n</code></pre>\n<p>paragraph</p>\n<pre><code>more code\n</code></pre>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 274
    input = "1.      indented code\n\n   paragraph\n\n       more code\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<pre><code> indented code\n</code></pre>\n<p>paragraph</p>\n<pre><code>more code\n</code></pre>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 275
    input = "   foo\n\nbar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo</p>\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 276
    input = "-    foo\n\n  bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n</ul>\n<p>bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 277
    input = "-  foo\n\n   bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<p>bar</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 278
    input = "-\n  foo\n-\n  ```\n  bar\n  ```\n-\n      baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li>\n<pre><code>bar\n</code></pre>\n</li>\n<li>\n<pre><code>baz\n</code></pre>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 279
    input = "-   \n  foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 280
    input = "-\n\n  foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li></li>\n</ul>\n<p>foo</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 281
    input = "- foo\n-\n- bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li></li>\n<li>bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 282
    input = "- foo\n-   \n- bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li></li>\n<li>bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 283
    input = "1. foo\n2.\n3. bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>foo</li>\n<li></li>\n<li>bar</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 284
    input = "*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li></li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 285
    input = "foo\n*\n\nfoo\n1.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\n*</p>\n<p>foo\n1.</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 286
    input = " 1.  A paragraph\n     with two lines.\n\n         indented code\n\n     > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 287
    input = "  1.  A paragraph\n      with two lines.\n\n          indented code\n\n      > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 288
    input = "   1.  A paragraph\n       with two lines.\n\n           indented code\n\n       > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 289
    input = "    1.  A paragraph\n        with two lines.\n\n            indented code\n\n        > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<pre><code>1.  A paragraph\n    with two lines.\n\n        indented code\n\n    &gt; A block quote.\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 290
    input = "  1.  A paragraph\nwith two lines.\n\n          indented code\n\n      > A block quote.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>A paragraph\nwith two lines.</p>\n<pre><code>indented code\n</code></pre>\n<blockquote>\n<p>A block quote.</p>\n</blockquote>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 291
    input = "  1.  A paragraph\n    with two lines.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>A paragraph\nwith two lines.</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 292
    input = "> 1. > Blockquote\ncontinued here.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<ol>\n<li>\n<blockquote>\n<p>Blockquote\ncontinued here.</p>\n</blockquote>\n</li>\n</ol>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 293
    input = "> 1. > Blockquote\n> continued here.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<blockquote>\n<ol>\n<li>\n<blockquote>\n<p>Blockquote\ncontinued here.</p>\n</blockquote>\n</li>\n</ol>\n</blockquote>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 294
    input = "- foo\n  - bar\n    - baz\n      - boo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo\n<ul>\n<li>bar\n<ul>\n<li>baz\n<ul>\n<li>boo</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 295
    input = "- foo\n - bar\n  - baz\n   - boo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li>bar</li>\n<li>baz</li>\n<li>boo</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 296
    input = "10) foo\n    - bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"10\">\n<li>foo\n<ul>\n<li>bar</li>\n</ul>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 297
    input = "10) foo\n   - bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol start=\"10\">\n<li>foo</li>\n</ol>\n<ul>\n<li>bar</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 298
    input = "- - foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<ul>\n<li>foo</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 299
    input = "1. - 2. foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<ul>\n<li>\n<ol start=\"2\">\n<li>foo</li>\n</ol>\n</li>\n</ul>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 300
    input = "- # Foo\n- Bar\n  ---\n  baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<h1>Foo</h1>\n</li>\n<li>\n<h2>Bar</h2>\nbaz</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Lists
#
@testset "Lists" begin

    # Example 301
    input = "- foo\n- bar\n+ baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li>bar</li>\n</ul>\n<ul>\n<li>baz</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 302
    input = "1. foo\n2. bar\n3) baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>foo</li>\n<li>bar</li>\n</ol>\n<ol start=\"3\">\n<li>baz</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 303
    input = "Foo\n- bar\n- baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo</p>\n<ul>\n<li>bar</li>\n<li>baz</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 304
    input = "The number of windows in my house is\n14.  The number of doors is 6.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>The number of windows in my house is\n14.  The number of doors is 6.</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 305
    input = "The number of windows in my house is\n1.  The number of doors is 6.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>The number of windows in my house is</p>\n<ol>\n<li>The number of doors is 6.</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 306
    input = "- foo\n\n- bar\n\n\n- baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n</li>\n<li>\n<p>bar</p>\n</li>\n<li>\n<p>baz</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 307
    input = "- foo\n  - bar\n    - baz\n\n\n      bim\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo\n<ul>\n<li>bar\n<ul>\n<li>\n<p>baz</p>\n<p>bim</p>\n</li>\n</ul>\n</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 308
    input = "- foo\n- bar\n\n<!-- -->\n\n- baz\n- bim\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>foo</li>\n<li>bar</li>\n</ul>\n<!-- -->\n<ul>\n<li>baz</li>\n<li>bim</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 309
    input = "-   foo\n\n    notcode\n\n-   foo\n\n<!-- -->\n\n    code\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<p>notcode</p>\n</li>\n<li>\n<p>foo</p>\n</li>\n</ul>\n<!-- -->\n<pre><code>code\n</code></pre>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 310
    input = "- a\n - b\n  - c\n   - d\n  - e\n - f\n- g\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a</li>\n<li>b</li>\n<li>c</li>\n<li>d</li>\n<li>e</li>\n<li>f</li>\n<li>g</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 311
    input = "1. a\n\n  2. b\n\n   3. c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>a</p>\n</li>\n<li>\n<p>b</p>\n</li>\n<li>\n<p>c</p>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 312
    input = "- a\n - b\n  - c\n   - d\n    - e\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a</li>\n<li>b</li>\n<li>c</li>\n<li>d\n- e</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 313
    input = "1. a\n\n  2. b\n\n    3. c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<p>a</p>\n</li>\n<li>\n<p>b</p>\n</li>\n</ol>\n<pre><code>3. c\n</code></pre>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 314
    input = "- a\n- b\n\n- c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>a</p>\n</li>\n<li>\n<p>b</p>\n</li>\n<li>\n<p>c</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 315
    input = "* a\n*\n\n* c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>a</p>\n</li>\n<li></li>\n<li>\n<p>c</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 316
    input = "- a\n- b\n\n  c\n- d\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>a</p>\n</li>\n<li>\n<p>b</p>\n<p>c</p>\n</li>\n<li>\n<p>d</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 317
    input = "- a\n- b\n\n  [ref]: /url\n- d\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>a</p>\n</li>\n<li>\n<p>b</p>\n</li>\n<li>\n<p>d</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 318
    input = "- a\n- ```\n  b\n\n\n  ```\n- c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a</li>\n<li>\n<pre><code>b\n\n\n</code></pre>\n</li>\n<li>c</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 319
    input = "- a\n  - b\n\n    c\n- d\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a\n<ul>\n<li>\n<p>b</p>\n<p>c</p>\n</li>\n</ul>\n</li>\n<li>d</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 320
    input = "* a\n  > b\n  >\n* c\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a\n<blockquote>\n<p>b</p>\n</blockquote>\n</li>\n<li>c</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 321
    input = "- a\n  > b\n  ```\n  c\n  ```\n- d\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a\n<blockquote>\n<p>b</p>\n</blockquote>\n<pre><code>c\n</code></pre>\n</li>\n<li>d</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 322
    input = "- a\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 323
    input = "- a\n  - b\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>a\n<ul>\n<li>b</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 324
    input = "1. ```\n   foo\n   ```\n\n   bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ol>\n<li>\n<pre><code>foo\n</code></pre>\n<p>bar</p>\n</li>\n</ol>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 325
    input = "* foo\n  * bar\n\n  baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>foo</p>\n<ul>\n<li>bar</li>\n</ul>\n<p>baz</p>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 326
    input = "- a\n  - b\n  - c\n\n- d\n  - e\n  - f\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<ul>\n<li>\n<p>a</p>\n<ul>\n<li>b</li>\n<li>c</li>\n</ul>\n</li>\n<li>\n<p>d</p>\n<ul>\n<li>e</li>\n<li>f</li>\n</ul>\n</li>\n</ul>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Inlines
#
@testset "Inlines" begin

    # Example 327
    input = "`hi`lo`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>hi</code>lo`</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Code spans
#
@testset "Code spans" begin

    # Example 328
    input = "`foo`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo</code></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 329
    input = "`` foo ` bar ``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo ` bar</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 330
    input = "` `` `\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>``</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 331
    input = "`  ``  `\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code> `` </code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 332
    input = "` a`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code> a</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 333
    input = "`\u00A0b\u00A0`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>\u00A0b\u00A0</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 334
    input = "`\u00A0`\n`  `\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>\u00A0</code>\n<code>  </code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 335
    input = "``\nfoo\nbar  \nbaz\n``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo bar   baz</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 336
    input = "``\nfoo \n``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo </code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 337
    input = "`foo   bar \nbaz`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo   bar  baz</code></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 338
    input = "`foo\\`bar`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo\\</code>bar`</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 339
    input = "``foo`bar``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo`bar</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 340
    input = "` foo `` bar `\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>foo `` bar</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 341
    input = "*foo`*`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*foo<code>*</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 342
    input = "[not a `link](/foo`)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[not a <code>link](/foo</code>)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 343
    input = "`<a href=\"`\">`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>&lt;a href=&quot;</code>&quot;&gt;`</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 344
    input = "<a href=\"`\">`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"`\">`</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 345
    input = "`<https://foo.bar.`baz>`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>&lt;https://foo.bar.</code>baz&gt;`</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 346
    input = "<https://foo.bar.`baz>`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"https://foo.bar.%60baz\">https://foo.bar.`baz</a>`</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 347
    input = "```foo``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>```foo``</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 348
    input = "`foo\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>`foo</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 349
    input = "`foo``bar``\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>`foo<code>bar</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Emphasis and strong emphasis
#
@testset "Emphasis and strong emphasis" begin

    # Example 350
    input = "*foo bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo bar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 351
    input = "a * foo bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>a * foo bar*</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 352
    input = "a*\"foo\"*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>a*&quot;foo&quot;*</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 353
    input = "*\u00A0a\u00A0*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*\u00A0a\u00A0*</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 354
    input = "*\$*alpha.\n\n*£*bravo.\n\n*€*charlie.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*\$*alpha.</p>\n<p>*£*bravo.</p>\n<p>*€*charlie.</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 355
    input = "foo*bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<em>bar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 356
    input = "5*6*78\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>5<em>6</em>78</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 357
    input = "_foo bar_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo bar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 358
    input = "_ foo bar_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_ foo bar_</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 359
    input = "a_\"foo\"_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>a_&quot;foo&quot;_</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 360
    input = "foo_bar_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo_bar_</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 361
    input = "5_6_78\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>5_6_78</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 362
    input = "пристаням_стремятся_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>пристаням_стремятся_</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 363
    input = "aa_\"bb\"_cc\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>aa_&quot;bb&quot;_cc</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 364
    input = "foo-_(bar)_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo-<em>(bar)</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 365
    input = "_foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_foo*</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 366
    input = "*foo bar *\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*foo bar *</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 367
    input = "*foo bar\n*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*foo bar\n*</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 368
    input = "*(*foo)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*(*foo)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 369
    input = "*(*foo*)*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>(<em>foo</em>)</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 370
    input = "*foo*bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo</em>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 371
    input = "_foo bar _\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_foo bar _</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 372
    input = "_(_foo)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_(_foo)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 373
    input = "_(_foo_)_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>(<em>foo</em>)</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 374
    input = "_foo_bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_foo_bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 375
    input = "_пристаням_стремятся\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_пристаням_стремятся</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 376
    input = "_foo_bar_baz_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo_bar_baz</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 377
    input = "_(bar)_.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>(bar)</em>.</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 378
    input = "**foo bar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo bar</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 379
    input = "** foo bar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>** foo bar**</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 380
    input = "a**\"foo\"**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>a**&quot;foo&quot;**</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 381
    input = "foo**bar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<strong>bar</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 382
    input = "__foo bar__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo bar</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 383
    input = "__ foo bar__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__ foo bar__</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 384
    input = "__\nfoo bar__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__\nfoo bar__</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 385
    input = "a__\"foo\"__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>a__&quot;foo&quot;__</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 386
    input = "foo__bar__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo__bar__</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 387
    input = "5__6__78\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>5__6__78</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 388
    input = "пристаням__стремятся__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>пристаням__стремятся__</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 389
    input = "__foo, __bar__, baz__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo, <strong>bar</strong>, baz</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 390
    input = "foo-__(bar)__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo-<strong>(bar)</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 391
    input = "**foo bar **\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**foo bar **</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 392
    input = "**(**foo)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**(**foo)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 393
    input = "*(**foo**)*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>(<strong>foo</strong>)</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 394
    input = "**Gomphocarpus (*Gomphocarpus physocarpus*, syn.\n*Asclepias physocarpa*)**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>Gomphocarpus (<em>Gomphocarpus physocarpus</em>, syn.\n<em>Asclepias physocarpa</em>)</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 395
    input = "**foo \"*bar*\" foo**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo &quot;<em>bar</em>&quot; foo</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 396
    input = "**foo**bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo</strong>bar</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 397
    input = "__foo bar __\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__foo bar __</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 398
    input = "__(__foo)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__(__foo)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 399
    input = "_(__foo__)_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>(<strong>foo</strong>)</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 400
    input = "__foo__bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__foo__bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 401
    input = "__пристаням__стремятся\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__пристаням__стремятся</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 402
    input = "__foo__bar__baz__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo__bar__baz</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 403
    input = "__(bar)__.\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>(bar)</strong>.</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 404
    input = "*foo [bar](/url)*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <a href=\"/url\">bar</a></em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 405
    input = "*foo\nbar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo\nbar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 406
    input = "_foo __bar__ baz_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <strong>bar</strong> baz</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 407
    input = "_foo _bar_ baz_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <em>bar</em> baz</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 408
    input = "__foo_ bar_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><em>foo</em> bar</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 409
    input = "*foo *bar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <em>bar</em></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 410
    input = "*foo **bar** baz*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <strong>bar</strong> baz</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 411
    input = "*foo**bar**baz*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo<strong>bar</strong>baz</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 412
    input = "*foo**bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo**bar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 413
    input = "***foo** bar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><strong>foo</strong> bar</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 414
    input = "*foo **bar***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <strong>bar</strong></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 415
    input = "*foo**bar***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo<strong>bar</strong></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 416
    input = "foo***bar***baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<em><strong>bar</strong></em>baz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 417
    input = "foo******bar*********baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<strong><strong><strong>bar</strong></strong></strong>***baz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 418
    input = "*foo **bar *baz* bim** bop*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <strong>bar <em>baz</em> bim</strong> bop</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 419
    input = "*foo [*bar*](/url)*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <a href=\"/url\"><em>bar</em></a></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 420
    input = "** is not an empty emphasis\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>** is not an empty emphasis</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 421
    input = "**** is not an empty strong emphasis\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**** is not an empty strong emphasis</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 422
    input = "**foo [bar](/url)**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <a href=\"/url\">bar</a></strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 423
    input = "**foo\nbar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo\nbar</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 424
    input = "__foo _bar_ baz__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <em>bar</em> baz</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 425
    input = "__foo __bar__ baz__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <strong>bar</strong> baz</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 426
    input = "____foo__ bar__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong><strong>foo</strong> bar</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 427
    input = "**foo **bar****\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <strong>bar</strong></strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 428
    input = "**foo *bar* baz**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <em>bar</em> baz</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 429
    input = "**foo*bar*baz**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo<em>bar</em>baz</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 430
    input = "***foo* bar**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong><em>foo</em> bar</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 431
    input = "**foo *bar***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <em>bar</em></strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 432
    input = "**foo *bar **baz**\nbim* bop**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <em>bar <strong>baz</strong>\nbim</em> bop</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 433
    input = "**foo [*bar*](/url)**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo <a href=\"/url\"><em>bar</em></a></strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 434
    input = "__ is not an empty emphasis\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__ is not an empty emphasis</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 435
    input = "____ is not an empty strong emphasis\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>____ is not an empty strong emphasis</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 436
    input = "foo ***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo ***</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 437
    input = "foo *\\**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <em>*</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 438
    input = "foo *_*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <em>_</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 439
    input = "foo *****\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo *****</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 440
    input = "foo **\\***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <strong>*</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 441
    input = "foo **_**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <strong>_</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 442
    input = "**foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 443
    input = "*foo**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo</em>*</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 444
    input = "***foo**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<strong>foo</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 445
    input = "****foo*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>***<em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 446
    input = "**foo***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo</strong>*</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 447
    input = "*foo****\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo</em>***</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 448
    input = "foo ___\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo ___</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 449
    input = "foo _\\__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <em>_</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 450
    input = "foo _*_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <em>*</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 451
    input = "foo _____\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo _____</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 452
    input = "foo __\\___\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <strong>_</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 453
    input = "foo __*__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <strong>*</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 454
    input = "__foo_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_<em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 455
    input = "_foo__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo</em>_</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 456
    input = "___foo__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_<strong>foo</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 457
    input = "____foo_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>___<em>foo</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 458
    input = "__foo___\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo</strong>_</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 459
    input = "_foo____\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo</em>___</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 460
    input = "**foo**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 461
    input = "*_foo_*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><em>foo</em></em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 462
    input = "__foo__\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong>foo</strong></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 463
    input = "_*foo*_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><em>foo</em></em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 464
    input = "****foo****\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong><strong>foo</strong></strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 465
    input = "____foo____\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong><strong>foo</strong></strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 466
    input = "******foo******\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><strong><strong><strong>foo</strong></strong></strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 467
    input = "***foo***\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><strong>foo</strong></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 468
    input = "_____foo_____\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em><strong><strong>foo</strong></strong></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 469
    input = "*foo _bar* baz_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo _bar</em> baz_</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 470
    input = "*foo __bar *baz bim__ bam*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo <strong>bar *baz bim</strong> bam</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 471
    input = "**foo **bar baz**\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**foo <strong>bar baz</strong></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 472
    input = "*foo *bar baz*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*foo <em>bar baz</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 473
    input = "*[bar*](/url)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<a href=\"/url\">bar*</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 474
    input = "_foo [bar_](/url)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>_foo <a href=\"/url\">bar_</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 475
    input = "*<img src=\"foo\" title=\"*\"/>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<img src=\"foo\" title=\"*\"/></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 476
    input = "**<a href=\"**\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**<a href=\"**\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 477
    input = "__<a href=\"__\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__<a href=\"__\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 478
    input = "*a `*`*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>a <code>*</code></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 479
    input = "_a `_`_\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>a <code>_</code></em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 480
    input = "**a<https://foo.bar/?q=**>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>**a<a href=\"https://foo.bar/?q=**\">https://foo.bar/?q=**</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 481
    input = "__a<https://foo.bar/?q=__>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>__a<a href=\"https://foo.bar/?q=__\">https://foo.bar/?q=__</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Links
#
@testset "Links" begin

    # Example 482
    input = "[link](/uri \"title\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\" title=\"title\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 483
    input = "[link](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 484
    input = "[](./target.md)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"./target.md\"></a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 485
    input = "[link]()\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 486
    input = "[link](<>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 487
    input = "[]()\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"\"></a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 488
    input = "[link](/my uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](/my uri)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 489
    input = "[link](</my uri>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/my%20uri\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 490
    input = "[link](foo\nbar)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](foo\nbar)</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 491
    input = "[link](<foo\nbar>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](<foo\nbar>)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 492
    input = "[a](<b)c>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"b)c\">a</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 493
    input = "[link](<foo\\>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](&lt;foo&gt;)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 494
    input = "[a](<b)c\n[a](<b)c>\n[a](<b>c)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[a](&lt;b)c\n[a](&lt;b)c&gt;\n[a](<b>c)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 495
    input = "[link](\\(foo\\))\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"(foo)\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 496
    input = "[link](foo(and(bar)))\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo(and(bar))\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 497
    input = "[link](foo(and(bar))\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](foo(and(bar))</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 498
    input = "[link](foo\\(and\\(bar\\))\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo(and(bar)\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 499
    input = "[link](<foo(and(bar)>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo(and(bar)\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 500
    input = "[link](foo\\)\\:)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo):\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 501
    input = "[link](#fragment)\n\n[link](https://example.com#fragment)\n\n[link](https://example.com?foo=3#frag)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"#fragment\">link</a></p>\n<p><a href=\"https://example.com#fragment\">link</a></p>\n<p><a href=\"https://example.com?foo=3#frag\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 502
    input = "[link](foo\\bar)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo%5Cbar\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 503
    input = "[link](foo%20b&auml;)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo%20b%C3%A4\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 504
    input = "[link](\"title\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"%22title%22\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 505
    input = "[link](/url \"title\")\n[link](/url 'title')\n[link](/url (title))\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">link</a>\n<a href=\"/url\" title=\"title\">link</a>\n<a href=\"/url\" title=\"title\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 506
    input = "[link](/url \"title \\\"&quot;\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title &quot;&quot;\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 507
    input = "[link](/url\u00A0\"title\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url%C2%A0%22title%22\">link</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 508
    input = "[link](/url \"title \"and\" title\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link](/url &quot;title &quot;and&quot; title&quot;)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 509
    input = "[link](/url 'title \"and\" title')\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title &quot;and&quot; title\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 510
    input = "[link](   /uri\n  \"title\"  )\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\" title=\"title\">link</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 511
    input = "[link] (/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link] (/uri)</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 512
    input = "[link [foo [bar]]](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link [foo [bar]]</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 513
    input = "[link] bar](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link] bar](/uri)</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 514
    input = "[link [bar](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[link <a href=\"/uri\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 515
    input = "[link \\[bar](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link [bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 516
    input = "[link *foo **bar** `#`*](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link <em>foo <strong>bar</strong> <code>#</code></em></a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 517
    input = "[![moon](moon.jpg)](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\"><img src=\"moon.jpg\" alt=\"moon\" /></a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 518
    input = "[foo [bar](/uri)](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <a href=\"/uri\">bar</a>](/uri)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 519
    input = "[foo *[bar [baz](/uri)](/uri)*](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <em>[bar <a href=\"/uri\">baz</a>](/uri)</em>](/uri)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 520
    input = "![[[foo](uri1)](uri2)](uri3)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"uri3\" alt=\"[foo](uri2)\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 521
    input = "*[foo*](/uri)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<a href=\"/uri\">foo*</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 522
    input = "[foo *bar](baz*)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"baz*\">foo *bar</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 523
    input = "*foo [bar* baz]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo [bar</em> baz]</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 524
    input = "[foo <bar attr=\"](baz)\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <bar attr=\"](baz)\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 525
    input = "[foo`](/uri)`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo<code>](/uri)</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 526
    input = "[foo<https://example.com/?search=](uri)>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo<a href=\"https://example.com/?search=%5D(uri)\">https://example.com/?search=](uri)</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 527
    input = "[foo][bar]\n\n[bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 528
    input = "[link [foo [bar]]][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link [foo [bar]]</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 529
    input = "[link \\[bar][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link [bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 530
    input = "[link *foo **bar** `#`*][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">link <em>foo <strong>bar</strong> <code>#</code></em></a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 531
    input = "[![moon](moon.jpg)][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\"><img src=\"moon.jpg\" alt=\"moon\" /></a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 532
    input = "[foo [bar](/uri)][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <a href=\"/uri\">bar</a>]<a href=\"/uri\">ref</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 533
    input = "[foo *bar [baz][ref]*][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <em>bar <a href=\"/uri\">baz</a></em>]<a href=\"/uri\">ref</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 534
    input = "*[foo*][ref]\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<a href=\"/uri\">foo*</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 535
    input = "[foo *bar][ref]*\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">foo *bar</a>*</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 536
    input = "[foo <bar attr=\"][ref]\">\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo <bar attr=\"][ref]\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 537
    input = "[foo`][ref]`\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo<code>][ref]</code></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 538
    input = "[foo<https://example.com/?search=][ref]>\n\n[ref]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo<a href=\"https://example.com/?search=%5D%5Bref%5D\">https://example.com/?search=][ref]</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 539
    input = "[foo][BaR]\n\n[bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 540
    input = "[ẞ]\n\n[SS]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">ẞ</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 541
    input = "[Foo\n  bar]: /url\n\n[Baz][Foo bar]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">Baz</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 542
    input = "[foo] [bar]\n\n[bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo] <a href=\"/url\" title=\"title\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 543
    input = "[foo]\n[bar]\n\n[bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]\n<a href=\"/url\" title=\"title\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 544
    input = "[foo]: /url1\n\n[foo]: /url2\n\n[bar][foo]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url1\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 545
    input = "[bar][foo\\!]\n\n[foo!]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[bar][foo!]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 546
    input = "[foo][ref[]\n\n[ref[]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo][ref[]</p>\n<p>[ref[]: /uri</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 547
    input = "[foo][ref[bar]]\n\n[ref[bar]]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo][ref[bar]]</p>\n<p>[ref[bar]]: /uri</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 548
    input = "[[[foo]]]\n\n[[[foo]]]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[[[foo]]]</p>\n<p>[[[foo]]]: /url</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 549
    input = "[foo][ref\\[]\n\n[ref\\[]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 550
    input = "[bar\\\\]: /uri\n\n[bar\\\\]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/uri\">bar\\</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 551
    input = "[]\n\n[]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[]</p>\n<p>[]: /uri</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 552
    input = "[\n ]\n\n[\n ]: /uri\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[\n]</p>\n<p>[\n]: /uri</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 553
    input = "[foo][]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 554
    input = "[*foo* bar][]\n\n[*foo* bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\"><em>foo</em> bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 555
    input = "[Foo][]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">Foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 556
    input = "[foo] \n[]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a>\n[]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 557
    input = "[foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 558
    input = "[*foo* bar]\n\n[*foo* bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\"><em>foo</em> bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 559
    input = "[[*foo* bar]]\n\n[*foo* bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[<a href=\"/url\" title=\"title\"><em>foo</em> bar</a>]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 560
    input = "[[bar [foo]\n\n[foo]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[[bar <a href=\"/url\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 561
    input = "[Foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\" title=\"title\">Foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 562
    input = "[foo] bar\n\n[foo]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url\">foo</a> bar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 563
    input = "\\[foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 564
    input = "[foo*]: /url\n\n*[foo*]\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>*<a href=\"/url\">foo*</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 565
    input = "[foo][bar]\n\n[foo]: /url1\n[bar]: /url2\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url2\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 566
    input = "[foo][]\n\n[foo]: /url1\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url1\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 567
    input = "[foo]()\n\n[foo]: /url1\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 568
    input = "[foo](not a link)\n\n[foo]: /url1\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url1\">foo</a>(not a link)</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 569
    input = "[foo][bar][baz]\n\n[baz]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]<a href=\"/url\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 570
    input = "[foo][bar][baz]\n\n[baz]: /url1\n[bar]: /url2\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"/url2\">foo</a><a href=\"/url1\">baz</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 571
    input = "[foo][bar][baz]\n\n[baz]: /url1\n[foo]: /url2\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>[foo]<a href=\"/url1\">bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Images
#
@testset "Images" begin

    # Example 572
    input = "![foo](/url \"title\")\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 573
    input = "![foo *bar*]\n\n[foo *bar*]: train.jpg \"train & tracks\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"train.jpg\" alt=\"foo bar\" title=\"train &amp; tracks\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 574
    input = "![foo ![bar](/url)](/url2)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url2\" alt=\"foo bar\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 575
    input = "![foo [bar](/url)](/url2)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url2\" alt=\"foo bar\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 576
    input = "![foo *bar*][]\n\n[foo *bar*]: train.jpg \"train & tracks\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"train.jpg\" alt=\"foo bar\" title=\"train &amp; tracks\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 577
    input = "![foo *bar*][foobar]\n\n[FOOBAR]: train.jpg \"train & tracks\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"train.jpg\" alt=\"foo bar\" title=\"train &amp; tracks\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 578
    input = "![foo](train.jpg)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"train.jpg\" alt=\"foo\" /></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 579
    input = "My ![foo bar](/path/to/train.jpg  \"title\"   )\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>My <img src=\"/path/to/train.jpg\" alt=\"foo bar\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 580
    input = "![foo](<url>)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"url\" alt=\"foo\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 581
    input = "![](/url)\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"\" /></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 582
    input = "![foo][bar]\n\n[bar]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 583
    input = "![foo][bar]\n\n[BAR]: /url\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 584
    input = "![foo][]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 585
    input = "![*foo* bar][]\n\n[*foo* bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo bar\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 586
    input = "![Foo][]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"Foo\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 587
    input = "![foo] \n[]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" title=\"title\" />\n[]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 588
    input = "![foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 589
    input = "![*foo* bar]\n\n[*foo* bar]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"foo bar\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 590
    input = "![[foo]]\n\n[[foo]]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>![[foo]]</p>\n<p>[[foo]]: /url &quot;title&quot;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 591
    input = "![Foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><img src=\"/url\" alt=\"Foo\" title=\"title\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 592
    input = "!\\[foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>![foo]</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 593
    input = "\\![foo]\n\n[foo]: /url \"title\"\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>!<a href=\"/url\" title=\"title\">foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

end

#
# Autolinks
#
@testset "Autolinks" begin

    # Example 594
    input = "<http://foo.bar.baz>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"http://foo.bar.baz\">http://foo.bar.baz</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 595
    input = "<https://foo.bar.baz/test?q=hello&id=22&boolean>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"https://foo.bar.baz/test?q=hello&amp;id=22&amp;boolean\">https://foo.bar.baz/test?q=hello&amp;id=22&amp;boolean</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 596
    input = "<irc://foo.bar:2233/baz>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"irc://foo.bar:2233/baz\">irc://foo.bar:2233/baz</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 597
    input = "<MAILTO:FOO@BAR.BAZ>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"MAILTO:FOO@BAR.BAZ\">MAILTO:FOO@BAR.BAZ</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 598
    input = "<a+b+c:d>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"a+b+c:d\">a+b+c:d</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 599
    input = "<made-up-scheme://foo,bar>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"made-up-scheme://foo,bar\">made-up-scheme://foo,bar</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 600
    input = "<https://../>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"https://../\">https://../</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 601
    input = "<localhost:5001/foo>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"localhost:5001/foo\">localhost:5001/foo</a></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 602
    input = "<https://foo.bar/baz bim>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;https://foo.bar/baz bim&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 603
    input = "<https://example.com/\\[\\>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"https://example.com/%5C%5B%5C\">https://example.com/\\[\\</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 604
    input = "<foo@bar.example.com>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"mailto:foo@bar.example.com\">foo@bar.example.com</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 605
    input = "<foo+special@Bar.baz-bar0.com>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"mailto:foo+special@Bar.baz-bar0.com\">foo+special@Bar.baz-bar0.com</a></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 606
    input = "<foo\\+@bar.example.com>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;foo+@bar.example.com&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 607
    input = "<>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 608
    input = "< https://foo.bar >\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt; https://foo.bar &gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 609
    input = "<m:abc>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;m:abc&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 610
    input = "<foo.bar.baz>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;foo.bar.baz&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 611
    input = "https://example.com\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>https://example.com</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 612
    input = "foo@bar.example.com\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo@bar.example.com</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Raw HTML
#
@testset "Raw HTML" begin

    # Example 613
    input = "<a><bab><c2c>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a><bab><c2c></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 614
    input = "<a/><b2/>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a/><b2/></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 615
    input = "<a  /><b2\ndata=\"foo\" >\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a  /><b2\ndata=\"foo\" ></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 616
    input = "<a foo=\"bar\" bam = 'baz <em>\"</em>'\n_boolean zoop:33=zoop:33 />\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a foo=\"bar\" bam = 'baz <em>\"</em>'\n_boolean zoop:33=zoop:33 /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 617
    input = "Foo <responsive-image src=\"foo.jpg\" />\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo <responsive-image src=\"foo.jpg\" /></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 618
    input = "<33> <__>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;33&gt; &lt;__&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 619
    input = "<a h*#ref=\"hi\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;a h*#ref=&quot;hi&quot;&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 620
    input = "<a href=\"hi'> <a href=hi'>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;a href=&quot;hi'&gt; &lt;a href=hi'&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 621
    input = "< a><\nfoo><bar/ >\n<foo bar=baz\nbim!bop />\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt; a&gt;&lt;\nfoo&gt;&lt;bar/ &gt;\n&lt;foo bar=baz\nbim!bop /&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 622
    input = "<a href='bar'title=title>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;a href='bar'title=title&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 623
    input = "</a></foo >\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p></a></foo ></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 624
    input = "</a href=\"foo\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;/a href=&quot;foo&quot;&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 625
    input = "foo <!-- this is a --\ncomment - with hyphens -->\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <!-- this is a --\ncomment - with hyphens --></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 626
    input = "foo <!--> foo -->\n\nfoo <!---> foo -->\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <!--> foo --&gt;</p>\n<p>foo <!---> foo --&gt;</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 627
    input = "foo <?php echo \$a; ?>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <?php echo \$a; ?></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 628
    input = "foo <!ELEMENT br EMPTY>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <!ELEMENT br EMPTY></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 629
    input = "foo <![CDATA[>&<]]>\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <![CDATA[>&<]]></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 630
    input = "foo <a href=\"&ouml;\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <a href=\"&ouml;\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 631
    input = "foo <a href=\"\\*\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo <a href=\"\\*\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 632
    input = "<a href=\"\\\"\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>&lt;a href=&quot;&quot;&quot;&gt;</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Hard line breaks
#
@testset "Hard line breaks" begin

    # Example 633
    input = "foo  \nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbaz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 634
    input = "foo\\\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbaz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 635
    input = "foo       \nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbaz</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 636
    input = "foo  \n     bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 637
    input = "foo\\\n     bar\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo<br />\nbar</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 638
    input = "*foo  \nbar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo<br />\nbar</em></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 639
    input = "*foo\\\nbar*\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><em>foo<br />\nbar</em></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 640
    input = "`code  \nspan`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>code   span</code></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 641
    input = "`code\\\nspan`\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><code>code\\ span</code></p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 642
    input = "<a href=\"foo  \nbar\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo  \nbar\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 643
    input = "<a href=\"foo\\\nbar\">\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p><a href=\"foo\\\nbar\"></p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 644
    input = "foo\\\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\\</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 645
    input = "foo  \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo</p>\n"
    actual = Markdown.html(md)
    @test_broken expected == actual

    # Example 646
    input = "### foo\\\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo\\</h3>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 647
    input = "### foo  \n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<h3>foo</h3>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Soft line breaks
#
@testset "Soft line breaks" begin

    # Example 648
    input = "foo\nbaz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\nbaz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 649
    input = "foo \n baz\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>foo\nbaz</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

#
# Textual content
#
@testset "Textual content" begin

    # Example 650
    input = "hello \$.;'there\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>hello \$.;'there</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 651
    input = "Foo χρῆν\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Foo χρῆν</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

    # Example 652
    input = "Multiple     spaces\n"
    md = Markdown.parse(input; flavor=:github)
    expected = "<p>Multiple     spaces</p>\n"
    actual = Markdown.html(md)
    @test expected == actual

end

end
