# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: freetier
using AWS.Compat
using AWS.UUIDs

"""
    get_free_tier_usage()
    get_free_tier_usage(params::Dict{String,<:Any})

Returns a list of all Free Tier usage objects that match your filters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: An expression that specifies the conditions that you want each FreeTierUsage
  object to meet.
- `"maxResults"`: The maximum number of results to return in the response. MaxResults means
  that there can be up to the specified number of values, but there might be fewer results
  based on your filters.
- `"nextToken"`: The pagination token that indicates the next set of results to retrieve.
"""
function get_free_tier_usage(; aws_config::AbstractAWSConfig=current_aws_config())
    return freetier(
        "GetFreeTierUsage"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_free_tier_usage(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return freetier(
        "GetFreeTierUsage", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
