# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: kafkaconnect
using AWS.Compat
using AWS.UUIDs

"""
    create_connector(capacity, connector_configuration, connector_name, kafka_cluster, kafka_cluster_client_authentication, kafka_cluster_encryption_in_transit, kafka_connect_version, plugins, service_execution_role_arn)
    create_connector(capacity, connector_configuration, connector_name, kafka_cluster, kafka_cluster_client_authentication, kafka_cluster_encryption_in_transit, kafka_connect_version, plugins, service_execution_role_arn, params::Dict{String,<:Any})

Creates a connector using the specified properties.

# Arguments
- `capacity`: Information about the capacity allocated to the connector. Exactly one of the
  two properties must be specified.
- `connector_configuration`: A map of keys to values that represent the configuration for
  the connector.
- `connector_name`: The name of the connector.
- `kafka_cluster`: Specifies which Apache Kafka cluster to connect to.
- `kafka_cluster_client_authentication`: Details of the client authentication used by the
  Apache Kafka cluster.
- `kafka_cluster_encryption_in_transit`: Details of encryption in transit to the Apache
  Kafka cluster.
- `kafka_connect_version`: The version of Kafka Connect. It has to be compatible with both
  the Apache Kafka cluster's version and the plugins.
- `plugins`:  Amazon MSK Connect does not currently support specifying multiple plugins as
  a list. To use more than one plugin for your connector, you can create a single custom
  plugin using a ZIP file that bundles multiple plugins together.  Specifies which plugin to
  use for the connector. You must specify a single-element list containing one customPlugin
  object.
- `service_execution_role_arn`: The Amazon Resource Name (ARN) of the IAM role used by the
  connector to access the Amazon Web Services resources that it needs. The types of resources
  depends on the logic of the connector. For example, a connector that has Amazon S3 as a
  destination must have permissions that allow it to write to the S3 destination bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"connectorDescription"`: A summary description of the connector.
- `"logDelivery"`: Details about log delivery.
- `"tags"`: The tags you want to attach to the connector.
- `"workerConfiguration"`: Specifies which worker configuration to use with the connector.
"""
function create_connector(
    capacity,
    connectorConfiguration,
    connectorName,
    kafkaCluster,
    kafkaClusterClientAuthentication,
    kafkaClusterEncryptionInTransit,
    kafkaConnectVersion,
    plugins,
    serviceExecutionRoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "POST",
        "/v1/connectors",
        Dict{String,Any}(
            "capacity" => capacity,
            "connectorConfiguration" => connectorConfiguration,
            "connectorName" => connectorName,
            "kafkaCluster" => kafkaCluster,
            "kafkaClusterClientAuthentication" => kafkaClusterClientAuthentication,
            "kafkaClusterEncryptionInTransit" => kafkaClusterEncryptionInTransit,
            "kafkaConnectVersion" => kafkaConnectVersion,
            "plugins" => plugins,
            "serviceExecutionRoleArn" => serviceExecutionRoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connector(
    capacity,
    connectorConfiguration,
    connectorName,
    kafkaCluster,
    kafkaClusterClientAuthentication,
    kafkaClusterEncryptionInTransit,
    kafkaConnectVersion,
    plugins,
    serviceExecutionRoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "POST",
        "/v1/connectors",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "capacity" => capacity,
                    "connectorConfiguration" => connectorConfiguration,
                    "connectorName" => connectorName,
                    "kafkaCluster" => kafkaCluster,
                    "kafkaClusterClientAuthentication" => kafkaClusterClientAuthentication,
                    "kafkaClusterEncryptionInTransit" => kafkaClusterEncryptionInTransit,
                    "kafkaConnectVersion" => kafkaConnectVersion,
                    "plugins" => plugins,
                    "serviceExecutionRoleArn" => serviceExecutionRoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_plugin(content_type, location, name)
    create_custom_plugin(content_type, location, name, params::Dict{String,<:Any})

Creates a custom plugin using the specified properties.

# Arguments
- `content_type`: The type of the plugin file.
- `location`: Information about the location of a custom plugin.
- `name`: The name of the custom plugin.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A summary description of the custom plugin.
- `"tags"`: The tags you want to attach to the custom plugin.
"""
function create_custom_plugin(
    contentType, location, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "POST",
        "/v1/custom-plugins",
        Dict{String,Any}(
            "contentType" => contentType, "location" => location, "name" => name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_plugin(
    contentType,
    location,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "POST",
        "/v1/custom-plugins",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "contentType" => contentType, "location" => location, "name" => name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_worker_configuration(name, properties_file_content)
    create_worker_configuration(name, properties_file_content, params::Dict{String,<:Any})

Creates a worker configuration using the specified properties.

# Arguments
- `name`: The name of the worker configuration.
- `properties_file_content`: Base64 encoded contents of connect-distributed.properties file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A summary description of the worker configuration.
- `"tags"`: The tags you want to attach to the worker configuration.
"""
function create_worker_configuration(
    name, propertiesFileContent; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "POST",
        "/v1/worker-configurations",
        Dict{String,Any}("name" => name, "propertiesFileContent" => propertiesFileContent);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_worker_configuration(
    name,
    propertiesFileContent,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "POST",
        "/v1/worker-configurations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "name" => name, "propertiesFileContent" => propertiesFileContent
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connector(connector_arn)
    delete_connector(connector_arn, params::Dict{String,<:Any})

Deletes the specified connector.

# Arguments
- `connector_arn`: The Amazon Resource Name (ARN) of the connector that you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"currentVersion"`: The current version of the connector that you want to delete.
"""
function delete_connector(connectorArn; aws_config::AbstractAWSConfig=current_aws_config())
    return kafkaconnect(
        "DELETE",
        "/v1/connectors/$(connectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connector(
    connectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "DELETE",
        "/v1/connectors/$(connectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_plugin(custom_plugin_arn)
    delete_custom_plugin(custom_plugin_arn, params::Dict{String,<:Any})

Deletes a custom plugin.

# Arguments
- `custom_plugin_arn`: The Amazon Resource Name (ARN) of the custom plugin that you want to
  delete.

"""
function delete_custom_plugin(
    customPluginArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "DELETE",
        "/v1/custom-plugins/$(customPluginArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_plugin(
    customPluginArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "DELETE",
        "/v1/custom-plugins/$(customPluginArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_worker_configuration(worker_configuration_arn)
    delete_worker_configuration(worker_configuration_arn, params::Dict{String,<:Any})

Deletes the specified worker configuration.

# Arguments
- `worker_configuration_arn`: The Amazon Resource Name (ARN) of the worker configuration
  that you want to delete.

"""
function delete_worker_configuration(
    workerConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "DELETE",
        "/v1/worker-configurations/$(workerConfigurationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_worker_configuration(
    workerConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "DELETE",
        "/v1/worker-configurations/$(workerConfigurationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_connector(connector_arn)
    describe_connector(connector_arn, params::Dict{String,<:Any})

Returns summary information about the connector.

# Arguments
- `connector_arn`: The Amazon Resource Name (ARN) of the connector that you want to
  describe.

"""
function describe_connector(
    connectorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/connectors/$(connectorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_connector(
    connectorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "GET",
        "/v1/connectors/$(connectorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_custom_plugin(custom_plugin_arn)
    describe_custom_plugin(custom_plugin_arn, params::Dict{String,<:Any})

A summary description of the custom plugin.

# Arguments
- `custom_plugin_arn`: Returns information about a custom plugin.

"""
function describe_custom_plugin(
    customPluginArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/custom-plugins/$(customPluginArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_custom_plugin(
    customPluginArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "GET",
        "/v1/custom-plugins/$(customPluginArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_worker_configuration(worker_configuration_arn)
    describe_worker_configuration(worker_configuration_arn, params::Dict{String,<:Any})

Returns information about a worker configuration.

# Arguments
- `worker_configuration_arn`: The Amazon Resource Name (ARN) of the worker configuration
  that you want to get information about.

"""
function describe_worker_configuration(
    workerConfigurationArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/worker-configurations/$(workerConfigurationArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_worker_configuration(
    workerConfigurationArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "GET",
        "/v1/worker-configurations/$(workerConfigurationArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_connectors()
    list_connectors(params::Dict{String,<:Any})

Returns a list of all the connectors in this account and Region. The list is limited to
connectors whose name starts with the specified prefix. The response also includes a
description of each of the listed connectors.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"connectorNamePrefix"`: The name prefix that you want to use to search for and list
  connectors.
- `"maxResults"`: The maximum number of connectors to list in one response.
- `"nextToken"`: If the response of a ListConnectors operation is truncated, it will
  include a NextToken. Send this NextToken in a subsequent request to continue listing from
  where the previous operation left off.
"""
function list_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafkaconnect(
        "GET", "/v1/connectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/connectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_custom_plugins()
    list_custom_plugins(params::Dict{String,<:Any})

Returns a list of all of the custom plugins in this account and Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of custom plugins to list in one response.
- `"namePrefix"`: Lists custom plugin names that start with the specified text string.
- `"nextToken"`: If the response of a ListCustomPlugins operation is truncated, it will
  include a NextToken. Send this NextToken in a subsequent request to continue listing from
  where the previous operation left off.
"""
function list_custom_plugins(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafkaconnect(
        "GET", "/v1/custom-plugins"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_custom_plugins(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/custom-plugins",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all the tags attached to the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which you want to list
  all attached tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "GET",
        "/v1/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_worker_configurations()
    list_worker_configurations(params::Dict{String,<:Any})

Returns a list of all of the worker configurations in this account and Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of worker configurations to list in one response.
- `"namePrefix"`: Lists worker configuration names that start with the specified text
  string.
- `"nextToken"`: If the response of a ListWorkerConfigurations operation is truncated, it
  will include a NextToken. Send this NextToken in a subsequent request to continue listing
  from where the previous operation left off.
"""
function list_worker_configurations(; aws_config::AbstractAWSConfig=current_aws_config())
    return kafkaconnect(
        "GET",
        "/v1/worker-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_worker_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "GET",
        "/v1/worker-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Attaches tags to the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to which you want to
  attach tags.
- `tags`: The tags that you want to attach to the resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return kafkaconnect(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from the specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource from which you want to
  remove tags.
- `tag_keys`: The keys of the tags that you want to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return kafkaconnect(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connector(capacity, connector_arn, current_version)
    update_connector(capacity, connector_arn, current_version, params::Dict{String,<:Any})

Updates the specified connector.

# Arguments
- `capacity`: The target capacity.
- `connector_arn`: The Amazon Resource Name (ARN) of the connector that you want to update.
- `current_version`: The current version of the connector that you want to update.

"""
function update_connector(
    capacity,
    connectorArn,
    currentVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "PUT",
        "/v1/connectors/$(connectorArn)",
        Dict{String,Any}("capacity" => capacity, "currentVersion" => currentVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connector(
    capacity,
    connectorArn,
    currentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return kafkaconnect(
        "PUT",
        "/v1/connectors/$(connectorArn)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "capacity" => capacity, "currentVersion" => currentVersion
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
