# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: mediapackagev2
using AWS.Compat
using AWS.UUIDs

"""
    create_channel(channel_group_name, channel_name)
    create_channel(channel_group_name, channel_name, params::Dict{String,<:Any})

Create a channel to start receiving content streams. The channel represents the input to
MediaPackage for incoming live content from an encoder such as AWS Elemental MediaLive. The
channel receives content, and after packaging it, outputs it through an origin endpoint to
downstream devices (such as video players or CDNs) that request the content. You can create
only one channel with each request. We recommend that you spread out channels between
channel groups, such as putting redundant channels in the same AWS Region in different
channel groups.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
  You can't change the name after you create the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Enter any descriptive text that helps you to identify the channel.
- `"InputType"`: The input type will be an immutable field which will be used to define
  whether the channel will allow CMAF ingest or HLS ingest. If unprovided, it will default to
  HLS to preserve current behavior. The allowed values are:    HLS - The HLS streaming
  specification (which defines M3U8 manifests and TS segments).    CMAF - The DASH-IF CMAF
  Ingest specification (which defines CMAF segments with optional DASH manifests).
- `"tags"`: A comma-separated list of tag key:value pairs that you define. For example:
  \"Key1\": \"Value1\",   \"Key2\": \"Value2\"
- `"x-amzn-client-token"`: A unique, case-sensitive token that you provide to ensure the
  idempotency of the request.
"""
function create_channel(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel",
        Dict{String,Any}(
            "ChannelName" => ChannelName, "x-amzn-client-token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChannelName" => ChannelName, "x-amzn-client-token" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_channel_group(channel_group_name)
    create_channel_group(channel_group_name, params::Dict{String,<:Any})

Create a channel group to group your channels and origin endpoints. A channel group is the
top-level resource that consists of channels and origin endpoints that are associated with
it and that provides predictable URLs for stream delivery. All channels and origin
endpoints within the channel group are guaranteed to share the DNS. You can create only one
channel group with each request.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
  You can't use spaces in the name. You can't change the name after you create the channel
  group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Enter any descriptive text that helps you to identify the channel group.
- `"tags"`: A comma-separated list of tag key:value pairs that you define. For example:
  \"Key1\": \"Value1\",   \"Key2\": \"Value2\"
- `"x-amzn-client-token"`: A unique, case-sensitive token that you provide to ensure the
  idempotency of the request.
"""
function create_channel_group(
    ChannelGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "POST",
        "/channelGroup",
        Dict{String,Any}(
            "ChannelGroupName" => ChannelGroupName, "x-amzn-client-token" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel_group(
    ChannelGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ChannelGroupName" => ChannelGroupName,
                    "x-amzn-client-token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_origin_endpoint(channel_group_name, channel_name, container_type, origin_endpoint_name)
    create_origin_endpoint(channel_group_name, channel_name, container_type, origin_endpoint_name, params::Dict{String,<:Any})

The endpoint is attached to a channel, and represents the output of the live content. You
can associate multiple endpoints to a single channel. Each endpoint gives players and
downstream CDNs (such as Amazon CloudFront) access to the content for playback. Content
can't be served from a channel until it has an endpoint. You can create only one endpoint
with each request.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `container_type`: The type of container to attach to this origin endpoint. A container
  type is a file format that encapsulates one or more media streams, such as audio and video,
  into a single file. You can't change the container type after you create the endpoint.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and must be unique for your account in the AWS
  Region and channel. You can't use spaces in the name. You can't change the name after you
  create the endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DashManifests"`: A DASH manifest configuration.
- `"Description"`: Enter any descriptive text that helps you to identify the origin
  endpoint.
- `"ForceEndpointErrorConfiguration"`: The failover settings for the endpoint.
- `"HlsManifests"`: An HTTP live streaming (HLS) manifest configuration.
- `"LowLatencyHlsManifests"`: A low-latency HLS manifest configuration.
- `"Segment"`: The segment configuration, including the segment name, duration, and other
  configuration values.
- `"StartoverWindowSeconds"`: The size of the window (in seconds) to create a window of the
  live stream that's available for on-demand viewing. Viewers can start-over or catch-up on
  content that falls within the window. The maximum startover window is 1,209,600 seconds (14
  days).
- `"Tags"`: A comma-separated list of tag key:value pairs that you define. For example:
  \"Key1\": \"Value1\",   \"Key2\": \"Value2\"
- `"x-amzn-client-token"`: A unique, case-sensitive token that you provide to ensure the
  idempotency of the request.
"""
function create_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    ContainerType,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint",
        Dict{String,Any}(
            "ContainerType" => ContainerType,
            "OriginEndpointName" => OriginEndpointName,
            "x-amzn-client-token" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    ContainerType,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContainerType" => ContainerType,
                    "OriginEndpointName" => OriginEndpointName,
                    "x-amzn-client-token" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel(channel_group_name, channel_name)
    delete_channel(channel_group_name, channel_name, params::Dict{String,<:Any})

Delete a channel to stop AWS Elemental MediaPackage from receiving further content. You
must delete the channel's origin endpoints before you can delete the channel.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

"""
function delete_channel(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_group(channel_group_name)
    delete_channel_group(channel_group_name, params::Dict{String,<:Any})

Delete a channel group. You must delete the channel group's channels and origin endpoints
before you can delete the channel group. If you delete a channel group, you'll lose access
to the egress domain and will have to create a new channel group to replace it.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.

"""
function delete_channel_group(
    ChannelGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_group(
    ChannelGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_policy(channel_group_name, channel_name)
    delete_channel_policy(channel_group_name, channel_name, params::Dict{String,<:Any})

Delete a channel policy.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

"""
function delete_channel_policy(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_policy(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_origin_endpoint(channel_group_name, channel_name, origin_endpoint_name)
    delete_origin_endpoint(channel_group_name, channel_name, origin_endpoint_name, params::Dict{String,<:Any})

Origin endpoints can serve content until they're deleted. Delete the endpoint if it should
no longer respond to playback requests. You must delete all endpoints from a channel before
you can delete the channel.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.

"""
function delete_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name)
    delete_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name, params::Dict{String,<:Any})

Delete an origin endpoint policy.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.

"""
function delete_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_channel(channel_group_name, channel_name)
    get_channel(channel_group_name, channel_name, params::Dict{String,<:Any})

Retrieves the specified channel that's configured in AWS Elemental MediaPackage, including
the origin endpoints that are associated with it.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

"""
function get_channel(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_channel(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_channel_group(channel_group_name)
    get_channel_group(channel_group_name, params::Dict{String,<:Any})

Retrieves the specified channel group that's configured in AWS Elemental MediaPackage,
including the channels and origin endpoints that are associated with it.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.

"""
function get_channel_group(
    ChannelGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_channel_group(
    ChannelGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_channel_policy(channel_group_name, channel_name)
    get_channel_policy(channel_group_name, channel_name, params::Dict{String,<:Any})

Retrieves the specified channel policy that's configured in AWS Elemental MediaPackage.
With policies, you can specify who has access to AWS resources and what actions they can
perform on those resources.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

"""
function get_channel_policy(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_channel_policy(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_origin_endpoint(channel_group_name, channel_name, origin_endpoint_name)
    get_origin_endpoint(channel_group_name, channel_name, origin_endpoint_name, params::Dict{String,<:Any})

Retrieves the specified origin endpoint that's configured in AWS Elemental MediaPackage to
obtain its playback URL and to view the packaging settings that it's currently using.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.

"""
function get_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name)
    get_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name, params::Dict{String,<:Any})

Retrieves the specified origin endpoint policy that's configured in AWS Elemental
MediaPackage.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.

"""
function get_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_groups()
    list_channel_groups(params::Dict{String,<:Any})

Retrieves all channel groups that are configured in AWS Elemental MediaPackage, including
the channels and origin endpoints that are associated with it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: The pagination token from the GET list request. Use the token to fetch the
  next page of results.
"""
function list_channel_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return mediapackagev2(
        "GET", "/channelGroup"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_channel_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/channelGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channels(channel_group_name)
    list_channels(channel_group_name, params::Dict{String,<:Any})

Retrieves all channels in a specific channel group that are configured in AWS Elemental
MediaPackage, including the origin endpoints that are associated with it.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: The pagination token from the GET list request. Use the token to fetch the
  next page of results.
"""
function list_channels(ChannelGroupName; aws_config::AbstractAWSConfig=current_aws_config())
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channels(
    ChannelGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_origin_endpoints(channel_group_name, channel_name)
    list_origin_endpoints(channel_group_name, channel_name, params::Dict{String,<:Any})

Retrieves all origin endpoints in a specific channel that are configured in AWS Elemental
MediaPackage.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response.
- `"nextToken"`: The pagination token from the GET list request. Use the token to fetch the
  next page of results.
"""
function list_origin_endpoints(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_origin_endpoints(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags assigned to a resource.

# Arguments
- `resource_arn`: The ARN of the CloudWatch resource that you want to view tags for.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_channel_policy(channel_group_name, channel_name, policy)
    put_channel_policy(channel_group_name, channel_name, policy, params::Dict{String,<:Any})

Attaches an IAM policy to the specified channel. With policies, you can specify who has
access to AWS resources and what actions they can perform on those resources. You can
attach only one policy with each request.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `policy`: The policy to attach to the specified channel.

"""
function put_channel_policy(
    ChannelGroupName,
    ChannelName,
    Policy;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_channel_policy(
    ChannelGroupName,
    ChannelName,
    Policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/policy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name, policy)
    put_origin_endpoint_policy(channel_group_name, channel_name, origin_endpoint_name, policy, params::Dict{String,<:Any})

Attaches an IAM policy to the specified origin endpoint. You can attach only one policy
with each request.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.
- `policy`: The policy to attach to the specified origin endpoint.

"""
function put_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    Policy;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy",
        Dict{String,Any}("Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_origin_endpoint_policy(
    ChannelGroupName,
    ChannelName,
    OriginEndpointName,
    Policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)/policy",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Policy" => Policy), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one of more tags (key-value pairs) to the specified MediaPackage resource. Tags can
help you organize and categorize your resources. You can also use them to scope user
permissions, by granting a user permission to access or change only resources with certain
tag values. You can use the TagResource operation with a resource that already has tags. If
you specify a new tag key for the resource, this tag is appended to the list of tags
associated with the resource. If you specify a tag key that is already associated with the
resource, the new tag value that you specify replaces the previous value for that tag.

# Arguments
- `resource_arn`: The ARN of the MediaPackage resource that you're adding tags to.
- `tags`: Contains a map of the key-value pairs for the resource tag or tags assigned to
  the resource.

"""
function tag_resource(ResourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return mediapackagev2(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "POST",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource.

# Arguments
- `resource_arn`: The ARN of the MediaPackage resource that you're removing tags from.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_channel(channel_group_name, channel_name)
    update_channel(channel_group_name, channel_name, params::Dict{String,<:Any})

Update the specified channel. You can edit if MediaPackage sends ingest or egress access
logs to the CloudWatch log group, if content will be encrypted, the description on a
channel, and your channel's policy settings. You can't edit the name of the channel or
CloudFront distribution details. Any edits you make that impact the video output may not be
reflected for a few minutes.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Any descriptive information that you want to add to the channel for
  future identification purposes.
- `"x-amzn-update-if-match"`: The expected current Entity Tag (ETag) for the resource. If
  the specified ETag does not match the resource's current entity tag, the update request
  will be rejected.
"""
function update_channel(
    ChannelGroupName, ChannelName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_channel(
    ChannelGroupName,
    ChannelName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_channel_group(channel_group_name)
    update_channel_group(channel_group_name, params::Dict{String,<:Any})

Update the specified channel group. You can edit the description on a channel group for
easier identification later from the AWS Elemental MediaPackage console. You can't edit the
name of the channel group. Any edits you make that impact the video output may not be
reflected for a few minutes.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: Any descriptive information that you want to add to the channel group
  for future identification purposes.
- `"x-amzn-update-if-match"`: The expected current Entity Tag (ETag) for the resource. If
  the specified ETag does not match the resource's current entity tag, the update request
  will be rejected.
"""
function update_channel_group(
    ChannelGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_channel_group(
    ChannelGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_origin_endpoint(channel_group_name, channel_name, container_type, origin_endpoint_name)
    update_origin_endpoint(channel_group_name, channel_name, container_type, origin_endpoint_name, params::Dict{String,<:Any})

Update the specified origin endpoint. Edit the packaging preferences on an endpoint to
optimize the viewing experience. You can't edit the name of the endpoint. Any edits you
make that impact the video output may not be reflected for a few minutes.

# Arguments
- `channel_group_name`: The name that describes the channel group. The name is the primary
  identifier for the channel group, and must be unique for your account in the AWS Region.
- `channel_name`: The name that describes the channel. The name is the primary identifier
  for the channel, and must be unique for your account in the AWS Region and channel group.
- `container_type`: The type of container attached to this origin endpoint. A container
  type is a file format that encapsulates one or more media streams, such as audio and video,
  into a single file.
- `origin_endpoint_name`: The name that describes the origin endpoint. The name is the
  primary identifier for the origin endpoint, and and must be unique for your account in the
  AWS Region and channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DashManifests"`: A DASH manifest configuration.
- `"Description"`: Any descriptive information that you want to add to the origin endpoint
  for future identification purposes.
- `"ForceEndpointErrorConfiguration"`: The failover settings for the endpoint.
- `"HlsManifests"`: An HTTP live streaming (HLS) manifest configuration.
- `"LowLatencyHlsManifests"`: A low-latency HLS manifest configuration.
- `"Segment"`: The segment configuration, including the segment name, duration, and other
  configuration values.
- `"StartoverWindowSeconds"`: The size of the window (in seconds) to create a window of the
  live stream that's available for on-demand viewing. Viewers can start-over or catch-up on
  content that falls within the window. The maximum startover window is 1,209,600 seconds (14
  days).
- `"x-amzn-update-if-match"`: The expected current Entity Tag (ETag) for the resource. If
  the specified ETag does not match the resource's current entity tag, the update request
  will be rejected.
"""
function update_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    ContainerType,
    OriginEndpointName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)",
        Dict{String,Any}("ContainerType" => ContainerType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_origin_endpoint(
    ChannelGroupName,
    ChannelName,
    ContainerType,
    OriginEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediapackagev2(
        "PUT",
        "/channelGroup/$(ChannelGroupName)/channel/$(ChannelName)/originEndpoint/$(OriginEndpointName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerType" => ContainerType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
