# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: mediastore
using AWS.Compat
using AWS.UUIDs

"""
    create_container(container_name)
    create_container(container_name, params::Dict{String,<:Any})

Creates a storage container to hold objects. A container is similar to a bucket in the
Amazon S3 service.

# Arguments
- `container_name`: The name for the container. The name must be from 1 to 255 characters.
  Container names must be unique to your AWS account within a specific region. As an example,
  you could create a container named movies in every region, as long as you don’t have an
  existing container with that name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: An array of key:value pairs that you define. These values can be anything that
  you want. Typically, the tag key represents a category (such as \"environment\") and the
  tag value represents a specific value within that category (such as \"test,\"
  \"development,\" or \"production\"). You can add up to 50 tags to each container. For more
  information about tagging, including naming and usage conventions, see Tagging Resources in
  MediaStore.
"""
function create_container(ContainerName; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "CreateContainer",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_container(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "CreateContainer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_container(container_name)
    delete_container(container_name, params::Dict{String,<:Any})

Deletes the specified container. Before you make a DeleteContainer request, delete any
objects in the container or in any folders in the container. You can delete only empty
containers.

# Arguments
- `container_name`: The name of the container to delete.

"""
function delete_container(ContainerName; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "DeleteContainer",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_container(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "DeleteContainer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_container_policy(container_name)
    delete_container_policy(container_name, params::Dict{String,<:Any})

Deletes the access policy that is associated with the specified container.

# Arguments
- `container_name`: The name of the container that holds the policy.

"""
function delete_container_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "DeleteContainerPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_container_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "DeleteContainerPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_cors_policy(container_name)
    delete_cors_policy(container_name, params::Dict{String,<:Any})

Deletes the cross-origin resource sharing (CORS) configuration information that is set for
the container. To use this operation, you must have permission to perform the
MediaStore:DeleteCorsPolicy action. The container owner has this permission by default and
can grant this permission to others.

# Arguments
- `container_name`: The name of the container to remove the policy from.

"""
function delete_cors_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "DeleteCorsPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_cors_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "DeleteCorsPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lifecycle_policy(container_name)
    delete_lifecycle_policy(container_name, params::Dict{String,<:Any})

Removes an object lifecycle policy from a container. It takes up to 20 minutes for the
change to take effect.

# Arguments
- `container_name`: The name of the container that holds the object lifecycle policy.

"""
function delete_lifecycle_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "DeleteLifecyclePolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lifecycle_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "DeleteLifecyclePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_metric_policy(container_name)
    delete_metric_policy(container_name, params::Dict{String,<:Any})

Deletes the metric policy that is associated with the specified container. If there is no
metric policy associated with the container, MediaStore doesn't send metrics to CloudWatch.

# Arguments
- `container_name`: The name of the container that is associated with the metric policy
  that you want to delete.

"""
function delete_metric_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "DeleteMetricPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_metric_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "DeleteMetricPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_container()
    describe_container(params::Dict{String,<:Any})

Retrieves the properties of the requested container. This request is commonly used to
retrieve the endpoint of a container. An endpoint is a value assigned by the service when a
new container is created. A container's endpoint does not change after it has been
assigned. The DescribeContainer request returns a single Container object based on
ContainerName. To return all Container objects that are associated with a specified AWS
account, use ListContainers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ContainerName"`: The name of the container to query.
"""
function describe_container(; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "DescribeContainer"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_container(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "DescribeContainer", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_container_policy(container_name)
    get_container_policy(container_name, params::Dict{String,<:Any})

Retrieves the access policy for the specified container. For information about the data
that is included in an access policy, see the AWS Identity and Access Management User Guide.

# Arguments
- `container_name`: The name of the container.

"""
function get_container_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "GetContainerPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_container_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "GetContainerPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_cors_policy(container_name)
    get_cors_policy(container_name, params::Dict{String,<:Any})

Returns the cross-origin resource sharing (CORS) configuration information that is set for
the container. To use this operation, you must have permission to perform the
MediaStore:GetCorsPolicy action. By default, the container owner has this permission and
can grant it to others.

# Arguments
- `container_name`: The name of the container that the policy is assigned to.

"""
function get_cors_policy(ContainerName; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "GetCorsPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_cors_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "GetCorsPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lifecycle_policy(container_name)
    get_lifecycle_policy(container_name, params::Dict{String,<:Any})

Retrieves the object lifecycle policy that is assigned to a container.

# Arguments
- `container_name`: The name of the container that the object lifecycle policy is assigned
  to.

"""
function get_lifecycle_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "GetLifecyclePolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lifecycle_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "GetLifecyclePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_metric_policy(container_name)
    get_metric_policy(container_name, params::Dict{String,<:Any})

Returns the metric policy for the specified container.

# Arguments
- `container_name`: The name of the container that is associated with the metric policy.

"""
function get_metric_policy(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "GetMetricPolicy",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_metric_policy(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "GetMetricPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_containers()
    list_containers(params::Dict{String,<:Any})

Lists the properties of all containers in AWS Elemental MediaStore.  You can query to
receive all the containers in one response. Or you can include the MaxResults parameter to
receive a limited number of containers in each response. In this case, the response
includes a token. To get the next set of containers, send the command again, this time with
the NextToken parameter (with the returned token as its value). The next set of responses
appears, with a token if there are still more containers to receive.  See also
DescribeContainer, which gets the properties of one container.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Enter the maximum number of containers in the response. Use from 1 to 255
  characters.
- `"NextToken"`: Only if you used MaxResults in the first command, enter the token (which
  was included in the previous response) to obtain the next set of containers. This token is
  included in a response only if there actually are more containers to list.
"""
function list_containers(; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "ListContainers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_containers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "ListContainers", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource)
    list_tags_for_resource(resource, params::Dict{String,<:Any})

Returns a list of the tags assigned to the specified container.

# Arguments
- `resource`: The Amazon Resource Name (ARN) for the container.

"""
function list_tags_for_resource(
    Resource; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "ListTagsForResource",
        Dict{String,Any}("Resource" => Resource);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    Resource,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Resource" => Resource), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_container_policy(container_name, policy)
    put_container_policy(container_name, policy, params::Dict{String,<:Any})

Creates an access policy for the specified container to restrict the users and clients that
can access it. For information about the data that is included in an access policy, see the
AWS Identity and Access Management User Guide. For this release of the REST API, you can
create only one policy for a container. If you enter PutContainerPolicy twice, the second
command modifies the existing policy.

# Arguments
- `container_name`: The name of the container.
- `policy`: The contents of the policy, which includes the following:    One Version tag
  One Statement tag that contains the standard tags for the policy.

"""
function put_container_policy(
    ContainerName, Policy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "PutContainerPolicy",
        Dict{String,Any}("ContainerName" => ContainerName, "Policy" => Policy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_container_policy(
    ContainerName,
    Policy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "PutContainerPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ContainerName" => ContainerName, "Policy" => Policy),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_cors_policy(container_name, cors_policy)
    put_cors_policy(container_name, cors_policy, params::Dict{String,<:Any})

Sets the cross-origin resource sharing (CORS) configuration on a container so that the
container can service cross-origin requests. For example, you might want to enable a
request whose origin is http://www.example.com to access your AWS Elemental MediaStore
container at my.example.container.com by using the browser's XMLHttpRequest capability. To
enable CORS on a container, you attach a CORS policy to the container. In the CORS policy,
you configure rules that identify origins and the HTTP methods that can be executed on your
container. The policy can contain up to 398,000 characters. You can add up to 100 rules to
a CORS policy. If more than one rule applies, the service uses the first applicable rule
listed. To learn more about CORS, see Cross-Origin Resource Sharing (CORS) in AWS Elemental
MediaStore.

# Arguments
- `container_name`: The name of the container that you want to assign the CORS policy to.
- `cors_policy`: The CORS policy to apply to the container.

"""
function put_cors_policy(
    ContainerName, CorsPolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "PutCorsPolicy",
        Dict{String,Any}("ContainerName" => ContainerName, "CorsPolicy" => CorsPolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_cors_policy(
    ContainerName,
    CorsPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "PutCorsPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContainerName" => ContainerName, "CorsPolicy" => CorsPolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_lifecycle_policy(container_name, lifecycle_policy)
    put_lifecycle_policy(container_name, lifecycle_policy, params::Dict{String,<:Any})

Writes an object lifecycle policy to a container. If the container already has an object
lifecycle policy, the service replaces the existing policy with the new policy. It takes up
to 20 minutes for the change to take effect. For information about how to construct an
object lifecycle policy, see Components of an Object Lifecycle Policy.

# Arguments
- `container_name`: The name of the container that you want to assign the object lifecycle
  policy to.
- `lifecycle_policy`: The object lifecycle policy to apply to the container.

"""
function put_lifecycle_policy(
    ContainerName, LifecyclePolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "PutLifecyclePolicy",
        Dict{String,Any}(
            "ContainerName" => ContainerName, "LifecyclePolicy" => LifecyclePolicy
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_lifecycle_policy(
    ContainerName,
    LifecyclePolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "PutLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContainerName" => ContainerName, "LifecyclePolicy" => LifecyclePolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_metric_policy(container_name, metric_policy)
    put_metric_policy(container_name, metric_policy, params::Dict{String,<:Any})

The metric policy that you want to add to the container. A metric policy allows AWS
Elemental MediaStore to send metrics to Amazon CloudWatch. It takes up to 20 minutes for
the new policy to take effect.

# Arguments
- `container_name`: The name of the container that you want to add the metric policy to.
- `metric_policy`: The metric policy that you want to associate with the container. In the
  policy, you must indicate whether you want MediaStore to send container-level metrics. You
  can also include up to five rules to define groups of objects that you want MediaStore to
  send object-level metrics for. If you include rules in the policy, construct each rule with
  both of the following:   An object group that defines which objects to include in the
  group. The definition can be a path or a file name, but it can't have more than 900
  characters. Valid characters are: a-z, A-Z, 0-9, _ (underscore), = (equal), : (colon), .
  (period), - (hyphen), ~ (tilde), / (forward slash), and * (asterisk). Wildcards (*) are
  acceptable.   An object group name that allows you to refer to the object group. The name
  can't have more than 30 characters. Valid characters are: a-z, A-Z, 0-9, and _
  (underscore).

"""
function put_metric_policy(
    ContainerName, MetricPolicy; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "PutMetricPolicy",
        Dict{String,Any}("ContainerName" => ContainerName, "MetricPolicy" => MetricPolicy);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_metric_policy(
    ContainerName,
    MetricPolicy,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "PutMetricPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ContainerName" => ContainerName, "MetricPolicy" => MetricPolicy
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_access_logging(container_name)
    start_access_logging(container_name, params::Dict{String,<:Any})

Starts access logging on the specified container. When you enable access logging on a
container, MediaStore delivers access logs for objects stored in that container to Amazon
CloudWatch Logs.

# Arguments
- `container_name`: The name of the container that you want to start access logging on.

"""
function start_access_logging(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "StartAccessLogging",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_access_logging(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "StartAccessLogging",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_access_logging(container_name)
    stop_access_logging(container_name, params::Dict{String,<:Any})

Stops access logging on the specified container. When you stop access logging on a
container, MediaStore stops sending access logs to Amazon CloudWatch Logs. These access
logs are not saved and are not retrievable.

# Arguments
- `container_name`: The name of the container that you want to stop access logging on.

"""
function stop_access_logging(
    ContainerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "StopAccessLogging",
        Dict{String,Any}("ContainerName" => ContainerName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_access_logging(
    ContainerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "StopAccessLogging",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ContainerName" => ContainerName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource, tags)
    tag_resource(resource, tags, params::Dict{String,<:Any})

Adds tags to the specified AWS Elemental MediaStore container. Tags are key:value pairs
that you can associate with AWS resources. For example, the tag key might be \"customer\"
and the tag value might be \"companyA.\" You can specify one or more tags to add to each
container. You can add up to 50 tags to each container. For more information about tagging,
including naming and usage conventions, see Tagging Resources in MediaStore.

# Arguments
- `resource`: The Amazon Resource Name (ARN) for the container.
- `tags`: An array of key:value pairs that you want to add to the container. You need to
  specify only the tags that you want to add or update. For example, suppose a container
  already has two tags (customer:CompanyA and priority:High). You want to change the priority
  tag and also add a third tag (type:Contract). For TagResource, you specify the following
  tags: priority:Medium, type:Contract. The result is that your container has three tags:
  customer:CompanyA, priority:Medium, and type:Contract.

"""
function tag_resource(Resource, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return mediastore(
        "TagResource",
        Dict{String,Any}("Resource" => Resource, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Resource,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Resource" => Resource, "Tags" => Tags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource, tag_keys)
    untag_resource(resource, tag_keys, params::Dict{String,<:Any})

Removes tags from the specified container. You can specify one or more tags to remove.

# Arguments
- `resource`: The Amazon Resource Name (ARN) for the container.
- `tag_keys`: A comma-separated list of keys for tags that you want to remove from the
  container. For example, if your container has two tags (customer:CompanyA and
  priority:High) and you want to remove one of the tags (priority:High), you specify the key
  for the tag that you want to remove (priority).

"""
function untag_resource(
    Resource, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return mediastore(
        "UntagResource",
        Dict{String,Any}("Resource" => Resource, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    Resource,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return mediastore(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Resource" => Resource, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
