# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: oam
using AWS.Compat
using AWS.UUIDs

"""
    create_link(label_template, resource_types, sink_identifier)
    create_link(label_template, resource_types, sink_identifier, params::Dict{String,<:Any})

Creates a link between a source account and a sink that you have created in a monitoring
account. After the link is created, data is sent from the source account to the monitoring
account. When you create a link, you can optionally specify filters that specify which
metric namespaces and which log groups are shared from the source account to the monitoring
account. Before you create a link, you must create a sink in the monitoring account and
create a sink policy in that account. The sink policy must permit the source account to
link to it. You can grant permission to source accounts by granting permission to an entire
organization or to individual accounts. For more information, see CreateSink and
PutSinkPolicy. Each monitoring account can be linked to as many as 100,000 source accounts.
Each source account can be linked to as many as five monitoring accounts.

# Arguments
- `label_template`: Specify a friendly human-readable name to use to identify this source
  account when you are viewing data from it in the monitoring account. You can use a custom
  label or use the following variables:    AccountName is the name of the account
  AccountEmail is the globally unique email address of the account    AccountEmailNoDomain is
  the email address of the account without the domain name
- `resource_types`: An array of strings that define which types of data that the source
  account shares with the monitoring account.
- `sink_identifier`: The ARN of the sink to use to create this link. You can use ListSinks
  to find the ARNs of sinks. For more information about sinks, see CreateSink.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkConfiguration"`: Use this structure to optionally create filters that specify that
  only some metric namespaces or log groups are to be shared from the source account to the
  monitoring account.
- `"Tags"`: Assigns one or more tags (key-value pairs) to the link.  Tags can help you
  organize and categorize your resources. You can also use them to scope user permissions by
  granting a user permission to access or change only resources with certain tag values. For
  more information about using tags to control access, see Controlling access to Amazon Web
  Services resources using tags.
"""
function create_link(
    LabelTemplate,
    ResourceTypes,
    SinkIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/CreateLink",
        Dict{String,Any}(
            "LabelTemplate" => LabelTemplate,
            "ResourceTypes" => ResourceTypes,
            "SinkIdentifier" => SinkIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_link(
    LabelTemplate,
    ResourceTypes,
    SinkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/CreateLink",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LabelTemplate" => LabelTemplate,
                    "ResourceTypes" => ResourceTypes,
                    "SinkIdentifier" => SinkIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sink(name)
    create_sink(name, params::Dict{String,<:Any})

Use this to create a sink in the current account, so that it can be used as a monitoring
account in CloudWatch cross-account observability. A sink is a resource that represents an
attachment point in a monitoring account. Source accounts can link to the sink to send
observability data. After you create a sink, you must create a sink policy that allows
source accounts to attach to it. For more information, see PutSinkPolicy. Each account can
contain one sink per Region. If you delete a sink, you can then create a new one in that
Region.

# Arguments
- `name`: A name for the sink.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Assigns one or more tags (key-value pairs) to the link.  Tags can help you
  organize and categorize your resources. You can also use them to scope user permissions by
  granting a user permission to access or change only resources with certain tag values. For
  more information about using tags to control access, see Controlling access to Amazon Web
  Services resources using tags.
"""
function create_sink(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/CreateSink",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sink(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST",
        "/CreateSink",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_link(identifier)
    delete_link(identifier, params::Dict{String,<:Any})

Deletes a link between a monitoring account sink and a source account. You must run this
operation in the source account.

# Arguments
- `identifier`: The ARN of the link to delete.

"""
function delete_link(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/DeleteLink",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_link(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/DeleteLink",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sink(identifier)
    delete_sink(identifier, params::Dict{String,<:Any})

Deletes a sink. You must delete all links to a sink before you can delete that sink.

# Arguments
- `identifier`: The ARN of the sink to delete.

"""
function delete_sink(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/DeleteSink",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sink(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/DeleteSink",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_link(identifier)
    get_link(identifier, params::Dict{String,<:Any})

Returns complete information about one link. To use this operation, provide the link ARN.
To retrieve a list of link ARNs, use ListLinks.

# Arguments
- `identifier`: The ARN of the link to retrieve information for.

"""
function get_link(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/GetLink",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_link(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/GetLink",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sink(identifier)
    get_sink(identifier, params::Dict{String,<:Any})

Returns complete information about one monitoring account sink. To use this operation,
provide the sink ARN. To retrieve a list of sink ARNs, use ListSinks.

# Arguments
- `identifier`: The ARN of the sink to retrieve information for.

"""
function get_sink(Identifier; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/GetSink",
        Dict{String,Any}("Identifier" => Identifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sink(
    Identifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/GetSink",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Identifier" => Identifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sink_policy(sink_identifier)
    get_sink_policy(sink_identifier, params::Dict{String,<:Any})

Returns the current sink policy attached to this sink. The sink policy specifies what
accounts can attach to this sink as source accounts, and what types of data they can share.

# Arguments
- `sink_identifier`: The ARN of the sink to retrieve the policy of.

"""
function get_sink_policy(SinkIdentifier; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "POST",
        "/GetSinkPolicy",
        Dict{String,Any}("SinkIdentifier" => SinkIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sink_policy(
    SinkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/GetSinkPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SinkIdentifier" => SinkIdentifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attached_links(sink_identifier)
    list_attached_links(sink_identifier, params::Dict{String,<:Any})

Returns a list of source account links that are linked to this monitoring account sink. To
use this operation, provide the sink ARN. To retrieve a list of sink ARNs, use ListSinks.
To find a list of links for one source account, use ListLinks.

# Arguments
- `sink_identifier`: The ARN of the sink that you want to retrieve links for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Limits the number of returned links to the specified number.
- `"NextToken"`: The token for the next set of items to return. You received this token
  from a previous call.
"""
function list_attached_links(
    SinkIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST",
        "/ListAttachedLinks",
        Dict{String,Any}("SinkIdentifier" => SinkIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attached_links(
    SinkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/ListAttachedLinks",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SinkIdentifier" => SinkIdentifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_links()
    list_links(params::Dict{String,<:Any})

Use this operation in a source account to return a list of links to monitoring account
sinks that this source account has. To find a list of links for one monitoring account
sink, use ListAttachedLinks from within the monitoring account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Limits the number of returned links to the specified number.
- `"NextToken"`: The token for the next set of items to return. You received this token
  from a previous call.
"""
function list_links(; aws_config::AbstractAWSConfig=current_aws_config())
    return oam("POST", "/ListLinks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_links(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST", "/ListLinks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_sinks()
    list_sinks(params::Dict{String,<:Any})

Use this operation in a monitoring account to return the list of sinks created in that
account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: Limits the number of returned links to the specified number.
- `"NextToken"`: The token for the next set of items to return. You received this token
  from a previous call.
"""
function list_sinks(; aws_config::AbstractAWSConfig=current_aws_config())
    return oam("POST", "/ListSinks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_sinks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST", "/ListSinks", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Displays the tags associated with a resource. Both sinks and links support tagging.

# Arguments
- `resource_arn`: The ARN of the resource that you want to view tags for. The ARN format of
  a sink is arn:aws:oam:Region:account-id:sink/sink-id   The ARN format of a link is
  arn:aws:oam:Region:account-id:link/link-id   For more information about ARN format, see
  CloudWatch Logs resources and operations.  Unlike tagging permissions in other Amazon Web
  Services services, to retrieve the list of tags for links or sinks you must have the
  oam:RequestTag permission. The aws:ReguestTag permission does not allow you to tag and
  untag links and sinks.

"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "GET",
        "/tags/$(ResourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "GET",
        "/tags/$(ResourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sink_policy(policy, sink_identifier)
    put_sink_policy(policy, sink_identifier, params::Dict{String,<:Any})

Creates or updates the resource policy that grants permissions to source accounts to link
to the monitoring account sink. When you create a sink policy, you can grant permissions to
all accounts in an organization or to individual accounts. You can also use a sink policy
to limit the types of data that is shared. The three types that you can allow or deny are:
  Metrics - Specify with AWS::CloudWatch::Metric     Log groups - Specify with
AWS::Logs::LogGroup     Traces - Specify with AWS::XRay::Trace     Application Insights -
Applications - Specify with AWS::ApplicationInsights::Application    See the examples in
this section to see how to specify permitted source accounts and data types.

# Arguments
- `policy`: The JSON policy to use. If you are updating an existing policy, the entire
  existing policy is replaced by what you specify here. The policy must be in JSON string
  format with quotation marks escaped and no newlines. For examples of different types of
  policies, see the Examples section on this page.
- `sink_identifier`: The ARN of the sink to attach this policy to.

"""
function put_sink_policy(
    Policy, SinkIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST",
        "/PutSinkPolicy",
        Dict{String,Any}("Policy" => Policy, "SinkIdentifier" => SinkIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sink_policy(
    Policy,
    SinkIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/PutSinkPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Policy" => Policy, "SinkIdentifier" => SinkIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified resource. Both sinks and links
can be tagged.  Tags can help you organize and categorize your resources. You can also use
them to scope user permissions by granting a user permission to access or change only
resources with certain tag values. Tags don't have any semantic meaning to Amazon Web
Services and are interpreted strictly as strings of characters. You can use the TagResource
action with a resource that already has tags. If you specify a new tag key for the alarm,
this tag is appended to the list of tags associated with the alarm. If you specify a tag
key that is already associated with the alarm, the new tag value that you specify replaces
the previous value for that tag. You can associate as many as 50 tags with a resource.
Unlike tagging permissions in other Amazon Web Services services, to tag or untag links and
sinks you must have the oam:ResourceTag permission. The iam:ResourceTag permission does not
allow you to tag and untag links and sinks.

# Arguments
- `resource_arn`: The ARN of the resource that you're adding tags to. The ARN format of a
  sink is arn:aws:oam:Region:account-id:sink/sink-id   The ARN format of a link is
  arn:aws:oam:Region:account-id:link/link-id   For more information about ARN format, see
  CloudWatch Logs resources and operations.
- `tags`: The list of key-value pairs to associate with the resource.

"""
function tag_resource(ResourceArn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return oam(
        "PUT",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "PUT",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified resource.  Unlike tagging permissions in other
Amazon Web Services services, to tag or untag links and sinks you must have the
oam:ResourceTag permission. The iam:TagResource permission does not allow you to tag and
untag links and sinks.

# Arguments
- `resource_arn`: The ARN of the resource that you're removing tags from. The ARN format of
  a sink is arn:aws:oam:Region:account-id:sink/sink-id   The ARN format of a link is
  arn:aws:oam:Region:account-id:link/link-id   For more information about ARN format, see
  CloudWatch Logs resources and operations.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    ResourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "DELETE",
        "/tags/$(ResourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_link(identifier, resource_types)
    update_link(identifier, resource_types, params::Dict{String,<:Any})

Use this operation to change what types of data are shared from a source account to its
linked monitoring account sink. You can't change the sink or change the monitoring account
with this operation. When you update a link, you can optionally specify filters that
specify which metric namespaces and which log groups are shared from the source account to
the monitoring account. To update the list of tags associated with the sink, use
TagResource.

# Arguments
- `identifier`: The ARN of the link that you want to update.
- `resource_types`: An array of strings that define which types of data that the source
  account will send to the monitoring account. Your input here replaces the current set of
  data types that are shared.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkConfiguration"`: Use this structure to filter which metric namespaces and which log
  groups are to be shared from the source account to the monitoring account.
"""
function update_link(
    Identifier, ResourceTypes; aws_config::AbstractAWSConfig=current_aws_config()
)
    return oam(
        "POST",
        "/UpdateLink",
        Dict{String,Any}("Identifier" => Identifier, "ResourceTypes" => ResourceTypes);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_link(
    Identifier,
    ResourceTypes,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return oam(
        "POST",
        "/UpdateLink",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Identifier" => Identifier, "ResourceTypes" => ResourceTypes
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
