# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: osis
using AWS.Compat
using AWS.UUIDs

"""
    create_pipeline(max_units, min_units, pipeline_configuration_body, pipeline_name)
    create_pipeline(max_units, min_units, pipeline_configuration_body, pipeline_name, params::Dict{String,<:Any})

Creates an OpenSearch Ingestion pipeline. For more information, see Creating Amazon
OpenSearch Ingestion pipelines.

# Arguments
- `max_units`: The maximum pipeline capacity, in Ingestion Compute Units (ICUs).
- `min_units`: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
- `pipeline_configuration_body`: The pipeline configuration in YAML format. The command
  accepts the pipeline configuration as a string or within a .yaml file. If you provide the
  configuration as a string, each new line must be escaped with n.
- `pipeline_name`: The name of the OpenSearch Ingestion pipeline to create. Pipeline names
  are unique across the pipelines owned by an account within an Amazon Web Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BufferOptions"`: Key-value pairs to configure persistent buffering for the pipeline.
- `"EncryptionAtRestOptions"`: Key-value pairs to configure encryption for data that is
  written to a persistent buffer.
- `"LogPublishingOptions"`: Key-value pairs to configure log publishing.
- `"Tags"`: List of tags to add to the pipeline upon creation.
- `"VpcOptions"`: Container for the values required to configure VPC access for the
  pipeline. If you don't specify these values, OpenSearch Ingestion creates the pipeline with
  a public endpoint.
"""
function create_pipeline(
    MaxUnits,
    MinUnits,
    PipelineConfigurationBody,
    PipelineName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "POST",
        "/2022-01-01/osis/createPipeline",
        Dict{String,Any}(
            "MaxUnits" => MaxUnits,
            "MinUnits" => MinUnits,
            "PipelineConfigurationBody" => PipelineConfigurationBody,
            "PipelineName" => PipelineName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pipeline(
    MaxUnits,
    MinUnits,
    PipelineConfigurationBody,
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "POST",
        "/2022-01-01/osis/createPipeline",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MaxUnits" => MaxUnits,
                    "MinUnits" => MinUnits,
                    "PipelineConfigurationBody" => PipelineConfigurationBody,
                    "PipelineName" => PipelineName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pipeline(pipeline_name)
    delete_pipeline(pipeline_name, params::Dict{String,<:Any})

Deletes an OpenSearch Ingestion pipeline. For more information, see Deleting Amazon
OpenSearch Ingestion pipelines.

# Arguments
- `pipeline_name`: The name of the pipeline to delete.

"""
function delete_pipeline(PipelineName; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "DELETE",
        "/2022-01-01/osis/deletePipeline/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pipeline(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "DELETE",
        "/2022-01-01/osis/deletePipeline/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pipeline(pipeline_name)
    get_pipeline(pipeline_name, params::Dict{String,<:Any})

Retrieves information about an OpenSearch Ingestion pipeline.

# Arguments
- `pipeline_name`: The name of the pipeline.

"""
function get_pipeline(PipelineName; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "GET",
        "/2022-01-01/osis/getPipeline/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pipeline(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "GET",
        "/2022-01-01/osis/getPipeline/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pipeline_blueprint(blueprint_name)
    get_pipeline_blueprint(blueprint_name, params::Dict{String,<:Any})

Retrieves information about a specific blueprint for OpenSearch Ingestion. Blueprints are
templates for the configuration needed for a CreatePipeline request. For more information,
see Using blueprints to create a pipeline.

# Arguments
- `blueprint_name`: The name of the blueprint to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"format"`: The format format of the blueprint to retrieve.
"""
function get_pipeline_blueprint(
    BlueprintName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "GET",
        "/2022-01-01/osis/getPipelineBlueprint/$(BlueprintName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pipeline_blueprint(
    BlueprintName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "GET",
        "/2022-01-01/osis/getPipelineBlueprint/$(BlueprintName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_pipeline_change_progress(pipeline_name)
    get_pipeline_change_progress(pipeline_name, params::Dict{String,<:Any})

Returns progress information for the current change happening on an OpenSearch Ingestion
pipeline. Currently, this operation only returns information when a pipeline is being
created. For more information, see Tracking the status of pipeline creation.

# Arguments
- `pipeline_name`: The name of the pipeline.

"""
function get_pipeline_change_progress(
    PipelineName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "GET",
        "/2022-01-01/osis/getPipelineChangeProgress/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_pipeline_change_progress(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "GET",
        "/2022-01-01/osis/getPipelineChangeProgress/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pipeline_blueprints()
    list_pipeline_blueprints(params::Dict{String,<:Any})

Retrieves a list of all available blueprints for Data Prepper. For more information, see
Using blueprints to create a pipeline.

"""
function list_pipeline_blueprints(; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "POST",
        "/2022-01-01/osis/listPipelineBlueprints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pipeline_blueprints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "POST",
        "/2022-01-01/osis/listPipelineBlueprints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_pipelines()
    list_pipelines(params::Dict{String,<:Any})

Lists all OpenSearch Ingestion pipelines in the current Amazon Web Services account and
Region. For more information, see Viewing Amazon OpenSearch Ingestion pipelines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: An optional parameter that specifies the maximum number of results to
  return. You can use nextToken to get the next page of results.
- `"nextToken"`: If your initial ListPipelines operation returns a nextToken, you can
  include the returned nextToken in subsequent ListPipelines operations, which returns
  results in the next page.
"""
function list_pipelines(; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "GET",
        "/2022-01-01/osis/listPipelines";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_pipelines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "GET",
        "/2022-01-01/osis/listPipelines",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Lists all resource tags associated with an OpenSearch Ingestion pipeline. For more
information, see Tagging Amazon OpenSearch Ingestion pipelines.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the pipeline to retrieve tags for.

"""
function list_tags_for_resource(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "GET",
        "/2022-01-01/osis/listTagsForResource/",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "GET",
        "/2022-01-01/osis/listTagsForResource/",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_pipeline(pipeline_name)
    start_pipeline(pipeline_name, params::Dict{String,<:Any})

Starts an OpenSearch Ingestion pipeline. For more information, see Starting an OpenSearch
Ingestion pipeline.

# Arguments
- `pipeline_name`: The name of the pipeline to start.

"""
function start_pipeline(PipelineName; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "PUT",
        "/2022-01-01/osis/startPipeline/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_pipeline(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "PUT",
        "/2022-01-01/osis/startPipeline/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_pipeline(pipeline_name)
    stop_pipeline(pipeline_name, params::Dict{String,<:Any})

Stops an OpenSearch Ingestion pipeline. For more information, see Stopping an OpenSearch
Ingestion pipeline.

# Arguments
- `pipeline_name`: The name of the pipeline to stop.

"""
function stop_pipeline(PipelineName; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "PUT",
        "/2022-01-01/osis/stopPipeline/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_pipeline(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "PUT",
        "/2022-01-01/osis/stopPipeline/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(tags, arn)
    tag_resource(tags, arn, params::Dict{String,<:Any})

Tags an OpenSearch Ingestion pipeline. For more information, see Tagging Amazon OpenSearch
Ingestion pipelines.

# Arguments
- `tags`: The list of key-value tags to add to the pipeline.
- `arn`: The Amazon Resource Name (ARN) of the pipeline to tag.

"""
function tag_resource(Tags, arn; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "POST",
        "/2022-01-01/osis/tagResource/",
        Dict{String,Any}("Tags" => Tags, "arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Tags,
    arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "POST",
        "/2022-01-01/osis/tagResource/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Tags" => Tags, "arn" => arn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(tag_keys, arn)
    untag_resource(tag_keys, arn, params::Dict{String,<:Any})

Removes one or more tags from an OpenSearch Ingestion pipeline. For more information, see
Tagging Amazon OpenSearch Ingestion pipelines.

# Arguments
- `tag_keys`: The tag keys to remove.
- `arn`: The Amazon Resource Name (ARN) of the pipeline to remove tags from.

"""
function untag_resource(TagKeys, arn; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "POST",
        "/2022-01-01/osis/untagResource/",
        Dict{String,Any}("TagKeys" => TagKeys, "arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    TagKeys,
    arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "POST",
        "/2022-01-01/osis/untagResource/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TagKeys" => TagKeys, "arn" => arn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pipeline(pipeline_name)
    update_pipeline(pipeline_name, params::Dict{String,<:Any})

Updates an OpenSearch Ingestion pipeline. For more information, see Updating Amazon
OpenSearch Ingestion pipelines.

# Arguments
- `pipeline_name`: The name of the pipeline to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BufferOptions"`: Key-value pairs to configure persistent buffering for the pipeline.
- `"EncryptionAtRestOptions"`: Key-value pairs to configure encryption for data that is
  written to a persistent buffer.
- `"LogPublishingOptions"`: Key-value pairs to configure log publishing.
- `"MaxUnits"`: The maximum pipeline capacity, in Ingestion Compute Units (ICUs)
- `"MinUnits"`: The minimum pipeline capacity, in Ingestion Compute Units (ICUs).
- `"PipelineConfigurationBody"`: The pipeline configuration in YAML format. The command
  accepts the pipeline configuration as a string or within a .yaml file. If you provide the
  configuration as a string, each new line must be escaped with n.
"""
function update_pipeline(PipelineName; aws_config::AbstractAWSConfig=current_aws_config())
    return osis(
        "PUT",
        "/2022-01-01/osis/updatePipeline/$(PipelineName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pipeline(
    PipelineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "PUT",
        "/2022-01-01/osis/updatePipeline/$(PipelineName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_pipeline(pipeline_configuration_body)
    validate_pipeline(pipeline_configuration_body, params::Dict{String,<:Any})

Checks whether an OpenSearch Ingestion pipeline configuration is valid prior to creation.
For more information, see Creating Amazon OpenSearch Ingestion pipelines.

# Arguments
- `pipeline_configuration_body`: The pipeline configuration in YAML format. The command
  accepts the pipeline configuration as a string or within a .yaml file. If you provide the
  configuration as a string, each new line must be escaped with n.

"""
function validate_pipeline(
    PipelineConfigurationBody; aws_config::AbstractAWSConfig=current_aws_config()
)
    return osis(
        "POST",
        "/2022-01-01/osis/validatePipeline",
        Dict{String,Any}("PipelineConfigurationBody" => PipelineConfigurationBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_pipeline(
    PipelineConfigurationBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return osis(
        "POST",
        "/2022-01-01/osis/validatePipeline",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("PipelineConfigurationBody" => PipelineConfigurationBody),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
