# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: amplifyuibuilder
using AWS.Compat
using AWS.UUIDs

"""
    create_component(app_id, component_to_create, environment_name)
    create_component(app_id, component_to_create, environment_name, params::Dict{String,<:Any})

Creates a new component for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app to associate with the component.
- `component_to_create`: Represents the configuration of the component to create.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function create_component(
    appId,
    componentToCreate,
    environmentName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/components",
        Dict{String,Any}(
            "componentToCreate" => componentToCreate, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_component(
    appId,
    componentToCreate,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/components",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "componentToCreate" => componentToCreate,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_form(app_id, environment_name, form_to_create)
    create_form(app_id, environment_name, form_to_create, params::Dict{String,<:Any})

Creates a new form for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app to associate with the form.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.
- `form_to_create`: Represents the configuration of the form to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function create_form(
    appId, environmentName, formToCreate; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/forms",
        Dict{String,Any}("formToCreate" => formToCreate, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_form(
    appId,
    environmentName,
    formToCreate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/forms",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "formToCreate" => formToCreate, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_theme(app_id, environment_name, theme_to_create)
    create_theme(app_id, environment_name, theme_to_create, params::Dict{String,<:Any})

Creates a theme to apply to the components in an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app associated with the theme.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.
- `theme_to_create`: Represents the configuration of the theme to create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function create_theme(
    appId,
    environmentName,
    themeToCreate;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/themes",
        Dict{String,Any}(
            "themeToCreate" => themeToCreate, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_theme(
    appId,
    environmentName,
    themeToCreate,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/themes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "themeToCreate" => themeToCreate, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_component(app_id, environment_name, id)
    delete_component(app_id, environment_name, id, params::Dict{String,<:Any})

Deletes a component from an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app associated with the component to delete.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.
- `id`: The unique ID of the component to delete.

"""
function delete_component(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_component(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_form(app_id, environment_name, id)
    delete_form(app_id, environment_name, id, params::Dict{String,<:Any})

Deletes a form from an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app associated with the form to delete.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.
- `id`: The unique ID of the form to delete.

"""
function delete_form(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_form(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_theme(app_id, environment_name, id)
    delete_theme(app_id, environment_name, id, params::Dict{String,<:Any})

Deletes a theme from an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app associated with the theme to delete.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.
- `id`: The unique ID of the theme to delete.

"""
function delete_theme(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_theme(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "DELETE",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    exchange_code_for_token(provider, request)
    exchange_code_for_token(provider, request, params::Dict{String,<:Any})

 This is for internal use.  Amplify uses this action to exchange an access code for a token.

# Arguments
- `provider`: The third-party provider for the token. The only valid value is figma.
- `request`: Describes the configuration of the request.

"""
function exchange_code_for_token(
    provider, request; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "POST",
        "/tokens/$(provider)",
        Dict{String,Any}("request" => request);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function exchange_code_for_token(
    provider,
    request,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/tokens/$(provider)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("request" => request), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_components(app_id, environment_name)
    export_components(app_id, environment_name, params::Dict{String,<:Any})

Exports component configurations to code that is ready to integrate into an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app to export components to.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token to request the next page of results.
"""
function export_components(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/components";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_components(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/components",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_forms(app_id, environment_name)
    export_forms(app_id, environment_name, params::Dict{String,<:Any})

Exports form configurations to code that is ready to integrate into an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app to export forms to.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token to request the next page of results.
"""
function export_forms(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/forms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_forms(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/forms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_themes(app_id, environment_name)
    export_themes(app_id, environment_name, params::Dict{String,<:Any})

Exports theme configurations to code that is ready to integrate into an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app to export the themes to.
- `environment_name`: The name of the backend environment that is part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nextToken"`: The token to request the next page of results.
"""
function export_themes(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/themes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_themes(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/export/app/$(appId)/environment/$(environmentName)/themes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_codegen_job(app_id, environment_name, id)
    get_codegen_job(app_id, environment_name, id, params::Dict{String,<:Any})

Returns an existing code generation job.

# Arguments
- `app_id`: The unique ID of the Amplify app associated with the code generation job.
- `environment_name`: The name of the backend environment that is a part of the Amplify app
  associated with the code generation job.
- `id`: The unique ID of the code generation job.

"""
function get_codegen_job(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_codegen_job(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_component(app_id, environment_name, id)
    get_component(app_id, environment_name, id, params::Dict{String,<:Any})

Returns an existing component for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID of the component.

"""
function get_component(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_component(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_form(app_id, environment_name, id)
    get_form(app_id, environment_name, id, params::Dict{String,<:Any})

Returns an existing form for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID of the form.

"""
function get_form(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_form(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_metadata(app_id, environment_name)
    get_metadata(app_id, environment_name, params::Dict{String,<:Any})

Returns existing metadata for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.

"""
function get_metadata(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/metadata";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_metadata(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/metadata",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_theme(app_id, environment_name, id)
    get_theme(app_id, environment_name, id, params::Dict{String,<:Any})

Returns an existing theme for an Amplify app.

# Arguments
- `app_id`: The unique ID of the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID for the theme.

"""
function get_theme(
    appId, environmentName, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_theme(
    appId,
    environmentName,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_codegen_jobs(app_id, environment_name)
    list_codegen_jobs(app_id, environment_name, params::Dict{String,<:Any})

Retrieves a list of code generation jobs for a specified Amplify app and backend
environment.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of jobs to retrieve.
- `"nextToken"`: The token to request the next page of results.
"""
function list_codegen_jobs(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_codegen_jobs(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_components(app_id, environment_name)
    list_components(app_id, environment_name, params::Dict{String,<:Any})

Retrieves a list of components for a specified Amplify app and backend environment.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of components to retrieve.
- `"nextToken"`: The token to request the next page of results.
"""
function list_components(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/components";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_components(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/components",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_forms(app_id, environment_name)
    list_forms(app_id, environment_name, params::Dict{String,<:Any})

Retrieves a list of forms for a specified Amplify app and backend environment.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of forms to retrieve.
- `"nextToken"`: The token to request the next page of results.
"""
function list_forms(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/forms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_forms(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/forms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Returns a list of tags for a specified Amazon Resource Name (ARN).

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) to use to list tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_themes(app_id, environment_name)
    list_themes(app_id, environment_name, params::Dict{String,<:Any})

Retrieves a list of themes for a specified Amplify app and backend environment.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of theme results to return in the response.
- `"nextToken"`: The token to request the next page of results.
"""
function list_themes(
    appId, environmentName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/themes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_themes(
    appId,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "GET",
        "/app/$(appId)/environment/$(environmentName)/themes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_metadata_flag(app_id, body, environment_name, feature_name)
    put_metadata_flag(app_id, body, environment_name, feature_name, params::Dict{String,<:Any})

Stores the metadata information about a feature on a form.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `body`: The metadata information to store.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `feature_name`: The name of the feature associated with the metadata.

"""
function put_metadata_flag(
    appId,
    body,
    environmentName,
    featureName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PUT",
        "/app/$(appId)/environment/$(environmentName)/metadata/features/$(featureName)",
        Dict{String,Any}("body" => body);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_metadata_flag(
    appId,
    body,
    environmentName,
    featureName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PUT",
        "/app/$(appId)/environment/$(environmentName)/metadata/features/$(featureName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("body" => body), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    refresh_token(provider, refresh_token_body)
    refresh_token(provider, refresh_token_body, params::Dict{String,<:Any})

 This is for internal use.  Amplify uses this action to refresh a previously issued access
token that might have expired.

# Arguments
- `provider`: The third-party provider for the token. The only valid value is figma.
- `refresh_token_body`: Information about the refresh token request.

"""
function refresh_token(
    provider, refreshTokenBody; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "POST",
        "/tokens/$(provider)/refresh",
        Dict{String,Any}("refreshTokenBody" => refreshTokenBody);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function refresh_token(
    provider,
    refreshTokenBody,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/tokens/$(provider)/refresh",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("refreshTokenBody" => refreshTokenBody), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_codegen_job(app_id, codegen_job_to_create, environment_name)
    start_codegen_job(app_id, codegen_job_to_create, environment_name, params::Dict{String,<:Any})

Starts a code generation job for a specified Amplify app and backend environment.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `codegen_job_to_create`: The code generation job resource configuration.
- `environment_name`: The name of the backend environment that is a part of the Amplify app.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The idempotency token used to ensure that the code generation job
  request completes only once.
"""
function start_codegen_job(
    appId,
    codegenJobToCreate,
    environmentName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs",
        Dict{String,Any}(
            "codegenJobToCreate" => codegenJobToCreate, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_codegen_job(
    appId,
    codegenJobToCreate,
    environmentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/app/$(appId)/environment/$(environmentName)/codegen-jobs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "codegenJobToCreate" => codegenJobToCreate,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tags the resource with a tag key and value.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) to use to tag a resource.
- `tags`: A list of tag key value pairs for a specified Amazon Resource Name (ARN).

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return amplifyuibuilder(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Untags a resource with a specified Amazon Resource Name (ARN).

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) to use to untag a resource.
- `tag_keys`: The tag keys to use to untag a resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return amplifyuibuilder(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_component(app_id, environment_name, id, updated_component)
    update_component(app_id, environment_name, id, updated_component, params::Dict{String,<:Any})

Updates an existing component.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID for the component.
- `updated_component`: The configuration of the updated component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function update_component(
    appId,
    environmentName,
    id,
    updatedComponent;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)",
        Dict{String,Any}(
            "updatedComponent" => updatedComponent, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_component(
    appId,
    environmentName,
    id,
    updatedComponent,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/components/$(id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "updatedComponent" => updatedComponent, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_form(app_id, environment_name, id, updated_form)
    update_form(app_id, environment_name, id, updated_form, params::Dict{String,<:Any})

Updates an existing form.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID for the form.
- `updated_form`: The request accepts the following data in JSON format.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function update_form(
    appId,
    environmentName,
    id,
    updatedForm;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)",
        Dict{String,Any}("updatedForm" => updatedForm, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_form(
    appId,
    environmentName,
    id,
    updatedForm,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/forms/$(id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "updatedForm" => updatedForm, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_theme(app_id, environment_name, id, updated_theme)
    update_theme(app_id, environment_name, id, updated_theme, params::Dict{String,<:Any})

Updates an existing theme.

# Arguments
- `app_id`: The unique ID for the Amplify app.
- `environment_name`: The name of the backend environment that is part of the Amplify app.
- `id`: The unique ID for the theme.
- `updated_theme`: The configuration of the updated theme.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: The unique client token.
"""
function update_theme(
    appId,
    environmentName,
    id,
    updatedTheme;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)",
        Dict{String,Any}("updatedTheme" => updatedTheme, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_theme(
    appId,
    environmentName,
    id,
    updatedTheme,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return amplifyuibuilder(
        "PATCH",
        "/app/$(appId)/environment/$(environmentName)/themes/$(id)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "updatedTheme" => updatedTheme, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
