# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: bedrock_agent
using AWS.Compat
using AWS.UUIDs

"""
    associate_agent_knowledge_base(agent_id, agent_version, description, knowledge_base_id)
    associate_agent_knowledge_base(agent_id, agent_version, description, knowledge_base_id, params::Dict{String,<:Any})

Associates a knowledge base with an agent. If a knowledge base is associated and its
indexState is set to Enabled, the agent queries the knowledge base for information to
augment its response to the user.

# Arguments
- `agent_id`: The unique identifier of the agent with which you want to associate the
  knowledge base.
- `agent_version`: The version of the agent with which you want to associate the knowledge
  base.
- `description`: A description of what the agent should use the knowledge base for.
- `knowledge_base_id`: The unique identifier of the knowledge base to associate with the
  agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"knowledgeBaseState"`: Specifies whether to use the knowledge base or not when sending
  an InvokeAgent request.
"""
function associate_agent_knowledge_base(
    agentId,
    agentVersion,
    description,
    knowledgeBaseId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/",
        Dict{String,Any}(
            "description" => description, "knowledgeBaseId" => knowledgeBaseId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_agent_knowledge_base(
    agentId,
    agentVersion,
    description,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "description" => description, "knowledgeBaseId" => knowledgeBaseId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_agent(agent_name)
    create_agent(agent_name, params::Dict{String,<:Any})

Creates an agent that orchestrates interactions between foundation models, data sources,
software applications, user conversations, and APIs to carry out tasks to help customers.
Specify the following fields for security purposes.    agentResourceRoleArn – The Amazon
Resource Name (ARN) of the role with permissions to invoke API operations on an agent.
(Optional) customerEncryptionKeyArn – The Amazon Resource Name (ARN) of a KMS key to
encrypt the creation of the agent.   (Optional) idleSessionTTLinSeconds – Specify the
number of seconds for which the agent should maintain session information. After this time
expires, the subsequent InvokeAgent request begins a new session.     To override the
default prompt behavior for agent orchestration and to use advanced prompts, include a
promptOverrideConfiguration object. For more information, see Advanced prompts.   If you
agent fails to be created, the response returns a list of failureReasons alongside a list
of recommendedActions for you to troubleshoot.

# Arguments
- `agent_name`: A name for the agent that you create.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"agentResourceRoleArn"`: The Amazon Resource Name (ARN) of the IAM role with permissions
  to invoke API operations on the agent.
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"customerEncryptionKeyArn"`: The Amazon Resource Name (ARN) of the KMS key with which to
  encrypt the agent.
- `"description"`: A description of the agent.
- `"foundationModel"`: The foundation model to be used for orchestration by the agent you
  create.
- `"guardrailConfiguration"`: The unique Guardrail configuration assigned to the agent when
  it is created.
- `"idleSessionTTLInSeconds"`: The number of seconds for which Amazon Bedrock keeps
  information about a user's conversation with the agent. A user interaction remains active
  for the amount of time specified. If no conversation occurs during this time, the session
  expires and Amazon Bedrock deletes any data provided before the timeout.
- `"instruction"`: Instructions that tell the agent what it should do and how it should
  interact with users.
- `"promptOverrideConfiguration"`: Contains configurations to override prompts in different
  parts of an agent sequence. For more information, see Advanced prompts.
- `"tags"`: Any tags that you want to attach to the agent.
"""
function create_agent(agentName; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "PUT",
        "/agents/",
        Dict{String,Any}("agentName" => agentName, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_agent(
    agentName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "agentName" => agentName, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_agent_action_group(action_group_name, agent_id, agent_version)
    create_agent_action_group(action_group_name, agent_id, agent_version, params::Dict{String,<:Any})

Creates an action group for an agent. An action group represents the actions that an agent
can carry out for the customer by defining the APIs that an agent can call and the logic
for calling them. To allow your agent to request the user for additional information when
trying to complete a task, add an action group with the parentActionGroupSignature field
set to AMAZON.UserInput. You must leave the description, apiSchema, and actionGroupExecutor
fields blank for this action group. During orchestration, if your agent determines that it
needs to invoke an API in an action group, but doesn't have enough information to complete
the API request, it will invoke this action group instead and return an Observation
reprompting the user for more information.

# Arguments
- `action_group_name`: The name to give the action group.
- `agent_id`: The unique identifier of the agent for which to create the action group.
- `agent_version`: The version of the agent for which to create the action group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionGroupExecutor"`: The Amazon Resource Name (ARN) of the Lambda function containing
  the business logic that is carried out upon invoking the action or the custom control
  method for handling the information elicited from the user.
- `"actionGroupState"`: Specifies whether the action group is available for the agent to
  invoke or not when sending an InvokeAgent request.
- `"apiSchema"`: Contains either details about the S3 object containing the OpenAPI schema
  for the action group or the JSON or YAML-formatted payload defining the schema. For more
  information, see Action group OpenAPI schemas.
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"description"`: A description of the action group.
- `"functionSchema"`: Contains details about the function schema for the action group or
  the JSON or YAML-formatted payload defining the schema.
- `"parentActionGroupSignature"`: To allow your agent to request the user for additional
  information when trying to complete a task, set this field to AMAZON.UserInput. You must
  leave the description, apiSchema, and actionGroupExecutor fields blank for this action
  group. During orchestration, if your agent determines that it needs to invoke an API in an
  action group, but doesn't have enough information to complete the API request, it will
  invoke this action group instead and return an Observation reprompting the user for more
  information.
"""
function create_agent_action_group(
    actionGroupName,
    agentId,
    agentVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/",
        Dict{String,Any}(
            "actionGroupName" => actionGroupName, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_agent_action_group(
    actionGroupName,
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "actionGroupName" => actionGroupName, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_agent_alias(agent_alias_name, agent_id)
    create_agent_alias(agent_alias_name, agent_id, params::Dict{String,<:Any})

Creates an alias of an agent that can be used to deploy the agent.

# Arguments
- `agent_alias_name`: The name of the alias.
- `agent_id`: The unique identifier of the agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"description"`: A description of the alias of the agent.
- `"routingConfiguration"`: Contains details about the routing configuration of the alias.
- `"tags"`: Any tags that you want to attach to the alias of the agent.
"""
function create_agent_alias(
    agentAliasName, agentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentaliases/",
        Dict{String,Any}(
            "agentAliasName" => agentAliasName, "clientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_agent_alias(
    agentAliasName,
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentaliases/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "agentAliasName" => agentAliasName, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_source(data_source_configuration, knowledge_base_id, name)
    create_data_source(data_source_configuration, knowledge_base_id, name, params::Dict{String,<:Any})

Sets up a data source to be added to a knowledge base.  You can't change the
chunkingConfiguration after you create the data source.

# Arguments
- `data_source_configuration`: Contains metadata about where the data source is stored.
- `knowledge_base_id`: The unique identifier of the knowledge base to which to add the data
  source.
- `name`: The name of the data source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"dataDeletionPolicy"`: The data deletion policy assigned to the data source.
- `"description"`: A description of the data source.
- `"serverSideEncryptionConfiguration"`: Contains details about the server-side encryption
  for the data source.
- `"vectorIngestionConfiguration"`: Contains details about how to ingest the documents in
  the data source.
"""
function create_data_source(
    dataSourceConfiguration,
    knowledgeBaseId,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/",
        Dict{String,Any}(
            "dataSourceConfiguration" => dataSourceConfiguration,
            "name" => name,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_source(
    dataSourceConfiguration,
    knowledgeBaseId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "dataSourceConfiguration" => dataSourceConfiguration,
                    "name" => name,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_knowledge_base(knowledge_base_configuration, name, role_arn, storage_configuration)
    create_knowledge_base(knowledge_base_configuration, name, role_arn, storage_configuration, params::Dict{String,<:Any})

Creates a knowledge base that contains data sources from which information can be queried
and used by LLMs. To create a knowledge base, you must first set up your data sources and
configure a supported vector store. For more information, see Set up your data for
ingestion.  If you prefer to let Amazon Bedrock create and manage a vector store for you in
Amazon OpenSearch Service, use the console. For more information, see Create a knowledge
base.    Provide the name and an optional description.   Provide the Amazon Resource Name
(ARN) with permissions to create a knowledge base in the roleArn field.   Provide the
embedding model to use in the embeddingModelArn field in the knowledgeBaseConfiguration
object.   Provide the configuration for your vector store in the storageConfiguration
object.   For an Amazon OpenSearch Service database, use the
opensearchServerlessConfiguration object. For more information, see Create a vector store
in Amazon OpenSearch Service.   For an Amazon Aurora database, use the RdsConfiguration
object. For more information, see Create a vector store in Amazon Aurora.   For a Pinecone
database, use the pineconeConfiguration object. For more information, see Create a vector
store in Pinecone.   For a Redis Enterprise Cloud database, use the
redisEnterpriseCloudConfiguration object. For more information, see Create a vector store
in Redis Enterprise Cloud.

# Arguments
- `knowledge_base_configuration`: Contains details about the embeddings model used for the
  knowledge base.
- `name`: A name for the knowledge base.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API
  operations on the knowledge base.
- `storage_configuration`: Contains details about the configuration of the vector database
  used for the knowledge base.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"description"`: A description of the knowledge base.
- `"tags"`: Specify the key-value pairs for the tags that you want to attach to your
  knowledge base in this object.
"""
function create_knowledge_base(
    knowledgeBaseConfiguration,
    name,
    roleArn,
    storageConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/",
        Dict{String,Any}(
            "knowledgeBaseConfiguration" => knowledgeBaseConfiguration,
            "name" => name,
            "roleArn" => roleArn,
            "storageConfiguration" => storageConfiguration,
            "clientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_knowledge_base(
    knowledgeBaseConfiguration,
    name,
    roleArn,
    storageConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "knowledgeBaseConfiguration" => knowledgeBaseConfiguration,
                    "name" => name,
                    "roleArn" => roleArn,
                    "storageConfiguration" => storageConfiguration,
                    "clientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_agent(agent_id)
    delete_agent(agent_id, params::Dict{String,<:Any})

Deletes an agent.

# Arguments
- `agent_id`: The unique identifier of the agent to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"skipResourceInUseCheck"`: By default, this value is false and deletion is stopped if
  the resource is in use. If you set it to true, the resource will be deleted even if the
  resource is in use.
"""
function delete_agent(agentId; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_agent(
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_agent_action_group(action_group_id, agent_id, agent_version)
    delete_agent_action_group(action_group_id, agent_id, agent_version, params::Dict{String,<:Any})

Deletes an action group in an agent.

# Arguments
- `action_group_id`: The unique identifier of the action group to delete.
- `agent_id`: The unique identifier of the agent that the action group belongs to.
- `agent_version`: The version of the agent that the action group belongs to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"skipResourceInUseCheck"`: By default, this value is false and deletion is stopped if
  the resource is in use. If you set it to true, the resource will be deleted even if the
  resource is in use.
"""
function delete_agent_action_group(
    actionGroupId, agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_agent_action_group(
    actionGroupId,
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_agent_alias(agent_alias_id, agent_id)
    delete_agent_alias(agent_alias_id, agent_id, params::Dict{String,<:Any})

Deletes an alias of an agent.

# Arguments
- `agent_alias_id`: The unique identifier of the alias to delete.
- `agent_id`: The unique identifier of the agent that the alias belongs to.

"""
function delete_agent_alias(
    agentAliasId, agentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_agent_alias(
    agentAliasId,
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_agent_version(agent_id, agent_version)
    delete_agent_version(agent_id, agent_version, params::Dict{String,<:Any})

Deletes a version of an agent.

# Arguments
- `agent_id`: The unique identifier of the agent that the version belongs to.
- `agent_version`: The version of the agent to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"skipResourceInUseCheck"`: By default, this value is false and deletion is stopped if
  the resource is in use. If you set it to true, the resource will be deleted even if the
  resource is in use.
"""
function delete_agent_version(
    agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_agent_version(
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_source(data_source_id, knowledge_base_id)
    delete_data_source(data_source_id, knowledge_base_id, params::Dict{String,<:Any})

Deletes a data source from a knowledge base.

# Arguments
- `data_source_id`: The unique identifier of the data source to delete.
- `knowledge_base_id`: The unique identifier of the knowledge base from which to delete the
  data source.

"""
function delete_data_source(
    dataSourceId, knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_source(
    dataSourceId,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_knowledge_base(knowledge_base_id)
    delete_knowledge_base(knowledge_base_id, params::Dict{String,<:Any})

Deletes a knowledge base. Before deleting a knowledge base, you should disassociate the
knowledge base from any agents that it is associated with by making a
DisassociateAgentKnowledgeBase request.

# Arguments
- `knowledge_base_id`: The unique identifier of the knowledge base to delete.

"""
function delete_knowledge_base(
    knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/knowledgebases/$(knowledgeBaseId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_knowledge_base(
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/knowledgebases/$(knowledgeBaseId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_agent_knowledge_base(agent_id, agent_version, knowledge_base_id)
    disassociate_agent_knowledge_base(agent_id, agent_version, knowledge_base_id, params::Dict{String,<:Any})

Disassociates a knowledge base from an agent.

# Arguments
- `agent_id`: The unique identifier of the agent from which to disassociate the knowledge
  base.
- `agent_version`: The version of the agent from which to disassociate the knowledge base.
- `knowledge_base_id`: The unique identifier of the knowledge base to disassociate.

"""
function disassociate_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agent(agent_id)
    get_agent(agent_id, params::Dict{String,<:Any})

Gets information about an agent.

# Arguments
- `agent_id`: The unique identifier of the agent.

"""
function get_agent(agentId; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "GET", "/agents/$(agentId)/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_agent(
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agent_action_group(action_group_id, agent_id, agent_version)
    get_agent_action_group(action_group_id, agent_id, agent_version, params::Dict{String,<:Any})

Gets information about an action group for an agent.

# Arguments
- `action_group_id`: The unique identifier of the action group for which to get information.
- `agent_id`: The unique identifier of the agent that the action group belongs to.
- `agent_version`: The version of the agent that the action group belongs to.

"""
function get_agent_action_group(
    actionGroupId, agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_agent_action_group(
    actionGroupId,
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agent_alias(agent_alias_id, agent_id)
    get_agent_alias(agent_alias_id, agent_id, params::Dict{String,<:Any})

Gets information about an alias of an agent.

# Arguments
- `agent_alias_id`: The unique identifier of the alias for which to get information.
- `agent_id`: The unique identifier of the agent to which the alias to get information
  belongs.

"""
function get_agent_alias(
    agentAliasId, agentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_agent_alias(
    agentAliasId,
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agent_knowledge_base(agent_id, agent_version, knowledge_base_id)
    get_agent_knowledge_base(agent_id, agent_version, knowledge_base_id, params::Dict{String,<:Any})

Gets information about a knowledge base associated with an agent.

# Arguments
- `agent_id`: The unique identifier of the agent with which the knowledge base is
  associated.
- `agent_version`: The version of the agent with which the knowledge base is associated.
- `knowledge_base_id`: The unique identifier of the knowledge base associated with the
  agent.

"""
function get_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_agent_version(agent_id, agent_version)
    get_agent_version(agent_id, agent_version, params::Dict{String,<:Any})

Gets details about a version of an agent.

# Arguments
- `agent_id`: The unique identifier of the agent.
- `agent_version`: The version of the agent.

"""
function get_agent_version(
    agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_agent_version(
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/agents/$(agentId)/agentversions/$(agentVersion)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_source(data_source_id, knowledge_base_id)
    get_data_source(data_source_id, knowledge_base_id, params::Dict{String,<:Any})

Gets information about a data source.

# Arguments
- `data_source_id`: The unique identifier of the data source.
- `knowledge_base_id`: The unique identifier of the knowledge base that the data source was
  added to.

"""
function get_data_source(
    dataSourceId, knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_source(
    dataSourceId,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ingestion_job(data_source_id, ingestion_job_id, knowledge_base_id)
    get_ingestion_job(data_source_id, ingestion_job_id, knowledge_base_id, params::Dict{String,<:Any})

Gets information about a ingestion job, in which a data source is added to a knowledge base.

# Arguments
- `data_source_id`: The unique identifier of the data source in the ingestion job.
- `ingestion_job_id`: The unique identifier of the ingestion job.
- `knowledge_base_id`: The unique identifier of the knowledge base for which the ingestion
  job applies.

"""
function get_ingestion_job(
    dataSourceId,
    ingestionJobId,
    knowledgeBaseId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/$(ingestionJobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ingestion_job(
    dataSourceId,
    ingestionJobId,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/$(ingestionJobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_knowledge_base(knowledge_base_id)
    get_knowledge_base(knowledge_base_id, params::Dict{String,<:Any})

Gets information about a knoweldge base.

# Arguments
- `knowledge_base_id`: The unique identifier of the knowledge base for which to get
  information.

"""
function get_knowledge_base(
    knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_knowledge_base(
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/knowledgebases/$(knowledgeBaseId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agent_action_groups(agent_id, agent_version)
    list_agent_action_groups(agent_id, agent_version, params::Dict{String,<:Any})

Lists the action groups for an agent and information about each one.

# Arguments
- `agent_id`: The unique identifier of the agent.
- `agent_version`: The version of the agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_agent_action_groups(
    agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_agent_action_groups(
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agent_aliases(agent_id)
    list_agent_aliases(agent_id, params::Dict{String,<:Any})

Lists the aliases of an agent and information about each one.

# Arguments
- `agent_id`: The unique identifier of the agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_agent_aliases(agentId; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentaliases/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_agent_aliases(
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentaliases/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agent_knowledge_bases(agent_id, agent_version)
    list_agent_knowledge_bases(agent_id, agent_version, params::Dict{String,<:Any})

Lists knowledge bases associated with an agent and information about each one.

# Arguments
- `agent_id`: The unique identifier of the agent for which to return information about
  knowledge bases associated with it.
- `agent_version`: The version of the agent for which to return information about knowledge
  bases associated with it.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_agent_knowledge_bases(
    agentId, agentVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_agent_knowledge_bases(
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agent_versions(agent_id)
    list_agent_versions(agent_id, params::Dict{String,<:Any})

Lists the versions of an agent and information about each version.

# Arguments
- `agent_id`: The unique identifier of the agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_agent_versions(agentId; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_agent_versions(
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/agentversions/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_agents()
    list_agents(params::Dict{String,<:Any})

Lists the agents belonging to an account and information about each agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_agents(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST", "/agents/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_agents(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST", "/agents/", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_data_sources(knowledge_base_id)
    list_data_sources(knowledge_base_id, params::Dict{String,<:Any})

Lists the data sources in a knowledge base and information about each one.

# Arguments
- `knowledge_base_id`: The unique identifier of the knowledge base for which to return a
  list of information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_data_sources(
    knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/datasources/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sources(
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/datasources/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_ingestion_jobs(data_source_id, knowledge_base_id)
    list_ingestion_jobs(data_source_id, knowledge_base_id, params::Dict{String,<:Any})

Lists the ingestion jobs for a data source and information about each of them.

# Arguments
- `data_source_id`: The unique identifier of the data source for which to return ingestion
  jobs.
- `knowledge_base_id`: The unique identifier of the knowledge base for which to return
  ingestion jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: Contains a definition of a filter for which to filter the results.
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
- `"sortBy"`: Contains details about how to sort the results.
"""
function list_ingestion_jobs(
    dataSourceId, knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_ingestion_jobs(
    dataSourceId,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_knowledge_bases()
    list_knowledge_bases(params::Dict{String,<:Any})

Lists the knowledge bases in an account and information about each of them.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return in the response. If the total
  number of results is greater than this value, use the token returned in the response in the
  nextToken field when making another request to return the next batch of results.
- `"nextToken"`: If the total number of results is greater than the maxResults value
  provided in the request, enter the token returned in the nextToken field in the response in
  this field to return the next batch of results.
"""
function list_knowledge_bases(; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST", "/knowledgebases/"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_knowledge_bases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "POST",
        "/knowledgebases/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List all the tags for the resource you specify.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which to list tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    prepare_agent(agent_id)
    prepare_agent(agent_id, params::Dict{String,<:Any})

Creates a DRAFT version of the agent that can be used for internal testing.

# Arguments
- `agent_id`: The unique identifier of the agent for which to create a DRAFT version.

"""
function prepare_agent(agentId; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function prepare_agent(
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/agents/$(agentId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_ingestion_job(data_source_id, knowledge_base_id)
    start_ingestion_job(data_source_id, knowledge_base_id, params::Dict{String,<:Any})

Begins an ingestion job, in which a data source is added to a knowledge base.

# Arguments
- `data_source_id`: The unique identifier of the data source to ingest.
- `knowledge_base_id`: The unique identifier of the knowledge base to which to add the data
  source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier to ensure that the API request
  completes no more than one time. If this token matches a previous request, Amazon Bedrock
  ignores the request, but does not return an error. For more information, see Ensuring
  idempotency.
- `"description"`: A description of the ingestion job.
"""
function start_ingestion_job(
    dataSourceId, knowledgeBaseId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_ingestion_job(
    dataSourceId,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)/ingestionjobs/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Associate tags with a resource. For more information, see Tagging resources in the Amazon
Bedrock User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource to tag.
- `tags`: An object containing key-value pairs that define the tags to attach to the
  resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return bedrock_agent(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Remove tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource from which to remove tags.
- `tag_keys`: A list of keys of the tags to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bedrock_agent(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_agent(agent_id, agent_name, agent_resource_role_arn, foundation_model)
    update_agent(agent_id, agent_name, agent_resource_role_arn, foundation_model, params::Dict{String,<:Any})

Updates the configuration of an agent.

# Arguments
- `agent_id`: The unique identifier of the agent.
- `agent_name`: Specifies a new name for the agent.
- `agent_resource_role_arn`: The Amazon Resource Name (ARN) of the IAM role with
  permissions to invoke API operations on the agent.
- `foundation_model`: Specifies a new foundation model to be used for orchestration by the
  agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customerEncryptionKeyArn"`: The Amazon Resource Name (ARN) of the KMS key with which to
  encrypt the agent.
- `"description"`: Specifies a new description of the agent.
- `"guardrailConfiguration"`: The unique Guardrail configuration assigned to the agent when
  it is updated.
- `"idleSessionTTLInSeconds"`: The number of seconds for which Amazon Bedrock keeps
  information about a user's conversation with the agent. A user interaction remains active
  for the amount of time specified. If no conversation occurs during this time, the session
  expires and Amazon Bedrock deletes any data provided before the timeout.
- `"instruction"`: Specifies new instructions that tell the agent what it should do and how
  it should interact with users.
- `"promptOverrideConfiguration"`: Contains configurations to override prompts in different
  parts of an agent sequence. For more information, see Advanced prompts.
"""
function update_agent(
    agentId,
    agentName,
    agentResourceRoleArn,
    foundationModel;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/",
        Dict{String,Any}(
            "agentName" => agentName,
            "agentResourceRoleArn" => agentResourceRoleArn,
            "foundationModel" => foundationModel,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_agent(
    agentId,
    agentName,
    agentResourceRoleArn,
    foundationModel,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "agentName" => agentName,
                    "agentResourceRoleArn" => agentResourceRoleArn,
                    "foundationModel" => foundationModel,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_agent_action_group(action_group_id, action_group_name, agent_id, agent_version)
    update_agent_action_group(action_group_id, action_group_name, agent_id, agent_version, params::Dict{String,<:Any})

Updates the configuration for an action group for an agent.

# Arguments
- `action_group_id`: The unique identifier of the action group.
- `action_group_name`: Specifies a new name for the action group.
- `agent_id`: The unique identifier of the agent for which to update the action group.
- `agent_version`: The unique identifier of the agent version for which to update the
  action group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"actionGroupExecutor"`: The Amazon Resource Name (ARN) of the Lambda function containing
  the business logic that is carried out upon invoking the action.
- `"actionGroupState"`: Specifies whether the action group is available for the agent to
  invoke or not when sending an InvokeAgent request.
- `"apiSchema"`: Contains either details about the S3 object containing the OpenAPI schema
  for the action group or the JSON or YAML-formatted payload defining the schema. For more
  information, see Action group OpenAPI schemas.
- `"description"`: Specifies a new name for the action group.
- `"functionSchema"`: Contains details about the function schema for the action group or
  the JSON or YAML-formatted payload defining the schema.
- `"parentActionGroupSignature"`: To allow your agent to request the user for additional
  information when trying to complete a task, set this field to AMAZON.UserInput. You must
  leave the description, apiSchema, and actionGroupExecutor fields blank for this action
  group. During orchestration, if your agent determines that it needs to invoke an API in an
  action group, but doesn't have enough information to complete the API request, it will
  invoke this action group instead and return an Observation reprompting the user for more
  information.
"""
function update_agent_action_group(
    actionGroupId,
    actionGroupName,
    agentId,
    agentVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/",
        Dict{String,Any}("actionGroupName" => actionGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_agent_action_group(
    actionGroupId,
    actionGroupName,
    agentId,
    agentVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/actiongroups/$(actionGroupId)/",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("actionGroupName" => actionGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_agent_alias(agent_alias_id, agent_alias_name, agent_id)
    update_agent_alias(agent_alias_id, agent_alias_name, agent_id, params::Dict{String,<:Any})

Updates configurations for an alias of an agent.

# Arguments
- `agent_alias_id`: The unique identifier of the alias.
- `agent_alias_name`: Specifies a new name for the alias.
- `agent_id`: The unique identifier of the agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Specifies a new description for the alias.
- `"routingConfiguration"`: Contains details about the routing configuration of the alias.
"""
function update_agent_alias(
    agentAliasId,
    agentAliasName,
    agentId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/",
        Dict{String,Any}("agentAliasName" => agentAliasName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_agent_alias(
    agentAliasId,
    agentAliasName,
    agentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentaliases/$(agentAliasId)/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("agentAliasName" => agentAliasName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_agent_knowledge_base(agent_id, agent_version, knowledge_base_id)
    update_agent_knowledge_base(agent_id, agent_version, knowledge_base_id, params::Dict{String,<:Any})

Updates the configuration for a knowledge base that has been associated with an agent.

# Arguments
- `agent_id`: The unique identifier of the agent associated with the knowledge base that
  you want to update.
- `agent_version`: The version of the agent associated with the knowledge base that you
  want to update.
- `knowledge_base_id`: The unique identifier of the knowledge base that has been associated
  with an agent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Specifies a new description for the knowledge base associated with an
  agent.
- `"knowledgeBaseState"`: Specifies whether the agent uses the knowledge base or not when
  sending an InvokeAgent request.
"""
function update_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_agent_knowledge_base(
    agentId,
    agentVersion,
    knowledgeBaseId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/agents/$(agentId)/agentversions/$(agentVersion)/knowledgebases/$(knowledgeBaseId)/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_source(data_source_configuration, data_source_id, knowledge_base_id, name)
    update_data_source(data_source_configuration, data_source_id, knowledge_base_id, name, params::Dict{String,<:Any})

Updates configurations for a data source.  You can't change the chunkingConfiguration after
you create the data source. Specify the existing chunkingConfiguration.

# Arguments
- `data_source_configuration`: Contains details about the storage configuration of the data
  source.
- `data_source_id`: The unique identifier of the data source.
- `knowledge_base_id`: The unique identifier of the knowledge base to which the data source
  belongs.
- `name`: Specifies a new name for the data source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dataDeletionPolicy"`: The data deletion policy of the updated data source.
- `"description"`: Specifies a new description for the data source.
- `"serverSideEncryptionConfiguration"`: Contains details about server-side encryption of
  the data source.
- `"vectorIngestionConfiguration"`: Contains details about how to ingest the documents in
  the data source.
"""
function update_data_source(
    dataSourceConfiguration,
    dataSourceId,
    knowledgeBaseId,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)",
        Dict{String,Any}(
            "dataSourceConfiguration" => dataSourceConfiguration, "name" => name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_source(
    dataSourceConfiguration,
    dataSourceId,
    knowledgeBaseId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)/datasources/$(dataSourceId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "dataSourceConfiguration" => dataSourceConfiguration, "name" => name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_knowledge_base(knowledge_base_configuration, knowledge_base_id, name, role_arn, storage_configuration)
    update_knowledge_base(knowledge_base_configuration, knowledge_base_id, name, role_arn, storage_configuration, params::Dict{String,<:Any})

Updates the configuration of a knowledge base with the fields that you specify. Because all
fields will be overwritten, you must include the same values for fields that you want to
keep the same. You can change the following fields:    name     description     roleArn
You can't change the knowledgeBaseConfiguration or storageConfiguration fields, so you must
specify the same configurations as when you created the knowledge base. You can send a
GetKnowledgeBase request and copy the same configurations.

# Arguments
- `knowledge_base_configuration`: Specifies the configuration for the embeddings model used
  for the knowledge base. You must use the same configuration as when the knowledge base was
  created.
- `knowledge_base_id`: The unique identifier of the knowledge base to update.
- `name`: Specifies a new name for the knowledge base.
- `role_arn`: Specifies a different Amazon Resource Name (ARN) of the IAM role with
  permissions to invoke API operations on the knowledge base.
- `storage_configuration`: Specifies the configuration for the vector store used for the
  knowledge base. You must use the same configuration as when the knowledge base was created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: Specifies a new description for the knowledge base.
"""
function update_knowledge_base(
    knowledgeBaseConfiguration,
    knowledgeBaseId,
    name,
    roleArn,
    storageConfiguration;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)",
        Dict{String,Any}(
            "knowledgeBaseConfiguration" => knowledgeBaseConfiguration,
            "name" => name,
            "roleArn" => roleArn,
            "storageConfiguration" => storageConfiguration,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_knowledge_base(
    knowledgeBaseConfiguration,
    knowledgeBaseId,
    name,
    roleArn,
    storageConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bedrock_agent(
        "PUT",
        "/knowledgebases/$(knowledgeBaseId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "knowledgeBaseConfiguration" => knowledgeBaseConfiguration,
                    "name" => name,
                    "roleArn" => roleArn,
                    "storageConfiguration" => storageConfiguration,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
