# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: chime
using AWS.Compat
using AWS.UUIDs

"""
    associate_phone_number_with_user(e164_phone_number, account_id, user_id)
    associate_phone_number_with_user(e164_phone_number, account_id, user_id, params::Dict{String,<:Any})

Associates a phone number with the specified Amazon Chime user.

# Arguments
- `e164_phone_number`: The phone number, in E.164 format.
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function associate_phone_number_with_user(
    E164PhoneNumber, accountId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=associate-phone-number",
        Dict{String,Any}("E164PhoneNumber" => E164PhoneNumber);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_phone_number_with_user(
    E164PhoneNumber,
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=associate-phone-number",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumber" => E164PhoneNumber), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_phone_numbers_with_voice_connector(e164_phone_numbers, voice_connector_id)
    associate_phone_numbers_with_voice_connector(e164_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Associates phone numbers with the specified Amazon Chime Voice Connector.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
AssociatePhoneNumbersWithVoiceConnector, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceAssociate"`: If true, associates the provided phone numbers with the provided
  Amazon Chime Voice Connector and removes any previously existing associations. If false,
  does not associate any phone numbers that have previously existing associations.
"""
function associate_phone_numbers_with_voice_connector(
    E164PhoneNumbers, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=associate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_phone_numbers_with_voice_connector(
    E164PhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=associate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_phone_numbers_with_voice_connector_group(e164_phone_numbers, voice_connector_group_id)
    associate_phone_numbers_with_voice_connector_group(e164_phone_numbers, voice_connector_group_id, params::Dict{String,<:Any})

Associates phone numbers with the specified Amazon Chime Voice Connector group.   This API
is is no longer supported and will not be updated. We recommend using the latest version,
AssociatePhoneNumbersWithVoiceConnectorGroup, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_group_id`: The Amazon Chime Voice Connector group ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceAssociate"`: If true, associates the provided phone numbers with the provided
  Amazon Chime Voice Connector Group and removes any previously existing associations. If
  false, does not associate any phone numbers that have previously existing associations.
"""
function associate_phone_numbers_with_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=associate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_phone_numbers_with_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=associate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_signin_delegate_groups_with_account(signin_delegate_groups, account_id)
    associate_signin_delegate_groups_with_account(signin_delegate_groups, account_id, params::Dict{String,<:Any})

Associates the specified sign-in delegate groups with the specified Amazon Chime account.

# Arguments
- `signin_delegate_groups`: The sign-in delegate groups.
- `account_id`: The Amazon Chime account ID.

"""
function associate_signin_delegate_groups_with_account(
    SigninDelegateGroups, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)?operation=associate-signin-delegate-groups",
        Dict{String,Any}("SigninDelegateGroups" => SigninDelegateGroups);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_signin_delegate_groups_with_account(
    SigninDelegateGroups,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)?operation=associate-signin-delegate-groups",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SigninDelegateGroups" => SigninDelegateGroups),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_create_attendee(attendees, meeting_id)
    batch_create_attendee(attendees, meeting_id, params::Dict{String,<:Any})

Creates up to 100 new attendees for an active Amazon Chime SDK meeting.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
BatchCreateAttendee, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.  For more information about the Amazon
Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime SDK Developer Guide.

# Arguments
- `attendees`: The request containing the attendees to create.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function batch_create_attendee(
    Attendees, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees?operation=batch-create",
        Dict{String,Any}("Attendees" => Attendees);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_create_attendee(
    Attendees,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees?operation=batch-create",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Attendees" => Attendees), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_create_channel_membership(member_arns, channel_arn)
    batch_create_channel_membership(member_arns, channel_arn, params::Dict{String,<:Any})

Adds a specified number of users to a channel.   This API is is no longer supported and
will not be updated. We recommend using the latest version, BatchCreateChannelMembership,
in the Amazon Chime SDK. Using the latest version requires migrating to a dedicated
namespace. For more information, refer to Migrating from the Amazon Chime namespace in the
Amazon Chime SDK Developer Guide.

# Arguments
- `member_arns`: The ARNs of the members you want to add to the channel.
- `channel_arn`: The ARN of the channel to which you're adding users.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Type"`: The membership type of a user, DEFAULT or HIDDEN. Default members are always
  returned as part of ListChannelMemberships. Hidden members are only returned if the type
  filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned.
  This is only supported by moderators.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function batch_create_channel_membership(
    MemberArns, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/channels/$(channelArn)/memberships?operation=batch-create",
        Dict{String,Any}("MemberArns" => MemberArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_create_channel_membership(
    MemberArns,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/memberships?operation=batch-create",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MemberArns" => MemberArns), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_create_room_membership(membership_item_list, account_id, room_id)
    batch_create_room_membership(membership_item_list, account_id, room_id, params::Dict{String,<:Any})

Adds up to 50 members to a chat room in an Amazon Chime Enterprise account. Members can be
users or bots. The member role designates whether the member is a chat room administrator
or a general chat room member.

# Arguments
- `membership_item_list`: The list of membership items.
- `account_id`: The Amazon Chime account ID.
- `room_id`: The room ID.

"""
function batch_create_room_membership(
    MembershipItemList,
    accountId,
    roomId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships?operation=batch-create",
        Dict{String,Any}("MembershipItemList" => MembershipItemList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_create_room_membership(
    MembershipItemList,
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships?operation=batch-create",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("MembershipItemList" => MembershipItemList), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_phone_number(phone_number_ids)
    batch_delete_phone_number(phone_number_ids, params::Dict{String,<:Any})

 Moves phone numbers into the Deletion queue. Phone numbers must be disassociated from any
users or Amazon Chime Voice Connectors before they can be deleted.   Phone numbers remain
in the Deletion queue for 7 days before they are deleted permanently.

# Arguments
- `phone_number_ids`: List of phone number IDs.

"""
function batch_delete_phone_number(
    PhoneNumberIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/phone-numbers?operation=batch-delete",
        Dict{String,Any}("PhoneNumberIds" => PhoneNumberIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_phone_number(
    PhoneNumberIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/phone-numbers?operation=batch-delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PhoneNumberIds" => PhoneNumberIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_suspend_user(user_id_list, account_id)
    batch_suspend_user(user_id_list, account_id, params::Dict{String,<:Any})

Suspends up to 50 users from a Team or EnterpriseLWA Amazon Chime account. For more
information about different account types, see Managing Your Amazon Chime Accounts in the
Amazon Chime Administration Guide. Users suspended from a Team account are disassociated
from the account,but they can continue to use Amazon Chime as free users. To remove the
suspension from suspended Team account users, invite them to the Team account again. You
can use the InviteUsers action to do so. Users suspended from an EnterpriseLWA account are
immediately signed out of Amazon Chime and can no longer sign in. To remove the suspension
from suspended EnterpriseLWA account users, use the BatchUnsuspendUser action.  To sign out
users without suspending them, use the LogoutUser action.

# Arguments
- `user_id_list`: The request containing the user IDs to suspend.
- `account_id`: The Amazon Chime account ID.

"""
function batch_suspend_user(
    UserIdList, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=suspend",
        Dict{String,Any}("UserIdList" => UserIdList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_suspend_user(
    UserIdList,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=suspend",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserIdList" => UserIdList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_unsuspend_user(user_id_list, account_id)
    batch_unsuspend_user(user_id_list, account_id, params::Dict{String,<:Any})

Removes the suspension from up to 50 previously suspended users for the specified Amazon
Chime EnterpriseLWA account. Only users on EnterpriseLWA accounts can be unsuspended using
this action. For more information about different account types, see  Managing Your Amazon
Chime Accounts  in the account types, in the Amazon Chime Administration Guide.  Previously
suspended users who are unsuspended using this action are returned to Registered status.
Users who are not previously suspended are ignored.

# Arguments
- `user_id_list`: The request containing the user IDs to unsuspend.
- `account_id`: The Amazon Chime account ID.

"""
function batch_unsuspend_user(
    UserIdList, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=unsuspend",
        Dict{String,Any}("UserIdList" => UserIdList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_unsuspend_user(
    UserIdList,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=unsuspend",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserIdList" => UserIdList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_phone_number(update_phone_number_request_items)
    batch_update_phone_number(update_phone_number_request_items, params::Dict{String,<:Any})

Updates phone number product types or calling names. You can update one attribute at a time
for each UpdatePhoneNumberRequestItem. For example, you can update the product type or the
calling name. For toll-free numbers, you cannot use the Amazon Chime Business Calling
product type. For numbers outside the U.S., you must use the Amazon Chime SIP Media
Application Dial-In product type. Updates to outbound calling names can take up to 72 hours
to complete. Pending updates to outbound calling names must be complete before you can
request another update.

# Arguments
- `update_phone_number_request_items`: The request containing the phone number IDs and
  product types or calling names to update.

"""
function batch_update_phone_number(
    UpdatePhoneNumberRequestItems; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/phone-numbers?operation=batch-update",
        Dict{String,Any}("UpdatePhoneNumberRequestItems" => UpdatePhoneNumberRequestItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_phone_number(
    UpdatePhoneNumberRequestItems,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/phone-numbers?operation=batch-update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "UpdatePhoneNumberRequestItems" => UpdatePhoneNumberRequestItems
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_update_user(update_user_request_items, account_id)
    batch_update_user(update_user_request_items, account_id, params::Dict{String,<:Any})

Updates user details within the UpdateUserRequestItem object for up to 20 users for the
specified Amazon Chime account. Currently, only LicenseType updates are supported for this
action.

# Arguments
- `update_user_request_items`: The request containing the user IDs and details to update.
- `account_id`: The Amazon Chime account ID.

"""
function batch_update_user(
    UpdateUserRequestItems, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users",
        Dict{String,Any}("UpdateUserRequestItems" => UpdateUserRequestItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_update_user(
    UpdateUserRequestItems,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("UpdateUserRequestItems" => UpdateUserRequestItems),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_account(name)
    create_account(name, params::Dict{String,<:Any})

Creates an Amazon Chime account under the administrator's AWS account. Only Team account
types are currently supported for this action. For more information about different account
types, see Managing Your Amazon Chime Accounts in the Amazon Chime Administration Guide.

# Arguments
- `name`: The name of the Amazon Chime account.

"""
function create_account(Name; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_account(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_instance(client_request_token, name)
    create_app_instance(client_request_token, name, params::Dict{String,<:Any})

Creates an Amazon Chime SDK messaging AppInstance under an AWS account. Only SDK messaging
customers use this API. CreateAppInstance supports idempotency behavior as described in the
AWS API Standard.   This API is is no longer supported and will not be updated. We
recommend using the latest version, CreateAppInstance, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `client_request_token`: The ClientRequestToken of the AppInstance.
- `name`: The name of the AppInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The metadata of the AppInstance. Limited to a 1KB string in UTF-8.
- `"Tags"`: Tags assigned to the AppInstance.
"""
function create_app_instance(
    ClientRequestToken, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/app-instances",
        Dict{String,Any}("ClientRequestToken" => ClientRequestToken, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_instance(
    ClientRequestToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/app-instances",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientRequestToken" => ClientRequestToken, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_instance_admin(app_instance_admin_arn, app_instance_arn)
    create_app_instance_admin(app_instance_admin_arn, app_instance_arn, params::Dict{String,<:Any})

Promotes an AppInstanceUser to an AppInstanceAdmin. The promoted user can perform the
following actions.    This API is is no longer supported and will not be updated. We
recommend using the latest version, CreateAppInstanceAdmin, in the Amazon Chime SDK. Using
the latest version requires migrating to a dedicated namespace. For more information, refer
to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.
ChannelModerator actions across all channels in the AppInstance.    DeleteChannelMessage
actions.   Only an AppInstanceUser can be promoted to an AppInstanceAdmin role.

# Arguments
- `app_instance_admin_arn`: The ARN of the administrator of the current AppInstance.
- `app_instance_arn`: The ARN of the AppInstance.

"""
function create_app_instance_admin(
    AppInstanceAdminArn, appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/app-instances/$(appInstanceArn)/admins",
        Dict{String,Any}("AppInstanceAdminArn" => AppInstanceAdminArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_instance_admin(
    AppInstanceAdminArn,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/app-instances/$(appInstanceArn)/admins",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("AppInstanceAdminArn" => AppInstanceAdminArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_app_instance_user(app_instance_arn, app_instance_user_id, client_request_token, name)
    create_app_instance_user(app_instance_arn, app_instance_user_id, client_request_token, name, params::Dict{String,<:Any})

Creates a user under an Amazon Chime AppInstance. The request consists of a unique
appInstanceUserId and Name for that user.   This API is is no longer supported and will not
be updated. We recommend using the latest version, CreateAppInstanceUser, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance request.
- `app_instance_user_id`: The user ID of the AppInstance.
- `client_request_token`: The token assigned to the user requesting an AppInstance.
- `name`: The user's name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The request's metadata. Limited to a 1KB string in UTF-8.
- `"Tags"`: Tags assigned to the AppInstanceUser.
"""
function create_app_instance_user(
    AppInstanceArn,
    AppInstanceUserId,
    ClientRequestToken,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/app-instance-users",
        Dict{String,Any}(
            "AppInstanceArn" => AppInstanceArn,
            "AppInstanceUserId" => AppInstanceUserId,
            "ClientRequestToken" => ClientRequestToken,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_app_instance_user(
    AppInstanceArn,
    AppInstanceUserId,
    ClientRequestToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/app-instance-users",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppInstanceArn" => AppInstanceArn,
                    "AppInstanceUserId" => AppInstanceUserId,
                    "ClientRequestToken" => ClientRequestToken,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_attendee(external_user_id, meeting_id)
    create_attendee(external_user_id, meeting_id, params::Dict{String,<:Any})

 Creates a new attendee for an active Amazon Chime SDK meeting. For more information about
the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime SDK Developer
Guide.    This API is is no longer supported and will not be updated. We recommend using
the latest version, CreateAttendee, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `external_user_id`: The Amazon Chime SDK external user ID. An idempotency token. Links
  the attendee to an identity managed by a builder application.
- `meeting_id`: The Amazon Chime SDK meeting ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tag key-value pairs.
"""
function create_attendee(
    ExternalUserId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees",
        Dict{String,Any}("ExternalUserId" => ExternalUserId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_attendee(
    ExternalUserId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExternalUserId" => ExternalUserId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_bot(display_name, account_id)
    create_bot(display_name, account_id, params::Dict{String,<:Any})

Creates a bot for an Amazon Chime Enterprise account.

# Arguments
- `display_name`: The bot display name.
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Domain"`: The domain of the Amazon Chime Enterprise account.
"""
function create_bot(
    DisplayName, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/bots",
        Dict{String,Any}("DisplayName" => DisplayName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_bot(
    DisplayName,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/bots",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DisplayName" => DisplayName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_channel(app_instance_arn, client_request_token, name)
    create_channel(app_instance_arn, client_request_token, name, params::Dict{String,<:Any})

Creates a channel to which you can add users and send messages.  Restriction: You can't
change a channel's privacy.  The x-amz-chime-bearer request header is mandatory. Use the
AppInstanceUserArn of the user that makes the API call as the value in the header.    This
API is is no longer supported and will not be updated. We recommend using the latest
version, CreateChannel, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the channel request.
- `client_request_token`: The client token for the request. An Idempotency token.
- `name`: The name of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The metadata of the creation request. Limited to 1KB and UTF-8.
- `"Mode"`: The channel mode: UNRESTRICTED or RESTRICTED. Administrators, moderators, and
  channel members can add themselves and other members to unrestricted channels. Only
  administrators and moderators can add members to restricted channels.
- `"Privacy"`: The channel's privacy level: PUBLIC or PRIVATE. Private channels aren't
  discoverable by users outside the channel. Public channels are discoverable by anyone in
  the AppInstance.
- `"Tags"`: The tags for the creation request.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function create_channel(
    AppInstanceArn,
    ClientRequestToken,
    Name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels",
        Dict{String,Any}(
            "AppInstanceArn" => AppInstanceArn,
            "ClientRequestToken" => ClientRequestToken,
            "Name" => Name,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel(
    AppInstanceArn,
    ClientRequestToken,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppInstanceArn" => AppInstanceArn,
                    "ClientRequestToken" => ClientRequestToken,
                    "Name" => Name,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_channel_ban(member_arn, channel_arn)
    create_channel_ban(member_arn, channel_arn, params::Dict{String,<:Any})

Permanently bans a member from a channel. Moderators can't add banned members to a channel.
To undo a ban, you first have to DeleteChannelBan, and then CreateChannelMembership. Bans
are cleaned up when you delete users or channels. If you ban a user who is already part of
a channel, that user is automatically kicked from the channel.  The x-amz-chime-bearer
request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call
as the value in the header.    This API is is no longer supported and will not be updated.
We recommend using the latest version, CreateChannelBan, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `member_arn`: The ARN of the member being banned.
- `channel_arn`: The ARN of the ban request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function create_channel_ban(
    MemberArn, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/channels/$(channelArn)/bans",
        Dict{String,Any}("MemberArn" => MemberArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel_ban(
    MemberArn,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/bans",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MemberArn" => MemberArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_channel_membership(member_arn, type, channel_arn)
    create_channel_membership(member_arn, type, channel_arn, params::Dict{String,<:Any})

Adds a user to a channel. The InvitedBy response field is derived from the request header.
A channel member can:   List messages   Send messages   Receive messages   Edit their own
messages   Leave the channel   Privacy settings impact this action as follows:   Public
Channels: You do not need to be a member to list messages, but you must be a member to send
messages.   Private Channels: You must be a member to list or send messages.    The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version, CreateChannelMembership, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Arguments
- `member_arn`: The ARN of the member you want to add to the channel.
- `type`: The membership type of a user, DEFAULT or HIDDEN. Default members are always
  returned as part of ListChannelMemberships. Hidden members are only returned if the type
  filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned.
  This is only supported by moderators.
- `channel_arn`: The ARN of the channel to which you're adding users.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function create_channel_membership(
    MemberArn, Type, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/channels/$(channelArn)/memberships",
        Dict{String,Any}("MemberArn" => MemberArn, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel_membership(
    MemberArn,
    Type,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/memberships",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("MemberArn" => MemberArn, "Type" => Type), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_channel_moderator(channel_moderator_arn, channel_arn)
    create_channel_moderator(channel_moderator_arn, channel_arn, params::Dict{String,<:Any})

Creates a new ChannelModerator. A channel moderator can:   Add and remove other members of
the channel.   Add and remove other moderators of the channel.   Add and remove user bans
for the channel.   Redact messages in the channel.   List messages in the channel.    The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version, CreateChannelModerator, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Arguments
- `channel_moderator_arn`: The ARN of the moderator.
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function create_channel_moderator(
    ChannelModeratorArn, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/channels/$(channelArn)/moderators",
        Dict{String,Any}("ChannelModeratorArn" => ChannelModeratorArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_channel_moderator(
    ChannelModeratorArn,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/moderators",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ChannelModeratorArn" => ChannelModeratorArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_media_capture_pipeline(sink_arn, sink_type, source_arn, source_type)
    create_media_capture_pipeline(sink_arn, sink_type, source_arn, source_type, params::Dict{String,<:Any})

Creates a media capture pipeline.   This API is is no longer supported and will not be
updated. We recommend using the latest version, CreateMediaCapturePipeline, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `sink_arn`: The ARN of the sink type.
- `sink_type`: Destination type to which the media artifacts are saved. You must use an S3
  bucket.
- `source_arn`: ARN of the source from which the media artifacts are captured.
- `source_type`: Source type from which the media artifacts will be captured. A Chime SDK
  Meeting is the only supported source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ChimeSdkMeetingConfiguration"`: The configuration for a specified media capture
  pipeline. SourceType must be ChimeSdkMeeting.
- `"ClientRequestToken"`: The unique identifier for the client request. The token makes the
  API request idempotent. Use a different token for different media pipeline requests.
"""
function create_media_capture_pipeline(
    SinkArn,
    SinkType,
    SourceArn,
    SourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/media-capture-pipelines",
        Dict{String,Any}(
            "SinkArn" => SinkArn,
            "SinkType" => SinkType,
            "SourceArn" => SourceArn,
            "SourceType" => SourceType,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_media_capture_pipeline(
    SinkArn,
    SinkType,
    SourceArn,
    SourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/media-capture-pipelines",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SinkArn" => SinkArn,
                    "SinkType" => SinkType,
                    "SourceArn" => SourceArn,
                    "SourceType" => SourceType,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_meeting(client_request_token)
    create_meeting(client_request_token, params::Dict{String,<:Any})

Creates a new Amazon Chime SDK meeting in the specified media Region with no initial
attendees. For more information about specifying media Regions, see Amazon Chime SDK Media
Regions in the Amazon Chime SDK Developer Guide . For more information about the Amazon
Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime SDK Developer Guide.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, CreateMeeting, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `client_request_token`: The unique identifier for the client request. Use a different
  token for different meetings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExternalMeetingId"`: The external meeting ID.
- `"MediaRegion"`:  The Region in which to create the meeting. Default: us-east-1.
  Available values: af-south-1 , ap-northeast-1 , ap-northeast-2 , ap-south-1 ,
  ap-southeast-1 , ap-southeast-2 , ca-central-1 , eu-central-1 , eu-north-1 , eu-south-1 ,
  eu-west-1 , eu-west-2 , eu-west-3 , sa-east-1 , us-east-1 , us-east-2 , us-west-1 ,
  us-west-2 .
- `"MeetingHostId"`: Reserved.
- `"NotificationsConfiguration"`: The configuration for resource targets to receive
  notifications when meeting and attendee events occur.
- `"Tags"`: The tag key-value pairs.
"""
function create_meeting(
    ClientRequestToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings",
        Dict{String,Any}("ClientRequestToken" => ClientRequestToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_meeting(
    ClientRequestToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClientRequestToken" => ClientRequestToken), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_meeting_dial_out(from_phone_number, join_token, to_phone_number, meeting_id)
    create_meeting_dial_out(from_phone_number, join_token, to_phone_number, meeting_id, params::Dict{String,<:Any})

Uses the join token and call metadata in a meeting request (From number, To number, and so
forth) to initiate an outbound call to a public switched telephone network (PSTN) and join
them into a Chime meeting. Also ensures that the From number belongs to the customer. To
play welcome audio or implement an interactive voice response (IVR), use the
CreateSipMediaApplicationCall action with the corresponding SIP media application ID.
This API is is not available in a dedicated namespace.

# Arguments
- `from_phone_number`: Phone number used as the caller ID when the remote party receives a
  call.
- `join_token`: Token used by the Amazon Chime SDK attendee. Call the CreateAttendee action
  to get a join token.
- `to_phone_number`: Phone number called when inviting someone to a meeting.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function create_meeting_dial_out(
    FromPhoneNumber,
    JoinToken,
    ToPhoneNumber,
    meetingId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/dial-outs",
        Dict{String,Any}(
            "FromPhoneNumber" => FromPhoneNumber,
            "JoinToken" => JoinToken,
            "ToPhoneNumber" => ToPhoneNumber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_meeting_dial_out(
    FromPhoneNumber,
    JoinToken,
    ToPhoneNumber,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/dial-outs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FromPhoneNumber" => FromPhoneNumber,
                    "JoinToken" => JoinToken,
                    "ToPhoneNumber" => ToPhoneNumber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_meeting_with_attendees(client_request_token)
    create_meeting_with_attendees(client_request_token, params::Dict{String,<:Any})

 Creates a new Amazon Chime SDK meeting in the specified media Region, with attendees. For
more information about specifying media Regions, see Amazon Chime SDK Media Regions in the
Amazon Chime SDK Developer Guide . For more information about the Amazon Chime SDK, see
Using the Amazon Chime SDK in the Amazon Chime SDK Developer Guide .    This API is is no
longer supported and will not be updated. We recommend using the latest version,
CreateMeetingWithAttendees, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `client_request_token`: The unique identifier for the client request. Use a different
  token for different meetings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Attendees"`: The request containing the attendees to create.
- `"ExternalMeetingId"`: The external meeting ID.
- `"MediaRegion"`:  The Region in which to create the meeting. Default: us-east-1 .
  Available values: af-south-1 , ap-northeast-1 , ap-northeast-2 , ap-south-1 ,
  ap-southeast-1 , ap-southeast-2 , ca-central-1 , eu-central-1 , eu-north-1 , eu-south-1 ,
  eu-west-1 , eu-west-2 , eu-west-3 , sa-east-1 , us-east-1 , us-east-2 , us-west-1 ,
  us-west-2 .
- `"MeetingHostId"`: Reserved.
- `"NotificationsConfiguration"`: The resource target configurations for receiving Amazon
  Chime SDK meeting and attendee event notifications. The Amazon Chime SDK supports resource
  targets located in the US East (N. Virginia) AWS Region (us-east-1).
- `"Tags"`: The tag key-value pairs.
"""
function create_meeting_with_attendees(
    ClientRequestToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings?operation=create-attendees",
        Dict{String,Any}("ClientRequestToken" => ClientRequestToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_meeting_with_attendees(
    ClientRequestToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings?operation=create-attendees",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ClientRequestToken" => ClientRequestToken), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_phone_number_order(e164_phone_numbers, product_type)
    create_phone_number_order(e164_phone_numbers, product_type, params::Dict{String,<:Any})

Creates an order for phone numbers to be provisioned. For toll-free numbers, you cannot use
the Amazon Chime Business Calling product type. For numbers outside the U.S., you must use
the Amazon Chime SIP Media Application Dial-In product type.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `product_type`: The phone number product type.

"""
function create_phone_number_order(
    E164PhoneNumbers, ProductType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/phone-number-orders",
        Dict{String,Any}(
            "E164PhoneNumbers" => E164PhoneNumbers, "ProductType" => ProductType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_phone_number_order(
    E164PhoneNumbers,
    ProductType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/phone-number-orders",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "E164PhoneNumbers" => E164PhoneNumbers, "ProductType" => ProductType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_proxy_session(capabilities, participant_phone_numbers, voice_connector_id)
    create_proxy_session(capabilities, participant_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Creates a proxy session on the specified Amazon Chime Voice Connector for the specified
participant phone numbers.   This API is is no longer supported and will not be updated. We
recommend using the latest version, CreateProxySession, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `capabilities`: The proxy session capabilities.
- `participant_phone_numbers`: The participant phone numbers.
- `voice_connector_id`: The Amazon Chime voice connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpiryMinutes"`: The number of minutes allowed for the proxy session.
- `"GeoMatchLevel"`: The preference for matching the country or area code of the proxy
  phone number with that of the first participant.
- `"GeoMatchParams"`: The country and area code for the proxy phone number.
- `"Name"`: The name of the proxy session.
- `"NumberSelectionBehavior"`: The preference for proxy phone number reuse, or stickiness,
  between the same participants across sessions.
"""
function create_proxy_session(
    Capabilities,
    ParticipantPhoneNumbers,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        Dict{String,Any}(
            "Capabilities" => Capabilities,
            "ParticipantPhoneNumbers" => ParticipantPhoneNumbers,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_proxy_session(
    Capabilities,
    ParticipantPhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Capabilities" => Capabilities,
                    "ParticipantPhoneNumbers" => ParticipantPhoneNumbers,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_room(name, account_id)
    create_room(name, account_id, params::Dict{String,<:Any})

Creates a chat room for the specified Amazon Chime Enterprise account.

# Arguments
- `name`: The room name.
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: The idempotency token for the request.
"""
function create_room(Name, accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms",
        Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_room(
    Name,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "ClientRequestToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_room_membership(member_id, account_id, room_id)
    create_room_membership(member_id, account_id, room_id, params::Dict{String,<:Any})

Adds a member to a chat room in an Amazon Chime Enterprise account. A member can be either
a user or a bot. The member role designates whether the member is a chat room administrator
or a general chat room member.

# Arguments
- `member_id`: The Amazon Chime member ID (user ID or bot ID).
- `account_id`: The Amazon Chime account ID.
- `room_id`: The room ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Role"`: The role of the member.
"""
function create_room_membership(
    MemberId, accountId, roomId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships",
        Dict{String,Any}("MemberId" => MemberId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_room_membership(
    MemberId,
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MemberId" => MemberId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_media_application(aws_region, endpoints, name)
    create_sip_media_application(aws_region, endpoints, name, params::Dict{String,<:Any})

Creates a SIP media application.   This API is is no longer supported and will not be
updated. We recommend using the latest version, CreateSipMediaApplication, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `aws_region`: The AWS Region assigned to the SIP media application.
- `endpoints`: List of endpoints (Lambda Amazon Resource Names) specified for the SIP media
  application. Currently, only one endpoint is supported.
- `name`: The SIP media application name.

"""
function create_sip_media_application(
    AwsRegion, Endpoints, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/sip-media-applications",
        Dict{String,Any}(
            "AwsRegion" => AwsRegion, "Endpoints" => Endpoints, "Name" => Name
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_media_application(
    AwsRegion,
    Endpoints,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-media-applications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AwsRegion" => AwsRegion, "Endpoints" => Endpoints, "Name" => Name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_media_application_call(from_phone_number, to_phone_number, sip_media_application_id)
    create_sip_media_application_call(from_phone_number, to_phone_number, sip_media_application_id, params::Dict{String,<:Any})

Creates an outbound call to a phone number from the phone number specified in the request,
and it invokes the endpoint of the specified sipMediaApplicationId.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
CreateSipMediaApplicationCall, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `from_phone_number`: The phone number that a user calls from. This is a phone number in
  your Amazon Chime phone number inventory.
- `to_phone_number`: The phone number that the service should call.
- `sip_media_application_id`: The ID of the SIP media application.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SipHeaders"`: The SIP headers added to an outbound call leg.
"""
function create_sip_media_application_call(
    FromPhoneNumber,
    ToPhoneNumber,
    sipMediaApplicationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls",
        Dict{String,Any}(
            "FromPhoneNumber" => FromPhoneNumber, "ToPhoneNumber" => ToPhoneNumber
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_media_application_call(
    FromPhoneNumber,
    ToPhoneNumber,
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FromPhoneNumber" => FromPhoneNumber, "ToPhoneNumber" => ToPhoneNumber
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sip_rule(name, target_applications, trigger_type, trigger_value)
    create_sip_rule(name, target_applications, trigger_type, trigger_value, params::Dict{String,<:Any})

Creates a SIP rule which can be used to run a SIP media application as a target for a
specific trigger type.   This API is is no longer supported and will not be updated. We
recommend using the latest version, CreateSipRule, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name of the SIP rule.
- `target_applications`: List of SIP media applications with priority and AWS Region. Only
  one SIP application per AWS Region can be used.
- `trigger_type`: The type of trigger assigned to the SIP rule in TriggerValue, currently
  RequestUriHostname or ToPhoneNumber.
- `trigger_value`: If TriggerType is RequestUriHostname, the value can be the outbound host
  name of an Amazon Chime Voice Connector. If TriggerType is ToPhoneNumber, the value can be
  a customer-owned phone number in the E164 format. The SipMediaApplication specified in the
  SipRule is triggered if the request URI in an incoming SIP request matches the
  RequestUriHostname, or if the To header in the incoming SIP request matches the
  ToPhoneNumber value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: Enables or disables a rule. You must disable rules before you can delete
  them.
"""
function create_sip_rule(
    Name,
    TargetApplications,
    TriggerType,
    TriggerValue;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-rules",
        Dict{String,Any}(
            "Name" => Name,
            "TargetApplications" => TargetApplications,
            "TriggerType" => TriggerType,
            "TriggerValue" => TriggerValue,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sip_rule(
    Name,
    TargetApplications,
    TriggerType,
    TriggerValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-rules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "TargetApplications" => TargetApplications,
                    "TriggerType" => TriggerType,
                    "TriggerValue" => TriggerValue,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_user(account_id)
    create_user(account_id, params::Dict{String,<:Any})

Creates a user under the specified Amazon Chime account.

# Arguments
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Email"`: The user's email address.
- `"UserType"`: The user type.
- `"Username"`: The user name.
"""
function create_user(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=create";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_user(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=create",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_connector(name, require_encryption)
    create_voice_connector(name, require_encryption, params::Dict{String,<:Any})

Creates an Amazon Chime Voice Connector under the administrator's AWS account. You can
choose to create an Amazon Chime Voice Connector in a specific AWS Region. Enabling
CreateVoiceConnectorRequestRequireEncryption configures your Amazon Chime Voice Connector
to use TLS transport for SIP signaling and Secure RTP (SRTP) for media. Inbound calls use
TLS transport, and unencrypted outbound calls are blocked.    This API is is no longer
supported and will not be updated. We recommend using the latest version,
CreateVoiceConnector, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name of the Amazon Chime Voice Connector.
- `require_encryption`: When enabled, requires encryption for the Amazon Chime Voice
  Connector.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AwsRegion"`:  The AWS Region in which the Amazon Chime Voice Connector is created.
  Default value: us-east-1 .
"""
function create_voice_connector(
    Name, RequireEncryption; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connectors",
        Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_connector(
    Name,
    RequireEncryption,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_voice_connector_group(name)
    create_voice_connector_group(name, params::Dict{String,<:Any})

Creates an Amazon Chime Voice Connector group under the administrator's AWS account. You
can associate Amazon Chime Voice Connectors with the Amazon Chime Voice Connector group by
including VoiceConnectorItems in the request. You can include Amazon Chime Voice Connectors
from different AWS Regions in your group. This creates a fault tolerant mechanism for
fallback in case of availability events.   This API is is no longer supported and will not
be updated. We recommend using the latest version, CreateVoiceConnectorGroup, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `name`: The name of the Amazon Chime Voice Connector group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VoiceConnectorItems"`: The Amazon Chime Voice Connectors to route inbound calls to.
"""
function create_voice_connector_group(
    Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connector-groups",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_voice_connector_group(
    Name, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connector-groups",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_account(account_id)
    delete_account(account_id, params::Dict{String,<:Any})

Deletes the specified Amazon Chime account. You must suspend all users before deleting Team
account. You can use the BatchSuspendUser action to dodo. For EnterpriseLWA and
EnterpriseAD accounts, you must release the claimed domains for your Amazon Chime account
before deletion. As soon as you release the domain, all users under that account are
suspended. Deleted accounts appear in your Disabled accounts list for 90 days. To restore
deleted account from your Disabled accounts list, you must contact AWS Support. After 90
days, deleted accounts are permanently removed from your Disabled accounts list.

# Arguments
- `account_id`: The Amazon Chime account ID.

"""
function delete_account(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "DELETE",
        "/accounts/$(accountId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_account(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_instance(app_instance_arn)
    delete_app_instance(app_instance_arn, params::Dict{String,<:Any})

Deletes an AppInstance and all associated data asynchronously.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
DeleteAppInstance, in the Amazon Chime SDK. Using the latest version requires migrating to
a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance.

"""
function delete_app_instance(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_instance(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_instance_admin(app_instance_admin_arn, app_instance_arn)
    delete_app_instance_admin(app_instance_admin_arn, app_instance_arn, params::Dict{String,<:Any})

Demotes an AppInstanceAdmin to an AppInstanceUser. This action does not delete the user.
This API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteAppInstanceAdmin, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_admin_arn`: The ARN of the AppInstance's administrator.
- `app_instance_arn`: The ARN of the AppInstance.

"""
function delete_app_instance_admin(
    appInstanceAdminArn, appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)/admins/$(appInstanceAdminArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_instance_admin(
    appInstanceAdminArn,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)/admins/$(appInstanceAdminArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_instance_streaming_configurations(app_instance_arn)
    delete_app_instance_streaming_configurations(app_instance_arn, params::Dict{String,<:Any})

Deletes the streaming configurations of an AppInstance.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
DeleteAppInstanceStreamingConfigurations, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the streaming configurations being deleted.

"""
function delete_app_instance_streaming_configurations(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)/streaming-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_instance_streaming_configurations(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/app-instances/$(appInstanceArn)/streaming-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_app_instance_user(app_instance_user_arn)
    delete_app_instance_user(app_instance_user_arn, params::Dict{String,<:Any})

Deletes an AppInstanceUser.   This API is is no longer supported and will not be updated.
We recommend using the latest version, DeleteAppInstanceUser, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_user_arn`: The ARN of the user request being deleted.

"""
function delete_app_instance_user(
    appInstanceUserArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/app-instance-users/$(appInstanceUserArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_app_instance_user(
    appInstanceUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/app-instance-users/$(appInstanceUserArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_attendee(attendee_id, meeting_id)
    delete_attendee(attendee_id, meeting_id, params::Dict{String,<:Any})

Deletes an attendee from the specified Amazon Chime SDK meeting and deletes their
JoinToken. Attendees are automatically deleted when a Amazon Chime SDK meeting is deleted.
For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the
Amazon Chime SDK Developer Guide.   This API is is no longer supported and will not be
updated. We recommend using the latest version, DeleteAttendee, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function delete_attendee(
    attendeeId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/meetings/$(meetingId)/attendees/$(attendeeId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_attendee(
    attendeeId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/meetings/$(meetingId)/attendees/$(attendeeId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel(channel_arn)
    delete_channel(channel_arn, params::Dict{String,<:Any})

Immediately makes a channel and its memberships inaccessible and marks them for deletion.
This is an irreversible process.  The x-amz-chime-bearer request header is mandatory. Use
the AppInstanceUserArn of the user that makes the API call as the value in the header.
This API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteChannel, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel being deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function delete_channel(channelArn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "DELETE",
        "/channels/$(channelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_ban(channel_arn, member_arn)
    delete_channel_ban(channel_arn, member_arn, params::Dict{String,<:Any})

Removes a user from a channel's ban list.  The x-amz-chime-bearer request header is
mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in
the header.    This API is is no longer supported and will not be updated. We recommend
using the latest version, DeleteChannelBan, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel from which the AppInstanceUser was banned.
- `member_arn`: The ARN of the AppInstanceUser that you want to reinstate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function delete_channel_ban(
    channelArn, memberArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/bans/$(memberArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_ban(
    channelArn,
    memberArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/bans/$(memberArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_membership(channel_arn, member_arn)
    delete_channel_membership(channel_arn, member_arn, params::Dict{String,<:Any})

Removes a member from a channel.  The x-amz-chime-bearer request header is mandatory. Use
the AppInstanceUserArn of the user that makes the API call as the value in the header.
This API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteChannelMembership, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel from which you want to remove the user.
- `member_arn`: The ARN of the member that you're removing from the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function delete_channel_membership(
    channelArn, memberArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/memberships/$(memberArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_membership(
    channelArn,
    memberArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/memberships/$(memberArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_message(channel_arn, message_id)
    delete_channel_message(channel_arn, message_id, params::Dict{String,<:Any})

Deletes a channel message. Only admins can perform this action. Deletion makes messages
inaccessible immediately. A background process deletes any revisions created by
UpdateChannelMessage.  The x-amz-chime-bearer request header is mandatory. Use the
AppInstanceUserArn of the user that makes the API call as the value in the header.    This
API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteChannelMessage, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `message_id`: The ID of the message being deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function delete_channel_message(
    channelArn, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/messages/$(messageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_message(
    channelArn,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/messages/$(messageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_channel_moderator(channel_arn, channel_moderator_arn)
    delete_channel_moderator(channel_arn, channel_moderator_arn, params::Dict{String,<:Any})

Deletes a channel moderator.  The x-amz-chime-bearer request header is mandatory. Use the
AppInstanceUserArn of the user that makes the API call as the value in the header.    This
API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteChannelModerator, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `channel_moderator_arn`: The ARN of the moderator being deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function delete_channel_moderator(
    channelArn, channelModeratorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/moderators/$(channelModeratorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_channel_moderator(
    channelArn,
    channelModeratorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/channels/$(channelArn)/moderators/$(channelModeratorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_events_configuration(account_id, bot_id)
    delete_events_configuration(account_id, bot_id, params::Dict{String,<:Any})

Deletes the events configuration that allows a bot to receive outgoing events.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

"""
function delete_events_configuration(
    accountId, botId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_events_configuration(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_media_capture_pipeline(media_pipeline_id)
    delete_media_capture_pipeline(media_pipeline_id, params::Dict{String,<:Any})

Deletes the media capture pipeline.   This API is is no longer supported and will not be
updated. We recommend using the latest version, DeleteMediaCapturePipeline, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `media_pipeline_id`: The ID of the media capture pipeline being deleted.

"""
function delete_media_capture_pipeline(
    mediaPipelineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/media-capture-pipelines/$(mediaPipelineId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_media_capture_pipeline(
    mediaPipelineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/media-capture-pipelines/$(mediaPipelineId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_meeting(meeting_id)
    delete_meeting(meeting_id, params::Dict{String,<:Any})

Deletes the specified Amazon Chime SDK meeting. The operation deletes all attendees,
disconnects all clients, and prevents new clients from joining the meeting. For more
information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime
SDK Developer Guide.   This API is is no longer supported and will not be updated. We
recommend using the latest version, DeleteMeeting, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function delete_meeting(meetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "DELETE",
        "/meetings/$(meetingId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_meeting(
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/meetings/$(meetingId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_phone_number(phone_number_id)
    delete_phone_number(phone_number_id, params::Dict{String,<:Any})

Moves the specified phone number into the Deletion queue. A phone number must be
disassociated from any users or Amazon Chime Voice Connectors before it can be deleted.
Deleted phone numbers remain in the Deletion queue for 7 days before they are deleted
permanently.

# Arguments
- `phone_number_id`: The phone number ID.

"""
function delete_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_proxy_session(proxy_session_id, voice_connector_id)
    delete_proxy_session(proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Deletes the specified proxy session from the specified Amazon Chime Voice Connector.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteProxySession, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Amazon Chime voice connector ID.

"""
function delete_proxy_session(
    proxySessionId, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_proxy_session(
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_room(account_id, room_id)
    delete_room(account_id, room_id, params::Dict{String,<:Any})

Deletes a chat room in an Amazon Chime Enterprise account.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `room_id`: The chat room ID.

"""
function delete_room(accountId, roomId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "DELETE",
        "/accounts/$(accountId)/rooms/$(roomId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_room(
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)/rooms/$(roomId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_room_membership(account_id, member_id, room_id)
    delete_room_membership(account_id, member_id, room_id, params::Dict{String,<:Any})

Removes a member from a chat room in an Amazon Chime Enterprise account.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `member_id`: The member ID (user ID or bot ID).
- `room_id`: The room ID.

"""
function delete_room_membership(
    accountId, memberId, roomId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships/$(memberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_room_membership(
    accountId,
    memberId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships/$(memberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sip_media_application(sip_media_application_id)
    delete_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Deletes a SIP media application.   This API is is no longer supported and will not be
updated. We recommend using the latest version, DeleteSipMediaApplication, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function delete_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sip_rule(sip_rule_id)
    delete_sip_rule(sip_rule_id, params::Dict{String,<:Any})

Deletes a SIP rule. You must disable a SIP rule before you can delete it.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
DeleteSipRule, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_rule_id`: The SIP rule ID.

"""
function delete_sip_rule(sipRuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "DELETE",
        "/sip-rules/$(sipRuleId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sip_rule(
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/sip-rules/$(sipRuleId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector(voice_connector_id)
    delete_voice_connector(voice_connector_id, params::Dict{String,<:Any})

Deletes the specified Amazon Chime Voice Connector. Any phone numbers associated with the
Amazon Chime Voice Connector must be disassociated from it before it can be deleted.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteVoiceConnector, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_emergency_calling_configuration(voice_connector_id)
    delete_voice_connector_emergency_calling_configuration(voice_connector_id, params::Dict{String,<:Any})

Deletes the emergency calling configuration details from the specified Amazon Chime Voice
Connector.   This API is is no longer supported and will not be updated. We recommend using
the latest version, DeleteVoiceConnectorEmergencyCallingConfiguration, in the Amazon Chime
SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_emergency_calling_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_emergency_calling_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_group(voice_connector_group_id)
    delete_voice_connector_group(voice_connector_group_id, params::Dict{String,<:Any})

Deletes the specified Amazon Chime Voice Connector group. Any VoiceConnectorItems and phone
numbers associated with the group must be removed before it can be deleted.   This API is
is no longer supported and will not be updated. We recommend using the latest version,
DeleteVoiceConnectorGroup, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_group_id`: The Amazon Chime Voice Connector group ID.

"""
function delete_voice_connector_group(
    voiceConnectorGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connector-groups/$(voiceConnectorGroupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_group(
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_origination(voice_connector_id)
    delete_voice_connector_origination(voice_connector_id, params::Dict{String,<:Any})

Deletes the origination settings for the specified Amazon Chime Voice Connector.  If
emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted
prior to deleting the origination settings.    This API is is no longer supported and will
not be updated. We recommend using the latest version, DeleteVoiceConnectorOrigination, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_origination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/origination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_origination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/origination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_proxy(voice_connector_id)
    delete_voice_connector_proxy(voice_connector_id, params::Dict{String,<:Any})

Deletes the proxy configuration from the specified Amazon Chime Voice Connector.   This API
is is no longer supported and will not be updated. We recommend using the latest version,
DeleteVoiceProxy, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_proxy(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_proxy(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_streaming_configuration(voice_connector_id)
    delete_voice_connector_streaming_configuration(voice_connector_id, params::Dict{String,<:Any})

Deletes the streaming configuration for the specified Amazon Chime Voice Connector.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, DeleteVoiceConnectorStreamingConfiguration, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_streaming_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_streaming_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_termination(voice_connector_id)
    delete_voice_connector_termination(voice_connector_id, params::Dict{String,<:Any})

Deletes the termination settings for the specified Amazon Chime Voice Connector.  If
emergency calling is configured for the Amazon Chime Voice Connector, it must be deleted
prior to deleting the termination settings.    This API is is no longer supported and will
not be updated. We recommend using the latest version, DeleteVoiceConnectorTermination, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_termination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/termination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_termination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "DELETE",
        "/voice-connectors/$(voiceConnectorId)/termination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_voice_connector_termination_credentials(usernames, voice_connector_id)
    delete_voice_connector_termination_credentials(usernames, voice_connector_id, params::Dict{String,<:Any})

Deletes the specified SIP credentials used by your equipment to authenticate during call
termination.   This API is is no longer supported and will not be updated. We recommend
using the latest version, DeleteVoiceConnectorTerminationCredentials, in the Amazon Chime
SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `usernames`: The RFC2617 compliant username associated with the SIP credentials, in
  US-ASCII format.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function delete_voice_connector_termination_credentials(
    Usernames, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=delete",
        Dict{String,Any}("Usernames" => Usernames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_voice_connector_termination_credentials(
    Usernames,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Usernames" => Usernames), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_instance(app_instance_arn)
    describe_app_instance(app_instance_arn, params::Dict{String,<:Any})

Returns the full details of an AppInstance.   This API is is no longer supported and will
not be updated. We recommend using the latest version, DescribeAppInstance, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance.

"""
function describe_app_instance(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_instance(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_instance_admin(app_instance_admin_arn, app_instance_arn)
    describe_app_instance_admin(app_instance_admin_arn, app_instance_arn, params::Dict{String,<:Any})

Returns the full details of an AppInstanceAdmin.   This API is is no longer supported and
will not be updated. We recommend using the latest version, DescribeAppInstanceAdmin, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `app_instance_admin_arn`: The ARN of the AppInstanceAdmin.
- `app_instance_arn`: The ARN of the AppInstance.

"""
function describe_app_instance_admin(
    appInstanceAdminArn, appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/admins/$(appInstanceAdminArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_instance_admin(
    appInstanceAdminArn,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/admins/$(appInstanceAdminArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_app_instance_user(app_instance_user_arn)
    describe_app_instance_user(app_instance_user_arn, params::Dict{String,<:Any})

Returns the full details of an AppInstanceUser.   This API is is no longer supported and
will not be updated. We recommend using the latest version, DescribeAppInstanceUser, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Arguments
- `app_instance_user_arn`: The ARN of the AppInstanceUser.

"""
function describe_app_instance_user(
    appInstanceUserArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instance-users/$(appInstanceUserArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_app_instance_user(
    appInstanceUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instance-users/$(appInstanceUserArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel(channel_arn)
    describe_channel(channel_arn, params::Dict{String,<:Any})

Returns the full details of a channel in an Amazon Chime AppInstance.  The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version, DescribeChannel, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel(channelArn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/channels/$(channelArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel_ban(channel_arn, member_arn)
    describe_channel_ban(channel_arn, member_arn, params::Dict{String,<:Any})

Returns the full details of a channel ban.  The x-amz-chime-bearer request header is
mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in
the header.    This API is is no longer supported and will not be updated. We recommend
using the latest version, DescribeChannelBan, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel from which the user is banned.
- `member_arn`: The ARN of the member being banned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel_ban(
    channelArn, memberArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/bans/$(memberArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel_ban(
    channelArn,
    memberArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/bans/$(memberArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel_membership(channel_arn, member_arn)
    describe_channel_membership(channel_arn, member_arn, params::Dict{String,<:Any})

Returns the full details of a user's channel membership.  The x-amz-chime-bearer request
header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the
value in the header.    This API is is no longer supported and will not be updated. We
recommend using the latest version, DescribeChannelMembership, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `member_arn`: The ARN of the member.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel_membership(
    channelArn, memberArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/memberships/$(memberArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel_membership(
    channelArn,
    memberArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/memberships/$(memberArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel_membership_for_app_instance_user(app-instance-user-arn, channel_arn)
    describe_channel_membership_for_app_instance_user(app-instance-user-arn, channel_arn, params::Dict{String,<:Any})

 Returns the details of a channel based on the membership of the specified AppInstanceUser.
 The x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user
that makes the API call as the value in the header.    This API is is no longer supported
and will not be updated. We recommend using the latest version,
DescribeChannelMembershipForAppInstanceUser, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app-instance-user-arn`: The ARN of the user in a channel.
- `channel_arn`: The ARN of the channel to which the user belongs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel_membership_for_app_instance_user(
    app_instance_user_arn, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)?scope=app-instance-user-membership",
        Dict{String,Any}("app-instance-user-arn" => app_instance_user_arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel_membership_for_app_instance_user(
    app_instance_user_arn,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)?scope=app-instance-user-membership",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("app-instance-user-arn" => app_instance_user_arn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel_moderated_by_app_instance_user(app-instance-user-arn, channel_arn)
    describe_channel_moderated_by_app_instance_user(app-instance-user-arn, channel_arn, params::Dict{String,<:Any})

Returns the full details of a channel moderated by the specified AppInstanceUser.  The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version,
DescribeChannelModeratedByAppInstanceUser, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app-instance-user-arn`: The ARN of the AppInstanceUser in the moderated channel.
- `channel_arn`: The ARN of the moderated channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel_moderated_by_app_instance_user(
    app_instance_user_arn, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)?scope=app-instance-user-moderated-channel",
        Dict{String,Any}("app-instance-user-arn" => app_instance_user_arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel_moderated_by_app_instance_user(
    app_instance_user_arn,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)?scope=app-instance-user-moderated-channel",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("app-instance-user-arn" => app_instance_user_arn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_channel_moderator(channel_arn, channel_moderator_arn)
    describe_channel_moderator(channel_arn, channel_moderator_arn, params::Dict{String,<:Any})

Returns the full details of a single ChannelModerator.  The x-amz-chime-bearer request
header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the
value in the header.    This API is is no longer supported and will not be updated. We
recommend using the latest version, DescribeChannelModerator, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `channel_moderator_arn`: The ARN of the channel moderator.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function describe_channel_moderator(
    channelArn, channelModeratorArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/moderators/$(channelModeratorArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_channel_moderator(
    channelArn,
    channelModeratorArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/moderators/$(channelModeratorArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_phone_number_from_user(account_id, user_id)
    disassociate_phone_number_from_user(account_id, user_id, params::Dict{String,<:Any})

Disassociates the primary provisioned phone number from the specified Amazon Chime user.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function disassociate_phone_number_from_user(
    accountId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=disassociate-phone-number";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_phone_number_from_user(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=disassociate-phone-number",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_phone_numbers_from_voice_connector(e164_phone_numbers, voice_connector_id)
    disassociate_phone_numbers_from_voice_connector(e164_phone_numbers, voice_connector_id, params::Dict{String,<:Any})

Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector.
 This API is is no longer supported and will not be updated. We recommend using the latest
version, DisassociatePhoneNumbersFromVoiceConnector, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function disassociate_phone_numbers_from_voice_connector(
    E164PhoneNumbers, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=disassociate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_phone_numbers_from_voice_connector(
    E164PhoneNumbers,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)?operation=disassociate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_phone_numbers_from_voice_connector_group(e164_phone_numbers, voice_connector_group_id)
    disassociate_phone_numbers_from_voice_connector_group(e164_phone_numbers, voice_connector_group_id, params::Dict{String,<:Any})

Disassociates the specified phone numbers from the specified Amazon Chime Voice Connector
group.   This API is is no longer supported and will not be updated. We recommend using the
latest version, DisassociatePhoneNumbersFromVoiceConnectorGroup, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `e164_phone_numbers`: List of phone numbers, in E.164 format.
- `voice_connector_group_id`: The Amazon Chime Voice Connector group ID.

"""
function disassociate_phone_numbers_from_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=disassociate-phone-numbers",
        Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_phone_numbers_from_voice_connector_group(
    E164PhoneNumbers,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connector-groups/$(voiceConnectorGroupId)?operation=disassociate-phone-numbers",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("E164PhoneNumbers" => E164PhoneNumbers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_signin_delegate_groups_from_account(group_names, account_id)
    disassociate_signin_delegate_groups_from_account(group_names, account_id, params::Dict{String,<:Any})

Disassociates the specified sign-in delegate groups from the specified Amazon Chime account.

# Arguments
- `group_names`: The sign-in delegate group names.
- `account_id`: The Amazon Chime account ID.

"""
function disassociate_signin_delegate_groups_from_account(
    GroupNames, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)?operation=disassociate-signin-delegate-groups",
        Dict{String,Any}("GroupNames" => GroupNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_signin_delegate_groups_from_account(
    GroupNames,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)?operation=disassociate-signin-delegate-groups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("GroupNames" => GroupNames), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account(account_id)
    get_account(account_id, params::Dict{String,<:Any})

Retrieves details for the specified Amazon Chime account, such as account type and
supported licenses.

# Arguments
- `account_id`: The Amazon Chime account ID.

"""
function get_account(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_account(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_settings(account_id)
    get_account_settings(account_id, params::Dict{String,<:Any})

Retrieves account settings for the specified Amazon Chime account ID, such as remote
control and dialout settings. For more information about these settings, see Use the
Policies Page in the Amazon Chime Administration Guide.

# Arguments
- `account_id`: The Amazon Chime account ID.

"""
function get_account_settings(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_account_settings(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_app_instance_retention_settings(app_instance_arn)
    get_app_instance_retention_settings(app_instance_arn, params::Dict{String,<:Any})

Gets the retention settings for an AppInstance.   This API is is no longer supported and
will not be updated. We recommend using the latest version, GetMessagingRetentionSettings,
in the Amazon Chime SDK. Using the latest version requires migrating to a dedicated
namespace. For more information, refer to Migrating from the Amazon Chime namespace in the
Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance.

"""
function get_app_instance_retention_settings(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/retention-settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_app_instance_retention_settings(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/retention-settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_app_instance_streaming_configurations(app_instance_arn)
    get_app_instance_streaming_configurations(app_instance_arn, params::Dict{String,<:Any})

Gets the streaming settings for an AppInstance.   This API is is no longer supported and
will not be updated. We recommend using the latest version,
GetMessagingStreamingConfigurations, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance.

"""
function get_app_instance_streaming_configurations(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/streaming-configurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_app_instance_streaming_configurations(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/streaming-configurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_attendee(attendee_id, meeting_id)
    get_attendee(attendee_id, meeting_id, params::Dict{String,<:Any})

 Gets the Amazon Chime SDK attendee details for a specified meeting ID and attendee ID. For
more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon
Chime SDK Developer Guide.    This API is is no longer supported and will not be updated.
We recommend using the latest version, GetAttendee, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function get_attendee(
    attendeeId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees/$(attendeeId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_attendee(
    attendeeId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees/$(attendeeId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_bot(account_id, bot_id)
    get_bot(account_id, bot_id, params::Dict{String,<:Any})

Retrieves details for the specified bot, such as bot email address, bot type, status, and
display name.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

"""
function get_bot(accountId, botId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/bots/$(botId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_bot(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/bots/$(botId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_channel_message(channel_arn, message_id)
    get_channel_message(channel_arn, message_id, params::Dict{String,<:Any})

Gets the full details of a channel message.  The x-amz-chime-bearer request header is
mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in
the header.    This API is is no longer supported and will not be updated. We recommend
using the latest version, GetChannelMessage, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `message_id`: The ID of the message.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function get_channel_message(
    channelArn, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/messages/$(messageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_channel_message(
    channelArn,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/messages/$(messageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_events_configuration(account_id, bot_id)
    get_events_configuration(account_id, bot_id, params::Dict{String,<:Any})

Gets details for an events configuration that allows a bot to receive outgoing events, such
as an HTTPS endpoint or Lambda function ARN.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

"""
function get_events_configuration(
    accountId, botId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_events_configuration(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_global_settings()
    get_global_settings(params::Dict{String,<:Any})

Retrieves global settings for the administrator's AWS account, such as Amazon Chime
Business Calling and Amazon Chime Voice Connector settings.

"""
function get_global_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime("GET", "/settings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_global_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET", "/settings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_media_capture_pipeline(media_pipeline_id)
    get_media_capture_pipeline(media_pipeline_id, params::Dict{String,<:Any})

Gets an existing media capture pipeline.   This API is is no longer supported and will not
be updated. We recommend using the latest version, GetMediaCapturePipeline, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `media_pipeline_id`: The ID of the pipeline that you want to get.

"""
function get_media_capture_pipeline(
    mediaPipelineId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/media-capture-pipelines/$(mediaPipelineId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_media_capture_pipeline(
    mediaPipelineId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/media-capture-pipelines/$(mediaPipelineId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_meeting(meeting_id)
    get_meeting(meeting_id, params::Dict{String,<:Any})

  This API is is no longer supported and will not be updated. We recommend using the latest
version, GetMeeting, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.   Gets the Amazon Chime SDK meeting
details for the specified meeting ID. For more information about the Amazon Chime SDK, see
Using the Amazon Chime SDK in the Amazon Chime SDK Developer Guide .

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function get_meeting(meetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/meetings/$(meetingId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_meeting(
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/meetings/$(meetingId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_messaging_session_endpoint()
    get_messaging_session_endpoint(params::Dict{String,<:Any})

The details of the endpoint for the messaging session.   This API is is no longer supported
and will not be updated. We recommend using the latest version,
GetMessagingSessionEndpoint, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

"""
function get_messaging_session_endpoint(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/endpoints/messaging-session";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_messaging_session_endpoint(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/endpoints/messaging-session",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_phone_number(phone_number_id)
    get_phone_number(phone_number_id, params::Dict{String,<:Any})

Retrieves details for the specified phone number ID, such as associations, capabilities,
and product type.

# Arguments
- `phone_number_id`: The phone number ID.

"""
function get_phone_number(phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_phone_number_order(phone_number_order_id)
    get_phone_number_order(phone_number_order_id, params::Dict{String,<:Any})

Retrieves details for the specified phone number order, such as the order creation
timestamp, phone numbers in E.164 format, product type, and order status.

# Arguments
- `phone_number_order_id`: The ID for the phone number order.

"""
function get_phone_number_order(
    phoneNumberOrderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/phone-number-orders/$(phoneNumberOrderId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number_order(
    phoneNumberOrderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/phone-number-orders/$(phoneNumberOrderId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_phone_number_settings()
    get_phone_number_settings(params::Dict{String,<:Any})

Retrieves the phone number settings for the administrator's AWS account, such as the
default outbound calling name.

"""
function get_phone_number_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/settings/phone-number";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_phone_number_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/settings/phone-number",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_proxy_session(proxy_session_id, voice_connector_id)
    get_proxy_session(proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Gets the specified proxy session details for the specified Amazon Chime Voice Connector.
This API is is no longer supported and will not be updated. We recommend using the latest
version, GetProxySession, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Amazon Chime voice connector ID.

"""
function get_proxy_session(
    proxySessionId, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_proxy_session(
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_retention_settings(account_id)
    get_retention_settings(account_id, params::Dict{String,<:Any})

 Gets the retention settings for the specified Amazon Chime Enterprise account. For more
information about retention settings, see Managing Chat Retention Policies in the Amazon
Chime Administration Guide.

# Arguments
- `account_id`: The Amazon Chime account ID.

"""
function get_retention_settings(
    accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/accounts/$(accountId)/retention-settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_retention_settings(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/retention-settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_room(account_id, room_id)
    get_room(account_id, room_id, params::Dict{String,<:Any})

Retrieves room details, such as the room name, for a room in an Amazon Chime Enterprise
account.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `room_id`: The room ID.

"""
function get_room(accountId, roomId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms/$(roomId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_room(
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms/$(roomId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_media_application(sip_media_application_id)
    get_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Retrieves the information for a SIP media application, including name, AWS Region, and
endpoints.   This API is is no longer supported and will not be updated. We recommend using
the latest version, GetSipMediaApplication, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function get_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_media_application_logging_configuration(sip_media_application_id)
    get_sip_media_application_logging_configuration(sip_media_application_id, params::Dict{String,<:Any})

Returns the logging configuration for the specified SIP media application.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
GetSipMediaApplicationLoggingConfiguration, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

"""
function get_sip_media_application_logging_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_media_application_logging_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sip_rule(sip_rule_id)
    get_sip_rule(sip_rule_id, params::Dict{String,<:Any})

Retrieves the details of a SIP rule, such as the rule ID, name, triggers, and target
endpoints.   This API is is no longer supported and will not be updated. We recommend using
the latest version, GetSipRule, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_rule_id`: The SIP rule ID.

"""
function get_sip_rule(sipRuleId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/sip-rules/$(sipRuleId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sip_rule(
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/sip-rules/$(sipRuleId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user(account_id, user_id)
    get_user(account_id, user_id, params::Dict{String,<:Any})

Retrieves details for the specified user ID, such as primary email address, license
type,and personal meeting PIN.  To retrieve user details with an email address instead of a
user ID, use the ListUsers action, and then filter by email address.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function get_user(accountId, userId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/users/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/users/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_user_settings(account_id, user_id)
    get_user_settings(account_id, user_id, params::Dict{String,<:Any})

Retrieves settings for the specified user ID, such as any associated phone number settings.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function get_user_settings(
    accountId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/accounts/$(accountId)/users/$(userId)/settings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_user_settings(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/users/$(userId)/settings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector(voice_connector_id)
    get_voice_connector(voice_connector_id, params::Dict{String,<:Any})

Retrieves details for the specified Amazon Chime Voice Connector, such as timestamps,name,
outbound host, and encryption requirements.   This API is is no longer supported and will
not be updated. We recommend using the latest version, GetVoiceConnector, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_emergency_calling_configuration(voice_connector_id)
    get_voice_connector_emergency_calling_configuration(voice_connector_id, params::Dict{String,<:Any})

Gets the emergency calling configuration details for the specified Amazon Chime Voice
Connector.   This API is is no longer supported and will not be updated. We recommend using
the latest version, GetVoiceConnectorEmergencyCallingConfiguration, in the Amazon Chime
SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_emergency_calling_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_emergency_calling_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_group(voice_connector_group_id)
    get_voice_connector_group(voice_connector_group_id, params::Dict{String,<:Any})

 Retrieves details for the specified Amazon Chime Voice Connector group, such as
timestamps,name, and associated VoiceConnectorItems.   This API is is no longer supported
and will not be updated. We recommend using the latest version, GetVoiceConnectorGroup, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `voice_connector_group_id`: The Amazon Chime Voice Connector group ID.

"""
function get_voice_connector_group(
    voiceConnectorGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connector-groups/$(voiceConnectorGroupId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_group(
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_logging_configuration(voice_connector_id)
    get_voice_connector_logging_configuration(voice_connector_id, params::Dict{String,<:Any})

Retrieves the logging configuration details for the specified Amazon Chime Voice Connector.
Shows whether SIP message logs are enabled for sending to Amazon CloudWatch Logs.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, GetVoiceConnectorLoggingConfiguration, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_logging_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_logging_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_origination(voice_connector_id)
    get_voice_connector_origination(voice_connector_id, params::Dict{String,<:Any})

Retrieves origination setting details for the specified Amazon Chime Voice Connector.
This API is is no longer supported and will not be updated. We recommend using the latest
version, GetVoiceConnectorOrigination, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_origination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/origination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_origination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/origination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_proxy(voice_connector_id)
    get_voice_connector_proxy(voice_connector_id, params::Dict{String,<:Any})

Gets the proxy configuration details for the specified Amazon Chime Voice Connector.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, GetVoiceConnectorProxy, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime voice connector ID.

"""
function get_voice_connector_proxy(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_proxy(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_streaming_configuration(voice_connector_id)
    get_voice_connector_streaming_configuration(voice_connector_id, params::Dict{String,<:Any})

Retrieves the streaming configuration details for the specified Amazon Chime Voice
Connector. Shows whether media streaming is enabled for sending to Amazon Kinesis. It also
shows the retention period, in hours, for the Amazon Kinesis data.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
GetVoiceConnectorStreamingConfiguration, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_streaming_configuration(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_streaming_configuration(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_termination(voice_connector_id)
    get_voice_connector_termination(voice_connector_id, params::Dict{String,<:Any})

Retrieves termination setting details for the specified Amazon Chime Voice Connector.
This API is is no longer supported and will not be updated. We recommend using the latest
version, GetVoiceConnectorTermination, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_termination(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_termination(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_voice_connector_termination_health(voice_connector_id)
    get_voice_connector_termination_health(voice_connector_id, params::Dict{String,<:Any})

  This API is is no longer supported and will not be updated. We recommend using the latest
version, GetVoiceConnectorTerminationHealth, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.
Retrieves information about the last time a SIP OPTIONS ping was received from your SIP
infrastructure for the specified Amazon Chime Voice Connector.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function get_voice_connector_termination_health(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/health";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_voice_connector_termination_health(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/health",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invite_users(user_email_list, account_id)
    invite_users(user_email_list, account_id, params::Dict{String,<:Any})

Sends email to a maximum of 50 users, inviting them to the specified Amazon Chime Team
account. Only Team account types are currently supported for this action.

# Arguments
- `user_email_list`: The user email addresses to which to send the email invitation.
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"UserType"`: The user type.
"""
function invite_users(
    UserEmailList, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=add",
        Dict{String,Any}("UserEmailList" => UserEmailList);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invite_users(
    UserEmailList,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users?operation=add",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserEmailList" => UserEmailList), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_accounts()
    list_accounts(params::Dict{String,<:Any})

Lists the Amazon Chime accounts under the administrator's AWS account. You can filter
accounts by account name prefix. To find out which Amazon Chime account a user belongs to,
you can filter by the user's email address, which returns one account result.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"name"`: Amazon Chime account name prefix with which to filter results.
- `"next-token"`: The token to use to retrieve the next page of results.
- `"user-email"`: User email address with which to filter results.
"""
function list_accounts(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime("GET", "/accounts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_accounts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET", "/accounts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_app_instance_admins(app_instance_arn)
    list_app_instance_admins(app_instance_arn, params::Dict{String,<:Any})

Returns a list of the administrators in the AppInstance.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
ListAppInstanceAdmins, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_arn`: The ARN of the AppInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of administrators that you want to return.
- `"next-token"`: The token returned from previous API requests until the number of
  administrators is reached.
"""
function list_app_instance_admins(
    appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/admins";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_instance_admins(
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instances/$(appInstanceArn)/admins",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_instance_users(app-instance-arn)
    list_app_instance_users(app-instance-arn, params::Dict{String,<:Any})

List all AppInstanceUsers created under a single AppInstance.    This API is is no longer
supported and will not be updated. We recommend using the latest version,
ListAppInstanceUsers, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app-instance-arn`: The ARN of the AppInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of requests that you want returned.
- `"next-token"`: The token passed by previous API calls until all requested users are
  returned.
"""
function list_app_instance_users(
    app_instance_arn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instance-users",
        Dict{String,Any}("app-instance-arn" => app_instance_arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_app_instance_users(
    app_instance_arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/app-instance-users",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("app-instance-arn" => app_instance_arn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_app_instances()
    list_app_instances(params::Dict{String,<:Any})

Lists all Amazon Chime AppInstances created under a single AWS account.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
ListAppInstances, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of AppInstances that you want to return.
- `"next-token"`: The token passed by previous API requests until you reach the maximum
  number of AppInstances.
"""
function list_app_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET", "/app-instances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_app_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/app-instances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attendee_tags(attendee_id, meeting_id)
    list_attendee_tags(attendee_id, meeting_id, params::Dict{String,<:Any})

Lists the tags applied to an Amazon Chime SDK attendee resource.  ListAttendeeTags is not
supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove
calls to this API.

# Arguments
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function list_attendee_tags(
    attendeeId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attendee_tags(
    attendeeId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attendees(meeting_id)
    list_attendees(meeting_id, params::Dict{String,<:Any})

 Lists the attendees for the specified Amazon Chime SDK meeting. For more information about
the Amazon Chime SDK, see Using the Amazon Chime SDK in the Amazon Chime SDK Developer
Guide.    This API is is no longer supported and will not be updated. We recommend using
the latest version, ListAttendees, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_attendees(meetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_attendees(
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/attendees",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_bots(account_id)
    list_bots(account_id, params::Dict{String,<:Any})

Lists the bots associated with the administrator's Amazon Chime Enterprise account ID.

# Arguments
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. The default is
  10.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_bots(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/bots";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_bots(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/bots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_bans(channel_arn)
    list_channel_bans(channel_arn, params::Dict{String,<:Any})

Lists all the users banned from a particular channel.  The x-amz-chime-bearer request
header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the
value in the header.    This API is is no longer supported and will not be updated. We
recommend using the latest version, ListChannelBans, in the Amazon Chime SDK. Using the
latest version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of bans that you want returned.
- `"next-token"`: The token passed by previous API calls until all requested bans are
  returned.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channel_bans(channelArn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/channels/$(channelArn)/bans";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channel_bans(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/bans",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_memberships(channel_arn)
    list_channel_memberships(channel_arn, params::Dict{String,<:Any})

Lists all channel memberships in a channel.  The x-amz-chime-bearer request header is
mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in
the header.    This API is is no longer supported and will not be updated. We recommend
using the latest version, ListChannelMemberships, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The maximum number of channel memberships that you want returned.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of channel memberships that you want returned.
- `"next-token"`: The token passed by previous API calls until all requested channel
  memberships are returned.
- `"type"`: The membership type of a user, DEFAULT or HIDDEN. Default members are always
  returned as part of ListChannelMemberships. Hidden members are only returned if the type
  filter in ListChannelMemberships equals HIDDEN. Otherwise hidden members are not returned.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channel_memberships(
    channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/memberships";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channel_memberships(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/memberships",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_memberships_for_app_instance_user()
    list_channel_memberships_for_app_instance_user(params::Dict{String,<:Any})

 Lists all channels that a particular AppInstanceUser is a part of. Only an
AppInstanceAdmin can call the API with a user ARN that is not their own.   The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version,
ListChannelMembershipsForAppInstanceUser, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"app-instance-user-arn"`: The ARN of the AppInstanceUsers
- `"max-results"`: The maximum number of users that you want returned.
- `"next-token"`: The token returned from previous API requests until the number of channel
  memberships is reached.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channel_memberships_for_app_instance_user(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels?scope=app-instance-user-memberships";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channel_memberships_for_app_instance_user(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels?scope=app-instance-user-memberships",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_messages(channel_arn)
    list_channel_messages(channel_arn, params::Dict{String,<:Any})

List all the messages in a channel. Returns a paginated list of ChannelMessages. By
default, sorted by creation timestamp in descending order.  Redacted messages appear in the
results as empty, since they are only redacted, not deleted. Deleted messages do not appear
in the results. This action always returns the latest version of an edited message. Also,
the x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user
that makes the API call as the value in the header.    This API is is no longer supported
and will not be updated. We recommend using the latest version, ListChannelMessages, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of messages that you want returned.
- `"next-token"`: The token passed by previous API calls until all requested messages are
  returned.
- `"not-after"`: The final or ending time stamp for your requested messages.
- `"not-before"`: The initial or starting time stamp for your requested messages.
- `"sort-order"`: The order in which you want messages sorted. Default is Descending, based
  on time created.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channel_messages(
    channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/messages";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channel_messages(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/messages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channel_moderators(channel_arn)
    list_channel_moderators(channel_arn, params::Dict{String,<:Any})

Lists all the moderators for a channel.  The x-amz-chime-bearer request header is
mandatory. Use the AppInstanceUserArn of the user that makes the API call as the value in
the header.    This API is is no longer supported and will not be updated. We recommend
using the latest version, ListChannelModerators, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of moderators that you want returned.
- `"next-token"`: The token passed by previous API calls until all requested moderators are
  returned.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channel_moderators(
    channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels/$(channelArn)/moderators";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channel_moderators(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels/$(channelArn)/moderators",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channels(app-instance-arn)
    list_channels(app-instance-arn, params::Dict{String,<:Any})

Lists all Channels created under a single Chime App as a paginated list. You can specify
filters to narrow results.  Functionality &amp; restrictions    Use privacy = PUBLIC to
retrieve all public channels in the account.   Only an AppInstanceAdmin can set privacy =
PRIVATE to list the private channels in an account.    The x-amz-chime-bearer request
header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the
value in the header.    This API is is no longer supported and will not be updated. We
recommend using the latest version, ListChannels, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app-instance-arn`: The ARN of the AppInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of channels that you want to return.
- `"next-token"`: The token passed by previous API calls until all requested channels are
  returned.
- `"privacy"`: The privacy setting. PUBLIC retrieves all the public channels. PRIVATE
  retrieves private channels. Only an AppInstanceAdmin can retrieve private channels.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channels(app_instance_arn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/channels",
        Dict{String,Any}("app-instance-arn" => app_instance_arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channels(
    app_instance_arn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/channels",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("app-instance-arn" => app_instance_arn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_channels_moderated_by_app_instance_user()
    list_channels_moderated_by_app_instance_user(params::Dict{String,<:Any})

A list of the channels moderated by an AppInstanceUser.  The x-amz-chime-bearer request
header is mandatory. Use the AppInstanceUserArn of the user that makes the API call as the
value in the header.    This API is is no longer supported and will not be updated. We
recommend using the latest version, ListChannelsModeratedByAppInstanceUser, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"app-instance-user-arn"`: The ARN of the user in the moderated channel.
- `"max-results"`: The maximum number of channels in the request.
- `"next-token"`: The token returned from previous API requests until the number of
  channels moderated by the user is reached.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function list_channels_moderated_by_app_instance_user(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels?scope=app-instance-user-moderated-channels";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_channels_moderated_by_app_instance_user(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/channels?scope=app-instance-user-moderated-channels",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_media_capture_pipelines()
    list_media_capture_pipelines(params::Dict{String,<:Any})

Returns a list of media capture pipelines.   This API is is no longer supported and will
not be updated. We recommend using the latest version, ListMediaCapturePipelines, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Valid Range: 1
  - 99.
- `"next-token"`: The token used to retrieve the next page of results.
"""
function list_media_capture_pipelines(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/media-capture-pipelines";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_media_capture_pipelines(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/media-capture-pipelines",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_meeting_tags(meeting_id)
    list_meeting_tags(meeting_id, params::Dict{String,<:Any})

Lists the tags applied to an Amazon Chime SDK meeting resource.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
ListTagsForResource, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function list_meeting_tags(meetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/meetings/$(meetingId)/tags";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_meeting_tags(
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/meetings/$(meetingId)/tags",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_meetings()
    list_meetings(params::Dict{String,<:Any})

Lists up to 100 active Amazon Chime SDK meetings.  ListMeetings is not supported in the
Amazon Chime SDK Meetings Namespace. Update your application to remove calls to this API.
For more information about the Amazon Chime SDK, see Using the Amazon Chime SDK in the
Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_meetings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime("GET", "/meetings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_meetings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET", "/meetings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_phone_number_orders()
    list_phone_number_orders(params::Dict{String,<:Any})

Lists the phone number orders for the administrator's Amazon Chime account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_phone_number_orders(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/phone-number-orders";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_phone_number_orders(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/phone-number-orders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_phone_numbers()
    list_phone_numbers(params::Dict{String,<:Any})

Lists the phone numbers for the specified Amazon Chime account, Amazon Chime user, Amazon
Chime Voice Connector, or Amazon Chime Voice Connector group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter-name"`: The filter to use to limit the number of results.
- `"filter-value"`: The value to use for the filter.
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
- `"product-type"`: The phone number product type.
- `"status"`: The phone number status.
"""
function list_phone_numbers(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET", "/phone-numbers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_phone_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/phone-numbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_proxy_sessions(voice_connector_id)
    list_proxy_sessions(voice_connector_id, params::Dict{String,<:Any})

Lists the proxy sessions for the specified Amazon Chime Voice Connector.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
ListProxySessions, in the Amazon Chime SDK. Using the latest version requires migrating to
a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime voice connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
- `"status"`: The proxy session status.
"""
function list_proxy_sessions(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_proxy_sessions(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_room_memberships(account_id, room_id)
    list_room_memberships(account_id, room_id, params::Dict{String,<:Any})

Lists the membership details for the specified room in an Amazon Chime Enterprise account,
such as the members' IDs, email addresses, and names.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `room_id`: The room ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_room_memberships(
    accountId, roomId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_room_memberships(
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rooms(account_id)
    list_rooms(account_id, params::Dict{String,<:Any})

Lists the room details for the specified Amazon Chime Enterprise account. Optionally,
filter the results by a member ID (user ID or bot ID) to see a list of rooms that the
member belongs to.

# Arguments
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"member-id"`: The member ID (user ID or bot ID).
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_rooms(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rooms(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/rooms",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sip_media_applications()
    list_sip_media_applications(params::Dict{String,<:Any})

Lists the SIP media applications under the administrator's AWS account.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
ListSipMediaApplications, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_sip_media_applications(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/sip-media-applications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sip_media_applications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/sip-media-applications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sip_rules()
    list_sip_rules(params::Dict{String,<:Any})

Lists the SIP rules under the administrator's AWS account.   This API is is no longer
supported and will not be updated. We recommend using the latest version, ListSipRules, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"next-token"`: The token to use to retrieve the next page of results.
- `"sip-media-application"`: The SIP media application ID.
"""
function list_sip_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET", "/sip-rules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_sip_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET", "/sip-rules", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_supported_phone_number_countries(product-type)
    list_supported_phone_number_countries(product-type, params::Dict{String,<:Any})

Lists supported phone number countries.

# Arguments
- `product-type`: The phone number product type.

"""
function list_supported_phone_number_countries(
    product_type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/phone-number-countries",
        Dict{String,Any}("product-type" => product_type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_supported_phone_number_countries(
    product_type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/phone-number-countries",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("product-type" => product_type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Lists the tags applied to an Amazon Chime SDK meeting and messaging resources.   This API
is is no longer supported and will not be updated. We recommend using the applicable latest
version in the Amazon Chime SDK.   For meetings: ListTagsForResource.   For messaging:
ListTagsForResource.   Using the latest version requires migrating to a dedicated
namespace. For more information, refer to Migrating from the Amazon Chime namespace in the
Amazon Chime SDK Developer Guide.

# Arguments
- `arn`: The resource ARN.

"""
function list_tags_for_resource(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/tags",
        Dict{String,Any}("arn" => arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/tags",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("arn" => arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_users(account_id)
    list_users(account_id, params::Dict{String,<:Any})

Lists the users that belong to the specified Amazon Chime account. You can specify an email
address to list only the user that the email address belongs to.

# Arguments
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call. Defaults to
  100.
- `"next-token"`: The token to use to retrieve the next page of results.
- `"user-email"`: Optional. The user email address used to filter results. Maximum 1.
- `"user-type"`: The user type.
"""
function list_users(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/accounts/$(accountId)/users";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_users(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/accounts/$(accountId)/users",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connector_groups()
    list_voice_connector_groups(params::Dict{String,<:Any})

Lists the Amazon Chime Voice Connector groups for the administrator's AWS account.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, ListVoiceConnectorGroups, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_voice_connector_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET",
        "/voice-connector-groups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_connector_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connector-groups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connector_termination_credentials(voice_connector_id)
    list_voice_connector_termination_credentials(voice_connector_id, params::Dict{String,<:Any})

Lists the SIP credentials for the specified Amazon Chime Voice Connector.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
ListVoiceConnectorTerminationCredentials, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function list_voice_connector_termination_credentials(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_voice_connector_termination_credentials(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "GET",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_voice_connectors()
    list_voice_connectors(params::Dict{String,<:Any})

Lists the Amazon Chime Voice Connectors for the administrator's AWS account.   This API is
is no longer supported and will not be updated. We recommend using the latest version,
ListVoiceConnectors, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token to use to retrieve the next page of results.
"""
function list_voice_connectors(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "GET", "/voice-connectors"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_voice_connectors(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/voice-connectors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    logout_user(account_id, user_id)
    logout_user(account_id, user_id, params::Dict{String,<:Any})

Logs out the specified user from all of the devices they are currently logged into.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function logout_user(accountId, userId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=logout";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function logout_user(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=logout",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_app_instance_retention_settings(app_instance_retention_settings, app_instance_arn)
    put_app_instance_retention_settings(app_instance_retention_settings, app_instance_arn, params::Dict{String,<:Any})

Sets the amount of time in days that a given AppInstance retains data.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
PutAppInstanceRetentionSettings, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_retention_settings`: The time in days to retain data. Data type: number.
- `app_instance_arn`: The ARN of the AppInstance.

"""
function put_app_instance_retention_settings(
    AppInstanceRetentionSettings,
    appInstanceArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)/retention-settings",
        Dict{String,Any}("AppInstanceRetentionSettings" => AppInstanceRetentionSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_app_instance_retention_settings(
    AppInstanceRetentionSettings,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)/retention-settings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppInstanceRetentionSettings" => AppInstanceRetentionSettings
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_app_instance_streaming_configurations(app_instance_streaming_configurations, app_instance_arn)
    put_app_instance_streaming_configurations(app_instance_streaming_configurations, app_instance_arn, params::Dict{String,<:Any})

The data streaming configurations of an AppInstance.   This API is is no longer supported
and will not be updated. We recommend using the latest version,
PutMessagingStreamingConfigurations, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `app_instance_streaming_configurations`: The streaming configurations set for an
  AppInstance.
- `app_instance_arn`: The ARN of the AppInstance.

"""
function put_app_instance_streaming_configurations(
    AppInstanceStreamingConfigurations,
    appInstanceArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)/streaming-configurations",
        Dict{String,Any}(
            "AppInstanceStreamingConfigurations" => AppInstanceStreamingConfigurations
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_app_instance_streaming_configurations(
    AppInstanceStreamingConfigurations,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)/streaming-configurations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AppInstanceStreamingConfigurations" =>
                        AppInstanceStreamingConfigurations,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_events_configuration(account_id, bot_id)
    put_events_configuration(account_id, bot_id, params::Dict{String,<:Any})

Creates an events configuration that allows a bot to receive outgoing events sent by Amazon
Chime. Choose either an HTTPS endpoint or a Lambda function ARN. For more information, see
Bot.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LambdaFunctionArn"`: Lambda function ARN that allows the bot to receive outgoing events.
- `"OutboundEventsHTTPSEndpoint"`: HTTPS endpoint that allows the bot to receive outgoing
  events.
"""
function put_events_configuration(
    accountId, botId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_events_configuration(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/bots/$(botId)/events-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_retention_settings(retention_settings, account_id)
    put_retention_settings(retention_settings, account_id, params::Dict{String,<:Any})

 Puts retention settings for the specified Amazon Chime Enterprise account. We recommend
using AWS CloudTrail to monitor usage of this API for your account. For more information,
see Logging Amazon Chime API Calls with AWS CloudTrail in the Amazon Chime Administration
Guide.  To turn off existing retention settings, remove the number of days from the
corresponding RetentionDays field in the RetentionSettings object. For more information
about retention settings, see Managing Chat Retention Policies in the Amazon Chime
Administration Guide.

# Arguments
- `retention_settings`: The retention settings.
- `account_id`: The Amazon Chime account ID.

"""
function put_retention_settings(
    RetentionSettings, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/retention-settings",
        Dict{String,Any}("RetentionSettings" => RetentionSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_retention_settings(
    RetentionSettings,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/retention-settings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RetentionSettings" => RetentionSettings), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sip_media_application_logging_configuration(sip_media_application_id)
    put_sip_media_application_logging_configuration(sip_media_application_id, params::Dict{String,<:Any})

Updates the logging configuration for the specified SIP media application.   This API is is
no longer supported and will not be updated. We recommend using the latest version,
PutSipMediaApplicationLoggingConfiguration, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SipMediaApplicationLoggingConfiguration"`: The actual logging configuration.
"""
function put_sip_media_application_logging_configuration(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sip_media_application_logging_configuration(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)/logging-configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_emergency_calling_configuration(emergency_calling_configuration, voice_connector_id)
    put_voice_connector_emergency_calling_configuration(emergency_calling_configuration, voice_connector_id, params::Dict{String,<:Any})

Puts emergency calling configuration details to the specified Amazon Chime Voice Connector,
such as emergency phone numbers and calling countries. Origination and termination settings
must be enabled for the Amazon Chime Voice Connector before emergency calling can be
configured.   This API is is no longer supported and will not be updated. We recommend
using the latest version, PutVoiceConnectorEmergencyCallingConfiguration, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `emergency_calling_configuration`: The emergency calling configuration details.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function put_voice_connector_emergency_calling_configuration(
    EmergencyCallingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        Dict{String,Any}("EmergencyCallingConfiguration" => EmergencyCallingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_emergency_calling_configuration(
    EmergencyCallingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/emergency-calling-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EmergencyCallingConfiguration" => EmergencyCallingConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_logging_configuration(logging_configuration, voice_connector_id)
    put_voice_connector_logging_configuration(logging_configuration, voice_connector_id, params::Dict{String,<:Any})

Adds a logging configuration for the specified Amazon Chime Voice Connector. The logging
configuration specifies whether SIP message logs are enabled for sending to Amazon
CloudWatch Logs.   This API is is no longer supported and will not be updated. We recommend
using the latest version, PutVoiceConnectorLoggingConfiguration, in the Amazon Chime SDK.
Using the latest version requires migrating to a dedicated namespace. For more information,
refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `logging_configuration`: The logging configuration details to add.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function put_voice_connector_logging_configuration(
    LoggingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_logging_configuration(
    LoggingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/logging-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LoggingConfiguration" => LoggingConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_origination(origination, voice_connector_id)
    put_voice_connector_origination(origination, voice_connector_id, params::Dict{String,<:Any})

Adds origination settings for the specified Amazon Chime Voice Connector.  If emergency
calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to
turning off origination settings.    This API is is no longer supported and will not be
updated. We recommend using the latest version, PutVoiceConnectorOrigination, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `origination`: The origination setting details to add.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function put_voice_connector_origination(
    Origination, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/origination",
        Dict{String,Any}("Origination" => Origination);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_origination(
    Origination,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/origination",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Origination" => Origination), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_proxy(default_session_expiry_minutes, phone_number_pool_countries, voice_connector_id)
    put_voice_connector_proxy(default_session_expiry_minutes, phone_number_pool_countries, voice_connector_id, params::Dict{String,<:Any})

Puts the specified proxy configuration to the specified Amazon Chime Voice Connector.
This API is is no longer supported and will not be updated. We recommend using the latest
version, PutVoiceConnectorProxy, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `default_session_expiry_minutes`: The default number of minutes allowed for proxy
  sessions.
- `phone_number_pool_countries`: The countries for proxy phone numbers to be selected from.
- `voice_connector_id`: The Amazon Chime voice connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: When true, stops proxy sessions from being created on the specified Amazon
  Chime Voice Connector.
- `"FallBackPhoneNumber"`: The phone number to route calls to after a proxy session expires.
"""
function put_voice_connector_proxy(
    DefaultSessionExpiryMinutes,
    PhoneNumberPoolCountries,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        Dict{String,Any}(
            "DefaultSessionExpiryMinutes" => DefaultSessionExpiryMinutes,
            "PhoneNumberPoolCountries" => PhoneNumberPoolCountries,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_proxy(
    DefaultSessionExpiryMinutes,
    PhoneNumberPoolCountries,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/programmable-numbers/proxy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DefaultSessionExpiryMinutes" => DefaultSessionExpiryMinutes,
                    "PhoneNumberPoolCountries" => PhoneNumberPoolCountries,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_streaming_configuration(streaming_configuration, voice_connector_id)
    put_voice_connector_streaming_configuration(streaming_configuration, voice_connector_id, params::Dict{String,<:Any})

Adds a streaming configuration for the specified Amazon Chime Voice Connector. The
streaming configuration specifies whether media streaming is enabled for sending to
Kinesis. It also sets the retention period, in hours, for the Amazon Kinesis data.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, PutVoiceConnectorStreamingConfiguration, in the Amazon Chime SDK. Using the latest
version requires migrating to a dedicated namespace. For more information, refer to
Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `streaming_configuration`: The streaming configuration details to add.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function put_voice_connector_streaming_configuration(
    StreamingConfiguration,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        Dict{String,Any}("StreamingConfiguration" => StreamingConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_streaming_configuration(
    StreamingConfiguration,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/streaming-configuration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("StreamingConfiguration" => StreamingConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_termination(termination, voice_connector_id)
    put_voice_connector_termination(termination, voice_connector_id, params::Dict{String,<:Any})

Adds termination settings for the specified Amazon Chime Voice Connector.  If emergency
calling is configured for the Amazon Chime Voice Connector, it must be deleted prior to
turning off termination settings.    This API is is no longer supported and will not be
updated. We recommend using the latest version, PutVoiceConnectorTermination, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `termination`: The termination setting details to add.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function put_voice_connector_termination(
    Termination, voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/termination",
        Dict{String,Any}("Termination" => Termination);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_termination(
    Termination,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)/termination",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Termination" => Termination), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_voice_connector_termination_credentials(voice_connector_id)
    put_voice_connector_termination_credentials(voice_connector_id, params::Dict{String,<:Any})

Adds termination SIP credentials for the specified Amazon Chime Voice Connector.   This API
is is no longer supported and will not be updated. We recommend using the latest version,
PutVoiceConnectorTerminationCredentials, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Credentials"`: The termination SIP credentials.
"""
function put_voice_connector_termination_credentials(
    voiceConnectorId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=put";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_voice_connector_termination_credentials(
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/termination/credentials?operation=put",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    redact_channel_message(channel_arn, message_id)
    redact_channel_message(channel_arn, message_id, params::Dict{String,<:Any})

Redacts message content, but not metadata. The message exists in the back end, but the
action returns null content, and the state shows as redacted.  The x-amz-chime-bearer
request header is mandatory. Use the AppInstanceUserArn of the user that makes the API call
as the value in the header.    This API is is no longer supported and will not be updated.
We recommend using the latest version, RedactChannelMessage, in the Amazon Chime SDK. Using
the latest version requires migrating to a dedicated namespace. For more information, refer
to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel containing the messages that you want to redact.
- `message_id`: The ID of the message being redacted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function redact_channel_message(
    channelArn, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/channels/$(channelArn)/messages/$(messageId)?operation=redact";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function redact_channel_message(
    channelArn,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/messages/$(messageId)?operation=redact",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    redact_conversation_message(account_id, conversation_id, message_id)
    redact_conversation_message(account_id, conversation_id, message_id, params::Dict{String,<:Any})

Redacts the specified message from the specified Amazon Chime conversation.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `conversation_id`: The conversation ID.
- `message_id`: The message ID.

"""
function redact_conversation_message(
    accountId, conversationId, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/conversations/$(conversationId)/messages/$(messageId)?operation=redact";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function redact_conversation_message(
    accountId,
    conversationId,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/conversations/$(conversationId)/messages/$(messageId)?operation=redact",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    redact_room_message(account_id, message_id, room_id)
    redact_room_message(account_id, message_id, room_id, params::Dict{String,<:Any})

Redacts the specified message from the specified Amazon Chime channel.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `message_id`: The message ID.
- `room_id`: The room ID.

"""
function redact_room_message(
    accountId, messageId, roomId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/messages/$(messageId)?operation=redact";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function redact_room_message(
    accountId,
    messageId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/messages/$(messageId)?operation=redact",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    regenerate_security_token(account_id, bot_id)
    regenerate_security_token(account_id, bot_id, params::Dict{String,<:Any})

Regenerates the security token for a bot.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

"""
function regenerate_security_token(
    accountId, botId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/bots/$(botId)?operation=regenerate-security-token";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function regenerate_security_token(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/bots/$(botId)?operation=regenerate-security-token",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_personal_pin(account_id, user_id)
    reset_personal_pin(account_id, user_id, params::Dict{String,<:Any})

Resets the personal meeting PIN for the specified user on an Amazon Chime account. Returns
the User object with the updated personal meeting PIN.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function reset_personal_pin(
    accountId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=reset-personal-pin";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_personal_pin(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)?operation=reset-personal-pin",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_phone_number(phone_number_id)
    restore_phone_number(phone_number_id, params::Dict{String,<:Any})

Moves a phone number from the Deletion queue back into the phone number Inventory.

# Arguments
- `phone_number_id`: The phone number.

"""
function restore_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/phone-numbers/$(phoneNumberId)?operation=restore";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/phone-numbers/$(phoneNumberId)?operation=restore",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_available_phone_numbers()
    search_available_phone_numbers(params::Dict{String,<:Any})

Searches for phone numbers that can be ordered. For US numbers, provide at least one of the
following search filters: AreaCode, City, State, or TollFreePrefix. If you provide City,
you must also provide State. Numbers outside the US only support the PhoneNumberType
filter, which you must use.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"area-code"`: The area code used to filter results. Only applies to the US.
- `"city"`: The city used to filter results. Only applies to the US.
- `"country"`: The country used to filter results. Defaults to the US Format: ISO 3166-1
  alpha-2.
- `"max-results"`: The maximum number of results to return in a single call.
- `"next-token"`: The token used to retrieve the next page of results.
- `"phone-number-type"`: The phone number type used to filter results. Required for non-US
  numbers.
- `"state"`: The state used to filter results. Required only if you provide City. Only
  applies to the US.
- `"toll-free-prefix"`: The toll-free prefix that you use to filter results. Only applies
  to the US.
"""
function search_available_phone_numbers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/search?type=phone-numbers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_available_phone_numbers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "GET",
        "/search?type=phone-numbers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    send_channel_message(client_request_token, content, persistence, type, channel_arn)
    send_channel_message(client_request_token, content, persistence, type, channel_arn, params::Dict{String,<:Any})

Sends a message to a particular channel that the member is a part of.  The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header. Also, STANDARD messages can contain 4KB of
data and the 1KB of metadata. CONTROL messages can contain 30 bytes of data and no
metadata.    This API is is no longer supported and will not be updated. We recommend using
the latest version, SendChannelMessage, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `client_request_token`: The Idempotency token for each client request.
- `content`: The content of the message.
- `persistence`: Boolean that controls whether the message is persisted on the back end.
  Required.
- `type`: The type of message, STANDARD or CONTROL.
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The optional metadata for each message.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function send_channel_message(
    ClientRequestToken,
    Content,
    Persistence,
    Type,
    channelArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/messages",
        Dict{String,Any}(
            "ClientRequestToken" => ClientRequestToken,
            "Content" => Content,
            "Persistence" => Persistence,
            "Type" => Type,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function send_channel_message(
    ClientRequestToken,
    Content,
    Persistence,
    Type,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/channels/$(channelArn)/messages",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientRequestToken" => ClientRequestToken,
                    "Content" => Content,
                    "Persistence" => Persistence,
                    "Type" => Type,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_meeting_transcription(transcription_configuration, meeting_id)
    start_meeting_transcription(transcription_configuration, meeting_id, params::Dict{String,<:Any})

Starts transcription for the specified meetingId. For more information, refer to  Using
Amazon Chime SDK live transcription  in the Amazon Chime SDK Developer Guide. If you
specify an invalid configuration, a TranscriptFailed event will be sent with the contents
of the BadRequestException generated by Amazon Transcribe. For more information on each
parameter and which combinations are valid, refer to the StartStreamTranscription API in
the Amazon Transcribe Developer Guide.  Amazon Chime SDK live transcription is powered by
Amazon Transcribe. Use of Amazon Transcribe is subject to the AWS Service Terms, including
the terms specific to the AWS Machine Learning and Artificial Intelligence Services.
This API is is no longer supported and will not be updated. We recommend using the latest
version, StartMeetingTranscription, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `transcription_configuration`: The configuration for the current transcription operation.
  Must contain EngineTranscribeSettings or EngineTranscribeMedicalSettings.
- `meeting_id`: The unique ID of the meeting being transcribed.

"""
function start_meeting_transcription(
    TranscriptionConfiguration,
    meetingId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/transcription?operation=start",
        Dict{String,Any}("TranscriptionConfiguration" => TranscriptionConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_meeting_transcription(
    TranscriptionConfiguration,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/transcription?operation=start",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TranscriptionConfiguration" => TranscriptionConfiguration
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_meeting_transcription(meeting_id)
    stop_meeting_transcription(meeting_id, params::Dict{String,<:Any})

Stops transcription for the specified meetingId.   This API is is no longer supported and
will not be updated. We recommend using the latest version, StopMeetingTranscription, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `meeting_id`: The unique ID of the meeting for which you stop transcription.

"""
function stop_meeting_transcription(
    meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/transcription?operation=stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_meeting_transcription(
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/transcription?operation=stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_attendee(tags, attendee_id, meeting_id)
    tag_attendee(tags, attendee_id, meeting_id, params::Dict{String,<:Any})

Applies the specified tags to the specified Amazon Chime attendee.  TagAttendee is not
supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove
calls to this API.

# Arguments
- `tags`: The tag key-value pairs.
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function tag_attendee(
    Tags, attendeeId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags?operation=add",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_attendee(
    Tags,
    attendeeId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags?operation=add",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_meeting(tags, meeting_id)
    tag_meeting(tags, meeting_id, params::Dict{String,<:Any})

Applies the specified tags to the specified Amazon Chime SDK meeting.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
TagResource, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `tags`: The tag key-value pairs.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function tag_meeting(Tags, meetingId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/meetings/$(meetingId)/tags?operation=add",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_meeting(
    Tags,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/tags?operation=add",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Applies the specified tags to the specified Amazon Chime SDK meeting resource.   This API
is is no longer supported and will not be updated. We recommend using the latest version,
TagResource, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `resource_arn`: The resource ARN.
- `tags`: The tag key-value pairs.

"""
function tag_resource(ResourceARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/tags?operation=tag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "Tags" => Tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_attendee(tag_keys, attendee_id, meeting_id)
    untag_attendee(tag_keys, attendee_id, meeting_id, params::Dict{String,<:Any})

Untags the specified tags from the specified Amazon Chime SDK attendee.  UntagAttendee is
not supported in the Amazon Chime SDK Meetings Namespace. Update your application to remove
calls to this API.

# Arguments
- `tag_keys`: The tag keys.
- `attendee_id`: The Amazon Chime SDK attendee ID.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function untag_attendee(
    TagKeys, attendeeId, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags?operation=delete",
        Dict{String,Any}("TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_attendee(
    TagKeys,
    attendeeId,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/attendees/$(attendeeId)/tags?operation=delete",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKeys" => TagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_meeting(tag_keys, meeting_id)
    untag_meeting(tag_keys, meeting_id, params::Dict{String,<:Any})

Untags the specified tags from the specified Amazon Chime SDK meeting.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
UntagResource, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `tag_keys`: The tag keys.
- `meeting_id`: The Amazon Chime SDK meeting ID.

"""
function untag_meeting(
    TagKeys, meetingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/tags?operation=delete",
        Dict{String,Any}("TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_meeting(
    TagKeys,
    meetingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/meetings/$(meetingId)/tags?operation=delete",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("TagKeys" => TagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Untags the specified tags from the specified Amazon Chime SDK meeting resource. Applies the
specified tags to the specified Amazon Chime SDK meeting resource.   This API is is no
longer supported and will not be updated. We recommend using the latest version,
UntagResource, in the Amazon Chime SDK. Using the latest version requires migrating to a
dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `resource_arn`: The resource ARN.
- `tag_keys`: The tag keys.

"""
function untag_resource(
    ResourceARN, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceARN,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/tags?operation=untag-resource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceARN" => ResourceARN, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account(account_id)
    update_account(account_id, params::Dict{String,<:Any})

Updates account details for the specified Amazon Chime account. Currently, only account
name and default license updates are supported for this action.

# Arguments
- `account_id`: The Amazon Chime account ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DefaultLicense"`: The default license applied when you add users to an Amazon Chime
  account.
- `"Name"`: The new name for the specified Amazon Chime account.
"""
function update_account(accountId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account(
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_account_settings(account_settings, account_id)
    update_account_settings(account_settings, account_id, params::Dict{String,<:Any})

Updates the settings for the specified Amazon Chime account. You can update settings for
remote control of shared screens, or for the dial-out option. For more information about
these settings, see Use the Policies Page in the Amazon Chime Administration Guide.

# Arguments
- `account_settings`: The Amazon Chime account settings to update.
- `account_id`: The Amazon Chime account ID.

"""
function update_account_settings(
    AccountSettings, accountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/settings",
        Dict{String,Any}("AccountSettings" => AccountSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_account_settings(
    AccountSettings,
    accountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/settings",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AccountSettings" => AccountSettings), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_instance(name, app_instance_arn)
    update_app_instance(name, app_instance_arn, params::Dict{String,<:Any})

Updates AppInstance metadata.   This API is is no longer supported and will not be updated.
We recommend using the latest version, UpdateAppInstance, in the Amazon Chime SDK. Using
the latest version requires migrating to a dedicated namespace. For more information, refer
to Migrating from the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name that you want to change.
- `app_instance_arn`: The ARN of the AppInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The metadata that you want to change.
"""
function update_app_instance(
    Name, appInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_instance(
    Name,
    appInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instances/$(appInstanceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_app_instance_user(name, app_instance_user_arn)
    update_app_instance_user(name, app_instance_user_arn, params::Dict{String,<:Any})

Updates the details of an AppInstanceUser. You can update names and metadata.   This API is
is no longer supported and will not be updated. We recommend using the latest version,
UpdateAppInstanceUser, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name of the AppInstanceUser.
- `app_instance_user_arn`: The ARN of the AppInstanceUser.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The metadata of the AppInstanceUser.
"""
function update_app_instance_user(
    Name, appInstanceUserArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/app-instance-users/$(appInstanceUserArn)",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_app_instance_user(
    Name,
    appInstanceUserArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/app-instance-users/$(appInstanceUserArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_bot(account_id, bot_id)
    update_bot(account_id, bot_id, params::Dict{String,<:Any})

Updates the status of the specified bot, such as starting or stopping the bot from running
in your Amazon Chime Enterprise account.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `bot_id`: The bot ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: When true, stops the specified bot from running in your account.
"""
function update_bot(accountId, botId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/bots/$(botId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_bot(
    accountId,
    botId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/bots/$(botId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_channel(mode, name, channel_arn)
    update_channel(mode, name, channel_arn, params::Dict{String,<:Any})

Update a channel's attributes.  Restriction: You can't change a channel's privacy.   The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version, UpdateChannel, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `mode`: The mode of the update request.
- `name`: The name of the channel.
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Metadata"`: The metadata for the update request.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function update_channel(
    Mode, Name, channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/channels/$(channelArn)",
        Dict{String,Any}("Mode" => Mode, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_channel(
    Mode,
    Name,
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/channels/$(channelArn)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Mode" => Mode, "Name" => Name), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_channel_message(channel_arn, message_id)
    update_channel_message(channel_arn, message_id, params::Dict{String,<:Any})

Updates the content of a message.  The x-amz-chime-bearer request header is mandatory. Use
the AppInstanceUserArn of the user that makes the API call as the value in the header.
This API is is no longer supported and will not be updated. We recommend using the latest
version, UpdateChannelMessage, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.
- `message_id`: The ID string of the message being updated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content"`: The content of the message being updated.
- `"Metadata"`: The metadata of the message being updated.
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function update_channel_message(
    channelArn, messageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/channels/$(channelArn)/messages/$(messageId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_channel_message(
    channelArn,
    messageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/channels/$(channelArn)/messages/$(messageId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_channel_read_marker(channel_arn)
    update_channel_read_marker(channel_arn, params::Dict{String,<:Any})

The details of the time when a user last read messages in a channel.  The
x-amz-chime-bearer request header is mandatory. Use the AppInstanceUserArn of the user that
makes the API call as the value in the header.    This API is is no longer supported and
will not be updated. We recommend using the latest version, UpdateChannelReadMarker, in the
Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace. For
more information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime
SDK Developer Guide.

# Arguments
- `channel_arn`: The ARN of the channel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"x-amz-chime-bearer"`: The AppInstanceUserArn of the user that makes the API call.
"""
function update_channel_read_marker(
    channelArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/channels/$(channelArn)/readMarker";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_channel_read_marker(
    channelArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/channels/$(channelArn)/readMarker",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_global_settings()
    update_global_settings(params::Dict{String,<:Any})

Updates global settings for the administrator's AWS account, such as Amazon Chime Business
Calling and Amazon Chime Voice Connector settings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BusinessCalling"`: The Amazon Chime Business Calling settings.
- `"VoiceConnector"`: The Amazon Chime Voice Connector settings.
"""
function update_global_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return chime("PUT", "/settings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function update_global_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT", "/settings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    update_phone_number(phone_number_id)
    update_phone_number(phone_number_id, params::Dict{String,<:Any})

Updates phone number details, such as product type or calling name, for the specified phone
number ID. You can update one phone number detail at a time. For example, you can update
either the product type or the calling name in one action. For toll-free numbers, you
cannot use the Amazon Chime Business Calling product type. For numbers outside the U.S.,
you must use the Amazon Chime SIP Media Application Dial-In product type. Updates to
outbound calling names can take 72 hours to complete. Pending updates to outbound calling
names must be complete before you can request another update.

# Arguments
- `phone_number_id`: The phone number ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CallingName"`: The outbound calling name associated with the phone number.
- `"ProductType"`: The product type.
"""
function update_phone_number(
    phoneNumberId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/phone-numbers/$(phoneNumberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_phone_number(
    phoneNumberId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/phone-numbers/$(phoneNumberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_phone_number_settings(calling_name)
    update_phone_number_settings(calling_name, params::Dict{String,<:Any})

Updates the phone number settings for the administrator's AWS account, such as the default
outbound calling name. You can update the default outbound calling name once every seven
days. Outbound calling names can take up to 72 hours to update.

# Arguments
- `calling_name`: The default outbound calling name for the account.

"""
function update_phone_number_settings(
    CallingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/settings/phone-number",
        Dict{String,Any}("CallingName" => CallingName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_phone_number_settings(
    CallingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/settings/phone-number",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CallingName" => CallingName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_proxy_session(capabilities, proxy_session_id, voice_connector_id)
    update_proxy_session(capabilities, proxy_session_id, voice_connector_id, params::Dict{String,<:Any})

Updates the specified proxy session details, such as voice or SMS capabilities.   This API
is is no longer supported and will not be updated. We recommend using the latest version,
UpdateProxySession, in the Amazon Chime SDK. Using the latest version requires migrating to
a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `capabilities`: The proxy session capabilities.
- `proxy_session_id`: The proxy session ID.
- `voice_connector_id`: The Amazon Chime voice connector ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExpiryMinutes"`: The number of minutes allowed for the proxy session.
"""
function update_proxy_session(
    Capabilities,
    proxySessionId,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        Dict{String,Any}("Capabilities" => Capabilities);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_proxy_session(
    Capabilities,
    proxySessionId,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/voice-connectors/$(voiceConnectorId)/proxy-sessions/$(proxySessionId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Capabilities" => Capabilities), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_room(account_id, room_id)
    update_room(account_id, room_id, params::Dict{String,<:Any})

Updates room details, such as the room name, for a room in an Amazon Chime Enterprise
account.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `room_id`: The room ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Name"`: The room name.
"""
function update_room(accountId, roomId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_room(
    accountId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_room_membership(account_id, member_id, room_id)
    update_room_membership(account_id, member_id, room_id, params::Dict{String,<:Any})

Updates room membership details, such as the member role, for a room in an Amazon Chime
Enterprise account. The member role designates whether the member is a chat room
administrator or a general chat room member. The member role can be updated only for user
IDs.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `member_id`: The member ID.
- `room_id`: The room ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Role"`: The role of the member.
"""
function update_room_membership(
    accountId, memberId, roomId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships/$(memberId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_room_membership(
    accountId,
    memberId,
    roomId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/rooms/$(roomId)/memberships/$(memberId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_media_application(sip_media_application_id)
    update_sip_media_application(sip_media_application_id, params::Dict{String,<:Any})

Updates the details of the specified SIP media application.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
UpdateSipMediaApplication, in the Amazon Chime SDK. Using the latest version requires
migrating to a dedicated namespace. For more information, refer to Migrating from the
Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `sip_media_application_id`: The SIP media application ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Endpoints"`: The new set of endpoints for the specified SIP media application.
- `"Name"`: The new name for the specified SIP media application.
"""
function update_sip_media_application(
    sipMediaApplicationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_media_application(
    sipMediaApplicationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/sip-media-applications/$(sipMediaApplicationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_media_application_call(arguments, sip_media_application_id, transaction_id)
    update_sip_media_application_call(arguments, sip_media_application_id, transaction_id, params::Dict{String,<:Any})

Invokes the AWS Lambda function associated with the SIP media application and transaction
ID in an update request. The Lambda function can then return a new set of actions.   This
API is is no longer supported and will not be updated. We recommend using the latest
version, UpdateSipMediaApplicationCall, in the Amazon Chime SDK. Using the latest version
requires migrating to a dedicated namespace. For more information, refer to Migrating from
the Amazon Chime namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `arguments`: Arguments made available to the Lambda function as part of the
  CALL_UPDATE_REQUESTED event. Can contain 0-20 key-value pairs.
- `sip_media_application_id`: The ID of the SIP media application handling the call.
- `transaction_id`: The ID of the call transaction.

"""
function update_sip_media_application_call(
    Arguments,
    sipMediaApplicationId,
    transactionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls/$(transactionId)",
        Dict{String,Any}("Arguments" => Arguments);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_media_application_call(
    Arguments,
    sipMediaApplicationId,
    transactionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/sip-media-applications/$(sipMediaApplicationId)/calls/$(transactionId)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arguments" => Arguments), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sip_rule(name, sip_rule_id)
    update_sip_rule(name, sip_rule_id, params::Dict{String,<:Any})

Updates the details of the specified SIP rule.   This API is is no longer supported and
will not be updated. We recommend using the latest version, UpdateSipRule, in the Amazon
Chime SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `name`: The new name for the specified SIP rule.
- `sip_rule_id`: The SIP rule ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Disabled"`: The new value specified to indicate whether the rule is disabled.
- `"TargetApplications"`: The new value of the list of target applications.
"""
function update_sip_rule(
    Name, sipRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/sip-rules/$(sipRuleId)",
        Dict{String,Any}("Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sip_rule(
    Name,
    sipRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/sip-rules/$(sipRuleId)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Name" => Name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user(account_id, user_id)
    update_user(account_id, user_id, params::Dict{String,<:Any})

Updates user details for a specified user ID. Currently, only LicenseType updates are
supported for this action.

# Arguments
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AlexaForBusinessMetadata"`: The Alexa for Business metadata.
- `"LicenseType"`: The user license type to update. This must be a supported license type
  for the Amazon Chime account that the user belongs to.
- `"UserType"`: The user type.
"""
function update_user(accountId, userId; aws_config::AbstractAWSConfig=current_aws_config())
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user(
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/accounts/$(accountId)/users/$(userId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_user_settings(user_settings, account_id, user_id)
    update_user_settings(user_settings, account_id, user_id, params::Dict{String,<:Any})

Updates the settings for the specified user, such as phone number settings.

# Arguments
- `user_settings`: The user settings to update.
- `account_id`: The Amazon Chime account ID.
- `user_id`: The user ID.

"""
function update_user_settings(
    UserSettings, accountId, userId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/users/$(userId)/settings",
        Dict{String,Any}("UserSettings" => UserSettings);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_user_settings(
    UserSettings,
    accountId,
    userId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/accounts/$(accountId)/users/$(userId)/settings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("UserSettings" => UserSettings), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_connector(name, require_encryption, voice_connector_id)
    update_voice_connector(name, require_encryption, voice_connector_id, params::Dict{String,<:Any})

Updates details for the specified Amazon Chime Voice Connector.   This API is is no longer
supported and will not be updated. We recommend using the latest version,
UpdateVoiceConnector, in the Amazon Chime SDK. Using the latest version requires migrating
to a dedicated namespace. For more information, refer to Migrating from the Amazon Chime
namespace in the Amazon Chime SDK Developer Guide.

# Arguments
- `name`: The name of the Amazon Chime Voice Connector.
- `require_encryption`: When enabled, requires encryption for the Amazon Chime Voice
  Connector.
- `voice_connector_id`: The Amazon Chime Voice Connector ID.

"""
function update_voice_connector(
    Name,
    RequireEncryption,
    voiceConnectorId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)",
        Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_connector(
    Name,
    RequireEncryption,
    voiceConnectorId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connectors/$(voiceConnectorId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Name" => Name, "RequireEncryption" => RequireEncryption),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_voice_connector_group(name, voice_connector_items, voice_connector_group_id)
    update_voice_connector_group(name, voice_connector_items, voice_connector_group_id, params::Dict{String,<:Any})

Updates details of the specified Amazon Chime Voice Connector group, such as the name and
Amazon Chime Voice Connector priority ranking.   This API is is no longer supported and
will not be updated. We recommend using the latest version, UpdateVoiceConnectorGroup, in
the Amazon Chime SDK. Using the latest version requires migrating to a dedicated namespace.
For more information, refer to Migrating from the Amazon Chime namespace in the Amazon
Chime SDK Developer Guide.

# Arguments
- `name`: The name of the Amazon Chime Voice Connector group.
- `voice_connector_items`: The VoiceConnectorItems to associate with the group.
- `voice_connector_group_id`: The Amazon Chime Voice Connector group ID.

"""
function update_voice_connector_group(
    Name,
    VoiceConnectorItems,
    voiceConnectorGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        Dict{String,Any}("Name" => Name, "VoiceConnectorItems" => VoiceConnectorItems);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_voice_connector_group(
    Name,
    VoiceConnectorItems,
    voiceConnectorGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "PUT",
        "/voice-connector-groups/$(voiceConnectorGroupId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name, "VoiceConnectorItems" => VoiceConnectorItems
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_e911_address(aws_account_id, city, country, postal_code, state, street_info, street_number)
    validate_e911_address(aws_account_id, city, country, postal_code, state, street_info, street_number, params::Dict{String,<:Any})

Validates an address to be used for 911 calls made with Amazon Chime Voice Connectors. You
can use validated addresses in a Presence Information Data Format Location Object file that
you include in SIP requests. That helps ensure that addresses are routed to the appropriate
Public Safety Answering Point.   This API is is no longer supported and will not be
updated. We recommend using the latest version, ValidateE911Address, in the Amazon Chime
SDK. Using the latest version requires migrating to a dedicated namespace. For more
information, refer to Migrating from the Amazon Chime namespace in the Amazon Chime SDK
Developer Guide.

# Arguments
- `aws_account_id`: The AWS account ID.
- `city`: The address city, such as Portland.
- `country`: The address country, such as US.
- `postal_code`: The address postal code, such as 04352.
- `state`: The address state, such as ME.
- `street_info`: The address street information, such as 8th Avenue.
- `street_number`: The address street number, such as 200 or 2121.

"""
function validate_e911_address(
    AwsAccountId,
    City,
    Country,
    PostalCode,
    State,
    StreetInfo,
    StreetNumber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/emergency-calling/address",
        Dict{String,Any}(
            "AwsAccountId" => AwsAccountId,
            "City" => City,
            "Country" => Country,
            "PostalCode" => PostalCode,
            "State" => State,
            "StreetInfo" => StreetInfo,
            "StreetNumber" => StreetNumber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_e911_address(
    AwsAccountId,
    City,
    Country,
    PostalCode,
    State,
    StreetInfo,
    StreetNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return chime(
        "POST",
        "/emergency-calling/address",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AwsAccountId" => AwsAccountId,
                    "City" => City,
                    "Country" => Country,
                    "PostalCode" => PostalCode,
                    "State" => State,
                    "StreetInfo" => StreetInfo,
                    "StreetNumber" => StreetNumber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
