# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: codestar_notifications
using AWS.Compat
using AWS.UUIDs

"""
    create_notification_rule(detail_type, event_type_ids, name, resource, targets)
    create_notification_rule(detail_type, event_type_ids, name, resource, targets, params::Dict{String,<:Any})

Creates a notification rule for a resource. The rule specifies the events you want
notifications about and the targets (such as Chatbot topics or Chatbot clients configured
for Slack) where you want to receive them.

# Arguments
- `detail_type`: The level of detail to include in the notifications for this resource.
  BASIC will include only the contents of the event as it would appear in Amazon CloudWatch.
  FULL will include any supplemental information provided by AWS CodeStar Notifications
  and/or the service for the resource for which the notification is created.
- `event_type_ids`: A list of event types associated with this notification rule. For a
  list of allowed events, see EventTypeSummary.
- `name`: The name for the notification rule. Notification rule names must be unique in
  your Amazon Web Services account.
- `resource`: The Amazon Resource Name (ARN) of the resource to associate with the
  notification rule. Supported resources include pipelines in CodePipeline, repositories in
  CodeCommit, and build projects in CodeBuild.
- `targets`: A list of Amazon Resource Names (ARNs) of Amazon Simple Notification Service
  topics and Chatbot clients to associate with the notification rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: A unique, client-generated idempotency token that, when provided
  in a request, ensures the request cannot be repeated with a changed parameter. If a request
  with the same parameters is received and a token is included, the request returns
  information about the initial request that used that token.  The Amazon Web Services SDKs
  prepopulate client request tokens. If you are using an Amazon Web Services SDK, an
  idempotency token is created for you.
- `"Status"`: The status of the notification rule. The default value is ENABLED. If the
  status is set to DISABLED, notifications aren't sent for the notification rule.
- `"Tags"`: A list of tags to apply to this notification rule. Key names cannot start with
  \"aws\".
"""
function create_notification_rule(
    DetailType,
    EventTypeIds,
    Name,
    Resource,
    Targets;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/createNotificationRule",
        Dict{String,Any}(
            "DetailType" => DetailType,
            "EventTypeIds" => EventTypeIds,
            "Name" => Name,
            "Resource" => Resource,
            "Targets" => Targets,
            "ClientRequestToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_notification_rule(
    DetailType,
    EventTypeIds,
    Name,
    Resource,
    Targets,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/createNotificationRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DetailType" => DetailType,
                    "EventTypeIds" => EventTypeIds,
                    "Name" => Name,
                    "Resource" => Resource,
                    "Targets" => Targets,
                    "ClientRequestToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_notification_rule(arn)
    delete_notification_rule(arn, params::Dict{String,<:Any})

Deletes a notification rule for a resource.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule you want to delete.

"""
function delete_notification_rule(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/deleteNotificationRule",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_notification_rule(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/deleteNotificationRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_target(target_address)
    delete_target(target_address, params::Dict{String,<:Any})

Deletes a specified target for notifications.

# Arguments
- `target_address`: The Amazon Resource Name (ARN) of the Chatbot topic or Chatbot client
  to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceUnsubscribeAll"`: A Boolean value that can be used to delete all associations with
  this Chatbot topic. The default value is FALSE. If set to TRUE, all associations between
  that target and every notification rule in your Amazon Web Services account are deleted.
"""
function delete_target(TargetAddress; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/deleteTarget",
        Dict{String,Any}("TargetAddress" => TargetAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_target(
    TargetAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/deleteTarget",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TargetAddress" => TargetAddress), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_notification_rule(arn)
    describe_notification_rule(arn, params::Dict{String,<:Any})

Returns information about a specified notification rule.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule.

"""
function describe_notification_rule(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/describeNotificationRule",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_notification_rule(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/describeNotificationRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_event_types()
    list_event_types(params::Dict{String,<:Any})

Returns information about the event types available for configuring notifications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: The filters to use to return information by service or resource type.
- `"MaxResults"`: A non-negative integer used to limit the number of returned results. The
  default number is 50. The maximum number of results that can be returned is 100.
- `"NextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_event_types(; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST", "/listEventTypes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_event_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/listEventTypes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_notification_rules()
    list_notification_rules(params::Dict{String,<:Any})

Returns a list of the notification rules for an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: The filters to use to return information by service or resource type. For
  valid values, see ListNotificationRulesFilter.  A filter with the same name can appear more
  than once when used with OR statements. Filters with different names should be applied with
  AND statements.
- `"MaxResults"`: A non-negative integer used to limit the number of returned results. The
  maximum number of results that can be returned is 100.
- `"NextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_notification_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/listNotificationRules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_notification_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/listNotificationRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

Returns a list of the tags associated with a notification rule.

# Arguments
- `arn`: The Amazon Resource Name (ARN) for the notification rule.

"""
function list_tags_for_resource(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/listTagsForResource",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/listTagsForResource",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_targets()
    list_targets(params::Dict{String,<:Any})

Returns a list of the notification rule targets for an Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: The filters to use to return information by service or resource type. Valid
  filters include target type, target address, and target status.  A filter with the same
  name can appear more than once when used with OR statements. Filters with different names
  should be applied with AND statements.
- `"MaxResults"`: A non-negative integer used to limit the number of returned results. The
  maximum number of results that can be returned is 100.
- `"NextToken"`: An enumeration token that, when provided in a request, returns the next
  batch of the results.
"""
function list_targets(; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST", "/listTargets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_targets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/listTargets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    subscribe(arn, target)
    subscribe(arn, target, params::Dict{String,<:Any})

Creates an association between a notification rule and an Chatbot topic or Chatbot client
so that the associated target can receive notifications when the events described in the
rule are triggered.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule for which you want to
  create the association.
- `target`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientRequestToken"`: An enumeration token that, when provided in a request, returns
  the next batch of the results.
"""
function subscribe(Arn, Target; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/subscribe",
        Dict{String,Any}("Arn" => Arn, "Target" => Target);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function subscribe(
    Arn,
    Target,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/subscribe",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arn" => Arn, "Target" => Target), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(arn, tags)
    tag_resource(arn, tags, params::Dict{String,<:Any})

Associates a set of provided tags with a notification rule.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule to tag.
- `tags`: The list of tags to associate with the resource. Tag key names cannot start with
  \"aws\".

"""
function tag_resource(Arn, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/tagResource",
        Dict{String,Any}("Arn" => Arn, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Arn,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/tagResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Arn" => Arn, "Tags" => Tags), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unsubscribe(arn, target_address)
    unsubscribe(arn, target_address, params::Dict{String,<:Any})

Removes an association between a notification rule and an Chatbot topic so that subscribers
to that topic stop receiving notifications when the events described in the rule are
triggered.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule.
- `target_address`: The ARN of the Chatbot topic to unsubscribe from the notification rule.

"""
function unsubscribe(Arn, TargetAddress; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/unsubscribe",
        Dict{String,Any}("Arn" => Arn, "TargetAddress" => TargetAddress);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unsubscribe(
    Arn,
    TargetAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/unsubscribe",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Arn" => Arn, "TargetAddress" => TargetAddress),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes the association between one or more provided tags and a notification rule.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the notification rule from which to
  remove the tags.
- `tag_keys`: The key names of the tags to remove.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/untagResource/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return codestar_notifications(
        "POST",
        "/untagResource/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_notification_rule(arn)
    update_notification_rule(arn, params::Dict{String,<:Any})

Updates a notification rule for a resource. You can change the events that trigger the
notification rule, the status of the rule, and the targets that receive the notifications.
To add or remove tags for a notification rule, you must use TagResource and UntagResource.

# Arguments
- `arn`: The Amazon Resource Name (ARN) of the notification rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DetailType"`: The level of detail to include in the notifications for this resource.
  BASIC will include only the contents of the event as it would appear in Amazon CloudWatch.
  FULL will include any supplemental information provided by AWS CodeStar Notifications
  and/or the service for the resource for which the notification is created.
- `"EventTypeIds"`: A list of event types associated with this notification rule. For a
  complete list of event types and IDs, see Notification concepts in the Developer Tools
  Console User Guide.
- `"Name"`: The name of the notification rule.
- `"Status"`: The status of the notification rule. Valid statuses include enabled (sending
  notifications) or disabled (not sending notifications).
- `"Targets"`: The address and type of the targets to receive notifications from this
  notification rule.
"""
function update_notification_rule(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return codestar_notifications(
        "POST",
        "/updateNotificationRule",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_notification_rule(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return codestar_notifications(
        "POST",
        "/updateNotificationRule",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
