# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: compute_optimizer
using AWS.Compat
using AWS.UUIDs

"""
    delete_recommendation_preferences(recommendation_preference_names, resource_type)
    delete_recommendation_preferences(recommendation_preference_names, resource_type, params::Dict{String,<:Any})

Deletes a recommendation preference, such as enhanced infrastructure metrics. For more
information, see Activating enhanced infrastructure metrics in the Compute Optimizer User
Guide.

# Arguments
- `recommendation_preference_names`: The name of the recommendation preference to delete.
- `resource_type`: The target resource type of the recommendation preference to delete. The
  Ec2Instance option encompasses standalone instances and instances that are part of Auto
  Scaling groups. The AutoScalingGroup option encompasses only instances that are part of an
  Auto Scaling group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"scope"`: An object that describes the scope of the recommendation preference to delete.
  You can delete recommendation preferences that are created at the organization level (for
  management accounts of an organization only), account level, and resource level. For more
  information, see Activating enhanced infrastructure metrics in the Compute Optimizer User
  Guide.
"""
function delete_recommendation_preferences(
    recommendationPreferenceNames,
    resourceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "DeleteRecommendationPreferences",
        Dict{String,Any}(
            "recommendationPreferenceNames" => recommendationPreferenceNames,
            "resourceType" => resourceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_recommendation_preferences(
    recommendationPreferenceNames,
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "DeleteRecommendationPreferences",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "recommendationPreferenceNames" => recommendationPreferenceNames,
                    "resourceType" => resourceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_recommendation_export_jobs()
    describe_recommendation_export_jobs(params::Dict{String,<:Any})

Describes recommendation export jobs created in the last seven days. Use the
ExportAutoScalingGroupRecommendations or ExportEC2InstanceRecommendations actions to
request an export of your recommendations. Then use the DescribeRecommendationExportJobs
action to view your export jobs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  export jobs.
- `"jobIds"`: The identification numbers of the export jobs to return. An export job ID is
  returned when you create an export using the ExportAutoScalingGroupRecommendations or
  ExportEC2InstanceRecommendations actions. All export jobs created in the last seven days
  are returned if this parameter is omitted.
- `"maxResults"`: The maximum number of export jobs to return with a single request. To
  retrieve the remaining results, make another request with the returned nextToken value.
- `"nextToken"`: The token to advance to the next page of export jobs.
"""
function describe_recommendation_export_jobs(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "DescribeRecommendationExportJobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_recommendation_export_jobs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "DescribeRecommendationExportJobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_auto_scaling_group_recommendations(s3_destination_config)
    export_auto_scaling_group_recommendations(s3_destination_config, params::Dict{String,<:Any})

Exports optimization recommendations for Auto Scaling groups. Recommendations are exported
in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation
(JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that
you specify. For more information, see Exporting Recommendations in the Compute Optimizer
User Guide. You can have only one Auto Scaling group export job in progress per Amazon Web
Services Region.

# Arguments
- `s3_destination_config`: An object to specify the destination Amazon Simple Storage
  Service (Amazon S3) bucket name and key prefix for the export job. You must create the
  destination Amazon S3 bucket for your recommendations export before you create the export
  job. Compute Optimizer does not create the S3 bucket for you. After you create the S3
  bucket, ensure that it has the required permissions policy to allow Compute Optimizer to
  write the export file to it. If you plan to specify an object prefix when you create the
  export job, you must include the object prefix in the policy that you add to the S3 bucket.
  For more information, see Amazon S3 Bucket Policy for Compute Optimizer in the Compute
  Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The IDs of the Amazon Web Services accounts for which to export Auto
  Scaling group recommendations. If your account is the management account of an
  organization, use this parameter to specify the member account for which you want to export
  recommendations. This parameter cannot be specified together with the include member
  accounts parameter. The parameters are mutually exclusive. Recommendations for member
  accounts are not included in the export if this parameter, or the include member accounts
  parameter, is omitted. You can specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`: The format of the export file. The only export file format currently
  supported is Csv.
- `"filters"`: An array of objects to specify a filter that exports a more specific set of
  Auto Scaling group recommendations.
- `"includeMemberAccounts"`: Indicates whether to include recommendations for resources in
  all member accounts of the organization if your account is the management account of an
  organization. The member accounts must also be opted in to Compute Optimizer, and trusted
  access for Compute Optimizer must be enabled in the organization account. For more
  information, see Compute Optimizer and Amazon Web Services Organizations trusted access in
  the Compute Optimizer User Guide. Recommendations for member accounts of the organization
  are not included in the export file if this parameter is omitted. This parameter cannot be
  specified together with the account IDs parameter. The parameters are mutually exclusive.
  Recommendations for member accounts are not included in the export if this parameter, or
  the account IDs parameter, is omitted.
- `"recommendationPreferences"`: An object to specify the preferences for the Auto Scaling
  group recommendations to export.
"""
function export_auto_scaling_group_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportAutoScalingGroupRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_auto_scaling_group_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportAutoScalingGroupRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_ebsvolume_recommendations(s3_destination_config)
    export_ebsvolume_recommendations(s3_destination_config, params::Dict{String,<:Any})

Exports optimization recommendations for Amazon EBS volumes. Recommendations are exported
in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation
(JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that
you specify. For more information, see Exporting Recommendations in the Compute Optimizer
User Guide. You can have only one Amazon EBS volume export job in progress per Amazon Web
Services Region.

# Arguments
- `s3_destination_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The IDs of the Amazon Web Services accounts for which to export Amazon
  EBS volume recommendations. If your account is the management account of an organization,
  use this parameter to specify the member account for which you want to export
  recommendations. This parameter cannot be specified together with the include member
  accounts parameter. The parameters are mutually exclusive. Recommendations for member
  accounts are not included in the export if this parameter, or the include member accounts
  parameter, is omitted. You can specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`: The format of the export file. The only export file format currently
  supported is Csv.
- `"filters"`: An array of objects to specify a filter that exports a more specific set of
  Amazon EBS volume recommendations.
- `"includeMemberAccounts"`: Indicates whether to include recommendations for resources in
  all member accounts of the organization if your account is the management account of an
  organization. The member accounts must also be opted in to Compute Optimizer, and trusted
  access for Compute Optimizer must be enabled in the organization account. For more
  information, see Compute Optimizer and Amazon Web Services Organizations trusted access in
  the Compute Optimizer User Guide. Recommendations for member accounts of the organization
  are not included in the export file if this parameter is omitted. This parameter cannot be
  specified together with the account IDs parameter. The parameters are mutually exclusive.
  Recommendations for member accounts are not included in the export if this parameter, or
  the account IDs parameter, is omitted.
"""
function export_ebsvolume_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportEBSVolumeRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_ebsvolume_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportEBSVolumeRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_ec2_instance_recommendations(s3_destination_config)
    export_ec2_instance_recommendations(s3_destination_config, params::Dict{String,<:Any})

Exports optimization recommendations for Amazon EC2 instances. Recommendations are exported
in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation
(JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that
you specify. For more information, see Exporting Recommendations in the Compute Optimizer
User Guide. You can have only one Amazon EC2 instance export job in progress per Amazon Web
Services Region.

# Arguments
- `s3_destination_config`: An object to specify the destination Amazon Simple Storage
  Service (Amazon S3) bucket name and key prefix for the export job. You must create the
  destination Amazon S3 bucket for your recommendations export before you create the export
  job. Compute Optimizer does not create the S3 bucket for you. After you create the S3
  bucket, ensure that it has the required permissions policy to allow Compute Optimizer to
  write the export file to it. If you plan to specify an object prefix when you create the
  export job, you must include the object prefix in the policy that you add to the S3 bucket.
  For more information, see Amazon S3 Bucket Policy for Compute Optimizer in the Compute
  Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The IDs of the Amazon Web Services accounts for which to export instance
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to export recommendations. This
  parameter cannot be specified together with the include member accounts parameter. The
  parameters are mutually exclusive. Recommendations for member accounts are not included in
  the export if this parameter, or the include member accounts parameter, is omitted. You can
  specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`: The format of the export file. The only export file format currently
  supported is Csv.
- `"filters"`: An array of objects to specify a filter that exports a more specific set of
  instance recommendations.
- `"includeMemberAccounts"`: Indicates whether to include recommendations for resources in
  all member accounts of the organization if your account is the management account of an
  organization. The member accounts must also be opted in to Compute Optimizer, and trusted
  access for Compute Optimizer must be enabled in the organization account. For more
  information, see Compute Optimizer and Amazon Web Services Organizations trusted access in
  the Compute Optimizer User Guide. Recommendations for member accounts of the organization
  are not included in the export file if this parameter is omitted. Recommendations for
  member accounts are not included in the export if this parameter, or the account IDs
  parameter, is omitted.
- `"recommendationPreferences"`: An object to specify the preferences for the Amazon EC2
  instance recommendations to export.
"""
function export_ec2_instance_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportEC2InstanceRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_ec2_instance_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportEC2InstanceRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_ecsservice_recommendations(s3_destination_config)
    export_ecsservice_recommendations(s3_destination_config, params::Dict{String,<:Any})

 Exports optimization recommendations for Amazon ECS services on Fargate.  Recommendations
are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple
Storage Service (Amazon S3) bucket that you specify. For more information, see Exporting
Recommendations in the Compute Optimizer User Guide. You can only have one Amazon ECS
service export job in progress per Amazon Web Services Region.

# Arguments
- `s3_destination_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`:  The Amazon Web Services account IDs for the export Amazon ECS service
  recommendations.  If your account is the management account or the delegated administrator
  of an organization, use this parameter to specify the member account you want to export
  recommendations to. This parameter can't be specified together with the include member
  accounts parameter. The parameters are mutually exclusive. If this parameter or the include
  member accounts parameter is omitted, the recommendations for member accounts aren't
  included in the export. You can specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`:  The format of the export file.  The CSV file is the only export file
  format currently supported.
- `"filters"`:  An array of objects to specify a filter that exports a more specific set of
  Amazon ECS service recommendations.
- `"includeMemberAccounts"`: If your account is the management account or the delegated
  administrator of an organization, this parameter indicates whether to include
  recommendations for resources in all member accounts of the organization. The member
  accounts must also be opted in to Compute Optimizer, and trusted access for Compute
  Optimizer must be enabled in the organization account. For more information, see Compute
  Optimizer and Amazon Web Services Organizations trusted access in the Compute Optimizer
  User Guide. If this parameter is omitted, recommendations for member accounts of the
  organization aren't included in the export file. If this parameter or the account ID
  parameter is omitted, recommendations for member accounts aren't included in the export.
"""
function export_ecsservice_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportECSServiceRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_ecsservice_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportECSServiceRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_lambda_function_recommendations(s3_destination_config)
    export_lambda_function_recommendations(s3_destination_config, params::Dict{String,<:Any})

Exports optimization recommendations for Lambda functions. Recommendations are exported in
a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation
(JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that
you specify. For more information, see Exporting Recommendations in the Compute Optimizer
User Guide. You can have only one Lambda function export job in progress per Amazon Web
Services Region.

# Arguments
- `s3_destination_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The IDs of the Amazon Web Services accounts for which to export Lambda
  function recommendations. If your account is the management account of an organization, use
  this parameter to specify the member account for which you want to export recommendations.
  This parameter cannot be specified together with the include member accounts parameter. The
  parameters are mutually exclusive. Recommendations for member accounts are not included in
  the export if this parameter, or the include member accounts parameter, is omitted. You can
  specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`: The format of the export file. The only export file format currently
  supported is Csv.
- `"filters"`: An array of objects to specify a filter that exports a more specific set of
  Lambda function recommendations.
- `"includeMemberAccounts"`: Indicates whether to include recommendations for resources in
  all member accounts of the organization if your account is the management account of an
  organization. The member accounts must also be opted in to Compute Optimizer, and trusted
  access for Compute Optimizer must be enabled in the organization account. For more
  information, see Compute Optimizer and Amazon Web Services Organizations trusted access in
  the Compute Optimizer User Guide. Recommendations for member accounts of the organization
  are not included in the export file if this parameter is omitted. This parameter cannot be
  specified together with the account IDs parameter. The parameters are mutually exclusive.
  Recommendations for member accounts are not included in the export if this parameter, or
  the account IDs parameter, is omitted.
"""
function export_lambda_function_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportLambdaFunctionRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_lambda_function_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportLambdaFunctionRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_license_recommendations(s3_destination_config)
    export_license_recommendations(s3_destination_config, params::Dict{String,<:Any})

 Export optimization recommendations for your licenses.  Recommendations are exported in a
comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON)
file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For
more information, see Exporting Recommendations in the Compute Optimizer User Guide. You
can have only one license export job in progress per Amazon Web Services Region.

# Arguments
- `s3_destination_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The IDs of the Amazon Web Services accounts for which to export license
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to export recommendations. This
  parameter can't be specified together with the include member accounts parameter. The
  parameters are mutually exclusive. If this parameter is omitted, recommendations for member
  accounts aren't included in the export. You can specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`: The format of the export file. A CSV file is the only export format
  currently supported.
- `"filters"`:  An array of objects to specify a filter that exports a more specific set of
  license recommendations.
- `"includeMemberAccounts"`: Indicates whether to include recommendations for resources in
  all member accounts of the organization if your account is the management account of an
  organization. The member accounts must also be opted in to Compute Optimizer, and trusted
  access for Compute Optimizer must be enabled in the organization account. For more
  information, see Compute Optimizer and Amazon Web Services Organizations trusted access in
  the Compute Optimizer User Guide. If this parameter is omitted, recommendations for member
  accounts of the organization aren't included in the export file . This parameter cannot be
  specified together with the account IDs parameter. The parameters are mutually exclusive.
"""
function export_license_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportLicenseRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_license_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportLicenseRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_rdsdatabase_recommendations(s3_destination_config)
    export_rdsdatabase_recommendations(s3_destination_config, params::Dict{String,<:Any})

 Export optimization recommendations for your Amazon Relational Database Service (Amazon
RDS).  Recommendations are exported in a comma-separated values (CSV) file, and its
metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage
Service (Amazon S3) bucket that you specify. For more information, see Exporting
Recommendations in the Compute Optimizer User Guide. You can have only one Amazon RDS
export job in progress per Amazon Web Services Region.

# Arguments
- `s3_destination_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`:  The Amazon Web Services account IDs for the export Amazon RDS
  recommendations.  If your account is the management account or the delegated administrator
  of an organization, use this parameter to specify the member account you want to export
  recommendations to. This parameter can't be specified together with the include member
  accounts parameter. The parameters are mutually exclusive. If this parameter or the include
  member accounts parameter is omitted, the recommendations for member accounts aren't
  included in the export. You can specify multiple account IDs per request.
- `"fieldsToExport"`: The recommendations data to include in the export file. For more
  information about the fields that can be exported, see Exported files in the Compute
  Optimizer User Guide.
- `"fileFormat"`:  The format of the export file.  The CSV file is the only export file
  format currently supported.
- `"filters"`:  An array of objects to specify a filter that exports a more specific set of
  Amazon RDS recommendations.
- `"includeMemberAccounts"`: If your account is the management account or the delegated
  administrator of an organization, this parameter indicates whether to include
  recommendations for resources in all member accounts of the organization. The member
  accounts must also be opted in to Compute Optimizer, and trusted access for Compute
  Optimizer must be enabled in the organization account. For more information, see Compute
  Optimizer and Amazon Web Services Organizations trusted access in the Compute Optimizer
  User Guide. If this parameter is omitted, recommendations for member accounts of the
  organization aren't included in the export file. If this parameter or the account ID
  parameter is omitted, recommendations for member accounts aren't included in the export.
- `"recommendationPreferences"`:
"""
function export_rdsdatabase_recommendations(
    s3DestinationConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "ExportRDSDatabaseRecommendations",
        Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_rdsdatabase_recommendations(
    s3DestinationConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "ExportRDSDatabaseRecommendations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("s3DestinationConfig" => s3DestinationConfig),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_auto_scaling_group_recommendations()
    get_auto_scaling_group_recommendations(params::Dict{String,<:Any})

Returns Auto Scaling group recommendations. Compute Optimizer generates recommendations for
Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more
information, see the Supported resources and requirements in the Compute Optimizer User
Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return Auto
  Scaling group recommendations. If your account is the management account of an
  organization, use this parameter to specify the member account for which you want to return
  Auto Scaling group recommendations. Only one account ID can be specified per request.
- `"autoScalingGroupArns"`: The Amazon Resource Name (ARN) of the Auto Scaling groups for
  which to return recommendations.
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  Auto Scaling group recommendations.
- `"maxResults"`: The maximum number of Auto Scaling group recommendations to return with a
  single request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of Auto Scaling group
  recommendations.
- `"recommendationPreferences"`: An object to specify the preferences for the Auto Scaling
  group recommendations to return in the response.
"""
function get_auto_scaling_group_recommendations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetAutoScalingGroupRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_auto_scaling_group_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetAutoScalingGroupRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ebsvolume_recommendations()
    get_ebsvolume_recommendations(params::Dict{String,<:Any})

Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations. Compute Optimizer
generates recommendations for Amazon EBS volumes that meet a specific set of requirements.
For more information, see the Supported resources and requirements in the Compute Optimizer
User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return volume
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to return volume
  recommendations. Only one account ID can be specified per request.
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  volume recommendations.
- `"maxResults"`: The maximum number of volume recommendations to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of volume recommendations.
- `"volumeArns"`: The Amazon Resource Name (ARN) of the volumes for which to return
  recommendations.
"""
function get_ebsvolume_recommendations(; aws_config::AbstractAWSConfig=current_aws_config())
    return compute_optimizer(
        "GetEBSVolumeRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ebsvolume_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEBSVolumeRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ec2_instance_recommendations()
    get_ec2_instance_recommendations(params::Dict{String,<:Any})

Returns Amazon EC2 instance recommendations. Compute Optimizer generates recommendations
for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of
requirements. For more information, see the Supported resources and requirements in the
Compute Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return instance
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to return instance
  recommendations. Only one account ID can be specified per request.
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  instance recommendations.
- `"instanceArns"`: The Amazon Resource Name (ARN) of the instances for which to return
  recommendations.
- `"maxResults"`: The maximum number of instance recommendations to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of instance recommendations.
- `"recommendationPreferences"`: An object to specify the preferences for the Amazon EC2
  instance recommendations to return in the response.
"""
function get_ec2_instance_recommendations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEC2InstanceRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ec2_instance_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEC2InstanceRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ec2_recommendation_projected_metrics(end_time, instance_arn, period, start_time, stat)
    get_ec2_recommendation_projected_metrics(end_time, instance_arn, period, start_time, stat, params::Dict{String,<:Any})

Returns the projected utilization metrics of Amazon EC2 instance recommendations.  The Cpu
and Memory metrics are the only projected utilization metrics returned when you run this
action. Additionally, the Memory metric is returned only for resources that have the
unified CloudWatch agent installed on them. For more information, see Enabling Memory
Utilization with the CloudWatch Agent.

# Arguments
- `end_time`: The timestamp of the last projected metrics data point to return.
- `instance_arn`: The Amazon Resource Name (ARN) of the instances for which to return
  recommendation projected metrics.
- `period`: The granularity, in seconds, of the projected metrics data points.
- `start_time`: The timestamp of the first projected metrics data point to return.
- `stat`: The statistic of the projected metrics.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"recommendationPreferences"`: An object to specify the preferences for the Amazon EC2
  recommendation projected metrics to return in the response.
"""
function get_ec2_recommendation_projected_metrics(
    endTime,
    instanceArn,
    period,
    startTime,
    stat;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetEC2RecommendationProjectedMetrics",
        Dict{String,Any}(
            "endTime" => endTime,
            "instanceArn" => instanceArn,
            "period" => period,
            "startTime" => startTime,
            "stat" => stat,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ec2_recommendation_projected_metrics(
    endTime,
    instanceArn,
    period,
    startTime,
    stat,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetEC2RecommendationProjectedMetrics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "instanceArn" => instanceArn,
                    "period" => period,
                    "startTime" => startTime,
                    "stat" => stat,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ecsservice_recommendation_projected_metrics(end_time, period, service_arn, start_time, stat)
    get_ecsservice_recommendation_projected_metrics(end_time, period, service_arn, start_time, stat, params::Dict{String,<:Any})

 Returns the projected metrics of Amazon ECS service recommendations.

# Arguments
- `end_time`:  The timestamp of the last projected metrics data point to return.
- `period`:  The granularity, in seconds, of the projected metrics data points.
- `service_arn`:  The ARN that identifies the Amazon ECS service.   The following is the
  format of the ARN:   arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name
- `start_time`:  The timestamp of the first projected metrics data point to return.
- `stat`:  The statistic of the projected metrics.

"""
function get_ecsservice_recommendation_projected_metrics(
    endTime,
    period,
    serviceArn,
    startTime,
    stat;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetECSServiceRecommendationProjectedMetrics",
        Dict{String,Any}(
            "endTime" => endTime,
            "period" => period,
            "serviceArn" => serviceArn,
            "startTime" => startTime,
            "stat" => stat,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ecsservice_recommendation_projected_metrics(
    endTime,
    period,
    serviceArn,
    startTime,
    stat,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetECSServiceRecommendationProjectedMetrics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "period" => period,
                    "serviceArn" => serviceArn,
                    "startTime" => startTime,
                    "stat" => stat,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ecsservice_recommendations()
    get_ecsservice_recommendations(params::Dict{String,<:Any})

 Returns Amazon ECS service recommendations.   Compute Optimizer generates recommendations
for Amazon ECS services on Fargate that meet a specific set of requirements. For more
information, see the Supported resources and requirements in the Compute Optimizer User
Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`:  Return the Amazon ECS service recommendations to the specified Amazon
  Web Services account IDs.  If your account is the management account or the delegated
  administrator of an organization, use this parameter to return the Amazon ECS service
  recommendations to specific member accounts. You can only specify one account ID per
  request.
- `"filters"`:  An array of objects to specify a filter that returns a more specific list
  of Amazon ECS service recommendations.
- `"maxResults"`:  The maximum number of Amazon ECS service recommendations to return with
  a single request.  To retrieve the remaining results, make another request with the
  returned nextToken value.
- `"nextToken"`:  The token to advance to the next page of Amazon ECS service
  recommendations.
- `"serviceArns"`:  The ARN that identifies the Amazon ECS service.   The following is the
  format of the ARN:   arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name
"""
function get_ecsservice_recommendations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetECSServiceRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_ecsservice_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetECSServiceRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_effective_recommendation_preferences(resource_arn)
    get_effective_recommendation_preferences(resource_arn, params::Dict{String,<:Any})

Returns the recommendation preferences that are in effect for a given resource, such as
enhanced infrastructure metrics. Considers all applicable preferences that you might have
set at the resource, account, and organization level. When you create a recommendation
preference, you can set its status to Active or Inactive. Use this action to view the
recommendation preferences that are in effect, or Active.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource for which to confirm
  effective recommendation preferences. Only EC2 instance and Auto Scaling group ARNs are
  currently supported.

"""
function get_effective_recommendation_preferences(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEffectiveRecommendationPreferences",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_effective_recommendation_preferences(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetEffectiveRecommendationPreferences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_enrollment_status()
    get_enrollment_status(params::Dict{String,<:Any})

Returns the enrollment (opt in) status of an account to the Compute Optimizer service. If
the account is the management account of an organization, this action also confirms the
enrollment status of member accounts of the organization. Use the
GetEnrollmentStatusesForOrganization action to get detailed information about the
enrollment status of member accounts of an organization.

"""
function get_enrollment_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return compute_optimizer(
        "GetEnrollmentStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_enrollment_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEnrollmentStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_enrollment_statuses_for_organization()
    get_enrollment_statuses_for_organization(params::Dict{String,<:Any})

Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts,
if your account is an organization management account. To get the enrollment status of
standalone accounts, use the GetEnrollmentStatus action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  account enrollment statuses.
- `"maxResults"`: The maximum number of account enrollment statuses to return with a single
  request. You can specify up to 100 statuses to return with each request. To retrieve the
  remaining results, make another request with the returned nextToken value.
- `"nextToken"`: The token to advance to the next page of account enrollment statuses.
"""
function get_enrollment_statuses_for_organization(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEnrollmentStatusesForOrganization";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_enrollment_statuses_for_organization(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetEnrollmentStatusesForOrganization",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lambda_function_recommendations()
    get_lambda_function_recommendations(params::Dict{String,<:Any})

Returns Lambda function recommendations. Compute Optimizer generates recommendations for
functions that meet a specific set of requirements. For more information, see the Supported
resources and requirements in the Compute Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return function
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to return function
  recommendations. Only one account ID can be specified per request.
- `"filters"`: An array of objects to specify a filter that returns a more specific list of
  function recommendations.
- `"functionArns"`: The Amazon Resource Name (ARN) of the functions for which to return
  recommendations. You can specify a qualified or unqualified ARN. If you specify an
  unqualified ARN without a function version suffix, Compute Optimizer will return
  recommendations for the latest (LATEST) version of the function. If you specify a qualified
  ARN with a version suffix, Compute Optimizer will return recommendations for the specified
  function version. For more information about using function versions, see Using versions in
  the Lambda Developer Guide.
- `"maxResults"`: The maximum number of function recommendations to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of function recommendations.
"""
function get_lambda_function_recommendations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetLambdaFunctionRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lambda_function_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetLambdaFunctionRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_license_recommendations()
    get_license_recommendations(params::Dict{String,<:Any})

Returns license recommendations for Amazon EC2 instances that run on a specific license.
Compute Optimizer generates recommendations for licenses that meet a specific set of
requirements. For more information, see the Supported resources and requirements in the
Compute Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return license
  recommendations. If your account is the management account of an organization, use this
  parameter to specify the member account for which you want to return license
  recommendations. Only one account ID can be specified per request.
- `"filters"`:  An array of objects to specify a filter that returns a more specific list
  of license recommendations.
- `"maxResults"`:  The maximum number of license recommendations to return with a single
  request.   To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`:  The token to advance to the next page of license recommendations.
- `"resourceArns"`:  The ARN that identifies the Amazon EC2 instance.   The following is
  the format of the ARN:   arn:aws:ec2:region:aws_account_id:instance/instance-id
"""
function get_license_recommendations(; aws_config::AbstractAWSConfig=current_aws_config())
    return compute_optimizer(
        "GetLicenseRecommendations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_license_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetLicenseRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rdsdatabase_recommendation_projected_metrics(end_time, period, resource_arn, start_time, stat)
    get_rdsdatabase_recommendation_projected_metrics(end_time, period, resource_arn, start_time, stat, params::Dict{String,<:Any})

 Returns the projected metrics of Amazon RDS recommendations.

# Arguments
- `end_time`:  The timestamp of the last projected metrics data point to return.
- `period`:  The granularity, in seconds, of the projected metrics data points.
- `resource_arn`:  The ARN that identifies the Amazon RDS.   The following is the format of
  the ARN:   arn:aws:rds:{region}:{accountId}:db:{resourceName}
- `start_time`:  The timestamp of the first projected metrics data point to return.
- `stat`:  The statistic of the projected metrics.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"recommendationPreferences"`:
"""
function get_rdsdatabase_recommendation_projected_metrics(
    endTime,
    period,
    resourceArn,
    startTime,
    stat;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetRDSDatabaseRecommendationProjectedMetrics",
        Dict{String,Any}(
            "endTime" => endTime,
            "period" => period,
            "resourceArn" => resourceArn,
            "startTime" => startTime,
            "stat" => stat,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rdsdatabase_recommendation_projected_metrics(
    endTime,
    period,
    resourceArn,
    startTime,
    stat,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetRDSDatabaseRecommendationProjectedMetrics",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "endTime" => endTime,
                    "period" => period,
                    "resourceArn" => resourceArn,
                    "startTime" => startTime,
                    "stat" => stat,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_rdsdatabase_recommendations()
    get_rdsdatabase_recommendations(params::Dict{String,<:Any})

 Returns Amazon RDS recommendations.  Compute Optimizer generates recommendations for
Amazon RDS that meet a specific set of requirements. For more information, see the
Supported resources and requirements in the Compute Optimizer User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`:  Return the Amazon RDS recommendations to the specified Amazon Web
  Services account IDs.  If your account is the management account or the delegated
  administrator of an organization, use this parameter to return the Amazon RDS
  recommendations to specific member accounts. You can only specify one account ID per
  request.
- `"filters"`:  An array of objects to specify a filter that returns a more specific list
  of Amazon RDS recommendations.
- `"maxResults"`: The maximum number of Amazon RDS recommendations to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`:  The token to advance to the next page of Amazon RDS recommendations.
- `"recommendationPreferences"`:
- `"resourceArns"`:  The ARN that identifies the Amazon RDS.   The following is the format
  of the ARN:   arn:aws:rds:{region}:{accountId}:db:{resourceName}   The following is the
  format of a DB Cluster ARN:   arn:aws:rds:{region}:{accountId}:cluster:{resourceName}
"""
function get_rdsdatabase_recommendations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetRDSDatabaseRecommendations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_rdsdatabase_recommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetRDSDatabaseRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_recommendation_preferences(resource_type)
    get_recommendation_preferences(resource_type, params::Dict{String,<:Any})

Returns existing recommendation preferences, such as enhanced infrastructure metrics. Use
the scope parameter to specify which preferences to return. You can specify to return
preferences for an organization, a specific account ID, or a specific EC2 instance or Auto
Scaling group Amazon Resource Name (ARN). For more information, see Activating enhanced
infrastructure metrics in the Compute Optimizer User Guide.

# Arguments
- `resource_type`: The target resource type of the recommendation preference for which to
  return preferences. The Ec2Instance option encompasses standalone instances and instances
  that are part of Auto Scaling groups. The AutoScalingGroup option encompasses only
  instances that are part of an Auto Scaling group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of recommendation preferences to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of recommendation preferences.
- `"scope"`: An object that describes the scope of the recommendation preference to return.
  You can return recommendation preferences that are created at the organization level (for
  management accounts of an organization only), account level, and resource level. For more
  information, see Activating enhanced infrastructure metrics in the Compute Optimizer User
  Guide.
"""
function get_recommendation_preferences(
    resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetRecommendationPreferences",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_recommendation_preferences(
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "GetRecommendationPreferences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_recommendation_summaries()
    get_recommendation_summaries(params::Dict{String,<:Any})

Returns the optimization findings for an account. It returns the number of:   Amazon EC2
instances in an account that are Underprovisioned, Overprovisioned, or Optimized.   Auto
Scaling groups in an account that are NotOptimized, or Optimized.   Amazon EBS volumes in
an account that are NotOptimized, or Optimized.   Lambda functions in an account that are
NotOptimized, or Optimized.   Amazon ECS services in an account that are Underprovisioned,
Overprovisioned, or Optimized.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountIds"`: The ID of the Amazon Web Services account for which to return
  recommendation summaries. If your account is the management account of an organization, use
  this parameter to specify the member account for which you want to return recommendation
  summaries. Only one account ID can be specified per request.
- `"maxResults"`: The maximum number of recommendation summaries to return with a single
  request. To retrieve the remaining results, make another request with the returned
  nextToken value.
- `"nextToken"`: The token to advance to the next page of recommendation summaries.
"""
function get_recommendation_summaries(; aws_config::AbstractAWSConfig=current_aws_config())
    return compute_optimizer(
        "GetRecommendationSummaries"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_recommendation_summaries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "GetRecommendationSummaries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_recommendation_preferences(resource_type)
    put_recommendation_preferences(resource_type, params::Dict{String,<:Any})

Creates a new recommendation preference or updates an existing recommendation preference,
such as enhanced infrastructure metrics. For more information, see Activating enhanced
infrastructure metrics in the Compute Optimizer User Guide.

# Arguments
- `resource_type`: The target resource type of the recommendation preference to create. The
  Ec2Instance option encompasses standalone instances and instances that are part of Auto
  Scaling groups. The AutoScalingGroup option encompasses only instances that are part of an
  Auto Scaling group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"enhancedInfrastructureMetrics"`: The status of the enhanced infrastructure metrics
  recommendation preference to create or update. Specify the Active status to activate the
  preference, or specify Inactive to deactivate the preference. For more information, see
  Enhanced infrastructure metrics in the Compute Optimizer User Guide.
- `"externalMetricsPreference"`: The provider of the external metrics recommendation
  preference to create or update. Specify a valid provider in the source field to activate
  the preference. To delete this preference, see the DeleteRecommendationPreferences action.
  This preference can only be set for the Ec2Instance resource type. For more information,
  see External metrics ingestion in the Compute Optimizer User Guide.
- `"inferredWorkloadTypes"`: The status of the inferred workload types recommendation
  preference to create or update.  The inferred workload type feature is active by default.
  To deactivate it, create a recommendation preference.  Specify the Inactive status to
  deactivate the feature, or specify Active to activate it. For more information, see
  Inferred workload types in the Compute Optimizer User Guide.
- `"lookBackPeriod"`:  The preference to control the number of days the utilization metrics
  of the Amazon Web Services resource are analyzed. When this preference isn't specified, we
  use the default value DAYS_14.   You can only set this preference for the Amazon EC2
  instance and Auto Scaling group resource types.
- `"preferredResources"`:  The preference to control which resource type values are
  considered when generating rightsizing recommendations. You can specify this preference as
  a combination of include and exclude lists. You must specify either an includeList or
  excludeList. If the preference is an empty set of resource type values, an error occurs.
  You can only set this preference for the Amazon EC2 instance and Auto Scaling group
  resource types.
- `"savingsEstimationMode"`:  The status of the savings estimation mode preference to
  create or update.  Specify the AfterDiscounts status to activate the preference, or specify
  BeforeDiscounts to deactivate the preference. Only the account manager or delegated
  administrator of your organization can activate this preference. For more information, see
  Savings estimation mode in the Compute Optimizer User Guide.
- `"scope"`: An object that describes the scope of the recommendation preference to create.
  You can create recommendation preferences at the organization level (for management
  accounts of an organization only), account level, and resource level. For more information,
  see Activating enhanced infrastructure metrics in the Compute Optimizer User Guide.  You
  cannot create recommendation preferences for Auto Scaling groups at the organization and
  account levels. You can create recommendation preferences for Auto Scaling groups only at
  the resource level by specifying a scope name of ResourceArn and a scope value of the Auto
  Scaling group Amazon Resource Name (ARN). This will configure the preference for all
  instances that are part of the specified Auto Scaling group. You also cannot create
  recommendation preferences at the resource level for instances that are part of an Auto
  Scaling group. You can create recommendation preferences at the resource level only for
  standalone instances.
- `"utilizationPreferences"`:  The preference to control the resource’s CPU utilization
  threshold, CPU utilization headroom, and memory utilization headroom. When this preference
  isn't specified, we use the following default values.  CPU utilization:    P99_5 for
  threshold    PERCENT_20 for headroom   Memory utilization:    PERCENT_20 for headroom
  You can only set CPU and memory utilization preferences for the Amazon EC2 instance
  resource type.   The threshold setting isn’t available for memory utilization.
"""
function put_recommendation_preferences(
    resourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "PutRecommendationPreferences",
        Dict{String,Any}("resourceType" => resourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_recommendation_preferences(
    resourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return compute_optimizer(
        "PutRecommendationPreferences",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceType" => resourceType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_enrollment_status(status)
    update_enrollment_status(status, params::Dict{String,<:Any})

Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer
service. If the account is a management account of an organization, this action can also be
used to enroll member accounts of the organization. You must have the appropriate
permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out.
For more information, see Controlling access with Amazon Web Services Identity and Access
Management in the Compute Optimizer User Guide. When you opt in, Compute Optimizer
automatically creates a service-linked role in your account to access its data. For more
information, see Using Service-Linked Roles for Compute Optimizer in the Compute Optimizer
User Guide.

# Arguments
- `status`: The new enrollment status of the account. The following status options are
  available:    Active - Opts in your account to the Compute Optimizer service. Compute
  Optimizer begins analyzing the configuration and utilization metrics of your Amazon Web
  Services resources after you opt in. For more information, see Metrics analyzed by Compute
  Optimizer in the Compute Optimizer User Guide.    Inactive - Opts out your account from the
  Compute Optimizer service. Your account's recommendations and related metrics data will be
  deleted from Compute Optimizer after you opt out.    The Pending and Failed options cannot
  be used to update the enrollment status of an account. They are returned in the response of
  a request to update the enrollment status of an account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeMemberAccounts"`: Indicates whether to enroll member accounts of the
  organization if the account is the management account of an organization.
"""
function update_enrollment_status(
    status; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "UpdateEnrollmentStatus",
        Dict{String,Any}("status" => status);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_enrollment_status(
    status, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return compute_optimizer(
        "UpdateEnrollmentStatus",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("status" => status), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
