# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: connectcampaigns
using AWS.Compat
using AWS.UUIDs

"""
    create_campaign(connect_instance_id, dialer_config, name, outbound_call_config)
    create_campaign(connect_instance_id, dialer_config, name, outbound_call_config, params::Dict{String,<:Any})

Creates a campaign for the specified Amazon Connect account. This API is idempotent.

# Arguments
- `connect_instance_id`:
- `dialer_config`:
- `name`:
- `outbound_call_config`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`:
"""
function create_campaign(
    connectInstanceId,
    dialerConfig,
    name,
    outboundCallConfig;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "PUT",
        "/campaigns",
        Dict{String,Any}(
            "connectInstanceId" => connectInstanceId,
            "dialerConfig" => dialerConfig,
            "name" => name,
            "outboundCallConfig" => outboundCallConfig,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_campaign(
    connectInstanceId,
    dialerConfig,
    name,
    outboundCallConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "PUT",
        "/campaigns",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "connectInstanceId" => connectInstanceId,
                    "dialerConfig" => dialerConfig,
                    "name" => name,
                    "outboundCallConfig" => outboundCallConfig,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_campaign(id)
    delete_campaign(id, params::Dict{String,<:Any})

Deletes a campaign from the specified Amazon Connect account.

# Arguments
- `id`:

"""
function delete_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "DELETE", "/campaigns/$(id)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "DELETE",
        "/campaigns/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connect_instance_config(connect_instance_id)
    delete_connect_instance_config(connect_instance_id, params::Dict{String,<:Any})

Deletes a connect instance config from the specified AWS account.

# Arguments
- `connect_instance_id`:

"""
function delete_connect_instance_config(
    connectInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "DELETE",
        "/connect-instance/$(connectInstanceId)/config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connect_instance_config(
    connectInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "DELETE",
        "/connect-instance/$(connectInstanceId)/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_onboarding_job(connect_instance_id)
    delete_instance_onboarding_job(connect_instance_id, params::Dict{String,<:Any})

Delete the Connect Campaigns onboarding job for the specified Amazon Connect instance.

# Arguments
- `connect_instance_id`:

"""
function delete_instance_onboarding_job(
    connectInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "DELETE",
        "/connect-instance/$(connectInstanceId)/onboarding";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_onboarding_job(
    connectInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "DELETE",
        "/connect-instance/$(connectInstanceId)/onboarding",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_campaign(id)
    describe_campaign(id, params::Dict{String,<:Any})

Describes the specific campaign.

# Arguments
- `id`:

"""
function describe_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "GET", "/campaigns/$(id)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "GET",
        "/campaigns/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_state(id)
    get_campaign_state(id, params::Dict{String,<:Any})

Get state of a campaign for the specified Amazon Connect account.

# Arguments
- `id`:

"""
function get_campaign_state(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "GET",
        "/campaigns/$(id)/state";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_state(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "GET",
        "/campaigns/$(id)/state",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_campaign_state_batch(campaign_ids)
    get_campaign_state_batch(campaign_ids, params::Dict{String,<:Any})

Get state of campaigns for the specified Amazon Connect account.

# Arguments
- `campaign_ids`:

"""
function get_campaign_state_batch(
    campaignIds; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns-state",
        Dict{String,Any}("campaignIds" => campaignIds);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_campaign_state_batch(
    campaignIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "POST",
        "/campaigns-state",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("campaignIds" => campaignIds), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connect_instance_config(connect_instance_id)
    get_connect_instance_config(connect_instance_id, params::Dict{String,<:Any})

Get the specific Connect instance config.

# Arguments
- `connect_instance_id`:

"""
function get_connect_instance_config(
    connectInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "GET",
        "/connect-instance/$(connectInstanceId)/config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connect_instance_config(
    connectInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "GET",
        "/connect-instance/$(connectInstanceId)/config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_onboarding_job_status(connect_instance_id)
    get_instance_onboarding_job_status(connect_instance_id, params::Dict{String,<:Any})

Get the specific instance onboarding job status.

# Arguments
- `connect_instance_id`:

"""
function get_instance_onboarding_job_status(
    connectInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "GET",
        "/connect-instance/$(connectInstanceId)/onboarding";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_onboarding_job_status(
    connectInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "GET",
        "/connect-instance/$(connectInstanceId)/onboarding",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_campaigns()
    list_campaigns(params::Dict{String,<:Any})

Provides summary information about the campaigns under the specified Amazon Connect account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filters"`:
- `"maxResults"`:
- `"nextToken"`:
"""
function list_campaigns(; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST", "/campaigns-summary"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_campaigns(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns-summary",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(arn)
    list_tags_for_resource(arn, params::Dict{String,<:Any})

List tags for a resource.

# Arguments
- `arn`:

"""
function list_tags_for_resource(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "GET", "/tags/$(arn)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_tags_for_resource(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "GET",
        "/tags/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    pause_campaign(id)
    pause_campaign(id, params::Dict{String,<:Any})

Pauses a campaign for the specified Amazon Connect account.

# Arguments
- `id`:

"""
function pause_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/pause";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function pause_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/pause",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_dial_request_batch(dial_requests, id)
    put_dial_request_batch(dial_requests, id, params::Dict{String,<:Any})

Creates dials requests for the specified campaign Amazon Connect account. This API is
idempotent.

# Arguments
- `dial_requests`:
- `id`:

"""
function put_dial_request_batch(
    dialRequests, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "PUT",
        "/campaigns/$(id)/dial-requests",
        Dict{String,Any}("dialRequests" => dialRequests);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_dial_request_batch(
    dialRequests,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "PUT",
        "/campaigns/$(id)/dial-requests",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("dialRequests" => dialRequests), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resume_campaign(id)
    resume_campaign(id, params::Dict{String,<:Any})

Stops a campaign for the specified Amazon Connect account.

# Arguments
- `id`:

"""
function resume_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/resume";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resume_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/resume",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_campaign(id)
    start_campaign(id, params::Dict{String,<:Any})

Starts a campaign for the specified Amazon Connect account.

# Arguments
- `id`:

"""
function start_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/start";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/start",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_instance_onboarding_job(connect_instance_id, encryption_config)
    start_instance_onboarding_job(connect_instance_id, encryption_config, params::Dict{String,<:Any})

Onboard the specific Amazon Connect instance to Connect Campaigns.

# Arguments
- `connect_instance_id`:
- `encryption_config`:

"""
function start_instance_onboarding_job(
    connectInstanceId, encryptionConfig; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "PUT",
        "/connect-instance/$(connectInstanceId)/onboarding",
        Dict{String,Any}("encryptionConfig" => encryptionConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_instance_onboarding_job(
    connectInstanceId,
    encryptionConfig,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "PUT",
        "/connect-instance/$(connectInstanceId)/onboarding",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("encryptionConfig" => encryptionConfig), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_campaign(id)
    stop_campaign(id, params::Dict{String,<:Any})

Stops a campaign for the specified Amazon Connect account.

# Arguments
- `id`:

"""
function stop_campaign(id; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/stop";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_campaign(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/stop",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(arn, tags)
    tag_resource(arn, tags, params::Dict{String,<:Any})

Tag a resource.

# Arguments
- `arn`:
- `tags`:

"""
function tag_resource(arn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/tags/$(arn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    arn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "POST",
        "/tags/$(arn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(arn, tag_keys)
    untag_resource(arn, tag_keys, params::Dict{String,<:Any})

Untag a resource.

# Arguments
- `arn`:
- `tag_keys`:

"""
function untag_resource(arn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "DELETE",
        "/tags/$(arn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    arn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "DELETE",
        "/tags/$(arn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_campaign_dialer_config(dialer_config, id)
    update_campaign_dialer_config(dialer_config, id, params::Dict{String,<:Any})

Updates the dialer config of a campaign. This API is idempotent.

# Arguments
- `dialer_config`:
- `id`:

"""
function update_campaign_dialer_config(
    dialerConfig, id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/dialer-config",
        Dict{String,Any}("dialerConfig" => dialerConfig);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_campaign_dialer_config(
    dialerConfig,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/dialer-config",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("dialerConfig" => dialerConfig), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_campaign_name(id, name)
    update_campaign_name(id, name, params::Dict{String,<:Any})

Updates the name of a campaign. This API is idempotent.

# Arguments
- `id`:
- `name`:

"""
function update_campaign_name(id, name; aws_config::AbstractAWSConfig=current_aws_config())
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/name",
        Dict{String,Any}("name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_campaign_name(
    id,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/name",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("name" => name), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_campaign_outbound_call_config(id)
    update_campaign_outbound_call_config(id, params::Dict{String,<:Any})

Updates the outbound call config of a campaign. This API is idempotent.

# Arguments
- `id`:

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"answerMachineDetectionConfig"`:
- `"connectContactFlowId"`:
- `"connectSourcePhoneNumber"`:
"""
function update_campaign_outbound_call_config(
    id; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/outbound-call-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_campaign_outbound_call_config(
    id, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return connectcampaigns(
        "POST",
        "/campaigns/$(id)/outbound-call-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
