# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: customer_profiles
using AWS.Compat
using AWS.UUIDs

"""
    add_profile_key(domain_name, key_name, profile_id, values)
    add_profile_key(domain_name, key_name, profile_id, values, params::Dict{String,<:Any})

Associates a new key value with a specific profile, such as a Contact Record ContactId. A
profile object can have a single unique key and any number of additional keys that can be
used to identify the profile that it belongs to.

# Arguments
- `domain_name`: The unique name of the domain.
- `key_name`: A searchable identifier of a customer profile. The predefined keys you can
  use include: _account, _profileId, _assetId, _caseId, _orderId, _fullName, _phone, _email,
  _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId,
  _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId,
  _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId,
  _shopifyOrderId.
- `profile_id`: The unique identifier of a customer profile.
- `values`: A list of key values.

"""
function add_profile_key(
    DomainName,
    KeyName,
    ProfileId,
    Values;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/keys",
        Dict{String,Any}(
            "KeyName" => KeyName, "ProfileId" => ProfileId, "Values" => Values
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_profile_key(
    DomainName,
    KeyName,
    ProfileId,
    Values,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/keys",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "KeyName" => KeyName, "ProfileId" => ProfileId, "Values" => Values
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_calculated_attribute_definition(attribute_details, calculated_attribute_name, domain_name, statistic)
    create_calculated_attribute_definition(attribute_details, calculated_attribute_name, domain_name, statistic, params::Dict{String,<:Any})

Creates a new calculated attribute definition. After creation, new object data ingested
into Customer Profiles will be included in the calculated attribute, which can be retrieved
for a profile using the GetCalculatedAttributeForProfile API. Defining a calculated
attribute makes it available for all profiles within a domain. Each calculated attribute
can only reference one ObjectType and at most, two fields from that ObjectType.

# Arguments
- `attribute_details`: Mathematical expression and a list of attribute items specified in
  that expression.
- `calculated_attribute_name`: The unique name of the calculated attribute.
- `domain_name`: The unique name of the domain.
- `statistic`: The aggregation operation to perform for the calculated attribute.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Conditions"`: The conditions including range, object count, and threshold for the
  calculated attribute.
- `"Description"`: The description of the calculated attribute.
- `"DisplayName"`: The display name of the calculated attribute.
- `"Tags"`: The tags used to organize, track, or control access for this resource.
"""
function create_calculated_attribute_definition(
    AttributeDetails,
    CalculatedAttributeName,
    DomainName,
    Statistic;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)",
        Dict{String,Any}("AttributeDetails" => AttributeDetails, "Statistic" => Statistic);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_calculated_attribute_definition(
    AttributeDetails,
    CalculatedAttributeName,
    DomainName,
    Statistic,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AttributeDetails" => AttributeDetails, "Statistic" => Statistic
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain(default_expiration_days, domain_name)
    create_domain(default_expiration_days, domain_name, params::Dict{String,<:Any})

Creates a domain, which is a container for all customer data, such as customer profile
attributes, object types, profile keys, and encryption keys. You can create multiple
domains, and each domain can have multiple third-party integrations. Each Amazon Connect
instance can be associated with only one domain. Multiple Amazon Connect instances can be
associated with one domain. Use this API or UpdateDomain to enable identity resolution: set
Matching to true. To prevent cross-service impersonation when you call this API, see
Cross-service confused deputy prevention for sample policies that you should apply.   It is
not possible to associate a Customer Profiles domain with an Amazon Connect Instance
directly from the API. If you would like to create a domain and associate a Customer
Profiles domain, use the Amazon Connect admin website. For more information, see Enable
Customer Profiles. Each Amazon Connect instance can be associated with only one domain.
Multiple Amazon Connect instances can be associated with one domain.

# Arguments
- `default_expiration_days`: The default number of days until the data within the domain
  expires.
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeadLetterQueueUrl"`: The URL of the SQS dead letter queue, which is used for reporting
  errors associated with ingesting data from third party applications. You must set up a
  policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect
  Customer Profiles to send messages to the DeadLetterQueue.
- `"DefaultEncryptionKey"`: The default encryption key, which is an AWS managed key, is
  used when no specific type of encryption key is specified. It is used to encrypt all data
  before it is placed in permanent or semi-permanent storage.
- `"Matching"`: The process of matching duplicate profiles. If Matching = true, Amazon
  Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If
  you do not specify a date and time for Identity Resolution Job to run, by default it runs
  every Saturday at 12AM UTC to detect duplicate profiles in your domains.  After the
  Identity Resolution Job completes, use the GetMatches API to return and review the results.
  Or, if you have configured ExportingConfig in the MatchingRequest, you can download the
  results from S3.
- `"RuleBasedMatching"`: The process of matching duplicate profiles using the Rule-Based
  matching. If RuleBasedMatching = true, Amazon Connect Customer Profiles will start to match
  and merge your profiles according to your configuration in the RuleBasedMatchingRequest.
  You can use the ListRuleBasedMatches and GetSimilarProfiles API to return and review the
  results. Also, if you have configured ExportingConfig in the RuleBasedMatchingRequest, you
  can download the results from S3.
- `"Tags"`: The tags used to organize, track, or control access for this resource.
"""
function create_domain(
    DefaultExpirationDays, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)",
        Dict{String,Any}("DefaultExpirationDays" => DefaultExpirationDays);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain(
    DefaultExpirationDays,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DefaultExpirationDays" => DefaultExpirationDays),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_stream(domain_name, event_stream_name, uri)
    create_event_stream(domain_name, event_stream_name, uri, params::Dict{String,<:Any})

Creates an event stream, which is a subscription to real-time events, such as when profiles
are created and updated through Amazon Connect Customer Profiles. Each event stream can be
associated with only one Kinesis Data Stream destination in the same region and Amazon Web
Services account as the customer profiles domain

# Arguments
- `domain_name`: The unique name of the domain.
- `event_stream_name`: The name of the event stream.
- `uri`: The StreamARN of the destination to deliver profile events to. For example,
  arn:aws:kinesis:region:account-id:stream/stream-name

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags used to organize, track, or control access for this resource.
"""
function create_event_stream(
    DomainName, EventStreamName, Uri; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)",
        Dict{String,Any}("Uri" => Uri);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_stream(
    DomainName,
    EventStreamName,
    Uri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Uri" => Uri), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_integration_workflow(domain_name, integration_config, object_type_name, role_arn, workflow_type)
    create_integration_workflow(domain_name, integration_config, object_type_name, role_arn, workflow_type, params::Dict{String,<:Any})

 Creates an integration workflow. An integration workflow is an async process which ingests
historic data and sets up an integration for ongoing updates. The supported Amazon AppFlow
sources are Salesforce, ServiceNow, and Marketo.

# Arguments
- `domain_name`: The unique name of the domain.
- `integration_config`: Configuration data for integration workflow.
- `object_type_name`: The name of the profile object type.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes
  this role to create resources on your behalf as part of workflow execution.
- `workflow_type`: The type of workflow. The only supported value is APPFLOW_INTEGRATION.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags used to organize, track, or control access for this resource.
"""
function create_integration_workflow(
    DomainName,
    IntegrationConfig,
    ObjectTypeName,
    RoleArn,
    WorkflowType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/workflows/integrations",
        Dict{String,Any}(
            "IntegrationConfig" => IntegrationConfig,
            "ObjectTypeName" => ObjectTypeName,
            "RoleArn" => RoleArn,
            "WorkflowType" => WorkflowType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_integration_workflow(
    DomainName,
    IntegrationConfig,
    ObjectTypeName,
    RoleArn,
    WorkflowType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/workflows/integrations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IntegrationConfig" => IntegrationConfig,
                    "ObjectTypeName" => ObjectTypeName,
                    "RoleArn" => RoleArn,
                    "WorkflowType" => WorkflowType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_profile(domain_name)
    create_profile(domain_name, params::Dict{String,<:Any})

Creates a standard profile. A standard profile represents the following attributes for a
customer profile in a domain.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountNumber"`: An account number that you have given to the customer.
- `"AdditionalInformation"`: Any additional information relevant to the customer’s
  profile.
- `"Address"`: A generic address associated with the customer that is not mailing,
  shipping, or billing.
- `"Attributes"`: A key value pair of attributes of a customer profile.
- `"BillingAddress"`: The customer’s billing address.
- `"BirthDate"`: The customer’s birth date.
- `"BusinessEmailAddress"`: The customer’s business email address.
- `"BusinessName"`: The name of the customer’s business.
- `"BusinessPhoneNumber"`: The customer’s business phone number.
- `"EmailAddress"`: The customer’s email address, which has not been specified as a
  personal or business address.
- `"FirstName"`: The customer’s first name.
- `"Gender"`: The gender with which the customer identifies.
- `"GenderString"`: An alternative to Gender which accepts any string as input.
- `"HomePhoneNumber"`: The customer’s home phone number.
- `"LastName"`: The customer’s last name.
- `"MailingAddress"`: The customer’s mailing address.
- `"MiddleName"`: The customer’s middle name.
- `"MobilePhoneNumber"`: The customer’s mobile phone number.
- `"PartyType"`: The type of profile used to describe the customer.
- `"PartyTypeString"`: An alternative to PartyType which accepts any string as input.
- `"PersonalEmailAddress"`: The customer’s personal email address.
- `"PhoneNumber"`: The customer’s phone number, which has not been specified as a mobile,
  home, or business number.
- `"ShippingAddress"`: The customer’s shipping address.
"""
function create_profile(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_profile(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_calculated_attribute_definition(calculated_attribute_name, domain_name)
    delete_calculated_attribute_definition(calculated_attribute_name, domain_name, params::Dict{String,<:Any})

Deletes an existing calculated attribute definition. Note that deleting a default
calculated attribute is possible, however once deleted, you will be unable to undo that
action and will need to recreate it on your own using the
CreateCalculatedAttributeDefinition API if you want it back.

# Arguments
- `calculated_attribute_name`: The unique name of the calculated attribute.
- `domain_name`: The unique name of the domain.

"""
function delete_calculated_attribute_definition(
    CalculatedAttributeName, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_calculated_attribute_definition(
    CalculatedAttributeName,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain(domain_name)
    delete_domain(domain_name, params::Dict{String,<:Any})

Deletes a specific domain and all of its customer data, such as customer profile attributes
and their related objects.

# Arguments
- `domain_name`: The unique name of the domain.

"""
function delete_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_stream(domain_name, event_stream_name)
    delete_event_stream(domain_name, event_stream_name, params::Dict{String,<:Any})

Disables and deletes the specified event stream.

# Arguments
- `domain_name`: The unique name of the domain.
- `event_stream_name`: The name of the event stream

"""
function delete_event_stream(
    DomainName, EventStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_stream(
    DomainName,
    EventStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_integration(domain_name, uri)
    delete_integration(domain_name, uri, params::Dict{String,<:Any})

Removes an integration from a specific domain.

# Arguments
- `domain_name`: The unique name of the domain.
- `uri`: The URI of the S3 bucket or any other type of data source.

"""
function delete_integration(
    DomainName, Uri; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/integrations/delete",
        Dict{String,Any}("Uri" => Uri);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_integration(
    DomainName,
    Uri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/integrations/delete",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Uri" => Uri), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile(domain_name, profile_id)
    delete_profile(domain_name, profile_id, params::Dict{String,<:Any})

Deletes the standard customer profile and all data pertaining to the profile.

# Arguments
- `domain_name`: The unique name of the domain.
- `profile_id`: The unique identifier of a customer profile.

"""
function delete_profile(
    DomainName, ProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/delete",
        Dict{String,Any}("ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile(
    DomainName,
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/delete",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProfileId" => ProfileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile_key(domain_name, key_name, profile_id, values)
    delete_profile_key(domain_name, key_name, profile_id, values, params::Dict{String,<:Any})

Removes a searchable key from a customer profile.

# Arguments
- `domain_name`: The unique name of the domain.
- `key_name`: A searchable identifier of a customer profile.
- `profile_id`: The unique identifier of a customer profile.
- `values`: A list of key values.

"""
function delete_profile_key(
    DomainName,
    KeyName,
    ProfileId,
    Values;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/keys/delete",
        Dict{String,Any}(
            "KeyName" => KeyName, "ProfileId" => ProfileId, "Values" => Values
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile_key(
    DomainName,
    KeyName,
    ProfileId,
    Values,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/keys/delete",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "KeyName" => KeyName, "ProfileId" => ProfileId, "Values" => Values
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile_object(domain_name, object_type_name, profile_id, profile_object_unique_key)
    delete_profile_object(domain_name, object_type_name, profile_id, profile_object_unique_key, params::Dict{String,<:Any})

Removes an object associated with a profile of a given ProfileObjectType.

# Arguments
- `domain_name`: The unique name of the domain.
- `object_type_name`: The name of the profile object type.
- `profile_id`: The unique identifier of a customer profile.
- `profile_object_unique_key`: The unique identifier of the profile object generated by the
  service.

"""
function delete_profile_object(
    DomainName,
    ObjectTypeName,
    ProfileId,
    ProfileObjectUniqueKey;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects/delete",
        Dict{String,Any}(
            "ObjectTypeName" => ObjectTypeName,
            "ProfileId" => ProfileId,
            "ProfileObjectUniqueKey" => ProfileObjectUniqueKey,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile_object(
    DomainName,
    ObjectTypeName,
    ProfileId,
    ProfileObjectUniqueKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects/delete",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ObjectTypeName" => ObjectTypeName,
                    "ProfileId" => ProfileId,
                    "ProfileObjectUniqueKey" => ProfileObjectUniqueKey,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_profile_object_type(domain_name, object_type_name)
    delete_profile_object_type(domain_name, object_type_name, params::Dict{String,<:Any})

Removes a ProfileObjectType from a specific domain as well as removes all the
ProfileObjects of that type. It also disables integrations from this specific
ProfileObjectType. In addition, it scrubs all of the fields of the standard profile that
were populated from this ProfileObjectType.

# Arguments
- `domain_name`: The unique name of the domain.
- `object_type_name`: The name of the profile object type.

"""
function delete_profile_object_type(
    DomainName, ObjectTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_profile_object_type(
    DomainName,
    ObjectTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_workflow(domain_name, workflow_id)
    delete_workflow(domain_name, workflow_id, params::Dict{String,<:Any})

Deletes the specified workflow and all its corresponding resources. This is an async
process.

# Arguments
- `domain_name`: The unique name of the domain.
- `workflow_id`: Unique identifier for the workflow.

"""
function delete_workflow(
    DomainName, WorkflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/workflows/$(WorkflowId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_workflow(
    DomainName,
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/domains/$(DomainName)/workflows/$(WorkflowId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detect_profile_object_type(domain_name, objects)
    detect_profile_object_type(domain_name, objects, params::Dict{String,<:Any})

The process of detecting profile object type mapping by using given objects.

# Arguments
- `domain_name`: The unique name of the domain.
- `objects`: A string that is serialized from a JSON object.

"""
function detect_profile_object_type(
    DomainName, Objects; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/detect/object-types",
        Dict{String,Any}("Objects" => Objects);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detect_profile_object_type(
    DomainName,
    Objects,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/detect/object-types",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Objects" => Objects), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_auto_merging_preview(conflict_resolution, consolidation, domain_name)
    get_auto_merging_preview(conflict_resolution, consolidation, domain_name, params::Dict{String,<:Any})

Tests the auto-merging settings of your Identity Resolution Job without merging your data.
It randomly selects a sample of matching groups from the existing matching results, and
applies the automerging settings that you provided. You can then view the number of
profiles in the sample, the number of matches, and the number of profiles identified to be
merged. This enables you to evaluate the accuracy of the attributes in your matching list.
You can't view which profiles are matched and would be merged.  We strongly recommend you
use this API to do a dry run of the automerging process before running the Identity
Resolution Job. Include at least two matching attributes. If your matching list includes
too few attributes (such as only FirstName or only LastName), there may be a large number
of matches. This increases the chances of erroneous merges.

# Arguments
- `conflict_resolution`: How the auto-merging process should resolve conflicts between
  different profiles.
- `consolidation`: A list of matching attributes that represent matching criteria.
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MinAllowedConfidenceScoreForMerging"`: Minimum confidence score required for profiles
  within a matching group to be merged during the auto-merge process.
"""
function get_auto_merging_preview(
    ConflictResolution,
    Consolidation,
    DomainName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/identity-resolution-jobs/auto-merging-preview",
        Dict{String,Any}(
            "ConflictResolution" => ConflictResolution, "Consolidation" => Consolidation
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_auto_merging_preview(
    ConflictResolution,
    Consolidation,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/identity-resolution-jobs/auto-merging-preview",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConflictResolution" => ConflictResolution,
                    "Consolidation" => Consolidation,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_calculated_attribute_definition(calculated_attribute_name, domain_name)
    get_calculated_attribute_definition(calculated_attribute_name, domain_name, params::Dict{String,<:Any})

Provides more information on a calculated attribute definition for Customer Profiles.

# Arguments
- `calculated_attribute_name`: The unique name of the calculated attribute.
- `domain_name`: The unique name of the domain.

"""
function get_calculated_attribute_definition(
    CalculatedAttributeName, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_calculated_attribute_definition(
    CalculatedAttributeName,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_calculated_attribute_for_profile(calculated_attribute_name, domain_name, profile_id)
    get_calculated_attribute_for_profile(calculated_attribute_name, domain_name, profile_id, params::Dict{String,<:Any})

Retrieve a calculated attribute for a customer profile.

# Arguments
- `calculated_attribute_name`: The unique name of the calculated attribute.
- `domain_name`: The unique name of the domain.
- `profile_id`: The unique identifier of a customer profile.

"""
function get_calculated_attribute_for_profile(
    CalculatedAttributeName,
    DomainName,
    ProfileId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profile/$(ProfileId)/calculated-attributes/$(CalculatedAttributeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_calculated_attribute_for_profile(
    CalculatedAttributeName,
    DomainName,
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profile/$(ProfileId)/calculated-attributes/$(CalculatedAttributeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain(domain_name)
    get_domain(domain_name, params::Dict{String,<:Any})

Returns information about a specific domain.

# Arguments
- `domain_name`: The unique name of the domain.

"""
function get_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_event_stream(domain_name, event_stream_name)
    get_event_stream(domain_name, event_stream_name, params::Dict{String,<:Any})

Returns information about the specified event stream in a specific domain.

# Arguments
- `domain_name`: The unique name of the domain.
- `event_stream_name`: The name of the event stream provided during create operations.

"""
function get_event_stream(
    DomainName, EventStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_event_stream(
    DomainName,
    EventStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/event-streams/$(EventStreamName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_identity_resolution_job(domain_name, job_id)
    get_identity_resolution_job(domain_name, job_id, params::Dict{String,<:Any})

Returns information about an Identity Resolution Job in a specific domain.  Identity
Resolution Jobs are set up using the Amazon Connect admin console. For more information,
see Use Identity Resolution to consolidate similar profiles.

# Arguments
- `domain_name`: The unique name of the domain.
- `job_id`: The unique identifier of the Identity Resolution Job.

"""
function get_identity_resolution_job(
    DomainName, JobId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/identity-resolution-jobs/$(JobId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_identity_resolution_job(
    DomainName,
    JobId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/identity-resolution-jobs/$(JobId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_integration(domain_name, uri)
    get_integration(domain_name, uri, params::Dict{String,<:Any})

Returns an integration for a domain.

# Arguments
- `domain_name`: The unique name of the domain.
- `uri`: The URI of the S3 bucket or any other type of data source.

"""
function get_integration(
    DomainName, Uri; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/integrations",
        Dict{String,Any}("Uri" => Uri);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_integration(
    DomainName,
    Uri,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/integrations",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Uri" => Uri), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_matches(domain_name)
    get_matches(domain_name, params::Dict{String,<:Any})

Before calling this API, use CreateDomain or UpdateDomain to enable identity resolution:
set Matching to true. GetMatches returns potentially matching profiles, based on the
results of the latest run of a machine learning process.   The process of matching
duplicate profiles. If Matching = true, Amazon Connect Customer Profiles starts a weekly
batch process called Identity Resolution Job. If you do not specify a date and time for
Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect
duplicate profiles in your domains.  After the Identity Resolution Job completes, use the
GetMatches API to return and review the results. Or, if you have configured ExportingConfig
in the MatchingRequest, you can download the results from S3.  Amazon Connect uses the
following profile attributes to identify matches:   PhoneNumber   HomePhoneNumber
BusinessPhoneNumber   MobilePhoneNumber   EmailAddress   PersonalEmailAddress
BusinessEmailAddress   FullName   For example, two or more profiles—with spelling
mistakes such as John Doe and Jhn Doe, or different casing email addresses such as
JOHN_DOE@ANYCOMPANY.COM and johndoe@anycompany.com, or different phone number formats such
as 555-010-0000 and +1-555-010-0000—can be detected as belonging to the same customer
John Doe and merged into a unified profile.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return per page.
- `"next-token"`: The token for the next set of results. Use the value returned in the
  previous response in the next request to retrieve the next set of results.
"""
function get_matches(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/matches";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_matches(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/matches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile_object_type(domain_name, object_type_name)
    get_profile_object_type(domain_name, object_type_name, params::Dict{String,<:Any})

Returns the object types for a specific domain.

# Arguments
- `domain_name`: The unique name of the domain.
- `object_type_name`: The name of the profile object type.

"""
function get_profile_object_type(
    DomainName, ObjectTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile_object_type(
    DomainName,
    ObjectTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_profile_object_type_template(template_id)
    get_profile_object_type_template(template_id, params::Dict{String,<:Any})

Returns the template information for a specific object type. A template is a predefined
ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a
user sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that
matches one of the TemplateIds, it uses the mappings from the template.

# Arguments
- `template_id`: A unique identifier for the object template.

"""
function get_profile_object_type_template(
    TemplateId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/templates/$(TemplateId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_profile_object_type_template(
    TemplateId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/templates/$(TemplateId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_similar_profiles(domain_name, match_type, search_key, search_value)
    get_similar_profiles(domain_name, match_type, search_key, search_value, params::Dict{String,<:Any})

Returns a set of profiles that belong to the same matching group using the matchId or
profileId. You can also specify the type of matching that you want for finding similar
profiles using either RULE_BASED_MATCHING or ML_BASED_MATCHING.

# Arguments
- `domain_name`: The unique name of the domain.
- `match_type`: Specify the type of matching to get similar profiles for.
- `search_key`: The string indicating the search key to be used.
- `search_value`: The string based on SearchKey to be searched for similar profiles.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous GetSimilarProfiles API call.
"""
function get_similar_profiles(
    DomainName,
    MatchType,
    SearchKey,
    SearchValue;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/matches",
        Dict{String,Any}(
            "MatchType" => MatchType, "SearchKey" => SearchKey, "SearchValue" => SearchValue
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_similar_profiles(
    DomainName,
    MatchType,
    SearchKey,
    SearchValue,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/matches",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MatchType" => MatchType,
                    "SearchKey" => SearchKey,
                    "SearchValue" => SearchValue,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow(domain_name, workflow_id)
    get_workflow(domain_name, workflow_id, params::Dict{String,<:Any})

Get details of specified workflow.

# Arguments
- `domain_name`: The unique name of the domain.
- `workflow_id`: Unique identifier for the workflow.

"""
function get_workflow(
    DomainName, WorkflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/workflows/$(WorkflowId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow(
    DomainName,
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/workflows/$(WorkflowId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_workflow_steps(domain_name, workflow_id)
    get_workflow_steps(domain_name, workflow_id, params::Dict{String,<:Any})

Get granular list of steps in workflow.

# Arguments
- `domain_name`: The unique name of the domain.
- `workflow_id`: Unique identifier for the workflow.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return per page.
- `"next-token"`: The token for the next set of results. Use the value returned in the
  previous response in the next request to retrieve the next set of results.
"""
function get_workflow_steps(
    DomainName, WorkflowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/workflows/$(WorkflowId)/steps";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_workflow_steps(
    DomainName,
    WorkflowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/workflows/$(WorkflowId)/steps",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_account_integrations(uri)
    list_account_integrations(uri, params::Dict{String,<:Any})

Lists all of the integrations associated to a specific URI in the AWS account.

# Arguments
- `uri`: The URI of the S3 bucket or any other type of data source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"include-hidden"`: Boolean to indicate if hidden integration should be returned.
  Defaults to False.
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous ListAccountIntegrations API call.
"""
function list_account_integrations(Uri; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "POST",
        "/integrations",
        Dict{String,Any}("Uri" => Uri);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_account_integrations(
    Uri, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/integrations",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Uri" => Uri), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_calculated_attribute_definitions(domain_name)
    list_calculated_attribute_definitions(domain_name, params::Dict{String,<:Any})

Lists calculated attribute definitions for Customer Profiles

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of calculated attribute definitions returned per page.
- `"next-token"`: The pagination token from the previous call to
  ListCalculatedAttributeDefinitions.
"""
function list_calculated_attribute_definitions(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/calculated-attributes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_calculated_attribute_definitions(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/calculated-attributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_calculated_attributes_for_profile(domain_name, profile_id)
    list_calculated_attributes_for_profile(domain_name, profile_id, params::Dict{String,<:Any})

Retrieve a list of calculated attributes for a customer profile.

# Arguments
- `domain_name`: The unique name of the domain.
- `profile_id`: The unique identifier of a customer profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of calculated attributes returned per page.
- `"next-token"`: The pagination token from the previous call to
  ListCalculatedAttributesForProfile.
"""
function list_calculated_attributes_for_profile(
    DomainName, ProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profile/$(ProfileId)/calculated-attributes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_calculated_attributes_for_profile(
    DomainName,
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profile/$(ProfileId)/calculated-attributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domains()
    list_domains(params::Dict{String,<:Any})

Returns a list of all the domains for an AWS account that have been created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous ListDomain API call.
"""
function list_domains(; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "GET", "/domains"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET", "/domains", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_event_streams(domain_name)
    list_event_streams(domain_name, params::Dict{String,<:Any})

Returns a list of all the event streams in a specific domain.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: Identifies the next page of results to return.
"""
function list_event_streams(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/event-streams";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_event_streams(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/event-streams",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_identity_resolution_jobs(domain_name)
    list_identity_resolution_jobs(domain_name, params::Dict{String,<:Any})

Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by
JobStartTime.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of results to return per page.
- `"next-token"`: The token for the next set of results. Use the value returned in the
  previous response in the next request to retrieve the next set of results.
"""
function list_identity_resolution_jobs(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/identity-resolution-jobs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_identity_resolution_jobs(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/identity-resolution-jobs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_integrations(domain_name)
    list_integrations(domain_name, params::Dict{String,<:Any})

Lists all of the integrations in your domain.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"include-hidden"`: Boolean to indicate if hidden integration should be returned.
  Defaults to False.
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous ListIntegrations API call.
"""
function list_integrations(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/integrations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_integrations(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/integrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profile_object_type_templates()
    list_profile_object_type_templates(params::Dict{String,<:Any})

Lists all of the template information for object types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous ListObjectTypeTemplates API call.
"""
function list_profile_object_type_templates(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET", "/templates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_profile_object_type_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET", "/templates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_profile_object_types(domain_name)
    list_profile_object_types(domain_name, params::Dict{String,<:Any})

Lists all of the templates available within the service.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: Identifies the next page of results to return.
"""
function list_profile_object_types(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/object-types";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_profile_object_types(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/object-types",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_profile_objects(domain_name, object_type_name, profile_id)
    list_profile_objects(domain_name, object_type_name, profile_id, params::Dict{String,<:Any})

Returns a list of objects associated with a profile of a given ProfileObjectType.

# Arguments
- `domain_name`: The unique name of the domain.
- `object_type_name`: The name of the profile object type.
- `profile_id`: The unique identifier of a customer profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ObjectFilter"`: Applies a filter to the response to include profile objects with the
  specified index values.
- `"max-results"`: The maximum number of objects returned per page.
- `"next-token"`: The pagination token from the previous call to ListProfileObjects.
"""
function list_profile_objects(
    DomainName,
    ObjectTypeName,
    ProfileId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects",
        Dict{String,Any}("ObjectTypeName" => ObjectTypeName, "ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_profile_objects(
    DomainName,
    ObjectTypeName,
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ObjectTypeName" => ObjectTypeName, "ProfileId" => ProfileId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_rule_based_matches(domain_name)
    list_rule_based_matches(domain_name, params::Dict{String,<:Any})

Returns a set of MatchIds that belong to the given domain.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max-results"`: The maximum number of MatchIds returned per page.
- `"next-token"`: The pagination token from the previous ListRuleBasedMatches API call.
"""
function list_rule_based_matches(
    DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profiles/ruleBasedMatches";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_rule_based_matches(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/domains/$(DomainName)/profiles/ruleBasedMatches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect
Customer Profiles, domains, profile object types, and integrations can be tagged.

# Arguments
- `resource_arn`: The ARN of the resource for which you want to view tags.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_workflows(domain_name)
    list_workflows(domain_name, params::Dict{String,<:Any})

Query to list all workflows.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"QueryEndDate"`: Retrieve workflows ended after timestamp.
- `"QueryStartDate"`: Retrieve workflows started after timestamp.
- `"Status"`: Status of workflow execution.
- `"WorkflowType"`: The type of workflow. The only supported value is APPFLOW_INTEGRATION.
- `"max-results"`: The maximum number of results to return per page.
- `"next-token"`: The token for the next set of results. Use the value returned in the
  previous response in the next request to retrieve the next set of results.
"""
function list_workflows(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/workflows";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_workflows(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/workflows",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    merge_profiles(domain_name, main_profile_id, profile_ids_to_be_merged)
    merge_profiles(domain_name, main_profile_id, profile_ids_to_be_merged, params::Dict{String,<:Any})

Runs an AWS Lambda job that does the following:   All the profileKeys in the
ProfileToBeMerged will be moved to the main profile.   All the objects in the
ProfileToBeMerged will be moved to the main profile.   All the ProfileToBeMerged will be
deleted at the end.   All the profileKeys in the ProfileIdsToBeMerged will be moved to the
main profile.   Standard fields are merged as follows:   Fields are always \"union\"-ed if
there are no conflicts in standard fields or attributeKeys.   When there are conflicting
fields:   If no SourceProfileIds entry is specified, the main Profile value is always
taken.    If a SourceProfileIds entry is specified, the specified profileId is always
taken, even if it is a NULL value.       You can use MergeProfiles together with
GetMatches, which returns potentially matching profiles, or use it with the results of
another matching system. After profiles have been merged, they cannot be separated
(unmerged).

# Arguments
- `domain_name`: The unique name of the domain.
- `main_profile_id`: The identifier of the profile to be taken.
- `profile_ids_to_be_merged`: The identifier of the profile to be merged into MainProfileId.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FieldSourceProfileIds"`: The identifiers of the fields in the profile that has the
  information you want to apply to the merge. For example, say you want to merge EmailAddress
  from Profile1 into MainProfile. This would be the identifier of the EmailAddress field in
  Profile1.
"""
function merge_profiles(
    DomainName,
    MainProfileId,
    ProfileIdsToBeMerged;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects/merge",
        Dict{String,Any}(
            "MainProfileId" => MainProfileId, "ProfileIdsToBeMerged" => ProfileIdsToBeMerged
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function merge_profiles(
    DomainName,
    MainProfileId,
    ProfileIdsToBeMerged,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/objects/merge",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "MainProfileId" => MainProfileId,
                    "ProfileIdsToBeMerged" => ProfileIdsToBeMerged,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_integration(domain_name)
    put_integration(domain_name, params::Dict{String,<:Any})

Adds an integration between the service and a third-party service, which includes Amazon
AppFlow and Amazon Connect. An integration can belong to only one domain. To add or remove
tags on an existing Integration, see  TagResource / UntagResource.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FlowDefinition"`: The configuration that controls how Customer Profiles retrieves data
  from the source.
- `"ObjectTypeName"`: The name of the profile object type.
- `"ObjectTypeNames"`: A map in which each key is an event type from an external
  application such as Segment or Shopify, and each value is an ObjectTypeName (template) used
  to ingest the event. It supports the following event types: SegmentIdentify,
  ShopifyCreateCustomers, ShopifyUpdateCustomers, ShopifyCreateDraftOrders,
  ShopifyUpdateDraftOrders, ShopifyCreateOrders, and ShopifyUpdatedOrders.
- `"Tags"`: The tags used to organize, track, or control access for this resource.
- `"Uri"`: The URI of the S3 bucket or any other type of data source.
"""
function put_integration(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/integrations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_integration(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/integrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_profile_object(domain_name, object, object_type_name)
    put_profile_object(domain_name, object, object_type_name, params::Dict{String,<:Any})

Adds additional objects to customer profiles of a given ObjectType. When adding a specific
profile object, like a Contact Record, an inferred profile can get created if it is not
mapped to an existing profile. The resulting profile will only have a phone number
populated in the standard ProfileObject. Any additional Contact Records with the same phone
number will be mapped to the same inferred profile. When a ProfileObject is created and if
a ProfileObjectType already exists for the ProfileObject, it will provide data to a
standard profile depending on the ProfileObjectType definition. PutProfileObject needs an
ObjectType, which can be created using PutProfileObjectType.

# Arguments
- `domain_name`: The unique name of the domain.
- `object`: A string that is serialized from a JSON object.
- `object_type_name`: The name of the profile object type.

"""
function put_profile_object(
    DomainName, Object, ObjectTypeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/profiles/objects",
        Dict{String,Any}("Object" => Object, "ObjectTypeName" => ObjectTypeName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_profile_object(
    DomainName,
    Object,
    ObjectTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/profiles/objects",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Object" => Object, "ObjectTypeName" => ObjectTypeName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_profile_object_type(description, domain_name, object_type_name)
    put_profile_object_type(description, domain_name, object_type_name, params::Dict{String,<:Any})

Defines a ProfileObjectType. To add or remove tags on an existing ObjectType, see
TagResource/UntagResource.

# Arguments
- `description`: Description of the profile object type.
- `domain_name`: The unique name of the domain.
- `object_type_name`: The name of the profile object type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowProfileCreation"`: Indicates whether a profile should be created when data is
  received if one doesn’t exist for an object of this type. The default is FALSE. If the
  AllowProfileCreation flag is set to FALSE, then the service tries to fetch a standard
  profile and associate this object with the profile. If it is set to TRUE, and if no match
  is found, then the service creates a new standard profile.
- `"EncryptionKey"`: The customer-provided key to encrypt the profile object that will be
  created in this profile object type.
- `"ExpirationDays"`: The number of days until the data in the object expires.
- `"Fields"`: A map of the name and ObjectType field.
- `"Keys"`: A list of unique keys that can be used to map data to the profile.
- `"MaxProfileObjectCount"`: The amount of profile object max count assigned to the object
  type
- `"SourceLastUpdatedTimestampFormat"`: The format of your sourceLastUpdatedTimestamp that
  was previously set up.
- `"Tags"`: The tags used to organize, track, or control access for this resource.
- `"TemplateId"`: A unique identifier for the object template. For some attributes in the
  request, the service will use the default value from the object template when TemplateId is
  present. If these attributes are present in the request, the service may return a
  BadRequestException. These attributes include: AllowProfileCreation,
  SourceLastUpdatedTimestampFormat, Fields, and Keys. For example, if AllowProfileCreation is
  set to true when TemplateId is set, the service may return a BadRequestException.
"""
function put_profile_object_type(
    Description,
    DomainName,
    ObjectTypeName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)",
        Dict{String,Any}("Description" => Description);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_profile_object_type(
    Description,
    DomainName,
    ObjectTypeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/object-types/$(ObjectTypeName)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Description" => Description), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    search_profiles(domain_name, key_name, values)
    search_profiles(domain_name, key_name, values, params::Dict{String,<:Any})

Searches for profiles within a specific domain using one or more predefined search keys
(e.g., _fullName, _phone, _email, _account, etc.) and/or custom-defined search keys. A
search key is a data type pair that consists of a KeyName and Values list. This operation
supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5
key-value(s) pairs using either AND or OR logic.

# Arguments
- `domain_name`: The unique name of the domain.
- `key_name`: A searchable identifier of a customer profile. The predefined keys you can
  use to search include: _account, _profileId, _assetId, _caseId, _orderId, _fullName,
  _phone, _email, _ctrContactId, _marketoLeadId, _salesforceAccountId, _salesforceContactId,
  _salesforceAssetId, _zendeskUserId, _zendeskExternalId, _zendeskTicketId,
  _serviceNowSystemId, _serviceNowIncidentId, _segmentUserId, _shopifyCustomerId,
  _shopifyOrderId.
- `values`: A list of key values.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalSearchKeys"`: A list of AdditionalSearchKey objects that are each searchable
  identifiers of a profile. Each AdditionalSearchKey object contains a KeyName and a list of
  Values associated with that specific key (i.e., a key-value(s) pair). These additional
  search keys will be used in conjunction with the LogicalOperator and the required KeyName
  and Values parameters to search for profiles that satisfy the search criteria.
- `"LogicalOperator"`: Relationship between all specified search keys that will be used to
  search for profiles. This includes the required KeyName and Values parameters as well as
  any key-value(s) pairs specified in the AdditionalSearchKeys list. This parameter
  influences which profiles will be returned in the response in the following manner:    AND
  - The response only includes profiles that match all of the search keys.    OR - The
  response includes profiles that match at least one of the search keys.   The OR
  relationship is the default behavior if this parameter is not included in the request.
- `"max-results"`: The maximum number of objects returned per page. The default is 20 if
  this parameter is not included in the request.
- `"next-token"`: The pagination token from the previous SearchProfiles API call.
"""
function search_profiles(
    DomainName, KeyName, Values; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/search",
        Dict{String,Any}("KeyName" => KeyName, "Values" => Values);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function search_profiles(
    DomainName,
    KeyName,
    Values,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/domains/$(DomainName)/profiles/search",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("KeyName" => KeyName, "Values" => Values), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer
Profiles resource. Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to access or change only
resources with certain tag values. In Connect Customer Profiles, domains, profile object
types, and integrations can be tagged. Tags don't have any semantic meaning to AWS and are
interpreted strictly as strings of characters. You can use the TagResource action with a
resource that already has tags. If you specify a new tag key, this tag is appended to the
list of tags associated with the resource. If you specify a tag key that is already
associated with the resource, the new tag value that you specify replaces the previous
value for that tag. You can associate as many as 50 tags with a resource.

# Arguments
- `resource_arn`: The ARN of the resource that you're adding tags to.
- `tags`: The tags used to organize, track, or control access for this resource.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In
Connect Customer Profiles, domains, profile object types, and integrations can be tagged.

# Arguments
- `resource_arn`: The ARN of the resource from which you are removing tags.
- `tag_keys`: The list of tag keys to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_calculated_attribute_definition(calculated_attribute_name, domain_name)
    update_calculated_attribute_definition(calculated_attribute_name, domain_name, params::Dict{String,<:Any})

Updates an existing calculated attribute definition. When updating the Conditions, note
that increasing the date range of a calculated attribute will not trigger inclusion of
historical data greater than the current date range.

# Arguments
- `calculated_attribute_name`: The unique name of the calculated attribute.
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Conditions"`: The conditions including range, object count, and threshold for the
  calculated attribute.
- `"Description"`: The description of the calculated attribute.
- `"DisplayName"`: The display name of the calculated attribute.
"""
function update_calculated_attribute_definition(
    CalculatedAttributeName, DomainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_calculated_attribute_definition(
    CalculatedAttributeName,
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/calculated-attributes/$(CalculatedAttributeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain(domain_name)
    update_domain(domain_name, params::Dict{String,<:Any})

Updates the properties of a domain, including creating or selecting a dead letter queue or
an encryption key. After a domain is created, the name can’t be changed. Use this API or
CreateDomain to enable identity resolution: set Matching to true. To prevent cross-service
impersonation when you call this API, see Cross-service confused deputy prevention for
sample policies that you should apply.  To add or remove tags on an existing Domain, see
TagResource/UntagResource.

# Arguments
- `domain_name`: The unique name of the domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeadLetterQueueUrl"`: The URL of the SQS dead letter queue, which is used for reporting
  errors associated with ingesting data from third party applications. If specified as an
  empty string, it will clear any existing value. You must set up a policy on the
  DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to
  send messages to the DeadLetterQueue.
- `"DefaultEncryptionKey"`: The default encryption key, which is an AWS managed key, is
  used when no specific type of encryption key is specified. It is used to encrypt all data
  before it is placed in permanent or semi-permanent storage. If specified as an empty
  string, it will clear any existing value.
- `"DefaultExpirationDays"`: The default number of days until the data within the domain
  expires.
- `"Matching"`: The process of matching duplicate profiles. If Matching = true, Amazon
  Connect Customer Profiles starts a weekly batch process called Identity Resolution Job. If
  you do not specify a date and time for Identity Resolution Job to run, by default it runs
  every Saturday at 12AM UTC to detect duplicate profiles in your domains.  After the
  Identity Resolution Job completes, use the GetMatches API to return and review the results.
  Or, if you have configured ExportingConfig in the MatchingRequest, you can download the
  results from S3.
- `"RuleBasedMatching"`: The process of matching duplicate profiles using the rule-Based
  matching. If RuleBasedMatching = true, Amazon Connect Customer Profiles will start to match
  and merge your profiles according to your configuration in the RuleBasedMatchingRequest.
  You can use the ListRuleBasedMatches and GetSimilarProfiles API to return and review the
  results. Also, if you have configured ExportingConfig in the RuleBasedMatchingRequest, you
  can download the results from S3.
- `"Tags"`: The tags used to organize, track, or control access for this resource.
"""
function update_domain(DomainName; aws_config::AbstractAWSConfig=current_aws_config())
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain(
    DomainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_profile(domain_name, profile_id)
    update_profile(domain_name, profile_id, params::Dict{String,<:Any})

Updates the properties of a profile. The ProfileId is required for updating a customer
profile. When calling the UpdateProfile API, specifying an empty string value means that
any existing value will be removed. Not specifying a string value means that any value
already there will be kept.

# Arguments
- `domain_name`: The unique name of the domain.
- `profile_id`: The unique identifier of a customer profile.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccountNumber"`: An account number that you have given to the customer.
- `"AdditionalInformation"`: Any additional information relevant to the customer’s
  profile.
- `"Address"`: A generic address associated with the customer that is not mailing,
  shipping, or billing.
- `"Attributes"`: A key value pair of attributes of a customer profile.
- `"BillingAddress"`: The customer’s billing address.
- `"BirthDate"`: The customer’s birth date.
- `"BusinessEmailAddress"`: The customer’s business email address.
- `"BusinessName"`: The name of the customer’s business.
- `"BusinessPhoneNumber"`: The customer’s business phone number.
- `"EmailAddress"`: The customer’s email address, which has not been specified as a
  personal or business address.
- `"FirstName"`: The customer’s first name.
- `"Gender"`: The gender with which the customer identifies.
- `"GenderString"`: An alternative to Gender which accepts any string as input.
- `"HomePhoneNumber"`: The customer’s home phone number.
- `"LastName"`: The customer’s last name.
- `"MailingAddress"`: The customer’s mailing address.
- `"MiddleName"`: The customer’s middle name.
- `"MobilePhoneNumber"`: The customer’s mobile phone number.
- `"PartyType"`: The type of profile used to describe the customer.
- `"PartyTypeString"`: An alternative to PartyType which accepts any string as input.
- `"PersonalEmailAddress"`: The customer’s personal email address.
- `"PhoneNumber"`: The customer’s phone number, which has not been specified as a mobile,
  home, or business number.
- `"ShippingAddress"`: The customer’s shipping address.
"""
function update_profile(
    DomainName, ProfileId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/profiles",
        Dict{String,Any}("ProfileId" => ProfileId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_profile(
    DomainName,
    ProfileId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return customer_profiles(
        "PUT",
        "/domains/$(DomainName)/profiles",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ProfileId" => ProfileId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
