# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: dynamodb_streams
using AWS.Compat
using AWS.UUIDs

"""
    describe_stream(stream_arn)
    describe_stream(stream_arn, params::Dict{String,<:Any})

Returns information about a stream, including the current status of the stream, its Amazon
Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.
You can call DescribeStream at a maximum rate of 10 times per second.  Each shard in the
stream has a SequenceNumberRange associated with it. If the SequenceNumberRange has a
StartingSequenceNumber but no EndingSequenceNumber, then the shard is still open (able to
receive more stream records). If both StartingSequenceNumber and EndingSequenceNumber are
present, then that shard is closed and can no longer receive more data.

# Arguments
- `stream_arn`: The Amazon Resource Name (ARN) for the stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartShardId"`: The shard ID of the first item that this operation will
  evaluate. Use the value that was returned for LastEvaluatedShardId in the previous
  operation.
- `"Limit"`: The maximum number of shard objects to return. The upper limit is 100.
"""
function describe_stream(StreamArn; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb_streams(
        "DescribeStream",
        Dict{String,Any}("StreamArn" => StreamArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stream(
    StreamArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb_streams(
        "DescribeStream",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("StreamArn" => StreamArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_records(shard_iterator)
    get_records(shard_iterator, params::Dict{String,<:Any})

Retrieves the stream records from a given shard. Specify a shard iterator using the
ShardIterator parameter. The shard iterator specifies the position in the shard from which
you want to start reading stream records sequentially. If there are no stream records
available in the portion of the shard that the iterator points to, GetRecords returns an
empty list. Note that it might take multiple calls to get to a portion of the shard that
contains stream records.   GetRecords can retrieve a maximum of 1 MB of data or 1000 stream
records, whichever comes first.

# Arguments
- `shard_iterator`: A shard iterator that was retrieved from a previous GetShardIterator
  operation. This iterator can be used to access the stream records in this shard.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Limit"`: The maximum number of records to return from the shard. The upper limit is
  1000.
"""
function get_records(ShardIterator; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb_streams(
        "GetRecords",
        Dict{String,Any}("ShardIterator" => ShardIterator);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_records(
    ShardIterator,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb_streams(
        "GetRecords",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ShardIterator" => ShardIterator), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_shard_iterator(shard_id, shard_iterator_type, stream_arn)
    get_shard_iterator(shard_id, shard_iterator_type, stream_arn, params::Dict{String,<:Any})

Returns a shard iterator. A shard iterator provides information about how to retrieve the
stream records from within a shard. Use the shard iterator in a subsequent GetRecords
request to read the stream records from the shard.  A shard iterator expires 15 minutes
after it is returned to the requester.

# Arguments
- `shard_id`: The identifier of the shard. The iterator will be returned for this shard ID.
- `shard_iterator_type`: Determines how the shard iterator is used to start reading stream
  records from the shard:    AT_SEQUENCE_NUMBER - Start reading exactly from the position
  denoted by a specific sequence number.    AFTER_SEQUENCE_NUMBER - Start reading right after
  the position denoted by a specific sequence number.    TRIM_HORIZON - Start reading at the
  last (untrimmed) stream record, which is the oldest record in the shard. In DynamoDB
  Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this
  limit are subject to removal (trimming) from the stream.    LATEST - Start reading just
  after the most recent stream record in the shard, so that you always read the most recent
  data in the shard.
- `stream_arn`: The Amazon Resource Name (ARN) for the stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SequenceNumber"`: The sequence number of a stream record in the shard from which to
  start reading.
"""
function get_shard_iterator(
    ShardId,
    ShardIteratorType,
    StreamArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb_streams(
        "GetShardIterator",
        Dict{String,Any}(
            "ShardId" => ShardId,
            "ShardIteratorType" => ShardIteratorType,
            "StreamArn" => StreamArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_shard_iterator(
    ShardId,
    ShardIteratorType,
    StreamArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return dynamodb_streams(
        "GetShardIterator",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ShardId" => ShardId,
                    "ShardIteratorType" => ShardIteratorType,
                    "StreamArn" => StreamArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_streams()
    list_streams(params::Dict{String,<:Any})

Returns an array of stream ARNs associated with the current account and endpoint. If the
TableName parameter is present, then ListStreams will return only the streams ARNs for that
table.  You can call ListStreams at a maximum rate of 5 times per second.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartStreamArn"`: The ARN (Amazon Resource Name) of the first item that this
  operation will evaluate. Use the value that was returned for LastEvaluatedStreamArn in the
  previous operation.
- `"Limit"`: The maximum number of streams to return. The upper limit is 100.
- `"TableName"`: If this parameter is provided, then only the streams associated with this
  table name are returned.
"""
function list_streams(; aws_config::AbstractAWSConfig=current_aws_config())
    return dynamodb_streams(
        "ListStreams"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_streams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return dynamodb_streams(
        "ListStreams", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
