# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ec2
using AWS.Compat
using AWS.UUIDs

"""
    accept_address_transfer(address)
    accept_address_transfer(address, params::Dict{String,<:Any})

Accepts an Elastic IP address transfer. For more information, see Accept a transferred
Elastic IP address in the Amazon VPC User Guide.

# Arguments
- `address`: The Elastic IP address you are accepting for transfer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`:  tag:&lt;key&gt; - The key/value combination of a tag assigned to
  the resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.
"""
function accept_address_transfer(
    Address; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptAddressTransfer",
        Dict{String,Any}("Address" => Address);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_address_transfer(
    Address,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptAddressTransfer",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Address" => Address), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_reserved_instances_exchange_quote(reserved_instance_id)
    accept_reserved_instances_exchange_quote(reserved_instance_id, params::Dict{String,<:Any})

Accepts the Convertible Reserved Instance exchange quote described in the
GetReservedInstancesExchangeQuote call.

# Arguments
- `reserved_instance_id`: The IDs of the Convertible Reserved Instances to exchange for
  another Convertible Reserved Instance of the same or higher value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TargetConfiguration"`: The configuration of the target Convertible Reserved Instance to
  exchange for your current Convertible Reserved Instances.
"""
function accept_reserved_instances_exchange_quote(
    ReservedInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptReservedInstancesExchangeQuote",
        Dict{String,Any}("ReservedInstanceId" => ReservedInstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_reserved_instances_exchange_quote(
    ReservedInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptReservedInstancesExchangeQuote",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ReservedInstanceId" => ReservedInstanceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_transit_gateway_multicast_domain_associations()
    accept_transit_gateway_multicast_domain_associations(params::Dict{String,<:Any})

Accepts a request to associate subnets with a transit gateway multicast domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"SubnetIds"`: The IDs of the subnets to associate with the transit gateway multicast
  domain.
- `"TransitGatewayAttachmentId"`: The ID of the transit gateway attachment.
- `"TransitGatewayMulticastDomainId"`: The ID of the transit gateway multicast domain.
"""
function accept_transit_gateway_multicast_domain_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptTransitGatewayMulticastDomainAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_transit_gateway_multicast_domain_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptTransitGatewayMulticastDomainAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_transit_gateway_peering_attachment(transit_gateway_attachment_id)
    accept_transit_gateway_peering_attachment(transit_gateway_attachment_id, params::Dict{String,<:Any})

Accepts a transit gateway peering attachment request. The peering attachment must be in the
pendingAcceptance state.

# Arguments
- `transit_gateway_attachment_id`: The ID of the transit gateway attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function accept_transit_gateway_peering_attachment(
    TransitGatewayAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptTransitGatewayPeeringAttachment",
        Dict{String,Any}("TransitGatewayAttachmentId" => TransitGatewayAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_transit_gateway_peering_attachment(
    TransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptTransitGatewayPeeringAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_transit_gateway_vpc_attachment(transit_gateway_attachment_id)
    accept_transit_gateway_vpc_attachment(transit_gateway_attachment_id, params::Dict{String,<:Any})

Accepts a request to attach a VPC to a transit gateway. The VPC attachment must be in the
pendingAcceptance state. Use DescribeTransitGatewayVpcAttachments to view your pending VPC
attachment requests. Use RejectTransitGatewayVpcAttachment to reject a VPC attachment
request.

# Arguments
- `transit_gateway_attachment_id`: The ID of the attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function accept_transit_gateway_vpc_attachment(
    TransitGatewayAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptTransitGatewayVpcAttachment",
        Dict{String,Any}("TransitGatewayAttachmentId" => TransitGatewayAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_transit_gateway_vpc_attachment(
    TransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptTransitGatewayVpcAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_vpc_endpoint_connections(service_id, vpc_endpoint_id)
    accept_vpc_endpoint_connections(service_id, vpc_endpoint_id, params::Dict{String,<:Any})

Accepts connection requests to your VPC endpoint service.

# Arguments
- `service_id`: The ID of the VPC endpoint service.
- `vpc_endpoint_id`: The IDs of the interface VPC endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function accept_vpc_endpoint_connections(
    ServiceId, VpcEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptVpcEndpointConnections",
        Dict{String,Any}("ServiceId" => ServiceId, "VpcEndpointId" => VpcEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_vpc_endpoint_connections(
    ServiceId,
    VpcEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptVpcEndpointConnections",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ServiceId" => ServiceId, "VpcEndpointId" => VpcEndpointId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    accept_vpc_peering_connection(vpc_peering_connection_id)
    accept_vpc_peering_connection(vpc_peering_connection_id, params::Dict{String,<:Any})

Accept a VPC peering connection request. To accept a request, the VPC peering connection
must be in the pending-acceptance state, and you must be the owner of the peer VPC. Use
DescribeVpcPeeringConnections to view your outstanding VPC peering connection requests. For
an inter-Region VPC peering connection request, you must accept the VPC peering connection
in the Region of the accepter VPC.

# Arguments
- `vpc_peering_connection_id`: The ID of the VPC peering connection. You must specify this
  parameter in the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function accept_vpc_peering_connection(
    vpcPeeringConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AcceptVpcPeeringConnection",
        Dict{String,Any}("vpcPeeringConnectionId" => vpcPeeringConnectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_vpc_peering_connection(
    vpcPeeringConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AcceptVpcPeeringConnection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("vpcPeeringConnectionId" => vpcPeeringConnectionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    advertise_byoip_cidr(cidr)
    advertise_byoip_cidr(cidr, params::Dict{String,<:Any})

Advertises an IPv4 or IPv6 address range that is provisioned for use with your Amazon Web
Services resources through bring your own IP addresses (BYOIP). You can perform this
operation at most once every 10 seconds, even if you specify different address ranges each
time. We recommend that you stop advertising the BYOIP CIDR from other locations when you
advertise it from Amazon Web Services. To minimize down time, you can configure your Amazon
Web Services resources to use an address from a BYOIP CIDR before it is advertised, and
then simultaneously stop advertising it from the current location and start advertising it
through Amazon Web Services. It can take a few minutes before traffic to the specified
addresses starts routing to Amazon Web Services because of BGP propagation delays. To stop
advertising the BYOIP CIDR, use WithdrawByoipCidr.

# Arguments
- `cidr`: The address range, in CIDR notation. This must be the exact range that you
  provisioned. You can't advertise only a portion of the provisioned range.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Asn"`: The public 2-byte or 4-byte ASN that you want to advertise.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"NetworkBorderGroup"`: If you have Local Zones enabled, you can choose a network border
  group for Local Zones when you provision and advertise a BYOIPv4 CIDR. Choose the network
  border group carefully as the EIP and the Amazon Web Services resource it is associated
  with must reside in the same network border group. You can provision BYOIP address ranges
  to and advertise them in the following Local Zone network border groups:   us-east-1-dfw-2
   us-west-2-lax-1   us-west-2-phx-2    You cannot provision or advertise BYOIPv6 address
  ranges in Local Zones at this time.
"""
function advertise_byoip_cidr(Cidr; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "AdvertiseByoipCidr",
        Dict{String,Any}("Cidr" => Cidr);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function advertise_byoip_cidr(
    Cidr, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AdvertiseByoipCidr",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Cidr" => Cidr), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    allocate_address()
    allocate_address(params::Dict{String,<:Any})

Allocates an Elastic IP address to your Amazon Web Services account. After you allocate the
Elastic IP address you can associate it with an instance or network interface. After you
release an Elastic IP address, it is released to the IP address pool and can be allocated
to a different Amazon Web Services account. You can allocate an Elastic IP address from an
address pool owned by Amazon Web Services or from an address pool created from a public
IPv4 address range that you have brought to Amazon Web Services for use with your Amazon
Web Services resources using bring your own IP addresses (BYOIP). For more information, see
Bring Your Own IP Addresses (BYOIP) in the Amazon EC2 User Guide. If you release an Elastic
IP address, you might be able to recover it. You cannot recover an Elastic IP address that
you released after it is allocated to another Amazon Web Services account. To attempt to
recover an Elastic IP address that you released, specify it in this operation. For more
information, see Elastic IP Addresses in the Amazon EC2 User Guide. You can allocate a
carrier IP address which is a public IP address from a telecommunication carrier, to a
network interface which resides in a subnet in a Wavelength Zone (for example an EC2
instance).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Address"`: The Elastic IP address to recover or an IPv4 address from an address pool.
- `"CustomerOwnedIpv4Pool"`: The ID of a customer-owned address pool. Use this parameter to
  let Amazon EC2 select an address from the address pool. Alternatively, specify a specific
  address from the address pool.
- `"Domain"`: The network (vpc).
- `"NetworkBorderGroup"`:  A unique set of Availability Zones, Local Zones, or Wavelength
  Zones from which Amazon Web Services advertises IP addresses. Use this parameter to limit
  the IP address to this location. IP addresses cannot move between network border groups.
- `"PublicIpv4Pool"`: The ID of an address pool that you own. Use this parameter to let
  Amazon EC2 select an address from the address pool. To specify a specific address from the
  address pool, use the Address parameter instead.
- `"TagSpecification"`: The tags to assign to the Elastic IP address.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function allocate_address(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("AllocateAddress"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function allocate_address(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AllocateAddress", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    allocate_hosts(availability_zone)
    allocate_hosts(availability_zone, params::Dict{String,<:Any})

Allocates a Dedicated Host to your account. At a minimum, specify the supported instance
type or instance family, the Availability Zone in which to allocate the host, and the
number of hosts to allocate.

# Arguments
- `availability_zone`: The Availability Zone in which to allocate the Dedicated Host.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssetId"`: The IDs of the Outpost hardware assets on which to allocate the Dedicated
  Hosts. Targeting specific hardware assets on an Outpost can help to minimize latency
  between your workloads. This parameter is supported only if you specify OutpostArn. If you
  are allocating the Dedicated Hosts in a Region, omit this parameter.   If you specify this
  parameter, you can omit Quantity. In this case, Amazon EC2 allocates a Dedicated Host on
  each specified hardware asset.   If you specify both AssetIds and Quantity, then the value
  for Quantity must be equal to the number of asset IDs specified.
- `"HostMaintenance"`: Indicates whether to enable or disable host maintenance for the
  Dedicated Host. For more information, see Host maintenance in the Amazon EC2 User Guide.
- `"HostRecovery"`: Indicates whether to enable or disable host recovery for the Dedicated
  Host. Host recovery is disabled by default. For more information, see  Host recovery in the
  Amazon EC2 User Guide. Default: off
- `"InstanceFamily"`: Specifies the instance family to be supported by the Dedicated Hosts.
  If you specify an instance family, the Dedicated Hosts support multiple instance types
  within that instance family. If you want the Dedicated Hosts to support a specific instance
  type only, omit this parameter and specify InstanceType instead. You cannot specify
  InstanceFamily and InstanceType in the same request.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Amazon Web Services Outpost on
  which to allocate the Dedicated Host. If you specify OutpostArn, you can optionally specify
  AssetIds. If you are allocating the Dedicated Host in a Region, omit this parameter.
- `"TagSpecification"`: The tags to apply to the Dedicated Host during creation.
- `"autoPlacement"`: Indicates whether the host accepts any untargeted instance launches
  that match its instance type configuration, or if it only accepts Host tenancy instance
  launches that specify its unique host ID. For more information, see  Understanding
  auto-placement and affinity in the Amazon EC2 User Guide. Default: off
- `"clientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring Idempotency.
- `"instanceType"`: Specifies the instance type to be supported by the Dedicated Hosts. If
  you specify an instance type, the Dedicated Hosts support instances of the specified
  instance type only. If you want the Dedicated Hosts to support multiple instance types in a
  specific instance family, omit this parameter and specify InstanceFamily instead. You
  cannot specify InstanceType and InstanceFamily in the same request.
- `"quantity"`: The number of Dedicated Hosts to allocate to your account with these
  parameters. If you are allocating the Dedicated Hosts on an Outpost, and you specify
  AssetIds, you can omit this parameter. In this case, Amazon EC2 allocates a Dedicated Host
  on each specified hardware asset. If you specify both AssetIds and Quantity, then the value
  that you specify for Quantity must be equal to the number of asset IDs specified.
"""
function allocate_hosts(
    availabilityZone; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AllocateHosts",
        Dict{String,Any}("availabilityZone" => availabilityZone);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function allocate_hosts(
    availabilityZone,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AllocateHosts",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("availabilityZone" => availabilityZone), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    allocate_ipam_pool_cidr(ipam_pool_id)
    allocate_ipam_pool_cidr(ipam_pool_id, params::Dict{String,<:Any})

Allocate a CIDR from an IPAM pool. The Region you use should be the IPAM pool locale. The
locale is the Amazon Web Services Region where this IPAM pool is available for allocations.
In IPAM, an allocation is a CIDR assignment from an IPAM pool to another IPAM pool or to a
resource. For more information, see Allocate CIDRs in the Amazon VPC IPAM User Guide.  This
action creates an allocation with strong consistency. The returned CIDR will not overlap
with any other allocations from the same pool.

# Arguments
- `ipam_pool_id`: The ID of the IPAM pool from which you would like to allocate a CIDR.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowedCidr"`: Include a particular CIDR range that can be returned by the pool.
  Allowed CIDRs are only allowed if using netmask length for allocation.
- `"Cidr"`: The CIDR you would like to allocate from the IPAM pool. Note the following:
  If there is no DefaultNetmaskLength allocation rule set on the pool, you must specify
  either the NetmaskLength or the CIDR.   If the DefaultNetmaskLength allocation rule is set
  on the pool, you can specify either the NetmaskLength or the CIDR and the
  DefaultNetmaskLength allocation rule will be ignored.   Possible values: Any available IPv4
  or IPv6 CIDR.
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the allocation.
- `"DisallowedCidr"`: Exclude a particular CIDR range from being returned by the pool.
  Disallowed CIDRs are only allowed if using netmask length for allocation.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"NetmaskLength"`: The netmask length of the CIDR you would like to allocate from the
  IPAM pool. Note the following:   If there is no DefaultNetmaskLength allocation rule set on
  the pool, you must specify either the NetmaskLength or the CIDR.   If the
  DefaultNetmaskLength allocation rule is set on the pool, you can specify either the
  NetmaskLength or the CIDR and the DefaultNetmaskLength allocation rule will be ignored.
  Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6
  addresses are 0 - 128.
- `"PreviewNextCidr"`: A preview of the next available CIDR in a pool.
"""
function allocate_ipam_pool_cidr(
    IpamPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AllocateIpamPoolCidr",
        Dict{String,Any}("IpamPoolId" => IpamPoolId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function allocate_ipam_pool_cidr(
    IpamPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AllocateIpamPoolCidr",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IpamPoolId" => IpamPoolId, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    apply_security_groups_to_client_vpn_target_network(client_vpn_endpoint_id, security_group_id, vpc_id)
    apply_security_groups_to_client_vpn_target_network(client_vpn_endpoint_id, security_group_id, vpc_id, params::Dict{String,<:Any})

Applies a security group to the association between the target network and the Client VPN
endpoint. This action replaces the existing security groups with the specified security
groups.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.
- `security_group_id`: The IDs of the security groups to apply to the associated target
  network. Up to 5 security groups can be applied to an associated target network.
- `vpc_id`: The ID of the VPC in which the associated target network is located.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function apply_security_groups_to_client_vpn_target_network(
    ClientVpnEndpointId,
    SecurityGroupId,
    VpcId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ApplySecurityGroupsToClientVpnTargetNetwork",
        Dict{String,Any}(
            "ClientVpnEndpointId" => ClientVpnEndpointId,
            "SecurityGroupId" => SecurityGroupId,
            "VpcId" => VpcId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function apply_security_groups_to_client_vpn_target_network(
    ClientVpnEndpointId,
    SecurityGroupId,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ApplySecurityGroupsToClientVpnTargetNetwork",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                    "SecurityGroupId" => SecurityGroupId,
                    "VpcId" => VpcId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assign_ipv6_addresses(network_interface_id)
    assign_ipv6_addresses(network_interface_id, params::Dict{String,<:Any})

Assigns one or more IPv6 addresses to the specified network interface. You can specify one
or more specific IPv6 addresses, or you can specify the number of IPv6 addresses to be
automatically assigned from within the subnet's IPv6 CIDR block range. You can assign as
many IPv6 addresses to a network interface as you can assign private IPv4 addresses, and
the limit varies per instance type. You must specify either the IPv6 addresses or the IPv6
address count in the request.  You can optionally use Prefix Delegation on the network
interface. You must specify either the IPV6 Prefix Delegation prefixes, or the IPv6 Prefix
Delegation count. For information, see  Assigning prefixes to network interfaces in the
Amazon EC2 User Guide.

# Arguments
- `network_interface_id`: The ID of the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Ipv6Prefix"`: One or more IPv6 prefixes assigned to the network interface. You cannot
  use this option if you use the Ipv6PrefixCount option.
- `"Ipv6PrefixCount"`: The number of IPv6 prefixes that Amazon Web Services automatically
  assigns to the network interface. You cannot use this option if you use the Ipv6Prefixes
  option.
- `"ipv6AddressCount"`: The number of additional IPv6 addresses to assign to the network
  interface. The specified number of IPv6 addresses are assigned in addition to the existing
  IPv6 addresses that are already assigned to the network interface. Amazon EC2 automatically
  selects the IPv6 addresses from the subnet range. You can't use this option if specifying
  specific IPv6 addresses.
- `"ipv6Addresses"`: The IPv6 addresses to be assigned to the network interface. You can't
  use this option if you're specifying a number of IPv6 addresses.
"""
function assign_ipv6_addresses(
    networkInterfaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssignIpv6Addresses",
        Dict{String,Any}("networkInterfaceId" => networkInterfaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_ipv6_addresses(
    networkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssignIpv6Addresses",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("networkInterfaceId" => networkInterfaceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assign_private_ip_addresses(network_interface_id)
    assign_private_ip_addresses(network_interface_id, params::Dict{String,<:Any})

Assigns one or more secondary private IP addresses to the specified network interface. You
can specify one or more specific secondary IP addresses, or you can specify the number of
secondary IP addresses to be automatically assigned within the subnet's CIDR block range.
The number of secondary IP addresses that you can assign to an instance varies by instance
type. For more information about Elastic IP addresses, see Elastic IP Addresses in the
Amazon EC2 User Guide. When you move a secondary private IP address to another network
interface, any Elastic IP address that is associated with the IP address is also moved.
Remapping an IP address is an asynchronous operation. When you move an IP address from one
network interface to another, check network/interfaces/macs/mac/local-ipv4s in the instance
metadata to confirm that the remapping is complete. You must specify either the IP
addresses or the IP address count in the request. You can optionally use Prefix Delegation
on the network interface. You must specify either the IPv4 Prefix Delegation prefixes, or
the IPv4 Prefix Delegation count. For information, see  Assigning prefixes to network
interfaces in the Amazon EC2 User Guide.

# Arguments
- `network_interface_id`: The ID of the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Ipv4Prefix"`: One or more IPv4 prefixes assigned to the network interface. You cannot
  use this option if you use the Ipv4PrefixCount option.
- `"Ipv4PrefixCount"`: The number of IPv4 prefixes that Amazon Web Services automatically
  assigns to the network interface. You cannot use this option if you use the Ipv4 Prefixes
  option.
- `"allowReassignment"`: Indicates whether to allow an IP address that is already assigned
  to another network interface or instance to be reassigned to the specified network
  interface.
- `"privateIpAddress"`: The IP addresses to be assigned as a secondary private IP address
  to the network interface. You can't specify this parameter when also specifying a number of
  secondary IP addresses. If you don't specify an IP address, Amazon EC2 automatically
  selects an IP address within the subnet range.
- `"secondaryPrivateIpAddressCount"`: The number of secondary IP addresses to assign to the
  network interface. You can't specify this parameter when also specifying private IP
  addresses.
"""
function assign_private_ip_addresses(
    networkInterfaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssignPrivateIpAddresses",
        Dict{String,Any}("networkInterfaceId" => networkInterfaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_private_ip_addresses(
    networkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssignPrivateIpAddresses",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("networkInterfaceId" => networkInterfaceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    assign_private_nat_gateway_address(nat_gateway_id)
    assign_private_nat_gateway_address(nat_gateway_id, params::Dict{String,<:Any})

Assigns private IPv4 addresses to a private NAT gateway. For more information, see Work
with NAT gateways in the Amazon VPC User Guide.

# Arguments
- `nat_gateway_id`: The ID of the NAT gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PrivateIpAddress"`: The private IPv4 addresses you want to assign to the private NAT
  gateway.
- `"PrivateIpAddressCount"`: The number of private IP addresses to assign to the NAT
  gateway. You can't specify this parameter when also specifying private IP addresses.
"""
function assign_private_nat_gateway_address(
    NatGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssignPrivateNatGatewayAddress",
        Dict{String,Any}("NatGatewayId" => NatGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function assign_private_nat_gateway_address(
    NatGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssignPrivateNatGatewayAddress",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("NatGatewayId" => NatGatewayId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_address()
    associate_address(params::Dict{String,<:Any})

Associates an Elastic IP address, or carrier IP address (for instances that are in subnets
in Wavelength Zones) with an instance or a network interface. Before you can use an Elastic
IP address, you must allocate it to your account. If the Elastic IP address is already
associated with a different instance, it is disassociated from that instance and associated
with the specified instance. If you associate an Elastic IP address with an instance that
has an existing Elastic IP address, the existing address is disassociated from the
instance, but remains allocated to your account. [Subnets in Wavelength Zones] You can
associate an IP address from the telecommunication carrier to the instance or network
interface.  You cannot associate an Elastic IP address with an interface in a different
network border group.  This is an idempotent operation. If you perform the operation more
than once, Amazon EC2 doesn't return an error, and you may be charged for each time the
Elastic IP address is remapped to the same instance. For more information, see the Elastic
IP Addresses section of Amazon EC2 Pricing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationId"`: The allocation ID. This is required.
- `"InstanceId"`: The ID of the instance. The instance must have exactly one attached
  network interface. You can specify either the instance ID or the network interface ID, but
  not both.
- `"PublicIp"`: Deprecated.
- `"allowReassociation"`: Reassociation is automatic, but you can specify false to ensure
  the operation fails if the Elastic IP address is already associated with another resource.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"networkInterfaceId"`: The ID of the network interface. If the instance has more than
  one network interface, you must specify a network interface ID. You can specify either the
  instance ID or the network interface ID, but not both.
- `"privateIpAddress"`: The primary or secondary private IP address to associate with the
  Elastic IP address. If no private IP address is specified, the Elastic IP address is
  associated with the primary private IP address.
"""
function associate_address(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("AssociateAddress"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function associate_address(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateAddress", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    associate_client_vpn_target_network(client_vpn_endpoint_id, subnet_id)
    associate_client_vpn_target_network(client_vpn_endpoint_id, subnet_id, params::Dict{String,<:Any})

Associates a target network with a Client VPN endpoint. A target network is a subnet in a
VPC. You can associate multiple subnets from the same VPC with a Client VPN endpoint. You
can associate only one subnet in each Availability Zone. We recommend that you associate at
least two subnets to provide Availability Zone redundancy. If you specified a VPC when you
created the Client VPN endpoint or if you have previous subnet associations, the specified
subnet must be in the same VPC. To specify a subnet that's in a different VPC, you must
first modify the Client VPN endpoint (ModifyClientVpnEndpoint) and change the VPC that's
associated with it.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.
- `subnet_id`: The ID of the subnet to associate with the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_client_vpn_target_network(
    ClientVpnEndpointId, SubnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateClientVpnTargetNetwork",
        Dict{String,Any}(
            "ClientVpnEndpointId" => ClientVpnEndpointId,
            "SubnetId" => SubnetId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_client_vpn_target_network(
    ClientVpnEndpointId,
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateClientVpnTargetNetwork",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                    "SubnetId" => SubnetId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_dhcp_options(dhcp_options_id, vpc_id)
    associate_dhcp_options(dhcp_options_id, vpc_id, params::Dict{String,<:Any})

Associates a set of DHCP options (that you've previously created) with the specified VPC,
or associates no DHCP options with the VPC. After you associate the options with the VPC,
any existing instances and all new instances that you launch in that VPC use the options.
You don't need to restart or relaunch the instances. They automatically pick up the changes
within a few hours, depending on how frequently the instance renews its DHCP lease. You can
explicitly renew the lease using the operating system on the instance. For more
information, see DHCP option sets in the Amazon VPC User Guide.

# Arguments
- `dhcp_options_id`: The ID of the DHCP options set, or default to associate no DHCP
  options with the VPC.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_dhcp_options(
    DhcpOptionsId, VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateDhcpOptions",
        Dict{String,Any}("DhcpOptionsId" => DhcpOptionsId, "VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_dhcp_options(
    DhcpOptionsId,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateDhcpOptions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DhcpOptionsId" => DhcpOptionsId, "VpcId" => VpcId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_enclave_certificate_iam_role(certificate_arn, role_arn)
    associate_enclave_certificate_iam_role(certificate_arn, role_arn, params::Dict{String,<:Any})

Associates an Identity and Access Management (IAM) role with an Certificate Manager (ACM)
certificate. This enables the certificate to be used by the ACM for Nitro Enclaves
application inside an enclave. For more information, see Certificate Manager for Nitro
Enclaves in the Amazon Web Services Nitro Enclaves User Guide. When the IAM role is
associated with the ACM certificate, the certificate, certificate chain, and encrypted
private key are placed in an Amazon S3 location that only the associated IAM role can
access. The private key of the certificate is encrypted with an Amazon Web Services managed
key that has an attached attestation-based key policy. To enable the IAM role to access the
Amazon S3 object, you must grant it permission to call s3:GetObject on the Amazon S3 bucket
returned by the command. To enable the IAM role to access the KMS key, you must grant it
permission to call kms:Decrypt on the KMS key returned by the command. For more
information, see  Grant the role permission to access the certificate and encryption key in
the Amazon Web Services Nitro Enclaves User Guide.

# Arguments
- `certificate_arn`: The ARN of the ACM certificate with which to associate the IAM role.
- `role_arn`: The ARN of the IAM role to associate with the ACM certificate. You can
  associate up to 16 IAM roles with an ACM certificate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_enclave_certificate_iam_role(
    CertificateArn, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateEnclaveCertificateIamRole",
        Dict{String,Any}("CertificateArn" => CertificateArn, "RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_enclave_certificate_iam_role(
    CertificateArn,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateEnclaveCertificateIamRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateArn" => CertificateArn, "RoleArn" => RoleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_iam_instance_profile(iam_instance_profile, instance_id)
    associate_iam_instance_profile(iam_instance_profile, instance_id, params::Dict{String,<:Any})

Associates an IAM instance profile with a running or stopped instance. You cannot associate
more than one IAM instance profile with an instance.

# Arguments
- `iam_instance_profile`: The IAM instance profile.
- `instance_id`: The ID of the instance.

"""
function associate_iam_instance_profile(
    IamInstanceProfile, InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateIamInstanceProfile",
        Dict{String,Any}(
            "IamInstanceProfile" => IamInstanceProfile, "InstanceId" => InstanceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_iam_instance_profile(
    IamInstanceProfile,
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateIamInstanceProfile",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IamInstanceProfile" => IamInstanceProfile, "InstanceId" => InstanceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_instance_event_window(association_target, instance_event_window_id)
    associate_instance_event_window(association_target, instance_event_window_id, params::Dict{String,<:Any})

Associates one or more targets with an event window. Only one type of target (instance IDs,
Dedicated Host IDs, or tags) can be specified with an event window. For more information,
see Define event windows for scheduled events in the Amazon EC2 User Guide.

# Arguments
- `association_target`: One or more targets associated with the specified event window.
- `instance_event_window_id`: The ID of the event window.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_instance_event_window(
    AssociationTarget,
    InstanceEventWindowId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateInstanceEventWindow",
        Dict{String,Any}(
            "AssociationTarget" => AssociationTarget,
            "InstanceEventWindowId" => InstanceEventWindowId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_instance_event_window(
    AssociationTarget,
    InstanceEventWindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateInstanceEventWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationTarget" => AssociationTarget,
                    "InstanceEventWindowId" => InstanceEventWindowId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_ipam_byoasn(asn, cidr)
    associate_ipam_byoasn(asn, cidr, params::Dict{String,<:Any})

Associates your Autonomous System Number (ASN) with a BYOIP CIDR that you own in the same
Amazon Web Services Region. For more information, see Tutorial: Bring your ASN to IPAM in
the Amazon VPC IPAM guide. After the association succeeds, the ASN is eligible for
advertisement. You can view the association with DescribeByoipCidrs. You can advertise the
CIDR with AdvertiseByoipCidr.

# Arguments
- `asn`: A public 2-byte or 4-byte ASN.
- `cidr`: The BYOIP CIDR you want to associate with an ASN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_ipam_byoasn(
    Asn, Cidr; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateIpamByoasn",
        Dict{String,Any}("Asn" => Asn, "Cidr" => Cidr);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_ipam_byoasn(
    Asn,
    Cidr,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateIpamByoasn",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Asn" => Asn, "Cidr" => Cidr), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_ipam_resource_discovery(ipam_id, ipam_resource_discovery_id)
    associate_ipam_resource_discovery(ipam_id, ipam_resource_discovery_id, params::Dict{String,<:Any})

Associates an IPAM resource discovery with an Amazon VPC IPAM. A resource discovery is an
IPAM component that enables IPAM to manage and monitor resources that belong to the owning
account.

# Arguments
- `ipam_id`: An IPAM ID.
- `ipam_resource_discovery_id`: A resource discovery ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A client token.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: Tag specifications.
"""
function associate_ipam_resource_discovery(
    IpamId, IpamResourceDiscoveryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateIpamResourceDiscovery",
        Dict{String,Any}(
            "IpamId" => IpamId,
            "IpamResourceDiscoveryId" => IpamResourceDiscoveryId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_ipam_resource_discovery(
    IpamId,
    IpamResourceDiscoveryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateIpamResourceDiscovery",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IpamId" => IpamId,
                    "IpamResourceDiscoveryId" => IpamResourceDiscoveryId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_nat_gateway_address(allocation_id, nat_gateway_id)
    associate_nat_gateway_address(allocation_id, nat_gateway_id, params::Dict{String,<:Any})

Associates Elastic IP addresses (EIPs) and private IPv4 addresses with a public NAT
gateway. For more information, see Work with NAT gateways in the Amazon VPC User Guide. By
default, you can associate up to 2 Elastic IP addresses per public NAT gateway. You can
increase the limit by requesting a quota adjustment. For more information, see Elastic IP
address quotas in the Amazon VPC User Guide.  When you associate an EIP or secondary EIPs
with a public NAT gateway, the network border group of the EIPs must match the network
border group of the Availability Zone (AZ) that the public NAT gateway is in. If it's not
the same, the EIP will fail to associate. You can see the network border group for the
subnet's AZ by viewing the details of the subnet. Similarly, you can view the network
border group of an EIP by viewing the details of the EIP address. For more information
about network border groups and EIPs, see Allocate an Elastic IP address in the Amazon VPC
User Guide.

# Arguments
- `allocation_id`: The allocation IDs of EIPs that you want to associate with your NAT
  gateway.
- `nat_gateway_id`: The ID of the NAT gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PrivateIpAddress"`: The private IPv4 addresses that you want to assign to the NAT
  gateway.
"""
function associate_nat_gateway_address(
    AllocationId, NatGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateNatGatewayAddress",
        Dict{String,Any}("AllocationId" => AllocationId, "NatGatewayId" => NatGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_nat_gateway_address(
    AllocationId,
    NatGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateNatGatewayAddress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AllocationId" => AllocationId, "NatGatewayId" => NatGatewayId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_route_table(route_table_id)
    associate_route_table(route_table_id, params::Dict{String,<:Any})

Associates a subnet in your VPC or an internet gateway or virtual private gateway attached
to your VPC with a route table in your VPC. This association causes traffic from the subnet
or gateway to be routed according to the routes in the route table. The action returns an
association ID, which you need in order to disassociate the route table later. A route
table can be associated with multiple subnets. For more information, see Route tables in
the Amazon VPC User Guide.

# Arguments
- `route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GatewayId"`: The ID of the internet gateway or virtual private gateway.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"subnetId"`: The ID of the subnet.
"""
function associate_route_table(
    routeTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateRouteTable",
        Dict{String,Any}("routeTableId" => routeTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_route_table(
    routeTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateRouteTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("routeTableId" => routeTableId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_subnet_cidr_block(subnet_id)
    associate_subnet_cidr_block(subnet_id, params::Dict{String,<:Any})

Associates a CIDR block with your subnet. You can only associate a single IPv6 CIDR block
with your subnet.

# Arguments
- `subnet_id`: The ID of your subnet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Ipv6IpamPoolId"`: An IPv6 IPAM pool ID.
- `"Ipv6NetmaskLength"`: An IPv6 netmask length.
- `"ipv6CidrBlock"`: The IPv6 CIDR block for your subnet.
"""
function associate_subnet_cidr_block(
    subnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateSubnetCidrBlock",
        Dict{String,Any}("subnetId" => subnetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_subnet_cidr_block(
    subnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateSubnetCidrBlock",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("subnetId" => subnetId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_transit_gateway_multicast_domain(transit_gateway_attachment_id, transit_gateway_multicast_domain_id, item)
    associate_transit_gateway_multicast_domain(transit_gateway_attachment_id, transit_gateway_multicast_domain_id, item, params::Dict{String,<:Any})

Associates the specified subnets and transit gateway attachments with the specified transit
gateway multicast domain. The transit gateway attachment must be in the available state
before you can add a resource. Use DescribeTransitGatewayAttachments to see the state of
the attachment.

# Arguments
- `transit_gateway_attachment_id`: The ID of the transit gateway attachment to associate
  with the transit gateway multicast domain.
- `transit_gateway_multicast_domain_id`: The ID of the transit gateway multicast domain.
- `item`: The IDs of the subnets to associate with the transit gateway multicast domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"SubnetIds"`: The IDs of the subnets to associate with the transit gateway multicast
  domain.
"""
function associate_transit_gateway_multicast_domain(
    TransitGatewayAttachmentId,
    TransitGatewayMulticastDomainId,
    item;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayMulticastDomain",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId,
            "item" => item,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_transit_gateway_multicast_domain(
    TransitGatewayAttachmentId,
    TransitGatewayMulticastDomainId,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayMulticastDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId,
                    "item" => item,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_transit_gateway_policy_table(transit_gateway_attachment_id, transit_gateway_policy_table_id)
    associate_transit_gateway_policy_table(transit_gateway_attachment_id, transit_gateway_policy_table_id, params::Dict{String,<:Any})

Associates the specified transit gateway attachment with a transit gateway policy table.

# Arguments
- `transit_gateway_attachment_id`: The ID of the transit gateway attachment to associate
  with the policy table.
- `transit_gateway_policy_table_id`: The ID of the transit gateway policy table to
  associate with the transit gateway attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_transit_gateway_policy_table(
    TransitGatewayAttachmentId,
    TransitGatewayPolicyTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayPolicyTable",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_transit_gateway_policy_table(
    TransitGatewayAttachmentId,
    TransitGatewayPolicyTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayPolicyTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_transit_gateway_route_table(transit_gateway_attachment_id, transit_gateway_route_table_id)
    associate_transit_gateway_route_table(transit_gateway_attachment_id, transit_gateway_route_table_id, params::Dict{String,<:Any})

Associates the specified attachment with the specified transit gateway route table. You can
associate only one route table with an attachment.

# Arguments
- `transit_gateway_attachment_id`: The ID of the attachment.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function associate_transit_gateway_route_table(
    TransitGatewayAttachmentId,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayRouteTable",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_transit_gateway_route_table(
    TransitGatewayAttachmentId,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTransitGatewayRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_trunk_interface(branch_interface_id, trunk_interface_id)
    associate_trunk_interface(branch_interface_id, trunk_interface_id, params::Dict{String,<:Any})

Associates a branch network interface with a trunk network interface. Before you create the
association, use CreateNetworkInterface command and set the interface type to trunk. You
must also create a network interface for each branch network interface that you want to
associate with the trunk network interface.

# Arguments
- `branch_interface_id`: The ID of the branch network interface.
- `trunk_interface_id`: The ID of the trunk network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GreKey"`: The application key. This applies to the GRE protocol.
- `"VlanId"`: The ID of the VLAN. This applies to the VLAN protocol.
"""
function associate_trunk_interface(
    BranchInterfaceId, TrunkInterfaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateTrunkInterface",
        Dict{String,Any}(
            "BranchInterfaceId" => BranchInterfaceId,
            "TrunkInterfaceId" => TrunkInterfaceId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_trunk_interface(
    BranchInterfaceId,
    TrunkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AssociateTrunkInterface",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BranchInterfaceId" => BranchInterfaceId,
                    "TrunkInterfaceId" => TrunkInterfaceId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_vpc_cidr_block(vpc_id)
    associate_vpc_cidr_block(vpc_id, params::Dict{String,<:Any})

Associates a CIDR block with your VPC. You can associate a secondary IPv4 CIDR block, an
Amazon-provided IPv6 CIDR block, or an IPv6 CIDR block from an IPv6 address pool that you
provisioned through bring your own IP addresses (BYOIP). You must specify one of the
following in the request: an IPv4 CIDR block, an IPv6 pool, or an Amazon-provided IPv6 CIDR
block. For more information about associating CIDR blocks with your VPC and applicable
restrictions, see IP addressing for your VPCs and subnets in the Amazon VPC User Guide.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CidrBlock"`: An IPv4 CIDR block to associate with the VPC.
- `"Ipv4IpamPoolId"`: Associate a CIDR allocated from an IPv4 IPAM pool to a VPC. For more
  information about Amazon VPC IP Address Manager (IPAM), see What is IPAM? in the Amazon VPC
  IPAM User Guide.
- `"Ipv4NetmaskLength"`: The netmask length of the IPv4 CIDR you would like to associate
  from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see
  What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv6CidrBlock"`: An IPv6 CIDR block from the IPv6 address pool. You must also specify
  Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this
  parameter.
- `"Ipv6CidrBlockNetworkBorderGroup"`: The name of the location from which we advertise the
  IPV6 CIDR block. Use this parameter to limit the CIDR block to this location.  You must set
  AmazonProvidedIpv6CidrBlock to true to use this parameter.  You can have one IPv6 CIDR
  block association per network border group.
- `"Ipv6IpamPoolId"`: Associates a CIDR allocated from an IPv6 IPAM pool to a VPC. For more
  information about Amazon VPC IP Address Manager (IPAM), see What is IPAM? in the Amazon VPC
  IPAM User Guide.
- `"Ipv6NetmaskLength"`: The netmask length of the IPv6 CIDR you would like to associate
  from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see
  What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv6Pool"`: The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
- `"amazonProvidedIpv6CidrBlock"`: Requests an Amazon-provided IPv6 CIDR block with a /56
  prefix length for the VPC. You cannot specify the range of IPv6 addresses or the size of
  the CIDR block.
"""
function associate_vpc_cidr_block(vpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "AssociateVpcCidrBlock",
        Dict{String,Any}("vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_vpc_cidr_block(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AssociateVpcCidrBlock",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("vpcId" => vpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_classic_link_vpc(security_group_id, instance_id, vpc_id)
    attach_classic_link_vpc(security_group_id, instance_id, vpc_id, params::Dict{String,<:Any})

 This action is deprecated.  Links an EC2-Classic instance to a ClassicLink-enabled VPC
through one or more of the VPC security groups. You cannot link an EC2-Classic instance to
more than one VPC at a time. You can only link an instance that's in the running state. An
instance is automatically unlinked from a VPC when it's stopped - you can link it to the
VPC again when you restart it. After you've linked an instance, you cannot change the VPC
security groups that are associated with it. To change the security groups, you must first
unlink the instance, and then link it again. Linking your instance to a VPC is sometimes
referred to as attaching your instance.

# Arguments
- `security_group_id`: The IDs of the security groups. You cannot specify security groups
  from a different VPC.
- `instance_id`: The ID of the EC2-Classic instance.
- `vpc_id`: The ID of the ClassicLink-enabled VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_classic_link_vpc(
    SecurityGroupId, instanceId, vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AttachClassicLinkVpc",
        Dict{String,Any}(
            "SecurityGroupId" => SecurityGroupId,
            "instanceId" => instanceId,
            "vpcId" => vpcId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_classic_link_vpc(
    SecurityGroupId,
    instanceId,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachClassicLinkVpc",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SecurityGroupId" => SecurityGroupId,
                    "instanceId" => instanceId,
                    "vpcId" => vpcId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_internet_gateway(internet_gateway_id, vpc_id)
    attach_internet_gateway(internet_gateway_id, vpc_id, params::Dict{String,<:Any})

Attaches an internet gateway or a virtual private gateway to a VPC, enabling connectivity
between the internet and the VPC. For more information, see Internet gateways in the Amazon
VPC User Guide.

# Arguments
- `internet_gateway_id`: The ID of the internet gateway.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_internet_gateway(
    internetGatewayId, vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AttachInternetGateway",
        Dict{String,Any}("internetGatewayId" => internetGatewayId, "vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_internet_gateway(
    internetGatewayId,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachInternetGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "internetGatewayId" => internetGatewayId, "vpcId" => vpcId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_network_interface(device_index, instance_id, network_interface_id)
    attach_network_interface(device_index, instance_id, network_interface_id, params::Dict{String,<:Any})

Attaches a network interface to an instance.

# Arguments
- `device_index`: The index of the device for the network interface attachment.
- `instance_id`: The ID of the instance.
- `network_interface_id`: The ID of the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EnaSrdSpecification"`: Configures ENA Express for the network interface that this
  action attaches to the instance.
- `"NetworkCardIndex"`: The index of the network card. Some instance types support multiple
  network cards. The primary network interface must be assigned to network card index 0. The
  default is network card index 0.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_network_interface(
    deviceIndex,
    instanceId,
    networkInterfaceId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachNetworkInterface",
        Dict{String,Any}(
            "deviceIndex" => deviceIndex,
            "instanceId" => instanceId,
            "networkInterfaceId" => networkInterfaceId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_network_interface(
    deviceIndex,
    instanceId,
    networkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachNetworkInterface",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "deviceIndex" => deviceIndex,
                    "instanceId" => instanceId,
                    "networkInterfaceId" => networkInterfaceId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_verified_access_trust_provider(verified_access_instance_id, verified_access_trust_provider_id)
    attach_verified_access_trust_provider(verified_access_instance_id, verified_access_trust_provider_id, params::Dict{String,<:Any})

Attaches the specified Amazon Web Services Verified Access trust provider to the specified
Amazon Web Services Verified Access instance.

# Arguments
- `verified_access_instance_id`: The ID of the Verified Access instance.
- `verified_access_trust_provider_id`: The ID of the Verified Access trust provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_verified_access_trust_provider(
    VerifiedAccessInstanceId,
    VerifiedAccessTrustProviderId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachVerifiedAccessTrustProvider",
        Dict{String,Any}(
            "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
            "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_verified_access_trust_provider(
    VerifiedAccessInstanceId,
    VerifiedAccessTrustProviderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachVerifiedAccessTrustProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
                    "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_volume(device, instance_id, volume_id)
    attach_volume(device, instance_id, volume_id, params::Dict{String,<:Any})

Attaches an EBS volume to a running or stopped instance and exposes it to the instance with
the specified device name. Encrypted EBS volumes must be attached to instances that support
Amazon EBS encryption. For more information, see Amazon EBS encryption in the Amazon EBS
User Guide. After you attach an EBS volume, you must make it available. For more
information, see Make an EBS volume available for use. If a volume has an Amazon Web
Services Marketplace product code:   The volume can be attached only to a stopped instance.
  Amazon Web Services Marketplace product codes are copied from the volume to the instance.
  You must be subscribed to the product.   The instance type and operating system of the
instance must support the product. For example, you can't detach a volume from a Windows
instance and attach it to a Linux instance.   For more information, see Attach an Amazon
EBS volume to an instance in the Amazon EBS User Guide.

# Arguments
- `device`: The device name (for example, /dev/sdh or xvdh).
- `instance_id`: The ID of the instance.
- `volume_id`: The ID of the EBS volume. The volume and instance must be within the same
  Availability Zone.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_volume(
    Device, InstanceId, VolumeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AttachVolume",
        Dict{String,Any}(
            "Device" => Device, "InstanceId" => InstanceId, "VolumeId" => VolumeId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_volume(
    Device,
    InstanceId,
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachVolume",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Device" => Device, "InstanceId" => InstanceId, "VolumeId" => VolumeId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    attach_vpn_gateway(vpc_id, vpn_gateway_id)
    attach_vpn_gateway(vpc_id, vpn_gateway_id, params::Dict{String,<:Any})

Attaches a virtual private gateway to a VPC. You can attach one virtual private gateway to
one VPC at a time. For more information, see Amazon Web Services Site-to-Site VPN in the
Amazon Web Services Site-to-Site VPN User Guide.

# Arguments
- `vpc_id`: The ID of the VPC.
- `vpn_gateway_id`: The ID of the virtual private gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function attach_vpn_gateway(
    VpcId, VpnGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AttachVpnGateway",
        Dict{String,Any}("VpcId" => VpcId, "VpnGatewayId" => VpnGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function attach_vpn_gateway(
    VpcId,
    VpnGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AttachVpnGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VpcId" => VpcId, "VpnGatewayId" => VpnGatewayId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_client_vpn_ingress(client_vpn_endpoint_id, target_network_cidr)
    authorize_client_vpn_ingress(client_vpn_endpoint_id, target_network_cidr, params::Dict{String,<:Any})

Adds an ingress authorization rule to a Client VPN endpoint. Ingress authorization rules
act as firewall rules that grant access to networks. You must configure ingress
authorization rules to enable clients to access resources in Amazon Web Services or
on-premises networks.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.
- `target_network_cidr`: The IPv4 address range, in CIDR notation, of the network for which
  access is being authorized.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AccessGroupId"`: The ID of the group to grant access to, for example, the Active
  Directory group or identity provider (IdP) group. Required if AuthorizeAllGroups is false
  or not specified.
- `"AuthorizeAllGroups"`: Indicates whether to grant access to all clients. Specify true to
  grant all clients who successfully establish a VPN connection access to the network. Must
  be set to true if AccessGroupId is not specified.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A brief description of the authorization rule.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function authorize_client_vpn_ingress(
    ClientVpnEndpointId,
    TargetNetworkCidr;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AuthorizeClientVpnIngress",
        Dict{String,Any}(
            "ClientVpnEndpointId" => ClientVpnEndpointId,
            "TargetNetworkCidr" => TargetNetworkCidr,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_client_vpn_ingress(
    ClientVpnEndpointId,
    TargetNetworkCidr,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AuthorizeClientVpnIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                    "TargetNetworkCidr" => TargetNetworkCidr,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_security_group_egress(group_id)
    authorize_security_group_egress(group_id, params::Dict{String,<:Any})

Adds the specified outbound (egress) rules to a security group. An outbound rule permits
instances to send traffic to the specified IPv4 or IPv6 address ranges, the IP address
ranges specified by a prefix list, or the instances that are associated with a source
security group. For more information, see Security group rules. You must specify exactly
one of the following destinations: an IPv4 or IPv6 address range, a prefix list, or a
security group. You must specify a protocol for each rule (for example, TCP). If the
protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP
or ICMPv6, you must also specify the ICMP type and code. Rule changes are propagated to
instances associated with the security group as quickly as possible. However, a small delay
might occur. For examples of rules that you can add to security groups for specific access
scenarios, see Security group rules for different use cases in the Amazon EC2 User Guide.
For information about security group quotas, see Amazon VPC quotas in the Amazon VPC User
Guide.

# Arguments
- `group_id`: The ID of the security group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags applied to the security group rule.
- `"cidrIp"`: Not supported. Use IP permissions instead.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"fromPort"`: Not supported. Use IP permissions instead.
- `"ipPermissions"`: The permissions for the security group rules.
- `"ipProtocol"`: Not supported. Use IP permissions instead.
- `"sourceSecurityGroupName"`: Not supported. Use IP permissions instead.
- `"sourceSecurityGroupOwnerId"`: Not supported. Use IP permissions instead.
- `"toPort"`: Not supported. Use IP permissions instead.
"""
function authorize_security_group_egress(
    groupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AuthorizeSecurityGroupEgress",
        Dict{String,Any}("groupId" => groupId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_security_group_egress(
    groupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "AuthorizeSecurityGroupEgress",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("groupId" => groupId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_security_group_ingress()
    authorize_security_group_ingress(params::Dict{String,<:Any})

Adds the specified inbound (ingress) rules to a security group. An inbound rule permits
instances to receive traffic from the specified IPv4 or IPv6 address range, the IP address
ranges that are specified by a prefix list, or the instances that are associated with a
destination security group. For more information, see Security group rules. You must
specify exactly one of the following sources: an IPv4 or IPv6 address range, a prefix list,
or a security group. You must specify a protocol for each rule (for example, TCP). If the
protocol is TCP or UDP, you must also specify a port or port range. If the protocol is ICMP
or ICMPv6, you must also specify the ICMP/ICMPv6 type and code. Rule changes are propagated
to instances associated with the security group as quickly as possible. However, a small
delay might occur. For examples of rules that you can add to security groups for specific
access scenarios, see Security group rules for different use cases in the Amazon EC2 User
Guide. For more information about security group quotas, see Amazon VPC quotas in the
Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CidrIp"`: The IPv4 address range, in CIDR format. To specify an IPv6 address range, use
  IP permissions instead. To specify multiple rules and descriptions for the rules, use IP
  permissions instead.
- `"FromPort"`: If the protocol is TCP or UDP, this is the start of the port range. If the
  protocol is ICMP, this is the ICMP type or -1 (all ICMP types). To specify multiple rules
  and descriptions for the rules, use IP permissions instead.
- `"GroupId"`: The ID of the security group.
- `"GroupName"`: [Default VPC] The name of the security group. For security groups for a
  default VPC you can specify either the ID or the name of the security group. For security
  groups for a nondefault VPC, you must specify the ID of the security group.
- `"IpPermissions"`: The permissions for the security group rules.
- `"IpProtocol"`: The IP protocol name (tcp, udp, icmp) or number (see Protocol Numbers).
  To specify all protocols, use -1. To specify icmpv6, use IP permissions instead. If you
  specify a protocol other than one of the supported values, traffic is allowed on all ports,
  regardless of any ports that you specify. To specify multiple rules and descriptions for
  the rules, use IP permissions instead.
- `"SourceSecurityGroupName"`: [Default VPC] The name of the source security group. The
  rule grants full ICMP, UDP, and TCP access. To create a rule with a specific protocol and
  port range, specify a set of IP permissions instead.
- `"SourceSecurityGroupOwnerId"`: The Amazon Web Services account ID for the source
  security group, if the source security group is in a different account. The rule grants
  full ICMP, UDP, and TCP access. To create a rule with a specific protocol and port range,
  use IP permissions instead.
- `"TagSpecification"`: The tags applied to the security group rule.
- `"ToPort"`: If the protocol is TCP or UDP, this is the end of the port range. If the
  protocol is ICMP, this is the ICMP code or -1 (all ICMP codes). If the start port is -1
  (all ICMP types), then the end port must be -1 (all ICMP codes). To specify multiple rules
  and descriptions for the rules, use IP permissions instead.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function authorize_security_group_ingress(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AuthorizeSecurityGroupIngress";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_security_group_ingress(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "AuthorizeSecurityGroupIngress",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    bundle_instance(instance_id, storage)
    bundle_instance(instance_id, storage, params::Dict{String,<:Any})

Bundles an Amazon instance store-backed Windows instance. During bundling, only the root
device volume (C:) is bundled. Data on other instance store volumes is not preserved.  This
action is not applicable for Linux/Unix instances or Windows instances that are backed by
Amazon EBS.

# Arguments
- `instance_id`: The ID of the instance to bundle. Default: None
- `storage`: The bucket in which to store the AMI. You can specify a bucket that you
  already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket
  that belongs to someone else, Amazon EC2 returns an error.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function bundle_instance(
    InstanceId, Storage; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "BundleInstance",
        Dict{String,Any}("InstanceId" => InstanceId, "Storage" => Storage);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function bundle_instance(
    InstanceId,
    Storage,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "BundleInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "Storage" => Storage),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_bundle_task(bundle_id)
    cancel_bundle_task(bundle_id, params::Dict{String,<:Any})

Cancels a bundling operation for an instance store-backed Windows instance.

# Arguments
- `bundle_id`: The ID of the bundle task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_bundle_task(BundleId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CancelBundleTask",
        Dict{String,Any}("BundleId" => BundleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_bundle_task(
    BundleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelBundleTask",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("BundleId" => BundleId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_capacity_reservation(capacity_reservation_id)
    cancel_capacity_reservation(capacity_reservation_id, params::Dict{String,<:Any})

Cancels the specified Capacity Reservation, releases the reserved capacity, and changes the
Capacity Reservation's state to cancelled. Instances running in the reserved capacity
continue running until you stop them. Stopped instances that target the Capacity
Reservation can no longer launch. Modify these instances to either target a different
Capacity Reservation, launch On-Demand Instance capacity, or run in any open Capacity
Reservation that has matching attributes and sufficient capacity.

# Arguments
- `capacity_reservation_id`: The ID of the Capacity Reservation to be cancelled.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_capacity_reservation(
    CapacityReservationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelCapacityReservation",
        Dict{String,Any}("CapacityReservationId" => CapacityReservationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_capacity_reservation(
    CapacityReservationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelCapacityReservation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CapacityReservationId" => CapacityReservationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_capacity_reservation_fleets(capacity_reservation_fleet_id)
    cancel_capacity_reservation_fleets(capacity_reservation_fleet_id, params::Dict{String,<:Any})

Cancels one or more Capacity Reservation Fleets. When you cancel a Capacity Reservation
Fleet, the following happens:   The Capacity Reservation Fleet's status changes to
cancelled.   The individual Capacity Reservations in the Fleet are cancelled. Instances
running in the Capacity Reservations at the time of cancelling the Fleet continue to run in
shared capacity.   The Fleet stops creating new Capacity Reservations.

# Arguments
- `capacity_reservation_fleet_id`: The IDs of the Capacity Reservation Fleets to cancel.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_capacity_reservation_fleets(
    CapacityReservationFleetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelCapacityReservationFleets",
        Dict{String,Any}("CapacityReservationFleetId" => CapacityReservationFleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_capacity_reservation_fleets(
    CapacityReservationFleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelCapacityReservationFleets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CapacityReservationFleetId" => CapacityReservationFleetId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_conversion_task(conversion_task_id)
    cancel_conversion_task(conversion_task_id, params::Dict{String,<:Any})

Cancels an active conversion task. The task can be the import of an instance or volume. The
action removes all artifacts of the conversion, including a partially uploaded volume or
instance. If the conversion is complete or is in the process of transferring the final disk
image, the command fails and returns an exception. For more information, see Importing a
Virtual Machine Using the Amazon EC2 CLI.

# Arguments
- `conversion_task_id`: The ID of the conversion task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"reasonMessage"`: The reason for canceling the conversion task.
"""
function cancel_conversion_task(
    conversionTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelConversionTask",
        Dict{String,Any}("conversionTaskId" => conversionTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_conversion_task(
    conversionTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelConversionTask",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("conversionTaskId" => conversionTaskId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_export_task(export_task_id)
    cancel_export_task(export_task_id, params::Dict{String,<:Any})

Cancels an active export task. The request removes all artifacts of the export, including
any partially-created Amazon S3 objects. If the export task is complete or is in the
process of transferring the final disk image, the command fails and returns an error.

# Arguments
- `export_task_id`: The ID of the export task. This is the ID returned by the
  CreateInstanceExportTask and ExportImage operations.

"""
function cancel_export_task(
    exportTaskId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelExportTask",
        Dict{String,Any}("exportTaskId" => exportTaskId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_export_task(
    exportTaskId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelExportTask",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("exportTaskId" => exportTaskId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_image_launch_permission(image_id)
    cancel_image_launch_permission(image_id, params::Dict{String,<:Any})

Removes your Amazon Web Services account from the launch permissions for the specified AMI.
For more information, see  Cancel having an AMI shared with your Amazon Web Services
account in the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI that was shared with your Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_image_launch_permission(
    ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelImageLaunchPermission",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_image_launch_permission(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelImageLaunchPermission",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_import_task()
    cancel_import_task(params::Dict{String,<:Any})

Cancels an in-process import virtual machine or import snapshot task.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CancelReason"`: The reason for canceling the task.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ImportTaskId"`: The ID of the import image or import snapshot task to be canceled.
"""
function cancel_import_task(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("CancelImportTask"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function cancel_import_task(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelImportTask", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    cancel_reserved_instances_listing(reserved_instances_listing_id)
    cancel_reserved_instances_listing(reserved_instances_listing_id, params::Dict{String,<:Any})

Cancels the specified Reserved Instance listing in the Reserved Instance Marketplace. For
more information, see Sell in the Reserved Instance Marketplace in the Amazon EC2 User
Guide.

# Arguments
- `reserved_instances_listing_id`: The ID of the Reserved Instance listing.

"""
function cancel_reserved_instances_listing(
    reservedInstancesListingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelReservedInstancesListing",
        Dict{String,Any}("reservedInstancesListingId" => reservedInstancesListingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_reserved_instances_listing(
    reservedInstancesListingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelReservedInstancesListing",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "reservedInstancesListingId" => reservedInstancesListingId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_spot_fleet_requests(spot_fleet_request_id, terminate_instances)
    cancel_spot_fleet_requests(spot_fleet_request_id, terminate_instances, params::Dict{String,<:Any})

Cancels the specified Spot Fleet requests. After you cancel a Spot Fleet request, the Spot
Fleet launches no new instances. You must also specify whether a canceled Spot Fleet
request should terminate its instances. If you choose to terminate the instances, the Spot
Fleet request enters the cancelled_terminating state. Otherwise, the Spot Fleet request
enters the cancelled_running state and the instances continue to run until they are
interrupted or you terminate them manually.  Restrictions    You can delete up to 100
fleets in a single request. If you exceed the specified number, no fleets are deleted.

# Arguments
- `spot_fleet_request_id`: The IDs of the Spot Fleet requests. Constraint: You can specify
  up to 100 IDs in a single request.
- `terminate_instances`: Indicates whether to terminate the associated instances when the
  Spot Fleet request is canceled. The default is to terminate the instances. To let the
  instances continue to run after the Spot Fleet request is canceled, specify
  no-terminate-instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_spot_fleet_requests(
    spotFleetRequestId,
    terminateInstances;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelSpotFleetRequests",
        Dict{String,Any}(
            "spotFleetRequestId" => spotFleetRequestId,
            "terminateInstances" => terminateInstances,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_spot_fleet_requests(
    spotFleetRequestId,
    terminateInstances,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelSpotFleetRequests",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "spotFleetRequestId" => spotFleetRequestId,
                    "terminateInstances" => terminateInstances,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_spot_instance_requests(spot_instance_request_id)
    cancel_spot_instance_requests(spot_instance_request_id, params::Dict{String,<:Any})

Cancels one or more Spot Instance requests.  Canceling a Spot Instance request does not
terminate running Spot Instances associated with the request.

# Arguments
- `spot_instance_request_id`: The IDs of the Spot Instance requests.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function cancel_spot_instance_requests(
    SpotInstanceRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CancelSpotInstanceRequests",
        Dict{String,Any}("SpotInstanceRequestId" => SpotInstanceRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_spot_instance_requests(
    SpotInstanceRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CancelSpotInstanceRequests",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SpotInstanceRequestId" => SpotInstanceRequestId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    confirm_product_instance(instance_id, product_code)
    confirm_product_instance(instance_id, product_code, params::Dict{String,<:Any})

Determines whether a product code is associated with an instance. This action can only be
used by the owner of the product code. It is useful when a product code owner must verify
whether another user's instance is eligible for support.

# Arguments
- `instance_id`: The ID of the instance.
- `product_code`: The product code. This must be a product code that you own.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function confirm_product_instance(
    InstanceId, ProductCode; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "ConfirmProductInstance",
        Dict{String,Any}("InstanceId" => InstanceId, "ProductCode" => ProductCode);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function confirm_product_instance(
    InstanceId,
    ProductCode,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ConfirmProductInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceId" => InstanceId, "ProductCode" => ProductCode),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_fpga_image(source_fpga_image_id, source_region)
    copy_fpga_image(source_fpga_image_id, source_region, params::Dict{String,<:Any})

Copies the specified Amazon FPGA Image (AFI) to the current Region.

# Arguments
- `source_fpga_image_id`: The ID of the source AFI.
- `source_region`: The Region that contains the source AFI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: The description for the new AFI.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Name"`: The name for the new AFI. The default is the name of the source AFI.
"""
function copy_fpga_image(
    SourceFpgaImageId, SourceRegion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CopyFpgaImage",
        Dict{String,Any}(
            "SourceFpgaImageId" => SourceFpgaImageId, "SourceRegion" => SourceRegion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_fpga_image(
    SourceFpgaImageId,
    SourceRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CopyFpgaImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceFpgaImageId" => SourceFpgaImageId, "SourceRegion" => SourceRegion
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_image(name, source_image_id, source_region)
    copy_image(name, source_image_id, source_region, params::Dict{String,<:Any})

Initiates the copy of an AMI. You can copy an AMI from one Region to another, or from a
Region to an Outpost. You can't copy an AMI from an Outpost to a Region, from one Outpost
to another, or within the same Outpost. To copy an AMI to another partition, see
CreateStoreImageTask. To copy an AMI from one Region to another, specify the source Region
using the SourceRegion parameter, and specify the destination Region using its endpoint.
Copies of encrypted backing snapshots for the AMI are encrypted. Copies of unencrypted
backing snapshots remain unencrypted, unless you set Encrypted during the copy operation.
You cannot create an unencrypted copy of an encrypted backing snapshot. To copy an AMI from
a Region to an Outpost, specify the source Region using the SourceRegion parameter, and
specify the ARN of the destination Outpost using DestinationOutpostArn. Backing snapshots
copied to an Outpost are encrypted by default using the default encryption key for the
Region, or a different key that you specify in the request using KmsKeyId. Outposts do not
support unencrypted snapshots. For more information,  Amazon EBS local snapshots on
Outposts in the Amazon EBS User Guide. For more information about the prerequisites and
limits when copying an AMI, see Copy an AMI in the Amazon EC2 User Guide.

# Arguments
- `name`: The name of the new AMI in the destination Region.
- `source_image_id`: The ID of the AMI to copy.
- `source_region`: The name of the Region that contains the AMI to copy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure idempotency of
  the request. For more information, see Ensuring idempotency in the Amazon EC2 API Reference.
- `"CopyImageTags"`: Indicates whether to include your user-defined AMI tags when copying
  the AMI. The following tags will not be copied:   System tags (prefixed with aws:)   For
  public and shared AMIs, user-defined tags that are attached by other Amazon Web Services
  accounts   Default: Your user-defined AMI tags are not copied.
- `"Description"`: A description for the new AMI in the destination Region.
- `"DestinationOutpostArn"`: The Amazon Resource Name (ARN) of the Outpost to which to copy
  the AMI. Only specify this parameter when copying an AMI from an Amazon Web Services Region
  to an Outpost. The AMI must be in the Region of the destination Outpost. You cannot copy an
  AMI from an Outpost to a Region, from one Outpost to another, or within the same Outpost.
  For more information, see Copy AMIs from an Amazon Web Services Region to an Outpost in the
  Amazon EBS User Guide.
- `"TagSpecification"`: The tags to apply to the new AMI and new snapshots. You can tag the
  AMI, the snapshots, or both.   To tag the new AMI, the value for ResourceType must be
  image.   To tag the new snapshots, the value for ResourceType must be snapshot. The same
  tag is applied to all the new snapshots.   If you specify other values for ResourceType,
  the request fails. To tag an AMI or snapshot after it has been created, see CreateTags.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"encrypted"`: Specifies whether the destination snapshots of the copied image should be
  encrypted. You can encrypt a copy of an unencrypted snapshot, but you cannot create an
  unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is used
  unless you specify a non-default Key Management Service (KMS) KMS key using KmsKeyId. For
  more information, see Amazon EBS encryption in the Amazon EBS User Guide.
- `"kmsKeyId"`: The identifier of the symmetric Key Management Service (KMS) KMS key to use
  when creating encrypted volumes. If this parameter is not specified, your Amazon Web
  Services managed KMS key for Amazon EBS is used. If you specify a KMS key, you must also
  set the encrypted state to true. You can specify a KMS key using any of the following:
  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example,
  alias/ExampleAlias.   Key ARN. For example,
  arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN.
  For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services
  authenticates the KMS key asynchronously. Therefore, if you specify an identifier that is
  not valid, the action can appear to complete, but eventually fails. The specified KMS key
  must exist in the destination Region. Amazon EBS does not support asymmetric KMS keys.
"""
function copy_image(
    Name, SourceImageId, SourceRegion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CopyImage",
        Dict{String,Any}(
            "Name" => Name, "SourceImageId" => SourceImageId, "SourceRegion" => SourceRegion
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_image(
    Name,
    SourceImageId,
    SourceRegion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CopyImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Name" => Name,
                    "SourceImageId" => SourceImageId,
                    "SourceRegion" => SourceRegion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_snapshot(source_region, source_snapshot_id)
    copy_snapshot(source_region, source_snapshot_id, params::Dict{String,<:Any})

Copies a point-in-time snapshot of an EBS volume and stores it in Amazon S3. You can copy a
snapshot within the same Region, from one Region to another, or from a Region to an
Outpost. You can't copy a snapshot from an Outpost to a Region, from one Outpost to
another, or within the same Outpost. You can use the snapshot to create EBS volumes or
Amazon Machine Images (AMIs). When copying snapshots to a Region, copies of encrypted EBS
snapshots remain encrypted. Copies of unencrypted snapshots remain unencrypted, unless you
enable encryption for the snapshot copy operation. By default, encrypted snapshot copies
use the default KMS key; however, you can specify a different KMS key. To copy an encrypted
snapshot that has been shared from another account, you must have permissions for the KMS
key used to encrypt the snapshot. Snapshots copied to an Outpost are encrypted by default
using the default encryption key for the Region, or a different key that you specify in the
request using KmsKeyId. Outposts do not support unencrypted snapshots. For more
information,  Amazon EBS local snapshots on Outposts in the Amazon EBS User Guide.
Snapshots created by copying another snapshot have an arbitrary volume ID that should not
be used for any purpose. For more information, see Copy an Amazon EBS snapshot in the
Amazon EBS User Guide.

# Arguments
- `source_region`: The ID of the Region that contains the snapshot to be copied.
- `source_snapshot_id`: The ID of the EBS snapshot to copy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the EBS snapshot.
- `"DestinationOutpostArn"`: The Amazon Resource Name (ARN) of the Outpost to which to copy
  the snapshot. Only specify this parameter when copying a snapshot from an Amazon Web
  Services Region to an Outpost. The snapshot must be in the Region for the destination
  Outpost. You cannot copy a snapshot from an Outpost to a Region, from one Outpost to
  another, or within the same Outpost. For more information, see  Copy snapshots from an
  Amazon Web Services Region to an Outpost in the Amazon EBS User Guide.
- `"TagSpecification"`: The tags to apply to the new snapshot.
- `"destinationRegion"`: The destination Region to use in the PresignedUrl parameter of a
  snapshot copy operation. This parameter is only valid for specifying the destination Region
  in a PresignedUrl parameter, where it is required. The snapshot copy is sent to the
  regional endpoint that you sent the HTTP request to (for example,
  ec2.us-east-1.amazonaws.com). With the CLI, this is specified using the --region parameter
  or the default Region in your Amazon Web Services configuration file.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"encrypted"`: To encrypt a copy of an unencrypted snapshot if encryption by default is
  not enabled, enable encryption using this parameter. Otherwise, omit this parameter.
  Encrypted snapshots are encrypted, even if you omit this parameter and encryption by
  default is not enabled. You cannot set this parameter to false. For more information, see
  Amazon EBS encryption in the Amazon EBS User Guide.
- `"kmsKeyId"`: The identifier of the KMS key to use for Amazon EBS encryption. If this
  parameter is not specified, your KMS key for Amazon EBS is used. If KmsKeyId is specified,
  the encrypted state must be true. You can specify the KMS key using any of the following:
  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example,
  alias/ExampleAlias.   Key ARN. For example,
  arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN.
  For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services
  authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN
  that is not valid, the action can appear to complete, but eventually fails.
- `"presignedUrl"`: When you copy an encrypted source snapshot using the Amazon EC2 Query
  API, you must supply a pre-signed URL. This parameter is optional for unencrypted
  snapshots. For more information, see Query requests. The PresignedUrl should use the
  snapshot source endpoint, the CopySnapshot action, and include the SourceRegion,
  SourceSnapshotId, and DestinationRegion parameters. The PresignedUrl must be signed using
  Amazon Web Services Signature Version 4. Because EBS snapshots are stored in Amazon S3, the
  signing algorithm for this parameter uses the same logic that is described in
  Authenticating Requests: Using Query Parameters (Amazon Web Services Signature Version 4)
  in the Amazon S3 API Reference. An invalid or improperly signed PresignedUrl will cause the
  copy operation to fail asynchronously, and the snapshot will move to an error state.
"""
function copy_snapshot(
    SourceRegion, SourceSnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CopySnapshot",
        Dict{String,Any}(
            "SourceRegion" => SourceRegion, "SourceSnapshotId" => SourceSnapshotId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_snapshot(
    SourceRegion,
    SourceSnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CopySnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceRegion" => SourceRegion, "SourceSnapshotId" => SourceSnapshotId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_capacity_reservation(instance_count, instance_platform, instance_type)
    create_capacity_reservation(instance_count, instance_platform, instance_type, params::Dict{String,<:Any})

Creates a new Capacity Reservation with the specified attributes. Capacity Reservations
enable you to reserve capacity for your Amazon EC2 instances in a specific Availability
Zone for any duration. This gives you the flexibility to selectively add capacity
reservations and still get the Regional RI discounts for that usage. By creating Capacity
Reservations, you ensure that you always have access to Amazon EC2 capacity when you need
it, for as long as you need it. For more information, see Capacity Reservations in the
Amazon EC2 User Guide. Your request to create a Capacity Reservation could fail if Amazon
EC2 does not have sufficient capacity to fulfill the request. If your request fails due to
Amazon EC2 capacity constraints, either try again at a later time, try in a different
Availability Zone, or request a smaller capacity reservation. If your application is
flexible across instance types and sizes, try to create a Capacity Reservation with
different instance attributes. Your request could also fail if the requested quantity
exceeds your On-Demand Instance limit for the selected instance type. If your request fails
due to limit constraints, increase your On-Demand Instance limit for the required instance
type and try again. For more information about increasing your instance limits, see Amazon
EC2 Service Quotas in the Amazon EC2 User Guide.

# Arguments
- `instance_count`: The number of instances for which to reserve capacity. Valid range: 1 -
  1000
- `instance_platform`: The type of operating system for which to reserve capacity.
- `instance_type`: The instance type for which to reserve capacity. For more information,
  see Instance types in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZone"`: The Availability Zone in which to create the Capacity Reservation.
- `"AvailabilityZoneId"`: The ID of the Availability Zone in which to create the Capacity
  Reservation.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensure Idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EbsOptimized"`: Indicates whether the Capacity Reservation supports EBS-optimized
  instances. This optimization provides dedicated throughput to Amazon EBS and an optimized
  configuration stack to provide optimal I/O performance. This optimization isn't available
  with all instance types. Additional usage charges apply when using an EBS- optimized
  instance.
- `"EndDate"`: The date and time at which the Capacity Reservation expires. When a Capacity
  Reservation expires, the reserved capacity is released and you can no longer launch
  instances into it. The Capacity Reservation's state changes to expired when it reaches its
  end date and time. You must provide an EndDate value if EndDateType is limited. Omit
  EndDate if EndDateType is unlimited. If the EndDateType is limited, the Capacity
  Reservation is cancelled within an hour from the specified time. For example, if you
  specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55
  and 14:30:55 on 5/31/2019.
- `"EndDateType"`: Indicates the way in which the Capacity Reservation ends. A Capacity
  Reservation can have one of the following end types:    unlimited - The Capacity
  Reservation remains active until you explicitly cancel it. Do not provide an EndDate if the
  EndDateType is unlimited.    limited - The Capacity Reservation expires automatically at a
  specified date and time. You must provide an EndDate value if the EndDateType value is
  limited.
- `"EphemeralStorage"`:  Deprecated.
- `"InstanceMatchCriteria"`: Indicates the type of instance launches that the Capacity
  Reservation accepts. The options include:    open - The Capacity Reservation automatically
  matches all instances that have matching attributes (instance type, platform, and
  Availability Zone). Instances that have matching attributes run in the Capacity Reservation
  automatically without specifying any additional parameters.    targeted - The Capacity
  Reservation only accepts instances that have matching attributes (instance type, platform,
  and Availability Zone), and explicitly target the Capacity Reservation. This ensures that
  only permitted instances can use the reserved capacity.    Default: open
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost on which to create the
  Capacity Reservation.
- `"PlacementGroupArn"`: The Amazon Resource Name (ARN) of the cluster placement group in
  which to create the Capacity Reservation. For more information, see  Capacity Reservations
  for cluster placement groups in the Amazon EC2 User Guide.
- `"TagSpecifications"`: The tags to apply to the Capacity Reservation during launch.
- `"Tenancy"`: Indicates the tenancy of the Capacity Reservation. A Capacity Reservation
  can have one of the following tenancy settings:    default - The Capacity Reservation is
  created on hardware that is shared with other Amazon Web Services accounts.    dedicated -
  The Capacity Reservation is created on single-tenant hardware that is dedicated to a single
  Amazon Web Services account.
"""
function create_capacity_reservation(
    InstanceCount,
    InstancePlatform,
    InstanceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCapacityReservation",
        Dict{String,Any}(
            "InstanceCount" => InstanceCount,
            "InstancePlatform" => InstancePlatform,
            "InstanceType" => InstanceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_capacity_reservation(
    InstanceCount,
    InstancePlatform,
    InstanceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCapacityReservation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceCount" => InstanceCount,
                    "InstancePlatform" => InstancePlatform,
                    "InstanceType" => InstanceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_capacity_reservation_fleet(instance_type_specification, total_target_capacity)
    create_capacity_reservation_fleet(instance_type_specification, total_target_capacity, params::Dict{String,<:Any})

Creates a Capacity Reservation Fleet. For more information, see Create a Capacity
Reservation Fleet in the Amazon EC2 User Guide.

# Arguments
- `instance_type_specification`: Information about the instance types for which to reserve
  the capacity.
- `total_target_capacity`: The total number of capacity units to be reserved by the
  Capacity Reservation Fleet. This value, together with the instance type weights that you
  assign to each instance type used by the Fleet determine the number of instances for which
  the Fleet reserves capacity. Both values are based on units that make sense for your
  workload. For more information, see Total target capacity in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationStrategy"`: The strategy used by the Capacity Reservation Fleet to determine
  which of the specified instance types to use. Currently, only the prioritized allocation
  strategy is supported. For more information, see  Allocation strategy in the Amazon EC2
  User Guide. Valid values: prioritized
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensure Idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EndDate"`: The date and time at which the Capacity Reservation Fleet expires. When the
  Capacity Reservation Fleet expires, its state changes to expired and all of the Capacity
  Reservations in the Fleet expire. The Capacity Reservation Fleet expires within an hour
  after the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity
  Reservation Fleet is guaranteed to expire between 13:30:55 and 14:30:55 on 5/31/2019.
- `"InstanceMatchCriteria"`: Indicates the type of instance launches that the Capacity
  Reservation Fleet accepts. All Capacity Reservations in the Fleet inherit this instance
  matching criteria. Currently, Capacity Reservation Fleets support open instance matching
  criteria only. This means that instances that have matching attributes (instance type,
  platform, and Availability Zone) run in the Capacity Reservations automatically. Instances
  do not need to explicitly target a Capacity Reservation Fleet to use its reserved capacity.
- `"TagSpecification"`: The tags to assign to the Capacity Reservation Fleet. The tags are
  automatically assigned to the Capacity Reservations in the Fleet.
- `"Tenancy"`: Indicates the tenancy of the Capacity Reservation Fleet. All Capacity
  Reservations in the Fleet inherit this tenancy. The Capacity Reservation Fleet can have one
  of the following tenancy settings:    default - The Capacity Reservation Fleet is created
  on hardware that is shared with other Amazon Web Services accounts.    dedicated - The
  Capacity Reservations are created on single-tenant hardware that is dedicated to a single
  Amazon Web Services account.
"""
function create_capacity_reservation_fleet(
    InstanceTypeSpecification,
    TotalTargetCapacity;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCapacityReservationFleet",
        Dict{String,Any}(
            "InstanceTypeSpecification" => InstanceTypeSpecification,
            "TotalTargetCapacity" => TotalTargetCapacity,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_capacity_reservation_fleet(
    InstanceTypeSpecification,
    TotalTargetCapacity,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCapacityReservationFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceTypeSpecification" => InstanceTypeSpecification,
                    "TotalTargetCapacity" => TotalTargetCapacity,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_carrier_gateway(vpc_id)
    create_carrier_gateway(vpc_id, params::Dict{String,<:Any})

Creates a carrier gateway. For more information about carrier gateways, see Carrier
gateways in the Amazon Web Services Wavelength Developer Guide.

# Arguments
- `vpc_id`: The ID of the VPC to associate with the carrier gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to associate with the carrier gateway.
"""
function create_carrier_gateway(VpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateCarrierGateway",
        Dict{String,Any}("VpcId" => VpcId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_carrier_gateway(
    VpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateCarrierGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VpcId" => VpcId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_client_vpn_endpoint(authentication, client_cidr_block, connection_log_options, server_certificate_arn)
    create_client_vpn_endpoint(authentication, client_cidr_block, connection_log_options, server_certificate_arn, params::Dict{String,<:Any})

Creates a Client VPN endpoint. A Client VPN endpoint is the resource you create and
configure to enable and manage client VPN sessions. It is the destination endpoint at which
all client VPN sessions are terminated.

# Arguments
- `authentication`: Information about the authentication method to be used to authenticate
  clients.
- `client_cidr_block`: The IPv4 address range, in CIDR notation, from which to assign
  client IP addresses. The address range cannot overlap with the local CIDR of the VPC in
  which the associated subnet is located, or the routes that you add manually. The address
  range cannot be changed after the Client VPN endpoint has been created. Client CIDR range
  must have a size of at least /22 and must not be greater than /12.
- `connection_log_options`: Information about the client connection logging options. If you
  enable client connection logging, data about client connections is sent to a Cloudwatch
  Logs log stream. The following information is logged:   Client connection requests   Client
  connection results (successful and unsuccessful)   Reasons for unsuccessful client
  connection requests   Client connection termination time
- `server_certificate_arn`: The ARN of the server certificate. For more information, see
  the Certificate Manager User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientConnectOptions"`: The options for managing connection authorization for new
  client connections.
- `"ClientLoginBannerOptions"`: Options for enabling a customizable text banner that will
  be displayed on Amazon Web Services provided clients when a VPN session is established.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A brief description of the Client VPN endpoint.
- `"DnsServers"`: Information about the DNS servers to be used for DNS resolution. A Client
  VPN endpoint can have up to two DNS servers. If no DNS server is specified, the DNS address
  configured on the device is used for the DNS server.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"SecurityGroupId"`: The IDs of one or more security groups to apply to the target
  network. You must also specify the ID of the VPC that contains the security groups.
- `"SelfServicePortal"`: Specify whether to enable the self-service portal for the Client
  VPN endpoint. Default Value: enabled
- `"SessionTimeoutHours"`: The maximum VPN session duration time in hours. Valid values: 8
  | 10 | 12 | 24  Default value: 24
- `"SplitTunnel"`: Indicates whether split-tunnel is enabled on the Client VPN endpoint. By
  default, split-tunnel on a VPN endpoint is disabled. For information about split-tunnel VPN
  endpoints, see Split-tunnel Client VPN endpoint in the Client VPN Administrator Guide.
- `"TagSpecification"`: The tags to apply to the Client VPN endpoint during creation.
- `"TransportProtocol"`: The transport protocol to be used by the VPN session. Default
  value: udp
- `"VpcId"`: The ID of the VPC to associate with the Client VPN endpoint. If no security
  group IDs are specified in the request, the default security group for the VPC is applied.
- `"VpnPort"`: The port number to assign to the Client VPN endpoint for TCP and UDP
  traffic. Valid Values: 443 | 1194  Default Value: 443
"""
function create_client_vpn_endpoint(
    Authentication,
    ClientCidrBlock,
    ConnectionLogOptions,
    ServerCertificateArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateClientVpnEndpoint",
        Dict{String,Any}(
            "Authentication" => Authentication,
            "ClientCidrBlock" => ClientCidrBlock,
            "ConnectionLogOptions" => ConnectionLogOptions,
            "ServerCertificateArn" => ServerCertificateArn,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_client_vpn_endpoint(
    Authentication,
    ClientCidrBlock,
    ConnectionLogOptions,
    ServerCertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateClientVpnEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Authentication" => Authentication,
                    "ClientCidrBlock" => ClientCidrBlock,
                    "ConnectionLogOptions" => ConnectionLogOptions,
                    "ServerCertificateArn" => ServerCertificateArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_client_vpn_route(client_vpn_endpoint_id, destination_cidr_block, target_vpc_subnet_id)
    create_client_vpn_route(client_vpn_endpoint_id, destination_cidr_block, target_vpc_subnet_id, params::Dict{String,<:Any})

Adds a route to a network to a Client VPN endpoint. Each Client VPN endpoint has a route
table that describes the available destination network routes. Each route in the route
table specifies the path for traﬃc to speciﬁc resources or networks.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint to which to add the route.
- `destination_cidr_block`: The IPv4 address range, in CIDR notation, of the route
  destination. For example:   To add a route for Internet access, enter 0.0.0.0/0    To add a
  route for a peered VPC, enter the peered VPC's IPv4 CIDR range   To add a route for an
  on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR
  range   To add a route for the local network, enter the client CIDR range
- `target_vpc_subnet_id`: The ID of the subnet through which you want to route traffic. The
  specified subnet must be an existing target network of the Client VPN endpoint.
  Alternatively, if you're adding a route for the local network, specify local.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A brief description of the route.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_client_vpn_route(
    ClientVpnEndpointId,
    DestinationCidrBlock,
    TargetVpcSubnetId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateClientVpnRoute",
        Dict{String,Any}(
            "ClientVpnEndpointId" => ClientVpnEndpointId,
            "DestinationCidrBlock" => DestinationCidrBlock,
            "TargetVpcSubnetId" => TargetVpcSubnetId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_client_vpn_route(
    ClientVpnEndpointId,
    DestinationCidrBlock,
    TargetVpcSubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateClientVpnRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "TargetVpcSubnetId" => TargetVpcSubnetId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_coip_cidr(cidr, coip_pool_id)
    create_coip_cidr(cidr, coip_pool_id, params::Dict{String,<:Any})

 Creates a range of customer-owned IP addresses.

# Arguments
- `cidr`:  A customer-owned IP address range to create.
- `coip_pool_id`:  The ID of the address pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_coip_cidr(
    Cidr, CoipPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateCoipCidr",
        Dict{String,Any}("Cidr" => Cidr, "CoipPoolId" => CoipPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_coip_cidr(
    Cidr,
    CoipPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCoipCidr",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Cidr" => Cidr, "CoipPoolId" => CoipPoolId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_coip_pool(local_gateway_route_table_id)
    create_coip_pool(local_gateway_route_table_id, params::Dict{String,<:Any})

 Creates a pool of customer-owned IP (CoIP) addresses.

# Arguments
- `local_gateway_route_table_id`:  The ID of the local gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`:  The tags to assign to the CoIP address pool.
"""
function create_coip_pool(
    LocalGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateCoipPool",
        Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_coip_pool(
    LocalGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateCoipPool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_customer_gateway(type)
    create_customer_gateway(type, params::Dict{String,<:Any})

Provides information to Amazon Web Services about your customer gateway device. The
customer gateway device is the appliance at your end of the VPN connection. You must
provide the IP address of the customer gateway device’s external interface. The IP
address must be static and can be behind a device performing network address translation
(NAT). For devices that use Border Gateway Protocol (BGP), you can also provide the
device's BGP Autonomous System Number (ASN). You can use an existing ASN assigned to your
network. If you don't have an ASN already, you can use a private ASN. For more information,
see Customer gateway options for your Site-to-Site VPN connection in the Amazon Web
Services Site-to-Site VPN User Guide. To create more than one customer gateway with the
same VPN type, IP address, and BGP ASN, specify a unique device name for each customer
gateway. An identical request returns information about the existing customer gateway; it
doesn't create a new customer gateway.

# Arguments
- `type`: The type of VPN connection that this customer gateway supports (ipsec.1).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BgpAsn"`: For customer gateway devices that support BGP, specify the device's ASN. You
  must specify either BgpAsn or BgpAsnExtended when creating the customer gateway. If the ASN
  is larger than 2,147,483,647, you must use BgpAsnExtended. Default: 65000 Valid values: 1
  to 2,147,483,647
- `"BgpAsnExtended"`: For customer gateway devices that support BGP, specify the device's
  ASN. You must specify either BgpAsn or BgpAsnExtended when creating the customer gateway.
  If the ASN is larger than 2,147,483,647, you must use BgpAsnExtended. Valid values:
  2,147,483,648 to 4,294,967,295
- `"CertificateArn"`: The Amazon Resource Name (ARN) for the customer gateway certificate.
- `"DeviceName"`: A name for the customer gateway device. Length Constraints: Up to 255
  characters.
- `"IpAddress"`: IPv4 address for the customer gateway device's outside interface. The
  address must be static. If OutsideIpAddressType in your VPN connection options is set to
  PrivateIpv4, you can use an RFC6598 or RFC1918 private IPv4 address. If
  OutsideIpAddressType is set to PublicIpv4, you can use a public IPv4 address.
- `"PublicIp"`:  This member has been deprecated. The Internet-routable IP address for the
  customer gateway's outside interface. The address must be static.
- `"TagSpecification"`: The tags to apply to the customer gateway.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_customer_gateway(Type; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateCustomerGateway",
        Dict{String,Any}("Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_customer_gateway(
    Type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateCustomerGateway",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Type" => Type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_default_subnet(availability_zone)
    create_default_subnet(availability_zone, params::Dict{String,<:Any})

Creates a default subnet with a size /20 IPv4 CIDR block in the specified Availability Zone
in your default VPC. You can have only one default subnet per Availability Zone. For more
information, see Create a default subnet in the Amazon VPC User Guide.

# Arguments
- `availability_zone`: The Availability Zone in which to create the default subnet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Ipv6Native"`: Indicates whether to create an IPv6 only subnet. If you already have a
  default subnet for this Availability Zone, you must delete it before you can create an IPv6
  only subnet.
"""
function create_default_subnet(
    AvailabilityZone; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateDefaultSubnet",
        Dict{String,Any}("AvailabilityZone" => AvailabilityZone);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_default_subnet(
    AvailabilityZone,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateDefaultSubnet",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AvailabilityZone" => AvailabilityZone), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_default_vpc()
    create_default_vpc(params::Dict{String,<:Any})

Creates a default VPC with a size /16 IPv4 CIDR block and a default subnet in each
Availability Zone. For more information about the components of a default VPC, see Default
VPCs in the Amazon VPC User Guide. You cannot specify the components of the default VPC
yourself. If you deleted your previous default VPC, you can create a default VPC. You
cannot have more than one default VPC per Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_default_vpc(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("CreateDefaultVpc"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function create_default_vpc(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateDefaultVpc", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    create_dhcp_options(dhcp_configuration)
    create_dhcp_options(dhcp_configuration, params::Dict{String,<:Any})

Creates a custom set of DHCP options. After you create a DHCP option set, you associate it
with a VPC. After you associate a DHCP option set with a VPC, all existing and newly
launched instances in the VPC use this set of DHCP options. The following are the
individual DHCP options you can specify. For more information, see DHCP option sets in the
Amazon VPC User Guide.    domain-name - If you're using AmazonProvidedDNS in us-east-1,
specify ec2.internal. If you're using AmazonProvidedDNS in any other Region, specify
region.compute.internal. Otherwise, specify a custom domain name. This value is used to
complete unqualified DNS hostnames. Some Linux operating systems accept multiple domain
names separated by spaces. However, Windows and other Linux operating systems treat the
value as a single domain, which results in unexpected behavior. If your DHCP option set is
associated with a VPC that has instances running operating systems that treat the value as
a single domain, specify only one domain name.    domain-name-servers - The IP addresses of
up to four DNS servers, or AmazonProvidedDNS. To specify multiple domain name servers in a
single parameter, separate the IP addresses using commas. To have your instances receive
custom DNS hostnames as specified in domain-name, you must specify a custom DNS server.
ntp-servers - The IP addresses of up to eight Network Time Protocol (NTP) servers (four
IPv4 addresses and four IPv6 addresses).    netbios-name-servers - The IP addresses of up
to four NetBIOS name servers.    netbios-node-type - The NetBIOS node type (1, 2, 4, or 8).
We recommend that you specify 2. Broadcast and multicast are not supported. For more
information about NetBIOS node types, see RFC 2132.    ipv6-address-preferred-lease-time -
A value (in seconds, minutes, hours, or years) for how frequently a running instance with
an IPv6 assigned to it goes through DHCPv6 lease renewal. Acceptable values are between 140
and 2147483647 seconds (approximately 68 years). If no value is entered, the default lease
time is 140 seconds. If you use long-term addressing for EC2 instances, you can increase
the lease time and avoid frequent lease renewal requests. Lease renewal typically occurs
when half of the lease time has elapsed.

# Arguments
- `dhcp_configuration`: A DHCP configuration option.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to assign to the DHCP option.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_dhcp_options(
    dhcpConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateDhcpOptions",
        Dict{String,Any}("dhcpConfiguration" => dhcpConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dhcp_options(
    dhcpConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateDhcpOptions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("dhcpConfiguration" => dhcpConfiguration), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_egress_only_internet_gateway(vpc_id)
    create_egress_only_internet_gateway(vpc_id, params::Dict{String,<:Any})

[IPv6 only] Creates an egress-only internet gateway for your VPC. An egress-only internet
gateway is used to enable outbound communication over IPv6 from instances in your VPC to
the internet, and prevents hosts outside of your VPC from initiating an IPv6 connection
with your instance.

# Arguments
- `vpc_id`: The ID of the VPC for which to create the egress-only internet gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to assign to the egress-only internet gateway.
"""
function create_egress_only_internet_gateway(
    VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateEgressOnlyInternetGateway",
        Dict{String,Any}("VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_egress_only_internet_gateway(
    VpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateEgressOnlyInternetGateway",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("VpcId" => VpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fleet(target_capacity_specification, item)
    create_fleet(target_capacity_specification, item, params::Dict{String,<:Any})

Creates an EC2 Fleet that contains the configuration information for On-Demand Instances
and Spot Instances. Instances are launched immediately if there is available capacity. A
single EC2 Fleet can include multiple launch specifications that vary by instance type,
AMI, Availability Zone, or subnet. For more information, see EC2 Fleet in the Amazon EC2
User Guide.

# Arguments
- `target_capacity_specification`: The number of units to request.
- `item`: The configuration for the EC2 Fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Context"`: Reserved.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ExcessCapacityTerminationPolicy"`: Indicates whether running instances should be
  terminated if the total target capacity of the EC2 Fleet is decreased below the current
  size of the EC2 Fleet. Supported only for fleets of type maintain.
- `"LaunchTemplateConfigs"`: The configuration for the EC2 Fleet.
- `"OnDemandOptions"`: Describes the configuration of On-Demand Instances in an EC2 Fleet.
- `"ReplaceUnhealthyInstances"`: Indicates whether EC2 Fleet should replace unhealthy Spot
  Instances. Supported only for fleets of type maintain. For more information, see EC2 Fleet
  health checks in the Amazon EC2 User Guide.
- `"SpotOptions"`: Describes the configuration of Spot Instances in an EC2 Fleet.
- `"TagSpecification"`: The key-value pair for tagging the EC2 Fleet request on creation.
  For more information, see Tag your resources. If the fleet type is instant, specify a
  resource type of fleet to tag the fleet or instance to tag the instances at launch. If the
  fleet type is maintain or request, specify a resource type of fleet to tag the fleet. You
  cannot specify a resource type of instance. To tag instances at launch, specify the tags in
  a launch template.
- `"TerminateInstancesWithExpiration"`: Indicates whether running instances should be
  terminated when the EC2 Fleet expires.
- `"Type"`: The fleet type. The default value is maintain.    maintain - The EC2 Fleet
  places an asynchronous request for your desired capacity, and continues to maintain your
  desired Spot capacity by replenishing interrupted Spot Instances.    request - The EC2
  Fleet places an asynchronous one-time request for your desired capacity, but does submit
  Spot requests in alternative capacity pools if Spot capacity is unavailable, and does not
  maintain Spot capacity if Spot Instances are interrupted.    instant - The EC2 Fleet places
  a synchronous one-time request for your desired capacity, and returns errors for any
  instances that could not be launched.   For more information, see EC2 Fleet request types
  in the Amazon EC2 User Guide.
- `"ValidFrom"`: The start date and time of the request, in UTC format (for example,
  YYYY-MM-DDTHH:MM:SSZ). The default is to start fulfilling the request immediately.
- `"ValidUntil"`: The end date and time of the request, in UTC format (for example,
  YYYY-MM-DDTHH:MM:SSZ). At this point, no new EC2 Fleet requests are placed or able to
  fulfill the request. If no value is specified, the request remains until you cancel it.
"""
function create_fleet(
    TargetCapacitySpecification, item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateFleet",
        Dict{String,Any}(
            "TargetCapacitySpecification" => TargetCapacitySpecification, "item" => item
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fleet(
    TargetCapacitySpecification,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateFleet",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TargetCapacitySpecification" => TargetCapacitySpecification,
                    "item" => item,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_flow_logs(resource_id, resource_type)
    create_flow_logs(resource_id, resource_type, params::Dict{String,<:Any})

Creates one or more flow logs to capture information about IP traffic for a specific
network interface, subnet, or VPC.  Flow log data for a monitored network interface is
recorded as flow log records, which are log events consisting of fields that describe the
traffic flow. For more information, see Flow log records in the Amazon VPC User Guide. When
publishing to CloudWatch Logs, flow log records are published to a log group, and each
network interface has a unique log stream in the log group. When publishing to Amazon S3,
flow log records for all of the monitored network interfaces are published to a single log
file object that is stored in the specified bucket. For more information, see VPC Flow Logs
in the Amazon VPC User Guide.

# Arguments
- `resource_id`: The IDs of the resources to monitor. For example, if the resource type is
  VPC, specify the IDs of the VPCs. Constraints: Maximum of 25 for transit gateway resource
  types. Maximum of 1000 for the other resource types.
- `resource_type`: The type of resource to monitor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"DeliverCrossAccountRole"`: The ARN of the IAM role that allows Amazon EC2 to publish
  flow logs across accounts.
- `"DeliverLogsPermissionArn"`: The ARN of the IAM role that allows Amazon EC2 to publish
  flow logs to the log destination. This parameter is required if the destination type is
  cloud-watch-logs, or if the destination type is kinesis-data-firehose and the delivery
  stream and the resources to monitor are in different accounts.
- `"DestinationOptions"`: The destination options.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LogDestination"`: The destination for the flow log data. The meaning of this parameter
  depends on the destination type.   If the destination type is cloud-watch-logs, specify the
  ARN of a CloudWatch Logs log group. For example:
  arn:aws:logs:region:account_id:log-group:my_group  Alternatively, use the LogGroupName
  parameter.   If the destination type is s3, specify the ARN of an S3 bucket. For example:
  arn:aws:s3:::my_bucket/my_subfolder/ The subfolder is optional. Note that you can't use
  AWSLogs as a subfolder name.   If the destination type is kinesis-data-firehose, specify
  the ARN of a Kinesis Data Firehose delivery stream. For example:
  arn:aws:firehose:region:account_id:deliverystream:my_stream
- `"LogDestinationType"`: The type of destination for the flow log data. Default:
  cloud-watch-logs
- `"LogFormat"`: The fields to include in the flow log record. List the fields in the order
  in which they should appear. If you omit this parameter, the flow log is created using the
  default format. If you specify this parameter, you must include at least one field. For
  more information about the available fields, see Flow log records in the Amazon VPC User
  Guide or Transit Gateway Flow Log records in the Amazon Web Services Transit Gateway Guide.
  Specify the fields using the {field-id} format, separated by spaces.
- `"LogGroupName"`: The name of a new or existing CloudWatch Logs log group where Amazon
  EC2 publishes your flow logs. This parameter is valid only if the destination type is
  cloud-watch-logs.
- `"MaxAggregationInterval"`: The maximum interval of time during which a flow of packets
  is captured and aggregated into a flow log record. The possible values are 60 seconds (1
  minute) or 600 seconds (10 minutes). This parameter must be 60 seconds for transit gateway
  resource types. When a network interface is attached to a Nitro-based instance, the
  aggregation interval is always 60 seconds or less, regardless of the value that you
  specify. Default: 600
- `"TagSpecification"`: The tags to apply to the flow logs.
- `"TrafficType"`: The type of traffic to monitor (accepted traffic, rejected traffic, or
  all traffic). This parameter is not supported for transit gateway resource types. It is
  required for the other resource types.
"""
function create_flow_logs(
    ResourceId, ResourceType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateFlowLogs",
        Dict{String,Any}("ResourceId" => ResourceId, "ResourceType" => ResourceType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_flow_logs(
    ResourceId,
    ResourceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateFlowLogs",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceId" => ResourceId, "ResourceType" => ResourceType
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_fpga_image(input_storage_location)
    create_fpga_image(input_storage_location, params::Dict{String,<:Any})

Creates an Amazon FPGA Image (AFI) from the specified design checkpoint (DCP). The create
operation is asynchronous. To verify that the AFI is ready for use, check the output logs.
An AFI contains the FPGA bitstream that is ready to download to an FPGA. You can securely
deploy an AFI on multiple FPGA-accelerated instances. For more information, see the Amazon
Web Services FPGA Hardware Development Kit.

# Arguments
- `input_storage_location`: The location of the encrypted design checkpoint in Amazon S3.
  The input must be a tarball.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring Idempotency.
- `"Description"`: A description for the AFI.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LogsStorageLocation"`: The location in Amazon S3 for the output logs.
- `"Name"`: A name for the AFI.
- `"TagSpecification"`: The tags to apply to the FPGA image during creation.
"""
function create_fpga_image(
    InputStorageLocation; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateFpgaImage",
        Dict{String,Any}("InputStorageLocation" => InputStorageLocation);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_fpga_image(
    InputStorageLocation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateFpgaImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InputStorageLocation" => InputStorageLocation),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_image(instance_id, name)
    create_image(instance_id, name, params::Dict{String,<:Any})

Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that is either running
or stopped. If you customized your instance with instance store volumes or Amazon EBS
volumes in addition to the root device volume, the new AMI contains block device mapping
information for those volumes. When you launch an instance from this new AMI, the instance
automatically launches with those additional volumes. For more information, see Create an
Amazon EBS-backed Linux AMI in the Amazon Elastic Compute Cloud User Guide.

# Arguments
- `instance_id`: The ID of the instance.
- `name`: A name for the new image. Constraints: 3-128 alphanumeric characters, parentheses
  (()), square brackets ([]), spaces ( ), periods (.), slashes (/), dashes (-), single quotes
  ('), at-signs (@), or underscores(_)

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to apply to the AMI and snapshots on creation. You can tag
  the AMI, the snapshots, or both.   To tag the AMI, the value for ResourceType must be
  image.   To tag the snapshots that are created of the root volume and of other Amazon EBS
  volumes that are attached to the instance, the value for ResourceType must be snapshot. The
  same tag is applied to all of the snapshots that are created.   If you specify other values
  for ResourceType, the request fails. To tag an AMI or snapshot after it has been created,
  see CreateTags.
- `"blockDeviceMapping"`: The block device mappings. When using the CreateImage action:
  You can't change the volume size using the VolumeSize parameter. If you want a different
  volume size, you must first change the volume size of the source instance.   You can't
  modify the encryption status of existing volumes or snapshots. To create an AMI with
  volumes or snapshots that have a different encryption status (for example, where the source
  volume and snapshots are unencrypted, and you want to create an AMI with encrypted volumes
  or snapshots), use the CopyImage action.   The only option that can be changed for existing
  mappings or snapshots is DeleteOnTermination.
- `"description"`: A description for the new image.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"noReboot"`: Indicates whether or not the instance should be automatically rebooted
  before creating the image. Specify one of the following values:    true - The instance is
  not rebooted before creating the image. This creates crash-consistent snapshots that
  include only the data that has been written to the volumes at the time the snapshots are
  created. Buffered data and data in memory that has not yet been written to the volumes is
  not included in the snapshots.    false - The instance is rebooted before creating the
  image. This ensures that all buffered data and data in memory is written to the volumes
  before the snapshots are created.   Default: false
"""
function create_image(instanceId, name; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateImage",
        Dict{String,Any}("instanceId" => instanceId, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_image(
    instanceId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateImage",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("instanceId" => instanceId, "name" => name), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_connect_endpoint(subnet_id)
    create_instance_connect_endpoint(subnet_id, params::Dict{String,<:Any})

Creates an EC2 Instance Connect Endpoint. An EC2 Instance Connect Endpoint allows you to
connect to an instance, without requiring the instance to have a public IPv4 address. For
more information, see Connect to your instances without requiring a public IPv4 address
using EC2 Instance Connect Endpoint in the Amazon EC2 User Guide.

# Arguments
- `subnet_id`: The ID of the subnet in which to create the EC2 Instance Connect Endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PreserveClientIp"`: Indicates whether your client's IP address is preserved as the
  source. The value is true or false.   If true, your client's IP address is used when you
  connect to a resource.   If false, the elastic network interface IP address is used when
  you connect to a resource.   Default: true
- `"SecurityGroupId"`: One or more security groups to associate with the endpoint. If you
  don't specify a security group, the default security group for your VPC will be associated
  with the endpoint.
- `"TagSpecification"`: The tags to apply to the EC2 Instance Connect Endpoint during
  creation.
"""
function create_instance_connect_endpoint(
    SubnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateInstanceConnectEndpoint",
        Dict{String,Any}("SubnetId" => SubnetId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance_connect_endpoint(
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateInstanceConnectEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SubnetId" => SubnetId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_event_window()
    create_instance_event_window(params::Dict{String,<:Any})

Creates an event window in which scheduled events for the associated Amazon EC2 instances
can run. You can define either a set of time ranges or a cron expression when creating the
event window, but not both. All event window times are in UTC. You can create up to 200
event windows per Amazon Web Services Region. When you create the event window, targets
(instance IDs, Dedicated Host IDs, or tags) are not yet associated with it. To ensure that
the event window can be used, you must associate one or more targets with it by using the
AssociateInstanceEventWindow API.  Event windows are applicable only for scheduled events
that stop, reboot, or terminate instances. Event windows are not applicable for:
Expedited scheduled events and network maintenance events.    Unscheduled maintenance such
as AutoRecovery and unplanned reboots.    For more information, see Define event windows
for scheduled events in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CronExpression"`: The cron expression for the event window, for example, * 0-4,20-23 *
  * 1,5. If you specify a cron expression, you can't specify a time range. Constraints:
  Only hour and day of the week values are supported.   For day of the week values, you can
  specify either integers 0 through 6, or alternative single values SUN through SAT.   The
  minute, month, and year must be specified by *.   The hour value must be one or a multiple
  range, for example, 0-4 or 0-4,20-23.   Each hour range must be &gt;= 2 hours, for example,
  0-2 or 20-23.   The event window must be &gt;= 4 hours. The combined total time ranges in
  the event window must be &gt;= 4 hours.   For more information about cron expressions, see
  cron on the Wikipedia website.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Name"`: The name of the event window.
- `"TagSpecification"`: The tags to apply to the event window.
- `"TimeRange"`: The time range for the event window. If you specify a time range, you
  can't specify a cron expression.
"""
function create_instance_event_window(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateInstanceEventWindow"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_instance_event_window(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateInstanceEventWindow",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_instance_export_task(export_to_s3, instance_id, target_environment)
    create_instance_export_task(export_to_s3, instance_id, target_environment, params::Dict{String,<:Any})

Exports a running or stopped instance to an Amazon S3 bucket. For information about the
prerequisites for your Amazon S3 bucket, supported operating systems, image formats, and
known limitations for the types of instances you can export, see Exporting an instance as a
VM Using VM Import/Export in the VM Import/Export User Guide.

# Arguments
- `export_to_s3`: The format and location for an export instance task.
- `instance_id`: The ID of the instance.
- `target_environment`: The target virtualization environment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to apply to the export instance task during creation.
- `"description"`: A description for the conversion task or the resource being exported.
  The maximum length is 255 characters.
"""
function create_instance_export_task(
    exportToS3,
    instanceId,
    targetEnvironment;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateInstanceExportTask",
        Dict{String,Any}(
            "exportToS3" => exportToS3,
            "instanceId" => instanceId,
            "targetEnvironment" => targetEnvironment,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_instance_export_task(
    exportToS3,
    instanceId,
    targetEnvironment,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateInstanceExportTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "exportToS3" => exportToS3,
                    "instanceId" => instanceId,
                    "targetEnvironment" => targetEnvironment,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_internet_gateway()
    create_internet_gateway(params::Dict{String,<:Any})

Creates an internet gateway for use with a VPC. After creating the internet gateway, you
attach it to a VPC using AttachInternetGateway. For more information, see Internet gateways
in the Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to assign to the internet gateway.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_internet_gateway(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateInternetGateway"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_internet_gateway(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateInternetGateway",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipam()
    create_ipam(params::Dict{String,<:Any})

Create an IPAM. Amazon VPC IP Address Manager (IPAM) is a VPC feature that you can use to
automate your IP address management workflows including assigning, tracking,
troubleshooting, and auditing IP addresses across Amazon Web Services Regions and accounts
throughout your Amazon Web Services Organization. For more information, see Create an IPAM
in the Amazon VPC IPAM User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the IPAM.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"OperatingRegion"`: The operating Regions for the IPAM. Operating Regions are Amazon Web
  Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM only discovers
  and monitors resources in the Amazon Web Services Regions you select as operating Regions.
  For more information about operating Regions, see Create an IPAM in the Amazon VPC IPAM
  User Guide.
- `"TagSpecification"`: The key/value combination of a tag assigned to the resource. Use
  the tag key in the filter name and the tag value as the filter value. For example, to find
  all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for
  the filter name and TeamA for the filter value.
- `"Tier"`: IPAM is offered in a Free Tier and an Advanced Tier. For more information about
  the features available in each tier and the costs associated with the tiers, see Amazon VPC
  pricing &gt; IPAM tab.
"""
function create_ipam(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateIpam",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipam(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateIpam",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipam_pool(address_family, ipam_scope_id)
    create_ipam_pool(address_family, ipam_scope_id, params::Dict{String,<:Any})

Create an IP address pool for Amazon VPC IP Address Manager (IPAM). In IPAM, a pool is a
collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses
according to your routing and security needs. For example, if you have separate routing and
security needs for development and production applications, you can create a pool for each.
For more information, see Create a top-level pool in the Amazon VPC IPAM User Guide.

# Arguments
- `address_family`: The IP protocol assigned to this IPAM pool. You must choose either IPv4
  or IPv6 protocol for a pool.
- `ipam_scope_id`: The ID of the scope in which you would like to create the IPAM pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationDefaultNetmaskLength"`: The default netmask length for allocations added to
  this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16
  here, new allocations will default to 10.0.0.0/16.
- `"AllocationMaxNetmaskLength"`: The maximum netmask length possible for CIDR allocations
  in this IPAM pool to be compliant. The maximum netmask length must be greater than the
  minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible
  netmask lengths for IPv6 addresses are 0 - 128.
- `"AllocationMinNetmaskLength"`: The minimum netmask length required for CIDR allocations
  in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum
  netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask
  lengths for IPv6 addresses are 0 - 128.
- `"AllocationResourceTag"`: Tags that are required for resources that use CIDRs from this
  IPAM pool. Resources that do not have these tags will not be allowed to allocate space from
  the pool. If the resources have their tags changed after they have allocated space or if
  the allocation tagging requirements are changed on the pool, the resource may be marked as
  noncompliant.
- `"AutoImport"`: If selected, IPAM will continuously look for resources within the CIDR
  range of this pool and automatically import them as allocations into your IPAM. The CIDRs
  that will be allocated for these resources must not already be allocated to other resources
  in order for the import to succeed. IPAM will import a CIDR regardless of its compliance
  with the pool's allocation rules, so a resource might be imported and subsequently marked
  as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the
  largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly
  import one of them only.  A locale must be set on the pool for this feature to work.
- `"AwsService"`: Limits which service in Amazon Web Services that the pool can be used in.
  \"ec2\", for example, allows users to use space for Elastic IP addresses and VPCs.
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the IPAM pool.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Locale"`: In IPAM, the locale is the Amazon Web Services Region where you want to make
  an IPAM pool available for allocations. Only resources in the same Region as the locale of
  the pool can get IP address allocations from the pool. You can only allocate a CIDR for a
  VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that
  once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale,
  resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.
  Possible values: Any Amazon Web Services Region, such as us-east-1.
- `"PublicIpSource"`: The IP address source for pools in the public scope. Only used for
  provisioning IP address CIDRs to pools in the public scope. Default is byoip. For more
  information, see Create IPv6 pools in the Amazon VPC IPAM User Guide. By default, you can
  add only one Amazon-provided IPv6 CIDR block to a top-level IPv6 pool if PublicIpSource is
  amazon. For information on increasing the default limit, see  Quotas for your IPAM in the
  Amazon VPC IPAM User Guide.
- `"PubliclyAdvertisable"`: Determines if the pool is publicly advertisable. This option is
  not available for pools with AddressFamily set to ipv4.
- `"SourceIpamPoolId"`: The ID of the source IPAM pool. Use this option to create a pool
  within an existing pool. Note that the CIDR you provision for the pool within the source
  pool must be available in the source pool's CIDR range.
- `"SourceResource"`: The resource used to provision CIDRs to a resource planning pool.
- `"TagSpecification"`: The key/value combination of a tag assigned to the resource. Use
  the tag key in the filter name and the tag value as the filter value. For example, to find
  all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for
  the filter name and TeamA for the filter value.
"""
function create_ipam_pool(
    AddressFamily, IpamScopeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateIpamPool",
        Dict{String,Any}(
            "AddressFamily" => AddressFamily,
            "IpamScopeId" => IpamScopeId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipam_pool(
    AddressFamily,
    IpamScopeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateIpamPool",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AddressFamily" => AddressFamily,
                    "IpamScopeId" => IpamScopeId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipam_resource_discovery()
    create_ipam_resource_discovery(params::Dict{String,<:Any})

Creates an IPAM resource discovery. A resource discovery is an IPAM component that enables
IPAM to manage and monitor resources that belong to the owning account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A client token for the IPAM resource discovery.
- `"Description"`: A description for the IPAM resource discovery.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"OperatingRegion"`: Operating Regions for the IPAM resource discovery. Operating Regions
  are Amazon Web Services Regions where the IPAM is allowed to manage IP address CIDRs. IPAM
  only discovers and monitors resources in the Amazon Web Services Regions you select as
  operating Regions.
- `"TagSpecification"`: Tag specifications for the IPAM resource discovery.
"""
function create_ipam_resource_discovery(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateIpamResourceDiscovery",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipam_resource_discovery(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateIpamResourceDiscovery",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_ipam_scope(ipam_id)
    create_ipam_scope(ipam_id, params::Dict{String,<:Any})

Create an IPAM scope. In IPAM, a scope is the highest-level container within IPAM. An IPAM
contains two default scopes. Each scope represents the IP space for a single network. The
private scope is intended for all private IP address space. The public scope is intended
for all public IP address space. Scopes enable you to reuse IP addresses across multiple
unconnected networks without causing IP address overlap or conflict. For more information,
see Add a scope in the Amazon VPC IPAM User Guide.

# Arguments
- `ipam_id`: The ID of the IPAM for which you're creating this scope.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the scope you're creating.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The key/value combination of a tag assigned to the resource. Use
  the tag key in the filter name and the tag value as the filter value. For example, to find
  all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for
  the filter name and TeamA for the filter value.
"""
function create_ipam_scope(IpamId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateIpamScope",
        Dict{String,Any}("IpamId" => IpamId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_ipam_scope(
    IpamId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateIpamScope",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IpamId" => IpamId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_key_pair(key_name)
    create_key_pair(key_name, params::Dict{String,<:Any})

Creates an ED25519 or 2048-bit RSA key pair with the specified name and in the specified
PEM or PPK format. Amazon EC2 stores the public key and displays the private key for you to
save to a file. The private key is returned as an unencrypted PEM encoded PKCS#1 private
key or an unencrypted PPK formatted private key for use with PuTTY. If a key with the
specified name already exists, Amazon EC2 returns an error. The key pair returned to you is
available only in the Amazon Web Services Region in which you create it. If you prefer, you
can create your own key pair using a third-party tool and upload it to any Region using
ImportKeyPair. You can have up to 5,000 key pairs per Amazon Web Services Region. For more
information, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.

# Arguments
- `key_name`: A unique name for the key pair. Constraints: Up to 255 ASCII characters

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KeyFormat"`: The format of the key pair. Default: pem
- `"KeyType"`: The type of key pair. Note that ED25519 keys are not supported for Windows
  instances. Default: rsa
- `"TagSpecification"`: The tags to apply to the new key pair.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_key_pair(KeyName; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateKeyPair",
        Dict{String,Any}("KeyName" => KeyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_key_pair(
    KeyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateKeyPair",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("KeyName" => KeyName), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_launch_template(launch_template_data, launch_template_name)
    create_launch_template(launch_template_data, launch_template_name, params::Dict{String,<:Any})

Creates a launch template. A launch template contains the parameters to launch an instance.
When you launch an instance using RunInstances, you can specify a launch template instead
of providing the launch parameters in the request. For more information, see Launch an
instance from a launch template in the Amazon EC2 User Guide. To clone an existing launch
template as the basis for a new launch template, use the Amazon EC2 console. The API, SDKs,
and CLI do not support cloning a template. For more information, see Create a launch
template from an existing launch template in the Amazon EC2 User Guide.

# Arguments
- `launch_template_data`: The information for the launch template.
- `launch_template_name`: A name for the launch template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request. For more information, see Ensuring idempotency. Constraint: Maximum 128
  ASCII characters.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to apply to the launch template on creation. To tag the
  launch template, the resource type must be launch-template. To specify the tags for the
  resources that are created when an instance is launched, you must use the TagSpecifications
  parameter in the launch template data structure.
- `"VersionDescription"`: A description for the first version of the launch template.
"""
function create_launch_template(
    LaunchTemplateData,
    LaunchTemplateName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLaunchTemplate",
        Dict{String,Any}(
            "LaunchTemplateData" => LaunchTemplateData,
            "LaunchTemplateName" => LaunchTemplateName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_launch_template(
    LaunchTemplateData,
    LaunchTemplateName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLaunchTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LaunchTemplateData" => LaunchTemplateData,
                    "LaunchTemplateName" => LaunchTemplateName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_launch_template_version(launch_template_data)
    create_launch_template_version(launch_template_data, params::Dict{String,<:Any})

Creates a new version of a launch template. You must specify an existing launch template,
either by name or ID. You can determine whether the new version inherits parameters from a
source version, and add or overwrite parameters as needed. Launch template versions are
numbered in the order in which they are created. You can't specify, change, or replace the
numbering of launch template versions. Launch templates are immutable; after you create a
launch template, you can't modify it. Instead, you can create a new version of the launch
template that includes the changes that you require. For more information, see Modify a
launch template (manage launch template versions) in the Amazon EC2 User Guide.

# Arguments
- `launch_template_data`: The information for the launch template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request. For more information, see Ensuring idempotency. Constraint: Maximum 128
  ASCII characters.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LaunchTemplateId"`: The ID of the launch template. You must specify either the launch
  template ID or the launch template name, but not both.
- `"LaunchTemplateName"`: The name of the launch template. You must specify either the
  launch template ID or the launch template name, but not both.
- `"ResolveAlias"`: If true, and if a Systems Manager parameter is specified for ImageId,
  the AMI ID is displayed in the response for imageID. For more information, see Use a
  Systems Manager parameter instead of an AMI ID in the Amazon EC2 User Guide. Default: false
- `"SourceVersion"`: The version of the launch template on which to base the new version.
  Snapshots applied to the block device mapping are ignored when creating a new version
  unless they are explicitly included. If you specify this parameter, the new version
  inherits the launch parameters from the source version. If you specify additional launch
  parameters for the new version, they overwrite any corresponding launch parameters
  inherited from the source version. If you omit this parameter, the new version contains
  only the launch parameters that you specify for the new version.
- `"VersionDescription"`: A description for the version of the launch template.
"""
function create_launch_template_version(
    LaunchTemplateData; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateLaunchTemplateVersion",
        Dict{String,Any}("LaunchTemplateData" => LaunchTemplateData);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_launch_template_version(
    LaunchTemplateData,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLaunchTemplateVersion",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("LaunchTemplateData" => LaunchTemplateData), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_local_gateway_route(local_gateway_route_table_id)
    create_local_gateway_route(local_gateway_route_table_id, params::Dict{String,<:Any})

Creates a static route for the specified local gateway route table. You must specify one of
the following targets:     LocalGatewayVirtualInterfaceGroupId     NetworkInterfaceId

# Arguments
- `local_gateway_route_table_id`: The ID of the local gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationCidrBlock"`: The CIDR range used for destination matches. Routing decisions
  are based on the most specific match.
- `"DestinationPrefixListId"`:  The ID of the prefix list. Use a prefix list in place of
  DestinationCidrBlock. You cannot use DestinationPrefixListId and DestinationCidrBlock in
  the same request.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LocalGatewayVirtualInterfaceGroupId"`: The ID of the virtual interface group.
- `"NetworkInterfaceId"`: The ID of the network interface.
"""
function create_local_gateway_route(
    LocalGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateLocalGatewayRoute",
        Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_local_gateway_route(
    LocalGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLocalGatewayRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_local_gateway_route_table(local_gateway_id)
    create_local_gateway_route_table(local_gateway_id, params::Dict{String,<:Any})

 Creates a local gateway route table.

# Arguments
- `local_gateway_id`:  The ID of the local gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Mode"`:  The mode of the local gateway route table.
- `"TagSpecification"`:  The tags assigned to the local gateway route table.
"""
function create_local_gateway_route_table(
    LocalGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateLocalGatewayRouteTable",
        Dict{String,Any}("LocalGatewayId" => LocalGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_local_gateway_route_table(
    LocalGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLocalGatewayRouteTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("LocalGatewayId" => LocalGatewayId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_local_gateway_route_table_virtual_interface_group_association(local_gateway_route_table_id, local_gateway_virtual_interface_group_id)
    create_local_gateway_route_table_virtual_interface_group_association(local_gateway_route_table_id, local_gateway_virtual_interface_group_id, params::Dict{String,<:Any})

 Creates a local gateway route table virtual interface group association.

# Arguments
- `local_gateway_route_table_id`:  The ID of the local gateway route table.
- `local_gateway_virtual_interface_group_id`:  The ID of the local gateway route table
  virtual interface group association.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`:  The tags assigned to the local gateway route table virtual
  interface group association.
"""
function create_local_gateway_route_table_virtual_interface_group_association(
    LocalGatewayRouteTableId,
    LocalGatewayVirtualInterfaceGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Dict{String,Any}(
            "LocalGatewayRouteTableId" => LocalGatewayRouteTableId,
            "LocalGatewayVirtualInterfaceGroupId" => LocalGatewayVirtualInterfaceGroupId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_local_gateway_route_table_virtual_interface_group_association(
    LocalGatewayRouteTableId,
    LocalGatewayVirtualInterfaceGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LocalGatewayRouteTableId" => LocalGatewayRouteTableId,
                    "LocalGatewayVirtualInterfaceGroupId" =>
                        LocalGatewayVirtualInterfaceGroupId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_local_gateway_route_table_vpc_association(local_gateway_route_table_id, vpc_id)
    create_local_gateway_route_table_vpc_association(local_gateway_route_table_id, vpc_id, params::Dict{String,<:Any})

Associates the specified VPC with the specified local gateway route table.

# Arguments
- `local_gateway_route_table_id`: The ID of the local gateway route table.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to assign to the local gateway route table VPC association.
"""
function create_local_gateway_route_table_vpc_association(
    LocalGatewayRouteTableId, VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateLocalGatewayRouteTableVpcAssociation",
        Dict{String,Any}(
            "LocalGatewayRouteTableId" => LocalGatewayRouteTableId, "VpcId" => VpcId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_local_gateway_route_table_vpc_association(
    LocalGatewayRouteTableId,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateLocalGatewayRouteTableVpcAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LocalGatewayRouteTableId" => LocalGatewayRouteTableId, "VpcId" => VpcId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_managed_prefix_list(address_family, max_entries, prefix_list_name)
    create_managed_prefix_list(address_family, max_entries, prefix_list_name, params::Dict{String,<:Any})

Creates a managed prefix list. You can specify one or more entries for the prefix list.
Each entry consists of a CIDR block and an optional description.

# Arguments
- `address_family`: The IP address type. Valid Values: IPv4 | IPv6
- `max_entries`: The maximum number of entries for the prefix list.
- `prefix_list_name`: A name for the prefix list. Constraints: Up to 255 characters in
  length. The name cannot start with com.amazonaws.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request. For more information, see Ensuring idempotency. Constraints: Up to 255
  UTF-8 characters in length.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Entry"`: One or more entries for the prefix list.
- `"TagSpecification"`: The tags to apply to the prefix list during creation.
"""
function create_managed_prefix_list(
    AddressFamily,
    MaxEntries,
    PrefixListName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateManagedPrefixList",
        Dict{String,Any}(
            "AddressFamily" => AddressFamily,
            "MaxEntries" => MaxEntries,
            "PrefixListName" => PrefixListName,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_managed_prefix_list(
    AddressFamily,
    MaxEntries,
    PrefixListName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateManagedPrefixList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AddressFamily" => AddressFamily,
                    "MaxEntries" => MaxEntries,
                    "PrefixListName" => PrefixListName,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_nat_gateway(subnet_id)
    create_nat_gateway(subnet_id, params::Dict{String,<:Any})

Creates a NAT gateway in the specified subnet. This action creates a network interface in
the specified subnet with a private IP address from the IP address range of the subnet. You
can create either a public NAT gateway or a private NAT gateway. With a public NAT gateway,
internet-bound traffic from a private subnet can be routed to the NAT gateway, so that
instances in a private subnet can connect to the internet. With a private NAT gateway,
private communication is routed across VPCs and on-premises networks through a transit
gateway or virtual private gateway. Common use cases include running large workloads behind
a small pool of allowlisted IPv4 addresses, preserving private IPv4 addresses, and
communicating between overlapping networks. For more information, see NAT gateways in the
Amazon VPC User Guide.  When you create a public NAT gateway and assign it an EIP or
secondary EIPs, the network border group of the EIPs must match the network border group of
the Availability Zone (AZ) that the public NAT gateway is in. If it's not the same, the NAT
gateway will fail to launch. You can see the network border group for the subnet's AZ by
viewing the details of the subnet. Similarly, you can view the network border group of an
EIP by viewing the details of the EIP address. For more information about network border
groups and EIPs, see Allocate an Elastic IP address in the Amazon VPC User Guide.

# Arguments
- `subnet_id`: The ID of the subnet in which to create the NAT gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationId"`: [Public NAT gateways only] The allocation ID of an Elastic IP address
  to associate with the NAT gateway. You cannot specify an Elastic IP address with a private
  NAT gateway. If the Elastic IP address is associated with another resource, you must first
  disassociate it.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency. Constraint:
  Maximum 64 ASCII characters.
- `"ConnectivityType"`: Indicates whether the NAT gateway supports public or private
  connectivity. The default is public connectivity.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PrivateIpAddress"`: The private IPv4 address to assign to the NAT gateway. If you don't
  provide an address, a private IPv4 address will be automatically assigned.
- `"SecondaryAllocationId"`: Secondary EIP allocation IDs. For more information, see Create
  a NAT gateway in the Amazon VPC User Guide.
- `"SecondaryPrivateIpAddress"`: Secondary private IPv4 addresses. For more information
  about secondary addresses, see Create a NAT gateway in the Amazon VPC User Guide.
- `"SecondaryPrivateIpAddressCount"`: [Private NAT gateway only] The number of secondary
  private IPv4 addresses you want to assign to the NAT gateway. For more information about
  secondary addresses, see Create a NAT gateway in the Amazon VPC User Guide.
- `"TagSpecification"`: The tags to assign to the NAT gateway.
"""
function create_nat_gateway(SubnetId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateNatGateway",
        Dict{String,Any}("SubnetId" => SubnetId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_nat_gateway(
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNatGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SubnetId" => SubnetId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_acl(vpc_id)
    create_network_acl(vpc_id, params::Dict{String,<:Any})

Creates a network ACL in a VPC. Network ACLs provide an optional layer of security (in
addition to security groups) for the instances in your VPC. For more information, see
Network ACLs in the Amazon VPC User Guide.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"TagSpecification"`: The tags to assign to the network ACL.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_network_acl(vpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateNetworkAcl",
        Dict{String,Any}("vpcId" => vpcId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_acl(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateNetworkAcl",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("vpcId" => vpcId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_acl_entry(egress, network_acl_id, protocol, rule_action, rule_number)
    create_network_acl_entry(egress, network_acl_id, protocol, rule_action, rule_number, params::Dict{String,<:Any})

Creates an entry (a rule) in a network ACL with the specified rule number. Each network ACL
has a set of numbered ingress rules and a separate set of numbered egress rules. When
determining whether a packet should be allowed in or out of a subnet associated with the
ACL, we process the entries in the ACL according to the rule numbers, in ascending order.
Each network ACL has a set of ingress rules and a separate set of egress rules. We
recommend that you leave room between the rule numbers (for example, 100, 110, 120, ...),
and not number them one right after the other (for example, 101, 102, 103, ...). This makes
it easier to add a rule between existing ones without having to renumber the rules. After
you add an entry, you can't modify it; you must either replace it, or create an entry and
delete the old one. For more information about network ACLs, see Network ACLs in the Amazon
VPC User Guide.

# Arguments
- `egress`: Indicates whether this is an egress rule (rule is applied to traffic leaving
  the subnet).
- `network_acl_id`: The ID of the network ACL.
- `protocol`: The protocol number. A value of \"-1\" means all protocols. If you specify
  \"-1\" or a protocol number other than \"6\" (TCP), \"17\" (UDP), or \"1\" (ICMP), traffic
  on all ports is allowed, regardless of any ports or ICMP types or codes that you specify.
  If you specify protocol \"58\" (ICMPv6) and specify an IPv4 CIDR block, traffic for all
  ICMP types and codes allowed, regardless of any that you specify. If you specify protocol
  \"58\" (ICMPv6) and specify an IPv6 CIDR block, you must specify an ICMP type and code.
- `rule_action`: Indicates whether to allow or deny the traffic that matches the rule.
- `rule_number`: The rule number for the entry (for example, 100). ACL entries are
  processed in ascending order by rule number. Constraints: Positive integer from 1 to 32766.
  The range 32767 to 65535 is reserved for internal use.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Icmp"`: ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying
  protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
- `"cidrBlock"`: The IPv4 network range to allow or deny, in CIDR notation (for example
  172.16.0.0/24). We modify the specified CIDR block to its canonical form; for example, if
  you specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ipv6CidrBlock"`: The IPv6 network range to allow or deny, in CIDR notation (for example
  2001:db8:1234:1a00::/64).
- `"portRange"`: TCP or UDP protocols: The range of ports the rule applies to. Required if
  specifying protocol 6 (TCP) or 17 (UDP).
"""
function create_network_acl_entry(
    egress,
    networkAclId,
    protocol,
    ruleAction,
    ruleNumber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkAclEntry",
        Dict{String,Any}(
            "egress" => egress,
            "networkAclId" => networkAclId,
            "protocol" => protocol,
            "ruleAction" => ruleAction,
            "ruleNumber" => ruleNumber,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_acl_entry(
    egress,
    networkAclId,
    protocol,
    ruleAction,
    ruleNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkAclEntry",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "egress" => egress,
                    "networkAclId" => networkAclId,
                    "protocol" => protocol,
                    "ruleAction" => ruleAction,
                    "ruleNumber" => ruleNumber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_insights_access_scope(client_token)
    create_network_insights_access_scope(client_token, params::Dict{String,<:Any})

Creates a Network Access Scope. Amazon Web Services Network Access Analyzer enables cloud
networking and cloud operations teams to verify that their networks on Amazon Web Services
conform to their network security and governance objectives. For more information, see the
Amazon Web Services Network Access Analyzer Guide.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ExcludePath"`: The paths to exclude.
- `"MatchPath"`: The paths to match.
- `"TagSpecification"`: The tags to apply.
"""
function create_network_insights_access_scope(
    ClientToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateNetworkInsightsAccessScope",
        Dict{String,Any}("ClientToken" => ClientToken);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_insights_access_scope(
    ClientToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkInsightsAccessScope",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => ClientToken), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_insights_path(client_token, protocol, source)
    create_network_insights_path(client_token, protocol, source, params::Dict{String,<:Any})

Creates a path to analyze for reachability. Reachability Analyzer enables you to analyze
and debug network reachability between two resources in your virtual private cloud (VPC).
For more information, see the Reachability Analyzer Guide.

# Arguments
- `client_token`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `protocol`: The protocol.
- `source`: The ID or ARN of the source. If the resource is in another account, you must
  specify an ARN.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Destination"`: The ID or ARN of the destination. If the resource is in another account,
  you must specify an ARN.
- `"DestinationIp"`: The IP address of the destination.
- `"DestinationPort"`: The destination port.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"FilterAtDestination"`: Scopes the analysis to network paths that match specific filters
  at the destination. If you specify this parameter, you can't specify the parameter for the
  destination IP address.
- `"FilterAtSource"`: Scopes the analysis to network paths that match specific filters at
  the source. If you specify this parameter, you can't specify the parameters for the source
  IP address or the destination port.
- `"SourceIp"`: The IP address of the source.
- `"TagSpecification"`: The tags to add to the path.
"""
function create_network_insights_path(
    ClientToken, Protocol, Source; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateNetworkInsightsPath",
        Dict{String,Any}(
            "ClientToken" => ClientToken, "Protocol" => Protocol, "Source" => Source
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_insights_path(
    ClientToken,
    Protocol,
    Source,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkInsightsPath",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientToken" => ClientToken, "Protocol" => Protocol, "Source" => Source
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_interface(subnet_id)
    create_network_interface(subnet_id, params::Dict{String,<:Any})

Creates a network interface in the specified subnet. The number of IP addresses you can
assign to a network interface varies by instance type. For more information about network
interfaces, see Elastic network interfaces in the Amazon EC2 User Guide.

# Arguments
- `subnet_id`: The ID of the subnet to associate with the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"ConnectionTrackingSpecification"`: A connection tracking specification for the network
  interface.
- `"EnablePrimaryIpv6"`: If you’re creating a network interface in a dual-stack or
  IPv6-only subnet, you have the option to assign a primary IPv6 IP address. A primary IPv6
  address is an IPv6 GUA address associated with an ENI that you have enabled to use a
  primary IPv6 address. Use this option if the instance that this ENI will be attached to
  relies on its IPv6 address not changing. Amazon Web Services will automatically assign an
  IPv6 address associated with the ENI attached to your instance to be the primary IPv6
  address. Once you enable an IPv6 GUA address to be a primary IPv6, you cannot disable it.
  When you enable an IPv6 GUA address to be a primary IPv6, the first IPv6 GUA will be made
  the primary IPv6 address until the instance is terminated or the network interface is
  detached. If you have multiple IPv6 addresses associated with an ENI attached to your
  instance and you enable a primary IPv6 address, the first IPv6 GUA address associated with
  the ENI becomes the primary IPv6 address.
- `"InterfaceType"`: The type of network interface. The default is interface. The only
  supported values are interface, efa, and trunk.
- `"Ipv4Prefix"`: The IPv4 prefixes assigned to the network interface. You can't specify
  IPv4 prefixes if you've specified one of the following: a count of IPv4 prefixes, specific
  private IPv4 addresses, or a count of private IPv4 addresses.
- `"Ipv4PrefixCount"`: The number of IPv4 prefixes that Amazon Web Services automatically
  assigns to the network interface. You can't specify a count of IPv4 prefixes if you've
  specified one of the following: specific IPv4 prefixes, specific private IPv4 addresses, or
  a count of private IPv4 addresses.
- `"Ipv6Prefix"`: The IPv6 prefixes assigned to the network interface. You can't specify
  IPv6 prefixes if you've specified one of the following: a count of IPv6 prefixes, specific
  IPv6 addresses, or a count of IPv6 addresses.
- `"Ipv6PrefixCount"`: The number of IPv6 prefixes that Amazon Web Services automatically
  assigns to the network interface. You can't specify a count of IPv6 prefixes if you've
  specified one of the following: specific IPv6 prefixes, specific IPv6 addresses, or a count
  of IPv6 addresses.
- `"SecurityGroupId"`: The IDs of one or more security groups.
- `"TagSpecification"`: The tags to apply to the new network interface.
- `"description"`: A description for the network interface.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ipv6AddressCount"`: The number of IPv6 addresses to assign to a network interface.
  Amazon EC2 automatically selects the IPv6 addresses from the subnet range. You can't
  specify a count of IPv6 addresses using this parameter if you've specified one of the
  following: specific IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes. If
  your subnet has the AssignIpv6AddressOnCreation attribute set, you can override that
  setting by specifying 0 as the IPv6 address count.
- `"ipv6Addresses"`: The IPv6 addresses from the IPv6 CIDR block range of your subnet. You
  can't specify IPv6 addresses using this parameter if you've specified one of the following:
  a count of IPv6 addresses, specific IPv6 prefixes, or a count of IPv6 prefixes.
- `"privateIpAddress"`: The primary private IPv4 address of the network interface. If you
  don't specify an IPv4 address, Amazon EC2 selects one for you from the subnet's IPv4 CIDR
  range. If you specify an IP address, you cannot indicate any IP addresses specified in
  privateIpAddresses as primary (only one IP address can be designated as primary).
- `"privateIpAddresses"`: The private IPv4 addresses. You can't specify private IPv4
  addresses if you've specified one of the following: a count of private IPv4 addresses,
  specific IPv4 prefixes, or a count of IPv4 prefixes.
- `"secondaryPrivateIpAddressCount"`: The number of secondary private IPv4 addresses to
  assign to a network interface. When you specify a number of secondary IPv4 addresses,
  Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't
  specify this option and specify more than one private IP address using privateIpAddresses.
  You can't specify a count of private IPv4 addresses if you've specified one of the
  following: specific private IPv4 addresses, specific IPv4 prefixes, or a count of IPv4
  prefixes.
"""
function create_network_interface(
    subnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateNetworkInterface",
        Dict{String,Any}("subnetId" => subnetId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_interface(
    subnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkInterface",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("subnetId" => subnetId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_network_interface_permission(network_interface_id, permission)
    create_network_interface_permission(network_interface_id, permission, params::Dict{String,<:Any})

Grants an Amazon Web Services-authorized account permission to attach the specified network
interface to an instance in their account. You can grant permission to a single Amazon Web
Services account only, and only one account at a time.

# Arguments
- `network_interface_id`: The ID of the network interface.
- `permission`: The type of permission to grant.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AwsAccountId"`: The Amazon Web Services account ID.
- `"AwsService"`: The Amazon Web Service. Currently not supported.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_network_interface_permission(
    NetworkInterfaceId, Permission; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateNetworkInterfacePermission",
        Dict{String,Any}(
            "NetworkInterfaceId" => NetworkInterfaceId, "Permission" => Permission
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_network_interface_permission(
    NetworkInterfaceId,
    Permission,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateNetworkInterfacePermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NetworkInterfaceId" => NetworkInterfaceId, "Permission" => Permission
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_placement_group()
    create_placement_group(params::Dict{String,<:Any})

Creates a placement group in which to launch instances. The strategy of the placement group
determines how the instances are organized within the group.  A cluster placement group is
a logical grouping of instances within a single Availability Zone that benefit from low
network latency, high network throughput. A spread placement group places instances on
distinct hardware. A partition placement group places groups of instances in different
partitions, where instances in one partition do not share the same hardware with instances
in another partition. For more information, see Placement groups in the Amazon EC2 User
Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PartitionCount"`: The number of partitions. Valid only when Strategy is set to
  partition.
- `"SpreadLevel"`: Determines how placement groups spread instances.    Host – You can
  use host only with Outpost placement groups.   Rack – No usage restrictions.
- `"TagSpecification"`: The tags to apply to the new placement group.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"groupName"`: A name for the placement group. Must be unique within the scope of your
  account for the Region. Constraints: Up to 255 ASCII characters
- `"strategy"`: The placement strategy.
"""
function create_placement_group(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreatePlacementGroup"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_placement_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreatePlacementGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_public_ipv4_pool()
    create_public_ipv4_pool(params::Dict{String,<:Any})

Creates a public IPv4 address pool. A public IPv4 pool is an EC2 IP address pool required
for the public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with
IPAM. IPv6 addresses you bring to Amazon Web Services, however, use IPAM pools only. To
monitor the status of pool creation, use DescribePublicIpv4Pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The key/value combination of a tag assigned to the resource. Use
  the tag key in the filter name and the tag value as the filter value. For example, to find
  all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for
  the filter name and TeamA for the filter value.
"""
function create_public_ipv4_pool(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreatePublicIpv4Pool"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_public_ipv4_pool(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreatePublicIpv4Pool",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_replace_root_volume_task(instance_id)
    create_replace_root_volume_task(instance_id, params::Dict{String,<:Any})

Replaces the EBS-backed root volume for a running instance with a new volume that is
restored to the original root volume's launch state, that is restored to a specific
snapshot taken from the original root volume, or that is restored from an AMI that has the
same key characteristics as that of the instance. For more information, see Replace a root
volume in the Amazon EC2 User Guide.

# Arguments
- `instance_id`: The ID of the instance for which to replace the root volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier you provide to ensure the idempotency
  of the request. If you do not specify a client token, a randomly generated token is used
  for the request to ensure idempotency. For more information, see Ensuring idempotency.
- `"DeleteReplacedRootVolume"`: Indicates whether to automatically delete the original root
  volume after the root volume replacement task completes. To delete the original root
  volume, specify true. If you choose to keep the original root volume after the replacement
  task completes, you must manually delete it when you no longer need it.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ImageId"`: The ID of the AMI to use to restore the root volume. The specified AMI must
  have the same product code, billing information, architecture type, and virtualization type
  as that of the instance. If you want to restore the replacement volume from a specific
  snapshot, or if you want to restore it to its launch state, omit this parameter.
- `"SnapshotId"`: The ID of the snapshot from which to restore the replacement root volume.
  The specified snapshot must be a snapshot that you previously created from the original
  root volume. If you want to restore the replacement root volume to the initial launch
  state, or if you want to restore the replacement root volume from an AMI, omit this
  parameter.
- `"TagSpecification"`: The tags to apply to the root volume replacement task.
"""
function create_replace_root_volume_task(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateReplaceRootVolumeTask",
        Dict{String,Any}("InstanceId" => InstanceId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_replace_root_volume_task(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateReplaceRootVolumeTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceId" => InstanceId, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_reserved_instances_listing(client_token, instance_count, price_schedules, reserved_instances_id)
    create_reserved_instances_listing(client_token, instance_count, price_schedules, reserved_instances_id, params::Dict{String,<:Any})

Creates a listing for Amazon EC2 Standard Reserved Instances to be sold in the Reserved
Instance Marketplace. You can submit one Standard Reserved Instance listing at a time. To
get a list of your Standard Reserved Instances, you can use the DescribeReservedInstances
operation.  Only Standard Reserved Instances can be sold in the Reserved Instance
Marketplace. Convertible Reserved Instances cannot be sold.  The Reserved Instance
Marketplace matches sellers who want to resell Standard Reserved Instance capacity that
they no longer need with buyers who want to purchase additional capacity. Reserved
Instances bought and sold through the Reserved Instance Marketplace work like any other
Reserved Instances. To sell your Standard Reserved Instances, you must first register as a
seller in the Reserved Instance Marketplace. After completing the registration process, you
can create a Reserved Instance Marketplace listing of some or all of your Standard Reserved
Instances, and specify the upfront price to receive for them. Your Standard Reserved
Instance listings then become available for purchase. To view the details of your Standard
Reserved Instance listing, you can use the DescribeReservedInstancesListings operation. For
more information, see Sell in the Reserved Instance Marketplace in the Amazon EC2 User
Guide.

# Arguments
- `client_token`: Unique, case-sensitive identifier you provide to ensure idempotency of
  your listings. This helps avoid duplicate listings. For more information, see Ensuring
  Idempotency.
- `instance_count`: The number of instances that are a part of a Reserved Instance account
  to be listed in the Reserved Instance Marketplace. This number should be less than or equal
  to the instance count associated with the Reserved Instance ID specified in this call.
- `price_schedules`: A list specifying the price of the Standard Reserved Instance for each
  month remaining in the Reserved Instance term.
- `reserved_instances_id`: The ID of the active Standard Reserved Instance.

"""
function create_reserved_instances_listing(
    clientToken,
    instanceCount,
    priceSchedules,
    reservedInstancesId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateReservedInstancesListing",
        Dict{String,Any}(
            "clientToken" => clientToken,
            "instanceCount" => instanceCount,
            "priceSchedules" => priceSchedules,
            "reservedInstancesId" => reservedInstancesId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_reserved_instances_listing(
    clientToken,
    instanceCount,
    priceSchedules,
    reservedInstancesId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateReservedInstancesListing",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "clientToken" => clientToken,
                    "instanceCount" => instanceCount,
                    "priceSchedules" => priceSchedules,
                    "reservedInstancesId" => reservedInstancesId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_restore_image_task(bucket, object_key)
    create_restore_image_task(bucket, object_key, params::Dict{String,<:Any})

Starts a task that restores an AMI from an Amazon S3 object that was previously created by
using CreateStoreImageTask. To use this API, you must have the required permissions. For
more information, see Permissions for storing and restoring AMIs using Amazon S3 in the
Amazon EC2 User Guide. For more information, see Store and restore an AMI using Amazon S3
in the Amazon EC2 User Guide.

# Arguments
- `bucket`: The name of the Amazon S3 bucket that contains the stored AMI object.
- `object_key`: The name of the stored AMI object in the bucket.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Name"`: The name for the restored AMI. The name must be unique for AMIs in the Region
  for this account. If you do not provide a name, the new AMI gets the same name as the
  original AMI.
- `"TagSpecification"`: The tags to apply to the AMI and snapshots on restoration. You can
  tag the AMI, the snapshots, or both.   To tag the AMI, the value for ResourceType must be
  image.   To tag the snapshots, the value for ResourceType must be snapshot. The same tag is
  applied to all of the snapshots that are created.
"""
function create_restore_image_task(
    Bucket, ObjectKey; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateRestoreImageTask",
        Dict{String,Any}("Bucket" => Bucket, "ObjectKey" => ObjectKey);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_restore_image_task(
    Bucket,
    ObjectKey,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateRestoreImageTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Bucket" => Bucket, "ObjectKey" => ObjectKey),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_route(route_table_id)
    create_route(route_table_id, params::Dict{String,<:Any})

Creates a route in a route table within a VPC. You must specify either a destination CIDR
block or a prefix list ID. You must also specify exactly one of the resources from the
parameter list. When determining how to route traffic, we use the route with the most
specific match. For example, traffic is destined for the IPv4 address 192.0.2.3, and the
route table includes the following two IPv4 routes:    192.0.2.0/24 (goes to some target A)
   192.0.2.0/28 (goes to some target B)   Both routes apply to the traffic destined for
192.0.2.3. However, the second route in the list covers a smaller number of IP addresses
and is therefore more specific, so we use that route to determine where to target the
traffic. For more information about route tables, see Route tables in the Amazon VPC User
Guide.

# Arguments
- `route_table_id`: The ID of the route table for the route.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CarrierGatewayId"`: The ID of the carrier gateway. You can only use this option when
  the VPC contains a subnet which is associated with a Wavelength Zone.
- `"CoreNetworkArn"`: The Amazon Resource Name (ARN) of the core network.
- `"DestinationPrefixListId"`: The ID of a prefix list used for the destination match.
- `"LocalGatewayId"`: The ID of the local gateway.
- `"TransitGatewayId"`: The ID of a transit gateway.
- `"VpcEndpointId"`: The ID of a VPC endpoint. Supported for Gateway Load Balancer
  endpoints only.
- `"destinationCidrBlock"`: The IPv4 CIDR address block used for the destination match.
  Routing decisions are based on the most specific match. We modify the specified CIDR block
  to its canonical form; for example, if you specify 100.68.0.18/18, we modify it to
  100.68.0.0/18.
- `"destinationIpv6CidrBlock"`: The IPv6 CIDR block used for the destination match. Routing
  decisions are based on the most specific match.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"egressOnlyInternetGatewayId"`: [IPv6 traffic only] The ID of an egress-only internet
  gateway.
- `"gatewayId"`: The ID of an internet gateway or virtual private gateway attached to your
  VPC.
- `"instanceId"`: The ID of a NAT instance in your VPC. The operation fails if you specify
  an instance ID unless exactly one network interface is attached.
- `"natGatewayId"`: [IPv4 traffic only] The ID of a NAT gateway.
- `"networkInterfaceId"`: The ID of a network interface.
- `"vpcPeeringConnectionId"`: The ID of a VPC peering connection.
"""
function create_route(routeTableId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateRoute",
        Dict{String,Any}("routeTableId" => routeTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_route(
    routeTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateRoute",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("routeTableId" => routeTableId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_route_table(vpc_id)
    create_route_table(vpc_id, params::Dict{String,<:Any})

Creates a route table for the specified VPC. After you create a route table, you can add
routes and associate the table with a subnet. For more information, see Route tables in the
Amazon VPC User Guide.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"TagSpecification"`: The tags to assign to the route table.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_route_table(vpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateRouteTable",
        Dict{String,Any}("vpcId" => vpcId, "ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_route_table(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("vpcId" => vpcId, "ClientToken" => string(uuid4())),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_security_group(group_description, group_name)
    create_security_group(group_description, group_name, params::Dict{String,<:Any})

Creates a security group. A security group acts as a virtual firewall for your instance to
control inbound and outbound traffic. For more information, see Amazon EC2 security groups
in the Amazon Elastic Compute Cloud User Guide and Security groups for your VPC in the
Amazon Virtual Private Cloud User Guide. When you create a security group, you specify a
friendly name of your choice. You can't have two security groups for the same VPC with the
same name. You have a default security group for use in your VPC. If you don't specify a
security group when you launch an instance, the instance is launched into the appropriate
default security group. A default security group includes a default rule that grants
instances unrestricted network access to each other. You can add or remove rules from your
security groups using AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress. For more information about VPC
security group limits, see Amazon VPC Limits.

# Arguments
- `group_description`: A description for the security group. Constraints: Up to 255
  characters in length Valid characters: a-z, A-Z, 0-9, spaces, and ._-:/()#,@[]+=&amp;;{}!*
- `group_name`: The name of the security group. Constraints: Up to 255 characters in
  length. Cannot start with sg-. Valid characters: a-z, A-Z, 0-9, spaces, and
  ._-:/()#,@[]+=&amp;;{}!*

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to assign to the security group.
- `"VpcId"`: The ID of the VPC. Required for a nondefault VPC.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_security_group(
    GroupDescription, GroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSecurityGroup",
        Dict{String,Any}("GroupDescription" => GroupDescription, "GroupName" => GroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_security_group(
    GroupDescription,
    GroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GroupDescription" => GroupDescription, "GroupName" => GroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshot(volume_id)
    create_snapshot(volume_id, params::Dict{String,<:Any})

Creates a snapshot of an EBS volume and stores it in Amazon S3. You can use snapshots for
backups, to make copies of EBS volumes, and to save data before shutting down an instance.
You can create snapshots of volumes in a Region and volumes on an Outpost. If you create a
snapshot of a volume in a Region, the snapshot must be stored in the same Region as the
volume. If you create a snapshot of a volume on an Outpost, the snapshot can be stored on
the same Outpost as the volume, or in the Region for that Outpost. When a snapshot is
created, any Amazon Web Services Marketplace product codes that are associated with the
source volume are propagated to the snapshot. You can take a snapshot of an attached volume
that is in use. However, snapshots only capture data that has been written to your Amazon
EBS volume at the time the snapshot command is issued; this might exclude any data that has
been cached by any applications or the operating system. If you can pause any file systems
on the volume long enough to take a snapshot, your snapshot should be complete. However, if
you cannot pause all file writes to the volume, you should unmount the volume from within
the instance, issue the snapshot command, and then remount the volume to ensure a
consistent and complete snapshot. You may remount and use your volume while the snapshot
status is pending. When you create a snapshot for an EBS volume that serves as a root
device, we recommend that you stop the instance before taking the snapshot. Snapshots that
are taken from encrypted volumes are automatically encrypted. Volumes that are created from
encrypted snapshots are also automatically encrypted. Your encrypted volumes and any
associated snapshots always remain protected. You can tag your snapshots during creation.
For more information, see Tag your Amazon EC2 resources in the Amazon EC2 User Guide. For
more information, see Amazon EBS and Amazon EBS encryption in the Amazon EBS User Guide.

# Arguments
- `volume_id`: The ID of the Amazon EBS volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description for the snapshot.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost on which to create a local
  snapshot.   To create a snapshot of a volume in a Region, omit this parameter. The snapshot
  is created in the same Region as the volume.   To create a snapshot of a volume on an
  Outpost and store the snapshot in the Region, omit this parameter. The snapshot is created
  in the Region for the Outpost.   To create a snapshot of a volume on an Outpost and store
  the snapshot on an Outpost, specify the ARN of the destination Outpost. The snapshot must
  be created on the same Outpost as the volume.   For more information, see Create local
  snapshots from volumes on an Outpost in the Amazon EBS User Guide.
- `"TagSpecification"`: The tags to apply to the snapshot during creation.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_snapshot(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateSnapshot",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshot(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_snapshots(instance_specification)
    create_snapshots(instance_specification, params::Dict{String,<:Any})

Creates crash-consistent snapshots of multiple EBS volumes and stores the data in S3.
Volumes are chosen by specifying an instance. Any attached volumes will produce one
snapshot each that is crash-consistent across the instance. You can include all of the
volumes currently attached to the instance, or you can exclude the root volume or specific
data (non-root) volumes from the multi-volume snapshot set. You can create multi-volume
snapshots of instances in a Region and instances on an Outpost. If you create snapshots
from an instance in a Region, the snapshots must be stored in the same Region as the
instance. If you create snapshots from an instance on an Outpost, the snapshots can be
stored on the same Outpost as the instance, or in the Region for that Outpost.

# Arguments
- `instance_specification`: The instance to specify which volumes should be included in the
  snapshots.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CopyTagsFromSource"`: Copies the tags from the specified volume to corresponding
  snapshot.
- `"Description"`:  A description propagated to every snapshot specified by the instance.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost on which to create the
  local snapshots.   To create snapshots from an instance in a Region, omit this parameter.
  The snapshots are created in the same Region as the instance.   To create snapshots from an
  instance on an Outpost and store the snapshots in the Region, omit this parameter. The
  snapshots are created in the Region for the Outpost.   To create snapshots from an instance
  on an Outpost and store the snapshots on an Outpost, specify the ARN of the destination
  Outpost. The snapshots must be created on the same Outpost as the instance.   For more
  information, see  Create multi-volume local snapshots from instances on an Outpost in the
  Amazon EBS User Guide.
- `"TagSpecification"`: Tags to apply to every snapshot specified by the instance.
"""
function create_snapshots(
    InstanceSpecification; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSnapshots",
        Dict{String,Any}("InstanceSpecification" => InstanceSpecification);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_snapshots(
    InstanceSpecification,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateSnapshots",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceSpecification" => InstanceSpecification),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_spot_datafeed_subscription(bucket)
    create_spot_datafeed_subscription(bucket, params::Dict{String,<:Any})

Creates a data feed for Spot Instances, enabling you to view Spot Instance usage logs. You
can create one data feed per Amazon Web Services account. For more information, see Spot
Instance data feed in the Amazon EC2 User Guide.

# Arguments
- `bucket`: The name of the Amazon S3 bucket in which to store the Spot Instance data feed.
  For more information about bucket names, see Rules for bucket naming in the Amazon S3
  Developer Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"prefix"`: The prefix for the data feed file names.
"""
function create_spot_datafeed_subscription(
    bucket; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSpotDatafeedSubscription",
        Dict{String,Any}("bucket" => bucket);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_spot_datafeed_subscription(
    bucket, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSpotDatafeedSubscription",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("bucket" => bucket), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_store_image_task(bucket, image_id)
    create_store_image_task(bucket, image_id, params::Dict{String,<:Any})

Stores an AMI as a single object in an Amazon S3 bucket. To use this API, you must have the
required permissions. For more information, see Permissions for storing and restoring AMIs
using Amazon S3 in the Amazon EC2 User Guide. For more information, see Store and restore
an AMI using Amazon S3 in the Amazon EC2 User Guide.

# Arguments
- `bucket`: The name of the Amazon S3 bucket in which the AMI object will be stored. The
  bucket must be in the Region in which the request is being made. The AMI object appears in
  the bucket only after the upload task has completed.
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"S3ObjectTag"`: The tags to apply to the AMI object that will be stored in the Amazon S3
  bucket.
"""
function create_store_image_task(
    Bucket, ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateStoreImageTask",
        Dict{String,Any}("Bucket" => Bucket, "ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_store_image_task(
    Bucket,
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateStoreImageTask",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Bucket" => Bucket, "ImageId" => ImageId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_subnet(vpc_id)
    create_subnet(vpc_id, params::Dict{String,<:Any})

Creates a subnet in the specified VPC. For an IPv4 only subnet, specify an IPv4 CIDR block.
If the VPC has an IPv6 CIDR block, you can create an IPv6 only subnet or a dual stack
subnet instead. For an IPv6 only subnet, specify an IPv6 CIDR block. For a dual stack
subnet, specify both an IPv4 CIDR block and an IPv6 CIDR block. A subnet CIDR block must
not overlap the CIDR block of an existing subnet in the VPC. After you create a subnet, you
can't change its CIDR block. The allowed size for an IPv4 subnet is between a /28 netmask
(16 IP addresses) and a /16 netmask (65,536 IP addresses). Amazon Web Services reserves
both the first four and the last IPv4 address in each subnet's CIDR block. They're not
available for your use. If you've associated an IPv6 CIDR block with your VPC, you can
associate an IPv6 CIDR block with a subnet when you create it.  If you add more than one
subnet to a VPC, they're set up in a star topology with a logical router in the middle.
When you stop an instance in a subnet, it retains its private IPv4 address. It's therefore
possible to have a subnet with no running instances (they're all stopped), but no remaining
IP addresses available. For more information, see Subnets in the Amazon VPC User Guide.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZone"`: The Availability Zone or Local Zone for the subnet. Default: Amazon
  Web Services selects one for you. If you create more than one subnet in your VPC, we do not
  necessarily select a different zone for each subnet. To create a subnet in a Local Zone,
  set this value to the Local Zone ID, for example us-west-2-lax-1a. For information about
  the Regions that support Local Zones, see Available Local Zones. To create a subnet in an
  Outpost, set this value to the Availability Zone for the Outpost and specify the Outpost
  ARN.
- `"AvailabilityZoneId"`: The AZ ID or the Local Zone ID of the subnet.
- `"CidrBlock"`: The IPv4 network range for the subnet, in CIDR notation. For example,
  10.0.0.0/24. We modify the specified CIDR block to its canonical form; for example, if you
  specify 100.68.0.18/18, we modify it to 100.68.0.0/18. This parameter is not supported for
  an IPv6 only subnet.
- `"Ipv4IpamPoolId"`: An IPv4 IPAM pool ID for the subnet.
- `"Ipv4NetmaskLength"`: An IPv4 netmask length for the subnet.
- `"Ipv6CidrBlock"`: The IPv6 network range for the subnet, in CIDR notation. This
  parameter is required for an IPv6 only subnet.
- `"Ipv6IpamPoolId"`: An IPv6 IPAM pool ID for the subnet.
- `"Ipv6Native"`: Indicates whether to create an IPv6 only subnet.
- `"Ipv6NetmaskLength"`: An IPv6 netmask length for the subnet.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost. If you specify an Outpost
  ARN, you must also specify the Availability Zone of the Outpost subnet.
- `"TagSpecification"`: The tags to assign to the subnet.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_subnet(VpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateSubnet",
        Dict{String,Any}("VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_subnet(
    VpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSubnet",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("VpcId" => VpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_subnet_cidr_reservation(cidr, reservation_type, subnet_id)
    create_subnet_cidr_reservation(cidr, reservation_type, subnet_id, params::Dict{String,<:Any})

Creates a subnet CIDR reservation. For more information, see Subnet CIDR reservations in
the Amazon VPC User Guide and Assign prefixes to network interfaces in the Amazon EC2 User
Guide.

# Arguments
- `cidr`: The IPv4 or IPV6 CIDR range to reserve.
- `reservation_type`: The type of reservation. The reservation type determines how the
  reserved IP addresses are assigned to resources.    prefix - Amazon Web Services assigns
  the reserved IP addresses to network interfaces.    explicit - You assign the reserved IP
  addresses to network interfaces.
- `subnet_id`: The ID of the subnet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description to assign to the subnet CIDR reservation.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to assign to the subnet CIDR reservation.
"""
function create_subnet_cidr_reservation(
    Cidr, ReservationType, SubnetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateSubnetCidrReservation",
        Dict{String,Any}(
            "Cidr" => Cidr, "ReservationType" => ReservationType, "SubnetId" => SubnetId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_subnet_cidr_reservation(
    Cidr,
    ReservationType,
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateSubnetCidrReservation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Cidr" => Cidr,
                    "ReservationType" => ReservationType,
                    "SubnetId" => SubnetId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tags(resource_id, tag)
    create_tags(resource_id, tag, params::Dict{String,<:Any})

Adds or overwrites only the specified tags for the specified Amazon EC2 resource or
resources. When you specify an existing tag key, the value is overwritten with the new
value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional
value. Tag keys must be unique per resource. For more information about tags, see Tag your
Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide. For more information
about creating IAM policies that control users' access to resources based on tags, see
Supported resource-level permissions for Amazon EC2 API actions in the Amazon Elastic
Compute Cloud User Guide.

# Arguments
- `resource_id`: The IDs of the resources, separated by spaces. Constraints: Up to 1000
  resource IDs. We recommend breaking up this request into smaller batches.
- `tag`: The tags. The value parameter is required, but if you don't want the tag to have a
  value, specify the parameter with no value, and we set the value to an empty string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_tags(ResourceId, Tag; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateTags",
        Dict{String,Any}("ResourceId" => ResourceId, "Tag" => Tag);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tags(
    ResourceId,
    Tag,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTags",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ResourceId" => ResourceId, "Tag" => Tag), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_traffic_mirror_filter()
    create_traffic_mirror_filter(params::Dict{String,<:Any})

Creates a Traffic Mirror filter. A Traffic Mirror filter is a set of rules that defines the
traffic to mirror. By default, no traffic is mirrored. To mirror traffic, use
CreateTrafficMirrorFilterRule to add Traffic Mirror rules to the filter. The rules you add
define what traffic gets mirrored. You can also use
ModifyTrafficMirrorFilterNetworkServices to mirror supported network services.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"Description"`: The description of the Traffic Mirror filter.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to assign to a Traffic Mirror filter.
"""
function create_traffic_mirror_filter(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateTrafficMirrorFilter",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_traffic_mirror_filter(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTrafficMirrorFilter",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_traffic_mirror_filter_rule(destination_cidr_block, rule_action, rule_number, source_cidr_block, traffic_direction, traffic_mirror_filter_id)
    create_traffic_mirror_filter_rule(destination_cidr_block, rule_action, rule_number, source_cidr_block, traffic_direction, traffic_mirror_filter_id, params::Dict{String,<:Any})

Creates a Traffic Mirror filter rule. A Traffic Mirror rule defines the Traffic Mirror
source traffic to mirror. You need the Traffic Mirror filter ID when you create the rule.

# Arguments
- `destination_cidr_block`: The destination CIDR block to assign to the Traffic Mirror rule.
- `rule_action`: The action to take on the filtered traffic.
- `rule_number`: The number of the Traffic Mirror rule. This number must be unique for each
  Traffic Mirror rule in a given direction. The rules are processed in ascending order by
  rule number.
- `source_cidr_block`: The source CIDR block to assign to the Traffic Mirror rule.
- `traffic_direction`: The type of traffic.
- `traffic_mirror_filter_id`: The ID of the filter that this rule is associated with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"Description"`: The description of the Traffic Mirror rule.
- `"DestinationPortRange"`: The destination port range.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Protocol"`: The protocol, for example UDP, to assign to the Traffic Mirror rule. For
  information about the protocol value, see Protocol Numbers on the Internet Assigned Numbers
  Authority (IANA) website.
- `"SourcePortRange"`: The source port range.
- `"TagSpecification"`: Traffic Mirroring tags specifications.
"""
function create_traffic_mirror_filter_rule(
    DestinationCidrBlock,
    RuleAction,
    RuleNumber,
    SourceCidrBlock,
    TrafficDirection,
    TrafficMirrorFilterId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTrafficMirrorFilterRule",
        Dict{String,Any}(
            "DestinationCidrBlock" => DestinationCidrBlock,
            "RuleAction" => RuleAction,
            "RuleNumber" => RuleNumber,
            "SourceCidrBlock" => SourceCidrBlock,
            "TrafficDirection" => TrafficDirection,
            "TrafficMirrorFilterId" => TrafficMirrorFilterId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_traffic_mirror_filter_rule(
    DestinationCidrBlock,
    RuleAction,
    RuleNumber,
    SourceCidrBlock,
    TrafficDirection,
    TrafficMirrorFilterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTrafficMirrorFilterRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "RuleAction" => RuleAction,
                    "RuleNumber" => RuleNumber,
                    "SourceCidrBlock" => SourceCidrBlock,
                    "TrafficDirection" => TrafficDirection,
                    "TrafficMirrorFilterId" => TrafficMirrorFilterId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_traffic_mirror_session(network_interface_id, session_number, traffic_mirror_filter_id, traffic_mirror_target_id)
    create_traffic_mirror_session(network_interface_id, session_number, traffic_mirror_filter_id, traffic_mirror_target_id, params::Dict{String,<:Any})

Creates a Traffic Mirror session. A Traffic Mirror session actively copies packets from a
Traffic Mirror source to a Traffic Mirror target. Create a filter, and then assign it to
the session to define a subset of the traffic to mirror, for example all TCP traffic. The
Traffic Mirror source and the Traffic Mirror target (monitoring appliances) can be in the
same VPC, or in a different VPC connected via VPC peering or a transit gateway.  By
default, no traffic is mirrored. Use CreateTrafficMirrorFilter to create filter rules that
specify the traffic to mirror.

# Arguments
- `network_interface_id`: The ID of the source network interface.
- `session_number`: The session number determines the order in which sessions are evaluated
  when an interface is used by multiple sessions. The first session with a matching filter is
  the one that mirrors the packets. Valid values are 1-32766.
- `traffic_mirror_filter_id`: The ID of the Traffic Mirror filter.
- `traffic_mirror_target_id`: The ID of the Traffic Mirror target.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"Description"`: The description of the Traffic Mirror session.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PacketLength"`: The number of bytes in each packet to mirror. These are bytes after the
  VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To
  mirror a subset of the packet, set this to the length (in bytes) that you want to mirror.
  For example, if you set this value to 100, then the first 100 bytes that meet the filter
  criteria are copied to the target. If you do not want to mirror the entire packet, use the
  PacketLength parameter to specify the number of bytes in each packet to mirror. For
  sessions with Network Load Balancer (NLB) Traffic Mirror targets the default PacketLength
  will be set to 8500. Valid values are 1-8500. Setting a PacketLength greater than 8500 will
  result in an error response.
- `"TagSpecification"`: The tags to assign to a Traffic Mirror session.
- `"VirtualNetworkId"`: The VXLAN ID for the Traffic Mirror session. For more information
  about the VXLAN protocol, see RFC 7348. If you do not specify a VirtualNetworkId, an
  account-wide unique ID is chosen at random.
"""
function create_traffic_mirror_session(
    NetworkInterfaceId,
    SessionNumber,
    TrafficMirrorFilterId,
    TrafficMirrorTargetId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTrafficMirrorSession",
        Dict{String,Any}(
            "NetworkInterfaceId" => NetworkInterfaceId,
            "SessionNumber" => SessionNumber,
            "TrafficMirrorFilterId" => TrafficMirrorFilterId,
            "TrafficMirrorTargetId" => TrafficMirrorTargetId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_traffic_mirror_session(
    NetworkInterfaceId,
    SessionNumber,
    TrafficMirrorFilterId,
    TrafficMirrorTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTrafficMirrorSession",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NetworkInterfaceId" => NetworkInterfaceId,
                    "SessionNumber" => SessionNumber,
                    "TrafficMirrorFilterId" => TrafficMirrorFilterId,
                    "TrafficMirrorTargetId" => TrafficMirrorTargetId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_traffic_mirror_target()
    create_traffic_mirror_target(params::Dict{String,<:Any})

Creates a target for your Traffic Mirror session. A Traffic Mirror target is the
destination for mirrored traffic. The Traffic Mirror source and the Traffic Mirror target
(monitoring appliances) can be in the same VPC, or in different VPCs connected via VPC
peering or a transit gateway. A Traffic Mirror target can be a network interface, a Network
Load Balancer, or a Gateway Load Balancer endpoint. To use the target in a Traffic Mirror
session, use CreateTrafficMirrorSession.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"Description"`: The description of the Traffic Mirror target.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GatewayLoadBalancerEndpointId"`: The ID of the Gateway Load Balancer endpoint.
- `"NetworkInterfaceId"`: The network interface ID that is associated with the target.
- `"NetworkLoadBalancerArn"`: The Amazon Resource Name (ARN) of the Network Load Balancer
  that is associated with the target.
- `"TagSpecification"`: The tags to assign to the Traffic Mirror target.
"""
function create_traffic_mirror_target(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateTrafficMirrorTarget",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_traffic_mirror_target(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTrafficMirrorTarget",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway()
    create_transit_gateway(params::Dict{String,<:Any})

Creates a transit gateway. You can use a transit gateway to interconnect your virtual
private clouds (VPC) and on-premises networks. After the transit gateway enters the
available state, you can attach your VPCs and VPN connections to the transit gateway. To
attach your VPCs, use CreateTransitGatewayVpcAttachment. To attach a VPN connection, use
CreateCustomerGateway to create a customer gateway and specify the ID of the customer
gateway and the ID of the transit gateway in a call to CreateVpnConnection. When you create
a transit gateway, we create a default transit gateway route table and use it as the
default association route table and the default propagation route table. You can use
CreateTransitGatewayRouteTable to create additional transit gateway route tables. If you
disable automatic route propagation, we do not create a default transit gateway route
table. You can use EnableTransitGatewayRouteTablePropagation to propagate routes from a
resource attachment to a transit gateway route table. If you disable automatic
associations, you can use AssociateTransitGatewayRouteTable to associate a resource
attachment with a transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the transit gateway.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Options"`: The transit gateway options.
- `"TagSpecification"`: The tags to apply to the transit gateway.
"""
function create_transit_gateway(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateTransitGateway"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_transit_gateway(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTransitGateway",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_connect(options, transport_transit_gateway_attachment_id)
    create_transit_gateway_connect(options, transport_transit_gateway_attachment_id, params::Dict{String,<:Any})

Creates a Connect attachment from a specified transit gateway attachment. A Connect
attachment is a GRE-based tunnel attachment that you can use to establish a connection
between a transit gateway and an appliance. A Connect attachment uses an existing VPC or
Amazon Web Services Direct Connect attachment as the underlying transport mechanism.

# Arguments
- `options`: The Connect attachment options.
- `transport_transit_gateway_attachment_id`: The ID of the transit gateway attachment. You
  can specify a VPC attachment or Amazon Web Services Direct Connect attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags to apply to the Connect attachment.
"""
function create_transit_gateway_connect(
    Options,
    TransportTransitGatewayAttachmentId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayConnect",
        Dict{String,Any}(
            "Options" => Options,
            "TransportTransitGatewayAttachmentId" => TransportTransitGatewayAttachmentId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_connect(
    Options,
    TransportTransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayConnect",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Options" => Options,
                    "TransportTransitGatewayAttachmentId" =>
                        TransportTransitGatewayAttachmentId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_connect_peer(peer_address, transit_gateway_attachment_id, item)
    create_transit_gateway_connect_peer(peer_address, transit_gateway_attachment_id, item, params::Dict{String,<:Any})

Creates a Connect peer for a specified transit gateway Connect attachment between a transit
gateway and an appliance. The peer address and transit gateway address must be the same IP
address family (IPv4 or IPv6). For more information, see Connect peers in the Amazon Web
Services Transit Gateways Guide.

# Arguments
- `peer_address`: The peer IP address (GRE outer IP address) on the appliance side of the
  Connect peer.
- `transit_gateway_attachment_id`: The ID of the Connect attachment.
- `item`: The range of inside IP addresses that are used for BGP peering. You must specify
  a size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address from the range
  must be configured on the appliance as the BGP IP address. You can also optionally specify
  a size /125 IPv6 CIDR block from the fd00::/8 range.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BgpOptions"`: The BGP options for the Connect peer.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"InsideCidrBlocks"`: The range of inside IP addresses that are used for BGP peering. You
  must specify a size /29 IPv4 CIDR block from the 169.254.0.0/16 range. The first address
  from the range must be configured on the appliance as the BGP IP address. You can also
  optionally specify a size /125 IPv6 CIDR block from the fd00::/8 range.
- `"TagSpecification"`: The tags to apply to the Connect peer.
- `"TransitGatewayAddress"`: The peer IP address (GRE outer IP address) on the transit
  gateway side of the Connect peer, which must be specified from a transit gateway CIDR
  block. If not specified, Amazon automatically assigns the first available IP address from
  the transit gateway CIDR block.
"""
function create_transit_gateway_connect_peer(
    PeerAddress,
    TransitGatewayAttachmentId,
    item;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayConnectPeer",
        Dict{String,Any}(
            "PeerAddress" => PeerAddress,
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "item" => item,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_connect_peer(
    PeerAddress,
    TransitGatewayAttachmentId,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayConnectPeer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PeerAddress" => PeerAddress,
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "item" => item,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_multicast_domain(transit_gateway_id)
    create_transit_gateway_multicast_domain(transit_gateway_id, params::Dict{String,<:Any})

Creates a multicast domain using the specified transit gateway. The transit gateway must be
in the available state before you create a domain. Use DescribeTransitGateways to see the
state of transit gateway.

# Arguments
- `transit_gateway_id`: The ID of the transit gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Options"`: The options for the transit gateway multicast domain.
- `"TagSpecification"`: The tags for the transit gateway multicast domain.
"""
function create_transit_gateway_multicast_domain(
    TransitGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTransitGatewayMulticastDomain",
        Dict{String,Any}("TransitGatewayId" => TransitGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_multicast_domain(
    TransitGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayMulticastDomain",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TransitGatewayId" => TransitGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_peering_attachment(peer_account_id, peer_region, peer_transit_gateway_id, transit_gateway_id)
    create_transit_gateway_peering_attachment(peer_account_id, peer_region, peer_transit_gateway_id, transit_gateway_id, params::Dict{String,<:Any})

Requests a transit gateway peering attachment between the specified transit gateway
(requester) and a peer transit gateway (accepter). The peer transit gateway can be in your
account or a different Amazon Web Services account. After you create the peering
attachment, the owner of the accepter transit gateway must accept the attachment request.

# Arguments
- `peer_account_id`: The ID of the Amazon Web Services account that owns the peer transit
  gateway.
- `peer_region`: The Region where the peer transit gateway is located.
- `peer_transit_gateway_id`: The ID of the peer transit gateway with which to create the
  peering attachment.
- `transit_gateway_id`: The ID of the transit gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Options"`: Requests a transit gateway peering attachment.
- `"TagSpecification"`: The tags to apply to the transit gateway peering attachment.
"""
function create_transit_gateway_peering_attachment(
    PeerAccountId,
    PeerRegion,
    PeerTransitGatewayId,
    TransitGatewayId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayPeeringAttachment",
        Dict{String,Any}(
            "PeerAccountId" => PeerAccountId,
            "PeerRegion" => PeerRegion,
            "PeerTransitGatewayId" => PeerTransitGatewayId,
            "TransitGatewayId" => TransitGatewayId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_peering_attachment(
    PeerAccountId,
    PeerRegion,
    PeerTransitGatewayId,
    TransitGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayPeeringAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PeerAccountId" => PeerAccountId,
                    "PeerRegion" => PeerRegion,
                    "PeerTransitGatewayId" => PeerTransitGatewayId,
                    "TransitGatewayId" => TransitGatewayId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_policy_table(transit_gateway_id)
    create_transit_gateway_policy_table(transit_gateway_id, params::Dict{String,<:Any})

Creates a transit gateway policy table.

# Arguments
- `transit_gateway_id`: The ID of the transit gateway used for the policy table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecifications"`: The tags specification for the transit gateway policy table
  created during the request.
"""
function create_transit_gateway_policy_table(
    TransitGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTransitGatewayPolicyTable",
        Dict{String,Any}("TransitGatewayId" => TransitGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_policy_table(
    TransitGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayPolicyTable",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TransitGatewayId" => TransitGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_prefix_list_reference(prefix_list_id, transit_gateway_route_table_id)
    create_transit_gateway_prefix_list_reference(prefix_list_id, transit_gateway_route_table_id, params::Dict{String,<:Any})

Creates a reference (route) to a prefix list in a specified transit gateway route table.

# Arguments
- `prefix_list_id`: The ID of the prefix list that is used for destination matches.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Blackhole"`: Indicates whether to drop traffic that matches this route.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TransitGatewayAttachmentId"`: The ID of the attachment to which traffic is routed.
"""
function create_transit_gateway_prefix_list_reference(
    PrefixListId,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayPrefixListReference",
        Dict{String,Any}(
            "PrefixListId" => PrefixListId,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_prefix_list_reference(
    PrefixListId,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayPrefixListReference",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PrefixListId" => PrefixListId,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_route(destination_cidr_block, transit_gateway_route_table_id)
    create_transit_gateway_route(destination_cidr_block, transit_gateway_route_table_id, params::Dict{String,<:Any})

Creates a static route for the specified transit gateway route table.

# Arguments
- `destination_cidr_block`: The CIDR range used for destination matches. Routing decisions
  are based on the most specific match.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Blackhole"`: Indicates whether to drop traffic that matches this route.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TransitGatewayAttachmentId"`: The ID of the attachment.
"""
function create_transit_gateway_route(
    DestinationCidrBlock,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayRoute",
        Dict{String,Any}(
            "DestinationCidrBlock" => DestinationCidrBlock,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_route(
    DestinationCidrBlock,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_route_table(transit_gateway_id)
    create_transit_gateway_route_table(transit_gateway_id, params::Dict{String,<:Any})

Creates a route table for the specified transit gateway.

# Arguments
- `transit_gateway_id`: The ID of the transit gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecifications"`: The tags to apply to the transit gateway route table.
"""
function create_transit_gateway_route_table(
    TransitGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTransitGatewayRouteTable",
        Dict{String,Any}("TransitGatewayId" => TransitGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_route_table(
    TransitGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TransitGatewayId" => TransitGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_route_table_announcement(peering_attachment_id, transit_gateway_route_table_id)
    create_transit_gateway_route_table_announcement(peering_attachment_id, transit_gateway_route_table_id, params::Dict{String,<:Any})

Advertises a new transit gateway route table.

# Arguments
- `peering_attachment_id`: The ID of the peering attachment.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TagSpecification"`: The tags specifications applied to the transit gateway route table
  announcement.
"""
function create_transit_gateway_route_table_announcement(
    PeeringAttachmentId,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayRouteTableAnnouncement",
        Dict{String,Any}(
            "PeeringAttachmentId" => PeeringAttachmentId,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_route_table_announcement(
    PeeringAttachmentId,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayRouteTableAnnouncement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PeeringAttachmentId" => PeeringAttachmentId,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_vpc_attachment(transit_gateway_id, vpc_id, item)
    create_transit_gateway_vpc_attachment(transit_gateway_id, vpc_id, item, params::Dict{String,<:Any})

Attaches the specified VPC to the specified transit gateway. If you attach a VPC with a
CIDR range that overlaps the CIDR range of a VPC that is already attached, the new VPC CIDR
range is not propagated to the default propagation route table. To send VPC traffic to an
attached transit gateway, add a route to the VPC route table using CreateRoute.

# Arguments
- `transit_gateway_id`: The ID of the transit gateway.
- `vpc_id`: The ID of the VPC.
- `item`: The IDs of one or more subnets. You can specify only one subnet per Availability
  Zone. You must specify at least one subnet, but we recommend that you specify two subnets
  for better availability. The transit gateway uses one IP address from each specified subnet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Options"`: The VPC attachment options.
- `"SubnetIds"`: The IDs of one or more subnets. You can specify only one subnet per
  Availability Zone. You must specify at least one subnet, but we recommend that you specify
  two subnets for better availability. The transit gateway uses one IP address from each
  specified subnet.
- `"TagSpecifications"`: The tags to apply to the VPC attachment.
"""
function create_transit_gateway_vpc_attachment(
    TransitGatewayId, VpcId, item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateTransitGatewayVpcAttachment",
        Dict{String,Any}(
            "TransitGatewayId" => TransitGatewayId, "VpcId" => VpcId, "item" => item
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_vpc_attachment(
    TransitGatewayId,
    VpcId,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateTransitGatewayVpcAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayId" => TransitGatewayId, "VpcId" => VpcId, "item" => item
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_verified_access_endpoint(application_domain, attachment_type, domain_certificate_arn, endpoint_domain_prefix, endpoint_type, verified_access_group_id)
    create_verified_access_endpoint(application_domain, attachment_type, domain_certificate_arn, endpoint_domain_prefix, endpoint_type, verified_access_group_id, params::Dict{String,<:Any})

An Amazon Web Services Verified Access endpoint is where you define your application along
with an optional endpoint-level access policy.

# Arguments
- `application_domain`: The DNS name for users to reach your application.
- `attachment_type`: The type of attachment.
- `domain_certificate_arn`: The ARN of the public TLS/SSL certificate in Amazon Web
  Services Certificate Manager to associate with the endpoint. The CN in the certificate must
  match the DNS name your end users will use to reach your application.
- `endpoint_domain_prefix`: A custom identifier that is prepended to the DNS name that is
  generated for the endpoint.
- `endpoint_type`: The type of Verified Access endpoint to create.
- `verified_access_group_id`: The ID of the Verified Access group to associate the endpoint
  with.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the Verified Access endpoint.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LoadBalancerOptions"`: The load balancer details. This parameter is required if the
  endpoint type is load-balancer.
- `"NetworkInterfaceOptions"`: The network interface details. This parameter is required if
  the endpoint type is network-interface.
- `"PolicyDocument"`: The Verified Access policy document.
- `"SecurityGroupId"`: The IDs of the security groups to associate with the Verified Access
  endpoint. Required if AttachmentType is set to vpc.
- `"SseSpecification"`: The options for server side encryption.
- `"TagSpecification"`: The tags to assign to the Verified Access endpoint.
"""
function create_verified_access_endpoint(
    ApplicationDomain,
    AttachmentType,
    DomainCertificateArn,
    EndpointDomainPrefix,
    EndpointType,
    VerifiedAccessGroupId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVerifiedAccessEndpoint",
        Dict{String,Any}(
            "ApplicationDomain" => ApplicationDomain,
            "AttachmentType" => AttachmentType,
            "DomainCertificateArn" => DomainCertificateArn,
            "EndpointDomainPrefix" => EndpointDomainPrefix,
            "EndpointType" => EndpointType,
            "VerifiedAccessGroupId" => VerifiedAccessGroupId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_verified_access_endpoint(
    ApplicationDomain,
    AttachmentType,
    DomainCertificateArn,
    EndpointDomainPrefix,
    EndpointType,
    VerifiedAccessGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVerifiedAccessEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplicationDomain" => ApplicationDomain,
                    "AttachmentType" => AttachmentType,
                    "DomainCertificateArn" => DomainCertificateArn,
                    "EndpointDomainPrefix" => EndpointDomainPrefix,
                    "EndpointType" => EndpointType,
                    "VerifiedAccessGroupId" => VerifiedAccessGroupId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_verified_access_group(verified_access_instance_id)
    create_verified_access_group(verified_access_instance_id, params::Dict{String,<:Any})

An Amazon Web Services Verified Access group is a collection of Amazon Web Services
Verified Access endpoints who's associated applications have similar security requirements.
Each instance within a Verified Access group shares an Verified Access policy. For example,
you can group all Verified Access instances associated with \"sales\" applications together
and use one common Verified Access policy.

# Arguments
- `verified_access_instance_id`: The ID of the Verified Access instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the Verified Access group.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"PolicyDocument"`: The Verified Access policy document.
- `"SseSpecification"`: The options for server side encryption.
- `"TagSpecification"`: The tags to assign to the Verified Access group.
"""
function create_verified_access_group(
    VerifiedAccessInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVerifiedAccessGroup",
        Dict{String,Any}(
            "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_verified_access_group(
    VerifiedAccessInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVerifiedAccessGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_verified_access_instance()
    create_verified_access_instance(params::Dict{String,<:Any})

An Amazon Web Services Verified Access instance is a regional entity that evaluates
application requests and grants access only when your security requirements are met.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the Verified Access instance.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"FIPSEnabled"`: Enable or disable support for Federal Information Processing Standards
  (FIPS) on the instance.
- `"TagSpecification"`: The tags to assign to the Verified Access instance.
"""
function create_verified_access_instance(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVerifiedAccessInstance",
        Dict{String,Any}("ClientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_verified_access_instance(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVerifiedAccessInstance",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ClientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_verified_access_trust_provider(policy_reference_name, trust_provider_type)
    create_verified_access_trust_provider(policy_reference_name, trust_provider_type, params::Dict{String,<:Any})

A trust provider is a third-party entity that creates, maintains, and manages identity
information for users and devices. When an application request is made, the identity
information sent by the trust provider is evaluated by Verified Access before allowing or
denying the application request.

# Arguments
- `policy_reference_name`: The identifier to be used when working with policy rules.
- `trust_provider_type`: The type of trust provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"Description"`: A description for the Verified Access trust provider.
- `"DeviceOptions"`: The options for a device-based trust provider. This parameter is
  required when the provider type is device.
- `"DeviceTrustProviderType"`: The type of device-based trust provider. This parameter is
  required when the provider type is device.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"OidcOptions"`: The options for a OpenID Connect-compatible user-identity trust
  provider. This parameter is required when the provider type is user.
- `"SseSpecification"`: The options for server side encryption.
- `"TagSpecification"`: The tags to assign to the Verified Access trust provider.
- `"UserTrustProviderType"`: The type of user-based trust provider. This parameter is
  required when the provider type is user.
"""
function create_verified_access_trust_provider(
    PolicyReferenceName,
    TrustProviderType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVerifiedAccessTrustProvider",
        Dict{String,Any}(
            "PolicyReferenceName" => PolicyReferenceName,
            "TrustProviderType" => TrustProviderType,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_verified_access_trust_provider(
    PolicyReferenceName,
    TrustProviderType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVerifiedAccessTrustProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyReferenceName" => PolicyReferenceName,
                    "TrustProviderType" => TrustProviderType,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_volume(availability_zone)
    create_volume(availability_zone, params::Dict{String,<:Any})

Creates an EBS volume that can be attached to an instance in the same Availability Zone.
You can create a new empty volume or restore a volume from an EBS snapshot. Any Amazon Web
Services Marketplace product codes from the snapshot are propagated to the volume. You can
create encrypted volumes. Encrypted volumes must be attached to instances that support
Amazon EBS encryption. Volumes that are created from encrypted snapshots are also
automatically encrypted. For more information, see Amazon EBS encryption in the Amazon EBS
User Guide. You can tag your volumes during creation. For more information, see Tag your
Amazon EC2 resources in the Amazon EC2 User Guide. For more information, see Create an
Amazon EBS volume in the Amazon EBS User Guide.

# Arguments
- `availability_zone`: The ID of the Availability Zone in which to create the volume. For
  example, us-east-1a.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensure Idempotency.
- `"Iops"`: The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes,
  this represents the number of IOPS that are provisioned for the volume. For gp2 volumes,
  this represents the baseline performance of the volume and the rate at which the volume
  accumulates I/O credits for bursting. The following are the supported values for each
  volume type:    gp3: 3,000 - 16,000 IOPS    io1: 100 - 64,000 IOPS    io2: 100 - 256,000
  IOPS   For io2 volumes, you can achieve up to 256,000 IOPS on instances built on the Nitro
  System. On other instances, you can achieve performance up to 32,000 IOPS. This parameter
  is required for io1 and io2 volumes. The default for gp3 volumes is 3,000 IOPS. This
  parameter is not supported for gp2, st1, sc1, or standard volumes.
- `"KmsKeyId"`: The identifier of the KMS key to use for Amazon EBS encryption. If this
  parameter is not specified, your KMS key for Amazon EBS is used. If KmsKeyId is specified,
  the encrypted state must be true. You can specify the KMS key using any of the following:
  Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.   Key alias. For example,
  alias/ExampleAlias.   Key ARN. For example,
  arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.   Alias ARN.
  For example, arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.   Amazon Web Services
  authenticates the KMS key asynchronously. Therefore, if you specify an ID, alias, or ARN
  that is not valid, the action can appear to complete, but eventually fails.
- `"MultiAttachEnabled"`: Indicates whether to enable Amazon EBS Multi-Attach. If you
  enable Multi-Attach, you can attach the volume to up to 16 Instances built on the Nitro
  System in the same Availability Zone. This parameter is supported with io1 and io2 volumes
  only. For more information, see  Amazon EBS Multi-Attach in the Amazon EBS User Guide.
- `"OutpostArn"`: The Amazon Resource Name (ARN) of the Outpost.
- `"Size"`: The size of the volume, in GiBs. You must specify either a snapshot ID or a
  volume size. If you specify a snapshot, the default is the snapshot size. You can specify a
  volume size that is equal to or larger than the snapshot size. The following are the
  supported volumes sizes for each volume type:    gp2 and gp3: 1 - 16,384 GiB    io1: 4 -
  16,384 GiB    io2: 4 - 65,536 GiB    st1 and sc1: 125 - 16,384 GiB    standard: 1 - 1024
  GiB
- `"SnapshotId"`: The snapshot from which to create the volume. You must specify either a
  snapshot ID or a volume size.
- `"TagSpecification"`: The tags to apply to the volume during creation.
- `"Throughput"`: The throughput to provision for a volume, with a maximum of 1,000 MiB/s.
  This parameter is valid only for gp3 volumes. Valid Range: Minimum value of 125. Maximum
  value of 1000.
- `"VolumeType"`: The volume type. This parameter can be one of the following values:
  General Purpose SSD: gp2 | gp3    Provisioned IOPS SSD: io1 | io2    Throughput Optimized
  HDD: st1    Cold HDD: sc1    Magnetic: standard     Throughput Optimized HDD (st1) and Cold
  HDD (sc1) volumes can't be used as boot volumes.  For more information, see Amazon EBS
  volume types in the Amazon EBS User Guide. Default: gp2
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"encrypted"`: Indicates whether the volume should be encrypted. The effect of setting
  the encryption state to true depends on the volume origin (new or from a snapshot),
  starting encryption state, ownership, and whether encryption by default is enabled. For
  more information, see Encryption by default in the Amazon EBS User Guide. Encrypted Amazon
  EBS volumes must be attached to instances that support Amazon EBS encryption. For more
  information, see Supported instance types.
"""
function create_volume(AvailabilityZone; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateVolume",
        Dict{String,Any}(
            "AvailabilityZone" => AvailabilityZone, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_volume(
    AvailabilityZone,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVolume",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AvailabilityZone" => AvailabilityZone, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc()
    create_vpc(params::Dict{String,<:Any})

Creates a VPC with the specified CIDR blocks. For more information, see IP addressing for
your VPCs and subnets in the Amazon VPC User Guide. You can optionally request an IPv6 CIDR
block for the VPC. You can request an Amazon-provided IPv6 CIDR block from Amazon's pool of
IPv6 addresses or an IPv6 CIDR block from an IPv6 address pool that you provisioned through
bring your own IP addresses (BYOIP). By default, each instance that you launch in the VPC
has the default DHCP options, which include only a default DNS server that we provide
(AmazonProvidedDNS). For more information, see DHCP option sets in the Amazon VPC User
Guide. You can specify the instance tenancy value for the VPC when you create it. You can't
change this value for the VPC after you create it. For more information, see Dedicated
Instances in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CidrBlock"`: The IPv4 network range for the VPC, in CIDR notation. For example,
  10.0.0.0/16. We modify the specified CIDR block to its canonical form; for example, if you
  specify 100.68.0.18/18, we modify it to 100.68.0.0/18.
- `"Ipv4IpamPoolId"`: The ID of an IPv4 IPAM pool you want to use for allocating this VPC's
  CIDR. For more information, see What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv4NetmaskLength"`: The netmask length of the IPv4 CIDR you want to allocate to this
  VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see
  What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv6CidrBlock"`: The IPv6 CIDR block from the IPv6 address pool. You must also specify
  Ipv6Pool in the request. To let Amazon choose the IPv6 CIDR block for you, omit this
  parameter.
- `"Ipv6CidrBlockNetworkBorderGroup"`: The name of the location from which we advertise the
  IPV6 CIDR block. Use this parameter to limit the address to this location.  You must set
  AmazonProvidedIpv6CidrBlock to true to use this parameter.
- `"Ipv6IpamPoolId"`: The ID of an IPv6 IPAM pool which will be used to allocate this VPC
  an IPv6 CIDR. IPAM is a VPC feature that you can use to automate your IP address management
  workflows including assigning, tracking, troubleshooting, and auditing IP addresses across
  Amazon Web Services Regions and accounts throughout your Amazon Web Services Organization.
  For more information, see What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv6NetmaskLength"`: The netmask length of the IPv6 CIDR you want to allocate to this
  VPC from an Amazon VPC IP Address Manager (IPAM) pool. For more information about IPAM, see
  What is IPAM? in the Amazon VPC IPAM User Guide.
- `"Ipv6Pool"`: The ID of an IPv6 address pool from which to allocate the IPv6 CIDR block.
- `"TagSpecification"`: The tags to assign to the VPC.
- `"amazonProvidedIpv6CidrBlock"`: Requests an Amazon-provided IPv6 CIDR block with a /56
  prefix length for the VPC. You cannot specify the range of IP addresses, or the size of the
  CIDR block.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"instanceTenancy"`: The tenancy options for instances launched into the VPC. For
  default, instances are launched with shared tenancy by default. You can launch instances
  with any tenancy into a shared tenancy VPC. For dedicated, instances are launched as
  dedicated tenancy instances by default. You can only launch instances with a tenancy of
  dedicated or host into a dedicated tenancy VPC.   Important: The host value cannot be used
  with this parameter. Use the default or dedicated values only. Default: default
"""
function create_vpc(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("CreateVpc"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function create_vpc(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2("CreateVpc", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end

"""
    create_vpc_endpoint(service_name, vpc_id)
    create_vpc_endpoint(service_name, vpc_id, params::Dict{String,<:Any})

Creates a VPC endpoint. A VPC endpoint provides a private connection between the specified
VPC and the specified endpoint service. You can use an endpoint service provided by Amazon
Web Services, an Amazon Web Services Marketplace Partner, or another Amazon Web Services
account. For more information, see the Amazon Web Services PrivateLink User Guide.

# Arguments
- `service_name`: The name of the endpoint service.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"DnsOptions"`: The DNS options for the endpoint.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"IpAddressType"`: The IP address type for the endpoint.
- `"PolicyDocument"`: (Interface and gateway endpoints) A policy to attach to the endpoint
  that controls access to the service. The policy must be in valid JSON format. If this
  parameter is not specified, we attach a default policy that allows full access to the
  service.
- `"PrivateDnsEnabled"`: (Interface endpoint) Indicates whether to associate a private
  hosted zone with the specified VPC. The private hosted zone contains a record set for the
  default public DNS name for the service for the Region (for example,
  kinesis.us-east-1.amazonaws.com), which resolves to the private IP addresses of the
  endpoint network interfaces in the VPC. This enables you to make requests to the default
  public DNS name for the service instead of the public DNS names that are automatically
  generated by the VPC endpoint service. To use a private hosted zone, you must set the
  following VPC attributes to true: enableDnsHostnames and enableDnsSupport. Use
  ModifyVpcAttribute to set the VPC attributes. Default: true
- `"RouteTableId"`: (Gateway endpoint) The route table IDs.
- `"SecurityGroupId"`: (Interface endpoint) The IDs of the security groups to associate
  with the endpoint network interfaces. If this parameter is not specified, we use the
  default security group for the VPC.
- `"SubnetConfiguration"`: The subnet configurations for the endpoint.
- `"SubnetId"`: (Interface and Gateway Load Balancer endpoints) The IDs of the subnets in
  which to create endpoint network interfaces. For a Gateway Load Balancer endpoint, you can
  specify only one subnet.
- `"TagSpecification"`: The tags to associate with the endpoint.
- `"VpcEndpointType"`: The type of endpoint. Default: Gateway
"""
function create_vpc_endpoint(
    ServiceName, VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcEndpoint",
        Dict{String,Any}("ServiceName" => ServiceName, "VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_endpoint(
    ServiceName,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVpcEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ServiceName" => ServiceName, "VpcId" => VpcId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_endpoint_connection_notification(connection_notification_arn, item)
    create_vpc_endpoint_connection_notification(connection_notification_arn, item, params::Dict{String,<:Any})

Creates a connection notification for a specified VPC endpoint or VPC endpoint service. A
connection notification notifies you of specific endpoint events. You must create an SNS
topic to receive notifications. For more information, see Creating an Amazon SNS topic in
the Amazon SNS Developer Guide. You can create a connection notification for interface
endpoints only.

# Arguments
- `connection_notification_arn`: The ARN of the SNS topic for the notifications.
- `item`: The endpoint events for which to receive notifications. Valid values are Accept,
  Connect, Delete, and Reject.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"ConnectionEvents"`: The endpoint events for which to receive notifications. Valid
  values are Accept, Connect, Delete, and Reject.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ServiceId"`: The ID of the endpoint service.
- `"VpcEndpointId"`: The ID of the endpoint.
"""
function create_vpc_endpoint_connection_notification(
    ConnectionNotificationArn, item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcEndpointConnectionNotification",
        Dict{String,Any}(
            "ConnectionNotificationArn" => ConnectionNotificationArn, "item" => item
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_endpoint_connection_notification(
    ConnectionNotificationArn,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVpcEndpointConnectionNotification",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectionNotificationArn" => ConnectionNotificationArn, "item" => item
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_endpoint_service_configuration()
    create_vpc_endpoint_service_configuration(params::Dict{String,<:Any})

Creates a VPC endpoint service to which service consumers (Amazon Web Services accounts,
users, and IAM roles) can connect. Before you create an endpoint service, you must create
one of the following for your service:   A Network Load Balancer. Service consumers connect
to your service using an interface endpoint.   A Gateway Load Balancer. Service consumers
connect to your service using a Gateway Load Balancer endpoint.   If you set the private
DNS name, you must prove that you own the private DNS domain name. For more information,
see the Amazon Web Services PrivateLink Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AcceptanceRequired"`: Indicates whether requests from service consumers to create an
  endpoint to your service must be accepted manually.
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see How to ensure idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GatewayLoadBalancerArn"`: The Amazon Resource Names (ARNs) of the Gateway Load
  Balancers.
- `"NetworkLoadBalancerArn"`: The Amazon Resource Names (ARNs) of the Network Load
  Balancers.
- `"PrivateDnsName"`: (Interface endpoint configuration) The private DNS name to assign to
  the VPC endpoint service.
- `"SupportedIpAddressType"`: The supported IP address types. The possible values are ipv4
  and ipv6.
- `"TagSpecification"`: The tags to associate with the service.
"""
function create_vpc_endpoint_service_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcEndpointServiceConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_endpoint_service_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcEndpointServiceConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_peering_connection(vpc_id)
    create_vpc_peering_connection(vpc_id, params::Dict{String,<:Any})

Requests a VPC peering connection between two VPCs: a requester VPC that you own and an
accepter VPC with which to create the connection. The accepter VPC can belong to another
Amazon Web Services account and can be in a different Region to the requester VPC. The
requester VPC and accepter VPC cannot have overlapping CIDR blocks.  Limitations and rules
apply to a VPC peering connection. For more information, see the VPC peering limitations in
the VPC Peering Guide.  The owner of the accepter VPC must accept the peering request to
activate the peering connection. The VPC peering connection request expires after 7 days,
after which it cannot be accepted or rejected. If you create a VPC peering connection
request between VPCs with overlapping CIDR blocks, the VPC peering connection has a status
of failed.

# Arguments
- `vpc_id`: The ID of the requester VPC. You must specify this parameter in the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"PeerRegion"`: The Region code for the accepter VPC, if the accepter VPC is located in a
  Region other than the Region in which you make the request. Default: The Region in which
  you make the request.
- `"TagSpecification"`: The tags to assign to the peering connection.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"peerOwnerId"`: The Amazon Web Services account ID of the owner of the accepter VPC.
  Default: Your Amazon Web Services account ID
- `"peerVpcId"`: The ID of the VPC with which you are creating the VPC peering connection.
  You must specify this parameter in the request.
"""
function create_vpc_peering_connection(
    vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcPeeringConnection",
        Dict{String,Any}("vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_peering_connection(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpcPeeringConnection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("vpcId" => vpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpn_connection(customer_gateway_id, type)
    create_vpn_connection(customer_gateway_id, type, params::Dict{String,<:Any})

Creates a VPN connection between an existing virtual private gateway or transit gateway and
a customer gateway. The supported connection type is ipsec.1. The response includes
information that you need to give to your network administrator to configure your customer
gateway.  We strongly recommend that you use HTTPS when calling this operation because the
response contains sensitive cryptographic information for configuring your customer gateway
device.  If you decide to shut down your VPN connection for any reason and later create a
new VPN connection, you must reconfigure your customer gateway with the new information
returned from this call. This is an idempotent operation. If you perform the operation more
than once, Amazon EC2 doesn't return an error. For more information, see Amazon Web
Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.

# Arguments
- `customer_gateway_id`: The ID of the customer gateway.
- `type`: The type of VPN connection (ipsec.1).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TagSpecification"`: The tags to apply to the VPN connection.
- `"TransitGatewayId"`: The ID of the transit gateway. If you specify a transit gateway,
  you cannot specify a virtual private gateway.
- `"VpnGatewayId"`: The ID of the virtual private gateway. If you specify a virtual private
  gateway, you cannot specify a transit gateway.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"options"`: The options for the VPN connection.
"""
function create_vpn_connection(
    CustomerGatewayId, Type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpnConnection",
        Dict{String,Any}("CustomerGatewayId" => CustomerGatewayId, "Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpn_connection(
    CustomerGatewayId,
    Type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVpnConnection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CustomerGatewayId" => CustomerGatewayId, "Type" => Type),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpn_connection_route(destination_cidr_block, vpn_connection_id)
    create_vpn_connection_route(destination_cidr_block, vpn_connection_id, params::Dict{String,<:Any})

Creates a static route associated with a VPN connection between an existing virtual private
gateway and a VPN customer gateway. The static route allows traffic to be routed from the
virtual private gateway to the VPN customer gateway. For more information, see Amazon Web
Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.

# Arguments
- `destination_cidr_block`: The CIDR block associated with the local subnet of the customer
  network.
- `vpn_connection_id`: The ID of the VPN connection.

"""
function create_vpn_connection_route(
    DestinationCidrBlock,
    VpnConnectionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVpnConnectionRoute",
        Dict{String,Any}(
            "DestinationCidrBlock" => DestinationCidrBlock,
            "VpnConnectionId" => VpnConnectionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpn_connection_route(
    DestinationCidrBlock,
    VpnConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "CreateVpnConnectionRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "VpnConnectionId" => VpnConnectionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpn_gateway(type)
    create_vpn_gateway(type, params::Dict{String,<:Any})

Creates a virtual private gateway. A virtual private gateway is the endpoint on the VPC
side of your VPN connection. You can create a virtual private gateway before creating the
VPC itself. For more information, see Amazon Web Services Site-to-Site VPN in the Amazon
Web Services Site-to-Site VPN User Guide.

# Arguments
- `type`: The type of VPN connection this virtual private gateway supports.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AmazonSideAsn"`: A private Autonomous System Number (ASN) for the Amazon side of a BGP
  session. If you're using a 16-bit ASN, it must be in the 64512 to 65534 range. If you're
  using a 32-bit ASN, it must be in the 4200000000 to 4294967294 range. Default: 64512
- `"AvailabilityZone"`: The Availability Zone for the virtual private gateway.
- `"TagSpecification"`: The tags to apply to the virtual private gateway.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function create_vpn_gateway(Type; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "CreateVpnGateway",
        Dict{String,Any}("Type" => Type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpn_gateway(
    Type, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "CreateVpnGateway",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Type" => Type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_carrier_gateway(carrier_gateway_id)
    delete_carrier_gateway(carrier_gateway_id, params::Dict{String,<:Any})

Deletes a carrier gateway.  If you do not delete the route that contains the carrier
gateway as the Target, the route is a blackhole route. For information about how to delete
a route, see DeleteRoute.

# Arguments
- `carrier_gateway_id`: The ID of the carrier gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_carrier_gateway(
    CarrierGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteCarrierGateway",
        Dict{String,Any}("CarrierGatewayId" => CarrierGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_carrier_gateway(
    CarrierGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteCarrierGateway",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("CarrierGatewayId" => CarrierGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_client_vpn_endpoint(client_vpn_endpoint_id)
    delete_client_vpn_endpoint(client_vpn_endpoint_id, params::Dict{String,<:Any})

Deletes the specified Client VPN endpoint. You must disassociate all target networks before
you can delete a Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN to be deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_client_vpn_endpoint(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteClientVpnEndpoint",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_client_vpn_endpoint(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteClientVpnEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_client_vpn_route(client_vpn_endpoint_id, destination_cidr_block)
    delete_client_vpn_route(client_vpn_endpoint_id, destination_cidr_block, params::Dict{String,<:Any})

Deletes a route from a Client VPN endpoint. You can only delete routes that you manually
added using the CreateClientVpnRoute action. You cannot delete routes that were
automatically added when associating a subnet. To remove routes that have been
automatically added, disassociate the target subnet from the Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint from which the route is to be
  deleted.
- `destination_cidr_block`: The IPv4 address range, in CIDR notation, of the route to be
  deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TargetVpcSubnetId"`: The ID of the target subnet used by the route.
"""
function delete_client_vpn_route(
    ClientVpnEndpointId,
    DestinationCidrBlock;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteClientVpnRoute",
        Dict{String,Any}(
            "ClientVpnEndpointId" => ClientVpnEndpointId,
            "DestinationCidrBlock" => DestinationCidrBlock,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_client_vpn_route(
    ClientVpnEndpointId,
    DestinationCidrBlock,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteClientVpnRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                    "DestinationCidrBlock" => DestinationCidrBlock,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_coip_cidr(cidr, coip_pool_id)
    delete_coip_cidr(cidr, coip_pool_id, params::Dict{String,<:Any})

 Deletes a range of customer-owned IP addresses.

# Arguments
- `cidr`:  A customer-owned IP address range that you want to delete.
- `coip_pool_id`:  The ID of the customer-owned address pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_coip_cidr(
    Cidr, CoipPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteCoipCidr",
        Dict{String,Any}("Cidr" => Cidr, "CoipPoolId" => CoipPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_coip_cidr(
    Cidr,
    CoipPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteCoipCidr",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Cidr" => Cidr, "CoipPoolId" => CoipPoolId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_coip_pool(coip_pool_id)
    delete_coip_pool(coip_pool_id, params::Dict{String,<:Any})

Deletes a pool of customer-owned IP (CoIP) addresses.

# Arguments
- `coip_pool_id`: The ID of the CoIP pool that you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_coip_pool(CoipPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteCoipPool",
        Dict{String,Any}("CoipPoolId" => CoipPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_coip_pool(
    CoipPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteCoipPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CoipPoolId" => CoipPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_customer_gateway(customer_gateway_id)
    delete_customer_gateway(customer_gateway_id, params::Dict{String,<:Any})

Deletes the specified customer gateway. You must delete the VPN connection before you can
delete the customer gateway.

# Arguments
- `customer_gateway_id`: The ID of the customer gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_customer_gateway(
    CustomerGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteCustomerGateway",
        Dict{String,Any}("CustomerGatewayId" => CustomerGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_customer_gateway(
    CustomerGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteCustomerGateway",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("CustomerGatewayId" => CustomerGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dhcp_options(dhcp_options_id)
    delete_dhcp_options(dhcp_options_id, params::Dict{String,<:Any})

Deletes the specified set of DHCP options. You must disassociate the set of DHCP options
before you can delete it. You can disassociate the set of DHCP options by associating
either a new set of options or the default set of options with the VPC.

# Arguments
- `dhcp_options_id`: The ID of the DHCP options set.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_dhcp_options(
    DhcpOptionsId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteDhcpOptions",
        Dict{String,Any}("DhcpOptionsId" => DhcpOptionsId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dhcp_options(
    DhcpOptionsId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteDhcpOptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DhcpOptionsId" => DhcpOptionsId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_egress_only_internet_gateway(egress_only_internet_gateway_id)
    delete_egress_only_internet_gateway(egress_only_internet_gateway_id, params::Dict{String,<:Any})

Deletes an egress-only internet gateway.

# Arguments
- `egress_only_internet_gateway_id`: The ID of the egress-only internet gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_egress_only_internet_gateway(
    EgressOnlyInternetGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteEgressOnlyInternetGateway",
        Dict{String,Any}("EgressOnlyInternetGatewayId" => EgressOnlyInternetGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_egress_only_internet_gateway(
    EgressOnlyInternetGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteEgressOnlyInternetGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EgressOnlyInternetGatewayId" => EgressOnlyInternetGatewayId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fleets(fleet_id, terminate_instances)
    delete_fleets(fleet_id, terminate_instances, params::Dict{String,<:Any})

Deletes the specified EC2 Fleets. After you delete an EC2 Fleet, it launches no new
instances. You must also specify whether a deleted EC2 Fleet should terminate its
instances. If you choose to terminate the instances, the EC2 Fleet enters the
deleted_terminating state. Otherwise, the EC2 Fleet enters the deleted_running state, and
the instances continue to run until they are interrupted or you terminate them manually.
For instant fleets, EC2 Fleet must terminate the instances when the fleet is deleted. Up to
1000 instances can be terminated in a single request to delete instant fleets. A deleted
instant fleet with running instances is not supported.  Restrictions    You can delete up
to 25 fleets of type instant in a single request.   You can delete up to 100 fleets of type
maintain or request in a single request.   You can delete up to 125 fleets in a single
request, provided you do not exceed the quota for each fleet type, as specified above.   If
you exceed the specified number of fleets to delete, no fleets are deleted.   For more
information, see Delete an EC2 Fleet in the Amazon EC2 User Guide.

# Arguments
- `fleet_id`: The IDs of the EC2 Fleets. Constraints: In a single request, you can specify
  up to 25 instant fleet IDs and up to 100 maintain or request fleet IDs.
- `terminate_instances`: Indicates whether to terminate the associated instances when the
  EC2 Fleet is deleted. The default is to terminate the instances. To let the instances
  continue to run after the EC2 Fleet is deleted, specify no-terminate-instances. Supported
  only for fleets of type maintain and request. For instant fleets, you cannot specify
  NoTerminateInstances. A deleted instant fleet with running instances is not supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_fleets(
    FleetId, TerminateInstances; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteFleets",
        Dict{String,Any}("FleetId" => FleetId, "TerminateInstances" => TerminateInstances);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fleets(
    FleetId,
    TerminateInstances,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteFleets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FleetId" => FleetId, "TerminateInstances" => TerminateInstances
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_flow_logs(flow_log_id)
    delete_flow_logs(flow_log_id, params::Dict{String,<:Any})

Deletes one or more flow logs.

# Arguments
- `flow_log_id`: One or more flow log IDs. Constraint: Maximum of 1000 flow log IDs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_flow_logs(FlowLogId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteFlowLogs",
        Dict{String,Any}("FlowLogId" => FlowLogId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_flow_logs(
    FlowLogId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteFlowLogs",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FlowLogId" => FlowLogId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_fpga_image(fpga_image_id)
    delete_fpga_image(fpga_image_id, params::Dict{String,<:Any})

Deletes the specified Amazon FPGA Image (AFI).

# Arguments
- `fpga_image_id`: The ID of the AFI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_fpga_image(FpgaImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteFpgaImage",
        Dict{String,Any}("FpgaImageId" => FpgaImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_fpga_image(
    FpgaImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteFpgaImage",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FpgaImageId" => FpgaImageId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_connect_endpoint(instance_connect_endpoint_id)
    delete_instance_connect_endpoint(instance_connect_endpoint_id, params::Dict{String,<:Any})

Deletes the specified EC2 Instance Connect Endpoint.

# Arguments
- `instance_connect_endpoint_id`: The ID of the EC2 Instance Connect Endpoint to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_instance_connect_endpoint(
    InstanceConnectEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteInstanceConnectEndpoint",
        Dict{String,Any}("InstanceConnectEndpointId" => InstanceConnectEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_connect_endpoint(
    InstanceConnectEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteInstanceConnectEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceConnectEndpointId" => InstanceConnectEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_instance_event_window(instance_event_window_id)
    delete_instance_event_window(instance_event_window_id, params::Dict{String,<:Any})

Deletes the specified event window. For more information, see Define event windows for
scheduled events in the Amazon EC2 User Guide.

# Arguments
- `instance_event_window_id`: The ID of the event window.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ForceDelete"`: Specify true to force delete the event window. Use the force delete
  parameter if the event window is currently associated with targets.
"""
function delete_instance_event_window(
    InstanceEventWindowId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteInstanceEventWindow",
        Dict{String,Any}("InstanceEventWindowId" => InstanceEventWindowId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_instance_event_window(
    InstanceEventWindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteInstanceEventWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceEventWindowId" => InstanceEventWindowId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_internet_gateway(internet_gateway_id)
    delete_internet_gateway(internet_gateway_id, params::Dict{String,<:Any})

Deletes the specified internet gateway. You must detach the internet gateway from the VPC
before you can delete it.

# Arguments
- `internet_gateway_id`: The ID of the internet gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_internet_gateway(
    internetGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteInternetGateway",
        Dict{String,Any}("internetGatewayId" => internetGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_internet_gateway(
    internetGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteInternetGateway",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("internetGatewayId" => internetGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipam(ipam_id)
    delete_ipam(ipam_id, params::Dict{String,<:Any})

Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM
including the historical data for CIDRs. For more information, see Delete an IPAM in the
Amazon VPC IPAM User Guide.

# Arguments
- `ipam_id`: The ID of the IPAM to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Cascade"`: Enables you to quickly delete an IPAM, private scopes, pools in private
  scopes, and any allocations in the pools in private scopes. You cannot delete the IPAM with
  this option if there is a pool in your public scope. If you use this option, IPAM does the
  following:   Deallocates any CIDRs allocated to VPC resources (such as VPCs) in pools in
  private scopes.  No VPC resources are deleted as a result of enabling this option. The CIDR
  associated with the resource will no longer be allocated from an IPAM pool, but the CIDR
  itself will remain unchanged.    Deprovisions all IPv4 CIDRs provisioned to IPAM pools in
  private scopes.   Deletes all IPAM pools in private scopes.   Deletes all non-default
  private scopes in the IPAM.   Deletes the default public and private scopes and the IPAM.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_ipam(IpamId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteIpam",
        Dict{String,Any}("IpamId" => IpamId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipam(
    IpamId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteIpam",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("IpamId" => IpamId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipam_pool(ipam_pool_id)
    delete_ipam_pool(ipam_pool_id, params::Dict{String,<:Any})

Delete an IPAM pool.  You cannot delete an IPAM pool if there are allocations in it or
CIDRs provisioned to it. To release allocations, see ReleaseIpamPoolAllocation. To
deprovision pool CIDRs, see DeprovisionIpamPoolCidr.  For more information, see Delete a
pool in the Amazon VPC IPAM User Guide.

# Arguments
- `ipam_pool_id`: The ID of the pool to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Cascade"`: Enables you to quickly delete an IPAM pool and all resources within that
  pool, including provisioned CIDRs, allocations, and other pools.  You can only use this
  option to delete pools in the private scope or pools in the public scope with a source
  resource. A source resource is a resource used to provision CIDRs to a resource planning
  pool.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_ipam_pool(IpamPoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteIpamPool",
        Dict{String,Any}("IpamPoolId" => IpamPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipam_pool(
    IpamPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteIpamPool",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IpamPoolId" => IpamPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipam_resource_discovery(ipam_resource_discovery_id)
    delete_ipam_resource_discovery(ipam_resource_discovery_id, params::Dict{String,<:Any})

Deletes an IPAM resource discovery. A resource discovery is an IPAM component that enables
IPAM to manage and monitor resources that belong to the owning account.

# Arguments
- `ipam_resource_discovery_id`: The IPAM resource discovery ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_ipam_resource_discovery(
    IpamResourceDiscoveryId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteIpamResourceDiscovery",
        Dict{String,Any}("IpamResourceDiscoveryId" => IpamResourceDiscoveryId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipam_resource_discovery(
    IpamResourceDiscoveryId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteIpamResourceDiscovery",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IpamResourceDiscoveryId" => IpamResourceDiscoveryId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_ipam_scope(ipam_scope_id)
    delete_ipam_scope(ipam_scope_id, params::Dict{String,<:Any})

Delete the scope for an IPAM. You cannot delete the default scopes. For more information,
see Delete a scope in the Amazon VPC IPAM User Guide.

# Arguments
- `ipam_scope_id`: The ID of the scope to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_ipam_scope(IpamScopeId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteIpamScope",
        Dict{String,Any}("IpamScopeId" => IpamScopeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_ipam_scope(
    IpamScopeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteIpamScope",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IpamScopeId" => IpamScopeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_key_pair()
    delete_key_pair(params::Dict{String,<:Any})

Deletes the specified key pair, by removing the public key from Amazon EC2.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"KeyName"`: The name of the key pair.
- `"KeyPairId"`: The ID of the key pair.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_key_pair(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DeleteKeyPair"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function delete_key_pair(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteKeyPair", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    delete_launch_template()
    delete_launch_template(params::Dict{String,<:Any})

Deletes a launch template. Deleting a launch template deletes all of its versions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LaunchTemplateId"`: The ID of the launch template. You must specify either the launch
  template ID or the launch template name, but not both.
- `"LaunchTemplateName"`: The name of the launch template. You must specify either the
  launch template ID or the launch template name, but not both.
"""
function delete_launch_template(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteLaunchTemplate"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_launch_template(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteLaunchTemplate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_launch_template_versions(launch_template_version)
    delete_launch_template_versions(launch_template_version, params::Dict{String,<:Any})

Deletes one or more versions of a launch template. You can't delete the default version of
a launch template; you must first assign a different version as the default. If the default
version is the only version for the launch template, you must delete the entire launch
template using DeleteLaunchTemplate. You can delete up to 200 launch template versions in a
single request. To delete more than 200 versions in a single request, use
DeleteLaunchTemplate, which deletes the launch template and all of its versions. For more
information, see Delete a launch template version in the Amazon EC2 User Guide.

# Arguments
- `launch_template_version`: The version numbers of one or more launch template versions to
  delete. You can specify up to 200 launch template version numbers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LaunchTemplateId"`: The ID of the launch template. You must specify either the launch
  template ID or the launch template name, but not both.
- `"LaunchTemplateName"`: The name of the launch template. You must specify either the
  launch template ID or the launch template name, but not both.
"""
function delete_launch_template_versions(
    LaunchTemplateVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteLaunchTemplateVersions",
        Dict{String,Any}("LaunchTemplateVersion" => LaunchTemplateVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_launch_template_versions(
    LaunchTemplateVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLaunchTemplateVersions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LaunchTemplateVersion" => LaunchTemplateVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_local_gateway_route(local_gateway_route_table_id)
    delete_local_gateway_route(local_gateway_route_table_id, params::Dict{String,<:Any})

Deletes the specified route from the specified local gateway route table.

# Arguments
- `local_gateway_route_table_id`: The ID of the local gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationCidrBlock"`: The CIDR range for the route. This must match the CIDR for the
  route exactly.
- `"DestinationPrefixListId"`:  Use a prefix list in place of DestinationCidrBlock. You
  cannot use DestinationPrefixListId and DestinationCidrBlock in the same request.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_local_gateway_route(
    LocalGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteLocalGatewayRoute",
        Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_local_gateway_route(
    LocalGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_local_gateway_route_table(local_gateway_route_table_id)
    delete_local_gateway_route_table(local_gateway_route_table_id, params::Dict{String,<:Any})

 Deletes a local gateway route table.

# Arguments
- `local_gateway_route_table_id`:  The ID of the local gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_local_gateway_route_table(
    LocalGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteLocalGatewayRouteTable",
        Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_local_gateway_route_table(
    LocalGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("LocalGatewayRouteTableId" => LocalGatewayRouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_local_gateway_route_table_virtual_interface_group_association(local_gateway_route_table_virtual_interface_group_association_id)
    delete_local_gateway_route_table_virtual_interface_group_association(local_gateway_route_table_virtual_interface_group_association_id, params::Dict{String,<:Any})

 Deletes a local gateway route table virtual interface group association.

# Arguments
- `local_gateway_route_table_virtual_interface_group_association_id`:  The ID of the local
  gateway route table virtual interface group association.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_local_gateway_route_table_virtual_interface_group_association(
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Dict{String,Any}(
            "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId" =>
                LocalGatewayRouteTableVirtualInterfaceGroupAssociationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_local_gateway_route_table_virtual_interface_group_association(
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRouteTableVirtualInterfaceGroupAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LocalGatewayRouteTableVirtualInterfaceGroupAssociationId" =>
                        LocalGatewayRouteTableVirtualInterfaceGroupAssociationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_local_gateway_route_table_vpc_association(local_gateway_route_table_vpc_association_id)
    delete_local_gateway_route_table_vpc_association(local_gateway_route_table_vpc_association_id, params::Dict{String,<:Any})

Deletes the specified association between a VPC and local gateway route table.

# Arguments
- `local_gateway_route_table_vpc_association_id`: The ID of the association.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_local_gateway_route_table_vpc_association(
    LocalGatewayRouteTableVpcAssociationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRouteTableVpcAssociation",
        Dict{String,Any}(
            "LocalGatewayRouteTableVpcAssociationId" =>
                LocalGatewayRouteTableVpcAssociationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_local_gateway_route_table_vpc_association(
    LocalGatewayRouteTableVpcAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteLocalGatewayRouteTableVpcAssociation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "LocalGatewayRouteTableVpcAssociationId" =>
                        LocalGatewayRouteTableVpcAssociationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_managed_prefix_list(prefix_list_id)
    delete_managed_prefix_list(prefix_list_id, params::Dict{String,<:Any})

Deletes the specified managed prefix list. You must first remove all references to the
prefix list in your resources.

# Arguments
- `prefix_list_id`: The ID of the prefix list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_managed_prefix_list(
    PrefixListId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteManagedPrefixList",
        Dict{String,Any}("PrefixListId" => PrefixListId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_managed_prefix_list(
    PrefixListId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteManagedPrefixList",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PrefixListId" => PrefixListId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_nat_gateway(nat_gateway_id)
    delete_nat_gateway(nat_gateway_id, params::Dict{String,<:Any})

Deletes the specified NAT gateway. Deleting a public NAT gateway disassociates its Elastic
IP address, but does not release the address from your account. Deleting a NAT gateway does
not delete any NAT gateway routes in your route tables.

# Arguments
- `nat_gateway_id`: The ID of the NAT gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_nat_gateway(
    NatGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNatGateway",
        Dict{String,Any}("NatGatewayId" => NatGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_nat_gateway(
    NatGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNatGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("NatGatewayId" => NatGatewayId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_acl(network_acl_id)
    delete_network_acl(network_acl_id, params::Dict{String,<:Any})

Deletes the specified network ACL. You can't delete the ACL if it's associated with any
subnets. You can't delete the default network ACL.

# Arguments
- `network_acl_id`: The ID of the network ACL.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_acl(
    networkAclId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkAcl",
        Dict{String,Any}("networkAclId" => networkAclId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_acl(
    networkAclId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkAcl",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("networkAclId" => networkAclId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_acl_entry(egress, network_acl_id, rule_number)
    delete_network_acl_entry(egress, network_acl_id, rule_number, params::Dict{String,<:Any})

Deletes the specified ingress or egress entry (rule) from the specified network ACL.

# Arguments
- `egress`: Indicates whether the rule is an egress rule.
- `network_acl_id`: The ID of the network ACL.
- `rule_number`: The rule number of the entry to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_acl_entry(
    egress, networkAclId, ruleNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkAclEntry",
        Dict{String,Any}(
            "egress" => egress, "networkAclId" => networkAclId, "ruleNumber" => ruleNumber
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_acl_entry(
    egress,
    networkAclId,
    ruleNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkAclEntry",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "egress" => egress,
                    "networkAclId" => networkAclId,
                    "ruleNumber" => ruleNumber,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_insights_access_scope(network_insights_access_scope_id)
    delete_network_insights_access_scope(network_insights_access_scope_id, params::Dict{String,<:Any})

Deletes the specified Network Access Scope.

# Arguments
- `network_insights_access_scope_id`: The ID of the Network Access Scope.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_insights_access_scope(
    NetworkInsightsAccessScopeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInsightsAccessScope",
        Dict{String,Any}("NetworkInsightsAccessScopeId" => NetworkInsightsAccessScopeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_insights_access_scope(
    NetworkInsightsAccessScopeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInsightsAccessScope",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NetworkInsightsAccessScopeId" => NetworkInsightsAccessScopeId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_insights_access_scope_analysis(network_insights_access_scope_analysis_id)
    delete_network_insights_access_scope_analysis(network_insights_access_scope_analysis_id, params::Dict{String,<:Any})

Deletes the specified Network Access Scope analysis.

# Arguments
- `network_insights_access_scope_analysis_id`: The ID of the Network Access Scope analysis.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_insights_access_scope_analysis(
    NetworkInsightsAccessScopeAnalysisId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInsightsAccessScopeAnalysis",
        Dict{String,Any}(
            "NetworkInsightsAccessScopeAnalysisId" => NetworkInsightsAccessScopeAnalysisId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_insights_access_scope_analysis(
    NetworkInsightsAccessScopeAnalysisId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInsightsAccessScopeAnalysis",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NetworkInsightsAccessScopeAnalysisId" =>
                        NetworkInsightsAccessScopeAnalysisId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_insights_analysis(network_insights_analysis_id)
    delete_network_insights_analysis(network_insights_analysis_id, params::Dict{String,<:Any})

Deletes the specified network insights analysis.

# Arguments
- `network_insights_analysis_id`: The ID of the network insights analysis.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_insights_analysis(
    NetworkInsightsAnalysisId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInsightsAnalysis",
        Dict{String,Any}("NetworkInsightsAnalysisId" => NetworkInsightsAnalysisId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_insights_analysis(
    NetworkInsightsAnalysisId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInsightsAnalysis",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("NetworkInsightsAnalysisId" => NetworkInsightsAnalysisId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_insights_path(network_insights_path_id)
    delete_network_insights_path(network_insights_path_id, params::Dict{String,<:Any})

Deletes the specified path.

# Arguments
- `network_insights_path_id`: The ID of the path.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_insights_path(
    NetworkInsightsPathId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInsightsPath",
        Dict{String,Any}("NetworkInsightsPathId" => NetworkInsightsPathId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_insights_path(
    NetworkInsightsPathId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInsightsPath",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("NetworkInsightsPathId" => NetworkInsightsPathId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_interface(network_interface_id)
    delete_network_interface(network_interface_id, params::Dict{String,<:Any})

Deletes the specified network interface. You must detach the network interface before you
can delete it.

# Arguments
- `network_interface_id`: The ID of the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_network_interface(
    networkInterfaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInterface",
        Dict{String,Any}("networkInterfaceId" => networkInterfaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_interface(
    networkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInterface",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("networkInterfaceId" => networkInterfaceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_network_interface_permission(network_interface_permission_id)
    delete_network_interface_permission(network_interface_permission_id, params::Dict{String,<:Any})

Deletes a permission for a network interface. By default, you cannot delete the permission
if the account for which you're removing the permission has attached the network interface
to an instance. However, you can force delete the permission, regardless of any attachment.

# Arguments
- `network_interface_permission_id`: The ID of the network interface permission.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Force"`: Specify true to remove the permission even if the network interface is
  attached to an instance.
"""
function delete_network_interface_permission(
    NetworkInterfacePermissionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteNetworkInterfacePermission",
        Dict{String,Any}("NetworkInterfacePermissionId" => NetworkInterfacePermissionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_network_interface_permission(
    NetworkInterfacePermissionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteNetworkInterfacePermission",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "NetworkInterfacePermissionId" => NetworkInterfacePermissionId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_placement_group(group_name)
    delete_placement_group(group_name, params::Dict{String,<:Any})

Deletes the specified placement group. You must terminate all instances in the placement
group before you can delete the placement group. For more information, see Placement groups
in the Amazon EC2 User Guide.

# Arguments
- `group_name`: The name of the placement group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_placement_group(
    groupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeletePlacementGroup",
        Dict{String,Any}("groupName" => groupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_placement_group(
    groupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeletePlacementGroup",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("groupName" => groupName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_public_ipv4_pool(pool_id)
    delete_public_ipv4_pool(pool_id, params::Dict{String,<:Any})

Delete a public IPv4 pool. A public IPv4 pool is an EC2 IP address pool required for the
public IPv4 CIDRs that you own and bring to Amazon Web Services to manage with IPAM. IPv6
addresses you bring to Amazon Web Services, however, use IPAM pools only.

# Arguments
- `pool_id`: The ID of the public IPv4 pool you want to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_public_ipv4_pool(PoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeletePublicIpv4Pool",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_public_ipv4_pool(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeletePublicIpv4Pool",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_queued_reserved_instances(reserved_instances_id)
    delete_queued_reserved_instances(reserved_instances_id, params::Dict{String,<:Any})

Deletes the queued purchases for the specified Reserved Instances.

# Arguments
- `reserved_instances_id`: The IDs of the Reserved Instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_queued_reserved_instances(
    ReservedInstancesId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteQueuedReservedInstances",
        Dict{String,Any}("ReservedInstancesId" => ReservedInstancesId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_queued_reserved_instances(
    ReservedInstancesId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteQueuedReservedInstances",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ReservedInstancesId" => ReservedInstancesId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_route(route_table_id)
    delete_route(route_table_id, params::Dict{String,<:Any})

Deletes the specified route from the specified route table.

# Arguments
- `route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationPrefixListId"`: The ID of the prefix list for the route.
- `"destinationCidrBlock"`: The IPv4 CIDR range for the route. The value you specify must
  match the CIDR for the route exactly.
- `"destinationIpv6CidrBlock"`: The IPv6 CIDR range for the route. The value you specify
  must match the CIDR for the route exactly.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_route(routeTableId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteRoute",
        Dict{String,Any}("routeTableId" => routeTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_route(
    routeTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteRoute",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("routeTableId" => routeTableId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_route_table(route_table_id)
    delete_route_table(route_table_id, params::Dict{String,<:Any})

Deletes the specified route table. You must disassociate the route table from any subnets
before you can delete it. You can't delete the main route table.

# Arguments
- `route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_route_table(
    routeTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteRouteTable",
        Dict{String,Any}("routeTableId" => routeTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_route_table(
    routeTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteRouteTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("routeTableId" => routeTableId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_security_group()
    delete_security_group(params::Dict{String,<:Any})

Deletes a security group. If you attempt to delete a security group that is associated with
an instance or network interface or is referenced by another security group, the operation
fails with DependencyViolation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"GroupId"`: The ID of the security group.
- `"GroupName"`: [Default VPC] The name of the security group. You can specify either the
  security group name or the security group ID. For security groups in a nondefault VPC, you
  must specify the security group ID.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_security_group(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteSecurityGroup"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_security_group(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteSecurityGroup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_snapshot(snapshot_id)
    delete_snapshot(snapshot_id, params::Dict{String,<:Any})

Deletes the specified snapshot. When you make periodic snapshots of a volume, the snapshots
are incremental, and only the blocks on the device that have changed since your last
snapshot are saved in the new snapshot. When you delete a snapshot, only the data not
needed for any other snapshot is removed. So regardless of which prior snapshots have been
deleted, all active snapshots will have access to all the information needed to restore the
volume. You cannot delete a snapshot of the root device of an EBS volume used by a
registered AMI. You must first de-register the AMI before you can delete the snapshot. For
more information, see Delete an Amazon EBS snapshot in the Amazon EBS User Guide.

# Arguments
- `snapshot_id`: The ID of the EBS snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_snapshot(SnapshotId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteSnapshot",
        Dict{String,Any}("SnapshotId" => SnapshotId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_snapshot(
    SnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteSnapshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SnapshotId" => SnapshotId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_spot_datafeed_subscription()
    delete_spot_datafeed_subscription(params::Dict{String,<:Any})

Deletes the data feed for Spot Instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_spot_datafeed_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteSpotDatafeedSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_spot_datafeed_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteSpotDatafeedSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_subnet(subnet_id)
    delete_subnet(subnet_id, params::Dict{String,<:Any})

Deletes the specified subnet. You must terminate all running instances in the subnet before
you can delete the subnet.

# Arguments
- `subnet_id`: The ID of the subnet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_subnet(SubnetId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteSubnet",
        Dict{String,Any}("SubnetId" => SubnetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_subnet(
    SubnetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteSubnet",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("SubnetId" => SubnetId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_subnet_cidr_reservation(subnet_cidr_reservation_id)
    delete_subnet_cidr_reservation(subnet_cidr_reservation_id, params::Dict{String,<:Any})

Deletes a subnet CIDR reservation.

# Arguments
- `subnet_cidr_reservation_id`: The ID of the subnet CIDR reservation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_subnet_cidr_reservation(
    SubnetCidrReservationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteSubnetCidrReservation",
        Dict{String,Any}("SubnetCidrReservationId" => SubnetCidrReservationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_subnet_cidr_reservation(
    SubnetCidrReservationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteSubnetCidrReservation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SubnetCidrReservationId" => SubnetCidrReservationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tags(resource_id)
    delete_tags(resource_id, params::Dict{String,<:Any})

Deletes the specified set of tags from the specified set of resources. To list the current
tags, use DescribeTags. For more information about tags, see Tag your Amazon EC2 resources
in the Amazon Elastic Compute Cloud User Guide.

# Arguments
- `resource_id`: The IDs of the resources, separated by spaces. Constraints: Up to 1000
  resource IDs. We recommend breaking up this request into smaller batches.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"tag"`: The tags to delete. Specify a tag key and an optional tag value to delete
  specific tags. If you specify a tag key without a tag value, we delete any tag with this
  key regardless of its value. If you specify a tag key with an empty string as the tag
  value, we delete the tag only if its value is an empty string. If you omit this parameter,
  we delete all user-defined tags for the specified resources. We do not delete Amazon Web
  Services-generated tags (tags that have the aws: prefix). Constraints: Up to 1000 tags.
"""
function delete_tags(resourceId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteTags",
        Dict{String,Any}("resourceId" => resourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tags(
    resourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTags",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceId" => resourceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_traffic_mirror_filter(traffic_mirror_filter_id)
    delete_traffic_mirror_filter(traffic_mirror_filter_id, params::Dict{String,<:Any})

Deletes the specified Traffic Mirror filter. You cannot delete a Traffic Mirror filter that
is in use by a Traffic Mirror session.

# Arguments
- `traffic_mirror_filter_id`: The ID of the Traffic Mirror filter.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_traffic_mirror_filter(
    TrafficMirrorFilterId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTrafficMirrorFilter",
        Dict{String,Any}("TrafficMirrorFilterId" => TrafficMirrorFilterId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_traffic_mirror_filter(
    TrafficMirrorFilterId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTrafficMirrorFilter",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TrafficMirrorFilterId" => TrafficMirrorFilterId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_traffic_mirror_filter_rule(traffic_mirror_filter_rule_id)
    delete_traffic_mirror_filter_rule(traffic_mirror_filter_rule_id, params::Dict{String,<:Any})

Deletes the specified Traffic Mirror rule.

# Arguments
- `traffic_mirror_filter_rule_id`: The ID of the Traffic Mirror rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_traffic_mirror_filter_rule(
    TrafficMirrorFilterRuleId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTrafficMirrorFilterRule",
        Dict{String,Any}("TrafficMirrorFilterRuleId" => TrafficMirrorFilterRuleId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_traffic_mirror_filter_rule(
    TrafficMirrorFilterRuleId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTrafficMirrorFilterRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TrafficMirrorFilterRuleId" => TrafficMirrorFilterRuleId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_traffic_mirror_session(traffic_mirror_session_id)
    delete_traffic_mirror_session(traffic_mirror_session_id, params::Dict{String,<:Any})

Deletes the specified Traffic Mirror session.

# Arguments
- `traffic_mirror_session_id`: The ID of the Traffic Mirror session.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_traffic_mirror_session(
    TrafficMirrorSessionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTrafficMirrorSession",
        Dict{String,Any}("TrafficMirrorSessionId" => TrafficMirrorSessionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_traffic_mirror_session(
    TrafficMirrorSessionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTrafficMirrorSession",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TrafficMirrorSessionId" => TrafficMirrorSessionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_traffic_mirror_target(traffic_mirror_target_id)
    delete_traffic_mirror_target(traffic_mirror_target_id, params::Dict{String,<:Any})

Deletes the specified Traffic Mirror target. You cannot delete a Traffic Mirror target that
is in use by a Traffic Mirror session.

# Arguments
- `traffic_mirror_target_id`: The ID of the Traffic Mirror target.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_traffic_mirror_target(
    TrafficMirrorTargetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTrafficMirrorTarget",
        Dict{String,Any}("TrafficMirrorTargetId" => TrafficMirrorTargetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_traffic_mirror_target(
    TrafficMirrorTargetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTrafficMirrorTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("TrafficMirrorTargetId" => TrafficMirrorTargetId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway(transit_gateway_id)
    delete_transit_gateway(transit_gateway_id, params::Dict{String,<:Any})

Deletes the specified transit gateway.

# Arguments
- `transit_gateway_id`: The ID of the transit gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway(
    TransitGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGateway",
        Dict{String,Any}("TransitGatewayId" => TransitGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway(
    TransitGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGateway",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TransitGatewayId" => TransitGatewayId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_connect(transit_gateway_attachment_id)
    delete_transit_gateway_connect(transit_gateway_attachment_id, params::Dict{String,<:Any})

Deletes the specified Connect attachment. You must first delete any Connect peers for the
attachment.

# Arguments
- `transit_gateway_attachment_id`: The ID of the Connect attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_connect(
    TransitGatewayAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayConnect",
        Dict{String,Any}("TransitGatewayAttachmentId" => TransitGatewayAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_connect(
    TransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayConnect",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_connect_peer(transit_gateway_connect_peer_id)
    delete_transit_gateway_connect_peer(transit_gateway_connect_peer_id, params::Dict{String,<:Any})

Deletes the specified Connect peer.

# Arguments
- `transit_gateway_connect_peer_id`: The ID of the Connect peer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_connect_peer(
    TransitGatewayConnectPeerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayConnectPeer",
        Dict{String,Any}("TransitGatewayConnectPeerId" => TransitGatewayConnectPeerId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_connect_peer(
    TransitGatewayConnectPeerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayConnectPeer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayConnectPeerId" => TransitGatewayConnectPeerId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_multicast_domain(transit_gateway_multicast_domain_id)
    delete_transit_gateway_multicast_domain(transit_gateway_multicast_domain_id, params::Dict{String,<:Any})

Deletes the specified transit gateway multicast domain.

# Arguments
- `transit_gateway_multicast_domain_id`: The ID of the transit gateway multicast domain.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_multicast_domain(
    TransitGatewayMulticastDomainId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayMulticastDomain",
        Dict{String,Any}(
            "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_multicast_domain(
    TransitGatewayMulticastDomainId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayMulticastDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_peering_attachment(transit_gateway_attachment_id)
    delete_transit_gateway_peering_attachment(transit_gateway_attachment_id, params::Dict{String,<:Any})

Deletes a transit gateway peering attachment.

# Arguments
- `transit_gateway_attachment_id`: The ID of the transit gateway peering attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_peering_attachment(
    TransitGatewayAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayPeeringAttachment",
        Dict{String,Any}("TransitGatewayAttachmentId" => TransitGatewayAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_peering_attachment(
    TransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayPeeringAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_policy_table(transit_gateway_policy_table_id)
    delete_transit_gateway_policy_table(transit_gateway_policy_table_id, params::Dict{String,<:Any})

Deletes the specified transit gateway policy table.

# Arguments
- `transit_gateway_policy_table_id`: The transit gateway policy table to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_policy_table(
    TransitGatewayPolicyTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayPolicyTable",
        Dict{String,Any}("TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_policy_table(
    TransitGatewayPolicyTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayPolicyTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_prefix_list_reference(prefix_list_id, transit_gateway_route_table_id)
    delete_transit_gateway_prefix_list_reference(prefix_list_id, transit_gateway_route_table_id, params::Dict{String,<:Any})

Deletes a reference (route) to a prefix list in a specified transit gateway route table.

# Arguments
- `prefix_list_id`: The ID of the prefix list.
- `transit_gateway_route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_prefix_list_reference(
    PrefixListId,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayPrefixListReference",
        Dict{String,Any}(
            "PrefixListId" => PrefixListId,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_prefix_list_reference(
    PrefixListId,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayPrefixListReference",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PrefixListId" => PrefixListId,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_route(destination_cidr_block, transit_gateway_route_table_id)
    delete_transit_gateway_route(destination_cidr_block, transit_gateway_route_table_id, params::Dict{String,<:Any})

Deletes the specified route from the specified transit gateway route table.

# Arguments
- `destination_cidr_block`: The CIDR range for the route. This must match the CIDR for the
  route exactly.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_route(
    DestinationCidrBlock,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayRoute",
        Dict{String,Any}(
            "DestinationCidrBlock" => DestinationCidrBlock,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_route(
    DestinationCidrBlock,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_route_table(transit_gateway_route_table_id)
    delete_transit_gateway_route_table(transit_gateway_route_table_id, params::Dict{String,<:Any})

Deletes the specified transit gateway route table. If there are any route tables associated
with the transit gateway route table, you must first run DisassociateRouteTable before you
can delete the transit gateway route table. This removes any route tables associated with
the transit gateway route table.

# Arguments
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_route_table(
    TransitGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayRouteTable",
        Dict{String,Any}("TransitGatewayRouteTableId" => TransitGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_route_table(
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_route_table_announcement(transit_gateway_route_table_announcement_id)
    delete_transit_gateway_route_table_announcement(transit_gateway_route_table_announcement_id, params::Dict{String,<:Any})

Advertises to the transit gateway that a transit gateway route table is deleted.

# Arguments
- `transit_gateway_route_table_announcement_id`: The transit gateway route table ID that's
  being deleted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_route_table_announcement(
    TransitGatewayRouteTableAnnouncementId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayRouteTableAnnouncement",
        Dict{String,Any}(
            "TransitGatewayRouteTableAnnouncementId" =>
                TransitGatewayRouteTableAnnouncementId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_route_table_announcement(
    TransitGatewayRouteTableAnnouncementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayRouteTableAnnouncement",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayRouteTableAnnouncementId" =>
                        TransitGatewayRouteTableAnnouncementId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_transit_gateway_vpc_attachment(transit_gateway_attachment_id)
    delete_transit_gateway_vpc_attachment(transit_gateway_attachment_id, params::Dict{String,<:Any})

Deletes the specified VPC attachment.

# Arguments
- `transit_gateway_attachment_id`: The ID of the attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_transit_gateway_vpc_attachment(
    TransitGatewayAttachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteTransitGatewayVpcAttachment",
        Dict{String,Any}("TransitGatewayAttachmentId" => TransitGatewayAttachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_transit_gateway_vpc_attachment(
    TransitGatewayAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteTransitGatewayVpcAttachment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_access_endpoint(verified_access_endpoint_id)
    delete_verified_access_endpoint(verified_access_endpoint_id, params::Dict{String,<:Any})

Delete an Amazon Web Services Verified Access endpoint.

# Arguments
- `verified_access_endpoint_id`: The ID of the Verified Access endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_verified_access_endpoint(
    VerifiedAccessEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVerifiedAccessEndpoint",
        Dict{String,Any}(
            "VerifiedAccessEndpointId" => VerifiedAccessEndpointId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_access_endpoint(
    VerifiedAccessEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVerifiedAccessEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessEndpointId" => VerifiedAccessEndpointId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_access_group(verified_access_group_id)
    delete_verified_access_group(verified_access_group_id, params::Dict{String,<:Any})

Delete an Amazon Web Services Verified Access group.

# Arguments
- `verified_access_group_id`: The ID of the Verified Access group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_verified_access_group(
    VerifiedAccessGroupId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVerifiedAccessGroup",
        Dict{String,Any}(
            "VerifiedAccessGroupId" => VerifiedAccessGroupId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_access_group(
    VerifiedAccessGroupId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVerifiedAccessGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessGroupId" => VerifiedAccessGroupId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_access_instance(verified_access_instance_id)
    delete_verified_access_instance(verified_access_instance_id, params::Dict{String,<:Any})

Delete an Amazon Web Services Verified Access instance.

# Arguments
- `verified_access_instance_id`: The ID of the Verified Access instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_verified_access_instance(
    VerifiedAccessInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVerifiedAccessInstance",
        Dict{String,Any}(
            "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_access_instance(
    VerifiedAccessInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVerifiedAccessInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_verified_access_trust_provider(verified_access_trust_provider_id)
    delete_verified_access_trust_provider(verified_access_trust_provider_id, params::Dict{String,<:Any})

Delete an Amazon Web Services Verified Access trust provider.

# Arguments
- `verified_access_trust_provider_id`: The ID of the Verified Access trust provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_verified_access_trust_provider(
    VerifiedAccessTrustProviderId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVerifiedAccessTrustProvider",
        Dict{String,Any}(
            "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_verified_access_trust_provider(
    VerifiedAccessTrustProviderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVerifiedAccessTrustProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_volume(volume_id)
    delete_volume(volume_id, params::Dict{String,<:Any})

Deletes the specified EBS volume. The volume must be in the available state (not attached
to an instance). The volume can remain in the deleting state for several minutes. For more
information, see Delete an Amazon EBS volume in the Amazon EBS User Guide.

# Arguments
- `volume_id`: The ID of the volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc(vpc_id)
    delete_vpc(vpc_id, params::Dict{String,<:Any})

Deletes the specified VPC. You must detach or delete all gateways and resources that are
associated with the VPC before you can delete it. For example, you must terminate all
instances running in the VPC, delete all security groups associated with the VPC (except
the default one), delete all route tables associated with the VPC (except the default one),
and so on. When you delete the VPC, it deletes the VPC's default security group, network
ACL, and route table.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpc(VpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeleteVpc",
        Dict{String,Any}("VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc(
    VpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpc",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("VpcId" => VpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_endpoint_connection_notifications(connection_notification_id)
    delete_vpc_endpoint_connection_notifications(connection_notification_id, params::Dict{String,<:Any})

Deletes the specified VPC endpoint connection notifications.

# Arguments
- `connection_notification_id`: The IDs of the notifications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpc_endpoint_connection_notifications(
    ConnectionNotificationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpcEndpointConnectionNotifications",
        Dict{String,Any}("ConnectionNotificationId" => ConnectionNotificationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_endpoint_connection_notifications(
    ConnectionNotificationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpcEndpointConnectionNotifications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConnectionNotificationId" => ConnectionNotificationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_endpoint_service_configurations(service_id)
    delete_vpc_endpoint_service_configurations(service_id, params::Dict{String,<:Any})

Deletes the specified VPC endpoint service configurations. Before you can delete an
endpoint service configuration, you must reject any Available or PendingAcceptance
interface endpoint connections that are attached to the service.

# Arguments
- `service_id`: The IDs of the services.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpc_endpoint_service_configurations(
    ServiceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpcEndpointServiceConfigurations",
        Dict{String,Any}("ServiceId" => ServiceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_endpoint_service_configurations(
    ServiceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpcEndpointServiceConfigurations",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServiceId" => ServiceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_endpoints(vpc_endpoint_id)
    delete_vpc_endpoints(vpc_endpoint_id, params::Dict{String,<:Any})

Deletes the specified VPC endpoints. When you delete a gateway endpoint, we delete the
endpoint routes in the route tables for the endpoint. When you delete a Gateway Load
Balancer endpoint, we delete its endpoint network interfaces. You can only delete Gateway
Load Balancer endpoints when the routes that are associated with the endpoint are deleted.
When you delete an interface endpoint, we delete its endpoint network interfaces.

# Arguments
- `vpc_endpoint_id`: The IDs of the VPC endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpc_endpoints(
    VpcEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpcEndpoints",
        Dict{String,Any}("VpcEndpointId" => VpcEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_endpoints(
    VpcEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpcEndpoints",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VpcEndpointId" => VpcEndpointId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpc_peering_connection(vpc_peering_connection_id)
    delete_vpc_peering_connection(vpc_peering_connection_id, params::Dict{String,<:Any})

Deletes a VPC peering connection. Either the owner of the requester VPC or the owner of the
accepter VPC can delete the VPC peering connection if it's in the active state. The owner
of the requester VPC can delete a VPC peering connection in the pending-acceptance state.
You cannot delete a VPC peering connection that's in the failed or rejected state.

# Arguments
- `vpc_peering_connection_id`: The ID of the VPC peering connection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpc_peering_connection(
    vpcPeeringConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpcPeeringConnection",
        Dict{String,Any}("vpcPeeringConnectionId" => vpcPeeringConnectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpc_peering_connection(
    vpcPeeringConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpcPeeringConnection",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("vpcPeeringConnectionId" => vpcPeeringConnectionId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpn_connection(vpn_connection_id)
    delete_vpn_connection(vpn_connection_id, params::Dict{String,<:Any})

Deletes the specified VPN connection. If you're deleting the VPC and its associated
components, we recommend that you detach the virtual private gateway from the VPC and
delete the VPC before deleting the VPN connection. If you believe that the tunnel
credentials for your VPN connection have been compromised, you can delete the VPN
connection and create a new one that has new keys, without needing to delete the VPC or
virtual private gateway. If you create a new VPN connection, you must reconfigure the
customer gateway device using the new configuration information returned with the new VPN
connection ID. For certificate-based authentication, delete all Certificate Manager (ACM)
private certificates used for the Amazon Web Services-side tunnel endpoints for the VPN
connection before deleting the VPN connection.

# Arguments
- `vpn_connection_id`: The ID of the VPN connection.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpn_connection(
    VpnConnectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpnConnection",
        Dict{String,Any}("VpnConnectionId" => VpnConnectionId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpn_connection(
    VpnConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpnConnection",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("VpnConnectionId" => VpnConnectionId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpn_connection_route(destination_cidr_block, vpn_connection_id)
    delete_vpn_connection_route(destination_cidr_block, vpn_connection_id, params::Dict{String,<:Any})

Deletes the specified static route associated with a VPN connection between an existing
virtual private gateway and a VPN customer gateway. The static route allows traffic to be
routed from the virtual private gateway to the VPN customer gateway.

# Arguments
- `destination_cidr_block`: The CIDR block associated with the local subnet of the customer
  network.
- `vpn_connection_id`: The ID of the VPN connection.

"""
function delete_vpn_connection_route(
    DestinationCidrBlock,
    VpnConnectionId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpnConnectionRoute",
        Dict{String,Any}(
            "DestinationCidrBlock" => DestinationCidrBlock,
            "VpnConnectionId" => VpnConnectionId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpn_connection_route(
    DestinationCidrBlock,
    VpnConnectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpnConnectionRoute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DestinationCidrBlock" => DestinationCidrBlock,
                    "VpnConnectionId" => VpnConnectionId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_vpn_gateway(vpn_gateway_id)
    delete_vpn_gateway(vpn_gateway_id, params::Dict{String,<:Any})

Deletes the specified virtual private gateway. You must first detach the virtual private
gateway from the VPC. Note that you don't need to delete the virtual private gateway if you
plan to delete and recreate the VPN connection between your VPC and your network.

# Arguments
- `vpn_gateway_id`: The ID of the virtual private gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function delete_vpn_gateway(
    VpnGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeleteVpnGateway",
        Dict{String,Any}("VpnGatewayId" => VpnGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_vpn_gateway(
    VpnGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeleteVpnGateway",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VpnGatewayId" => VpnGatewayId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprovision_byoip_cidr(cidr)
    deprovision_byoip_cidr(cidr, params::Dict{String,<:Any})

Releases the specified address range that you provisioned for use with your Amazon Web
Services resources through bring your own IP addresses (BYOIP) and deletes the
corresponding address pool. Before you can release an address range, you must stop
advertising it using WithdrawByoipCidr and you must not have any IP addresses allocated
from its address range.

# Arguments
- `cidr`: The address range, in CIDR notation. The prefix must be the same prefix that you
  specified when you provisioned the address range.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deprovision_byoip_cidr(Cidr; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeprovisionByoipCidr",
        Dict{String,Any}("Cidr" => Cidr);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprovision_byoip_cidr(
    Cidr, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeprovisionByoipCidr",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Cidr" => Cidr), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprovision_ipam_byoasn(asn, ipam_id)
    deprovision_ipam_byoasn(asn, ipam_id, params::Dict{String,<:Any})

Deprovisions your Autonomous System Number (ASN) from your Amazon Web Services account.
This action can only be called after any BYOIP CIDR associations are removed from your
Amazon Web Services account with DisassociateIpamByoasn. For more information, see
Tutorial: Bring your ASN to IPAM in the Amazon VPC IPAM guide.

# Arguments
- `asn`: An ASN.
- `ipam_id`: The IPAM ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deprovision_ipam_byoasn(
    Asn, IpamId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeprovisionIpamByoasn",
        Dict{String,Any}("Asn" => Asn, "IpamId" => IpamId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprovision_ipam_byoasn(
    Asn,
    IpamId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeprovisionIpamByoasn",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Asn" => Asn, "IpamId" => IpamId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprovision_ipam_pool_cidr(ipam_pool_id)
    deprovision_ipam_pool_cidr(ipam_pool_id, params::Dict{String,<:Any})

Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool
that has a source pool, the CIDR is recycled back into the source pool. For more
information, see Deprovision pool CIDRs in the Amazon VPC IPAM User Guide.

# Arguments
- `ipam_pool_id`: The ID of the pool that has the CIDR you want to deprovision.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Cidr"`: The CIDR which you want to deprovision from the pool.
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deprovision_ipam_pool_cidr(
    IpamPoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeprovisionIpamPoolCidr",
        Dict{String,Any}("IpamPoolId" => IpamPoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprovision_ipam_pool_cidr(
    IpamPoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeprovisionIpamPoolCidr",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("IpamPoolId" => IpamPoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deprovision_public_ipv4_pool_cidr(cidr, pool_id)
    deprovision_public_ipv4_pool_cidr(cidr, pool_id, params::Dict{String,<:Any})

Deprovision a CIDR from a public IPv4 pool.

# Arguments
- `cidr`: The CIDR you want to deprovision from the pool. Enter the CIDR you want to
  deprovision with a netmask of /32. You must rerun this command for each IP address in the
  CIDR range. If your CIDR is a /24, you will have to run this command to deprovision each of
  the 256 IP addresses in the /24 CIDR.
- `pool_id`: The ID of the pool that you want to deprovision the CIDR from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deprovision_public_ipv4_pool_cidr(
    Cidr, PoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeprovisionPublicIpv4PoolCidr",
        Dict{String,Any}("Cidr" => Cidr, "PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deprovision_public_ipv4_pool_cidr(
    Cidr,
    PoolId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeprovisionPublicIpv4PoolCidr",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Cidr" => Cidr, "PoolId" => PoolId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_image(image_id)
    deregister_image(image_id, params::Dict{String,<:Any})

Deregisters the specified AMI. After you deregister an AMI, it can't be used to launch new
instances. If you deregister an AMI that matches a Recycle Bin retention rule, the AMI is
retained in the Recycle Bin for the specified retention period. For more information, see
Recycle Bin in the Amazon EC2 User Guide. When you deregister an AMI, it doesn't affect any
instances that you've already launched from the AMI. You'll continue to incur usage costs
for those instances until you terminate them. When you deregister an Amazon EBS-backed AMI,
it doesn't affect the snapshot that was created for the root volume of the instance during
the AMI creation process. When you deregister an instance store-backed AMI, it doesn't
affect the files that you uploaded to Amazon S3 when you created the AMI.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deregister_image(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DeregisterImage",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_image(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeregisterImage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_instance_event_notification_attributes(instance_tag_attribute)
    deregister_instance_event_notification_attributes(instance_tag_attribute, params::Dict{String,<:Any})

Deregisters tag keys to prevent tags that have the specified tag keys from being included
in scheduled event notifications for resources in the Region.

# Arguments
- `instance_tag_attribute`: Information about the tag keys to deregister.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function deregister_instance_event_notification_attributes(
    InstanceTagAttribute; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeregisterInstanceEventNotificationAttributes",
        Dict{String,Any}("InstanceTagAttribute" => InstanceTagAttribute);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_instance_event_notification_attributes(
    InstanceTagAttribute,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DeregisterInstanceEventNotificationAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("InstanceTagAttribute" => InstanceTagAttribute),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_transit_gateway_multicast_group_members()
    deregister_transit_gateway_multicast_group_members(params::Dict{String,<:Any})

Deregisters the specified members (network interfaces) from the transit gateway multicast
group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GroupIpAddress"`: The IP address assigned to the transit gateway multicast group.
- `"NetworkInterfaceIds"`: The IDs of the group members' network interfaces.
- `"TransitGatewayMulticastDomainId"`: The ID of the transit gateway multicast domain.
"""
function deregister_transit_gateway_multicast_group_members(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeregisterTransitGatewayMulticastGroupMembers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_transit_gateway_multicast_group_members(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeregisterTransitGatewayMulticastGroupMembers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_transit_gateway_multicast_group_sources()
    deregister_transit_gateway_multicast_group_sources(params::Dict{String,<:Any})

Deregisters the specified sources (network interfaces) from the transit gateway multicast
group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GroupIpAddress"`: The IP address assigned to the transit gateway multicast group.
- `"NetworkInterfaceIds"`: The IDs of the group sources' network interfaces.
- `"TransitGatewayMulticastDomainId"`: The ID of the transit gateway multicast domain.
"""
function deregister_transit_gateway_multicast_group_sources(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeregisterTransitGatewayMulticastGroupSources";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_transit_gateway_multicast_group_sources(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DeregisterTransitGatewayMulticastGroupSources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_attributes()
    describe_account_attributes(params::Dict{String,<:Any})

Describes attributes of your Amazon Web Services account. The following are the supported
account attributes:    default-vpc: The ID of the default VPC for your account, or none.
max-instances: This attribute is no longer supported. The returned value does not reflect
your actual vCPU limit for running On-Demand Instances. For more information, see On-Demand
Instance Limits in the Amazon Elastic Compute Cloud User Guide.    max-elastic-ips: The
maximum number of Elastic IP addresses that you can allocate.    supported-platforms: This
attribute is deprecated.    vpc-max-elastic-ips: The maximum number of Elastic IP addresses
that you can allocate.    vpc-max-security-groups-per-interface: The maximum number of
security groups that you can assign to a network interface.    The order of the elements in
the response, including those within nested structures, might vary. Applications should not
assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attributeName"`: The account attribute names.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_account_attributes(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeAccountAttributes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAccountAttributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_address_transfers()
    describe_address_transfers(params::Dict{String,<:Any})

Describes an Elastic IP address transfer. For more information, see Transfer Elastic IP
addresses in the Amazon VPC User Guide. When you transfer an Elastic IP address, there is a
two-step handshake between the source and transfer Amazon Web Services accounts. When the
source account starts the transfer, the transfer account has seven days to accept the
Elastic IP address transfer. During those seven days, the source account can view the
pending transfer by using this action. After seven days, the transfer expires and ownership
of the Elastic IP address returns to the source account. Accepted transfers are visible to
the source account for three days after the transfers have been accepted.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationId"`: The allocation IDs of Elastic IP addresses.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of address transfers to return in one page of results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function describe_address_transfers(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeAddressTransfers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_address_transfers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAddressTransfers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_addresses()
    describe_addresses(params::Dict{String,<:Any})

Describes the specified Elastic IP addresses or all of your Elastic IP addresses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationId"`: Information about the allocation IDs.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  allocation-id - The allocation ID for the address.    association-id - The association ID
  for the address.    instance-id - The ID of the instance the address is associated with, if
  any.    network-border-group - A unique set of Availability Zones, Local Zones, or
  Wavelength Zones from where Amazon Web Services advertises IP addresses.
  network-interface-id - The ID of the network interface that the address is associated with,
  if any.    network-interface-owner-id - The Amazon Web Services account ID of the owner.
  private-ip-address - The private IP address associated with the Elastic IP address.
  public-ip - The Elastic IP address, or the carrier IP address.    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter
  to find all resources assigned a tag with a specific key, regardless of the tag value.
- `"PublicIp"`: One or more Elastic IP addresses. Default: Describes all your Elastic IP
  addresses.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_addresses(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeAddresses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_addresses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAddresses", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_addresses_attribute()
    describe_addresses_attribute(params::Dict{String,<:Any})

Describes the attributes of the specified Elastic IP addresses. For requirements, see Using
reverse DNS for email applications.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocationId"`: [EC2-VPC] The allocation IDs.
- `"Attribute"`: The attribute of the IP address.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_addresses_attribute(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeAddressesAttribute"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_addresses_attribute(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAddressesAttribute",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_aggregate_id_format()
    describe_aggregate_id_format(params::Dict{String,<:Any})

Describes the longer ID format settings for all resource types in a specific Region. This
request is useful for performing a quick audit to determine whether a specific Region is
fully opted in for longer IDs (17-character IDs). This request only returns information
about resource types that support longer IDs. The following resource types support longer
IDs: bundle | conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation |
elastic-ip-association | export-task | flow-log | image | import-task | instance |
internet-gateway | network-acl | network-acl-association | network-interface |
network-interface-attachment | prefix-list | reservation | route-table |
route-table-association | security-group | snapshot | subnet |
subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
vpc-peering-connection | vpn-connection | vpn-gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_aggregate_id_format(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeAggregateIdFormat"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_aggregate_id_format(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAggregateIdFormat",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_availability_zones()
    describe_availability_zones(params::Dict{String,<:Any})

Describes the Availability Zones, Local Zones, and Wavelength Zones that are available to
you. If there is an event impacting a zone, you can use this request to view the state and
any provided messages for that zone. For more information about Availability Zones, Local
Zones, and Wavelength Zones, see Regions and zones in the Amazon EC2 User Guide.  The order
of the elements in the response, including those within nested structures, might vary.
Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllAvailabilityZones"`: Include all Availability Zones, Local Zones, and Wavelength
  Zones regardless of your opt-in status. If you do not use this parameter, the results
  include only the zones for the Regions where you have chosen the option to opt in.
- `"Filter"`: The filters.    group-name - For Availability Zones, use the Region name. For
  Local Zones, use the name of the group associated with the Local Zone (for example,
  us-west-2-lax-1) For Wavelength Zones, use the name of the group associated with the
  Wavelength Zone (for example, us-east-1-wl1).    message - The Zone message.
  opt-in-status - The opt-in status (opted-in | not-opted-in | opt-in-not-required).
  parent-zone-id - The ID of the zone that handles some of the Local Zone and Wavelength Zone
  control plane operations, such as API calls.    parent-zone-name - The ID of the zone that
  handles some of the Local Zone and Wavelength Zone control plane operations, such as API
  calls.    region-name - The name of the Region for the Zone (for example, us-east-1).
  state - The state of the Availability Zone, the Local Zone, or the Wavelength Zone
  (available).    zone-id - The ID of the Availability Zone (for example, use1-az1), the
  Local Zone (for example, usw2-lax1-az1), or the Wavelength Zone (for example,
  us-east-1-wl1-bos-wlz-1).    zone-name - The name of the Availability Zone (for example,
  us-east-1a), the Local Zone (for example, us-west-2-lax-1a), or the Wavelength Zone (for
  example, us-east-1-wl1-bos-wlz-1).    zone-type - The type of zone (availability-zone |
  local-zone | wavelength-zone).
- `"ZoneId"`: The IDs of the Availability Zones, Local Zones, and Wavelength Zones.
- `"ZoneName"`: The names of the Availability Zones, Local Zones, and Wavelength Zones.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_availability_zones(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeAvailabilityZones"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_availability_zones(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAvailabilityZones",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_aws_network_performance_metric_subscriptions()
    describe_aws_network_performance_metric_subscriptions(params::Dict{String,<:Any})

Describes the current Infrastructure Performance metric subscriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_aws_network_performance_metric_subscriptions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAwsNetworkPerformanceMetricSubscriptions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_aws_network_performance_metric_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeAwsNetworkPerformanceMetricSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_bundle_tasks()
    describe_bundle_tasks(params::Dict{String,<:Any})

Describes the specified bundle tasks or all of your bundle tasks.  Completed bundle tasks
are listed for only a limited time. If your bundle task is no longer in the list, you can
still register an AMI from it. Just use RegisterImage with the Amazon S3 bucket name and
image manifest name you provided to the bundle task.   The order of the elements in the
response, including those within nested structures, might vary. Applications should not
assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BundleId"`: The bundle task IDs. Default: Describes all your bundle tasks.
- `"Filter"`: The filters.    bundle-id - The ID of the bundle task.    error-code - If the
  task failed, the error code returned.    error-message - If the task failed, the error
  message returned.    instance-id - The ID of the instance.    progress - The level of task
  completion, as a percentage (for example, 20%).    s3-bucket - The Amazon S3 bucket to
  store the AMI.    s3-prefix - The beginning of the AMI name.    start-time - The time the
  task started (for example, 2013-09-15T17:15:20.000Z).    state - The state of the task
  (pending | waiting-for-shutdown | bundling | storing | cancelling | complete | failed).
  update-time - The time of the most recent update for the task.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_bundle_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeBundleTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_bundle_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeBundleTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_byoip_cidrs(max_results)
    describe_byoip_cidrs(max_results, params::Dict{String,<:Any})

Describes the IP address ranges that were specified in calls to ProvisionByoipCidr. To
describe the address pools that were created when you provisioned the address ranges, use
DescribePublicIpv4Pools or DescribeIpv6Pools.

# Arguments
- `max_results`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"NextToken"`: The token for the next page of results.
"""
function describe_byoip_cidrs(
    MaxResults; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeByoipCidrs",
        Dict{String,Any}("MaxResults" => MaxResults);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_byoip_cidrs(
    MaxResults,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeByoipCidrs",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("MaxResults" => MaxResults), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_capacity_block_offerings(capacity_duration_hours, instance_count, instance_type)
    describe_capacity_block_offerings(capacity_duration_hours, instance_count, instance_type, params::Dict{String,<:Any})

Describes Capacity Block offerings available for purchase in the Amazon Web Services Region
that you're currently using. With Capacity Blocks, you purchase a specific instance type
for a period of time.

# Arguments
- `capacity_duration_hours`: The number of hours for which to reserve Capacity Block.
- `instance_count`: The number of instances for which to reserve capacity.
- `instance_type`: The type of instance for which the Capacity Block offering reserves
  capacity.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EndDateRange"`: The latest end date for the Capacity Block offering.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to use to retrieve the next page of results.
- `"StartDateRange"`: The earliest start date for the Capacity Block offering.
"""
function describe_capacity_block_offerings(
    CapacityDurationHours,
    InstanceCount,
    InstanceType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeCapacityBlockOfferings",
        Dict{String,Any}(
            "CapacityDurationHours" => CapacityDurationHours,
            "InstanceCount" => InstanceCount,
            "InstanceType" => InstanceType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_capacity_block_offerings(
    CapacityDurationHours,
    InstanceCount,
    InstanceType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeCapacityBlockOfferings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CapacityDurationHours" => CapacityDurationHours,
                    "InstanceCount" => InstanceCount,
                    "InstanceType" => InstanceType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_capacity_reservation_fleets()
    describe_capacity_reservation_fleets(params::Dict{String,<:Any})

Describes one or more Capacity Reservation Fleets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CapacityReservationFleetId"`: The IDs of the Capacity Reservation Fleets to describe.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    state - The state of the Fleet (submitted | modifying
  | active | partially_fulfilled | expiring | expired | cancelling | cancelled | failed).
  instance-match-criteria - The instance matching criteria for the Fleet. Only open is
  supported.    tenancy - The tenancy of the Fleet (default | dedicated).
  allocation-strategy - The allocation strategy used by the Fleet. Only prioritized is
  supported.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function describe_capacity_reservation_fleets(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCapacityReservationFleets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_capacity_reservation_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCapacityReservationFleets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_capacity_reservations()
    describe_capacity_reservations(params::Dict{String,<:Any})

Describes one or more of your Capacity Reservations. The results describe only the Capacity
Reservations in the Amazon Web Services Region that you're currently using.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CapacityReservationId"`: The ID of the Capacity Reservation.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    instance-type - The type of instance for which the
  Capacity Reservation reserves capacity.    owner-id - The ID of the Amazon Web Services
  account that owns the Capacity Reservation.    instance-platform - The type of operating
  system for which the Capacity Reservation reserves capacity.    availability-zone - The
  Availability Zone of the Capacity Reservation.    tenancy - Indicates the tenancy of the
  Capacity Reservation. A Capacity Reservation can have one of the following tenancy
  settings:    default - The Capacity Reservation is created on hardware that is shared with
  other Amazon Web Services accounts.    dedicated - The Capacity Reservation is created on
  single-tenant hardware that is dedicated to a single Amazon Web Services account.
  outpost-arn - The Amazon Resource Name (ARN) of the Outpost on which the Capacity
  Reservation was created.    state - The current state of the Capacity Reservation. A
  Capacity Reservation can be in one of the following states:    active- The Capacity
  Reservation is active and the capacity is available for your use.    expired - The Capacity
  Reservation expired automatically at the date and time specified in your request. The
  reserved capacity is no longer available for your use.    cancelled - The Capacity
  Reservation was cancelled. The reserved capacity is no longer available for your use.
  pending - The Capacity Reservation request was successful but the capacity provisioning is
  still pending.    failed - The Capacity Reservation request has failed. A request might
  fail due to invalid request parameters, capacity constraints, or instance limit
  constraints. Failed requests are retained for 60 minutes.      start-date - The date and
  time at which the Capacity Reservation was started.    end-date - The date and time at
  which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved
  capacity is released and you can no longer launch instances into it. The Capacity
  Reservation's state changes to expired when it reaches its end date and time.
  end-date-type - Indicates the way in which the Capacity Reservation ends. A Capacity
  Reservation can have one of the following end types:    unlimited - The Capacity
  Reservation remains active until you explicitly cancel it.    limited - The Capacity
  Reservation expires automatically at a specified date and time.
  instance-match-criteria - Indicates the type of instance launches that the Capacity
  Reservation accepts. The options include:    open - The Capacity Reservation accepts all
  instances that have matching attributes (instance type, platform, and Availability Zone).
  Instances that have matching attributes launch into the Capacity Reservation automatically
  without specifying any additional parameters.    targeted - The Capacity Reservation only
  accepts instances that have matching attributes (instance type, platform, and Availability
  Zone), and explicitly target the Capacity Reservation. This ensures that only permitted
  instances can use the reserved capacity.      placement-group-arn - The ARN of the cluster
  placement group in which the Capacity Reservation was created.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function describe_capacity_reservations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCapacityReservations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_capacity_reservations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCapacityReservations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_carrier_gateways()
    describe_carrier_gateways(params::Dict{String,<:Any})

Describes one or more of your carrier gateways.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CarrierGatewayId"`: One or more carrier gateway IDs.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    carrier-gateway-id - The ID of the carrier gateway.
   state - The state of the carrier gateway (pending | failed | available | deleting |
  deleted).    owner-id - The Amazon Web Services account ID of the owner of the carrier
  gateway.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource.
  Use the tag key in the filter name and the tag value as the filter value. For example, to
  find all resources that have a tag with the key Owner and the value TeamA, specify
  tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag
  assigned to the resource. Use this filter to find all resources assigned a tag with a
  specific key, regardless of the tag value.    vpc-id - The ID of the VPC associated with
  the carrier gateway.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_carrier_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeCarrierGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_carrier_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCarrierGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_classic_link_instances()
    describe_classic_link_instances(params::Dict{String,<:Any})

 This action is deprecated.  Describes your linked EC2-Classic instances. This request only
returns information about EC2-Classic instances linked to a VPC through ClassicLink. You
cannot use this request to return information about other instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    group-id - The ID of a VPC security group that's associated
  with the instance.    instance-id - The ID of the instance.    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter
  to find all resources assigned a tag with a specific key, regardless of the tag value.
  vpc-id - The ID of the VPC to which the instance is linked.
- `"InstanceId"`: The instance IDs. Must be instances linked to a VPC through ClassicLink.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. Constraint: If the value is greater than 1000, we return only
  1000 items.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_classic_link_instances(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClassicLinkInstances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_classic_link_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClassicLinkInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_vpn_authorization_rules(client_vpn_endpoint_id)
    describe_client_vpn_authorization_rules(client_vpn_endpoint_id, params::Dict{String,<:Any})

Describes the authorization rules for a specified Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  description - The description of the authorization rule.    destination-cidr - The CIDR of
  the network to which the authorization rule applies.    group-id - The ID of the Active
  Directory group to which the authorization rule grants access.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the nextToken value.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_client_vpn_authorization_rules(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClientVpnAuthorizationRules",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_vpn_authorization_rules(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeClientVpnAuthorizationRules",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_vpn_connections(client_vpn_endpoint_id)
    describe_client_vpn_connections(client_vpn_endpoint_id, params::Dict{String,<:Any})

Describes active client connections and connections that have been terminated within the
last 60 minutes for the specified Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  connection-id - The ID of the connection.    username - For Active Directory client
  authentication, the user name of the client who established the client connection.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the nextToken value.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_client_vpn_connections(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClientVpnConnections",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_vpn_connections(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeClientVpnConnections",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_vpn_endpoints()
    describe_client_vpn_endpoints(params::Dict{String,<:Any})

Describes one or more Client VPN endpoints in the account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientVpnEndpointId"`: The ID of the Client VPN endpoint.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  endpoint-id - The ID of the Client VPN endpoint.    transport-protocol - The transport
  protocol (tcp | udp).
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the nextToken value.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_client_vpn_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeClientVpnEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_client_vpn_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClientVpnEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_vpn_routes(client_vpn_endpoint_id)
    describe_client_vpn_routes(client_vpn_endpoint_id, params::Dict{String,<:Any})

Describes the routes for the specified Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  destination-cidr - The CIDR of the route destination.    origin - How the route was
  associated with the Client VPN endpoint (associate | add-route).    target-subnet - The ID
  of the subnet through which traffic is routed.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the nextToken value.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_client_vpn_routes(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClientVpnRoutes",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_vpn_routes(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeClientVpnRoutes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_client_vpn_target_networks(client_vpn_endpoint_id)
    describe_client_vpn_target_networks(client_vpn_endpoint_id, params::Dict{String,<:Any})

Describes the target networks associated with the specified Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationIds"`: The IDs of the target network associations.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  association-id - The ID of the association.    target-network-id - The ID of the subnet
  specified as the target network.    vpc-id - The ID of the VPC in which the target network
  is located.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the nextToken value.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_client_vpn_target_networks(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeClientVpnTargetNetworks",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_client_vpn_target_networks(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeClientVpnTargetNetworks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_coip_pools()
    describe_coip_pools(params::Dict{String,<:Any})

Describes the specified customer-owned address pools or all of your customer-owned address
pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    coip-pool.local-gateway-route-table-id - The ID of
  the local gateway route table.    coip-pool.pool-id - The ID of the address pool.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"PoolId"`: The IDs of the address pools.
"""
function describe_coip_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeCoipPools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_coip_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCoipPools", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_conversion_tasks()
    describe_conversion_tasks(params::Dict{String,<:Any})

Describes the specified conversion tasks or all your conversion tasks. For more
information, see the VM Import/Export User Guide. For information about the import manifest
referenced by this API action, see VM Import Manifest.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"conversionTaskId"`: The conversion task IDs.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_conversion_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeConversionTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_conversion_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeConversionTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_customer_gateways()
    describe_customer_gateways(params::Dict{String,<:Any})

Describes one or more of your VPN customer gateways. For more information, see Amazon Web
Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CustomerGatewayId"`: One or more customer gateway IDs. Default: Describes all your
  customer gateways.
- `"Filter"`: One or more filters.    bgp-asn - The customer gateway's Border Gateway
  Protocol (BGP) Autonomous System Number (ASN).    customer-gateway-id - The ID of the
  customer gateway.    ip-address - The IP address of the customer gateway device's external
  interface.    state - The state of the customer gateway (pending | available | deleting |
  deleted).    type - The type of customer gateway. Currently, the only supported type is
  ipsec.1.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource.
  Use the tag key in the filter name and the tag value as the filter value. For example, to
  find all resources that have a tag with the key Owner and the value TeamA, specify
  tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag
  assigned to the resource. Use this filter to find all resources assigned a tag with a
  specific key, regardless of the tag value.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_customer_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeCustomerGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_customer_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeCustomerGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dhcp_options()
    describe_dhcp_options(params::Dict{String,<:Any})

Describes your DHCP option sets. The default is to describe all your DHCP option sets.
Alternatively, you can specify specific DHCP option set IDs or filter the results to
include only the DHCP option sets that match specific criteria. For more information, see
DHCP option sets in the Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DhcpOptionsId"`: The IDs of DHCP option sets.
- `"Filter"`: The filters.    dhcp-options-id - The ID of a DHCP options set.    key - The
  key for one of the options (for example, domain-name).    value - The value for one of the
  options.    owner-id - The ID of the Amazon Web Services account that owns the DHCP options
  set.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use
  the tag key in the filter name and the tag value as the filter value. For example, to find
  all resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for
  the filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to
  the resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_dhcp_options(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeDhcpOptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dhcp_options(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeDhcpOptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_egress_only_internet_gateways()
    describe_egress_only_internet_gateways(params::Dict{String,<:Any})

Describes your egress-only internet gateways. The default is to describe all your
egress-only internet gateways. Alternatively, you can specify specific egress-only internet
gateway IDs or filter the results to include only the egress-only internet gateways that
match specific criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EgressOnlyInternetGatewayId"`: The IDs of the egress-only internet gateways.
- `"Filter"`: The filters.    tag:&lt;key&gt; - The key/value combination of a tag assigned
  to the resource. Use the tag key in the filter name and the tag value as the filter value.
  For example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_egress_only_internet_gateways(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeEgressOnlyInternetGateways";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_egress_only_internet_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeEgressOnlyInternetGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_elastic_gpus()
    describe_elastic_gpus(params::Dict{String,<:Any})

 Amazon Elastic Graphics reached end of life on January 8, 2024. For workloads that require
graphics acceleration, we recommend that you use Amazon EC2 G4, G5, or G6 instances.
Describes the Elastic Graphics accelerator associated with your instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ElasticGpuId"`: The Elastic Graphics accelerator IDs.
- `"Filter"`: The filters.    availability-zone - The Availability Zone in which the
  Elastic Graphics accelerator resides.    elastic-gpu-health - The status of the Elastic
  Graphics accelerator (OK | IMPAIRED).    elastic-gpu-state - The state of the Elastic
  Graphics accelerator (ATTACHED).    elastic-gpu-type - The type of Elastic Graphics
  accelerator; for example, eg1.medium.    instance-id - The ID of the instance to which the
  Elastic Graphics accelerator is associated.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value. This value can be
  between 5 and 1000.
- `"NextToken"`: The token to request the next page of results.
"""
function describe_elastic_gpus(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeElasticGpus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_elastic_gpus(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeElasticGpus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_export_image_tasks()
    describe_export_image_tasks(params::Dict{String,<:Any})

Describes the specified export image tasks or all of your export image tasks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"ExportImageTaskId"`: The IDs of the export image tasks.
- `"Filter"`: Filter tasks using the task-state filter and one of the following values:
  active, completed, deleting, or deleted.
- `"MaxResults"`: The maximum number of results to return in a single call.
- `"NextToken"`: A token that indicates the next page of results.
"""
function describe_export_image_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeExportImageTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_export_image_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeExportImageTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_export_tasks()
    describe_export_tasks(params::Dict{String,<:Any})

Describes the specified export instance tasks or all of your export instance tasks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: the filters for the export tasks.
- `"exportTaskId"`: The export task IDs.
"""
function describe_export_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeExportTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_export_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeExportTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fast_launch_images()
    describe_fast_launch_images(params::Dict{String,<:Any})

Describe details for Windows AMIs that are configured for Windows fast launch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: Use the following filters to streamline results.    resource-type - The
  resource type for pre-provisioning.    owner-id - The owner ID for the pre-provisioning
  resource.    state - The current state of fast launching for the Windows AMI.
- `"ImageId"`: Specify one or more Windows AMI image IDs for the request.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_fast_launch_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeFastLaunchImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_fast_launch_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFastLaunchImages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fast_snapshot_restores()
    describe_fast_snapshot_restores(params::Dict{String,<:Any})

Describes the state of fast snapshot restores for your snapshots.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters. The possible values are:    availability-zone: The Availability
  Zone of the snapshot.    owner-id: The ID of the Amazon Web Services account that enabled
  fast snapshot restore on the snapshot.    snapshot-id: The ID of the snapshot.    state:
  The state of fast snapshot restores for the snapshot (enabling | optimizing | enabled |
  disabling | disabled).
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_fast_snapshot_restores(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFastSnapshotRestores";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fast_snapshot_restores(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFastSnapshotRestores",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleet_history(fleet_id, start_time)
    describe_fleet_history(fleet_id, start_time, params::Dict{String,<:Any})

Describes the events for the specified EC2 Fleet during the specified time. EC2 Fleet
events are delayed by up to 30 seconds before they can be described. This ensures that you
can query by the last evaluated time and not miss a recorded event. EC2 Fleet events are
available for 48 hours. For more information, see Monitor fleet events using Amazon
EventBridge in the Amazon EC2 User Guide.

# Arguments
- `fleet_id`: The ID of the EC2 Fleet.
- `start_time`: The start date and time for the events, in UTC format (for example,
  YYYY-MM-DDTHH:MM:SSZ).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EventType"`: The type of events to describe. By default, all events are described.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_fleet_history(
    FleetId, StartTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFleetHistory",
        Dict{String,Any}("FleetId" => FleetId, "StartTime" => StartTime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fleet_history(
    FleetId,
    StartTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeFleetHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FleetId" => FleetId, "StartTime" => StartTime),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleet_instances(fleet_id)
    describe_fleet_instances(fleet_id, params::Dict{String,<:Any})

Describes the running instances for the specified EC2 Fleet.  Currently,
DescribeFleetInstances does not support fleets of type instant. Instead, use
DescribeFleets, specifying the instant fleet ID in the request.  For more information, see
Describe your EC2 Fleet in the Amazon EC2 User Guide.

# Arguments
- `fleet_id`: The ID of the EC2 Fleet.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    instance-type - The instance type.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_fleet_instances(
    FleetId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFleetInstances",
        Dict{String,Any}("FleetId" => FleetId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fleet_instances(
    FleetId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeFleetInstances",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("FleetId" => FleetId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fleets()
    describe_fleets(params::Dict{String,<:Any})

Describes the specified EC2 Fleet or all of your EC2 Fleets.  If a fleet is of type
instant, you must specify the fleet ID in the request, otherwise the fleet does not appear
in the response.  For more information, see Describe your EC2 Fleet in the Amazon EC2 User
Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    activity-status - The progress of the EC2 Fleet ( error |
  pending-fulfillment | pending-termination | fulfilled).
  excess-capacity-termination-policy - Indicates whether to terminate running instances if
  the target capacity is decreased below the current EC2 Fleet size (true | false).
  fleet-state - The state of the EC2 Fleet (submitted | active | deleted | failed |
  deleted-running | deleted-terminating | modifying).    replace-unhealthy-instances -
  Indicates whether EC2 Fleet should replace unhealthy instances (true | false).    type -
  The type of request (instant | request | maintain).
- `"FleetId"`: The IDs of the EC2 Fleets.  If a fleet is of type instant, you must specify
  the fleet ID, otherwise it does not appear in the response.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_fleets(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeFleets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_fleets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFleets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_flow_logs()
    describe_flow_logs(params::Dict{String,<:Any})

Describes one or more flow logs. To view the published flow log records, you must view the
log destination. For example, the CloudWatch Logs log group, the Amazon S3 bucket, or the
Kinesis Data Firehose delivery stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    deliver-log-status - The status of the logs delivery
  (SUCCESS | FAILED).    log-destination-type - The type of destination for the flow log data
  (cloud-watch-logs | s3 | kinesis-data-firehose).    flow-log-id - The ID of the flow log.
   log-group-name - The name of the log group.    resource-id - The ID of the VPC, subnet, or
  network interface.    traffic-type - The type of traffic (ACCEPT | REJECT | ALL).
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
  key in the filter name and the tag value as the filter value. For example, to find all
  resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the
  filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.
- `"FlowLogId"`: One or more flow log IDs. Constraint: Maximum of 1000 flow log IDs.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to request the next page of items. Pagination continues from the
  end of the items returned by the previous request.
"""
function describe_flow_logs(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeFlowLogs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_flow_logs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFlowLogs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_fpga_image_attribute(attribute, fpga_image_id)
    describe_fpga_image_attribute(attribute, fpga_image_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified Amazon FPGA Image (AFI).

# Arguments
- `attribute`: The AFI attribute.
- `fpga_image_id`: The ID of the AFI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_fpga_image_attribute(
    Attribute, FpgaImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFpgaImageAttribute",
        Dict{String,Any}("Attribute" => Attribute, "FpgaImageId" => FpgaImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_fpga_image_attribute(
    Attribute,
    FpgaImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeFpgaImageAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Attribute" => Attribute, "FpgaImageId" => FpgaImageId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_fpga_images()
    describe_fpga_images(params::Dict{String,<:Any})

Describes the Amazon FPGA Images (AFIs) available to you. These include public AFIs,
private AFIs that you own, and AFIs owned by other Amazon Web Services accounts for which
you have load permissions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    create-time - The creation time of the AFI.    fpga-image-id
  - The FPGA image identifier (AFI ID).    fpga-image-global-id - The global FPGA image
  identifier (AGFI ID).    name - The name of the AFI.    owner-id - The Amazon Web Services
  account ID of the AFI owner.    product-code - The product code.    shell-version - The
  version of the Amazon Web Services Shell that was used to create the bitstream.    state -
  The state of the AFI (pending | failed | available | unavailable).    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter
  to find all resources assigned a tag with a specific key, regardless of the tag value.
  update-time - The time of the most recent update.
- `"FpgaImageId"`: The AFI IDs.
- `"MaxResults"`: The maximum number of results to return in a single call.
- `"NextToken"`: The token to retrieve the next page of results.
- `"Owner"`: Filters the AFI by owner. Specify an Amazon Web Services account ID, self
  (owner is the sender of the request), or an Amazon Web Services owner alias (valid values
  are amazon | aws-marketplace).
"""
function describe_fpga_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeFpgaImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_fpga_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeFpgaImages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_host_reservation_offerings()
    describe_host_reservation_offerings(params::Dict{String,<:Any})

Describes the Dedicated Host reservations that are available to purchase. The results
describe all of the Dedicated Host reservation offerings, including offerings that might
not match the instance family and Region of your Dedicated Hosts. When purchasing an
offering, ensure that the instance family and Region of the offering matches that of the
Dedicated Hosts with which it is to be associated. For more information about supported
instance types, see Dedicated Hosts in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    instance-family - The instance family of the offering (for
  example, m4).    payment-option - The payment option (NoUpfront | PartialUpfront |
  AllUpfront).
- `"MaxDuration"`: This is the maximum duration of the reservation to purchase, specified
  in seconds. Reservations are available in one-year and three-year terms. The number of
  seconds specified must be the number of seconds in a year (365x24x60x60) times one of the
  supported durations (1 or 3). For example, specify 94608000 for three years.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the returned nextToken
  value. This value can be between 5 and 500. If maxResults is given a larger value than 500,
  you receive an error.
- `"MinDuration"`: This is the minimum duration of the reservation you'd like to purchase,
  specified in seconds. Reservations are available in one-year and three-year terms. The
  number of seconds specified must be the number of seconds in a year (365x24x60x60) times
  one of the supported durations (1 or 3). For example, specify 31536000 for one year.
- `"NextToken"`: The token to use to retrieve the next page of results.
- `"OfferingId"`: The ID of the reservation offering.
"""
function describe_host_reservation_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeHostReservationOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_host_reservation_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeHostReservationOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_host_reservations()
    describe_host_reservations(params::Dict{String,<:Any})

Describes reservations that are associated with Dedicated Hosts in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    instance-family - The instance family (for example, m4).
  payment-option - The payment option (NoUpfront | PartialUpfront | AllUpfront).    state -
  The state of the reservation (payment-pending | payment-failed | active | retired).
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
  key in the filter name and the tag value as the filter value. For example, to find all
  resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the
  filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.
- `"HostReservationIdSet"`: The host reservation IDs.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the returned nextToken
  value. This value can be between 5 and 500. If maxResults is given a larger value than 500,
  you receive an error.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function describe_host_reservations(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeHostReservations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_host_reservations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeHostReservations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_hosts()
    describe_hosts(params::Dict{String,<:Any})

Describes the specified Dedicated Hosts or all your Dedicated Hosts. The results describe
only the Dedicated Hosts in the Region you're currently using. All listed instances consume
capacity on your Dedicated Host. Dedicated Hosts that have recently been released are
listed with the state released.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: The filters.    auto-placement - Whether auto-placement is enabled or
  disabled (on | off).    availability-zone - The Availability Zone of the host.
  client-token - The idempotency token that you provided when you allocated the host.
  host-reservation-id - The ID of the reservation assigned to this host.    instance-type -
  The instance type size that the Dedicated Host is configured to support.    state - The
  allocation state of the Dedicated Host (available | under-assessment | permanent-failure |
  released | released-permanent-failure).    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.
- `"hostId"`: The IDs of the Dedicated Hosts. The IDs are used for targeted instance
  launches.
- `"maxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the returned nextToken
  value. This value can be between 5 and 500. If maxResults is given a larger value than 500,
  you receive an error. You cannot specify this parameter and the host IDs parameter in the
  same request.
- `"nextToken"`: The token to use to retrieve the next page of results.
"""
function describe_hosts(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeHosts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_hosts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeHosts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_iam_instance_profile_associations()
    describe_iam_instance_profile_associations(params::Dict{String,<:Any})

Describes your IAM instance profile associations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationId"`: The IAM instance profile associations.
- `"Filter"`: The filters.    instance-id - The ID of the instance.    state - The state of
  the association (associating | associated | disassociating).
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_iam_instance_profile_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIamInstanceProfileAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_iam_instance_profile_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIamInstanceProfileAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_id_format()
    describe_id_format(params::Dict{String,<:Any})

Describes the ID format settings for your resources on a per-Region basis, for example, to
view which resource types are enabled for longer IDs. This request only returns information
about resource types whose ID formats can be modified; it does not return information about
other resource types. The following resource types support longer IDs: bundle |
conversion-task | customer-gateway | dhcp-options | elastic-ip-allocation |
elastic-ip-association | export-task | flow-log | image | import-task | instance |
internet-gateway | network-acl | network-acl-association | network-interface |
network-interface-attachment | prefix-list | reservation | route-table |
route-table-association | security-group | snapshot | subnet |
subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the IAM
user who makes the request; they do not apply to the entire Amazon Web Services account. By
default, an IAM user defaults to the same settings as the root user, unless they explicitly
override the settings by running the ModifyIdFormat command. Resources created with longer
IDs are visible to all IAM users, regardless of these settings and provided that they have
permission to use the relevant Describe command for the resource type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Resource"`: The type of resource: bundle | conversion-task | customer-gateway |
  dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log |
  image | import-task | instance | internet-gateway | network-acl | network-acl-association |
  network-interface | network-interface-attachment | prefix-list | reservation | route-table
  | route-table-association | security-group | snapshot | subnet |
  subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
  vpc-peering-connection | vpn-connection | vpn-gateway
"""
function describe_id_format(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIdFormat"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_id_format(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIdFormat", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_identity_id_format(principal_arn)
    describe_identity_id_format(principal_arn, params::Dict{String,<:Any})

Describes the ID format settings for resources for the specified IAM user, IAM role, or
root user. For example, you can view the resource types that are enabled for longer IDs.
This request only returns information about resource types whose ID formats can be
modified; it does not return information about other resource types. For more information,
see Resource IDs in the Amazon Elastic Compute Cloud User Guide.  The following resource
types support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options |
elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image |
import-task | instance | internet-gateway | network-acl | network-acl-association |
network-interface | network-interface-attachment | prefix-list | reservation | route-table
| route-table-association | security-group | snapshot | subnet |
subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
vpc-peering-connection | vpn-connection | vpn-gateway.  These settings apply to the
principal specified in the request. They do not apply to the principal that makes the
request.

# Arguments
- `principal_arn`: The ARN of the principal, which can be an IAM role, IAM user, or the
  root user.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resource"`: The type of resource: bundle | conversion-task | customer-gateway |
  dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log |
  image | import-task | instance | internet-gateway | network-acl | network-acl-association |
  network-interface | network-interface-attachment | prefix-list | reservation | route-table
  | route-table-association | security-group | snapshot | subnet |
  subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
  vpc-peering-connection | vpn-connection | vpn-gateway
"""
function describe_identity_id_format(
    principalArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIdentityIdFormat",
        Dict{String,Any}("principalArn" => principalArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_identity_id_format(
    principalArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeIdentityIdFormat",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("principalArn" => principalArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_image_attribute(attribute, image_id)
    describe_image_attribute(attribute, image_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified AMI. You can specify only one attribute
at a time.  The order of the elements in the response, including those within nested
structures, might vary. Applications should not assume the elements appear in a particular
order.

# Arguments
- `attribute`: The AMI attribute.  Note: The blockDeviceMapping attribute is deprecated.
  Using this attribute returns the Client.AuthFailure error. To get information about the
  block device mappings for an AMI, use the DescribeImages action.
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_image_attribute(
    Attribute, ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeImageAttribute",
        Dict{String,Any}("Attribute" => Attribute, "ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_image_attribute(
    Attribute,
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeImageAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Attribute" => Attribute, "ImageId" => ImageId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_images()
    describe_images(params::Dict{String,<:Any})

Describes the specified images (AMIs, AKIs, and ARIs) available to you or all of the images
available to you. The images available to you include public images, private images that
you own, and private images owned by other Amazon Web Services accounts for which you have
explicit launch permissions. Recently deregistered images appear in the returned results
for a short interval and then return empty results. After all instances that reference a
deregistered AMI are terminated, specifying the ID of the image will eventually return an
error indicating that the AMI ID cannot be found.  We strongly recommend using only
paginated requests. Unpaginated requests are susceptible to throttling and timeouts.   The
order of the elements in the response, including those within nested structures, might
vary. Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExecutableBy"`: Scopes the images by users with explicit launch permissions. Specify an
  Amazon Web Services account ID, self (the sender of the request), or all (public AMIs).
  If you specify an Amazon Web Services account ID that is not your own, only AMIs shared
  with that specific Amazon Web Services account ID are returned. However, AMIs that are
  shared with the account’s organization or organizational unit (OU) are not returned.   If
  you specify self or your own Amazon Web Services account ID, AMIs shared with your account
  are returned. In addition, AMIs that are shared with the organization or OU of which you
  are member are also returned.    If you specify all, all public AMIs are returned.
- `"Filter"`: The filters.    architecture - The image architecture (i386 | x86_64 | arm64
  | x86_64_mac | arm64_mac).    block-device-mapping.delete-on-termination - A Boolean value
  that indicates whether the Amazon EBS volume is deleted on instance termination.
  block-device-mapping.device-name - The device name specified in the block device mapping
  (for example, /dev/sdh or xvdh).    block-device-mapping.snapshot-id - The ID of the
  snapshot used for the Amazon EBS volume.    block-device-mapping.volume-size - The volume
  size of the Amazon EBS volume, in GiB.    block-device-mapping.volume-type - The volume
  type of the Amazon EBS volume (io1 | io2 | gp2 | gp3 | sc1 | st1 | standard).
  block-device-mapping.encrypted - A Boolean that indicates whether the Amazon EBS volume is
  encrypted.    creation-date - The time when the image was created, in the ISO 8601 format
  in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example, 2021-09-29T11:04:43.305Z. You
  can use a wildcard (*), for example, 2021-09-29T*, which matches an entire day.
  description - The description of the image (provided during image creation).    ena-support
  - A Boolean that indicates whether enhanced networking with ENA is enabled.    hypervisor -
  The hypervisor type (ovm | xen).    image-id - The ID of the image.    image-type - The
  image type (machine | kernel | ramdisk).    is-public - A Boolean that indicates whether
  the image is public.    kernel-id - The kernel ID.    manifest-location - The location of
  the image manifest.    name - The name of the AMI (provided during image creation).
  owner-alias - The owner alias (amazon | aws-marketplace). The valid aliases are defined in
  an Amazon-maintained list. This is not the Amazon Web Services account alias that can be
  set using the IAM console. We recommend that you use the Owner request parameter instead of
  this filter.    owner-id - The Amazon Web Services account ID of the owner. We recommend
  that you use the Owner request parameter instead of this filter.    platform - The
  platform. The only supported value is windows.    product-code - The product code.
  product-code.type - The type of the product code (marketplace).    ramdisk-id - The RAM
  disk ID.    root-device-name - The device name of the root device volume (for example,
  /dev/sda1).    root-device-type - The type of the root device volume (ebs |
  instance-store).    source-instance-id - The ID of the instance that the AMI was created
  from if the AMI was created using CreateImage. This filter is applicable only if the AMI
  was created using CreateImage.    state - The state of the image (available | pending |
  failed).    state-reason-code - The reason code for the state change.
  state-reason-message - The message for the state change.    sriov-net-support - A value of
  simple indicates that enhanced networking with the Intel 82599 VF interface is enabled.
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
  key in the filter name and the tag value as the filter value. For example, to find all
  resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the
  filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.    virtualization-type - The virtualization type (paravirtual
  | hvm).
- `"ImageId"`: The image IDs. Default: Describes all images available to you.
- `"IncludeDeprecated"`: Specifies whether to include deprecated AMIs. Default: No
  deprecated AMIs are included in the response.  If you are the AMI owner, all deprecated
  AMIs appear in the response regardless of what you specify for this parameter.
- `"IncludeDisabled"`: Specifies whether to include disabled AMIs. Default: No disabled
  AMIs are included in the response.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"Owner"`: Scopes the results to images with the specified owners. You can specify a
  combination of Amazon Web Services account IDs, self, amazon, and aws-marketplace. If you
  omit this parameter, the results include all images for which you have launch permissions,
  regardless of ownership.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_images(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeImages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_images(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeImages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_import_image_tasks()
    describe_import_image_tasks(params::Dict{String,<:Any})

Displays details about an import virtual machine or import snapshot tasks that are already
created.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filters"`: Filter tasks using the task-state filter and one of the following values:
  active, completed, deleting, or deleted.
- `"ImportTaskId"`: The IDs of the import image tasks.
- `"MaxResults"`: The maximum number of results to return in a single call.
- `"NextToken"`: A token that indicates the next page of results.
"""
function describe_import_image_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeImportImageTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_import_image_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeImportImageTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_import_snapshot_tasks()
    describe_import_snapshot_tasks(params::Dict{String,<:Any})

Describes your import snapshot tasks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filters"`: The filters.
- `"ImportTaskId"`: A list of import snapshot task IDs.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value.
- `"NextToken"`: A token that indicates the next page of results.
"""
function describe_import_snapshot_tasks(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeImportSnapshotTasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_import_snapshot_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeImportSnapshotTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_attribute(attribute, instance_id)
    describe_instance_attribute(attribute, instance_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified instance. You can specify only one
attribute at a time. Valid attribute values are: instanceType | kernel | ramdisk | userData
| disableApiTermination | instanceInitiatedShutdownBehavior | rootDeviceName |
blockDeviceMapping | productCodes | sourceDestCheck | groupSet | ebsOptimized |
sriovNetSupport

# Arguments
- `attribute`: The instance attribute. Note: The enaSupport attribute is not supported at
  this time.
- `instance_id`: The ID of the instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_instance_attribute(
    attribute, instanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceAttribute",
        Dict{String,Any}("attribute" => attribute, "instanceId" => instanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_attribute(
    attribute,
    instanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeInstanceAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("attribute" => attribute, "instanceId" => instanceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_connect_endpoints()
    describe_instance_connect_endpoints(params::Dict{String,<:Any})

Describes the specified EC2 Instance Connect Endpoints or all EC2 Instance Connect
Endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    instance-connect-endpoint-id - The ID of the EC2
  Instance Connect Endpoint.    state - The state of the EC2 Instance Connect Endpoint
  (create-in-progress | create-complete | create-failed | delete-in-progress |
  delete-complete | delete-failed).    subnet-id - The ID of the subnet in which the EC2
  Instance Connect Endpoint was created.    tag:&lt;key&gt; - The key/value combination of a
  tag assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.    tag-value - The value
  of a tag assigned to the resource. Use this filter to find all resources that have a tag
  with a specific value, regardless of tag key.    vpc-id - The ID of the VPC in which the
  EC2 Instance Connect Endpoint was created.
- `"InstanceConnectEndpointId"`: One or more EC2 Instance Connect Endpoint IDs.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instance_connect_endpoints(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceConnectEndpoints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_connect_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceConnectEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_credit_specifications()
    describe_instance_credit_specifications(params::Dict{String,<:Any})

Describes the credit option for CPU usage of the specified burstable performance instances.
The credit options are standard and unlimited. If you do not specify an instance ID, Amazon
EC2 returns burstable performance instances with the unlimited credit option, as well as
instances that were previously configured as T2, T3, and T3a with the unlimited credit
option. For example, if you resize a T2 instance, while it is configured as unlimited, to
an M4 instance, Amazon EC2 returns the M4 instance. If you specify one or more instance
IDs, Amazon EC2 returns the credit option (standard or unlimited) of those instances. If
you specify an instance ID that is not valid, such as an instance that is not a burstable
performance instance, an error is returned. Recently terminated instances might appear in
the returned results. This interval is usually less than one hour. If an Availability Zone
is experiencing a service disruption and you specify instance IDs in the affected zone, or
do not specify any instance IDs at all, the call fails. If you specify only instance IDs in
an unaffected zone, the call works normally. For more information, see Burstable
performance instances in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    instance-id - The ID of the instance.
- `"InstanceId"`: The instance IDs. Default: Describes all your instances. Constraints:
  Maximum 1000 explicitly specified instance IDs.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. You cannot specify this parameter and the instance IDs
  parameter in the same call.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instance_credit_specifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceCreditSpecifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_credit_specifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceCreditSpecifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_event_notification_attributes()
    describe_instance_event_notification_attributes(params::Dict{String,<:Any})

Describes the tag keys that are registered to appear in scheduled event notifications for
resources in the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_instance_event_notification_attributes(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceEventNotificationAttributes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_event_notification_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceEventNotificationAttributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_event_windows()
    describe_instance_event_windows(params::Dict{String,<:Any})

Describes the specified event windows or all event windows. If you specify event window
IDs, the output includes information for only the specified event windows. If you specify
filters, the output includes information for only those event windows that meet the filter
criteria. If you do not specify event windows IDs or filters, the output includes
information for all event windows, which can affect performance. We recommend that you use
pagination to ensure that the operation returns quickly and successfully.  For more
information, see Define event windows for scheduled events in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    dedicated-host-id - The event windows associated with
  the specified Dedicated Host ID.    event-window-name - The event windows associated with
  the specified names.     instance-id - The event windows associated with the specified
  instance ID.    instance-tag - The event windows associated with the specified tag and
  value.    instance-tag-key - The event windows associated with the specified tag key,
  regardless of the value.    instance-tag-value - The event windows associated with the
  specified tag value, regardless of the key.    tag:&lt;key&gt; - The key/value combination
  of a tag assigned to the event window. Use the tag key in the filter name and the tag value
  as the filter value. For example, to find all resources that have a tag with the key Owner
  and the value CMX, specify tag:Owner for the filter name and CMX for the filter value.
  tag-key - The key of a tag assigned to the event window. Use this filter to find all event
  windows that have a tag with a specific key, regardless of the tag value.     tag-value -
  The value of a tag assigned to the event window. Use this filter to find all event windows
  that have a tag with a specific value, regardless of the tag key.
- `"InstanceEventWindowId"`: The IDs of the event windows.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value. This value can be
  between 20 and 500. You cannot specify this parameter and the event window IDs parameter in
  the same call.
- `"NextToken"`: The token to request the next page of results.
"""
function describe_instance_event_windows(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceEventWindows";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_event_windows(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceEventWindows",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_status()
    describe_instance_status(params::Dict{String,<:Any})

Describes the status of the specified instances or all of your instances. By default, only
running instances are described, unless you specifically indicate to return the status of
all instances. Instance status includes the following components:    Status checks - Amazon
EC2 performs status checks on running EC2 instances to identify hardware and software
issues. For more information, see Status checks for your instances and Troubleshoot
instances with failed status checks in the Amazon EC2 User Guide.    Scheduled events -
Amazon EC2 can schedule events (such as reboot, stop, or terminate) for your instances
related to hardware issues, software updates, or system maintenance. For more information,
see Scheduled events for your instances in the Amazon EC2 User Guide.    Instance state -
You can manage your instances from the moment you launch them through their termination.
For more information, see Instance lifecycle in the Amazon EC2 User Guide.    The order of
the elements in the response, including those within nested structures, might vary.
Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    availability-zone - The Availability Zone of the instance.
  event.code - The code for the scheduled event (instance-reboot | system-reboot |
  system-maintenance | instance-retirement | instance-stop).    event.description - A
  description of the event.    event.instance-event-id - The ID of the event whose date and
  time you are modifying.    event.not-after - The latest end time for the scheduled event
  (for example, 2014-09-15T17:15:20.000Z).    event.not-before - The earliest start time for
  the scheduled event (for example, 2014-09-15T17:15:20.000Z).    event.not-before-deadline -
  The deadline for starting the event (for example, 2014-09-15T17:15:20.000Z).
  instance-state-code - The code for the instance state, as a 16-bit unsigned integer. The
  high byte is used for internal purposes and should be ignored. The low byte is set based on
  the state represented. The valid values are 0 (pending), 16 (running), 32 (shutting-down),
  48 (terminated), 64 (stopping), and 80 (stopped).    instance-state-name - The state of the
  instance (pending | running | shutting-down | terminated | stopping | stopped).
  instance-status.reachability - Filters on instance status where the name is reachability
  (passed | failed | initializing | insufficient-data).    instance-status.status - The
  status of the instance (ok | impaired | initializing | insufficient-data | not-applicable).
     system-status.reachability - Filters on system status where the name is reachability
  (passed | failed | initializing | insufficient-data).    system-status.status - The system
  status of the instance (ok | impaired | initializing | insufficient-data | not-applicable).

- `"InstanceId"`: The instance IDs. Default: Describes all your instances. Constraints:
  Maximum 100 explicitly specified instance IDs.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. You cannot specify this parameter and the instance IDs
  parameter in the same request.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"includeAllInstances"`: When true, includes the health status for all instances. When
  false, includes the health status for running instances only. Default: false
"""
function describe_instance_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeInstanceStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_instance_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_topology()
    describe_instance_topology(params::Dict{String,<:Any})

Describes a tree-based hierarchy that represents the physical host placement of your EC2
instances within an Availability Zone or Local Zone. You can use this information to
determine the relative proximity of your EC2 instances within the Amazon Web Services
network to support your tightly coupled workloads.  Limitations    Supported zones
Availability Zone   Local Zone     Supported instance types    hpc6a.48xlarge |
hpc6id.32xlarge | hpc7a.12xlarge | hpc7a.24xlarge | hpc7a.48xlarge | hpc7a.96xlarge |
hpc7g.4xlarge | hpc7g.8xlarge | hpc7g.16xlarge     p3dn.24xlarge | p4d.24xlarge |
p4de.24xlarge | p5.48xlarge     trn1.2xlarge | trn1.32xlarge | trn1n.32xlarge      For more
information, see Amazon EC2 instance topology in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    availability-zone - The name of the Availability Zone (for
  example, us-west-2a) or Local Zone (for example, us-west-2-lax-1b) that the instance is in.
     instance-type - The instance type (for example, p4d.24xlarge) or instance family (for
  example, p4d*). You can use the * wildcard to match zero or more characters, or the ?
  wildcard to match zero or one character.    zone-id - The ID of the Availability Zone (for
  example, usw2-az2) or Local Zone (for example, usw2-lax1-az1) that the instance is in.
- `"GroupName"`: The name of the placement group that each instance is in. Constraints:
  Maximum 100 explicitly specified placement group names.
- `"InstanceId"`: The instance IDs. Default: Describes all your instances. Constraints:
  Maximum 100 explicitly specified instance IDs.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. You can't specify this parameter and the instance IDs
  parameter in the same request. Default: 20
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instance_topology(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeInstanceTopology"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_instance_topology(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceTopology",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_type_offerings()
    describe_instance_type_offerings(params::Dict{String,<:Any})

Lists the instance types that are offered for the specified location. If no location is
specified, the default is to list the instance types that are offered in the current Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  instance-type - The instance type. For a list of possible values, see Instance.    location
  - The location. For a list of possible identifiers, see Regions and Zones.
- `"LocationType"`: The location type.    availability-zone - The Availability Zone. When
  you specify a location filter, it must be an Availability Zone for the current Region.
  availability-zone-id - The AZ ID. When you specify a location filter, it must be an AZ ID
  for the current Region.    outpost - The Outpost ARN. When you specify a location filter,
  it must be an Outpost ARN for the current Region.    region - The current Region. If you
  specify a location filter, it must match the current Region.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instance_type_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceTypeOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_instance_type_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceTypeOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instance_types()
    describe_instance_types(params::Dict{String,<:Any})

Describes the specified instance types. By default, all instance types for the current
Region are described. Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
  auto-recovery-supported - Indicates whether Amazon CloudWatch action based recovery is
  supported (true | false).    bare-metal - Indicates whether it is a bare metal instance
  type (true | false).    burstable-performance-supported - Indicates whether the instance
  type is a burstable performance T instance type (true | false).    current-generation -
  Indicates whether this instance type is the latest generation instance type of an instance
  family (true | false).    ebs-info.ebs-optimized-info.baseline-bandwidth-in-mbps - The
  baseline bandwidth performance for an EBS-optimized instance type, in Mbps.
  ebs-info.ebs-optimized-info.baseline-iops - The baseline input/output storage operations
  per second for an EBS-optimized instance type.
  ebs-info.ebs-optimized-info.baseline-throughput-in-mbps - The baseline throughput
  performance for an EBS-optimized instance type, in MB/s.
  ebs-info.ebs-optimized-info.maximum-bandwidth-in-mbps - The maximum bandwidth performance
  for an EBS-optimized instance type, in Mbps.    ebs-info.ebs-optimized-info.maximum-iops -
  The maximum input/output storage operations per second for an EBS-optimized instance type.
    ebs-info.ebs-optimized-info.maximum-throughput-in-mbps - The maximum throughput
  performance for an EBS-optimized instance type, in MB/s.    ebs-info.ebs-optimized-support
  - Indicates whether the instance type is EBS-optimized (supported | unsupported | default).
     ebs-info.encryption-support - Indicates whether EBS encryption is supported (supported |
  unsupported).    ebs-info.nvme-support - Indicates whether non-volatile memory express
  (NVMe) is supported for EBS volumes (required | supported | unsupported).
  free-tier-eligible - Indicates whether the instance type is eligible to use in the free
  tier (true | false).    hibernation-supported - Indicates whether On-Demand hibernation is
  supported (true | false).    hypervisor - The hypervisor (nitro | xen).
  instance-storage-info.disk.count - The number of local disks.
  instance-storage-info.disk.size-in-gb - The storage size of each instance storage disk, in
  GB.    instance-storage-info.disk.type - The storage technology for the local instance
  storage disks (hdd | ssd).    instance-storage-info.encryption-support - Indicates whether
  data is encrypted at rest (required | supported | unsupported).
  instance-storage-info.nvme-support - Indicates whether non-volatile memory express (NVMe)
  is supported for instance store (required | supported | unsupported).
  instance-storage-info.total-size-in-gb - The total amount of storage available from all
  local instance storage, in GB.    instance-storage-supported - Indicates whether the
  instance type has local instance storage (true | false).    instance-type - The instance
  type (for example c5.2xlarge or c5*).    memory-info.size-in-mib - The memory size.
  network-info.efa-info.maximum-efa-interfaces - The maximum number of Elastic Fabric
  Adapters (EFAs) per instance.    network-info.efa-supported - Indicates whether the
  instance type supports Elastic Fabric Adapter (EFA) (true | false).
  network-info.ena-support - Indicates whether Elastic Network Adapter (ENA) is supported or
  required (required | supported | unsupported).
  network-info.encryption-in-transit-supported - Indicates whether the instance type
  automatically encrypts in-transit traffic between instances (true | false).
  network-info.ipv4-addresses-per-interface - The maximum number of private IPv4 addresses
  per network interface.    network-info.ipv6-addresses-per-interface - The maximum number of
  private IPv6 addresses per network interface.    network-info.ipv6-supported - Indicates
  whether the instance type supports IPv6 (true | false).
  network-info.maximum-network-cards - The maximum number of network cards per instance.
  network-info.maximum-network-interfaces - The maximum number of network interfaces per
  instance.    network-info.network-performance - The network performance (for example, \"25
  Gigabit\").    nitro-enclaves-support - Indicates whether Nitro Enclaves is supported
  (supported | unsupported).    nitro-tpm-support - Indicates whether NitroTPM is supported
  (supported | unsupported).    nitro-tpm-info.supported-versions - The supported NitroTPM
  version (2.0).    processor-info.supported-architecture - The CPU architecture (arm64 |
  i386 | x86_64).    processor-info.sustained-clock-speed-in-ghz - The CPU clock speed, in
  GHz.    processor-info.supported-features - The supported CPU features (amd-sev-snp).
  supported-boot-mode - The boot mode (legacy-bios | uefi).    supported-root-device-type -
  The root device type (ebs | instance-store).    supported-usage-class - The usage class
  (on-demand | spot).    supported-virtualization-type - The virtualization type (hvm |
  paravirtual).    vcpu-info.default-cores - The default number of cores for the instance
  type.    vcpu-info.default-threads-per-core - The default number of threads per core for
  the instance type.    vcpu-info.default-vcpus - The default number of vCPUs for the
  instance type.    vcpu-info.valid-cores - The number of cores that can be configured for
  the instance type.    vcpu-info.valid-threads-per-core - The number of threads per core
  that can be configured for the instance type. For example, \"1\" or \"1,2\".
- `"InstanceType"`: The instance types.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instance_types(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeInstanceTypes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_instance_types(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstanceTypes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_instances()
    describe_instances(params::Dict{String,<:Any})

Describes the specified instances or all instances. If you specify instance IDs, the output
includes information for only the specified instances. If you specify filters, the output
includes information for only those instances that meet the filter criteria. If you do not
specify instance IDs or filters, the output includes information for all instances, which
can affect performance. We recommend that you use pagination to ensure that the operation
returns quickly and successfully. If you specify an instance ID that is not valid, an error
is returned. If you specify an instance that you do not own, it is not included in the
output. Recently terminated instances might appear in the returned results. This interval
is usually less than one hour. If you describe instances in the rare case where an
Availability Zone is experiencing a service disruption and you specify instance IDs that
are in the affected zone, or do not specify any instance IDs at all, the call fails. If you
describe instances and specify only instance IDs that are in an unaffected zone, the call
works normally.  We strongly recommend using only paginated requests. Unpaginated requests
are susceptible to throttling and timeouts.   The order of the elements in the response,
including those within nested structures, might vary. Applications should not assume the
elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    affinity - The affinity setting for an instance running on a
  Dedicated Host (default | host).    architecture - The instance architecture (i386 | x86_64
  | arm64).    availability-zone - The Availability Zone of the instance.
  block-device-mapping.attach-time - The attach time for an EBS volume mapped to the
  instance, for example, 2022-09-15T17:15:20.000Z.
  block-device-mapping.delete-on-termination - A Boolean that indicates whether the EBS
  volume is deleted on instance termination.    block-device-mapping.device-name - The device
  name specified in the block device mapping (for example, /dev/sdh or xvdh).
  block-device-mapping.status - The status for the EBS volume (attaching | attached |
  detaching | detached).    block-device-mapping.volume-id - The volume ID of the EBS volume.
     boot-mode - The boot mode that was specified by the AMI (legacy-bios | uefi |
  uefi-preferred).    capacity-reservation-id - The ID of the Capacity Reservation into which
  the instance was launched.
  capacity-reservation-specification.capacity-reservation-preference - The instance's
  Capacity Reservation preference (open | none).
  capacity-reservation-specification.capacity-reservation-target.capacity-reservation-id -
  The ID of the targeted Capacity Reservation.
  capacity-reservation-specification.capacity-reservation-target.capacity-reservation-resource
  -group-arn - The ARN of the targeted Capacity Reservation group.    client-token - The
  idempotency token you provided when you launched the instance.
  current-instance-boot-mode - The boot mode that is used to launch the instance at launch or
  start (legacy-bios | uefi).    dns-name - The public DNS name of the instance.
  ebs-optimized - A Boolean that indicates whether the instance is optimized for Amazon EBS
  I/O.    ena-support - A Boolean that indicates whether the instance is enabled for enhanced
  networking with ENA.    enclave-options.enabled - A Boolean that indicates whether the
  instance is enabled for Amazon Web Services Nitro Enclaves.
  hibernation-options.configured - A Boolean that indicates whether the instance is enabled
  for hibernation. A value of true means that the instance is enabled for hibernation.
  host-id - The ID of the Dedicated Host on which the instance is running, if applicable.
  hypervisor - The hypervisor type of the instance (ovm | xen). The value xen is used for
  both Xen and Nitro hypervisors.    iam-instance-profile.arn - The instance profile
  associated with the instance. Specified as an ARN.    iam-instance-profile.id - The
  instance profile associated with the instance. Specified as an ID.
  iam-instance-profile.name - The instance profile associated with the instance. Specified as
  an name.    image-id - The ID of the image used to launch the instance.    instance-id -
  The ID of the instance.    instance-lifecycle - Indicates whether this is a Spot Instance,
  a Scheduled Instance, or a Capacity Block (spot | scheduled | capacity-block).
  instance-state-code - The state of the instance, as a 16-bit unsigned integer. The high
  byte is used for internal purposes and should be ignored. The low byte is set based on the
  state represented. The valid values are: 0 (pending), 16 (running), 32 (shutting-down), 48
  (terminated), 64 (stopping), and 80 (stopped).    instance-state-name - The state of the
  instance (pending | running | shutting-down | terminated | stopping | stopped).
  instance-type - The type of instance (for example, t2.micro).    instance.group-id - The ID
  of the security group for the instance.     instance.group-name - The name of the security
  group for the instance.     ip-address - The public IPv4 address of the instance.
  ipv6-address - The IPv6 address of the instance.    kernel-id - The kernel ID.    key-name
  - The name of the key pair used when the instance was launched.    launch-index - When
  launching multiple instances, this is the index for the instance in the launch group (for
  example, 0, 1, 2, and so on).     launch-time - The time when the instance was launched, in
  the ISO 8601 format in the UTC time zone (YYYY-MM-DDThh:mm:ss.sssZ), for example,
  2021-09-29T11:04:43.305Z. You can use a wildcard (*), for example, 2021-09-29T*, which
  matches an entire day.    maintenance-options.auto-recovery - The current automatic
  recovery behavior of the instance (disabled | default).    metadata-options.http-endpoint -
  The status of access to the HTTP metadata endpoint on your instance (enabled | disabled)
  metadata-options.http-protocol-ipv4 - Indicates whether the IPv4 endpoint is enabled
  (disabled | enabled).    metadata-options.http-protocol-ipv6 - Indicates whether the IPv6
  endpoint is enabled (disabled | enabled).    metadata-options.http-put-response-hop-limit -
  The HTTP metadata request put response hop limit (integer, possible values 1 to 64)
  metadata-options.http-tokens - The metadata request authorization state (optional |
  required)    metadata-options.instance-metadata-tags - The status of access to instance
  tags from the instance metadata (enabled | disabled)    metadata-options.state - The state
  of the metadata option changes (pending | applied).    monitoring-state - Indicates whether
  detailed monitoring is enabled (disabled | enabled).
  network-interface.addresses.association.allocation-id - The allocation ID.
  network-interface.addresses.association.association-id - The association ID.
  network-interface.addresses.association.carrier-ip - The carrier IP address.
  network-interface.addresses.association.customer-owned-ip - The customer-owned IP address.
    network-interface.addresses.association.ip-owner-id - The owner ID of the private IPv4
  address associated with the network interface.
  network-interface.addresses.association.public-dns-name - The public DNS name.
  network-interface.addresses.association.public-ip - The ID of the association of an Elastic
  IP address (IPv4) with a network interface.    network-interface.addresses.primary -
  Specifies whether the IPv4 address of the network interface is the primary private IPv4
  address.    network-interface.addresses.private-dns-name - The private DNS name.
  network-interface.addresses.private-ip-address - The private IPv4 address associated with
  the network interface.    network-interface.association.allocation-id - The allocation ID
  returned when you allocated the Elastic IP address (IPv4) for your network interface.
  network-interface.association.association-id - The association ID returned when the network
  interface was associated with an IPv4 address.    network-interface.association.carrier-ip
  - The customer-owned IP address.    network-interface.association.customer-owned-ip - The
  customer-owned IP address.    network-interface.association.ip-owner-id - The owner of the
  Elastic IP address (IPv4) associated with the network interface.
  network-interface.association.public-dns-name - The public DNS name.
  network-interface.association.public-ip - The address of the Elastic IP address (IPv4)
  bound to the network interface.    network-interface.attachment.attach-time - The time that
  the network interface was attached to an instance.
  network-interface.attachment.attachment-id - The ID of the interface attachment.
  network-interface.attachment.delete-on-termination - Specifies whether the attachment is
  deleted when an instance is terminated.    network-interface.attachment.device-index - The
  device index to which the network interface is attached.
  network-interface.attachment.instance-id - The ID of the instance to which the network
  interface is attached.    network-interface.attachment.instance-owner-id - The owner ID of
  the instance to which the network interface is attached.
  network-interface.attachment.network-card-index - The index of the network card.
  network-interface.attachment.status - The status of the attachment (attaching | attached |
  detaching | detached).    network-interface.availability-zone - The Availability Zone for
  the network interface.    network-interface.deny-all-igw-traffic - A Boolean that indicates
  whether a network interface with an IPv6 address is unreachable from the public internet.
   network-interface.description - The description of the network interface.
  network-interface.group-id - The ID of a security group associated with the network
  interface.    network-interface.group-name - The name of a security group associated with
  the network interface.    network-interface.ipv4-prefixes.ipv4-prefix - The IPv4 prefixes
  that are assigned to the network interface.    network-interface.ipv6-address - The IPv6
  address associated with the network interface.
  network-interface.ipv6-addresses.ipv6-address - The IPv6 address associated with the
  network interface.    network-interface.ipv6-addresses.is-primary-ipv6 - A Boolean that
  indicates whether this is the primary IPv6 address.    network-interface.ipv6-native - A
  Boolean that indicates whether this is an IPv6 only network interface.
  network-interface.ipv6-prefixes.ipv6-prefix - The IPv6 prefix assigned to the network
  interface.    network-interface.mac-address - The MAC address of the network interface.
  network-interface.network-interface-id - The ID of the network interface.
  network-interface.outpost-arn - The ARN of the Outpost.    network-interface.owner-id - The
  ID of the owner of the network interface.    network-interface.private-dns-name - The
  private DNS name of the network interface.    network-interface.private-ip-address - The
  private IPv4 address.    network-interface.public-dns-name - The public DNS name.
  network-interface.requester-id - The requester ID for the network interface.
  network-interface.requester-managed - Indicates whether the network interface is being
  managed by Amazon Web Services.    network-interface.status - The status of the network
  interface (available) | in-use).    network-interface.source-dest-check - Whether the
  network interface performs source/destination checking. A value of true means that checking
  is enabled, and false means that checking is disabled. The value must be false for the
  network interface to perform network address translation (NAT) in your VPC.
  network-interface.subnet-id - The ID of the subnet for the network interface.
  network-interface.tag-key - The key of a tag assigned to the network interface.
  network-interface.tag-value - The value of a tag assigned to the network interface.
  network-interface.vpc-id - The ID of the VPC for the network interface.    outpost-arn -
  The Amazon Resource Name (ARN) of the Outpost.    owner-id - The Amazon Web Services
  account ID of the instance owner.    placement-group-name - The name of the placement group
  for the instance.    placement-partition-number - The partition in which the instance is
  located.    platform - The platform. To list only Windows instances, use windows.
  platform-details - The platform (Linux/UNIX | Red Hat BYOL Linux |  Red Hat Enterprise
  Linux | Red Hat Enterprise Linux with HA | Red Hat Enterprise Linux with SQL Server
  Standard and HA | Red Hat Enterprise Linux with SQL Server Enterprise and HA | Red Hat
  Enterprise Linux with SQL Server Standard | Red Hat Enterprise Linux with SQL Server Web |
  Red Hat Enterprise Linux with SQL Server Enterprise | SQL Server Enterprise | SQL Server
  Standard | SQL Server Web | SUSE Linux | Ubuntu Pro | Windows | Windows BYOL | Windows with
  SQL Server Enterprise | Windows with SQL Server Standard | Windows with SQL Server Web).
  private-dns-name - The private IPv4 DNS name of the instance.
  private-dns-name-options.enable-resource-name-dns-a-record - A Boolean that indicates
  whether to respond to DNS queries for instance hostnames with DNS A records.
  private-dns-name-options.enable-resource-name-dns-aaaa-record - A Boolean that indicates
  whether to respond to DNS queries for instance hostnames with DNS AAAA records.
  private-dns-name-options.hostname-type - The type of hostname (ip-name | resource-name).
  private-ip-address - The private IPv4 address of the instance. This can only be used to
  filter by the primary IP address of the network interface attached to the instance. To
  filter by additional IP addresses assigned to the network interface, use the filter
  network-interface.addresses.private-ip-address.    product-code - The product code
  associated with the AMI used to launch the instance.    product-code.type - The type of
  product code (devpay | marketplace).    ramdisk-id - The RAM disk ID.    reason - The
  reason for the current state of the instance (for example, shows \"User Initiated [date]\"
  when you stop or terminate the instance). Similar to the state-reason-code filter.
  requester-id - The ID of the entity that launched the instance on your behalf (for example,
  Amazon Web Services Management Console, Auto Scaling, and so on).    reservation-id - The
  ID of the instance's reservation. A reservation ID is created any time you launch an
  instance. A reservation ID has a one-to-one relationship with an instance launch request,
  but can be associated with more than one instance if you launch multiple instances using
  the same launch request. For example, if you launch one instance, you get one reservation
  ID. If you launch ten instances using the same launch request, you also get one reservation
  ID.    root-device-name - The device name of the root device volume (for example,
  /dev/sda1).    root-device-type - The type of the root device volume (ebs |
  instance-store).    source-dest-check - Indicates whether the instance performs
  source/destination checking. A value of true means that checking is enabled, and false
  means that checking is disabled. The value must be false for the instance to perform
  network address translation (NAT) in your VPC.     spot-instance-request-id - The ID of the
  Spot Instance request.    state-reason-code - The reason code for the state change.
  state-reason-message - A message that describes the state change.    subnet-id - The ID of
  the subnet for the instance.    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  that have a tag with a specific key, regardless of the tag value.    tenancy - The tenancy
  of an instance (dedicated | default | host).    tpm-support - Indicates if the instance is
  configured for NitroTPM support (v2.0).     usage-operation - The usage operation value for
  the instance (RunInstances | RunInstances:00g0 | RunInstances:0010 | RunInstances:1010 |
  RunInstances:1014 | RunInstances:1110 | RunInstances:0014 | RunInstances:0210 |
  RunInstances:0110 | RunInstances:0100 | RunInstances:0004 | RunInstances:0200 |
  RunInstances:000g | RunInstances:0g00 | RunInstances:0002 | RunInstances:0800 |
  RunInstances:0102 | RunInstances:0006 | RunInstances:0202).    usage-operation-update-time
  - The time that the usage operation was last updated, for example,
  2022-09-15T17:15:20.000Z.    virtualization-type - The virtualization type of the instance
  (paravirtual | hvm).    vpc-id - The ID of the VPC that the instance is running in.
- `"InstanceId"`: The instance IDs. Default: Describes all your instances.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. You cannot specify this parameter and the instance IDs
  parameter in the same request.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInstances", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_internet_gateways()
    describe_internet_gateways(params::Dict{String,<:Any})

Describes your internet gateways. The default is to describe all your internet gateways.
Alternatively, you can specify specific internet gateway IDs or filter the results to
include only the internet gateways that match specific criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    attachment.state - The current state of the attachment
  between the gateway and the VPC (available). Present only if a VPC is attached.
  attachment.vpc-id - The ID of an attached VPC.    internet-gateway-id - The ID of the
  Internet gateway.    owner-id - The ID of the Amazon Web Services account that owns the
  internet gateway.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the
  resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"internetGatewayId"`: The IDs of the internet gateways. Default: Describes all your
  internet gateways.
"""
function describe_internet_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeInternetGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_internet_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeInternetGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ipam_byoasn()
    describe_ipam_byoasn(params::Dict{String,<:Any})

Describes your Autonomous System Numbers (ASNs), their provisioning statuses, and the BYOIP
CIDRs with which they are associated. For more information, see Tutorial: Bring your ASN to
IPAM in the Amazon VPC IPAM guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_ipam_byoasn(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIpamByoasn"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ipam_byoasn(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamByoasn", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_ipam_pools()
    describe_ipam_pools(params::Dict{String,<:Any})

Get information about your IPAM pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters for the request. For more information about filtering,
  see Filtering CLI output.
- `"IpamPoolId"`: The IDs of the IPAM pools you would like information on.
- `"MaxResults"`: The maximum number of results to return in the request.
- `"NextToken"`: The token for the next page of results.
"""
function describe_ipam_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIpamPools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ipam_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamPools", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_ipam_resource_discoveries()
    describe_ipam_resource_discoveries(params::Dict{String,<:Any})

Describes IPAM resource discoveries. A resource discovery is an IPAM component that enables
IPAM to manage and monitor resources that belong to the owning account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The resource discovery filters.
- `"IpamResourceDiscoveryId"`: The IPAM resource discovery IDs.
- `"MaxResults"`: The maximum number of resource discoveries to return in one page of
  results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function describe_ipam_resource_discoveries(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamResourceDiscoveries";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_ipam_resource_discoveries(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamResourceDiscoveries",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ipam_resource_discovery_associations()
    describe_ipam_resource_discovery_associations(params::Dict{String,<:Any})

Describes resource discovery association with an Amazon VPC IPAM. An associated resource
discovery is a resource discovery that has been associated with an IPAM..

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The resource discovery association filters.
- `"IpamResourceDiscoveryAssociationId"`: The resource discovery association IDs.
- `"MaxResults"`: The maximum number of resource discovery associations to return in one
  page of results.
- `"NextToken"`: Specify the pagination token from a previous request to retrieve the next
  page of results.
"""
function describe_ipam_resource_discovery_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamResourceDiscoveryAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_ipam_resource_discovery_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamResourceDiscoveryAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_ipam_scopes()
    describe_ipam_scopes(params::Dict{String,<:Any})

Get information about your IPAM scopes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters for the request. For more information about filtering,
  see Filtering CLI output.
- `"IpamScopeId"`: The IDs of the scopes you want information on.
- `"MaxResults"`: The maximum number of results to return in the request.
- `"NextToken"`: The token for the next page of results.
"""
function describe_ipam_scopes(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIpamScopes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ipam_scopes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpamScopes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_ipams()
    describe_ipams(params::Dict{String,<:Any})

Get information about your IPAM pools. For more information, see What is IPAM? in the
Amazon VPC IPAM User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters for the request. For more information about filtering,
  see Filtering CLI output.
- `"IpamId"`: The IDs of the IPAMs you want information on.
- `"MaxResults"`: The maximum number of results to return in the request.
- `"NextToken"`: The token for the next page of results.
"""
function describe_ipams(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIpams"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ipams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpams", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_ipv6_pools()
    describe_ipv6_pools(params::Dict{String,<:Any})

Describes your IPv6 address pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"PoolId"`: The IDs of the IPv6 address pools.
"""
function describe_ipv6_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeIpv6Pools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_ipv6_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeIpv6Pools", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_key_pairs()
    describe_key_pairs(params::Dict{String,<:Any})

Describes the specified key pairs or all of your key pairs. For more information about key
pairs, see Amazon EC2 key pairs in the Amazon Elastic Compute Cloud User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    key-pair-id - The ID of the key pair.    fingerprint - The
  fingerprint of the key pair.    key-name - The name of the key pair.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.    tag:&lt;key&gt; - The key/value
  combination of a tag assigned to the resource. Use the tag key in the filter name and the
  tag value as the filter value. For example, to find all resources that have a tag with the
  key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the
  filter value.
- `"IncludePublicKey"`: If true, the public key material is included in the response.
  Default: false
- `"KeyName"`: The key pair names. Default: Describes all of your key pairs.
- `"KeyPairId"`: The IDs of the key pairs.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_key_pairs(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeKeyPairs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_key_pairs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeKeyPairs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_launch_template_versions()
    describe_launch_template_versions(params::Dict{String,<:Any})

Describes one or more versions of a specified launch template. You can describe all
versions, individual versions, or a range of versions. You can also describe all the latest
versions or all the default versions of all the launch templates in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    create-time - The time the launch template version
  was created.    ebs-optimized - A boolean that indicates whether the instance is optimized
  for Amazon EBS I/O.    http-endpoint - Indicates whether the HTTP metadata endpoint on your
  instances is enabled (enabled | disabled).    http-protocol-ipv4 - Indicates whether the
  IPv4 endpoint for the instance metadata service is enabled (enabled | disabled).
  host-resource-group-arn - The ARN of the host resource group in which to launch the
  instances.    http-tokens - The state of token usage for your instance metadata requests
  (optional | required).    iam-instance-profile - The ARN of the IAM instance profile.
  image-id - The ID of the AMI.    instance-type - The instance type.    is-default-version -
  A boolean that indicates whether the launch template version is the default version.
  kernel-id - The kernel ID.    license-configuration-arn - The ARN of the license
  configuration.    network-card-index - The index of the network card.    ram-disk-id - The
  RAM disk ID.
- `"LaunchTemplateId"`: The ID of the launch template. To describe one or more versions of
  a specified launch template, you must specify either the launch template ID or the launch
  template name, but not both. To describe all the latest or default launch template versions
  in your account, you must omit this parameter.
- `"LaunchTemplateName"`: The name of the launch template. To describe one or more versions
  of a specified launch template, you must specify either the launch template name or the
  launch template ID, but not both. To describe all the latest or default launch template
  versions in your account, you must omit this parameter.
- `"LaunchTemplateVersion"`: One or more versions of the launch template. Valid values
  depend on whether you are describing a specified launch template (by ID or name) or all
  launch templates in your account. To describe one or more versions of a specified launch
  template, valid values are Latest, Default, and numbers. To describe all launch templates
  in your account that are defined as the latest version, the valid value is Latest. To
  describe all launch templates in your account that are defined as the default version, the
  valid value is Default. You can specify Latest and Default in the same request. You cannot
  specify numbers.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value. This value can be
  between 1 and 200.
- `"MaxVersion"`: The version number up to which to describe launch template versions.
- `"MinVersion"`: The version number after which to describe launch template versions.
- `"NextToken"`: The token to request the next page of results.
- `"ResolveAlias"`: If true, and if a Systems Manager parameter is specified for ImageId,
  the AMI ID is displayed in the response for imageId. If false, and if a Systems Manager
  parameter is specified for ImageId, the parameter is displayed in the response for imageId.
   For more information, see Use a Systems Manager parameter instead of an AMI ID in the
  Amazon EC2 User Guide. Default: false
"""
function describe_launch_template_versions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLaunchTemplateVersions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_launch_template_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLaunchTemplateVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_launch_templates()
    describe_launch_templates(params::Dict{String,<:Any})

Describes one or more launch templates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    create-time - The time the launch template was
  created.    launch-template-name - The name of the launch template.    tag:&lt;key&gt; -
  The key/value combination of a tag assigned to the resource. Use the tag key in the filter
  name and the tag value as the filter value. For example, to find all resources that have a
  tag with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA
  for the filter value.    tag-key - The key of a tag assigned to the resource. Use this
  filter to find all resources assigned a tag with a specific key, regardless of the tag
  value.
- `"LaunchTemplateId"`: One or more launch template IDs.
- `"LaunchTemplateName"`: One or more launch template names.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value. This value can be
  between 1 and 200.
- `"NextToken"`: The token to request the next page of results.
"""
function describe_launch_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeLaunchTemplates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_launch_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLaunchTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateway_route_table_virtual_interface_group_associations()
    describe_local_gateway_route_table_virtual_interface_group_associations(params::Dict{String,<:Any})

Describes the associations between virtual interface groups and local gateway route tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-gateway-id - The ID of a local gateway.
  local-gateway-route-table-arn - The Amazon Resource Name (ARN) of the local gateway route
  table for the virtual interface group.    local-gateway-route-table-id - The ID of the
  local gateway route table.
  local-gateway-route-table-virtual-interface-group-association-id - The ID of the
  association.    local-gateway-route-table-virtual-interface-group-id - The ID of the
  virtual interface group.    owner-id - The ID of the Amazon Web Services account that owns
  the local gateway virtual interface group association.    state - The state of the
  association.
- `"LocalGatewayRouteTableVirtualInterfaceGroupAssociationId"`: The IDs of the associations.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateway_route_table_virtual_interface_group_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_local_gateway_route_table_virtual_interface_group_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateway_route_table_vpc_associations()
    describe_local_gateway_route_table_vpc_associations(params::Dict{String,<:Any})

Describes the specified associations between VPCs and local gateway route tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-gateway-id - The ID of a local gateway.
  local-gateway-route-table-arn - The Amazon Resource Name (ARN) of the local gateway route
  table for the association.    local-gateway-route-table-id - The ID of the local gateway
  route table.    local-gateway-route-table-vpc-association-id - The ID of the association.
   owner-id - The ID of the Amazon Web Services account that owns the local gateway route
  table for the association.    state - The state of the association.    vpc-id - The ID of
  the VPC.
- `"LocalGatewayRouteTableVpcAssociationId"`: The IDs of the associations.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateway_route_table_vpc_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTableVpcAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_local_gateway_route_table_vpc_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTableVpcAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateway_route_tables()
    describe_local_gateway_route_tables(params::Dict{String,<:Any})

Describes one or more local gateway route tables. By default, all local gateway route
tables are described. Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-gateway-id - The ID of a local gateway.
  local-gateway-route-table-arn - The Amazon Resource Name (ARN) of the local gateway route
  table.    local-gateway-route-table-id - The ID of a local gateway route table.
  outpost-arn - The Amazon Resource Name (ARN) of the Outpost.    owner-id - The ID of the
  Amazon Web Services account that owns the local gateway route table.    state - The state
  of the local gateway route table.
- `"LocalGatewayRouteTableId"`: The IDs of the local gateway route tables.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateway_route_tables(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTables";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_local_gateway_route_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayRouteTables",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateway_virtual_interface_groups()
    describe_local_gateway_virtual_interface_groups(params::Dict{String,<:Any})

Describes the specified local gateway virtual interface groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-gateway-id - The ID of a local gateway.
  local-gateway-virtual-interface-group-id - The ID of the virtual interface group.
  local-gateway-virtual-interface-id - The ID of the virtual interface.    owner-id - The ID
  of the Amazon Web Services account that owns the local gateway virtual interface group.
- `"LocalGatewayVirtualInterfaceGroupId"`: The IDs of the virtual interface groups.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateway_virtual_interface_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayVirtualInterfaceGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_local_gateway_virtual_interface_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayVirtualInterfaceGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateway_virtual_interfaces()
    describe_local_gateway_virtual_interfaces(params::Dict{String,<:Any})

Describes the specified local gateway virtual interfaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-address - The local address.    local-bgp-asn -
  The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
  local-gateway-id - The ID of the local gateway.    local-gateway-virtual-interface-id - The
  ID of the virtual interface.    owner-id - The ID of the Amazon Web Services account that
  owns the local gateway virtual interface.    peer-address - The peer address.
  peer-bgp-asn - The peer BGP ASN.    vlan - The ID of the VLAN.
- `"LocalGatewayVirtualInterfaceId"`: The IDs of the virtual interfaces.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateway_virtual_interfaces(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayVirtualInterfaces";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_local_gateway_virtual_interfaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGatewayVirtualInterfaces",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_local_gateways()
    describe_local_gateways(params::Dict{String,<:Any})

Describes one or more local gateways. By default, all local gateways are described.
Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    local-gateway-id - The ID of a local gateway.
  outpost-arn - The Amazon Resource Name (ARN) of the Outpost.    owner-id - The ID of the
  Amazon Web Services account that owns the local gateway.    state - The state of the
  association.
- `"LocalGatewayId"`: The IDs of the local gateways.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_local_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeLocalGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_local_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLocalGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_locked_snapshots()
    describe_locked_snapshots(params::Dict{String,<:Any})

Describes the lock status for a snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    lock-state - The state of the snapshot lock
  (compliance-cooloff | governance | compliance | expired).
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"SnapshotId"`: The IDs of the snapshots for which to view the lock status.
"""
function describe_locked_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeLockedSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_locked_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeLockedSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_mac_hosts()
    describe_mac_hosts(params::Dict{String,<:Any})

Describes the specified EC2 Mac Dedicated Host or all of your EC2 Mac Dedicated Hosts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    availability-zone - The Availability Zone of the EC2 Mac
  Dedicated Host.    instance-type - The instance type size that the EC2 Mac Dedicated Host
  is configured to support.
- `"HostId"`:  The IDs of the EC2 Mac Dedicated Hosts.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results can be seen by sending another request with the returned nextToken
  value. This value can be between 5 and 500. If maxResults is given a larger value than 500,
  you receive an error.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function describe_mac_hosts(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeMacHosts"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_mac_hosts(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeMacHosts", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_managed_prefix_lists()
    describe_managed_prefix_lists(params::Dict{String,<:Any})

Describes your managed prefix lists and any Amazon Web Services-managed prefix lists. To
view the entries for your prefix list, use GetManagedPrefixListEntries.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    owner-id - The ID of the prefix list owner.
  prefix-list-id - The ID of the prefix list.    prefix-list-name - The name of the prefix
  list.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"PrefixListId"`: One or more prefix list IDs.
"""
function describe_managed_prefix_lists(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeManagedPrefixLists"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_managed_prefix_lists(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeManagedPrefixLists",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_moving_addresses()
    describe_moving_addresses(params::Dict{String,<:Any})

 This action is deprecated.  Describes your Elastic IP addresses that are being moved from
or being restored to the EC2-Classic platform. This request does not return information
about any other Elastic IP addresses in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"filter"`: One or more filters.    moving-status - The status of the Elastic IP address
  (MovingToVpc | RestoringToClassic).
- `"maxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results of the initial request can be seen by sending another request with
  the returned NextToken value. This value can be between 5 and 1000; if MaxResults is given
  a value outside of this range, an error is returned. Default: If no value is provided, the
  default is 1000.
- `"nextToken"`: The token for the next page of results.
- `"publicIp"`: One or more Elastic IP addresses.
"""
function describe_moving_addresses(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeMovingAddresses"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_moving_addresses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeMovingAddresses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_nat_gateways()
    describe_nat_gateways(params::Dict{String,<:Any})

Describes your NAT gateways. The default is to describe all your NAT gateways.
Alternatively, you can specify specific NAT gateway IDs or filter the results to include
only the NAT gateways that match specific criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    nat-gateway-id - The ID of the NAT gateway.    state - The
  state of the NAT gateway (pending | failed | available | deleting | deleted).    subnet-id
  - The ID of the subnet in which the NAT gateway resides.    tag:&lt;key&gt; - The key/value
  combination of a tag assigned to the resource. Use the tag key in the filter name and the
  tag value as the filter value. For example, to find all resources that have a tag with the
  key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the
  filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to
  find all resources assigned a tag with a specific key, regardless of the tag value.
  vpc-id - The ID of the VPC in which the NAT gateway resides.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NatGatewayId"`: The IDs of the NAT gateways.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_nat_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeNatGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_nat_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNatGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_acls()
    describe_network_acls(params::Dict{String,<:Any})

Describes your network ACLs. The default is to describe all your network ACLs.
Alternatively, you can specify specific network ACL IDs or filter the results to include
only the network ACLs that match specific criteria. For more information, see Network ACLs
in the Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    association.association-id - The ID of an association ID for
  the ACL.    association.network-acl-id - The ID of the network ACL involved in the
  association.    association.subnet-id - The ID of the subnet involved in the association.
   default - Indicates whether the ACL is the default network ACL for the VPC.    entry.cidr
  - The IPv4 CIDR range specified in the entry.    entry.icmp.code - The ICMP code specified
  in the entry, if any.    entry.icmp.type - The ICMP type specified in the entry, if any.
  entry.ipv6-cidr - The IPv6 CIDR range specified in the entry.    entry.port-range.from -
  The start of the port range specified in the entry.     entry.port-range.to - The end of
  the port range specified in the entry.     entry.protocol - The protocol specified in the
  entry (tcp | udp | icmp or a protocol number).    entry.rule-action - Allows or denies the
  matching traffic (allow | deny).    entry.egress - A Boolean that indicates the type of
  rule. Specify true for egress rules, or false for ingress rules.    entry.rule-number - The
  number of an entry (in other words, rule) in the set of ACL entries.    network-acl-id -
  The ID of the network ACL.    owner-id - The ID of the Amazon Web Services account that
  owns the network ACL.    tag:&lt;key&gt; - The key/value combination of a tag assigned to
  the resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC for the
  network ACL.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NetworkAclId"`: The IDs of the network ACLs.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_network_acls(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeNetworkAcls"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_network_acls(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkAcls",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_insights_access_scope_analyses()
    describe_network_insights_access_scope_analyses(params::Dict{String,<:Any})

Describes the specified Network Access Scope analyses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalysisStartTimeBegin"`: Filters the results based on the start time. The analysis
  must have started on or after this time.
- `"AnalysisStartTimeEnd"`: Filters the results based on the start time. The analysis must
  have started on or before this time.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: There are no supported filters.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NetworkInsightsAccessScopeAnalysisId"`: The IDs of the Network Access Scope analyses.
- `"NetworkInsightsAccessScopeId"`: The ID of the Network Access Scope.
- `"NextToken"`: The token for the next page of results.
"""
function describe_network_insights_access_scope_analyses(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAccessScopeAnalyses";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_insights_access_scope_analyses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAccessScopeAnalyses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_insights_access_scopes()
    describe_network_insights_access_scopes(params::Dict{String,<:Any})

Describes the specified Network Access Scopes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: There are no supported filters.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NetworkInsightsAccessScopeId"`: The IDs of the Network Access Scopes.
- `"NextToken"`: The token for the next page of results.
"""
function describe_network_insights_access_scopes(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAccessScopes";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_insights_access_scopes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAccessScopes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_insights_analyses()
    describe_network_insights_analyses(params::Dict{String,<:Any})

Describes one or more of your network insights analyses.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AnalysisEndTime"`: The time when the network insights analyses ended.
- `"AnalysisStartTime"`: The time when the network insights analyses started.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters. The following are the possible values:   path-found - A Boolean
  value that indicates whether a feasible path is found.   status - The status of the
  analysis (running | succeeded | failed).
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NetworkInsightsAnalysisId"`: The ID of the network insights analyses. You must specify
  either analysis IDs or a path ID.
- `"NetworkInsightsPathId"`: The ID of the path. You must specify either a path ID or
  analysis IDs.
- `"NextToken"`: The token for the next page of results.
"""
function describe_network_insights_analyses(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAnalyses";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_insights_analyses(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsAnalyses",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_insights_paths()
    describe_network_insights_paths(params::Dict{String,<:Any})

Describes one or more of your paths.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters. The following are the possible values:   destination - The ID of
  the resource.   filter-at-source.source-address - The source IPv4 address at the source.
  filter-at-source.source-port-range - The source port range at the source.
  filter-at-source.destination-address - The destination IPv4 address at the source.
  filter-at-source.destination-port-range - The destination port range at the source.
  filter-at-destination.source-address - The source IPv4 address at the destination.
  filter-at-destination.source-port-range - The source port range at the destination.
  filter-at-destination.destination-address - The destination IPv4 address at the
  destination.   filter-at-destination.destination-port-range - The destination port range at
  the destination.   protocol - The protocol.   source - The ID of the resource.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NetworkInsightsPathId"`: The IDs of the paths.
- `"NextToken"`: The token for the next page of results.
"""
function describe_network_insights_paths(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsPaths";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_insights_paths(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInsightsPaths",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_interface_attribute(network_interface_id)
    describe_network_interface_attribute(network_interface_id, params::Dict{String,<:Any})

Describes a network interface attribute. You can specify only one attribute at a time.

# Arguments
- `network_interface_id`: The ID of the network interface.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attribute"`: The attribute of the network interface. This parameter is required.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_network_interface_attribute(
    networkInterfaceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInterfaceAttribute",
        Dict{String,Any}("networkInterfaceId" => networkInterfaceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_interface_attribute(
    networkInterfaceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeNetworkInterfaceAttribute",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("networkInterfaceId" => networkInterfaceId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_interface_permissions()
    describe_network_interface_permissions(params::Dict{String,<:Any})

Describes the permissions for your network interfaces.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.
  network-interface-permission.network-interface-permission-id - The ID of the permission.
  network-interface-permission.network-interface-id - The ID of the network interface.
  network-interface-permission.aws-account-id - The Amazon Web Services account ID.
  network-interface-permission.aws-service - The Amazon Web Service.
  network-interface-permission.permission - The type of permission (INSTANCE-ATTACH |
  EIP-ASSOCIATE).
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. If this
  parameter is not specified, up to 50 results are returned by default. For more information,
  see Pagination.
- `"NetworkInterfacePermissionId"`: The network interface permission IDs.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_network_interface_permissions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInterfacePermissions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_network_interface_permissions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInterfacePermissions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_network_interfaces()
    describe_network_interfaces(params::Dict{String,<:Any})

Describes one or more of your network interfaces. If you have a large number of network
interfaces, the operation fails unless you use pagination or one of the following filters:
group-id, mac-address, private-dns-name, private-ip-address, private-dns-name, subnet-id,
or vpc-id.  We strongly recommend using only paginated requests. Unpaginated requests are
susceptible to throttling and timeouts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. You cannot
  specify this parameter and the network interface IDs parameter in the same request. For
  more information, see Pagination.
- `"NetworkInterfaceId"`: The network interface IDs. Default: Describes all your network
  interfaces.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"filter"`: One or more filters.    association.allocation-id - The allocation ID
  returned when you allocated the Elastic IP address (IPv4) for your network interface.
  association.association-id - The association ID returned when the network interface was
  associated with an IPv4 address.    addresses.association.owner-id - The owner ID of the
  addresses associated with the network interface.    addresses.association.public-ip - The
  association ID returned when the network interface was associated with the Elastic IP
  address (IPv4).    addresses.primary - Whether the private IPv4 address is the primary IP
  address associated with the network interface.     addresses.private-ip-address - The
  private IPv4 addresses associated with the network interface.    association.ip-owner-id -
  The owner of the Elastic IP address (IPv4) associated with the network interface.
  association.public-ip - The address of the Elastic IP address (IPv4) bound to the network
  interface.    association.public-dns-name - The public DNS name for the network interface
  (IPv4).    attachment.attach-time - The time that the network interface was attached to an
  instance.    attachment.attachment-id - The ID of the interface attachment.
  attachment.delete-on-termination - Indicates whether the attachment is deleted when an
  instance is terminated.    attachment.device-index - The device index to which the network
  interface is attached.    attachment.instance-id - The ID of the instance to which the
  network interface is attached.    attachment.instance-owner-id - The owner ID of the
  instance to which the network interface is attached.    attachment.status - The status of
  the attachment (attaching | attached | detaching | detached).    availability-zone - The
  Availability Zone of the network interface.    description - The description of the network
  interface.    group-id - The ID of a security group associated with the network interface.
    ipv6-addresses.ipv6-address - An IPv6 address associated with the network interface.
  interface-type - The type of network interface (api_gateway_managed |
  aws_codestar_connections_managed | branch | ec2_instance_connect_endpoint | efa | efs |
  gateway_load_balancer | gateway_load_balancer_endpoint | global_accelerator_managed |
  interface | iot_rules_managed | lambda | load_balancer | nat_gateway |
  network_load_balancer | quicksight | transit_gateway | trunk | vpc_endpoint).
  mac-address - The MAC address of the network interface.    network-interface-id - The ID of
  the network interface.    owner-id - The Amazon Web Services account ID of the network
  interface owner.    private-dns-name - The private DNS name of the network interface
  (IPv4).    private-ip-address - The private IPv4 address or addresses of the network
  interface.    requester-id - The alias or Amazon Web Services account ID of the principal
  or service that created the network interface.    requester-managed - Indicates whether the
  network interface is being managed by an Amazon Web Service (for example, Amazon Web
  Services Management Console, Auto Scaling, and so on).    source-dest-check - Indicates
  whether the network interface performs source/destination checking. A value of true means
  checking is enabled, and false means checking is disabled. The value must be false for the
  network interface to perform network address translation (NAT) in your VPC.     status -
  The status of the network interface. If the network interface is not attached to an
  instance, the status is available; if a network interface is attached to an instance the
  status is in-use.    subnet-id - The ID of the subnet for the network interface.
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
  key in the filter name and the tag value as the filter value. For example, to find all
  resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the
  filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.    vpc-id - The ID of the VPC for the network interface.
"""
function describe_network_interfaces(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeNetworkInterfaces"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_network_interfaces(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeNetworkInterfaces",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_placement_groups()
    describe_placement_groups(params::Dict{String,<:Any})

Describes the specified placement groups or all of your placement groups. For more
information, see Placement groups in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    group-name - The name of the placement group.    group-arn -
  The Amazon Resource Name (ARN) of the placement group.    spread-level - The spread level
  for the placement group (host | rack).     state - The state of the placement group
  (pending | available | deleting | deleted).    strategy - The strategy of the placement
  group (cluster | spread | partition).    tag:&lt;key&gt; - The key/value combination of a
  tag assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  that have a tag with a specific key, regardless of the tag value.
- `"GroupId"`: The IDs of the placement groups.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"groupName"`: The names of the placement groups. Default: Describes all your placement
  groups, or only those otherwise specified.
"""
function describe_placement_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribePlacementGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_placement_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribePlacementGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_prefix_lists()
    describe_prefix_lists(params::Dict{String,<:Any})

Describes available Amazon Web Services services in a prefix list format, which includes
the prefix list name and prefix list ID of the service and the IP address range for the
service. We recommend that you use DescribeManagedPrefixLists instead.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    prefix-list-id: The ID of a prefix list.
  prefix-list-name: The name of a prefix list.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"PrefixListId"`: One or more prefix list IDs.
"""
function describe_prefix_lists(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribePrefixLists"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_prefix_lists(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribePrefixLists",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_principal_id_format()
    describe_principal_id_format(params::Dict{String,<:Any})

Describes the ID format settings for the root user and all IAM roles and IAM users that
have explicitly specified a longer ID (17-character ID) preference.  By default, all IAM
roles and IAM users default to the same ID settings as the root user, unless they
explicitly override the settings. This request is useful for identifying those IAM users
and IAM roles that have overridden the default ID settings. The following resource types
support longer IDs: bundle | conversion-task | customer-gateway | dhcp-options |
elastic-ip-allocation | elastic-ip-association | export-task | flow-log | image |
import-task | instance | internet-gateway | network-acl | network-acl-association |
network-interface | network-interface-attachment | prefix-list | reservation | route-table
| route-table-association | security-group | snapshot | subnet |
subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
vpc-peering-connection | vpn-connection | vpn-gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another call with the returned NextToken value.
- `"NextToken"`: The token to request the next page of results.
- `"Resource"`: The type of resource: bundle | conversion-task | customer-gateway |
  dhcp-options | elastic-ip-allocation | elastic-ip-association | export-task | flow-log |
  image | import-task | instance | internet-gateway | network-acl | network-acl-association |
  network-interface | network-interface-attachment | prefix-list | reservation | route-table
  | route-table-association | security-group | snapshot | subnet |
  subnet-cidr-block-association | volume | vpc | vpc-cidr-block-association | vpc-endpoint |
  vpc-peering-connection | vpn-connection | vpn-gateway
"""
function describe_principal_id_format(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribePrincipalIdFormat"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_principal_id_format(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribePrincipalIdFormat",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_public_ipv4_pools()
    describe_public_ipv4_pools(params::Dict{String,<:Any})

Describes the specified IPv4 address pools.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"PoolId"`: The IDs of the address pools.
"""
function describe_public_ipv4_pools(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribePublicIpv4Pools"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_public_ipv4_pools(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribePublicIpv4Pools",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_regions()
    describe_regions(params::Dict{String,<:Any})

Describes the Regions that are enabled for your account, or all Regions. For a list of the
Regions supported by Amazon EC2, see Amazon EC2 service endpoints. For information about
enabling and disabling Regions for your account, see Specify which Amazon Web Services
Regions your account can use in the Amazon Web Services Account Management Reference Guide.
 The order of the elements in the response, including those within nested structures, might
vary. Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllRegions"`: Indicates whether to display all Regions, including Regions that are
  disabled for your account.
- `"Filter"`: The filters.    endpoint - The endpoint of the Region (for example,
  ec2.us-east-1.amazonaws.com).    opt-in-status - The opt-in status of the Region
  (opt-in-not-required | opted-in | not-opted-in).    region-name - The name of the Region
  (for example, us-east-1).
- `"RegionName"`: The names of the Regions. You can specify any Regions, whether they are
  enabled and disabled for your account.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_regions(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeRegions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_regions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeRegions", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_replace_root_volume_tasks()
    describe_replace_root_volume_tasks(params::Dict{String,<:Any})

Describes a root volume replacement task. For more information, see Replace a root volume
in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: Filter to use:    instance-id - The ID of the instance for which the root
  volume replacement task was created.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"ReplaceRootVolumeTaskId"`: The ID of the root volume replacement task to view.
"""
function describe_replace_root_volume_tasks(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReplaceRootVolumeTasks";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_replace_root_volume_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReplaceRootVolumeTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instances()
    describe_reserved_instances(params::Dict{String,<:Any})

Describes one or more of the Reserved Instances that you purchased. For more information
about Reserved Instances, see Reserved Instances in the Amazon EC2 User Guide.  The order
of the elements in the response, including those within nested structures, might vary.
Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    availability-zone - The Availability Zone where the
  Reserved Instance can be used.    duration - The duration of the Reserved Instance (one
  year or three years), in seconds (31536000 | 94608000).    end - The time when the Reserved
  Instance expires (for example, 2015-08-07T11:54:42.000Z).    fixed-price - The purchase
  price of the Reserved Instance (for example, 9800.0).    instance-type - The instance type
  that is covered by the reservation.    scope - The scope of the Reserved Instance (Region
  or Availability Zone).    product-description - The Reserved Instance product platform
  description (Linux/UNIX | Linux with SQL Server Standard | Linux with SQL Server Web |
  Linux with SQL Server Enterprise | SUSE Linux | Red Hat Enterprise Linux | Red Hat
  Enterprise Linux with HA | Windows | Windows with SQL Server Standard | Windows with SQL
  Server Web | Windows with SQL Server Enterprise).    reserved-instances-id - The ID of the
  Reserved Instance.    start - The time at which the Reserved Instance purchase request was
  placed (for example, 2014-08-07T11:54:42.000Z).    state - The state of the Reserved
  Instance (payment-pending | active | payment-failed | retired).    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter
  to find all resources assigned a tag with a specific key, regardless of the tag value.
  usage-price - The usage price of the Reserved Instance, per hour (for example, 0.84).
- `"OfferingClass"`: Describes whether the Reserved Instance is Standard or Convertible.
- `"ReservedInstancesId"`: One or more Reserved Instance IDs. Default: Describes all your
  Reserved Instances, or only those otherwise specified.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"offeringType"`: The Reserved Instance offering type. If you are using tools that
  predate the 2011-11-01 API version, you only have access to the Medium Utilization Reserved
  Instance offering type.
"""
function describe_reserved_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeReservedInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_reserved_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instances_listings()
    describe_reserved_instances_listings(params::Dict{String,<:Any})

Describes your account's Reserved Instance listings in the Reserved Instance Marketplace.
The Reserved Instance Marketplace matches sellers who want to resell Reserved Instance
capacity that they no longer need with buyers who want to purchase additional capacity.
Reserved Instances bought and sold through the Reserved Instance Marketplace work like any
other Reserved Instances. As a seller, you choose to list some or all of your Reserved
Instances, and you specify the upfront price to receive for them. Your Reserved Instances
are then listed in the Reserved Instance Marketplace and are available for purchase. As a
buyer, you specify the configuration of the Reserved Instance to purchase, and the
Marketplace matches what you're searching for with what's available. The Marketplace first
sells the lowest priced Reserved Instances to you, and continues to sell available Reserved
Instance listings to you until your demand is met. You are charged based on the total price
of all of the listings that you purchase. For more information, see Sell in the Reserved
Instance Marketplace in the Amazon EC2 User Guide.  The order of the elements in the
response, including those within nested structures, might vary. Applications should not
assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    reserved-instances-id - The ID of the Reserved
  Instances.    reserved-instances-listing-id - The ID of the Reserved Instances listing.
  status - The status of the Reserved Instance listing (pending | active | cancelled |
  closed).    status-message - The reason for the status.
- `"reservedInstancesId"`: One or more Reserved Instance IDs.
- `"reservedInstancesListingId"`: One or more Reserved Instance listing IDs.
"""
function describe_reserved_instances_listings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesListings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_instances_listings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesListings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instances_modifications()
    describe_reserved_instances_modifications(params::Dict{String,<:Any})

Describes the modifications made to your Reserved Instances. If no parameter is specified,
information about all your Reserved Instances modification requests is returned. If a
modification ID is specified, only information about the specific modification is returned.
For more information, see Modify Reserved Instances in the Amazon EC2 User Guide.  The
order of the elements in the response, including those within nested structures, might
vary. Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    client-token - The idempotency token for the
  modification request.    create-date - The time when the modification request was created.
    effective-date - The time when the modification becomes effective.
  modification-result.reserved-instances-id - The ID for the Reserved Instances created as
  part of the modification request. This ID is only available when the status of the
  modification is fulfilled.    modification-result.target-configuration.availability-zone -
  The Availability Zone for the new Reserved Instances.
  modification-result.target-configuration.instance-count  - The number of new Reserved
  Instances.    modification-result.target-configuration.instance-type - The instance type of
  the new Reserved Instances.    reserved-instances-id - The ID of the Reserved Instances
  modified.    reserved-instances-modification-id - The ID of the modification request.
  status - The status of the Reserved Instances modification request (processing | fulfilled
  | failed).    status-message - The reason for the status.    update-date - The time when
  the modification request was last updated.
- `"ReservedInstancesModificationId"`: IDs for the submitted modification request.
- `"nextToken"`: The token to retrieve the next page of results.
"""
function describe_reserved_instances_modifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesModifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_instances_modifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesModifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_instances_offerings()
    describe_reserved_instances_offerings(params::Dict{String,<:Any})

Describes Reserved Instance offerings that are available for purchase. With Reserved
Instances, you purchase the right to launch instances for a period of time. During that
time period, you do not receive insufficient capacity errors, and you pay a lower usage
rate than the rate charged for On-Demand instances for the actual time used. If you have
listed your own Reserved Instances for sale in the Reserved Instance Marketplace, they will
be excluded from these results. This is to ensure that you do not purchase your own
Reserved Instances. For more information, see Sell in the Reserved Instance Marketplace in
the Amazon EC2 User Guide.  The order of the elements in the response, including those
within nested structures, might vary. Applications should not assume the elements appear in
a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZone"`: The Availability Zone in which the Reserved Instance can be used.
- `"Filter"`: One or more filters.    availability-zone - The Availability Zone where the
  Reserved Instance can be used.    duration - The duration of the Reserved Instance (for
  example, one year or three years), in seconds (31536000 | 94608000).    fixed-price - The
  purchase price of the Reserved Instance (for example, 9800.0).    instance-type - The
  instance type that is covered by the reservation.    marketplace - Set to true to show only
  Reserved Instance Marketplace offerings. When this filter is not used, which is the default
  behavior, all offerings from both Amazon Web Services and the Reserved Instance Marketplace
  are listed.    product-description - The Reserved Instance product platform description
  (Linux/UNIX | Linux with SQL Server Standard | Linux with SQL Server Web | Linux with SQL
  Server Enterprise | SUSE Linux | Red Hat Enterprise Linux | Red Hat Enterprise Linux with
  HA | Windows | Windows with SQL Server Standard | Windows with SQL Server Web | Windows
  with SQL Server Enterprise).    reserved-instances-offering-id - The Reserved Instances
  offering ID.    scope - The scope of the Reserved Instance (Availability Zone or Region).
   usage-price - The usage price of the Reserved Instance, per hour (for example, 0.84).
- `"IncludeMarketplace"`: Include Reserved Instance Marketplace offerings in the response.
- `"InstanceType"`: The instance type that the reservation will cover (for example,
  m1.small). For more information, see Amazon EC2 instance types in the Amazon EC2 User Guide.
- `"MaxDuration"`: The maximum duration (in seconds) to filter when searching for
  offerings. Default: 94608000 (3 years)
- `"MaxInstanceCount"`: The maximum number of instances to filter when searching for
  offerings. Default: 20
- `"MinDuration"`: The minimum duration (in seconds) to filter when searching for
  offerings. Default: 2592000 (1 month)
- `"OfferingClass"`: The offering class of the Reserved Instance. Can be standard or
  convertible.
- `"ProductDescription"`: The Reserved Instance product platform description. Instances
  that include (Amazon VPC) in the description are for use with Amazon VPC.
- `"ReservedInstancesOfferingId"`: One or more Reserved Instances offering IDs.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"instanceTenancy"`: The tenancy of the instances covered by the reservation. A Reserved
  Instance with a tenancy of dedicated is applied to instances that run in a VPC on
  single-tenant hardware (i.e., Dedicated Instances).  Important: The host value cannot be
  used with this parameter. Use the default or dedicated values only. Default: default
- `"maxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results of the initial request can be seen by sending another request with
  the returned NextToken value. The maximum is 100. Default: 100
- `"nextToken"`: The token to retrieve the next page of results.
- `"offeringType"`: The Reserved Instance offering type. If you are using tools that
  predate the 2011-11-01 API version, you only have access to the Medium Utilization Reserved
  Instance offering type.
"""
function describe_reserved_instances_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_instances_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeReservedInstancesOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_route_tables()
    describe_route_tables(params::Dict{String,<:Any})

Describes your route tables. The default is to describe all your route tables.
Alternatively, you can specify specific route table IDs or filter the results to include
only the route tables that match specific criteria. Each subnet in your VPC must be
associated with a route table. If a subnet is not explicitly associated with any route
table, it is implicitly associated with the main route table. This command does not return
the subnet ID for implicit associations. For more information, see Route tables in the
Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    association.gateway-id - The ID of the gateway involved in
  the association.    association.route-table-association-id - The ID of an association ID
  for the route table.    association.route-table-id - The ID of the route table involved in
  the association.    association.subnet-id - The ID of the subnet involved in the
  association.    association.main - Indicates whether the route table is the main route
  table for the VPC (true | false). Route tables that do not have an association ID are not
  returned in the response.    owner-id - The ID of the Amazon Web Services account that owns
  the route table.    route-table-id - The ID of the route table.
  route.destination-cidr-block - The IPv4 CIDR range specified in a route in the table.
  route.destination-ipv6-cidr-block - The IPv6 CIDR range specified in a route in the route
  table.    route.destination-prefix-list-id - The ID (prefix) of the Amazon Web Service
  specified in a route in the table.    route.egress-only-internet-gateway-id - The ID of an
  egress-only Internet gateway specified in a route in the route table.    route.gateway-id -
  The ID of a gateway specified in a route in the table.    route.instance-id - The ID of an
  instance specified in a route in the table.    route.nat-gateway-id - The ID of a NAT
  gateway.    route.transit-gateway-id - The ID of a transit gateway.    route.origin -
  Describes how the route was created. CreateRouteTable indicates that the route was
  automatically created when the route table was created; CreateRoute indicates that the
  route was manually added to the route table; EnableVgwRoutePropagation indicates that the
  route was propagated by route propagation.    route.state - The state of a route in the
  route table (active | blackhole). The blackhole state indicates that the route's target
  isn't available (for example, the specified gateway isn't attached to the VPC, the
  specified NAT instance has been terminated, and so on).    route.vpc-peering-connection-id
  - The ID of a VPC peering connection specified in a route in the table.    tag:&lt;key&gt;
  - The key/value combination of a tag assigned to the resource. Use the tag key in the
  filter name and the tag value as the filter value. For example, to find all resources that
  have a tag with the key Owner and the value TeamA, specify tag:Owner for the filter name
  and TeamA for the filter value.    tag-key - The key of a tag assigned to the resource. Use
  this filter to find all resources assigned a tag with a specific key, regardless of the tag
  value.    vpc-id - The ID of the VPC for the route table.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"RouteTableId"`: The IDs of the route tables.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_route_tables(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeRouteTables"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_route_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeRouteTables",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scheduled_instance_availability(first_slot_start_time_range, recurrence)
    describe_scheduled_instance_availability(first_slot_start_time_range, recurrence, params::Dict{String,<:Any})

Finds available schedules that meet the specified criteria. You can search for an available
schedule no more than 3 months in advance. You must meet the minimum required duration of
1,200 hours per year. For example, the minimum daily schedule is 4 hours, the minimum
weekly schedule is 24 hours, and the minimum monthly schedule is 100 hours. After you find
a schedule that meets your needs, call PurchaseScheduledInstances to purchase Scheduled
Instances with that schedule.

# Arguments
- `first_slot_start_time_range`: The time period for the first schedule to start.
- `recurrence`: The schedule recurrence.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    availability-zone - The Availability Zone (for example,
  us-west-2a).    instance-type - The instance type (for example, c4.large).    platform -
  The platform (Linux/UNIX or Windows).
- `"MaxResults"`: The maximum number of results to return in a single call. This value can
  be between 5 and 300. The default value is 300. To retrieve the remaining results, make
  another call with the returned NextToken value.
- `"MaxSlotDurationInHours"`: The maximum available duration, in hours. This value must be
  greater than MinSlotDurationInHours and less than 1,720.
- `"MinSlotDurationInHours"`: The minimum available duration, in hours. The minimum
  required duration is 1,200 hours per year. For example, the minimum daily schedule is 4
  hours, the minimum weekly schedule is 24 hours, and the minimum monthly schedule is 100
  hours.
- `"NextToken"`: The token for the next set of results.
"""
function describe_scheduled_instance_availability(
    FirstSlotStartTimeRange, Recurrence; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeScheduledInstanceAvailability",
        Dict{String,Any}(
            "FirstSlotStartTimeRange" => FirstSlotStartTimeRange, "Recurrence" => Recurrence
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_scheduled_instance_availability(
    FirstSlotStartTimeRange,
    Recurrence,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeScheduledInstanceAvailability",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "FirstSlotStartTimeRange" => FirstSlotStartTimeRange,
                    "Recurrence" => Recurrence,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_scheduled_instances()
    describe_scheduled_instances(params::Dict{String,<:Any})

Describes the specified Scheduled Instances or all your Scheduled Instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    availability-zone - The Availability Zone (for example,
  us-west-2a).    instance-type - The instance type (for example, c4.large).    platform -
  The platform (Linux/UNIX or Windows).
- `"MaxResults"`: The maximum number of results to return in a single call. This value can
  be between 5 and 300. The default value is 100. To retrieve the remaining results, make
  another call with the returned NextToken value.
- `"NextToken"`: The token for the next set of results.
- `"ScheduledInstanceId"`: The Scheduled Instance IDs.
- `"SlotStartTimeRange"`: The time period for the first schedule to start.
"""
function describe_scheduled_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeScheduledInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_scheduled_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeScheduledInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_group_references(item)
    describe_security_group_references(item, params::Dict{String,<:Any})

Describes the VPCs on the other side of a VPC peering connection that are referencing the
security groups you've specified in this request.

# Arguments
- `item`: The IDs of the security groups in your account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"GroupId"`: The IDs of the security groups in your account.
"""
function describe_security_group_references(
    item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSecurityGroupReferences",
        Dict{String,Any}("item" => item);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_security_group_references(
    item, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSecurityGroupReferences",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("item" => item), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_group_rules()
    describe_security_group_rules(params::Dict{String,<:Any})

Describes one or more of your security group rules.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    group-id - The ID of the security group.
  security-group-rule-id - The ID of the security group rule.    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. This value can
  be between 5 and 1000. If this parameter is not specified, then all items are returned. For
  more information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"SecurityGroupRuleId"`: The IDs of the security group rules.
"""
function describe_security_group_rules(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeSecurityGroupRules"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_security_group_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSecurityGroupRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_security_groups()
    describe_security_groups(params::Dict{String,<:Any})

Describes the specified security groups or all of your security groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters. If using multiple filters for rules, the results include
  security groups for which any combination of rules - not necessarily a single rule - match
  all filters.    description - The description of the security group.
  egress.ip-permission.cidr - An IPv4 CIDR block for an outbound security group rule.
  egress.ip-permission.from-port - For an outbound rule, the start of port range for the TCP
  and UDP protocols, or an ICMP type number.    egress.ip-permission.group-id - The ID of a
  security group that has been referenced in an outbound security group rule.
  egress.ip-permission.group-name - The name of a security group that is referenced in an
  outbound security group rule.    egress.ip-permission.ipv6-cidr - An IPv6 CIDR block for an
  outbound security group rule.    egress.ip-permission.prefix-list-id - The ID of a prefix
  list to which a security group rule allows outbound access.
  egress.ip-permission.protocol - The IP protocol for an outbound security group rule (tcp |
  udp | icmp, a protocol number, or -1 for all protocols).    egress.ip-permission.to-port -
  For an outbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
     egress.ip-permission.user-id - The ID of an Amazon Web Services account that has been
  referenced in an outbound security group rule.    group-id - The ID of the security group.
     group-name - The name of the security group.    ip-permission.cidr - An IPv4 CIDR block
  for an inbound security group rule.    ip-permission.from-port - For an inbound rule, the
  start of port range for the TCP and UDP protocols, or an ICMP type number.
  ip-permission.group-id - The ID of a security group that has been referenced in an inbound
  security group rule.    ip-permission.group-name - The name of a security group that is
  referenced in an inbound security group rule.    ip-permission.ipv6-cidr - An IPv6 CIDR
  block for an inbound security group rule.    ip-permission.prefix-list-id - The ID of a
  prefix list from which a security group rule allows inbound access.
  ip-permission.protocol - The IP protocol for an inbound security group rule (tcp | udp |
  icmp, a protocol number, or -1 for all protocols).    ip-permission.to-port - For an
  inbound rule, the end of port range for the TCP and UDP protocols, or an ICMP code.
  ip-permission.user-id - The ID of an Amazon Web Services account that has been referenced
  in an inbound security group rule.    owner-id - The Amazon Web Services account ID of the
  owner of the security group.    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the
  VPC specified when the security group was created.
- `"GroupId"`: The IDs of the security groups. Required for security groups in a nondefault
  VPC. Default: Describes all of your security groups.
- `"GroupName"`: [Default VPC] The names of the security groups. You can specify either the
  security group name or the security group ID. Default: Describes all of your security
  groups.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. This value can
  be between 5 and 1000. If this parameter is not specified, then all items are returned. For
  more information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_security_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeSecurityGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_security_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSecurityGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshot_attribute(attribute, snapshot_id)
    describe_snapshot_attribute(attribute, snapshot_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified snapshot. You can specify only one
attribute at a time. For more information about EBS snapshots, see Amazon EBS snapshots in
the Amazon EBS User Guide.

# Arguments
- `attribute`: The snapshot attribute you would like to view.
- `snapshot_id`: The ID of the EBS snapshot.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_snapshot_attribute(
    Attribute, SnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSnapshotAttribute",
        Dict{String,Any}("Attribute" => Attribute, "SnapshotId" => SnapshotId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_snapshot_attribute(
    Attribute,
    SnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeSnapshotAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Attribute" => Attribute, "SnapshotId" => SnapshotId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshot_tier_status()
    describe_snapshot_tier_status(params::Dict{String,<:Any})

Describes the storage tier status of one or more Amazon EBS snapshots.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    snapshot-id - The snapshot ID.    volume-id - The ID of the
  volume the snapshot is for.    last-tiering-operation - The state of the last archive or
  restore action. (archival-in-progress | archival-completed | archival-failed |
  permanent-restore-in-progress | permanent-restore-completed | permanent-restore-failed |
  temporary-restore-in-progress | temporary-restore-completed | temporary-restore-failed)
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_snapshot_tier_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeSnapshotTierStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_snapshot_tier_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSnapshotTierStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_snapshots()
    describe_snapshots(params::Dict{String,<:Any})

Describes the specified EBS snapshots available to you or all of the EBS snapshots
available to you. The snapshots available to you include public snapshots, private
snapshots that you own, and private snapshots owned by other Amazon Web Services accounts
for which you have explicit create volume permissions. The create volume permissions fall
into the following categories:    public: The owner of the snapshot granted create volume
permissions for the snapshot to the all group. All Amazon Web Services accounts have create
volume permissions for these snapshots.    explicit: The owner of the snapshot granted
create volume permissions to a specific Amazon Web Services account.    implicit: An Amazon
Web Services account has implicit create volume permissions for all snapshots it owns.
The list of snapshots returned can be filtered by specifying snapshot IDs, snapshot owners,
or Amazon Web Services accounts with create volume permissions. If no options are
specified, Amazon EC2 returns all snapshots for which you have create volume permissions.
If you specify one or more snapshot IDs, only snapshots that have the specified IDs are
returned. If you specify an invalid snapshot ID, an error is returned. If you specify a
snapshot ID for which you do not have access, it is not included in the returned results.
If you specify one or more snapshot owners using the OwnerIds option, only snapshots from
the specified owners and for which you have access are returned. The results can include
the Amazon Web Services account IDs of the specified owners, amazon for snapshots owned by
Amazon, or self for snapshots that you own. If you specify a list of restorable users, only
snapshots with create snapshot permissions for those users are returned. You can specify
Amazon Web Services account IDs (if you own the snapshots), self for snapshots for which
you own or have explicit permissions, or all for public snapshots. If you are describing a
long list of snapshots, we recommend that you paginate the output to make the list more
manageable. For more information, see Pagination. To get the state of fast snapshot
restores for a snapshot, use DescribeFastSnapshotRestores. For more information about EBS
snapshots, see Amazon EBS snapshots in the Amazon EBS User Guide.  We strongly recommend
using only paginated requests. Unpaginated requests are susceptible to throttling and
timeouts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    description - A description of the snapshot.    encrypted -
  Indicates whether the snapshot is encrypted (true | false)    owner-alias - The owner
  alias, from an Amazon-maintained list (amazon). This is not the user-configured Amazon Web
  Services account alias set using the IAM console. We recommend that you use the related
  parameter instead of this filter.    owner-id - The Amazon Web Services account ID of the
  owner. We recommend that you use the related parameter instead of this filter.    progress
  - The progress of the snapshot, as a percentage (for example, 80%).    snapshot-id - The
  snapshot ID.    start-time - The time stamp when the snapshot was initiated.    status -
  The status of the snapshot (pending | completed | error).    storage-tier - The storage
  tier of the snapshot (archive | standard).    tag:&lt;key&gt; - The key/value combination
  of a tag assigned to the resource. Use the tag key in the filter name and the tag value as
  the filter value. For example, to find all resources that have a tag with the key Owner and
  the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.    volume-id - The ID of
  the volume the snapshot is for.    volume-size - The size of the volume, in GiB.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"Owner"`: Scopes the results to snapshots with the specified owners. You can specify a
  combination of Amazon Web Services account IDs, self, and amazon.
- `"RestorableBy"`: The IDs of the Amazon Web Services accounts that can create volumes
  from the snapshot.
- `"SnapshotId"`: The snapshot IDs. Default: Describes the snapshots for which you have
  create volume permissions.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSnapshots", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_spot_datafeed_subscription()
    describe_spot_datafeed_subscription(params::Dict{String,<:Any})

Describes the data feed for Spot Instances. For more information, see Spot Instance data
feed in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_spot_datafeed_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotDatafeedSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_spot_datafeed_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotDatafeedSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_spot_fleet_instances(spot_fleet_request_id)
    describe_spot_fleet_instances(spot_fleet_request_id, params::Dict{String,<:Any})

Describes the running instances for the specified Spot Fleet.

# Arguments
- `spot_fleet_request_id`: The ID of the Spot Fleet request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token to include in another request to get the next page of items.
  This value is null when there are no more items to return.
"""
function describe_spot_fleet_instances(
    spotFleetRequestId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotFleetInstances",
        Dict{String,Any}("spotFleetRequestId" => spotFleetRequestId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_spot_fleet_instances(
    spotFleetRequestId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeSpotFleetInstances",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("spotFleetRequestId" => spotFleetRequestId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_spot_fleet_request_history(spot_fleet_request_id, start_time)
    describe_spot_fleet_request_history(spot_fleet_request_id, start_time, params::Dict{String,<:Any})

Describes the events for the specified Spot Fleet request during the specified time. Spot
Fleet events are delayed by up to 30 seconds before they can be described. This ensures
that you can query by the last evaluated time and not miss a recorded event. Spot Fleet
events are available for 48 hours. For more information, see Monitor fleet events using
Amazon EventBridge in the Amazon EC2 User Guide.

# Arguments
- `spot_fleet_request_id`: The ID of the Spot Fleet request.
- `start_time`: The starting date and time for the events, in UTC format (for example,
  YYYY-MM-DDTHH:MM:SSZ).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"eventType"`: The type of events to describe. By default, all events are described.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token to include in another request to get the next page of items.
  This value is null when there are no more items to return.
"""
function describe_spot_fleet_request_history(
    spotFleetRequestId, startTime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotFleetRequestHistory",
        Dict{String,Any}(
            "spotFleetRequestId" => spotFleetRequestId, "startTime" => startTime
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_spot_fleet_request_history(
    spotFleetRequestId,
    startTime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeSpotFleetRequestHistory",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "spotFleetRequestId" => spotFleetRequestId, "startTime" => startTime
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_spot_fleet_requests()
    describe_spot_fleet_requests(params::Dict{String,<:Any})

Describes your Spot Fleet requests. Spot Fleet requests are deleted 48 hours after they are
canceled and their instances are terminated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token to include in another request to get the next page of items.
  This value is null when there are no more items to return.
- `"spotFleetRequestId"`: The IDs of the Spot Fleet requests.
"""
function describe_spot_fleet_requests(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeSpotFleetRequests"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_spot_fleet_requests(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotFleetRequests",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_spot_instance_requests()
    describe_spot_instance_requests(params::Dict{String,<:Any})

Describes the specified Spot Instance requests. You can use DescribeSpotInstanceRequests to
find a running Spot Instance by examining the response. If the status of the Spot Instance
is fulfilled, the instance ID appears in the response and contains the identifier of the
instance. Alternatively, you can use DescribeInstances with a filter to look for instances
where the instance lifecycle is spot. We recommend that you set MaxResults to a value
between 5 and 1000 to limit the number of items returned. This paginates the output, which
makes the list more manageable and returns the items faster. If the list of items exceeds
your MaxResults value, then that number of items is returned along with a NextToken value
that can be passed to a subsequent DescribeSpotInstanceRequests request to retrieve the
remaining items. Spot Instance requests are deleted four hours after they are canceled and
their instances are terminated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    availability-zone-group - The Availability Zone group.
  create-time - The time stamp when the Spot Instance request was created.    fault-code -
  The fault code related to the request.    fault-message - The fault message related to the
  request.    instance-id - The ID of the instance that fulfilled the request.
  launch-group - The Spot Instance launch group.
  launch.block-device-mapping.delete-on-termination - Indicates whether the EBS volume is
  deleted on instance termination.    launch.block-device-mapping.device-name - The device
  name for the volume in the block device mapping (for example, /dev/sdh or xvdh).
  launch.block-device-mapping.snapshot-id - The ID of the snapshot for the EBS volume.
  launch.block-device-mapping.volume-size - The size of the EBS volume, in GiB.
  launch.block-device-mapping.volume-type - The type of EBS volume: gp2 or gp3 for General
  Purpose SSD, io1 or io2 for Provisioned IOPS SSD, st1 for Throughput Optimized HDD, sc1 for
  Cold HDD, or standard for Magnetic.    launch.group-id - The ID of the security group for
  the instance.    launch.group-name - The name of the security group for the instance.
  launch.image-id - The ID of the AMI.    launch.instance-type - The type of instance (for
  example, m3.medium).    launch.kernel-id - The kernel ID.    launch.key-name - The name of
  the key pair the instance launched with.    launch.monitoring-enabled - Whether detailed
  monitoring is enabled for the Spot Instance.    launch.ramdisk-id - The RAM disk ID.
  launched-availability-zone - The Availability Zone in which the request is launched.
  network-interface.addresses.primary - Indicates whether the IP address is the primary
  private IP address.    network-interface.delete-on-termination - Indicates whether the
  network interface is deleted when the instance is terminated.
  network-interface.description - A description of the network interface.
  network-interface.device-index - The index of the device for the network interface
  attachment on the instance.    network-interface.group-id - The ID of the security group
  associated with the network interface.    network-interface.network-interface-id - The ID
  of the network interface.    network-interface.private-ip-address - The primary private IP
  address of the network interface.    network-interface.subnet-id - The ID of the subnet for
  the instance.    product-description - The product description associated with the instance
  (Linux/UNIX | Windows).    spot-instance-request-id - The Spot Instance request ID.
  spot-price - The maximum hourly price for any Spot Instance launched to fulfill the
  request.    state - The state of the Spot Instance request (open | active | closed |
  cancelled | failed). Spot request status information can help you track your Amazon EC2
  Spot Instance requests. For more information, see Spot request status in the Amazon EC2
  User Guide.    status-code - The short code describing the most recent evaluation of your
  Spot Instance request.    status-message - The message explaining the status of the Spot
  Instance request.    tag:&lt;key&gt; - The key/value combination of a tag assigned to the
  resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.    type - The type of Spot Instance
  request (one-time | persistent).    valid-from - The start date of the request.
  valid-until - The end date of the request.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"SpotInstanceRequestId"`: The IDs of the Spot Instance requests.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_spot_instance_requests(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotInstanceRequests";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_spot_instance_requests(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotInstanceRequests",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_spot_price_history()
    describe_spot_price_history(params::Dict{String,<:Any})

Describes the Spot price history. For more information, see Spot Instance pricing history
in the Amazon EC2 User Guide. When you specify a start and end time, the operation returns
the prices of the instance types within that time range. It also returns the last price
change before the start time, which is the effective price as of the start time.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    availability-zone - The Availability Zone for which prices
  should be returned.    instance-type - The type of instance (for example, m3.medium).
  product-description - The product description for the Spot price (Linux/UNIX | Red Hat
  Enterprise Linux | SUSE Linux | Windows | Linux/UNIX (Amazon VPC) | Red Hat Enterprise
  Linux (Amazon VPC) | SUSE Linux (Amazon VPC) | Windows (Amazon VPC)).    spot-price - The
  Spot price. The value must match exactly (or use wildcards; greater than or less than
  comparison is not supported).    timestamp - The time stamp of the Spot price history, in
  UTC format (for example, ddd MMM dd HH:mm:ss UTC YYYY). You can use wildcards (* and ?).
  Greater than or less than comparison is not supported.
- `"InstanceType"`: Filters the results by the specified instance types.
- `"ProductDescription"`: Filters the results by the specified basic product descriptions.
- `"availabilityZone"`: Filters the results by the specified Availability Zone.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"endTime"`: The date and time, up to the current date, from which to stop retrieving the
  price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"startTime"`: The date and time, up to the past 90 days, from which to start retrieving
  the price history data, in UTC format (for example, YYYY-MM-DDTHH:MM:SSZ).
"""
function describe_spot_price_history(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeSpotPriceHistory"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_spot_price_history(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSpotPriceHistory",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_stale_security_groups(vpc_id)
    describe_stale_security_groups(vpc_id, params::Dict{String,<:Any})

Describes the stale security group rules for security groups in a specified VPC. Rules are
stale when they reference a deleted security group in the same VPC or peered VPC. Rules can
also be stale if they reference a security group in a peer VPC for which the VPC peering
connection has been deleted.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_stale_security_groups(
    VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeStaleSecurityGroups",
        Dict{String,Any}("VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_stale_security_groups(
    VpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeStaleSecurityGroups",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("VpcId" => VpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_store_image_tasks()
    describe_store_image_tasks(params::Dict{String,<:Any})

Describes the progress of the AMI store tasks. You can describe the store tasks for
specified AMIs. If you don't specify the AMIs, you get a paginated list of store tasks from
the last 31 days. For each AMI task, the response indicates if the task is InProgress,
Completed, or Failed. For tasks InProgress, the response shows the estimated progress as a
percentage. Tasks are listed in reverse chronological order. Currently, only tasks from the
past 31 days can be viewed. To use this API, you must have the required permissions. For
more information, see Permissions for storing and restoring AMIs using Amazon S3 in the
Amazon EC2 User Guide. For more information, see Store and restore an AMI using Amazon S3
in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    task-state - Returns tasks in a certain state (InProgress |
  Completed | Failed)    bucket - Returns task information for tasks that targeted a specific
  bucket. For the filter value, specify the bucket name.    When you specify the ImageIds
  parameter, any filters that you specify are ignored. To use the filters, you must remove
  the ImageIds parameter.
- `"ImageId"`: The AMI IDs for which to show progress. Up to 20 AMI IDs can be included in
  a request.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination. You cannot specify this parameter and the ImageIds parameter
  in the same call.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_store_image_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeStoreImageTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_store_image_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeStoreImageTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_subnets()
    describe_subnets(params::Dict{String,<:Any})

Describes your subnets. The default is to describe all your subnets. Alternatively, you can
specify specific subnet IDs or filter the results to include only the subnets that match
specific criteria. For more information, see Subnets in the Amazon VPC User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    availability-zone - The Availability Zone for the subnet. You
  can also use availabilityZone as the filter name.    availability-zone-id - The ID of the
  Availability Zone for the subnet. You can also use availabilityZoneId as the filter name.
   available-ip-address-count - The number of IPv4 addresses in the subnet that are
  available.    cidr-block - The IPv4 CIDR block of the subnet. The CIDR block you specify
  must exactly match the subnet's CIDR block for information to be returned for the subnet.
  You can also use cidr or cidrBlock as the filter names.    customer-owned-ipv4-pool - The
  customer-owned IPv4 address pool associated with the subnet.    default-for-az - Indicates
  whether this is the default subnet for the Availability Zone (true | false). You can also
  use defaultForAz as the filter name.    enable-dns64 - Indicates whether DNS queries made
  to the Amazon-provided DNS Resolver in this subnet should return synthetic IPv6 addresses
  for IPv4-only destinations.    enable-lni-at-device-index - Indicates the device position
  for local network interfaces in this subnet. For example, 1 indicates local network
  interfaces in this subnet are the secondary network interface (eth1).
  ipv6-cidr-block-association.ipv6-cidr-block - An IPv6 CIDR block associated with the
  subnet.    ipv6-cidr-block-association.association-id - An association ID for an IPv6 CIDR
  block associated with the subnet.    ipv6-cidr-block-association.state - The state of an
  IPv6 CIDR block associated with the subnet.    ipv6-native - Indicates whether this is an
  IPv6 only subnet (true | false).    map-customer-owned-ip-on-launch - Indicates whether a
  network interface created in this subnet (including a network interface created by
  RunInstances) receives a customer-owned IPv4 address.    map-public-ip-on-launch -
  Indicates whether instances launched in this subnet receive a public IPv4 address.
  outpost-arn - The Amazon Resource Name (ARN) of the Outpost.    owner-id - The ID of the
  Amazon Web Services account that owns the subnet.
  private-dns-name-options-on-launch.hostname-type - The type of hostname to assign to
  instances in the subnet at launch. For IPv4-only and dual-stack (IPv4 and IPv6) subnets, an
  instance DNS name can be based on the instance IPv4 address (ip-name) or the instance ID
  (resource-name). For IPv6 only subnets, an instance DNS name must be based on the instance
  ID (resource-name).    private-dns-name-options-on-launch.enable-resource-name-dns-a-record
  - Indicates whether to respond to DNS queries for instance hostnames with DNS A records.
  private-dns-name-options-on-launch.enable-resource-name-dns-aaaa-record - Indicates whether
  to respond to DNS queries for instance hostnames with DNS AAAA records.    state - The
  state of the subnet (pending | available).    subnet-arn - The Amazon Resource Name (ARN)
  of the subnet.    subnet-id - The ID of the subnet.    tag:&lt;key&gt; - The key/value
  combination of a tag assigned to the resource. Use the tag key in the filter name and the
  tag value as the filter value. For example, to find all resources that have a tag with the
  key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the
  filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to
  find all resources assigned a tag with a specific key, regardless of the tag value.
  vpc-id - The ID of the VPC for the subnet.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"SubnetId"`: The IDs of the subnets. Default: Describes all your subnets.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_subnets(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeSubnets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_subnets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeSubnets", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_tags()
    describe_tags(params::Dict{String,<:Any})

Describes the specified tags for your EC2 resources. For more information about tags, see
Tag your Amazon EC2 resources in the Amazon Elastic Compute Cloud User Guide.  We strongly
recommend using only paginated requests. Unpaginated requests are susceptible to throttling
and timeouts.   The order of the elements in the response, including those within nested
structures, might vary. Applications should not assume the elements appear in a particular
order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    key - The tag key.    resource-id - The ID of the resource.
   resource-type - The resource type. For a list of possible values, see TagSpecification.
  tag:&lt;key&gt; - The key/value combination of the tag. For example, specify \"tag:Owner\"
  for the filter name and \"TeamA\" for the filter value to find resources with the tag
  \"Owner=TeamA\".    value - The tag value.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. This value can be
  between 5 and 1000. To get the next page of items, make another request with the token
  returned in the output. For more information, see Pagination.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_tags(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeTags"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_tags(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTags", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_traffic_mirror_filter_rules()
    describe_traffic_mirror_filter_rules(params::Dict{String,<:Any})

Describe traffic mirror filters that determine the traffic that is mirrored.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: Traffic mirror filters.    traffic-mirror-filter-rule-id: The ID of the
  Traffic Mirror rule.    traffic-mirror-filter-id: The ID of the filter that this rule is
  associated with.    rule-number: The number of the Traffic Mirror rule.    rule-action: The
  action taken on the filtered traffic. Possible actions are accept and reject.
  traffic-direction: The traffic direction. Possible directions are ingress and egress.
  protocol: The protocol, for example UDP, assigned to the Traffic Mirror rule.
  source-cidr-block: The source CIDR block assigned to the Traffic Mirror rule.
  destination-cidr-block: The destination CIDR block assigned to the Traffic Mirror rule.
  description: The description of the Traffic Mirror rule.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TrafficMirrorFilterId"`: Traffic filter ID.
- `"TrafficMirrorFilterRuleId"`: Traffic filter rule IDs.
"""
function describe_traffic_mirror_filter_rules(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorFilterRules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_traffic_mirror_filter_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorFilterRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_traffic_mirror_filters()
    describe_traffic_mirror_filters(params::Dict{String,<:Any})

Describes one or more Traffic Mirror filters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    description: The Traffic
  Mirror filter description.    traffic-mirror-filter-id: The ID of the Traffic Mirror
  filter.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TrafficMirrorFilterId"`: The ID of the Traffic Mirror filter.
"""
function describe_traffic_mirror_filters(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorFilters";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_traffic_mirror_filters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorFilters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_traffic_mirror_sessions()
    describe_traffic_mirror_sessions(params::Dict{String,<:Any})

Describes one or more Traffic Mirror sessions. By default, all Traffic Mirror sessions are
described. Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    description: The Traffic
  Mirror session description.    network-interface-id: The ID of the Traffic Mirror session
  network interface.    owner-id: The ID of the account that owns the Traffic Mirror session.
     packet-length: The assigned number of packets to mirror.     session-number: The
  assigned session number.     traffic-mirror-filter-id: The ID of the Traffic Mirror filter.
     traffic-mirror-session-id: The ID of the Traffic Mirror session.
  traffic-mirror-target-id: The ID of the Traffic Mirror target.    virtual-network-id: The
  virtual network ID of the Traffic Mirror session.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TrafficMirrorSessionId"`: The ID of the Traffic Mirror session.
"""
function describe_traffic_mirror_sessions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorSessions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_traffic_mirror_sessions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorSessions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_traffic_mirror_targets()
    describe_traffic_mirror_targets(params::Dict{String,<:Any})

Information about one or more Traffic Mirror targets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    description: The Traffic
  Mirror target description.    network-interface-id: The ID of the Traffic Mirror session
  network interface.    network-load-balancer-arn: The Amazon Resource Name (ARN) of the
  Network Load Balancer that is associated with the session.    owner-id: The ID of the
  account that owns the Traffic Mirror session.    traffic-mirror-target-id: The ID of the
  Traffic Mirror target.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TrafficMirrorTargetId"`: The ID of the Traffic Mirror targets.
"""
function describe_traffic_mirror_targets(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorTargets";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_traffic_mirror_targets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrafficMirrorTargets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_attachments()
    describe_transit_gateway_attachments(params::Dict{String,<:Any})

Describes one or more attachments between resources and transit gateways. By default, all
attachments are described. Alternatively, you can filter the results by attachment ID,
attachment state, resource ID, or resource owner.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    association.state - The
  state of the association (associating | associated | disassociating).
  association.transit-gateway-route-table-id - The ID of the route table for the transit
  gateway.    resource-id - The ID of the resource.    resource-owner-id - The ID of the
  Amazon Web Services account that owns the resource.    resource-type - The resource type.
  Valid values are vpc | vpn | direct-connect-gateway | peering | connect.    state - The
  state of the attachment. Valid values are available | deleted | deleting | failed | failing
  | initiatingRequest | modifying | pendingAcceptance | pending | rollingBack | rejected |
  rejecting.    transit-gateway-attachment-id - The ID of the attachment.
  transit-gateway-id - The ID of the transit gateway.    transit-gateway-owner-id - The ID of
  the Amazon Web Services account that owns the transit gateway.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayAttachmentIds"`: The IDs of the attachments.
"""
function describe_transit_gateway_attachments(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayAttachments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_attachments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayAttachments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_connect_peers()
    describe_transit_gateway_connect_peers(params::Dict{String,<:Any})

Describes one or more Connect peers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    state - The state of the
  Connect peer (pending | available | deleting | deleted).    transit-gateway-attachment-id -
  The ID of the attachment.    transit-gateway-connect-peer-id - The ID of the Connect peer.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayConnectPeerIds"`: The IDs of the Connect peers.
"""
function describe_transit_gateway_connect_peers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayConnectPeers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_connect_peers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayConnectPeers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_connects()
    describe_transit_gateway_connects(params::Dict{String,<:Any})

Describes one or more Connect attachments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    options.protocol - The
  tunnel protocol (gre).    state - The state of the attachment (initiating |
  initiatingRequest | pendingAcceptance | rollingBack | pending | available | modifying |
  deleting | deleted | failed | rejected | rejecting | failing).
  transit-gateway-attachment-id - The ID of the Connect attachment.    transit-gateway-id -
  The ID of the transit gateway.    transport-transit-gateway-attachment-id - The ID of the
  transit gateway attachment from which the Connect attachment was created.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayAttachmentIds"`: The IDs of the attachments.
"""
function describe_transit_gateway_connects(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayConnects";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_connects(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayConnects",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_multicast_domains()
    describe_transit_gateway_multicast_domains(params::Dict{String,<:Any})

Describes one or more transit gateway multicast domains.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    state - The state of the
  transit gateway multicast domain. Valid values are pending | available | deleting |
  deleted.    transit-gateway-id - The ID of the transit gateway.
  transit-gateway-multicast-domain-id - The ID of the transit gateway multicast domain.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayMulticastDomainIds"`: The ID of the transit gateway multicast domain.
"""
function describe_transit_gateway_multicast_domains(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayMulticastDomains";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_multicast_domains(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayMulticastDomains",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_peering_attachments()
    describe_transit_gateway_peering_attachments(params::Dict{String,<:Any})

Describes your transit gateway peering attachments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:
  transit-gateway-attachment-id - The ID of the transit gateway attachment.    local-owner-id
  - The ID of your Amazon Web Services account.    remote-owner-id - The ID of the Amazon Web
  Services account in the remote Region that owns the transit gateway.    state - The state
  of the peering attachment. Valid values are available | deleted | deleting | failed |
  failing | initiatingRequest | modifying | pendingAcceptance | pending | rollingBack |
  rejected | rejecting).    tag:&lt;key&gt; - The key/value combination of a tag assigned to
  the resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources that have a tag
  with a specific key, regardless of the tag value.    transit-gateway-id - The ID of the
  transit gateway.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayAttachmentIds"`: One or more IDs of the transit gateway peering
  attachments.
"""
function describe_transit_gateway_peering_attachments(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayPeeringAttachments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_peering_attachments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayPeeringAttachments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_policy_tables()
    describe_transit_gateway_policy_tables(params::Dict{String,<:Any})

Describes one or more transit gateway route policy tables.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters associated with the transit gateway policy table.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayPolicyTableIds"`: The IDs of the transit gateway policy tables.
"""
function describe_transit_gateway_policy_tables(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayPolicyTables";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_policy_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayPolicyTables",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_route_table_announcements()
    describe_transit_gateway_route_table_announcements(params::Dict{String,<:Any})

Describes one or more transit gateway route table advertisements.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters associated with the transit gateway policy table.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayRouteTableAnnouncementIds"`: The IDs of the transit gateway route tables
  that are being advertised.
"""
function describe_transit_gateway_route_table_announcements(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayRouteTableAnnouncements";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_route_table_announcements(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayRouteTableAnnouncements",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_route_tables()
    describe_transit_gateway_route_tables(params::Dict{String,<:Any})

Describes one or more transit gateway route tables. By default, all transit gateway route
tables are described. Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:
  default-association-route-table - Indicates whether this is the default association route
  table for the transit gateway (true | false).    default-propagation-route-table -
  Indicates whether this is the default propagation route table for the transit gateway (true
  | false).    state - The state of the route table (available | deleting | deleted |
  pending).    transit-gateway-id - The ID of the transit gateway.
  transit-gateway-route-table-id - The ID of the transit gateway route table.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayRouteTableIds"`: The IDs of the transit gateway route tables.
"""
function describe_transit_gateway_route_tables(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayRouteTables";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_route_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayRouteTables",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateway_vpc_attachments()
    describe_transit_gateway_vpc_attachments(params::Dict{String,<:Any})

Describes one or more VPC attachments. By default, all VPC attachments are described.
Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:    state - The state of the
  attachment. Valid values are available | deleted | deleting | failed | failing |
  initiatingRequest | modifying | pendingAcceptance | pending | rollingBack | rejected |
  rejecting.    transit-gateway-attachment-id - The ID of the attachment.
  transit-gateway-id - The ID of the transit gateway.    vpc-id - The ID of the VPC.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayAttachmentIds"`: The IDs of the attachments.
"""
function describe_transit_gateway_vpc_attachments(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayVpcAttachments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_transit_gateway_vpc_attachments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGatewayVpcAttachments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_transit_gateways()
    describe_transit_gateways(params::Dict{String,<:Any})

Describes one or more transit gateways. By default, all transit gateways are described.
Alternatively, you can filter the results.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:
  options.propagation-default-route-table-id - The ID of the default propagation route table.
     options.amazon-side-asn - The private ASN for the Amazon side of a BGP session.
  options.association-default-route-table-id - The ID of the default association route table.
     options.auto-accept-shared-attachments - Indicates whether there is automatic acceptance
  of attachment requests (enable | disable).    options.default-route-table-association -
  Indicates whether resource attachments are automatically associated with the default
  association route table (enable | disable).    options.default-route-table-propagation -
  Indicates whether resource attachments automatically propagate routes to the default
  propagation route table (enable | disable).    options.dns-support - Indicates whether DNS
  support is enabled (enable | disable).    options.vpn-ecmp-support - Indicates whether
  Equal Cost Multipath Protocol support is enabled (enable | disable).    owner-id - The ID
  of the Amazon Web Services account that owns the transit gateway.    state - The state of
  the transit gateway (available | deleted | deleting | modifying | pending).
  transit-gateway-id - The ID of the transit gateway.    tag-key - The key/value combination
  of a tag assigned to the resource. Use the tag key in the filter name and the tag value as
  the filter value. For example, to find all resources that have a tag with the key Owner and
  the value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"TransitGatewayIds"`: The IDs of the transit gateways.
"""
function describe_transit_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeTransitGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_transit_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTransitGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_trunk_interface_associations()
    describe_trunk_interface_associations(params::Dict{String,<:Any})

Describes one or more network interface trunk associations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationId"`: The IDs of the associations.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    gre-key - The ID of a trunk interface association.
  interface-protocol - The interface protocol. Valid values are VLAN and GRE.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function describe_trunk_interface_associations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrunkInterfaceAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_trunk_interface_associations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeTrunkInterfaceAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_access_endpoints()
    describe_verified_access_endpoints(params::Dict{String,<:Any})

Describes the specified Amazon Web Services Verified Access endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"VerifiedAccessEndpointId"`: The ID of the Verified Access endpoint.
- `"VerifiedAccessGroupId"`: The ID of the Verified Access group.
- `"VerifiedAccessInstanceId"`: The ID of the Verified Access instance.
"""
function describe_verified_access_endpoints(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessEndpoints";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_access_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_access_groups()
    describe_verified_access_groups(params::Dict{String,<:Any})

Describes the specified Verified Access groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"VerifiedAccessGroupId"`: The ID of the Verified Access groups.
- `"VerifiedAccessInstanceId"`: The ID of the Verified Access instance.
"""
function describe_verified_access_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_access_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_access_instance_logging_configurations()
    describe_verified_access_instance_logging_configurations(params::Dict{String,<:Any})

Describes the specified Amazon Web Services Verified Access instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"VerifiedAccessInstanceId"`: The IDs of the Verified Access instances.
"""
function describe_verified_access_instance_logging_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessInstanceLoggingConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_access_instance_logging_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessInstanceLoggingConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_access_instances()
    describe_verified_access_instances(params::Dict{String,<:Any})

Describes the specified Amazon Web Services Verified Access instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"VerifiedAccessInstanceId"`: The IDs of the Verified Access instances.
"""
function describe_verified_access_instances(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessInstances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_access_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_verified_access_trust_providers()
    describe_verified_access_trust_providers(params::Dict{String,<:Any})

Describes the specified Amazon Web Services Verified Access trust providers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. Filter names and values are case-sensitive.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"VerifiedAccessTrustProviderId"`: The IDs of the Verified Access trust providers.
"""
function describe_verified_access_trust_providers(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessTrustProviders";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_verified_access_trust_providers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVerifiedAccessTrustProviders",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_volume_attribute(attribute, volume_id)
    describe_volume_attribute(attribute, volume_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified volume. You can specify only one
attribute at a time. For more information about EBS volumes, see Amazon EBS volumes in the
Amazon EBS User Guide.

# Arguments
- `attribute`: The attribute of the volume. This parameter is required.
- `volume_id`: The ID of the volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_volume_attribute(
    Attribute, VolumeId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVolumeAttribute",
        Dict{String,Any}("Attribute" => Attribute, "VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_volume_attribute(
    Attribute,
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeVolumeAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Attribute" => Attribute, "VolumeId" => VolumeId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_volume_status()
    describe_volume_status(params::Dict{String,<:Any})

Describes the status of the specified volumes. Volume status provides the result of the
checks performed on your volumes to determine events that can impair the performance of
your volumes. The performance of a volume can be affected if an issue occurs on the
volume's underlying host. If the volume's underlying host experiences a power outage or
system issue, after the system is restored, there could be data inconsistencies on the
volume. Volume events notify you if this occurs. Volume actions notify you if any action
needs to be taken in response to the event. The DescribeVolumeStatus operation provides the
following information about the specified volumes:  Status: Reflects the current status of
the volume. The possible values are ok, impaired , warning, or insufficient-data. If all
checks pass, the overall status of the volume is ok. If the check fails, the overall status
is impaired. If the status is insufficient-data, then the checks might still be taking
place on your volume at the time. We recommend that you retry the request. For more
information about volume status, see Monitor the status of your volumes in the Amazon EBS
User Guide.  Events: Reflect the cause of a volume status and might require you to take
action. For example, if your volume returns an impaired status, then the volume event might
be potential-data-inconsistency. This means that your volume has been affected by an issue
with the underlying host, has all I/O operations disabled, and might have inconsistent
data.  Actions: Reflect the actions you might have to take in response to an event. For
example, if the status of the volume is impaired and the volume event shows
potential-data-inconsistency, then the action shows enable-volume-io. This means that you
may want to enable the I/O operations for the volume by calling the EnableVolumeIO action
and then check the volume for data consistency. Volume status is based on the volume status
checks, and does not reflect the volume state. Therefore, volume status does not indicate
volumes in the error state (for example, when a volume is incapable of accepting I/O.)  The
order of the elements in the response, including those within nested structures, might
vary. Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    action.code - The action code for the event (for example,
  enable-volume-io).    action.description - A description of the action.    action.event-id
  - The event ID associated with the action.    availability-zone - The Availability Zone of
  the instance.    event.description - A description of the event.    event.event-id - The
  event ID.    event.event-type - The event type (for io-enabled: passed | failed; for
  io-performance: io-performance:degraded | io-performance:severely-degraded |
  io-performance:stalled).    event.not-after - The latest end time for the event.
  event.not-before - The earliest start time for the event.    volume-status.details-name -
  The cause for volume-status.status (io-enabled | io-performance).
  volume-status.details-status - The status of volume-status.details-name (for io-enabled:
  passed | failed; for io-performance: normal | degraded | severely-degraded | stalled).
  volume-status.status - The status of the volume (ok | impaired | warning |
  insufficient-data).
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"VolumeId"`: The IDs of the volumes. Default: Describes all your volumes.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_volume_status(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeVolumeStatus"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_volume_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVolumeStatus",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_volumes()
    describe_volumes(params::Dict{String,<:Any})

Describes the specified EBS volumes or all of your EBS volumes. If you are describing a
long list of volumes, we recommend that you paginate the output to make the list more
manageable. For more information, see Pagination. For more information about EBS volumes,
see Amazon EBS volumes in the Amazon EBS User Guide.  We strongly recommend using only
paginated requests. Unpaginated requests are susceptible to throttling and timeouts.   The
order of the elements in the response, including those within nested structures, might
vary. Applications should not assume the elements appear in a particular order.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    attachment.attach-time - The time stamp when the attachment
  initiated.    attachment.delete-on-termination - Whether the volume is deleted on instance
  termination.    attachment.device - The device name specified in the block device mapping
  (for example, /dev/sda1).    attachment.instance-id - The ID of the instance the volume is
  attached to.    attachment.status - The attachment state (attaching | attached |
  detaching).    availability-zone - The Availability Zone in which the volume was created.
   create-time - The time stamp when the volume was created.    encrypted - Indicates whether
  the volume is encrypted (true | false)    multi-attach-enabled - Indicates whether the
  volume is enabled for Multi-Attach (true | false)    fast-restored - Indicates whether the
  volume was created from a snapshot that is enabled for fast snapshot restore (true |
  false).    size - The size of the volume, in GiB.    snapshot-id - The snapshot from which
  the volume was created.    status - The state of the volume (creating | available | in-use
  | deleting | deleted | error).    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.    volume-id - The volume
  ID.    volume-type - The Amazon EBS volume type (gp2 | gp3 | io1 | io2 | st1 | sc1|
  standard)
- `"VolumeId"`: The volume IDs.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_volumes(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeVolumes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_volumes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVolumes", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_volumes_modifications()
    describe_volumes_modifications(params::Dict{String,<:Any})

Describes the most recent volume modification request for the specified EBS volumes. If a
volume has never been modified, some information in the output will be null. If a volume
has been modified more than once, the output includes only the most recent modification
request. For more information, see  Monitor the progress of volume modifications in the
Amazon EBS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    modification-state - The current modification state
  (modifying | optimizing | completed | failed).    original-iops - The original IOPS rate of
  the volume.    original-size - The original size of the volume, in GiB.
  original-volume-type - The original volume type of the volume (standard | io1 | io2 | gp2 |
  sc1 | st1).    originalMultiAttachEnabled - Indicates whether Multi-Attach support was
  enabled (true | false).    start-time - The modification start time.    target-iops - The
  target IOPS rate of the volume.    target-size - The target size of the volume, in GiB.
  target-volume-type - The target volume type of the volume (standard | io1 | io2 | gp2 | sc1
  | st1).    targetMultiAttachEnabled - Indicates whether Multi-Attach support is to be
  enabled (true | false).    volume-id - The ID of the volume.
- `"MaxResults"`: The maximum number of results (up to a limit of 500) to be returned in a
  paginated request. For more information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"VolumeId"`: The IDs of the volumes.
"""
function describe_volumes_modifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVolumesModifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_volumes_modifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVolumesModifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_attribute(attribute, vpc_id)
    describe_vpc_attribute(attribute, vpc_id, params::Dict{String,<:Any})

Describes the specified attribute of the specified VPC. You can specify only one attribute
at a time.

# Arguments
- `attribute`: The VPC attribute.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpc_attribute(
    Attribute, VpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcAttribute",
        Dict{String,Any}("Attribute" => Attribute, "VpcId" => VpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_attribute(
    Attribute,
    VpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeVpcAttribute",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("Attribute" => Attribute, "VpcId" => VpcId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_classic_link()
    describe_vpc_classic_link(params::Dict{String,<:Any})

 This action is deprecated.  Describes the ClassicLink status of the specified VPCs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    is-classic-link-enabled - Whether the VPC is enabled for
  ClassicLink (true | false).    tag:&lt;key&gt; - The key/value combination of a tag
  assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.
- `"VpcId"`: The VPCs for which you want to describe the ClassicLink status.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpc_classic_link(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeVpcClassicLink"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_vpc_classic_link(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcClassicLink",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_classic_link_dns_support()
    describe_vpc_classic_link_dns_support(params::Dict{String,<:Any})

 This action is deprecated.  Describes the ClassicLink DNS support status of one or more
VPCs. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its private
IP address when addressed from an instance in the VPC to which it's linked. Similarly, the
DNS hostname of an instance in a VPC resolves to its private IP address when addressed from
a linked EC2-Classic instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VpcIds"`: The IDs of the VPCs.
- `"maxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"nextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
"""
function describe_vpc_classic_link_dns_support(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcClassicLinkDnsSupport";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_classic_link_dns_support(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcClassicLinkDnsSupport",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoint_connection_notifications()
    describe_vpc_endpoint_connection_notifications(params::Dict{String,<:Any})

Describes the connection notifications for VPC endpoints and VPC endpoint services.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionNotificationId"`: The ID of the notification.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    connection-notification-arn - The ARN of the SNS topic for
  the notification.    connection-notification-id - The ID of the notification.
  connection-notification-state - The state of the notification (Enabled | Disabled).
  connection-notification-type - The type of notification (Topic).    service-id - The ID of
  the endpoint service.    vpc-endpoint-id - The ID of the VPC endpoint.
- `"MaxResults"`: The maximum number of results to return in a single call. To retrieve the
  remaining results, make another request with the returned NextToken value.
- `"NextToken"`: The token to request the next page of results.
"""
function describe_vpc_endpoint_connection_notifications(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointConnectionNotifications";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoint_connection_notifications(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointConnectionNotifications",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoint_connections()
    describe_vpc_endpoint_connections(params::Dict{String,<:Any})

Describes the VPC endpoint connections to your VPC endpoint services, including any
endpoints that are pending your acceptance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    ip-address-type - The IP address type (ipv4 | ipv6).
  service-id - The ID of the service.    vpc-endpoint-owner - The ID of the Amazon Web
  Services account ID that owns the endpoint.    vpc-endpoint-state - The state of the
  endpoint (pendingAcceptance | pending | available | deleting | deleted | rejected |
  failed).    vpc-endpoint-id - The ID of the endpoint.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results of the initial request can be seen by sending another request with
  the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given
  a value larger than 1,000, only 1,000 results are returned.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_vpc_endpoint_connections(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointConnections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoint_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointConnections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoint_service_configurations()
    describe_vpc_endpoint_service_configurations(params::Dict{String,<:Any})

Describes the VPC endpoint service configurations in your account (your services).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    service-name - The name of the service.    service-id - The
  ID of the service.    service-state - The state of the service (Pending | Available |
  Deleting | Deleted | Failed).     supported-ip-address-types - The IP address type (ipv4 |
  ipv6).    tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource.
  Use the tag key in the filter name and the tag value as the filter value. For example, to
  find all resources that have a tag with the key Owner and the value TeamA, specify
  tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key of a tag
  assigned to the resource. Use this filter to find all resources assigned a tag with a
  specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results of the initial request can be seen by sending another request with
  the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given
  a value larger than 1,000, only 1,000 results are returned.
- `"NextToken"`: The token to retrieve the next page of results.
- `"ServiceId"`: The IDs of the endpoint services.
"""
function describe_vpc_endpoint_service_configurations(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointServiceConfigurations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoint_service_configurations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointServiceConfigurations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoint_service_permissions(service_id)
    describe_vpc_endpoint_service_permissions(service_id, params::Dict{String,<:Any})

Describes the principals (service consumers) that are permitted to discover your VPC
endpoint service.

# Arguments
- `service_id`: The ID of the service.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    principal - The ARN of the principal.    principal-type - The
  principal type (All | Service | OrganizationUnit | Account | User | Role).
- `"MaxResults"`: The maximum number of results to return for the request in a single page.
  The remaining results of the initial request can be seen by sending another request with
  the returned NextToken value. This value can be between 5 and 1,000; if MaxResults is given
  a value larger than 1,000, only 1,000 results are returned.
- `"NextToken"`: The token to retrieve the next page of results.
"""
function describe_vpc_endpoint_service_permissions(
    ServiceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointServicePermissions",
        Dict{String,Any}("ServiceId" => ServiceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoint_service_permissions(
    ServiceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DescribeVpcEndpointServicePermissions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ServiceId" => ServiceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoint_services()
    describe_vpc_endpoint_services(params::Dict{String,<:Any})

Describes available services to which you can create a VPC endpoint. When the service
provider and the consumer have different accounts in multiple Availability Zones, and the
consumer views the VPC endpoint service information, the response only includes the common
Availability Zones. For example, when the service provider account uses us-east-1a and
us-east-1c and the consumer uses us-east-1a and us-east-1b, the response includes the VPC
endpoint services in the common Availability Zone, us-east-1a.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    owner - The ID or alias of the Amazon Web Services account
  that owns the service.    service-name - The name of the service.    service-type - The
  type of service (Interface | Gateway | GatewayLoadBalancer).    supported-ip-address-types
  - The IP address type (ipv4 | ipv6).    tag:&lt;key&gt; - The key/value combination of a
  tag assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.
- `"MaxResults"`: The maximum number of items to return for this request. The request
  returns a token that you can specify in a subsequent call to get the next set of results.
  Constraint: If the value is greater than 1,000, we return only 1,000 items.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a prior call.)
- `"ServiceName"`: The service names.
"""
function describe_vpc_endpoint_services(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointServices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_endpoint_services(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpointServices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_endpoints()
    describe_vpc_endpoints(params::Dict{String,<:Any})

Describes your VPC endpoints. The default is to describe all your VPC endpoints.
Alternatively, you can specify specific VPC endpoint IDs or filter the results to include
only the VPC endpoints that match specific criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: The filters.    ip-address-type - The IP address type (ipv4 | ipv6).
  service-name - The name of the service.    tag:&lt;key&gt; - The key/value combination of a
  tag assigned to the resource. Use the tag key in the filter name and the tag value as the
  filter value. For example, to find all resources that have a tag with the key Owner and the
  value TeamA, specify tag:Owner for the filter name and TeamA for the filter value.
  tag-key - The key of a tag assigned to the resource. Use this filter to find all resources
  assigned a tag with a specific key, regardless of the tag value.    vpc-id - The ID of the
  VPC in which the endpoint resides.    vpc-endpoint-id - The ID of the endpoint.
  vpc-endpoint-state - The state of the endpoint (pendingAcceptance | pending | available |
  deleting | deleted | rejected | failed).    vpc-endpoint-type - The type of VPC endpoint
  (Interface | Gateway | GatewayLoadBalancer).
- `"MaxResults"`: The maximum number of items to return for this request. The request
  returns a token that you can specify in a subsequent call to get the next set of results.
  Constraint: If the value is greater than 1,000, we return only 1,000 items.
- `"NextToken"`: The token for the next set of items to return. (You received this token
  from a prior call.)
- `"VpcEndpointId"`: The IDs of the VPC endpoints.
"""
function describe_vpc_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeVpcEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_vpc_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpc_peering_connections()
    describe_vpc_peering_connections(params::Dict{String,<:Any})

Describes your VPC peering connections. The default is to describe all your VPC peering
connections. Alternatively, you can specify specific VPC peering connection IDs or filter
the results to include only the VPC peering connections that match specific criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    accepter-vpc-info.cidr-block - The IPv4 CIDR block of the
  accepter VPC.    accepter-vpc-info.owner-id - The ID of the Amazon Web Services account
  that owns the accepter VPC.    accepter-vpc-info.vpc-id - The ID of the accepter VPC.
  expiration-time - The expiration date and time for the VPC peering connection.
  requester-vpc-info.cidr-block - The IPv4 CIDR block of the requester's VPC.
  requester-vpc-info.owner-id - The ID of the Amazon Web Services account that owns the
  requester VPC.    requester-vpc-info.vpc-id - The ID of the requester VPC.    status-code -
  The status of the VPC peering connection (pending-acceptance | failed | expired |
  provisioning | active | deleting | deleted | rejected).    status-message - A message that
  provides more information about the status of the VPC peering connection, if applicable.
  tag:&lt;key&gt; - The key/value combination of a tag assigned to the resource. Use the tag
  key in the filter name and the tag value as the filter value. For example, to find all
  resources that have a tag with the key Owner and the value TeamA, specify tag:Owner for the
  filter name and TeamA for the filter value.    tag-key - The key of a tag assigned to the
  resource. Use this filter to find all resources assigned a tag with a specific key,
  regardless of the tag value.    vpc-peering-connection-id - The ID of the VPC peering
  connection.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"VpcPeeringConnectionId"`: The IDs of the VPC peering connections. Default: Describes
  all your VPC peering connections.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpc_peering_connections(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcPeeringConnections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_vpc_peering_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcPeeringConnections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpcs()
    describe_vpcs(params::Dict{String,<:Any})

Describes your VPCs. The default is to describe all your VPCs. Alternatively, you can
specify specific VPC IDs or filter the results to include only the VPCs that match specific
criteria.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: The filters.    cidr - The primary IPv4 CIDR block of the VPC. The CIDR block
  you specify must exactly match the VPC's CIDR block for information to be returned for the
  VPC. Must contain the slash followed by one or two digits (for example, /28).
  cidr-block-association.cidr-block - An IPv4 CIDR block associated with the VPC.
  cidr-block-association.association-id - The association ID for an IPv4 CIDR block
  associated with the VPC.    cidr-block-association.state - The state of an IPv4 CIDR block
  associated with the VPC.    dhcp-options-id - The ID of a set of DHCP options.
  ipv6-cidr-block-association.ipv6-cidr-block - An IPv6 CIDR block associated with the VPC.
   ipv6-cidr-block-association.ipv6-pool - The ID of the IPv6 address pool from which the
  IPv6 CIDR block is allocated.    ipv6-cidr-block-association.association-id - The
  association ID for an IPv6 CIDR block associated with the VPC.
  ipv6-cidr-block-association.state - The state of an IPv6 CIDR block associated with the
  VPC.    is-default - Indicates whether the VPC is the default VPC.    owner-id - The ID of
  the Amazon Web Services account that owns the VPC.    state - The state of the VPC (pending
  | available).    tag:&lt;key&gt; - The key/value combination of a tag assigned to the
  resource. Use the tag key in the filter name and the tag value as the filter value. For
  example, to find all resources that have a tag with the key Owner and the value TeamA,
  specify tag:Owner for the filter name and TeamA for the filter value.    tag-key - The key
  of a tag assigned to the resource. Use this filter to find all resources assigned a tag
  with a specific key, regardless of the tag value.    vpc-id - The ID of the VPC.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token returned from a previous paginated request. Pagination continues
  from the end of the items returned by the previous request.
- `"VpcId"`: The IDs of the VPCs.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpcs(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2("DescribeVpcs"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_vpcs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpcs", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_vpn_connections()
    describe_vpn_connections(params::Dict{String,<:Any})

Describes one or more of your VPN connections. For more information, see Amazon Web
Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    customer-gateway-configuration - The configuration
  information for the customer gateway.    customer-gateway-id - The ID of a customer gateway
  associated with the VPN connection.    state - The state of the VPN connection (pending |
  available | deleting | deleted).    option.static-routes-only - Indicates whether the
  connection has static routes only. Used for devices that do not support Border Gateway
  Protocol (BGP).    route.destination-cidr-block - The destination CIDR block. This
  corresponds to the subnet used in a customer data center.    bgp-asn - The BGP Autonomous
  System Number (ASN) associated with a BGP device.    tag:&lt;key&gt; - The key/value
  combination of a tag assigned to the resource. Use the tag key in the filter name and the
  tag value as the filter value. For example, to find all resources that have a tag with the
  key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for the
  filter value.    tag-key - The key of a tag assigned to the resource. Use this filter to
  find all resources assigned a tag with a specific key, regardless of the tag value.    type
  - The type of VPN connection. Currently the only supported type is ipsec.1.
  vpn-connection-id - The ID of the VPN connection.    vpn-gateway-id - The ID of a virtual
  private gateway associated with the VPN connection.    transit-gateway-id - The ID of a
  transit gateway associated with the VPN connection.
- `"VpnConnectionId"`: One or more VPN connection IDs. Default: Describes your VPN
  connections.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpn_connections(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeVpnConnections"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_vpn_connections(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpnConnections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_vpn_gateways()
    describe_vpn_gateways(params::Dict{String,<:Any})

Describes one or more of your virtual private gateways. For more information, see Amazon
Web Services Site-to-Site VPN in the Amazon Web Services Site-to-Site VPN User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filter"`: One or more filters.    amazon-side-asn - The Autonomous System Number (ASN)
  for the Amazon side of the gateway.    attachment.state - The current state of the
  attachment between the gateway and the VPC (attaching | attached | detaching | detached).
   attachment.vpc-id - The ID of an attached VPC.    availability-zone - The Availability
  Zone for the virtual private gateway (if applicable).    state - The state of the virtual
  private gateway (pending | available | deleting | deleted).    tag:&lt;key&gt; - The
  key/value combination of a tag assigned to the resource. Use the tag key in the filter name
  and the tag value as the filter value. For example, to find all resources that have a tag
  with the key Owner and the value TeamA, specify tag:Owner for the filter name and TeamA for
  the filter value.    tag-key - The key of a tag assigned to the resource. Use this filter
  to find all resources assigned a tag with a specific key, regardless of the tag value.
  type - The type of virtual private gateway. Currently the only supported type is ipsec.1.
   vpn-gateway-id - The ID of the virtual private gateway.
- `"VpnGatewayId"`: One or more virtual private gateway IDs. Default: Describes all your
  virtual private gateways.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function describe_vpn_gateways(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DescribeVpnGateways"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_vpn_gateways(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DescribeVpnGateways",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_classic_link_vpc(instance_id, vpc_id)
    detach_classic_link_vpc(instance_id, vpc_id, params::Dict{String,<:Any})

 This action is deprecated.  Unlinks (detaches) a linked EC2-Classic instance from a VPC.
After the instance has been unlinked, the VPC security groups are no longer associated with
it. An instance is automatically unlinked from a VPC when it's stopped.

# Arguments
- `instance_id`: The ID of the instance to unlink from the VPC.
- `vpc_id`: The ID of the VPC to which the instance is linked.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function detach_classic_link_vpc(
    instanceId, vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DetachClassicLinkVpc",
        Dict{String,Any}("instanceId" => instanceId, "vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_classic_link_vpc(
    instanceId,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachClassicLinkVpc",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("instanceId" => instanceId, "vpcId" => vpcId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_internet_gateway(internet_gateway_id, vpc_id)
    detach_internet_gateway(internet_gateway_id, vpc_id, params::Dict{String,<:Any})

Detaches an internet gateway from a VPC, disabling connectivity between the internet and
the VPC. The VPC must not contain any running instances with Elastic IP addresses or public
IPv4 addresses.

# Arguments
- `internet_gateway_id`: The ID of the internet gateway.
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function detach_internet_gateway(
    internetGatewayId, vpcId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DetachInternetGateway",
        Dict{String,Any}("internetGatewayId" => internetGatewayId, "vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_internet_gateway(
    internetGatewayId,
    vpcId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachInternetGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "internetGatewayId" => internetGatewayId, "vpcId" => vpcId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_network_interface(attachment_id)
    detach_network_interface(attachment_id, params::Dict{String,<:Any})

Detaches a network interface from an instance.

# Arguments
- `attachment_id`: The ID of the attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"force"`: Specifies whether to force a detachment.    Use the Force parameter only as a
  last resort to detach a network interface from a failed instance.    If you use the Force
  parameter to detach a network interface, you might not be able to attach a different
  network interface to the same index on the instance without first stopping and starting the
  instance.   If you force the detachment of a network interface, the instance metadata might
  not get updated. This means that the attributes associated with the detached network
  interface might still be visible. The instance metadata will get updated when you stop and
  start the instance.
"""
function detach_network_interface(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DetachNetworkInterface",
        Dict{String,Any}("attachmentId" => attachmentId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_network_interface(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachNetworkInterface",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("attachmentId" => attachmentId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_verified_access_trust_provider(verified_access_instance_id, verified_access_trust_provider_id)
    detach_verified_access_trust_provider(verified_access_instance_id, verified_access_trust_provider_id, params::Dict{String,<:Any})

Detaches the specified Amazon Web Services Verified Access trust provider from the
specified Amazon Web Services Verified Access instance.

# Arguments
- `verified_access_instance_id`: The ID of the Verified Access instance.
- `verified_access_trust_provider_id`: The ID of the Verified Access trust provider.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: A unique, case-sensitive token that you provide to ensure idempotency of
  your modification request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function detach_verified_access_trust_provider(
    VerifiedAccessInstanceId,
    VerifiedAccessTrustProviderId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachVerifiedAccessTrustProvider",
        Dict{String,Any}(
            "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
            "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_verified_access_trust_provider(
    VerifiedAccessInstanceId,
    VerifiedAccessTrustProviderId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachVerifiedAccessTrustProvider",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "VerifiedAccessInstanceId" => VerifiedAccessInstanceId,
                    "VerifiedAccessTrustProviderId" => VerifiedAccessTrustProviderId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_volume(volume_id)
    detach_volume(volume_id, params::Dict{String,<:Any})

Detaches an EBS volume from an instance. Make sure to unmount any file systems on the
device within your operating system before detaching the volume. Failure to do so can
result in the volume becoming stuck in the busy state while detaching. If this happens,
detachment can be delayed indefinitely until you unmount the volume, force detachment,
reboot the instance, or all three. If an EBS volume is the root device of an instance, it
can't be detached while the instance is running. To detach the root volume, stop the
instance first. When a volume with an Amazon Web Services Marketplace product code is
detached from an instance, the product code is no longer associated with the instance. You
can't detach or force detach volumes that are attached to Amazon ECS or Fargate tasks.
Attempting to do this results in the UnsupportedOperationException exception with the
Unable to detach volume attached to ECS tasks error message. For more information, see
Detach an Amazon EBS volume in the Amazon EBS User Guide.

# Arguments
- `volume_id`: The ID of the volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Device"`: The device name.
- `"Force"`: Forces detachment if the previous detachment attempt did not occur cleanly
  (for example, logging into an instance, unmounting the volume, and detaching normally).
  This option can lead to data loss or a corrupted file system. Use this option only as a
  last resort to detach a volume from a failed instance. The instance won't have an
  opportunity to flush file system caches or file system metadata. If you use this option,
  you must perform file system check and repair procedures.
- `"InstanceId"`: The ID of the instance. If you are detaching a Multi-Attach enabled
  volume, you must specify an instance ID.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function detach_volume(VolumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DetachVolume",
        Dict{String,Any}("VolumeId" => VolumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_volume(
    VolumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachVolume",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("VolumeId" => VolumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    detach_vpn_gateway(vpc_id, vpn_gateway_id)
    detach_vpn_gateway(vpc_id, vpn_gateway_id, params::Dict{String,<:Any})

Detaches a virtual private gateway from a VPC. You do this if you're planning to turn off
the VPC and not use it anymore. You can confirm a virtual private gateway has been
completely detached from a VPC by describing the virtual private gateway (any attachments
to the virtual private gateway are also described). You must wait for the attachment's
state to switch to detached before you can delete the VPC or attach a different VPC to the
virtual private gateway.

# Arguments
- `vpc_id`: The ID of the VPC.
- `vpn_gateway_id`: The ID of the virtual private gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function detach_vpn_gateway(
    VpcId, VpnGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DetachVpnGateway",
        Dict{String,Any}("VpcId" => VpcId, "VpnGatewayId" => VpnGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function detach_vpn_gateway(
    VpcId,
    VpnGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DetachVpnGateway",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("VpcId" => VpcId, "VpnGatewayId" => VpnGatewayId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_address_transfer(allocation_id)
    disable_address_transfer(allocation_id, params::Dict{String,<:Any})

Disables Elastic IP address transfer. For more information, see Transfer Elastic IP
addresses in the Amazon VPC User Guide.

# Arguments
- `allocation_id`: The allocation ID of an Elastic IP address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_address_transfer(
    AllocationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableAddressTransfer",
        Dict{String,Any}("AllocationId" => AllocationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_address_transfer(
    AllocationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableAddressTransfer",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AllocationId" => AllocationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_aws_network_performance_metric_subscription()
    disable_aws_network_performance_metric_subscription(params::Dict{String,<:Any})

Disables Infrastructure Performance metric subscriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Destination"`: The target Region or Availability Zone that the metric subscription is
  disabled for. For example, eu-north-1.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Metric"`: The metric used for the disabled subscription.
- `"Source"`: The source Region or Availability Zone that the metric subscription is
  disabled for. For example, us-east-1.
- `"Statistic"`: The statistic used for the disabled subscription.
"""
function disable_aws_network_performance_metric_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableAwsNetworkPerformanceMetricSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_aws_network_performance_metric_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableAwsNetworkPerformanceMetricSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_ebs_encryption_by_default()
    disable_ebs_encryption_by_default(params::Dict{String,<:Any})

Disables EBS encryption by default for your account in the current Region. After you
disable encryption by default, you can still create encrypted volumes by enabling
encryption when you create each volume. Disabling encryption by default does not change the
encryption status of your existing volumes. For more information, see Amazon EBS encryption
in the Amazon EBS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_ebs_encryption_by_default(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableEbsEncryptionByDefault";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_ebs_encryption_by_default(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableEbsEncryptionByDefault",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_fast_launch(image_id)
    disable_fast_launch(image_id, params::Dict{String,<:Any})

Discontinue Windows fast launch for a Windows AMI, and clean up existing pre-provisioned
snapshots. After you disable Windows fast launch, the AMI uses the standard launch process
for each new instance. Amazon EC2 must remove all pre-provisioned snapshots before you can
enable Windows fast launch again.  You can only change these settings for Windows AMIs that
you own or that have been shared with you.

# Arguments
- `image_id`: Specify the ID of the image for which to disable Windows fast launch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Force"`: Forces the image settings to turn off Windows fast launch for your Windows
  AMI. This parameter overrides any errors that are encountered while cleaning up resources
  in your account.
"""
function disable_fast_launch(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DisableFastLaunch",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_fast_launch(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableFastLaunch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_fast_snapshot_restores(availability_zone, source_snapshot_id)
    disable_fast_snapshot_restores(availability_zone, source_snapshot_id, params::Dict{String,<:Any})

Disables fast snapshot restores for the specified snapshots in the specified Availability
Zones.

# Arguments
- `availability_zone`: One or more Availability Zones. For example, us-east-2a.
- `source_snapshot_id`: The IDs of one or more snapshots. For example,
  snap-1234567890abcdef0.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_fast_snapshot_restores(
    AvailabilityZone, SourceSnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableFastSnapshotRestores",
        Dict{String,Any}(
            "AvailabilityZone" => AvailabilityZone, "SourceSnapshotId" => SourceSnapshotId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_fast_snapshot_restores(
    AvailabilityZone,
    SourceSnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableFastSnapshotRestores",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AvailabilityZone" => AvailabilityZone,
                    "SourceSnapshotId" => SourceSnapshotId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_image(image_id)
    disable_image(image_id, params::Dict{String,<:Any})

Sets the AMI state to disabled and removes all launch permissions from the AMI. A disabled
AMI can't be used for instance launches. A disabled AMI can't be shared. If an AMI was
public or previously shared, it is made private. If an AMI was shared with an Amazon Web
Services account, organization, or Organizational Unit, they lose access to the disabled
AMI.  A disabled AMI does not appear in DescribeImages API calls by default. Only the AMI
owner can disable an AMI. You can re-enable a disabled AMI using EnableImage. For more
information, see Disable an AMI in the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_image(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DisableImage",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_image(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableImage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_image_block_public_access()
    disable_image_block_public_access(params::Dict{String,<:Any})

Disables block public access for AMIs at the account level in the specified Amazon Web
Services Region. This removes the block public access restriction from your account. With
the restriction removed, you can publicly share your AMIs in the specified Amazon Web
Services Region. The API can take up to 10 minutes to configure this setting. During this
time, if you run GetImageBlockPublicAccessState, the response will be block-new-sharing.
When the API has completed the configuration, the response will be unblocked. For more
information, see Block public access to your AMIs in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_image_block_public_access(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableImageBlockPublicAccess";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_image_block_public_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableImageBlockPublicAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_image_deprecation(image_id)
    disable_image_deprecation(image_id, params::Dict{String,<:Any})

Cancels the deprecation of the specified AMI. For more information, see Deprecate an AMI in
the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_image_deprecation(
    ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableImageDeprecation",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_image_deprecation(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableImageDeprecation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_image_deregistration_protection(image_id)
    disable_image_deregistration_protection(image_id, params::Dict{String,<:Any})

Disables deregistration protection for an AMI. When deregistration protection is disabled,
the AMI can be deregistered. If you chose to include a 24-hour cooldown period when you
enabled deregistration protection for the AMI, then, when you disable deregistration
protection, you won’t immediately be able to deregister the AMI. For more information,
see Protect an AMI from deregistration in the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_image_deregistration_protection(
    ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableImageDeregistrationProtection",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_image_deregistration_protection(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableImageDeregistrationProtection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_ipam_organization_admin_account(delegated_admin_account_id)
    disable_ipam_organization_admin_account(delegated_admin_account_id, params::Dict{String,<:Any})

Disable the IPAM account. For more information, see Enable integration with Organizations
in the Amazon VPC IPAM User Guide.

# Arguments
- `delegated_admin_account_id`: The Organizations member account ID that you want to
  disable as IPAM account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_ipam_organization_admin_account(
    DelegatedAdminAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableIpamOrganizationAdminAccount",
        Dict{String,Any}("DelegatedAdminAccountId" => DelegatedAdminAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_ipam_organization_admin_account(
    DelegatedAdminAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableIpamOrganizationAdminAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DelegatedAdminAccountId" => DelegatedAdminAccountId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_serial_console_access()
    disable_serial_console_access(params::Dict{String,<:Any})

Disables access to the EC2 serial console of all instances for your account. By default,
access to the EC2 serial console is disabled for your account. For more information, see
Manage account access to the EC2 serial console in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_serial_console_access(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DisableSerialConsoleAccess"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function disable_serial_console_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableSerialConsoleAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_snapshot_block_public_access()
    disable_snapshot_block_public_access(params::Dict{String,<:Any})

Disables the block public access for snapshots setting at the account level for the
specified Amazon Web Services Region. After you disable block public access for snapshots
in a Region, users can publicly share snapshots in that Region. If block public access is
enabled in block-all-sharing mode, and you disable block public access, all snapshots that
were previously publicly shared are no longer treated as private and they become publicly
accessible again. For more information, see  Block public access for snapshots in the
Amazon EBS User Guide .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_snapshot_block_public_access(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableSnapshotBlockPublicAccess";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_snapshot_block_public_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableSnapshotBlockPublicAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_transit_gateway_route_table_propagation(transit_gateway_route_table_id)
    disable_transit_gateway_route_table_propagation(transit_gateway_route_table_id, params::Dict{String,<:Any})

Disables the specified resource attachment from propagating routes to the specified
propagation route table.

# Arguments
- `transit_gateway_route_table_id`: The ID of the propagation route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TransitGatewayAttachmentId"`: The ID of the attachment.
- `"TransitGatewayRouteTableAnnouncementId"`: The ID of the route table announcement.
"""
function disable_transit_gateway_route_table_propagation(
    TransitGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableTransitGatewayRouteTablePropagation",
        Dict{String,Any}("TransitGatewayRouteTableId" => TransitGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_transit_gateway_route_table_propagation(
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableTransitGatewayRouteTablePropagation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_vgw_route_propagation(gateway_id, route_table_id)
    disable_vgw_route_propagation(gateway_id, route_table_id, params::Dict{String,<:Any})

Disables a virtual private gateway (VGW) from propagating routes to a specified route table
of a VPC.

# Arguments
- `gateway_id`: The ID of the virtual private gateway.
- `route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_vgw_route_propagation(
    GatewayId, RouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableVgwRoutePropagation",
        Dict{String,Any}("GatewayId" => GatewayId, "RouteTableId" => RouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_vgw_route_propagation(
    GatewayId,
    RouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisableVgwRoutePropagation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayId" => GatewayId, "RouteTableId" => RouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_vpc_classic_link(vpc_id)
    disable_vpc_classic_link(vpc_id, params::Dict{String,<:Any})

 This action is deprecated.  Disables ClassicLink for a VPC. You cannot disable ClassicLink
for a VPC that has EC2-Classic instances linked to it.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disable_vpc_classic_link(vpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DisableVpcClassicLink",
        Dict{String,Any}("vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_vpc_classic_link(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableVpcClassicLink",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("vpcId" => vpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_vpc_classic_link_dns_support()
    disable_vpc_classic_link_dns_support(params::Dict{String,<:Any})

 This action is deprecated.  Disables ClassicLink DNS support for a VPC. If disabled, DNS
hostnames resolve to public IP addresses when addressed between a linked EC2-Classic
instance and instances in the VPC to which it's linked. You must specify a VPC ID in the
request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VpcId"`: The ID of the VPC.
"""
function disable_vpc_classic_link_dns_support(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableVpcClassicLinkDnsSupport";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_vpc_classic_link_dns_support(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisableVpcClassicLinkDnsSupport",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_address()
    disassociate_address(params::Dict{String,<:Any})

Disassociates an Elastic IP address from the instance or network interface it's associated
with. This is an idempotent operation. If you perform the operation more than once, Amazon
EC2 doesn't return an error.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AssociationId"`: The association ID. This parameter is required.
- `"PublicIp"`: Deprecated.
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_address(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "DisassociateAddress"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function disassociate_address(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateAddress",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_client_vpn_target_network(association_id, client_vpn_endpoint_id)
    disassociate_client_vpn_target_network(association_id, client_vpn_endpoint_id, params::Dict{String,<:Any})

Disassociates a target network from the specified Client VPN endpoint. When you
disassociate the last target network from a Client VPN, the following happens:   The route
that was automatically added for the VPC is deleted   All active client connections are
terminated   New client connections are disallowed   The Client VPN endpoint's status
changes to pending-associate

# Arguments
- `association_id`: The ID of the target network association.
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint from which to disassociate
  the target network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_client_vpn_target_network(
    AssociationId, ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateClientVpnTargetNetwork",
        Dict{String,Any}(
            "AssociationId" => AssociationId, "ClientVpnEndpointId" => ClientVpnEndpointId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_client_vpn_target_network(
    AssociationId,
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateClientVpnTargetNetwork",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationId" => AssociationId,
                    "ClientVpnEndpointId" => ClientVpnEndpointId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_enclave_certificate_iam_role(certificate_arn, role_arn)
    disassociate_enclave_certificate_iam_role(certificate_arn, role_arn, params::Dict{String,<:Any})

Disassociates an IAM role from an Certificate Manager (ACM) certificate. Disassociating an
IAM role from an ACM certificate removes the Amazon S3 object that contains the
certificate, certificate chain, and encrypted private key from the Amazon S3 bucket. It
also revokes the IAM role's permission to use the KMS key used to encrypt the private key.
This effectively revokes the role's permission to use the certificate.

# Arguments
- `certificate_arn`: The ARN of the ACM certificate from which to disassociate the IAM role.
- `role_arn`: The ARN of the IAM role to disassociate.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_enclave_certificate_iam_role(
    CertificateArn, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateEnclaveCertificateIamRole",
        Dict{String,Any}("CertificateArn" => CertificateArn, "RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_enclave_certificate_iam_role(
    CertificateArn,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateEnclaveCertificateIamRole",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CertificateArn" => CertificateArn, "RoleArn" => RoleArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_iam_instance_profile(association_id)
    disassociate_iam_instance_profile(association_id, params::Dict{String,<:Any})

Disassociates an IAM instance profile from a running or stopped instance. Use
DescribeIamInstanceProfileAssociations to get the association ID.

# Arguments
- `association_id`: The ID of the IAM instance profile association.

"""
function disassociate_iam_instance_profile(
    AssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateIamInstanceProfile",
        Dict{String,Any}("AssociationId" => AssociationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_iam_instance_profile(
    AssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateIamInstanceProfile",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AssociationId" => AssociationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_instance_event_window(association_target, instance_event_window_id)
    disassociate_instance_event_window(association_target, instance_event_window_id, params::Dict{String,<:Any})

Disassociates one or more targets from an event window. For more information, see Define
event windows for scheduled events in the Amazon EC2 User Guide.

# Arguments
- `association_target`: One or more targets to disassociate from the specified event window.
- `instance_event_window_id`: The ID of the event window.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_instance_event_window(
    AssociationTarget,
    InstanceEventWindowId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateInstanceEventWindow",
        Dict{String,Any}(
            "AssociationTarget" => AssociationTarget,
            "InstanceEventWindowId" => InstanceEventWindowId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_instance_event_window(
    AssociationTarget,
    InstanceEventWindowId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateInstanceEventWindow",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationTarget" => AssociationTarget,
                    "InstanceEventWindowId" => InstanceEventWindowId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_ipam_byoasn(asn, cidr)
    disassociate_ipam_byoasn(asn, cidr, params::Dict{String,<:Any})

Remove the association between your Autonomous System Number (ASN) and your BYOIP CIDR. You
may want to use this action to disassociate an ASN from a CIDR or if you want to swap ASNs.
For more information, see Tutorial: Bring your ASN to IPAM in the Amazon VPC IPAM guide.

# Arguments
- `asn`: A public 2-byte or 4-byte ASN.
- `cidr`: A BYOIP CIDR.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_ipam_byoasn(
    Asn, Cidr; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateIpamByoasn",
        Dict{String,Any}("Asn" => Asn, "Cidr" => Cidr);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_ipam_byoasn(
    Asn,
    Cidr,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateIpamByoasn",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Asn" => Asn, "Cidr" => Cidr), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_ipam_resource_discovery(ipam_resource_discovery_association_id)
    disassociate_ipam_resource_discovery(ipam_resource_discovery_association_id, params::Dict{String,<:Any})

Disassociates a resource discovery from an Amazon VPC IPAM. A resource discovery is an IPAM
component that enables IPAM to manage and monitor resources that belong to the owning
account.

# Arguments
- `ipam_resource_discovery_association_id`: A resource discovery association ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_ipam_resource_discovery(
    IpamResourceDiscoveryAssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateIpamResourceDiscovery",
        Dict{String,Any}(
            "IpamResourceDiscoveryAssociationId" => IpamResourceDiscoveryAssociationId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_ipam_resource_discovery(
    IpamResourceDiscoveryAssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateIpamResourceDiscovery",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IpamResourceDiscoveryAssociationId" =>
                        IpamResourceDiscoveryAssociationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_nat_gateway_address(association_id, nat_gateway_id)
    disassociate_nat_gateway_address(association_id, nat_gateway_id, params::Dict{String,<:Any})

Disassociates secondary Elastic IP addresses (EIPs) from a public NAT gateway. You cannot
disassociate your primary EIP. For more information, see Edit secondary IP address
associations in the Amazon VPC User Guide. While disassociating is in progress, you cannot
associate/disassociate additional EIPs while the connections are being drained. You are,
however, allowed to delete the NAT gateway. An EIP is released only at the end of
MaxDrainDurationSeconds. It stays associated and supports the existing connections but does
not support any new connections (new connections are distributed across the remaining
associated EIPs). As the existing connections drain out, the EIPs (and the corresponding
private IP addresses mapped to them) are released.

# Arguments
- `association_id`: The association IDs of EIPs that have been associated with the NAT
  gateway.
- `nat_gateway_id`: The ID of the NAT gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxDrainDurationSeconds"`: The maximum amount of time to wait (in seconds) before
  forcibly releasing the IP addresses if connections are still in progress. Default value is
  350 seconds.
"""
function disassociate_nat_gateway_address(
    AssociationId, NatGatewayId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateNatGatewayAddress",
        Dict{String,Any}("AssociationId" => AssociationId, "NatGatewayId" => NatGatewayId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_nat_gateway_address(
    AssociationId,
    NatGatewayId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateNatGatewayAddress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationId" => AssociationId, "NatGatewayId" => NatGatewayId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_route_table(association_id)
    disassociate_route_table(association_id, params::Dict{String,<:Any})

Disassociates a subnet or gateway from a route table. After you perform this action, the
subnet no longer uses the routes in the route table. Instead, it uses the routes in the
VPC's main route table. For more information about route tables, see Route tables in the
Amazon VPC User Guide.

# Arguments
- `association_id`: The association ID representing the current association between the
  route table and subnet or gateway.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_route_table(
    associationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateRouteTable",
        Dict{String,Any}("associationId" => associationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_route_table(
    associationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateRouteTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("associationId" => associationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_subnet_cidr_block(association_id)
    disassociate_subnet_cidr_block(association_id, params::Dict{String,<:Any})

Disassociates a CIDR block from a subnet. Currently, you can disassociate an IPv6 CIDR
block only. You must detach or delete all gateways and resources that are associated with
the CIDR block before you can disassociate it.

# Arguments
- `association_id`: The association ID for the CIDR block.

"""
function disassociate_subnet_cidr_block(
    associationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateSubnetCidrBlock",
        Dict{String,Any}("associationId" => associationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_subnet_cidr_block(
    associationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateSubnetCidrBlock",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("associationId" => associationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_transit_gateway_multicast_domain(transit_gateway_attachment_id, transit_gateway_multicast_domain_id, item)
    disassociate_transit_gateway_multicast_domain(transit_gateway_attachment_id, transit_gateway_multicast_domain_id, item, params::Dict{String,<:Any})

Disassociates the specified subnets from the transit gateway multicast domain.

# Arguments
- `transit_gateway_attachment_id`: The ID of the attachment.
- `transit_gateway_multicast_domain_id`: The ID of the transit gateway multicast domain.
- `item`: The IDs of the subnets;

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"SubnetIds"`: The IDs of the subnets;
"""
function disassociate_transit_gateway_multicast_domain(
    TransitGatewayAttachmentId,
    TransitGatewayMulticastDomainId,
    item;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayMulticastDomain",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId,
            "item" => item,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_transit_gateway_multicast_domain(
    TransitGatewayAttachmentId,
    TransitGatewayMulticastDomainId,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayMulticastDomain",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayMulticastDomainId" => TransitGatewayMulticastDomainId,
                    "item" => item,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_transit_gateway_policy_table(transit_gateway_attachment_id, transit_gateway_policy_table_id)
    disassociate_transit_gateway_policy_table(transit_gateway_attachment_id, transit_gateway_policy_table_id, params::Dict{String,<:Any})

Removes the association between an an attachment and a policy table.

# Arguments
- `transit_gateway_attachment_id`: The ID of the transit gateway attachment to disassociate
  from the policy table.
- `transit_gateway_policy_table_id`: The ID of the disassociated policy table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_transit_gateway_policy_table(
    TransitGatewayAttachmentId,
    TransitGatewayPolicyTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayPolicyTable",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_transit_gateway_policy_table(
    TransitGatewayAttachmentId,
    TransitGatewayPolicyTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayPolicyTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayPolicyTableId" => TransitGatewayPolicyTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_transit_gateway_route_table(transit_gateway_attachment_id, transit_gateway_route_table_id)
    disassociate_transit_gateway_route_table(transit_gateway_attachment_id, transit_gateway_route_table_id, params::Dict{String,<:Any})

Disassociates a resource attachment from a transit gateway route table.

# Arguments
- `transit_gateway_attachment_id`: The ID of the attachment.
- `transit_gateway_route_table_id`: The ID of the transit gateway route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_transit_gateway_route_table(
    TransitGatewayAttachmentId,
    TransitGatewayRouteTableId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayRouteTable",
        Dict{String,Any}(
            "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_transit_gateway_route_table(
    TransitGatewayAttachmentId,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTransitGatewayRouteTable",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayAttachmentId" => TransitGatewayAttachmentId,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_trunk_interface(association_id)
    disassociate_trunk_interface(association_id, params::Dict{String,<:Any})

Removes an association between a branch network interface with a trunk network interface.

# Arguments
- `association_id`: The ID of the association

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Unique, case-sensitive identifier that you provide to ensure the
  idempotency of the request. For more information, see Ensuring idempotency.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function disassociate_trunk_interface(
    AssociationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateTrunkInterface",
        Dict{String,Any}(
            "AssociationId" => AssociationId, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_trunk_interface(
    AssociationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateTrunkInterface",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AssociationId" => AssociationId, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_vpc_cidr_block(association_id)
    disassociate_vpc_cidr_block(association_id, params::Dict{String,<:Any})

Disassociates a CIDR block from a VPC. To disassociate the CIDR block, you must specify its
association ID. You can get the association ID by using DescribeVpcs. You must detach or
delete all gateways and resources that are associated with the CIDR block before you can
disassociate it.  You cannot disassociate the CIDR block with which you originally created
the VPC (the primary CIDR block).

# Arguments
- `association_id`: The association ID for the CIDR block.

"""
function disassociate_vpc_cidr_block(
    associationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "DisassociateVpcCidrBlock",
        Dict{String,Any}("associationId" => associationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_vpc_cidr_block(
    associationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "DisassociateVpcCidrBlock",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("associationId" => associationId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_address_transfer(allocation_id, transfer_account_id)
    enable_address_transfer(allocation_id, transfer_account_id, params::Dict{String,<:Any})

Enables Elastic IP address transfer. For more information, see Transfer Elastic IP
addresses in the Amazon VPC User Guide.

# Arguments
- `allocation_id`: The allocation ID of an Elastic IP address.
- `transfer_account_id`: The ID of the account that you want to transfer the Elastic IP
  address to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_address_transfer(
    AllocationId, TransferAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableAddressTransfer",
        Dict{String,Any}(
            "AllocationId" => AllocationId, "TransferAccountId" => TransferAccountId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_address_transfer(
    AllocationId,
    TransferAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableAddressTransfer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AllocationId" => AllocationId, "TransferAccountId" => TransferAccountId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_aws_network_performance_metric_subscription()
    enable_aws_network_performance_metric_subscription(params::Dict{String,<:Any})

Enables Infrastructure Performance subscriptions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Destination"`: The target Region (like us-east-2) or Availability Zone ID (like
  use2-az2) that the metric subscription is enabled for. If you use Availability Zone IDs,
  the Source and Destination Availability Zones must be in the same Region.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Metric"`: The metric used for the enabled subscription.
- `"Source"`: The source Region (like us-east-1) or Availability Zone ID (like use1-az1)
  that the metric subscription is enabled for. If you use Availability Zone IDs, the Source
  and Destination Availability Zones must be in the same Region.
- `"Statistic"`: The statistic used for the enabled subscription.
"""
function enable_aws_network_performance_metric_subscription(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableAwsNetworkPerformanceMetricSubscription";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_aws_network_performance_metric_subscription(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableAwsNetworkPerformanceMetricSubscription",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_ebs_encryption_by_default()
    enable_ebs_encryption_by_default(params::Dict{String,<:Any})

Enables EBS encryption by default for your account in the current Region. After you enable
encryption by default, the EBS volumes that you create are always encrypted, either using
the default KMS key or the KMS key that you specified when you created each volume. For
more information, see Amazon EBS encryption in the Amazon EBS User Guide. You can specify
the default KMS key for encryption by default using ModifyEbsDefaultKmsKeyId or
ResetEbsDefaultKmsKeyId. Enabling encryption by default has no effect on the encryption
status of your existing volumes. After you enable encryption by default, you can no longer
launch instances using instance types that do not support encryption. For more information,
see Supported instance types.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_ebs_encryption_by_default(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableEbsEncryptionByDefault";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_ebs_encryption_by_default(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableEbsEncryptionByDefault",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_fast_launch(image_id)
    enable_fast_launch(image_id, params::Dict{String,<:Any})

When you enable Windows fast launch for a Windows AMI, images are pre-provisioned, using
snapshots to launch instances up to 65% faster. To create the optimized Windows image,
Amazon EC2 launches an instance and runs through Sysprep steps, rebooting as required. Then
it creates a set of reserved snapshots that are used for subsequent launches. The reserved
snapshots are automatically replenished as they are used, depending on your settings for
launch frequency.  You can only change these settings for Windows AMIs that you own or that
have been shared with you.

# Arguments
- `image_id`: Specify the ID of the image for which to enable Windows fast launch.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"LaunchTemplate"`: The launch template to use when launching Windows instances from
  pre-provisioned snapshots. Launch template parameters can include either the name or ID of
  the launch template, but not both.
- `"MaxParallelLaunches"`: The maximum number of instances that Amazon EC2 can launch at
  the same time to create pre-provisioned snapshots for Windows fast launch. Value must be 6
  or greater.
- `"ResourceType"`: The type of resource to use for pre-provisioning the AMI for Windows
  fast launch. Supported values include: snapshot, which is the default value.
- `"SnapshotConfiguration"`: Configuration settings for creating and managing the snapshots
  that are used for pre-provisioning the AMI for Windows fast launch. The associated
  ResourceType must be snapshot.
"""
function enable_fast_launch(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "EnableFastLaunch",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_fast_launch(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableFastLaunch",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_fast_snapshot_restores(availability_zone, source_snapshot_id)
    enable_fast_snapshot_restores(availability_zone, source_snapshot_id, params::Dict{String,<:Any})

Enables fast snapshot restores for the specified snapshots in the specified Availability
Zones. You get the full benefit of fast snapshot restores after they enter the enabled
state. To get the current state of fast snapshot restores, use
DescribeFastSnapshotRestores. To disable fast snapshot restores, use
DisableFastSnapshotRestores. For more information, see Amazon EBS fast snapshot restore in
the Amazon EBS User Guide.

# Arguments
- `availability_zone`: One or more Availability Zones. For example, us-east-2a.
- `source_snapshot_id`: The IDs of one or more snapshots. For example,
  snap-1234567890abcdef0. You can specify a snapshot that was shared with you from another
  Amazon Web Services account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_fast_snapshot_restores(
    AvailabilityZone, SourceSnapshotId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableFastSnapshotRestores",
        Dict{String,Any}(
            "AvailabilityZone" => AvailabilityZone, "SourceSnapshotId" => SourceSnapshotId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_fast_snapshot_restores(
    AvailabilityZone,
    SourceSnapshotId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableFastSnapshotRestores",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AvailabilityZone" => AvailabilityZone,
                    "SourceSnapshotId" => SourceSnapshotId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_image(image_id)
    enable_image(image_id, params::Dict{String,<:Any})

Re-enables a disabled AMI. The re-enabled AMI is marked as available and can be used for
instance launches, appears in describe operations, and can be shared. Amazon Web Services
accounts, organizations, and Organizational Units that lost access to the AMI when it was
disabled do not regain access automatically. Once the AMI is available, it can be shared
with them again. Only the AMI owner can re-enable a disabled AMI. For more information, see
Disable an AMI in the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_image(ImageId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "EnableImage",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_image(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableImage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_image_block_public_access(image_block_public_access_state)
    enable_image_block_public_access(image_block_public_access_state, params::Dict{String,<:Any})

Enables block public access for AMIs at the account level in the specified Amazon Web
Services Region. This prevents the public sharing of your AMIs. However, if you already
have public AMIs, they will remain publicly available. The API can take up to 10 minutes to
configure this setting. During this time, if you run GetImageBlockPublicAccessState, the
response will be unblocked. When the API has completed the configuration, the response will
be block-new-sharing. For more information, see Block public access to your AMIs in the
Amazon EC2 User Guide.

# Arguments
- `image_block_public_access_state`: Specify block-new-sharing to enable block public
  access for AMIs at the account level in the specified Region. This will block any attempt
  to publicly share your AMIs in the specified Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_image_block_public_access(
    ImageBlockPublicAccessState; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableImageBlockPublicAccess",
        Dict{String,Any}("ImageBlockPublicAccessState" => ImageBlockPublicAccessState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_image_block_public_access(
    ImageBlockPublicAccessState,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableImageBlockPublicAccess",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ImageBlockPublicAccessState" => ImageBlockPublicAccessState
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_image_deprecation(deprecate_at, image_id)
    enable_image_deprecation(deprecate_at, image_id, params::Dict{String,<:Any})

Enables deprecation of the specified AMI at the specified date and time. For more
information, see Deprecate an AMI in the Amazon EC2 User Guide.

# Arguments
- `deprecate_at`: The date and time to deprecate the AMI, in UTC, in the following format:
  YYYY-MM-DDTHH:MM:SSZ. If you specify a value for seconds, Amazon EC2 rounds the seconds to
  the nearest minute. You can’t specify a date in the past. The upper limit for DeprecateAt
  is 10 years from now, except for public AMIs, where the upper limit is 2 years from the
  creation date.
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_image_deprecation(
    DeprecateAt, ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableImageDeprecation",
        Dict{String,Any}("DeprecateAt" => DeprecateAt, "ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_image_deprecation(
    DeprecateAt,
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableImageDeprecation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DeprecateAt" => DeprecateAt, "ImageId" => ImageId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_image_deregistration_protection(image_id)
    enable_image_deregistration_protection(image_id, params::Dict{String,<:Any})

Enables deregistration protection for an AMI. When deregistration protection is enabled,
the AMI can't be deregistered. To allow the AMI to be deregistered, you must first disable
deregistration protection using DisableImageDeregistrationProtection. For more information,
see Protect an AMI from deregistration in the Amazon EC2 User Guide.

# Arguments
- `image_id`: The ID of the AMI.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"WithCooldown"`: If true, enforces deregistration protection for 24 hours after
  deregistration protection is disabled.
"""
function enable_image_deregistration_protection(
    ImageId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableImageDeregistrationProtection",
        Dict{String,Any}("ImageId" => ImageId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_image_deregistration_protection(
    ImageId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableImageDeregistrationProtection",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("ImageId" => ImageId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_ipam_organization_admin_account(delegated_admin_account_id)
    enable_ipam_organization_admin_account(delegated_admin_account_id, params::Dict{String,<:Any})

Enable an Organizations member account as the IPAM admin account. You cannot select the
Organizations management account as the IPAM admin account. For more information, see
Enable integration with Organizations in the Amazon VPC IPAM User Guide.

# Arguments
- `delegated_admin_account_id`: The Organizations member account ID that you want to enable
  as the IPAM account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_ipam_organization_admin_account(
    DelegatedAdminAccountId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableIpamOrganizationAdminAccount",
        Dict{String,Any}("DelegatedAdminAccountId" => DelegatedAdminAccountId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_ipam_organization_admin_account(
    DelegatedAdminAccountId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableIpamOrganizationAdminAccount",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DelegatedAdminAccountId" => DelegatedAdminAccountId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_reachability_analyzer_organization_sharing()
    enable_reachability_analyzer_organization_sharing(params::Dict{String,<:Any})

Establishes a trust relationship between Reachability Analyzer and Organizations. This
operation must be performed by the management account for the organization. After you
establish a trust relationship, a user in the management account or a delegated
administrator account can run a cross-account analysis using resources from the member
accounts.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_reachability_analyzer_organization_sharing(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableReachabilityAnalyzerOrganizationSharing";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_reachability_analyzer_organization_sharing(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableReachabilityAnalyzerOrganizationSharing",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_serial_console_access()
    enable_serial_console_access(params::Dict{String,<:Any})

Enables access to the EC2 serial console of all instances for your account. By default,
access to the EC2 serial console is disabled for your account. For more information, see
Manage account access to the EC2 serial console in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_serial_console_access(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "EnableSerialConsoleAccess"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function enable_serial_console_access(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableSerialConsoleAccess",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_snapshot_block_public_access(state)
    enable_snapshot_block_public_access(state, params::Dict{String,<:Any})

Enables or modifies the block public access for snapshots setting at the account level for
the specified Amazon Web Services Region. After you enable block public access for
snapshots in a Region, users can no longer request public sharing for snapshots in that
Region. Snapshots that are already publicly shared are either treated as private or they
remain publicly shared, depending on the State that you specify. If block public access is
enabled in block-all-sharing mode, and you change the mode to block-new-sharing, all
snapshots that were previously publicly shared are no longer treated as private and they
become publicly accessible again. For more information, see  Block public access for
snapshots in the Amazon EBS User Guide.

# Arguments
- `state`: The mode in which to enable block public access for snapshots for the Region.
  Specify one of the following values:    block-all-sharing - Prevents all public sharing of
  snapshots in the Region. Users in the account will no longer be able to request new public
  sharing. Additionally, snapshots that are already publicly shared are treated as private
  and they are no longer publicly available.  If you enable block public access for snapshots
  in block-all-sharing mode, it does not change the permissions for snapshots that are
  already publicly shared. Instead, it prevents these snapshots from be publicly visible and
  publicly accessible. Therefore, the attributes for these snapshots still indicate that they
  are publicly shared, even though they are not publicly available.     block-new-sharing -
  Prevents only new public sharing of snapshots in the Region. Users in the account will no
  longer be able to request new public sharing. However, snapshots that are already publicly
  shared, remain publicly available.    unblocked is not a valid value for
  EnableSnapshotBlockPublicAccess.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_snapshot_block_public_access(
    State; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableSnapshotBlockPublicAccess",
        Dict{String,Any}("State" => State);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_snapshot_block_public_access(
    State, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableSnapshotBlockPublicAccess",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("State" => State), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_transit_gateway_route_table_propagation(transit_gateway_route_table_id)
    enable_transit_gateway_route_table_propagation(transit_gateway_route_table_id, params::Dict{String,<:Any})

Enables the specified attachment to propagate routes to the specified propagation route
table.

# Arguments
- `transit_gateway_route_table_id`: The ID of the propagation route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"TransitGatewayAttachmentId"`: The ID of the attachment.
- `"TransitGatewayRouteTableAnnouncementId"`: The ID of the transit gateway route table
  announcement.
"""
function enable_transit_gateway_route_table_propagation(
    TransitGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableTransitGatewayRouteTablePropagation",
        Dict{String,Any}("TransitGatewayRouteTableId" => TransitGatewayRouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_transit_gateway_route_table_propagation(
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableTransitGatewayRouteTablePropagation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_vgw_route_propagation(gateway_id, route_table_id)
    enable_vgw_route_propagation(gateway_id, route_table_id, params::Dict{String,<:Any})

Enables a virtual private gateway (VGW) to propagate routes to the specified route table of
a VPC.

# Arguments
- `gateway_id`: The ID of the virtual private gateway that is attached to a VPC. The
  virtual private gateway must be attached to the same VPC that the routing tables are
  associated with.
- `route_table_id`: The ID of the route table. The routing table must be associated with
  the same VPC that the virtual private gateway is attached to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_vgw_route_propagation(
    GatewayId, RouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableVgwRoutePropagation",
        Dict{String,Any}("GatewayId" => GatewayId, "RouteTableId" => RouteTableId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_vgw_route_propagation(
    GatewayId,
    RouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableVgwRoutePropagation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GatewayId" => GatewayId, "RouteTableId" => RouteTableId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_volume_io(volume_id)
    enable_volume_io(volume_id, params::Dict{String,<:Any})

Enables I/O operations for a volume that had I/O operations disabled because the data on
the volume was potentially inconsistent.

# Arguments
- `volume_id`: The ID of the volume.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_volume_io(volumeId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "EnableVolumeIO",
        Dict{String,Any}("volumeId" => volumeId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_volume_io(
    volumeId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "EnableVolumeIO",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("volumeId" => volumeId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_vpc_classic_link(vpc_id)
    enable_vpc_classic_link(vpc_id, params::Dict{String,<:Any})

 This action is deprecated.  Enables a VPC for ClassicLink. You can then link EC2-Classic
instances to your ClassicLink-enabled VPC to allow communication over private IP addresses.
You cannot enable your VPC for ClassicLink if any of your VPC route tables have existing
routes for address ranges within the 10.0.0.0/8 IP address range, excluding local routes
for VPCs in the 10.0.0.0/16 and 10.1.0.0/16 IP address ranges.

# Arguments
- `vpc_id`: The ID of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function enable_vpc_classic_link(vpcId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "EnableVpcClassicLink",
        Dict{String,Any}("vpcId" => vpcId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_vpc_classic_link(
    vpcId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableVpcClassicLink",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("vpcId" => vpcId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_vpc_classic_link_dns_support()
    enable_vpc_classic_link_dns_support(params::Dict{String,<:Any})

 This action is deprecated.  Enables a VPC to support DNS hostname resolution for
ClassicLink. If enabled, the DNS hostname of a linked EC2-Classic instance resolves to its
private IP address when addressed from an instance in the VPC to which it's linked.
Similarly, the DNS hostname of an instance in a VPC resolves to its private IP address when
addressed from a linked EC2-Classic instance. You must specify a VPC ID in the request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"VpcId"`: The ID of the VPC.
"""
function enable_vpc_classic_link_dns_support(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableVpcClassicLinkDnsSupport";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_vpc_classic_link_dns_support(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "EnableVpcClassicLinkDnsSupport",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_client_vpn_client_certificate_revocation_list(client_vpn_endpoint_id)
    export_client_vpn_client_certificate_revocation_list(client_vpn_endpoint_id, params::Dict{String,<:Any})

Downloads the client certificate revocation list for the specified Client VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function export_client_vpn_client_certificate_revocation_list(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "ExportClientVpnClientCertificateRevocationList",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_client_vpn_client_certificate_revocation_list(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ExportClientVpnClientCertificateRevocationList",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_client_vpn_client_configuration(client_vpn_endpoint_id)
    export_client_vpn_client_configuration(client_vpn_endpoint_id, params::Dict{String,<:Any})

Downloads the contents of the Client VPN endpoint configuration file for the specified
Client VPN endpoint. The Client VPN endpoint configuration file includes the Client VPN
endpoint and certificate information clients need to establish a connection with the Client
VPN endpoint.

# Arguments
- `client_vpn_endpoint_id`: The ID of the Client VPN endpoint.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function export_client_vpn_client_configuration(
    ClientVpnEndpointId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "ExportClientVpnClientConfiguration",
        Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_client_vpn_client_configuration(
    ClientVpnEndpointId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ExportClientVpnClientConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ClientVpnEndpointId" => ClientVpnEndpointId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_image(disk_image_format, image_id, s3_export_location)
    export_image(disk_image_format, image_id, s3_export_location, params::Dict{String,<:Any})

Exports an Amazon Machine Image (AMI) to a VM file. For more information, see Exporting a
VM directly from an Amazon Machine Image (AMI) in the VM Import/Export User Guide.

# Arguments
- `disk_image_format`: The disk image format.
- `image_id`: The ID of the image.
- `s3_export_location`: The Amazon S3 bucket for the destination image. The destination
  bucket must exist.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: Token to enable idempotency for export image requests.
- `"Description"`: A description of the image being exported. The maximum length is 255
  characters.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"RoleName"`: The name of the role that grants VM Import/Export permission to export
  images to your Amazon S3 bucket. If this parameter is not specified, the default role is
  named 'vmimport'.
- `"TagSpecification"`: The tags to apply to the export image task during creation.
"""
function export_image(
    DiskImageFormat,
    ImageId,
    S3ExportLocation;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ExportImage",
        Dict{String,Any}(
            "DiskImageFormat" => DiskImageFormat,
            "ImageId" => ImageId,
            "S3ExportLocation" => S3ExportLocation,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_image(
    DiskImageFormat,
    ImageId,
    S3ExportLocation,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ExportImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DiskImageFormat" => DiskImageFormat,
                    "ImageId" => ImageId,
                    "S3ExportLocation" => S3ExportLocation,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    export_transit_gateway_routes(s3_bucket, transit_gateway_route_table_id)
    export_transit_gateway_routes(s3_bucket, transit_gateway_route_table_id, params::Dict{String,<:Any})

Exports routes from the specified transit gateway route table to the specified S3 bucket.
By default, all routes are exported. Alternatively, you can filter by CIDR range. The
routes are saved to the specified bucket in a JSON file. For more information, see Export
route tables to Amazon S3 in the Amazon Web Services Transit Gateways Guide.

# Arguments
- `s3_bucket`: The name of the S3 bucket.
- `transit_gateway_route_table_id`: The ID of the route table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters. The possible values are:
  attachment.transit-gateway-attachment-id - The id of the transit gateway attachment.
  attachment.resource-id - The resource id of the transit gateway attachment.
  route-search.exact-match - The exact match of the specified filter.
  route-search.longest-prefix-match - The longest prefix that matches the route.
  route-search.subnet-of-match - The routes with a subnet that match the specified CIDR
  filter.    route-search.supernet-of-match - The routes with a CIDR that encompass the CIDR
  filter. For example, if you have 10.0.1.0/29 and 10.0.1.0/31 routes in your route table and
  you specify supernet-of-match as 10.0.1.0/30, then the result returns 10.0.1.0/29.    state
  - The state of the route (active | blackhole).
  transit-gateway-route-destination-cidr-block - The CIDR range.    type - The type of route
  (propagated | static).
"""
function export_transit_gateway_routes(
    S3Bucket, TransitGatewayRouteTableId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "ExportTransitGatewayRoutes",
        Dict{String,Any}(
            "S3Bucket" => S3Bucket,
            "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function export_transit_gateway_routes(
    S3Bucket,
    TransitGatewayRouteTableId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "ExportTransitGatewayRoutes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "S3Bucket" => S3Bucket,
                    "TransitGatewayRouteTableId" => TransitGatewayRouteTableId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_associated_enclave_certificate_iam_roles(certificate_arn)
    get_associated_enclave_certificate_iam_roles(certificate_arn, params::Dict{String,<:Any})

Returns the IAM roles that are associated with the specified ACM (ACM) certificate. It also
returns the name of the Amazon S3 bucket and the Amazon S3 object key where the
certificate, certificate chain, and encrypted private key bundle are stored, and the ARN of
the KMS key that's used to encrypt the private key.

# Arguments
- `certificate_arn`: The ARN of the ACM certificate for which to view the associated IAM
  roles, encryption keys, and Amazon S3 object information.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_associated_enclave_certificate_iam_roles(
    CertificateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetAssociatedEnclaveCertificateIamRoles",
        Dict{String,Any}("CertificateArn" => CertificateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_associated_enclave_certificate_iam_roles(
    CertificateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetAssociatedEnclaveCertificateIamRoles",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("CertificateArn" => CertificateArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_associated_ipv6_pool_cidrs(pool_id)
    get_associated_ipv6_pool_cidrs(pool_id, params::Dict{String,<:Any})

Gets information about the IPv6 CIDR block associations for a specified IPv6 address pool.

# Arguments
- `pool_id`: The ID of the IPv6 address pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function get_associated_ipv6_pool_cidrs(
    PoolId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetAssociatedIpv6PoolCidrs",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_associated_ipv6_pool_cidrs(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetAssociatedIpv6PoolCidrs",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_aws_network_performance_data()
    get_aws_network_performance_data(params::Dict{String,<:Any})

Gets network performance data.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataQuery"`: A list of network performance data queries.
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"EndTime"`: The ending time for the performance data request. The end time must be
  formatted as yyyy-mm-ddThh:mm:ss. For example, 2022-06-12T12:00:00.000Z.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
- `"StartTime"`: The starting time for the performance data request. The starting time must
  be formatted as yyyy-mm-ddThh:mm:ss. For example, 2022-06-10T12:00:00.000Z.
"""
function get_aws_network_performance_data(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetAwsNetworkPerformanceData";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_aws_network_performance_data(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetAwsNetworkPerformanceData",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_capacity_reservation_usage(capacity_reservation_id)
    get_capacity_reservation_usage(capacity_reservation_id, params::Dict{String,<:Any})

Gets usage information about a Capacity Reservation. If the Capacity Reservation is shared,
it shows usage information for the Capacity Reservation owner and each Amazon Web Services
account that is currently using the shared capacity. If the Capacity Reservation is not
shared, it shows only the Capacity Reservation owner's usage.

# Arguments
- `capacity_reservation_id`: The ID of the Capacity Reservation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function get_capacity_reservation_usage(
    CapacityReservationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetCapacityReservationUsage",
        Dict{String,Any}("CapacityReservationId" => CapacityReservationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_capacity_reservation_usage(
    CapacityReservationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetCapacityReservationUsage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CapacityReservationId" => CapacityReservationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_coip_pool_usage(pool_id)
    get_coip_pool_usage(pool_id, params::Dict{String,<:Any})

Describes the allocations from the specified customer-owned address pool.

# Arguments
- `pool_id`: The ID of the address pool.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"Filter"`: One or more filters.    coip-address-usage.allocation-id - The allocation ID
  of the address.    coip-address-usage.aws-account-id - The ID of the Amazon Web Services
  account that is using the customer-owned IP address.    coip-address-usage.aws-service -
  The Amazon Web Services service that is using the customer-owned IP address.
  coip-address-usage.co-ip - The customer-owned IP address.
- `"MaxResults"`: The maximum number of results to return with a single call. To retrieve
  the remaining results, make another call with the returned nextToken value.
- `"NextToken"`: The token for the next page of results.
"""
function get_coip_pool_usage(PoolId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "GetCoipPoolUsage",
        Dict{String,Any}("PoolId" => PoolId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_coip_pool_usage(
    PoolId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetCoipPoolUsage",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("PoolId" => PoolId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_console_output(instance_id)
    get_console_output(instance_id, params::Dict{String,<:Any})

Gets the console output for the specified instance. For Linux instances, the instance
console output displays the exact console output that would normally be displayed on a
physical monitor attached to a computer. For Windows instances, the instance console output
includes the last three system event log errors. By default, the console output returns
buffered information that was posted shortly after an instance transition state (start,
stop, reboot, or terminate). This information is available for at least one hour after the
most recent post. Only the most recent 64 KB of console output is available. You can
optionally retrieve the latest serial console output at any time during the instance
lifecycle. This option is supported on instance types that use the Nitro hypervisor. For
more information, see Instance console output in the Amazon EC2 User Guide.

# Arguments
- `instance_id`: The ID of the instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Latest"`: When enabled, retrieves the latest console output for the instance. Default:
  disabled (false)
- `"dryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_console_output(InstanceId; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "GetConsoleOutput",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_console_output(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetConsoleOutput",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_console_screenshot(instance_id)
    get_console_screenshot(instance_id, params::Dict{String,<:Any})

Retrieve a JPG-format screenshot of a running instance to help with troubleshooting. The
returned content is Base64-encoded. For more information, see Instance console output in
the Amazon EC2 User Guide.

# Arguments
- `instance_id`: The ID of the instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"WakeUp"`: When set to true, acts as keystroke input and wakes up an instance that's in
  standby or \"sleep\" mode.
"""
function get_console_screenshot(
    InstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetConsoleScreenshot",
        Dict{String,Any}("InstanceId" => InstanceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_console_screenshot(
    InstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetConsoleScreenshot",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceId" => InstanceId), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_default_credit_specification(instance_family)
    get_default_credit_specification(instance_family, params::Dict{String,<:Any})

Describes the default credit option for CPU usage of a burstable performance instance
family. For more information, see Burstable performance instances in the Amazon EC2 User
Guide.

# Arguments
- `instance_family`: The instance family.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_default_credit_specification(
    InstanceFamily; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetDefaultCreditSpecification",
        Dict{String,Any}("InstanceFamily" => InstanceFamily);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_default_credit_specification(
    InstanceFamily,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetDefaultCreditSpecification",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InstanceFamily" => InstanceFamily), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ebs_default_kms_key_id()
    get_ebs_default_kms_key_id(params::Dict{String,<:Any})

Describes the default KMS key for EBS encryption by default for your account in this
Region. You can change the default KMS key for encryption by default using
ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId. For more information, see Amazon EBS
encryption in the Amazon EBS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_ebs_default_kms_key_id(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "GetEbsDefaultKmsKeyId"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_ebs_default_kms_key_id(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetEbsDefaultKmsKeyId",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_ebs_encryption_by_default()
    get_ebs_encryption_by_default(params::Dict{String,<:Any})

Describes whether EBS encryption by default is enabled for your account in the current
Region. For more information, see Amazon EBS encryption in the Amazon EBS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_ebs_encryption_by_default(; aws_config::AbstractAWSConfig=current_aws_config())
    return ec2(
        "GetEbsEncryptionByDefault"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_ebs_encryption_by_default(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetEbsEncryptionByDefault",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_flow_logs_integration_template(config_delivery_s3_destination_arn, flow_log_id, integrate_service)
    get_flow_logs_integration_template(config_delivery_s3_destination_arn, flow_log_id, integrate_service, params::Dict{String,<:Any})

Generates a CloudFormation template that streamlines and automates the integration of VPC
flow logs with Amazon Athena. This make it easier for you to query and gain insights from
VPC flow logs data. Based on the information that you provide, we configure resources in
the template to do the following:   Create a table in Athena that maps fields to a custom
log format   Create a Lambda function that updates the table with new partitions on a
daily, weekly, or monthly basis   Create a table partitioned between two timestamps in the
past   Create a set of named queries in Athena that you can use to get started quickly
GetFlowLogsIntegrationTemplate does not support integration between Amazon Web Services
Transit Gateway Flow Logs and Amazon Athena.

# Arguments
- `config_delivery_s3_destination_arn`: To store the CloudFormation template in Amazon S3,
  specify the location in Amazon S3.
- `flow_log_id`: The ID of the flow log.
- `integrate_service`: Information about the service integration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_flow_logs_integration_template(
    ConfigDeliveryS3DestinationArn,
    FlowLogId,
    IntegrateService;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetFlowLogsIntegrationTemplate",
        Dict{String,Any}(
            "ConfigDeliveryS3DestinationArn" => ConfigDeliveryS3DestinationArn,
            "FlowLogId" => FlowLogId,
            "IntegrateService" => IntegrateService,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_flow_logs_integration_template(
    ConfigDeliveryS3DestinationArn,
    FlowLogId,
    IntegrateService,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetFlowLogsIntegrationTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConfigDeliveryS3DestinationArn" => ConfigDeliveryS3DestinationArn,
                    "FlowLogId" => FlowLogId,
                    "IntegrateService" => IntegrateService,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_groups_for_capacity_reservation(capacity_reservation_id)
    get_groups_for_capacity_reservation(capacity_reservation_id, params::Dict{String,<:Any})

Lists the resource groups to which a Capacity Reservation has been added.

# Arguments
- `capacity_reservation_id`: The ID of the Capacity Reservation. If you specify a Capacity
  Reservation that is shared with you, the operation returns only Capacity Reservation groups
  that you own.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"MaxResults"`: The maximum number of items to return for this request. To get the next
  page of items, make another request with the token returned in the output. For more
  information, see Pagination.
- `"NextToken"`: The token to use to retrieve the next page of results.
"""
function get_groups_for_capacity_reservation(
    CapacityReservationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetGroupsForCapacityReservation",
        Dict{String,Any}("CapacityReservationId" => CapacityReservationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_groups_for_capacity_reservation(
    CapacityReservationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetGroupsForCapacityReservation",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CapacityReservationId" => CapacityReservationId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_host_reservation_purchase_preview(offering_id, item)
    get_host_reservation_purchase_preview(offering_id, item, params::Dict{String,<:Any})

Preview a reservation purchase with configurations that match those of your Dedicated Host.
You must have active Dedicated Hosts in your account before you purchase a reservation.
This is a preview of the PurchaseHostReservation action and does not result in the offering
being purchased.

# Arguments
- `offering_id`: The offering ID of the reservation.
- `item`: The IDs of the Dedicated Hosts with which the reservation is associated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"HostIdSet"`: The IDs of the Dedicated Hosts with which the reservation is associated.
"""
function get_host_reservation_purchase_preview(
    OfferingId, item; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetHostReservationPurchasePreview",
        Dict{String,Any}("OfferingId" => OfferingId, "item" => item);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_host_reservation_purchase_preview(
    OfferingId,
    item,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetHostReservationPurchasePreview",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("OfferingId" => OfferingId, "item" => item), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_image_block_public_access_state()
    get_image_block_public_access_state(params::Dict{String,<:Any})

Gets the current state of block public access for AMIs at the account level in the
specified Amazon Web Services Region. For more information, see Block public access to your
AMIs in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_image_block_public_access_state(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetImageBlockPublicAccessState";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_image_block_public_access_state(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetImageBlockPublicAccessState",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_metadata_defaults()
    get_instance_metadata_defaults(params::Dict{String,<:Any})

Gets the default instance metadata service (IMDS) settings that are set at the account
level in the specified Amazon Web Services&#x2028; Region. For more information, see Order
of precedence for instance metadata options in the Amazon EC2 User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Checks whether you have the required permissions for the action, without
  actually making the request, and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
"""
function get_instance_metadata_defaults(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetInstanceMetadataDefaults";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_metadata_defaults(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetInstanceMetadataDefaults",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_tpm_ek_pub(instance_id, key_format, key_type)
    get_instance_tpm_ek_pub(instance_id, key_format, key_type, params::Dict{String,<:Any})

Gets the public endorsement key associated with the Nitro Trusted Platform Module
(NitroTPM) for the specified instance.

# Arguments
- `instance_id`: The ID of the instance for which to get the public endorsement key.
- `key_format`: The required public endorsement key format. Specify der for a DER-encoded
  public key that is compatible with OpenSSL. Specify tpmt for a TPM 2.0 format that is
  compatible with tpm2-tools. The returned key is base64 encoded.
- `key_type`: The required public endorsement key type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DryRun"`: Specify this parameter to verify whether the request will succeed, without
  actually making the request. If the request will succeed, the response is DryRunOperation.
  Otherwise, the response is UnauthorizedOperation.
"""
function get_instance_tpm_ek_pub(
    InstanceId, KeyFormat, KeyType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ec2(
        "GetInstanceTpmEkPub",
        Dict{String,Any}(
            "InstanceId" => InstanceId, "KeyFormat" => KeyFormat, "KeyType" => KeyType
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_instance_tpm_ek_pub(
    InstanceId,
    KeyFormat,
    KeyType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ec2(
        "GetInstanceTpmEkPub",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "InstanceId" => InstanceId,
                    "KeyFormat" => KeyFormat,
                    "KeyType" => KeyType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_instance_types_from_instance_requirements(architecture_type, instance_requirements, virtualization_type)
    get_instance_types_from_instance_requirements(architecture_type, instance_requirements, virtualization_type, params::Dict{String,<:Any})

Returns a list of instance types with the specified instance attributes. You can use the
response to preview the instance types without launching instances. Note that the response
does not consider capacity. When you specify multiple parameters, you get instance types
that satisfy all of the specified parameters. If you specify multiple values for a
parameter, you get instance types that satisfy any of the specified values. For more
information, see Preview instance types with specified attributes, Attribute-based instance
type selection for EC2 Fleet, Attribute-based instance type selection for Spot Fleet, and
Spot placement score in the Amazon EC2 User Guide, and Creating an Auto Scaling group using
attribute-based ins