# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: ecr
using AWS.Compat
using AWS.UUIDs

"""
    batch_check_layer_availability(layer_digests, repository_name)
    batch_check_layer_availability(layer_digests, repository_name, params::Dict{String,<:Any})

Checks the availability of one or more image layers in a repository. When an image is
pushed to a repository, each image layer is checked to verify if it has been uploaded
before. If it has been uploaded, then the image layer is skipped.  This operation is used
by the Amazon ECR proxy and is not generally used by customers for pulling and pushing
images. In most cases, you should use the docker CLI to pull, tag, and push images.

# Arguments
- `layer_digests`: The digests of the image layers to check.
- `repository_name`: The name of the repository that is associated with the image layers to
  check.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the image layers to check. If you do not specify a registry, the default registry
  is assumed.
"""
function batch_check_layer_availability(
    layerDigests, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "BatchCheckLayerAvailability",
        Dict{String,Any}(
            "layerDigests" => layerDigests, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_check_layer_availability(
    layerDigests,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "BatchCheckLayerAvailability",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "layerDigests" => layerDigests, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_delete_image(image_ids, repository_name)
    batch_delete_image(image_ids, repository_name, params::Dict{String,<:Any})

Deletes a list of specified images within a repository. Images are specified with either an
imageTag or imageDigest. You can remove a tag from an image by specifying the image's tag
in your request. When you remove the last tag from an image, the image is deleted from your
repository. You can completely delete an image (and all of its tags) by specifying the
image's digest in your request.

# Arguments
- `image_ids`: A list of image ID references that correspond to images to delete. The
  format of the imageIds reference is imageTag=tag or imageDigest=digest.
- `repository_name`: The repository that contains the image to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the image to delete. If you do not specify a registry, the default registry is
  assumed.
"""
function batch_delete_image(
    imageIds, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "BatchDeleteImage",
        Dict{String,Any}("imageIds" => imageIds, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_delete_image(
    imageIds,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "BatchDeleteImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "imageIds" => imageIds, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_image(image_ids, repository_name)
    batch_get_image(image_ids, repository_name, params::Dict{String,<:Any})

Gets detailed information for an image. Images are specified with either an imageTag or
imageDigest. When an image is pulled, the BatchGetImage API is called once to retrieve the
image manifest.

# Arguments
- `image_ids`: A list of image ID references that correspond to images to describe. The
  format of the imageIds reference is imageTag=tag or imageDigest=digest.
- `repository_name`: The repository that contains the images to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"acceptedMediaTypes"`: The accepted media types for the request. Valid values:
  application/vnd.docker.distribution.manifest.v1+json |
  application/vnd.docker.distribution.manifest.v2+json |
  application/vnd.oci.image.manifest.v1+json
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the images to describe. If you do not specify a registry, the default registry is
  assumed.
"""
function batch_get_image(
    imageIds, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "BatchGetImage",
        Dict{String,Any}("imageIds" => imageIds, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_image(
    imageIds,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "BatchGetImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "imageIds" => imageIds, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_get_repository_scanning_configuration(repository_names)
    batch_get_repository_scanning_configuration(repository_names, params::Dict{String,<:Any})

Gets the scanning configuration for one or more repositories.

# Arguments
- `repository_names`: One or more repository names to get the scanning configuration for.

"""
function batch_get_repository_scanning_configuration(
    repositoryNames; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "BatchGetRepositoryScanningConfiguration",
        Dict{String,Any}("repositoryNames" => repositoryNames);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_get_repository_scanning_configuration(
    repositoryNames,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "BatchGetRepositoryScanningConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("repositoryNames" => repositoryNames), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    complete_layer_upload(layer_digests, repository_name, upload_id)
    complete_layer_upload(layer_digests, repository_name, upload_id, params::Dict{String,<:Any})

Informs Amazon ECR that the image layer upload has completed for a specified registry,
repository name, and upload ID. You can optionally provide a sha256 digest of the image
layer for data validation purposes. When an image is pushed, the CompleteLayerUpload API is
called once per each new image layer to verify that the upload has completed.  This
operation is used by the Amazon ECR proxy and is not generally used by customers for
pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and
push images.

# Arguments
- `layer_digests`: The sha256 digest of the image layer.
- `repository_name`: The name of the repository to associate with the image layer.
- `upload_id`: The upload ID from a previous InitiateLayerUpload operation to associate
  with the image layer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry to which
  to upload layers. If you do not specify a registry, the default registry is assumed.
"""
function complete_layer_upload(
    layerDigests,
    repositoryName,
    uploadId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "CompleteLayerUpload",
        Dict{String,Any}(
            "layerDigests" => layerDigests,
            "repositoryName" => repositoryName,
            "uploadId" => uploadId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function complete_layer_upload(
    layerDigests,
    repositoryName,
    uploadId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "CompleteLayerUpload",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "layerDigests" => layerDigests,
                    "repositoryName" => repositoryName,
                    "uploadId" => uploadId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_pull_through_cache_rule(ecr_repository_prefix, upstream_registry_url)
    create_pull_through_cache_rule(ecr_repository_prefix, upstream_registry_url, params::Dict{String,<:Any})

Creates a pull through cache rule. A pull through cache rule provides a way to cache images
from an upstream registry source in your Amazon ECR private registry. For more information,
see Using pull through cache rules in the Amazon Elastic Container Registry User Guide.

# Arguments
- `ecr_repository_prefix`: The repository name prefix to use when caching images from the
  source registry.
- `upstream_registry_url`: The registry URL of the upstream public registry to use as the
  source for the pull through cache rule. The following is the syntax to use for each
  supported upstream registry.   Amazon ECR Public (ecr-public) - public.ecr.aws    Docker
  Hub (docker-hub) - registry-1.docker.io    Quay (quay) - quay.io    Kubernetes (k8s) -
  registry.k8s.io    GitHub Container Registry (github-container-registry) - ghcr.io
  Microsoft Azure Container Registry (azure-container-registry) - &lt;custom&gt;.azurecr.io
   GitLab Container Registry (gitlab-container-registry) - registry.gitlab.com

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"credentialArn"`: The Amazon Resource Name (ARN) of the Amazon Web Services Secrets
  Manager secret that identifies the credentials to authenticate to the upstream registry.
- `"registryId"`: The Amazon Web Services account ID associated with the registry to create
  the pull through cache rule for. If you do not specify a registry, the default registry is
  assumed.
- `"upstreamRegistry"`: The name of the upstream registry.
"""
function create_pull_through_cache_rule(
    ecrRepositoryPrefix,
    upstreamRegistryUrl;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "CreatePullThroughCacheRule",
        Dict{String,Any}(
            "ecrRepositoryPrefix" => ecrRepositoryPrefix,
            "upstreamRegistryUrl" => upstreamRegistryUrl,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_pull_through_cache_rule(
    ecrRepositoryPrefix,
    upstreamRegistryUrl,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "CreatePullThroughCacheRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ecrRepositoryPrefix" => ecrRepositoryPrefix,
                    "upstreamRegistryUrl" => upstreamRegistryUrl,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_repository(repository_name)
    create_repository(repository_name, params::Dict{String,<:Any})

Creates a repository. For more information, see Amazon ECR repositories in the Amazon
Elastic Container Registry User Guide.

# Arguments
- `repository_name`: The name to use for the repository. The repository name may be
  specified on its own (such as nginx-web-app) or it can be prepended with a namespace to
  group the repository into a category (such as project-a/nginx-web-app). The repository name
  must start with a letter and can only contain lowercase letters, numbers, hyphens,
  underscores, and forward slashes.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"encryptionConfiguration"`: The encryption configuration for the repository. This
  determines how the contents of your repository are encrypted at rest.
- `"imageScanningConfiguration"`: The image scanning configuration for the repository. This
  determines whether images are scanned for known vulnerabilities after being pushed to the
  repository.
- `"imageTagMutability"`: The tag mutability setting for the repository. If this parameter
  is omitted, the default setting of MUTABLE will be used which will allow image tags to be
  overwritten. If IMMUTABLE is specified, all image tags within the repository will be
  immutable which will prevent them from being overwritten.
- `"registryId"`: The Amazon Web Services account ID associated with the registry to create
  the repository. If you do not specify a registry, the default registry is assumed.
- `"tags"`: The metadata that you apply to the repository to help you categorize and
  organize them. Each tag consists of a key and an optional value, both of which you define.
  Tag keys can have a maximum character length of 128 characters, and tag values can have a
  maximum length of 256 characters.
"""
function create_repository(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "CreateRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "CreateRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_lifecycle_policy(repository_name)
    delete_lifecycle_policy(repository_name, params::Dict{String,<:Any})

Deletes the lifecycle policy associated with the specified repository.

# Arguments
- `repository_name`: The name of the repository.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function delete_lifecycle_policy(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DeleteLifecyclePolicy",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_lifecycle_policy(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DeleteLifecyclePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_pull_through_cache_rule(ecr_repository_prefix)
    delete_pull_through_cache_rule(ecr_repository_prefix, params::Dict{String,<:Any})

Deletes a pull through cache rule.

# Arguments
- `ecr_repository_prefix`: The Amazon ECR repository prefix associated with the pull
  through cache rule to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the pull through cache rule. If you do not specify a registry, the default
  registry is assumed.
"""
function delete_pull_through_cache_rule(
    ecrRepositoryPrefix; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DeletePullThroughCacheRule",
        Dict{String,Any}("ecrRepositoryPrefix" => ecrRepositoryPrefix);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_pull_through_cache_rule(
    ecrRepositoryPrefix,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DeletePullThroughCacheRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ecrRepositoryPrefix" => ecrRepositoryPrefix),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_registry_policy()
    delete_registry_policy(params::Dict{String,<:Any})

Deletes the registry permissions policy.

"""
function delete_registry_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "DeleteRegistryPolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function delete_registry_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DeleteRegistryPolicy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_repository(repository_name)
    delete_repository(repository_name, params::Dict{String,<:Any})

Deletes a repository. If the repository isn't empty, you must either delete the contents of
the repository or use the force option to delete the repository and have Amazon ECR delete
all of its contents on your behalf.

# Arguments
- `repository_name`: The name of the repository to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: If true, deleting the repository force deletes the contents of the repository.
  If false, the repository must be empty before attempting to delete it.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository to delete. If you do not specify a registry, the default registry
  is assumed.
"""
function delete_repository(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DeleteRepository",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_repository(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DeleteRepository",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_repository_policy(repository_name)
    delete_repository_policy(repository_name, params::Dict{String,<:Any})

Deletes the repository policy associated with the specified repository.

# Arguments
- `repository_name`: The name of the repository that is associated with the repository
  policy to delete.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository policy to delete. If you do not specify a registry, the default
  registry is assumed.
"""
function delete_repository_policy(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DeleteRepositoryPolicy",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_repository_policy(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DeleteRepositoryPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_image_replication_status(image_id, repository_name)
    describe_image_replication_status(image_id, repository_name, params::Dict{String,<:Any})

Returns the replication status for a specified image.

# Arguments
- `image_id`:
- `repository_name`: The name of the repository that the image is in.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry. If you
  do not specify a registry, the default registry is assumed.
"""
function describe_image_replication_status(
    imageId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribeImageReplicationStatus",
        Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_image_replication_status(
    imageId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DescribeImageReplicationStatus",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_image_scan_findings(image_id, repository_name)
    describe_image_scan_findings(image_id, repository_name, params::Dict{String,<:Any})

Returns the scan findings for the specified image.

# Arguments
- `image_id`:
- `repository_name`: The repository for the image for which to describe the scan findings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of image scan results returned by
  DescribeImageScanFindings in paginated output. When this parameter is used,
  DescribeImageScanFindings only returns maxResults results in a single page along with a
  nextToken response element. The remaining results of the initial request can be seen by
  sending another DescribeImageScanFindings request with the returned nextToken value. This
  value can be between 1 and 1000. If this parameter is not used, then
  DescribeImageScanFindings returns up to 100 results and a nextToken value, if applicable.
- `"nextToken"`: The nextToken value returned from a previous paginated
  DescribeImageScanFindings request where maxResults was used and the results exceeded the
  value of that parameter. Pagination continues from the end of the previous results that
  returned the nextToken value. This value is null when there are no more results to return.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to describe the image scan findings for. If you do not
  specify a registry, the default registry is assumed.
"""
function describe_image_scan_findings(
    imageId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribeImageScanFindings",
        Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_image_scan_findings(
    imageId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DescribeImageScanFindings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_images(repository_name)
    describe_images(repository_name, params::Dict{String,<:Any})

Returns metadata about the images in a repository.  Beginning with Docker version 1.9, the
Docker client compresses image layers before pushing them to a V2 Docker registry. The
output of the docker images command shows the uncompressed image size, so it may return a
larger image size than the image sizes returned by DescribeImages.

# Arguments
- `repository_name`: The repository that contains the images to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: The filter key and value with which to filter your DescribeImages results.
- `"imageIds"`: The list of image IDs for the requested repository.
- `"maxResults"`: The maximum number of repository results returned by DescribeImages in
  paginated output. When this parameter is used, DescribeImages only returns maxResults
  results in a single page along with a nextToken response element. The remaining results of
  the initial request can be seen by sending another DescribeImages request with the returned
  nextToken value. This value can be between 1 and 1000. If this parameter is not used, then
  DescribeImages returns up to 100 results and a nextToken value, if applicable. This option
  cannot be used when you specify images with imageIds.
- `"nextToken"`: The nextToken value returned from a previous paginated DescribeImages
  request where maxResults was used and the results exceeded the value of that parameter.
  Pagination continues from the end of the previous results that returned the nextToken
  value. This value is null when there are no more results to return. This option cannot be
  used when you specify images with imageIds.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to describe images. If you do not specify a registry, the
  default registry is assumed.
"""
function describe_images(repositoryName; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "DescribeImages",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_images(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "DescribeImages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_pull_through_cache_rules()
    describe_pull_through_cache_rules(params::Dict{String,<:Any})

Returns the pull through cache rules for a registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ecrRepositoryPrefixes"`: The Amazon ECR repository prefixes associated with the pull
  through cache rules to return. If no repository prefix value is specified, all pull through
  cache rules are returned.
- `"maxResults"`: The maximum number of pull through cache rules returned by
  DescribePullThroughCacheRulesRequest in paginated output. When this parameter is used,
  DescribePullThroughCacheRulesRequest only returns maxResults results in a single page along
  with a nextToken response element. The remaining results of the initial request can be seen
  by sending another DescribePullThroughCacheRulesRequest request with the returned nextToken
  value. This value can be between 1 and 1000. If this parameter is not used, then
  DescribePullThroughCacheRulesRequest returns up to 100 results and a nextToken value, if
  applicable.
- `"nextToken"`: The nextToken value returned from a previous paginated
  DescribePullThroughCacheRulesRequest request where maxResults was used and the results
  exceeded the value of that parameter. Pagination continues from the end of the previous
  results that returned the nextToken value. This value is null when there are no more
  results to return.
- `"registryId"`: The Amazon Web Services account ID associated with the registry to return
  the pull through cache rules for. If you do not specify a registry, the default registry is
  assumed.
"""
function describe_pull_through_cache_rules(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribePullThroughCacheRules";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_pull_through_cache_rules(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribePullThroughCacheRules",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_registry()
    describe_registry(params::Dict{String,<:Any})

Describes the settings for a registry. The replication configuration for a repository can
be created or updated with the PutReplicationConfiguration API action.

"""
function describe_registry(; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr("DescribeRegistry"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_registry(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribeRegistry", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_repositories()
    describe_repositories(params::Dict{String,<:Any})

Describes image repositories in a registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of repository results returned by DescribeRepositories
  in paginated output. When this parameter is used, DescribeRepositories only returns
  maxResults results in a single page along with a nextToken response element. The remaining
  results of the initial request can be seen by sending another DescribeRepositories request
  with the returned nextToken value. This value can be between 1 and 1000. If this parameter
  is not used, then DescribeRepositories returns up to 100 results and a nextToken value, if
  applicable. This option cannot be used when you specify repositories with repositoryNames.
- `"nextToken"`: The nextToken value returned from a previous paginated
  DescribeRepositories request where maxResults was used and the results exceeded the value
  of that parameter. Pagination continues from the end of the previous results that returned
  the nextToken value. This value is null when there are no more results to return. This
  option cannot be used when you specify repositories with repositoryNames.  This token
  should be treated as an opaque identifier that is only used to retrieve the next items in a
  list and not for other programmatic purposes.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repositories to be described. If you do not specify a registry, the default
  registry is assumed.
- `"repositoryNames"`: A list of repositories to describe. If this parameter is omitted,
  then all repositories in a registry are described.
"""
function describe_repositories(; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "DescribeRepositories"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_repositories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "DescribeRepositories",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_authorization_token()
    get_authorization_token(params::Dict{String,<:Any})

Retrieves an authorization token. An authorization token represents your IAM authentication
credentials and can be used to access any Amazon ECR registry that your IAM principal has
access to. The authorization token is valid for 12 hours. The authorizationToken returned
is a base64 encoded string that can be decoded and used in a docker login command to
authenticate to a registry. The CLI offers an get-login-password command that simplifies
the login process. For more information, see Registry authentication in the Amazon Elastic
Container Registry User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryIds"`: A list of Amazon Web Services account IDs that are associated with the
  registries for which to get AuthorizationData objects. If you do not specify a registry,
  the default registry is assumed.
"""
function get_authorization_token(; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "GetAuthorizationToken"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_authorization_token(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetAuthorizationToken",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_download_url_for_layer(layer_digest, repository_name)
    get_download_url_for_layer(layer_digest, repository_name, params::Dict{String,<:Any})

Retrieves the pre-signed Amazon S3 download URL corresponding to an image layer. You can
only get URLs for image layers that are referenced in an image. When an image is pulled,
the GetDownloadUrlForLayer API is called once per image layer that is not already cached.
This operation is used by the Amazon ECR proxy and is not generally used by customers for
pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and
push images.

# Arguments
- `layer_digest`: The digest of the image layer to download.
- `repository_name`: The name of the repository that is associated with the image layer to
  download.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the image layer to download. If you do not specify a registry, the default
  registry is assumed.
"""
function get_download_url_for_layer(
    layerDigest, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetDownloadUrlForLayer",
        Dict{String,Any}("layerDigest" => layerDigest, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_download_url_for_layer(
    layerDigest,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "GetDownloadUrlForLayer",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "layerDigest" => layerDigest, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lifecycle_policy(repository_name)
    get_lifecycle_policy(repository_name, params::Dict{String,<:Any})

Retrieves the lifecycle policy for the specified repository.

# Arguments
- `repository_name`: The name of the repository.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function get_lifecycle_policy(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetLifecyclePolicy",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lifecycle_policy(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "GetLifecyclePolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_lifecycle_policy_preview(repository_name)
    get_lifecycle_policy_preview(repository_name, params::Dict{String,<:Any})

Retrieves the results of the lifecycle policy preview request for the specified repository.

# Arguments
- `repository_name`: The name of the repository.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: An optional parameter that filters results based on image tag status and all
  tags, if tagged.
- `"imageIds"`: The list of imageIDs to be included.
- `"maxResults"`: The maximum number of repository results returned by
  GetLifecyclePolicyPreviewRequest in&#x2028; paginated output. When this parameter is used,
  GetLifecyclePolicyPreviewRequest only returns&#x2028; maxResults results in a single page
  along with a nextToken&#x2028; response element. The remaining results of the initial
  request can be seen by sending&#x2028; another GetLifecyclePolicyPreviewRequest request
  with the returned nextToken&#x2028; value. This value can be between 1 and 1000. If
  this&#x2028; parameter is not used, then GetLifecyclePolicyPreviewRequest returns up
  to&#x2028; 100 results and a nextToken value, if&#x2028; applicable. This option cannot be
  used when you specify images with imageIds.
- `"nextToken"`: The nextToken value returned from a previous paginated&#x2028;
  GetLifecyclePolicyPreviewRequest request where maxResults was used and the&#x2028; results
  exceeded the value of that parameter. Pagination continues from the end of the&#x2028;
  previous results that returned the nextToken value. This value is&#x2028; null when there
  are no more results to return. This option cannot be used when you specify images with
  imageIds.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function get_lifecycle_policy_preview(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetLifecyclePolicyPreview",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_lifecycle_policy_preview(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "GetLifecyclePolicyPreview",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_registry_policy()
    get_registry_policy(params::Dict{String,<:Any})

Retrieves the permissions policy for a registry.

"""
function get_registry_policy(; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr("GetRegistryPolicy"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function get_registry_policy(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetRegistryPolicy", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    get_registry_scanning_configuration()
    get_registry_scanning_configuration(params::Dict{String,<:Any})

Retrieves the scanning configuration for a registry.

"""
function get_registry_scanning_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetRegistryScanningConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_registry_scanning_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetRegistryScanningConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_repository_policy(repository_name)
    get_repository_policy(repository_name, params::Dict{String,<:Any})

Retrieves the repository policy for the specified repository.

# Arguments
- `repository_name`: The name of the repository with the policy to retrieve.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function get_repository_policy(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "GetRepositoryPolicy",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_repository_policy(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "GetRepositoryPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    initiate_layer_upload(repository_name)
    initiate_layer_upload(repository_name, params::Dict{String,<:Any})

Notifies Amazon ECR that you intend to upload an image layer. When an image is pushed, the
InitiateLayerUpload API is called once per image layer that has not already been uploaded.
Whether or not an image layer has been uploaded is determined by the
BatchCheckLayerAvailability API action.  This operation is used by the Amazon ECR proxy and
is not generally used by customers for pulling and pushing images. In most cases, you
should use the docker CLI to pull, tag, and push images.

# Arguments
- `repository_name`: The name of the repository to which you intend to upload layers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry to which
  you intend to upload layers. If you do not specify a registry, the default registry is
  assumed.
"""
function initiate_layer_upload(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "InitiateLayerUpload",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function initiate_layer_upload(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "InitiateLayerUpload",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_images(repository_name)
    list_images(repository_name, params::Dict{String,<:Any})

Lists all the image IDs for the specified repository. You can filter images based on
whether or not they are tagged by using the tagStatus filter and specifying either TAGGED,
UNTAGGED or ANY. For example, you can filter your results to return only UNTAGGED images
and then pipe that result to a BatchDeleteImage operation to delete them. Or, you can
filter your results to return only TAGGED images to list all of the tags in your repository.

# Arguments
- `repository_name`: The repository with image IDs to be listed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: The filter key and value with which to filter your ListImages results.
- `"maxResults"`: The maximum number of image results returned by ListImages in paginated
  output. When this parameter is used, ListImages only returns maxResults results in a single
  page along with a nextToken response element. The remaining results of the initial request
  can be seen by sending another ListImages request with the returned nextToken value. This
  value can be between 1 and 1000. If this parameter is not used, then ListImages returns up
  to 100 results and a nextToken value, if applicable.
- `"nextToken"`: The nextToken value returned from a previous paginated ListImages request
  where maxResults was used and the results exceeded the value of that parameter. Pagination
  continues from the end of the previous results that returned the nextToken value. This
  value is null when there are no more results to return.  This token should be treated as an
  opaque identifier that is only used to retrieve the next items in a list and not for other
  programmatic purposes.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to list images. If you do not specify a registry, the
  default registry is assumed.
"""
function list_images(repositoryName; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "ListImages",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_images(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "ListImages",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List the tags for an Amazon ECR resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) that identifies the resource for which to
  list the tags. Currently, the only supported resource is an Amazon ECR repository.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_image(image_manifest, repository_name)
    put_image(image_manifest, repository_name, params::Dict{String,<:Any})

Creates or updates the image manifest and tags associated with an image. When an image is
pushed and all new image layers have been uploaded, the PutImage API is called once to
create or update the image manifest and the tags associated with the image.  This operation
is used by the Amazon ECR proxy and is not generally used by customers for pulling and
pushing images. In most cases, you should use the docker CLI to pull, tag, and push images.

# Arguments
- `image_manifest`: The image manifest corresponding to the image to be uploaded.
- `repository_name`: The name of the repository in which to put the image.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"imageDigest"`: The image digest of the image manifest corresponding to the image.
- `"imageManifestMediaType"`: The media type of the image manifest. If you push an image
  manifest that does not contain the mediaType field, you must specify the
  imageManifestMediaType in the request.
- `"imageTag"`: The tag to associate with the image. This parameter is required for images
  that use the Docker Image Manifest V2 Schema 2 or Open Container Initiative (OCI) formats.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to put the image. If you do not specify a registry, the
  default registry is assumed.
"""
function put_image(
    imageManifest, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutImage",
        Dict{String,Any}(
            "imageManifest" => imageManifest, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_image(
    imageManifest,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutImage",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "imageManifest" => imageManifest, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_image_scanning_configuration(image_scanning_configuration, repository_name)
    put_image_scanning_configuration(image_scanning_configuration, repository_name, params::Dict{String,<:Any})

 The PutImageScanningConfiguration API is being deprecated, in favor of specifying the
image scanning configuration at the registry level. For more information, see
PutRegistryScanningConfiguration.  Updates the image scanning configuration for the
specified repository.

# Arguments
- `image_scanning_configuration`: The image scanning configuration for the repository. This
  setting determines whether images are scanned for known vulnerabilities after being pushed
  to the repository.
- `repository_name`: The name of the repository in which to update the image scanning
  configuration setting.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to update the image scanning configuration setting. If you
  do not specify a registry, the default registry is assumed.
"""
function put_image_scanning_configuration(
    imageScanningConfiguration,
    repositoryName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutImageScanningConfiguration",
        Dict{String,Any}(
            "imageScanningConfiguration" => imageScanningConfiguration,
            "repositoryName" => repositoryName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_image_scanning_configuration(
    imageScanningConfiguration,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutImageScanningConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "imageScanningConfiguration" => imageScanningConfiguration,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_image_tag_mutability(image_tag_mutability, repository_name)
    put_image_tag_mutability(image_tag_mutability, repository_name, params::Dict{String,<:Any})

Updates the image tag mutability settings for the specified repository. For more
information, see Image tag mutability in the Amazon Elastic Container Registry User Guide.

# Arguments
- `image_tag_mutability`: The tag mutability setting for the repository. If MUTABLE is
  specified, image tags can be overwritten. If IMMUTABLE is specified, all image tags within
  the repository will be immutable which will prevent them from being overwritten.
- `repository_name`: The name of the repository in which to update the image tag mutability
  settings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to update the image tag mutability settings. If you do not
  specify a registry, the default registry is assumed.
"""
function put_image_tag_mutability(
    imageTagMutability, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutImageTagMutability",
        Dict{String,Any}(
            "imageTagMutability" => imageTagMutability, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_image_tag_mutability(
    imageTagMutability,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutImageTagMutability",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "imageTagMutability" => imageTagMutability,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_lifecycle_policy(lifecycle_policy_text, repository_name)
    put_lifecycle_policy(lifecycle_policy_text, repository_name, params::Dict{String,<:Any})

Creates or updates the lifecycle policy for the specified repository. For more information,
see Lifecycle policy template.

# Arguments
- `lifecycle_policy_text`: The JSON repository policy text to apply to the repository.
- `repository_name`: The name of the repository to receive the policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do&#x2028; not specify a registry, the default registry is
  assumed.
"""
function put_lifecycle_policy(
    lifecyclePolicyText, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutLifecyclePolicy",
        Dict{String,Any}(
            "lifecyclePolicyText" => lifecyclePolicyText, "repositoryName" => repositoryName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_lifecycle_policy(
    lifecyclePolicyText,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutLifecyclePolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "lifecyclePolicyText" => lifecyclePolicyText,
                    "repositoryName" => repositoryName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_registry_policy(policy_text)
    put_registry_policy(policy_text, params::Dict{String,<:Any})

Creates or updates the permissions policy for your registry. A registry policy is used to
specify permissions for another Amazon Web Services account and is used when configuring
cross-account replication. For more information, see Registry permissions in the Amazon
Elastic Container Registry User Guide.

# Arguments
- `policy_text`: The JSON policy text to apply to your registry. The policy text follows
  the same format as IAM policy text. For more information, see Registry permissions in the
  Amazon Elastic Container Registry User Guide.

"""
function put_registry_policy(policyText; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "PutRegistryPolicy",
        Dict{String,Any}("policyText" => policyText);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_registry_policy(
    policyText,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutRegistryPolicy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("policyText" => policyText), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_registry_scanning_configuration()
    put_registry_scanning_configuration(params::Dict{String,<:Any})

Creates or updates the scanning configuration for your private registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"rules"`: The scanning rules to use for the registry. A scanning rule is used to
  determine which repository filters are used and at what frequency scanning will occur.
- `"scanType"`: The scanning type to set for the registry. When a registry scanning
  configuration is not defined, by default the BASIC scan type is used. When basic scanning
  is used, you may specify filters to determine which individual repositories, or all
  repositories, are scanned when new images are pushed to those repositories. Alternatively,
  you can do manual scans of images with basic scanning. When the ENHANCED scan type is set,
  Amazon Inspector provides automated vulnerability scanning. You may choose between
  continuous scanning or scan on push and you may specify filters to determine which
  individual repositories, or all repositories, are scanned.
"""
function put_registry_scanning_configuration(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutRegistryScanningConfiguration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_registry_scanning_configuration(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutRegistryScanningConfiguration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_replication_configuration(replication_configuration)
    put_replication_configuration(replication_configuration, params::Dict{String,<:Any})

Creates or updates the replication configuration for a registry. The existing replication
configuration for a repository can be retrieved with the DescribeRegistry API action. The
first time the PutReplicationConfiguration API is called, a service-linked IAM role is
created in your account for the replication process. For more information, see Using
service-linked roles for Amazon ECR in the Amazon Elastic Container Registry User Guide.
When configuring cross-account replication, the destination account must grant the source
account permission to replicate. This permission is controlled using a registry permissions
policy. For more information, see PutRegistryPolicy.

# Arguments
- `replication_configuration`: An object representing the replication configuration for a
  registry.

"""
function put_replication_configuration(
    replicationConfiguration; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "PutReplicationConfiguration",
        Dict{String,Any}("replicationConfiguration" => replicationConfiguration);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_replication_configuration(
    replicationConfiguration,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "PutReplicationConfiguration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("replicationConfiguration" => replicationConfiguration),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_repository_policy(policy_text, repository_name)
    set_repository_policy(policy_text, repository_name, params::Dict{String,<:Any})

Applies a repository policy to the specified repository to control access permissions. For
more information, see Amazon ECR Repository policies in the Amazon Elastic Container
Registry User Guide.

# Arguments
- `policy_text`: The JSON repository policy text to apply to the repository. For more
  information, see Amazon ECR repository policies in the Amazon Elastic Container Registry
  User Guide.
- `repository_name`: The name of the repository to receive the policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"force"`: If the policy you are attempting to set on a repository policy would prevent
  you from setting another policy in the future, you must force the SetRepositoryPolicy
  operation. This is intended to prevent accidental repository lock outs.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function set_repository_policy(
    policyText, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "SetRepositoryPolicy",
        Dict{String,Any}("policyText" => policyText, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_repository_policy(
    policyText,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "SetRepositoryPolicy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "policyText" => policyText, "repositoryName" => repositoryName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_image_scan(image_id, repository_name)
    start_image_scan(image_id, repository_name, params::Dict{String,<:Any})

Starts an image vulnerability scan. An image scan can only be started once per 24 hours on
an individual image. This limit includes if an image was scanned on initial push. For more
information, see Image scanning in the Amazon Elastic Container Registry User Guide.

# Arguments
- `image_id`:
- `repository_name`: The name of the repository that contains the images to scan.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository in which to start an image scan request. If you do not specify a
  registry, the default registry is assumed.
"""
function start_image_scan(
    imageId, repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "StartImageScan",
        Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_image_scan(
    imageId,
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "StartImageScan",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("imageId" => imageId, "repositoryName" => repositoryName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_lifecycle_policy_preview(repository_name)
    start_lifecycle_policy_preview(repository_name, params::Dict{String,<:Any})

Starts a preview of a lifecycle policy for the specified repository. This allows you to see
the results before associating the lifecycle policy with the repository.

# Arguments
- `repository_name`: The name of the repository to be evaluated.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"lifecyclePolicyText"`: The policy to be evaluated against. If you do not specify a
  policy, the current policy for the repository is used.
- `"registryId"`: The Amazon Web Services account ID associated with the registry that
  contains the repository. If you do not specify a registry, the default registry is assumed.
"""
function start_lifecycle_policy_preview(
    repositoryName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "StartLifecyclePolicyPreview",
        Dict{String,Any}("repositoryName" => repositoryName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_lifecycle_policy_preview(
    repositoryName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "StartLifecyclePolicyPreview",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("repositoryName" => repositoryName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds specified tags to a resource with the specified ARN. Existing tags on a resource are
not changed if they are not specified in the request parameters.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the the resource to which to add tags.
  Currently, the only supported resource is an Amazon ECR repository.
- `tags`: The tags to add to the resource. A tag is an array of key-value pairs. Tag keys
  can have a maximum character length of 128 characters, and tag values can have a maximum
  length of 256 characters.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return ecr(
        "TagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tags" => tags),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Deletes specified tags from a resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource from which to remove tags.
  Currently, the only supported resource is an Amazon ECR repository.
- `tag_keys`: The keys of the tags to be removed.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "UntagResource",
        Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("resourceArn" => resourceArn, "tagKeys" => tagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_pull_through_cache_rule(credential_arn, ecr_repository_prefix)
    update_pull_through_cache_rule(credential_arn, ecr_repository_prefix, params::Dict{String,<:Any})

Updates an existing pull through cache rule.

# Arguments
- `credential_arn`: The Amazon Resource Name (ARN) of the Amazon Web Services Secrets
  Manager secret that identifies the credentials to authenticate to the upstream registry.
- `ecr_repository_prefix`: The repository name prefix to use when caching images from the
  source registry.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry
  associated with the pull through cache rule. If you do not specify a registry, the default
  registry is assumed.
"""
function update_pull_through_cache_rule(
    credentialArn, ecrRepositoryPrefix; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "UpdatePullThroughCacheRule",
        Dict{String,Any}(
            "credentialArn" => credentialArn, "ecrRepositoryPrefix" => ecrRepositoryPrefix
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_pull_through_cache_rule(
    credentialArn,
    ecrRepositoryPrefix,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "UpdatePullThroughCacheRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "credentialArn" => credentialArn,
                    "ecrRepositoryPrefix" => ecrRepositoryPrefix,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    upload_layer_part(layer_part_blob, part_first_byte, part_last_byte, repository_name, upload_id)
    upload_layer_part(layer_part_blob, part_first_byte, part_last_byte, repository_name, upload_id, params::Dict{String,<:Any})

Uploads an image layer part to Amazon ECR. When an image is pushed, each new image layer is
uploaded in parts. The maximum size of each image layer part can be 20971520 bytes (or
about 20MB). The UploadLayerPart API is called once per each new image layer part.  This
operation is used by the Amazon ECR proxy and is not generally used by customers for
pulling and pushing images. In most cases, you should use the docker CLI to pull, tag, and
push images.

# Arguments
- `layer_part_blob`: The base64-encoded layer part payload.
- `part_first_byte`: The position of the first byte of the layer part witin the overall
  image layer.
- `part_last_byte`: The position of the last byte of the layer part within the overall
  image layer.
- `repository_name`: The name of the repository to which you are uploading layer parts.
- `upload_id`: The upload ID from a previous InitiateLayerUpload operation to associate
  with the layer part upload.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The Amazon Web Services account ID associated with the registry to which
  you are uploading layer parts. If you do not specify a registry, the default registry is
  assumed.
"""
function upload_layer_part(
    layerPartBlob,
    partFirstByte,
    partLastByte,
    repositoryName,
    uploadId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "UploadLayerPart",
        Dict{String,Any}(
            "layerPartBlob" => layerPartBlob,
            "partFirstByte" => partFirstByte,
            "partLastByte" => partLastByte,
            "repositoryName" => repositoryName,
            "uploadId" => uploadId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function upload_layer_part(
    layerPartBlob,
    partFirstByte,
    partLastByte,
    repositoryName,
    uploadId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "UploadLayerPart",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "layerPartBlob" => layerPartBlob,
                    "partFirstByte" => partFirstByte,
                    "partLastByte" => partLastByte,
                    "repositoryName" => repositoryName,
                    "uploadId" => uploadId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_pull_through_cache_rule(ecr_repository_prefix)
    validate_pull_through_cache_rule(ecr_repository_prefix, params::Dict{String,<:Any})

Validates an existing pull through cache rule for an upstream registry that requires
authentication. This will retrieve the contents of the Amazon Web Services Secrets Manager
secret, verify the syntax, and then validate that authentication to the upstream registry
is successful.

# Arguments
- `ecr_repository_prefix`: The repository name prefix associated with the pull through
  cache rule.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"registryId"`: The registry ID associated with the pull through cache rule. If you do
  not specify a registry, the default registry is assumed.
"""
function validate_pull_through_cache_rule(
    ecrRepositoryPrefix; aws_config::AbstractAWSConfig=current_aws_config()
)
    return ecr(
        "ValidatePullThroughCacheRule",
        Dict{String,Any}("ecrRepositoryPrefix" => ecrRepositoryPrefix);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_pull_through_cache_rule(
    ecrRepositoryPrefix,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return ecr(
        "ValidatePullThroughCacheRule",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ecrRepositoryPrefix" => ecrRepositoryPrefix),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
