# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: firehose
using AWS.Compat
using AWS.UUIDs

"""
    create_delivery_stream(delivery_stream_name)
    create_delivery_stream(delivery_stream_name, params::Dict{String,<:Any})

Creates a Firehose delivery stream. By default, you can create up to 50 delivery streams
per Amazon Web Services Region. This is an asynchronous operation that immediately returns.
The initial status of the delivery stream is CREATING. After the delivery stream is
created, its status is ACTIVE and it now accepts data. If the delivery stream creation
fails, the status transitions to CREATING_FAILED. Attempts to send data to a delivery
stream that is not in the ACTIVE state cause an exception. To check the state of a delivery
stream, use DescribeDeliveryStream. If the status of a delivery stream is CREATING_FAILED,
this status doesn't change, and you can't invoke CreateDeliveryStream again on it. However,
you can invoke the DeleteDeliveryStream operation to delete it. A Firehose delivery stream
can be configured to receive records directly from providers using PutRecord or
PutRecordBatch, or it can be configured to use an existing Kinesis stream as its source. To
specify a Kinesis data stream as input, set the DeliveryStreamType parameter to
KinesisStreamAsSource, and provide the Kinesis stream Amazon Resource Name (ARN) and role
ARN in the KinesisStreamSourceConfiguration parameter. To create a delivery stream with
server-side encryption (SSE) enabled, include DeliveryStreamEncryptionConfigurationInput in
your request. This is optional. You can also invoke StartDeliveryStreamEncryption to turn
on SSE for an existing delivery stream that doesn't have SSE enabled. A delivery stream is
configured with a single destination, such as Amazon Simple Storage Service (Amazon S3),
Amazon Redshift, Amazon OpenSearch Service, Amazon OpenSearch Serverless, Splunk, and any
custom HTTP endpoint or HTTP endpoints owned by or supported by third-party service
providers, including Datadog, Dynatrace, LogicMonitor, MongoDB, New Relic, and Sumo Logic.
You must specify only one of the following destination configuration parameters:
ExtendedS3DestinationConfiguration, S3DestinationConfiguration,
ElasticsearchDestinationConfiguration, RedshiftDestinationConfiguration, or
SplunkDestinationConfiguration. When you specify S3DestinationConfiguration, you can also
provide the following optional values: BufferingHints, EncryptionConfiguration, and
CompressionFormat. By default, if no BufferingHints value is provided, Firehose buffers
data up to 5 MB or for 5 minutes, whichever condition is satisfied first. BufferingHints is
a hint, so there are some cases where the service cannot adhere to these conditions
strictly. For example, record boundaries might be such that the size is a little over or
under the configured buffering size. By default, no encryption is performed. We strongly
recommend that you enable encryption to ensure secure data storage in Amazon S3. A few
notes about Amazon Redshift as a destination:   An Amazon Redshift destination requires an
S3 bucket as intermediate location. Firehose first delivers data to Amazon S3 and then uses
COPY syntax to load data into an Amazon Redshift table. This is specified in the
RedshiftDestinationConfiguration.S3Configuration parameter.   The compression formats
SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
because the Amazon Redshift COPY operation that reads from the S3 bucket doesn't support
these compression formats.   We strongly recommend that you use the user name and password
you provide exclusively with Firehose, and that the permissions for the account are
restricted for Amazon Redshift INSERT permissions.   Firehose assumes the IAM role that is
configured as part of the destination. The role should allow the Firehose principal to
assume the role, and the role should have permissions that allow the service to deliver the
data. For more information, see Grant Firehose Access to an Amazon S3 Destination in the
Amazon Firehose Developer Guide.

# Arguments
- `delivery_stream_name`: The name of the delivery stream. This name must be unique per
  Amazon Web Services account in the same Amazon Web Services Region. If the delivery streams
  are in different accounts or different Regions, you can have multiple delivery streams with
  the same name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AmazonOpenSearchServerlessDestinationConfiguration"`: The destination in the Serverless
  offering for Amazon OpenSearch Service. You can specify only one destination.
- `"AmazonopensearchserviceDestinationConfiguration"`: The destination in Amazon OpenSearch
  Service. You can specify only one destination.
- `"DeliveryStreamEncryptionConfigurationInput"`: Used to specify the type and Amazon
  Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).
- `"DeliveryStreamType"`: The delivery stream type. This parameter can be one of the
  following values:    DirectPut: Provider applications access the delivery stream directly.
    KinesisStreamAsSource: The delivery stream uses a Kinesis data stream as a source.
- `"ElasticsearchDestinationConfiguration"`: The destination in Amazon ES. You can specify
  only one destination.
- `"ExtendedS3DestinationConfiguration"`: The destination in Amazon S3. You can specify
  only one destination.
- `"HttpEndpointDestinationConfiguration"`: Enables configuring Kinesis Firehose to deliver
  data to any HTTP endpoint destination. You can specify only one destination.
- `"KinesisStreamSourceConfiguration"`: When a Kinesis data stream is used as the source
  for the delivery stream, a KinesisStreamSourceConfiguration containing the Kinesis data
  stream Amazon Resource Name (ARN) and the role ARN for the source stream.
- `"MSKSourceConfiguration"`:
- `"RedshiftDestinationConfiguration"`: The destination in Amazon Redshift. You can specify
  only one destination.
- `"S3DestinationConfiguration"`: [Deprecated] The destination in Amazon S3. You can
  specify only one destination.
- `"SnowflakeDestinationConfiguration"`: Configure Snowflake destination
- `"SplunkDestinationConfiguration"`: The destination in Splunk. You can specify only one
  destination.
- `"Tags"`: A set of tags to assign to the delivery stream. A tag is a key-value pair that
  you can define and assign to Amazon Web Services resources. Tags are metadata. For example,
  you can add friendly names and descriptions or other types of information that can help you
  distinguish the delivery stream. For more information about tags, see Using Cost Allocation
  Tags in the Amazon Web Services Billing and Cost Management User Guide. You can specify up
  to 50 tags when creating a delivery stream. If you specify tags in the CreateDeliveryStream
  action, Amazon Data Firehose performs an additional authorization on the
  firehose:TagDeliveryStream action to verify if users have permissions to create tags. If
  you do not provide this permission, requests to create new Firehose delivery streams with
  IAM resource tags will fail with an AccessDeniedException such as following.
  AccessDeniedException  User: arn:aws:sts::x:assumed-role/x/x is not authorized to perform:
  firehose:TagDeliveryStream on resource: arn:aws:firehose:us-east-1:x:deliverystream/x with
  an explicit deny in an identity-based policy. For an example IAM policy, see Tag example.
"""
function create_delivery_stream(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "CreateDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_delivery_stream(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "CreateDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_delivery_stream(delivery_stream_name)
    delete_delivery_stream(delivery_stream_name, params::Dict{String,<:Any})

Deletes a delivery stream and its data. You can delete a delivery stream only if it is in
one of the following states: ACTIVE, DELETING, CREATING_FAILED, or DELETING_FAILED. You
can't delete a delivery stream that is in the CREATING state. To check the state of a
delivery stream, use DescribeDeliveryStream.  DeleteDeliveryStream is an asynchronous API.
When an API request to DeleteDeliveryStream succeeds, the delivery stream is marked for
deletion, and it goes into the DELETING state.While the delivery stream is in the DELETING
state, the service might continue to accept records, but it doesn't make any guarantees
with respect to delivering the data. Therefore, as a best practice, first stop any
applications that are sending records before you delete a delivery stream. Removal of a
delivery stream that is in the DELETING state is a low priority operation for the service.
A stream may remain in the DELETING state for several minutes. Therefore, as a best
practice, applications should not wait for streams in the DELETING state to be removed.

# Arguments
- `delivery_stream_name`: The name of the delivery stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowForceDelete"`: Set this to true if you want to delete the delivery stream even if
  Firehose is unable to retire the grant for the CMK. Firehose might be unable to retire the
  grant due to a customer error, such as when the CMK or the grant are in an invalid state.
  If you force deletion, you can then use the RevokeGrant operation to revoke the grant you
  gave to Firehose. If a failure to retire the grant happens due to an Amazon Web Services
  KMS issue, Firehose keeps retrying the delete operation. The default value is false.
"""
function delete_delivery_stream(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "DeleteDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_delivery_stream(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "DeleteDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_delivery_stream(delivery_stream_name)
    describe_delivery_stream(delivery_stream_name, params::Dict{String,<:Any})

Describes the specified delivery stream and its status. For example, after your delivery
stream is created, call DescribeDeliveryStream to see whether the delivery stream is ACTIVE
and therefore ready for data to be sent to it.  If the status of a delivery stream is
CREATING_FAILED, this status doesn't change, and you can't invoke CreateDeliveryStream
again on it. However, you can invoke the DeleteDeliveryStream operation to delete it. If
the status is DELETING_FAILED, you can force deletion by invoking DeleteDeliveryStream
again but with DeleteDeliveryStreamInputAllowForceDelete set to true.

# Arguments
- `delivery_stream_name`: The name of the delivery stream.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartDestinationId"`: The ID of the destination to start returning the
  destination information. Firehose supports one destination per delivery stream.
- `"Limit"`: The limit on the number of destinations to return. You can have one
  destination per delivery stream.
"""
function describe_delivery_stream(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "DescribeDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_delivery_stream(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "DescribeDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_delivery_streams()
    list_delivery_streams(params::Dict{String,<:Any})

Lists your delivery streams in alphabetical order of their names. The number of delivery
streams might be too large to return using a single call to ListDeliveryStreams. You can
limit the number of delivery streams returned, using the Limit parameter. To determine
whether there are more delivery streams to list, check the value of HasMoreDeliveryStreams
in the output. If there are more delivery streams to list, you can request them by calling
this operation again and setting the ExclusiveStartDeliveryStreamName parameter to the name
of the last delivery stream returned in the last call.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryStreamType"`: The delivery stream type. This can be one of the following
  values:    DirectPut: Provider applications access the delivery stream directly.
  KinesisStreamAsSource: The delivery stream uses a Kinesis data stream as a source.   This
  parameter is optional. If this parameter is omitted, delivery streams of all types are
  returned.
- `"ExclusiveStartDeliveryStreamName"`: The list of delivery streams returned by this call
  to ListDeliveryStreams will start with the delivery stream whose name comes alphabetically
  immediately after the name you specify in ExclusiveStartDeliveryStreamName.
- `"Limit"`: The maximum number of delivery streams to list. The default value is 10.
"""
function list_delivery_streams(; aws_config::AbstractAWSConfig=current_aws_config())
    return firehose(
        "ListDeliveryStreams"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_delivery_streams(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "ListDeliveryStreams",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_delivery_stream(delivery_stream_name)
    list_tags_for_delivery_stream(delivery_stream_name, params::Dict{String,<:Any})

Lists the tags for the specified delivery stream. This operation has a limit of five
transactions per second per account.

# Arguments
- `delivery_stream_name`: The name of the delivery stream whose tags you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExclusiveStartTagKey"`: The key to use as the starting point for the list of tags. If
  you set this parameter, ListTagsForDeliveryStream gets all tags that occur after
  ExclusiveStartTagKey.
- `"Limit"`: The number of tags to return. If this number is less than the total number of
  tags associated with the delivery stream, HasMoreTags is set to true in the response. To
  list additional tags, set ExclusiveStartTagKey to the last key in the response.
"""
function list_tags_for_delivery_stream(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "ListTagsForDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_delivery_stream(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "ListTagsForDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_record(delivery_stream_name, record)
    put_record(delivery_stream_name, record, params::Dict{String,<:Any})

Writes a single data record into an Amazon Firehose delivery stream. To write multiple data
records into a delivery stream, use PutRecordBatch. Applications using these operations are
referred to as producers. By default, each delivery stream can take in up to 2,000
transactions per second, 5,000 records per second, or 5 MB per second. If you use PutRecord
and PutRecordBatch, the limits are an aggregate across these two operations for each
delivery stream. For more information about limits and how to request an increase, see
Amazon Firehose Limits.  Firehose accumulates and publishes a particular metric for a
customer account in one minute intervals. It is possible that the bursts of incoming
bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the
actual spikes in the traffic might not be fully visible in the customer's 1 minute
CloudWatch metrics. You must specify the name of the delivery stream and the data record
when using PutRecord. The data record consists of a data blob that can be up to 1,000 KiB
in size, and any kind of data. For example, it can be a segment from a log file, geographic
location data, website clickstream data, and so on. Firehose buffers records before
delivering them to the destination. To disambiguate the data blobs at the destination, a
common solution is to use delimiters in the data, such as a newline (n) or some other
character unique within the data. This allows the consumer application to parse individual
data items when reading the data from the destination. The PutRecord operation returns a
RecordId, which is a unique string assigned to each record. Producer applications can use
this ID for purposes such as auditability and investigation. If the PutRecord operation
throws a ServiceUnavailableException, the API is automatically reinvoked (retried) 3 times.
If the exception persists, it is possible that the throughput limits have been exceeded for
the delivery stream.  Re-invoking the Put API operations (for example, PutRecord and
PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer
time out before retrying Put API operations. Data records sent to Firehose are stored for
24 hours from the time they are added to a delivery stream as it tries to send the records
to the destination. If the destination is unreachable for more than 24 hours, the data is
no longer available.  Don't concatenate two or more base64 strings to form the data fields
of your records. Instead, concatenate the raw data, then perform base64 encoding.

# Arguments
- `delivery_stream_name`: The name of the delivery stream.
- `record`: The record.

"""
function put_record(
    DeliveryStreamName, Record; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "PutRecord",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName, "Record" => Record);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_record(
    DeliveryStreamName,
    Record,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "PutRecord",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeliveryStreamName" => DeliveryStreamName, "Record" => Record
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_record_batch(delivery_stream_name, records)
    put_record_batch(delivery_stream_name, records, params::Dict{String,<:Any})

Writes multiple data records into a delivery stream in a single call, which can achieve
higher throughput per producer than when writing single records. To write single data
records into a delivery stream, use PutRecord. Applications using these operations are
referred to as producers. Firehose accumulates and publishes a particular metric for a
customer account in one minute intervals. It is possible that the bursts of incoming
bytes/records ingested to a delivery stream last only for a few seconds. Due to this, the
actual spikes in the traffic might not be fully visible in the customer's 1 minute
CloudWatch metrics. For information about service quota, see Amazon Firehose Quota. Each
PutRecordBatch request supports up to 500 records. Each record in the request can be as
large as 1,000 KB (before base64 encoding), up to a limit of 4 MB for the entire request.
These limits cannot be changed. You must specify the name of the delivery stream and the
data record when using PutRecord. The data record consists of a data blob that can be up to
1,000 KB in size, and any kind of data. For example, it could be a segment from a log file,
geographic location data, website clickstream data, and so on. Firehose buffers records
before delivering them to the destination. To disambiguate the data blobs at the
destination, a common solution is to use delimiters in the data, such as a newline (n) or
some other character unique within the data. This allows the consumer application to parse
individual data items when reading the data from the destination. The PutRecordBatch
response includes a count of failed records, FailedPutCount, and an array of responses,
RequestResponses. Even if the PutRecordBatch call succeeds, the value of FailedPutCount may
be greater than 0, indicating that there are records for which the operation didn't
succeed. Each entry in the RequestResponses array provides additional information about the
processed record. It directly correlates with a record in the request array using the same
ordering, from the top to the bottom. The response array always includes the same number of
records as the request array. RequestResponses includes both successfully and
unsuccessfully processed records. Firehose tries to process all records in each
PutRecordBatch request. A single record failure does not stop the processing of subsequent
records.  A successfully processed record includes a RecordId value, which is unique for
the record. An unsuccessfully processed record includes ErrorCode and ErrorMessage values.
ErrorCode reflects the type of error, and is one of the following values:
ServiceUnavailableException or InternalFailure. ErrorMessage provides more detailed
information about the error. If there is an internal server error or a timeout, the write
might have completed or it might have failed. If FailedPutCount is greater than 0, retry
the request, resending only those records that might have failed processing. This minimizes
the possible duplicate records and also reduces the total bytes sent (and corresponding
charges). We recommend that you handle any duplicates at the destination. If PutRecordBatch
throws ServiceUnavailableException, the API is automatically reinvoked (retried) 3 times.
If the exception persists, it is possible that the throughput limits have been exceeded for
the delivery stream. Re-invoking the Put API operations (for example, PutRecord and
PutRecordBatch) can result in data duplicates. For larger data assets, allow for a longer
time out before retrying Put API operations. Data records sent to Firehose are stored for
24 hours from the time they are added to a delivery stream as it attempts to send the
records to the destination. If the destination is unreachable for more than 24 hours, the
data is no longer available.  Don't concatenate two or more base64 strings to form the data
fields of your records. Instead, concatenate the raw data, then perform base64 encoding.

# Arguments
- `delivery_stream_name`: The name of the delivery stream.
- `records`: One or more records.

"""
function put_record_batch(
    DeliveryStreamName, Records; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "PutRecordBatch",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName, "Records" => Records);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_record_batch(
    DeliveryStreamName,
    Records,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "PutRecordBatch",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeliveryStreamName" => DeliveryStreamName, "Records" => Records
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_delivery_stream_encryption(delivery_stream_name)
    start_delivery_stream_encryption(delivery_stream_name, params::Dict{String,<:Any})

Enables server-side encryption (SSE) for the delivery stream.  This operation is
asynchronous. It returns immediately. When you invoke it, Firehose first sets the
encryption status of the stream to ENABLING, and then to ENABLED. The encryption status of
a delivery stream is the Status property in DeliveryStreamEncryptionConfiguration. If the
operation fails, the encryption status changes to ENABLING_FAILED. You can continue to read
and write data to your delivery stream while the encryption status is ENABLING, but the
data is not encrypted. It can take up to 5 seconds after the encryption status changes to
ENABLED before all records written to the delivery stream are encrypted. To find out
whether a record or a batch of records was encrypted, check the response elements
PutRecordOutputEncrypted and PutRecordBatchOutputEncrypted, respectively. To check the
encryption status of a delivery stream, use DescribeDeliveryStream. Even if encryption is
currently enabled for a delivery stream, you can still invoke this operation on it to
change the ARN of the CMK or both its type and ARN. If you invoke this method to change the
CMK, and the old CMK is of type CUSTOMER_MANAGED_CMK, Firehose schedules the grant it had
on the old CMK for retirement. If the new CMK is of type CUSTOMER_MANAGED_CMK, Firehose
creates a grant that enables it to use the new CMK to encrypt and decrypt data and to
manage the grant. For the KMS grant creation to be successful, the Firehose API operations
StartDeliveryStreamEncryption and CreateDeliveryStream should not be called with session
credentials that are more than 6 hours old. If a delivery stream already has encryption
enabled and then you invoke this operation to change the ARN of the CMK or both its type
and ARN and you get ENABLING_FAILED, this only means that the attempt to change the CMK
failed. In this case, encryption remains enabled with the old CMK. If the encryption status
of your delivery stream is ENABLING_FAILED, you can invoke this operation again with a
valid CMK. The CMK must be enabled and the key policy mustn't explicitly deny the
permission for Firehose to invoke KMS encrypt and decrypt operations. You can enable SSE
for a delivery stream only if it's a delivery stream that uses DirectPut as its source.
The StartDeliveryStreamEncryption and StopDeliveryStreamEncryption operations have a
combined limit of 25 calls per delivery stream per 24 hours. For example, you reach the
limit if you call StartDeliveryStreamEncryption 13 times and StopDeliveryStreamEncryption
12 times for the same delivery stream in a 24-hour period.

# Arguments
- `delivery_stream_name`: The name of the delivery stream for which you want to enable
  server-side encryption (SSE).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeliveryStreamEncryptionConfigurationInput"`: Used to specify the type and Amazon
  Resource Name (ARN) of the KMS key needed for Server-Side Encryption (SSE).
"""
function start_delivery_stream_encryption(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "StartDeliveryStreamEncryption",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_delivery_stream_encryption(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "StartDeliveryStreamEncryption",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_delivery_stream_encryption(delivery_stream_name)
    stop_delivery_stream_encryption(delivery_stream_name, params::Dict{String,<:Any})

Disables server-side encryption (SSE) for the delivery stream.  This operation is
asynchronous. It returns immediately. When you invoke it, Firehose first sets the
encryption status of the stream to DISABLING, and then to DISABLED. You can continue to
read and write data to your stream while its status is DISABLING. It can take up to 5
seconds after the encryption status changes to DISABLED before all records written to the
delivery stream are no longer subject to encryption. To find out whether a record or a
batch of records was encrypted, check the response elements PutRecordOutputEncrypted and
PutRecordBatchOutputEncrypted, respectively. To check the encryption state of a delivery
stream, use DescribeDeliveryStream.  If SSE is enabled using a customer managed CMK and
then you invoke StopDeliveryStreamEncryption, Firehose schedules the related KMS grant for
retirement and then retires it after it ensures that it is finished delivering records to
the destination. The StartDeliveryStreamEncryption and StopDeliveryStreamEncryption
operations have a combined limit of 25 calls per delivery stream per 24 hours. For example,
you reach the limit if you call StartDeliveryStreamEncryption 13 times and
StopDeliveryStreamEncryption 12 times for the same delivery stream in a 24-hour period.

# Arguments
- `delivery_stream_name`: The name of the delivery stream for which you want to disable
  server-side encryption (SSE).

"""
function stop_delivery_stream_encryption(
    DeliveryStreamName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "StopDeliveryStreamEncryption",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_delivery_stream_encryption(
    DeliveryStreamName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "StopDeliveryStreamEncryption",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_delivery_stream(delivery_stream_name, tags)
    tag_delivery_stream(delivery_stream_name, tags, params::Dict{String,<:Any})

Adds or updates tags for the specified delivery stream. A tag is a key-value pair that you
can define and assign to Amazon Web Services resources. If you specify a tag that already
exists, the tag value is replaced with the value that you specify in the request. Tags are
metadata. For example, you can add friendly names and descriptions or other types of
information that can help you distinguish the delivery stream. For more information about
tags, see Using Cost Allocation Tags in the Amazon Web Services Billing and Cost Management
User Guide.  Each delivery stream can have up to 50 tags.  This operation has a limit of
five transactions per second per account.

# Arguments
- `delivery_stream_name`: The name of the delivery stream to which you want to add the tags.
- `tags`: A set of key-value pairs to use to create the tags.

"""
function tag_delivery_stream(
    DeliveryStreamName, Tags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "TagDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName, "Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_delivery_stream(
    DeliveryStreamName,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "TagDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeliveryStreamName" => DeliveryStreamName, "Tags" => Tags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_delivery_stream(delivery_stream_name, tag_keys)
    untag_delivery_stream(delivery_stream_name, tag_keys, params::Dict{String,<:Any})

Removes tags from the specified delivery stream. Removed tags are deleted, and you can't
recover them after this operation successfully completes. If you specify a tag that doesn't
exist, the operation ignores it. This operation has a limit of five transactions per second
per account.

# Arguments
- `delivery_stream_name`: The name of the delivery stream.
- `tag_keys`: A list of tag keys. Each corresponding tag is removed from the delivery
  stream.

"""
function untag_delivery_stream(
    DeliveryStreamName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return firehose(
        "UntagDeliveryStream",
        Dict{String,Any}("DeliveryStreamName" => DeliveryStreamName, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_delivery_stream(
    DeliveryStreamName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "UntagDeliveryStream",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeliveryStreamName" => DeliveryStreamName, "TagKeys" => TagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_destination(current_delivery_stream_version_id, delivery_stream_name, destination_id)
    update_destination(current_delivery_stream_version_id, delivery_stream_name, destination_id, params::Dict{String,<:Any})

Updates the specified destination of the specified delivery stream. Use this operation to
change the destination type (for example, to replace the Amazon S3 destination with Amazon
Redshift) or change the parameters associated with a destination (for example, to change
the bucket name of the Amazon S3 destination). The update might not occur immediately. The
target delivery stream remains active while the configurations are updated, so data writes
to the delivery stream can continue during this process. The updated configurations are
usually effective within a few minutes. Switching between Amazon OpenSearch Service and
other services is not supported. For an Amazon OpenSearch Service destination, you can only
update to another Amazon OpenSearch Service destination. If the destination type is the
same, Firehose merges the configuration parameters specified with the destination
configuration that already exists on the delivery stream. If any of the parameters are not
specified in the call, the existing values are retained. For example, in the Amazon S3
destination, if EncryptionConfiguration is not specified, then the existing
EncryptionConfiguration is maintained on the destination. If the destination type is not
the same, for example, changing the destination from Amazon S3 to Amazon Redshift, Firehose
does not merge any parameters. In this case, all parameters must be specified. Firehose
uses CurrentDeliveryStreamVersionId to avoid race conditions and conflicting merges. This
is a required field, and the service updates the configuration only if the existing
configuration has a version ID that matches. After the update is applied successfully, the
version ID is updated, and can be retrieved using DescribeDeliveryStream. Use the new
version ID to set CurrentDeliveryStreamVersionId in the next call.

# Arguments
- `current_delivery_stream_version_id`: Obtain this value from the VersionId result of
  DeliveryStreamDescription. This value is required, and helps the service perform
  conditional operations. For example, if there is an interleaving update and this value is
  null, then the update destination fails. After the update is successful, the VersionId
  value is updated. The service then performs a merge of the old configuration with the new
  configuration.
- `delivery_stream_name`: The name of the delivery stream.
- `destination_id`: The ID of the destination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AmazonOpenSearchServerlessDestinationUpdate"`: Describes an update for a destination in
  the Serverless offering for Amazon OpenSearch Service.
- `"AmazonopensearchserviceDestinationUpdate"`: Describes an update for a destination in
  Amazon OpenSearch Service.
- `"ElasticsearchDestinationUpdate"`: Describes an update for a destination in Amazon ES.
- `"ExtendedS3DestinationUpdate"`: Describes an update for a destination in Amazon S3.
- `"HttpEndpointDestinationUpdate"`: Describes an update to the specified HTTP endpoint
  destination.
- `"RedshiftDestinationUpdate"`: Describes an update for a destination in Amazon Redshift.
- `"S3DestinationUpdate"`: [Deprecated] Describes an update for a destination in Amazon S3.
- `"SnowflakeDestinationUpdate"`: Update to the Snowflake destination configuration
  settings.
- `"SplunkDestinationUpdate"`: Describes an update for a destination in Splunk.
"""
function update_destination(
    CurrentDeliveryStreamVersionId,
    DeliveryStreamName,
    DestinationId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "UpdateDestination",
        Dict{String,Any}(
            "CurrentDeliveryStreamVersionId" => CurrentDeliveryStreamVersionId,
            "DeliveryStreamName" => DeliveryStreamName,
            "DestinationId" => DestinationId,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_destination(
    CurrentDeliveryStreamVersionId,
    DeliveryStreamName,
    DestinationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return firehose(
        "UpdateDestination",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CurrentDeliveryStreamVersionId" => CurrentDeliveryStreamVersionId,
                    "DeliveryStreamName" => DeliveryStreamName,
                    "DestinationId" => DestinationId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
