# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: greengrassv2
using AWS.Compat
using AWS.UUIDs

"""
    associate_service_role_to_account(role_arn)
    associate_service_role_to_account(role_arn, params::Dict{String,<:Any})

Associates a Greengrass service role with IoT Greengrass for your Amazon Web Services
account in this Amazon Web Services Region. IoT Greengrass uses this role to verify the
identity of client devices and manage core device connectivity information. The role must
include the AWSGreengrassResourceAccessRolePolicy managed policy or a custom policy that
defines equivalent permissions for the IoT Greengrass features that you use. For more
information, see Greengrass service role in the IoT Greengrass Version 2 Developer Guide.

# Arguments
- `role_arn`: The Amazon Resource Name (ARN) of the service role to associate with IoT
  Greengrass for your Amazon Web Services account in this Amazon Web Services Region.

"""
function associate_service_role_to_account(
    RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "PUT",
        "/greengrass/servicerole",
        Dict{String,Any}("RoleArn" => RoleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_service_role_to_account(
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "PUT",
        "/greengrass/servicerole",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("RoleArn" => RoleArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_associate_client_device_with_core_device(core_device_thing_name)
    batch_associate_client_device_with_core_device(core_device_thing_name, params::Dict{String,<:Any})

Associates a list of client devices with a core device. Use this API operation to specify
which client devices can discover a core device through cloud discovery. With cloud
discovery, client devices connect to IoT Greengrass to retrieve associated core devices'
connectivity information and certificates. For more information, see Configure cloud
discovery in the IoT Greengrass V2 Developer Guide.  Client devices are local IoT devices
that connect to and communicate with an IoT Greengrass core device over MQTT. You can
connect client devices to a core device to sync MQTT messages and data to Amazon Web
Services IoT Core and interact with client devices in Greengrass components. For more
information, see Interact with local IoT devices in the IoT Greengrass V2 Developer Guide.

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"entries"`: The list of client devices to associate.
"""
function batch_associate_client_device_with_core_device(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/associateClientDevices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_associate_client_device_with_core_device(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/associateClientDevices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    batch_disassociate_client_device_from_core_device(core_device_thing_name)
    batch_disassociate_client_device_from_core_device(core_device_thing_name, params::Dict{String,<:Any})

Disassociates a list of client devices from a core device. After you disassociate a client
device from a core device, the client device won't be able to use cloud discovery to
retrieve the core device's connectivity information and certificates.

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"entries"`: The list of client devices to disassociate.
"""
function batch_disassociate_client_device_from_core_device(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/disassociateClientDevices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function batch_disassociate_client_device_from_core_device(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/disassociateClientDevices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_deployment(deployment_id)
    cancel_deployment(deployment_id, params::Dict{String,<:Any})

Cancels a deployment. This operation cancels the deployment for devices that haven't yet
received it. If a device already received the deployment, this operation doesn't change
anything for that device.

# Arguments
- `deployment_id`: The ID of the deployment.

"""
function cancel_deployment(deploymentId; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "POST",
        "/greengrass/v2/deployments/$(deploymentId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_deployment(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/deployments/$(deploymentId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_component_version()
    create_component_version(params::Dict{String,<:Any})

Creates a component. Components are software that run on Greengrass core devices. After you
develop and test a component on your core device, you can use this operation to upload your
component to IoT Greengrass. Then, you can deploy the component to other core devices. You
can use this operation to do the following:    Create components from recipes  Create a
component from a recipe, which is a file that defines the component's metadata, parameters,
dependencies, lifecycle, artifacts, and platform capability. For more information, see IoT
Greengrass component recipe reference in the IoT Greengrass V2 Developer Guide. To create a
component from a recipe, specify inlineRecipe when you call this operation.    Create
components from Lambda functions  Create a component from an Lambda function that runs on
IoT Greengrass. This creates a recipe and artifacts from the Lambda function's deployment
package. You can use this operation to migrate Lambda functions from IoT Greengrass V1 to
IoT Greengrass V2. This function accepts Lambda functions in all supported versions of
Python, Node.js, and Java runtimes. IoT Greengrass doesn't apply any additional
restrictions on deprecated Lambda runtime versions. To create a component from a Lambda
function, specify lambdaFunction when you call this operation.  IoT Greengrass currently
supports Lambda functions on only Linux core devices.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you can provide to ensure that
  the request is idempotent. Idempotency means that the request is successfully processed
  only once, even if you send the request multiple times. When a request succeeds, and you
  specify the same client token for subsequent successful requests, the IoT Greengrass V2
  service returns the successful response that it caches from the previous request. IoT
  Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
- `"inlineRecipe"`: The recipe to use to create the component. The recipe defines the
  component's metadata, parameters, dependencies, lifecycle, artifacts, and platform
  compatibility. You must specify either inlineRecipe or lambdaFunction.
- `"lambdaFunction"`: The parameters to create a component from a Lambda function. You must
  specify either inlineRecipe or lambdaFunction.
- `"tags"`: A list of key-value pairs that contain metadata for the resource. For more
  information, see Tag your resources in the IoT Greengrass V2 Developer Guide.
"""
function create_component_version(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "POST",
        "/greengrass/v2/createComponentVersion",
        Dict{String,Any}("clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_component_version(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/createComponentVersion",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("clientToken" => string(uuid4())), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_deployment(target_arn)
    create_deployment(target_arn, params::Dict{String,<:Any})

Creates a continuous deployment for a target, which is a Greengrass core device or group of
core devices. When you add a new core device to a group of core devices that has a
deployment, IoT Greengrass deploys that group's deployment to the new device. You can
define one deployment for each target. When you create a new deployment for a target that
has an existing deployment, you replace the previous deployment. IoT Greengrass applies the
new deployment to the target devices. Every deployment has a revision number that indicates
how many deployment revisions you define for a target. Use this operation to create a new
revision of an existing deployment. For more information, see the Create deployments in the
IoT Greengrass V2 Developer Guide.

# Arguments
- `target_arn`: The ARN of the target IoT thing or thing group. When creating a
  subdeployment, the targetARN can only be a thing group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"clientToken"`: A unique, case-sensitive identifier that you can provide to ensure that
  the request is idempotent. Idempotency means that the request is successfully processed
  only once, even if you send the request multiple times. When a request succeeds, and you
  specify the same client token for subsequent successful requests, the IoT Greengrass V2
  service returns the successful response that it caches from the previous request. IoT
  Greengrass V2 caches successful responses for idempotent requests for up to 8 hours.
- `"components"`: The components to deploy. This is a dictionary, where each key is the
  name of a component, and each key's value is the version and configuration to deploy for
  that component.
- `"deploymentName"`: The name of the deployment.
- `"deploymentPolicies"`: The deployment policies for the deployment. These policies define
  how the deployment updates components and handles failure.
- `"iotJobConfiguration"`: The job configuration for the deployment configuration. The job
  configuration specifies the rollout, timeout, and stop configurations for the deployment
  configuration.
- `"parentTargetArn"`: The parent deployment's target ARN within a subdeployment.
- `"tags"`: A list of key-value pairs that contain metadata for the resource. For more
  information, see Tag your resources in the IoT Greengrass V2 Developer Guide.
"""
function create_deployment(targetArn; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "POST",
        "/greengrass/v2/deployments",
        Dict{String,Any}("targetArn" => targetArn, "clientToken" => string(uuid4()));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_deployment(
    targetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/deployments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "targetArn" => targetArn, "clientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_component(arn)
    delete_component(arn, params::Dict{String,<:Any})

Deletes a version of a component from IoT Greengrass.  This operation deletes the
component's recipe and artifacts. As a result, deployments that refer to this component
version will fail. If you have deployments that use this component version, you can remove
the component from the deployment or update the deployment to use a valid version.

# Arguments
- `arn`: The ARN of the component version.

"""
function delete_component(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/components/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_component(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/components/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_core_device(core_device_thing_name)
    delete_core_device(core_device_thing_name, params::Dict{String,<:Any})

Deletes a Greengrass core device, which is an IoT thing. This operation removes the core
device from the list of core devices. This operation doesn't delete the IoT thing. For more
information about how to delete the IoT thing, see DeleteThing in the IoT API Reference.

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

"""
function delete_core_device(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_core_device(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_deployment(deployment_id)
    delete_deployment(deployment_id, params::Dict{String,<:Any})

Deletes a deployment. To delete an active deployment, you must first cancel it. For more
information, see CancelDeployment. Deleting a deployment doesn't affect core devices that
run that deployment, because core devices store the deployment's configuration on the
device. Additionally, core devices can roll back to a previous deployment that has been
deleted.

# Arguments
- `deployment_id`: The ID of the deployment.

"""
function delete_deployment(deploymentId; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/deployments/$(deploymentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_deployment(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "DELETE",
        "/greengrass/v2/deployments/$(deploymentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_component(arn)
    describe_component(arn, params::Dict{String,<:Any})

Retrieves metadata for a version of a component.

# Arguments
- `arn`: The ARN of the component version.

"""
function describe_component(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/metadata";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_component(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/metadata",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_service_role_from_account()
    disassociate_service_role_from_account(params::Dict{String,<:Any})

Disassociates the Greengrass service role from IoT Greengrass for your Amazon Web Services
account in this Amazon Web Services Region. Without a service role, IoT Greengrass can't
verify the identity of client devices or manage core device connectivity information. For
more information, see Greengrass service role in the IoT Greengrass Version 2 Developer
Guide.

"""
function disassociate_service_role_from_account(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "DELETE",
        "/greengrass/servicerole";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_service_role_from_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "DELETE",
        "/greengrass/servicerole",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_component(arn)
    get_component(arn, params::Dict{String,<:Any})

Gets the recipe for a version of a component.

# Arguments
- `arn`: The ARN of the component version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"recipeOutputFormat"`: The format of the recipe.
"""
function get_component(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_component(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_component_version_artifact(arn, artifact_name)
    get_component_version_artifact(arn, artifact_name, params::Dict{String,<:Any})

Gets the pre-signed URL to download a public or a Lambda component artifact. Core devices
call this operation to identify the URL that they can use to download an artifact to
install.

# Arguments
- `arn`: The ARN of the component version. Specify the ARN of a public or a Lambda
  component version.
- `artifact_name`: The name of the artifact. You can use the GetComponent operation to
  download the component recipe, which includes the URI of the artifact. The artifact name is
  the section of the URI after the scheme. For example, in the artifact URI
  greengrass:SomeArtifact.zip, the artifact name is SomeArtifact.zip.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"s3EndpointType"`: Specifies the endpoint to use when getting Amazon S3 pre-signed URLs.
  All Amazon Web Services Regions except US East (N. Virginia) use REGIONAL in all cases. In
  the US East (N. Virginia) Region the default is GLOBAL, but you can change it to REGIONAL
  with this parameter.
- `"x-amz-iot-endpoint-type"`: Determines if the Amazon S3 URL returned is a FIPS
  pre-signed URL endpoint. Specify fips if you want the returned Amazon S3 pre-signed URL to
  point to an Amazon S3 FIPS endpoint. If you don't specify a value, the default is standard.
"""
function get_component_version_artifact(
    arn, artifactName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/artifacts/$(artifactName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_component_version_artifact(
    arn,
    artifactName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/artifacts/$(artifactName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connectivity_info(thing_name)
    get_connectivity_info(thing_name, params::Dict{String,<:Any})

Retrieves connectivity information for a Greengrass core device. Connectivity information
includes endpoints and ports where client devices can connect to an MQTT broker on the core
device. When a client device calls the IoT Greengrass discovery API, IoT Greengrass returns
connectivity information for all of the core devices where the client device can connect.
For more information, see Connect client devices to core devices in the IoT Greengrass
Version 2 Developer Guide.

# Arguments
- `thing_name`: The name of the core device. This is also the name of the IoT thing.

"""
function get_connectivity_info(
    thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/things/$(thingName)/connectivityInfo";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connectivity_info(
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/things/$(thingName)/connectivityInfo",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_core_device(core_device_thing_name)
    get_core_device(core_device_thing_name, params::Dict{String,<:Any})

Retrieves metadata for a Greengrass core device.  IoT Greengrass relies on individual
devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core
software isn't running on the device, or if device isn't connected to the Amazon Web
Services Cloud, then the reported status of that device might not reflect its current
status. The status timestamp indicates when the device status was last updated. Core
devices send status updates at the following times:   When the IoT Greengrass Core software
starts   When the core device receives a deployment from the Amazon Web Services Cloud
When the status of any component on the core device becomes BROKEN    At a regular interval
that you can configure, which defaults to 24 hours   For IoT Greengrass Core v2.7.0, the
core device sends status updates upon local deployment and cloud deployment

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

"""
function get_core_device(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_core_device(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_deployment(deployment_id)
    get_deployment(deployment_id, params::Dict{String,<:Any})

Gets a deployment. Deployments define the components that run on Greengrass core devices.

# Arguments
- `deployment_id`: The ID of the deployment.

"""
function get_deployment(deploymentId; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/deployments/$(deploymentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_deployment(
    deploymentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/deployments/$(deploymentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_service_role_for_account()
    get_service_role_for_account(params::Dict{String,<:Any})

Gets the service role associated with IoT Greengrass for your Amazon Web Services account
in this Amazon Web Services Region. IoT Greengrass uses this role to verify the identity of
client devices and manage core device connectivity information. For more information, see
Greengrass service role in the IoT Greengrass Version 2 Developer Guide.

"""
function get_service_role_for_account(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/servicerole";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_service_role_for_account(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/servicerole",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_client_devices_associated_with_core_device(core_device_thing_name)
    list_client_devices_associated_with_core_device(core_device_thing_name, params::Dict{String,<:Any})

Retrieves a paginated list of client devices that are associated with a core device.

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
"""
function list_client_devices_associated_with_core_device(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/associatedClientDevices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_client_devices_associated_with_core_device(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/associatedClientDevices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_component_versions(arn)
    list_component_versions(arn, params::Dict{String,<:Any})

Retrieves a paginated list of all versions for a component. Greater versions are listed
first.

# Arguments
- `arn`: The ARN of the component.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
"""
function list_component_versions(arn; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_component_versions(
    arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components/$(arn)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_components()
    list_components(params::Dict{String,<:Any})

Retrieves a paginated list of component summaries. This list includes components that you
have permission to view.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
- `"scope"`: The scope of the components to list. Default: PRIVATE
"""
function list_components(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/components";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_components(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/components",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_core_devices()
    list_core_devices(params::Dict{String,<:Any})

Retrieves a paginated list of Greengrass core devices.  IoT Greengrass relies on individual
devices to send status updates to the Amazon Web Services Cloud. If the IoT Greengrass Core
software isn't running on the device, or if device isn't connected to the Amazon Web
Services Cloud, then the reported status of that device might not reflect its current
status. The status timestamp indicates when the device status was last updated. Core
devices send status updates at the following times:   When the IoT Greengrass Core software
starts   When the core device receives a deployment from the Amazon Web Services Cloud
When the status of any component on the core device becomes BROKEN    At a regular interval
that you can configure, which defaults to 24 hours   For IoT Greengrass Core v2.7.0, the
core device sends status updates upon local deployment and cloud deployment

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
- `"status"`: The core device status by which to filter. If you specify this parameter, the
  list includes only core devices that have this status. Choose one of the following options:
     HEALTHY – The IoT Greengrass Core software and all components run on the core device
  without issue.    UNHEALTHY – The IoT Greengrass Core software or a component is in a
  failed state on the core device.
- `"thingGroupArn"`: The ARN of the IoT thing group by which to filter. If you specify this
  parameter, the list includes only core devices that have successfully deployed a deployment
  that targets the thing group. When you remove a core device from a thing group, the list
  continues to include that core device.
"""
function list_core_devices(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_core_devices(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_deployments()
    list_deployments(params::Dict{String,<:Any})

Retrieves a paginated list of deployments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"historyFilter"`: The filter for the list of deployments. Choose one of the following
  options:    ALL – The list includes all deployments.    LATEST_ONLY – The list includes
  only the latest revision of each deployment.   Default: LATEST_ONLY
- `"maxResults"`: The maximum number of results to be returned per paginated request.
  Default: 50
- `"nextToken"`: The token to be used for the next set of paginated results.
- `"parentTargetArn"`: The parent deployment's target ARN within a subdeployment.
- `"targetArn"`: The ARN of the target IoT thing or thing group.
"""
function list_deployments(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "GET",
        "/greengrass/v2/deployments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_deployments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/deployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_effective_deployments(core_device_thing_name)
    list_effective_deployments(core_device_thing_name, params::Dict{String,<:Any})

Retrieves a paginated list of deployment jobs that IoT Greengrass sends to Greengrass core
devices.

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
"""
function list_effective_deployments(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/effectiveDeployments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_effective_deployments(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/effectiveDeployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_installed_components(core_device_thing_name)
    list_installed_components(core_device_thing_name, params::Dict{String,<:Any})

Retrieves a paginated list of the components that a Greengrass core device runs. By
default, this list doesn't include components that are deployed as dependencies of other
components. To include dependencies in the response, set the topologyFilter parameter to
ALL.  IoT Greengrass relies on individual devices to send status updates to the Amazon Web
Services Cloud. If the IoT Greengrass Core software isn't running on the device, or if
device isn't connected to the Amazon Web Services Cloud, then the reported status of that
device might not reflect its current status. The status timestamp indicates when the device
status was last updated. Core devices send status updates at the following times:   When
the IoT Greengrass Core software starts   When the core device receives a deployment from
the Amazon Web Services Cloud   When the status of any component on the core device becomes
BROKEN    At a regular interval that you can configure, which defaults to 24 hours   For
IoT Greengrass Core v2.7.0, the core device sends status updates upon local deployment and
cloud deployment

# Arguments
- `core_device_thing_name`: The name of the core device. This is also the name of the IoT
  thing.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to be returned per paginated request.
- `"nextToken"`: The token to be used for the next set of paginated results.
- `"topologyFilter"`: The filter for the list of components. Choose from the following
  options:    ALL – The list includes all components installed on the core device.    ROOT
  – The list includes only root components, which are components that you specify in a
  deployment. When you choose this option, the list doesn't include components that the core
  device installs as dependencies of other components.   Default: ROOT
"""
function list_installed_components(
    coreDeviceThingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/installedComponents";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_installed_components(
    coreDeviceThingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/greengrass/v2/coreDevices/$(coreDeviceThingName)/installedComponents",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Retrieves the list of tags for an IoT Greengrass resource.

# Arguments
- `resource_arn`: The ARN of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    resolve_component_candidates()
    resolve_component_candidates(params::Dict{String,<:Any})

Retrieves a list of components that meet the component, version, and platform requirements
of a deployment. Greengrass core devices call this operation when they receive a deployment
to identify the components to install. This operation identifies components that meet all
dependency requirements for a deployment. If the requirements conflict, then this operation
returns an error and the deployment fails. For example, this occurs if component A requires
version &gt;2.0.0 and component B requires version &lt;2.0.0 of a component dependency.
When you specify the component candidates to resolve, IoT Greengrass compares each
component's digest from the core device with the component's digest in the Amazon Web
Services Cloud. If the digests don't match, then IoT Greengrass specifies to use the
version from the Amazon Web Services Cloud.  To use this operation, you must use the data
plane API endpoint and authenticate with an IoT device certificate. For more information,
see IoT Greengrass endpoints and quotas.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"componentCandidates"`: The list of components to resolve.
- `"platform"`: The platform to use to resolve compatible components.
"""
function resolve_component_candidates(; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "POST",
        "/greengrass/v2/resolveComponentCandidates";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function resolve_component_candidates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "POST",
        "/greengrass/v2/resolveComponentCandidates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Adds tags to an IoT Greengrass resource. If a tag already exists for the resource, this
operation updates the tag's value.

# Arguments
- `resource_arn`: The ARN of the resource to tag.
- `tags`: A list of key-value pairs that contain metadata for the resource. For more
  information, see Tag your resources in the IoT Greengrass V2 Developer Guide.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return greengrassv2(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes a tag from an IoT Greengrass resource.

# Arguments
- `resource_arn`: The ARN of the resource to untag.
- `tag_keys`: A list of keys for tags to remove from the resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connectivity_info(connectivity_info, thing_name)
    update_connectivity_info(connectivity_info, thing_name, params::Dict{String,<:Any})

Updates connectivity information for a Greengrass core device. Connectivity information
includes endpoints and ports where client devices can connect to an MQTT broker on the core
device. When a client device calls the IoT Greengrass discovery API, IoT Greengrass returns
connectivity information for all of the core devices where the client device can connect.
For more information, see Connect client devices to core devices in the IoT Greengrass
Version 2 Developer Guide.

# Arguments
- `connectivity_info`: The connectivity information for the core device.
- `thing_name`: The name of the core device. This is also the name of the IoT thing.

"""
function update_connectivity_info(
    ConnectivityInfo, thingName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return greengrassv2(
        "PUT",
        "/greengrass/things/$(thingName)/connectivityInfo",
        Dict{String,Any}("ConnectivityInfo" => ConnectivityInfo);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connectivity_info(
    ConnectivityInfo,
    thingName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return greengrassv2(
        "PUT",
        "/greengrass/things/$(thingName)/connectivityInfo",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("ConnectivityInfo" => ConnectivityInfo), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
